/*
 * Decompiled with CFR 0.152.
 */
package rebound.bits;

import rebound.annotations.hints.ImplementationTransparency;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.bits.Unsigned;
import rebound.exceptions.OverflowException;
import rebound.math.SmallIntegerMathUtilities;
import rebound.util.objectutil.JavaNamespace;

public class BitUtilities
implements JavaNamespace {
    public static int cmp(boolean a, boolean b) {
        if (a == b) {
            return 0;
        }
        return a ? 1 : -1;
    }

    public static boolean getBit(long value, long bitIndex) {
        if (bitIndex < 0L || bitIndex >= 64L) {
            throw new IllegalArgumentException();
        }
        return (value & (long)(1 << (int)bitIndex)) != 0L;
    }

    public static long setBit(long value, long bitIndex, boolean newBitValue) {
        if (bitIndex < 0L || bitIndex >= 64L) {
            throw new IllegalArgumentException();
        }
        if (newBitValue) {
            return value | (long)(1 << (int)bitIndex);
        }
        return value & (long)(~(1 << (int)bitIndex));
    }

    public static int getHighestOneBit(int v) {
        v = v >>> 1 | v;
        v = v >>> 2 | v;
        v = v >>> 4 | v;
        v = v >>> 8 | v;
        v = v >>> 16 | v;
        v = v >>> 1 ^ v;
        return v;
    }

    public static long getHighestOneBit(long v) {
        v = v >>> 1 | v;
        v = v >>> 2 | v;
        v = v >>> 4 | v;
        v = v >>> 8 | v;
        v = v >>> 16 | v;
        v = v >>> 32 | v;
        v = v >>> 1 ^ v;
        return v;
    }

    @ImplementationTransparency
    public static int _getLowestOneBit_a(int v) {
        v = v << 1 | v;
        v = v << 2 | v;
        v = v << 4 | v;
        v = v << 8 | v;
        v = v << 16 | v;
        v = v << 1 ^ v;
        return v;
    }

    @ImplementationTransparency
    public static long _getLowestOneBit_a(long v) {
        v = v << 1 | v;
        v = v << 2 | v;
        v = v << 4 | v;
        v = v << 8 | v;
        v = v << 16 | v;
        v = v << 32 | v;
        v = v << 1 ^ v;
        return v;
    }

    public static long getLowestOneBit(long v) {
        return v & (v ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
    }

    public static int getLowestOneBit(int v) {
        return v & ~v + 1;
    }

    public static short getLowestOneBit(short v) {
        return (short)(v & ~v + 1);
    }

    public static byte getLowestOneBit(byte v) {
        return (byte)(v & ~v + 1);
    }

    @ImplementationTransparency
    public static long _getHighestOneBit_a(long v) {
        return BitUtilities.reverse(BitUtilities.getLowestOneBit(BitUtilities.reverse(v)));
    }

    public static int dcd32(int v) {
        return v == 0 ? 0 : Integer.numberOfTrailingZeros(v);
    }

    public static int dcd64(long v) {
        return v == 0L ? 0 : Long.numberOfTrailingZeros(v);
    }

    @ImplementationTransparency
    public static int _dcd32_a(int v) {
        int e = 0;
        if ((v & 0xAAAAAAAA) != 0) {
            e |= 1;
        }
        if ((v & 0xCCCCCCCC) != 0) {
            e |= 2;
        }
        if ((v & 0xF0F0F0F0) != 0) {
            e |= 4;
        }
        if ((v & 0xFF00FF00) != 0) {
            e |= 8;
        }
        if ((v & 0xFFFF0000) != 0) {
            e |= 0x10;
        }
        return e;
    }

    @ImplementationTransparency
    public static int _dcd64_a(long v) {
        int e = 0;
        if ((v & 0xAAAAAAAAAAAAAAAAL) != 0L) {
            e |= 1;
        }
        if ((v & 0xCCCCCCCCCCCCCCCCL) != 0L) {
            e |= 2;
        }
        if ((v & 0xF0F0F0F0F0F0F0F0L) != 0L) {
            e |= 4;
        }
        if ((v & 0xFF00FF00FF00FF00L) != 0L) {
            e |= 8;
        }
        if ((v & 0xFFFF0000FFFF0000L) != 0L) {
            e |= 0x10;
        }
        if ((v & 0xFFFFFFFF00000000L) != 0L) {
            e |= 0x20;
        }
        return e;
    }

    @ImplementationTransparency
    public static int _dcd32_b(int v) {
        int e = 0;
        int temp = 0;
        temp = (v & 0xAAAAAAAA) >>> 1;
        e |= 1 * ((temp - 1) / (temp + 1) + 1);
        temp = (v & 0xCCCCCCCC) >>> 1;
        e |= 2 * ((temp - 1) / (temp + 1) + 1);
        temp = (v & 0xF0F0F0F0) >>> 1;
        e |= 4 * ((temp - 1) / (temp + 1) + 1);
        temp = (v & 0xFF00FF00) >>> 1;
        e |= 8 * ((temp - 1) / (temp + 1) + 1);
        temp = (v & 0xFFFF0000) >>> 1;
        return e |= 16 * ((temp - 1) / (temp + 1) + 1);
    }

    @ImplementationTransparency
    public static int _dcd64_b(long v) {
        int e = 0;
        long temp = 0L;
        temp = (v & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        e = (int)((long)e | 1L * ((temp - 1L) / (temp + 1L) + 1L));
        temp = (v & 0xCCCCCCCCCCCCCCCCL) >>> 1;
        e = (int)((long)e | 2L * ((temp - 1L) / (temp + 1L) + 1L));
        temp = (v & 0xF0F0F0F0F0F0F0F0L) >>> 1;
        e = (int)((long)e | 4L * ((temp - 1L) / (temp + 1L) + 1L));
        temp = (v & 0xFF00FF00FF00FF00L) >>> 1;
        e = (int)((long)e | 8L * ((temp - 1L) / (temp + 1L) + 1L));
        temp = (v & 0xFFFF0000FFFF0000L) >>> 1;
        e = (int)((long)e | 16L * ((temp - 1L) / (temp + 1L) + 1L));
        temp = (v & 0xFFFFFFFF00000000L) >>> 1;
        e = (int)((long)e | 32L * ((temp - 1L) / (temp + 1L) + 1L));
        return e;
    }

    public static int getNumberOfOneBits(int v) {
        return Integer.bitCount(v);
    }

    public static int getNumberOfZeroBits(int v) {
        return BitUtilities.getNumberOfOneBits(~v);
    }

    public static int getNumberOfOneBits(long v) {
        return Long.bitCount(v);
    }

    public static int getNumberOfZeroBits(long v) {
        return BitUtilities.getNumberOfOneBits(v ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int getNumberOfContiguousBitsOfAGivenValue(long bitfield, int offset, int maxLength, boolean value) {
        if (offset > 64) {
            throw new IllegalArgumentException();
        }
        if (value) {
            bitfield ^= 0xFFFFFFFFFFFFFFFFL;
        }
        int number = Long.numberOfTrailingZeros(bitfield >>>= offset);
        return Math.min(number, maxLength);
    }

    public static int getNumberOfContiguousBitsOfAGivenValue(int bitfield, int offset, int maxLength, boolean value) {
        if (offset > 32) {
            throw new IllegalArgumentException();
        }
        return BitUtilities.getNumberOfContiguousBitsOfAGivenValue(bitfield, offset, Math.min(maxLength, 32 - offset), value);
    }

    public static int getNumberOfContiguousBitsOfAGivenValue(short bitfield, int offset, int maxLength, boolean value) {
        if (offset > 16) {
            throw new IllegalArgumentException();
        }
        return BitUtilities.getNumberOfContiguousBitsOfAGivenValue(bitfield, offset, Math.min(maxLength, 16 - offset), value);
    }

    public static int getNumberOfContiguousBitsOfAGivenValue(byte bitfield, int offset, int maxLength, boolean value) {
        if (offset > 8) {
            throw new IllegalArgumentException();
        }
        return BitUtilities.getNumberOfContiguousBitsOfAGivenValue(bitfield, offset, Math.min(maxLength, 8 - offset), value);
    }

    public static int getNumberOfContiguousBitsOfAGivenValue(long bitfield, int offset, boolean value) {
        if (offset > 64) {
            throw new IllegalArgumentException();
        }
        return BitUtilities.getNumberOfContiguousBitsOfAGivenValue(bitfield, offset, 64 - offset, value);
    }

    public static int getNumberOfContiguousBitsOfAGivenValue(int bitfield, int offset, boolean value) {
        if (offset > 32) {
            throw new IllegalArgumentException();
        }
        return BitUtilities.getNumberOfContiguousBitsOfAGivenValue(bitfield, offset, 32 - offset, value);
    }

    public static int getNumberOfContiguousBitsOfAGivenValue(short bitfield, int offset, boolean value) {
        if (offset > 16) {
            throw new IllegalArgumentException();
        }
        return BitUtilities.getNumberOfContiguousBitsOfAGivenValue(bitfield, offset, 16 - offset, value);
    }

    public static int getNumberOfContiguousBitsOfAGivenValue(byte bitfield, int offset, boolean value) {
        if (offset > 8) {
            throw new IllegalArgumentException();
        }
        return BitUtilities.getNumberOfContiguousBitsOfAGivenValue(bitfield, offset, 8 - offset, value);
    }

    public static int variadicMoreThanOne(int ... inputs) {
        int accumulator = 0;
        int currentResult = 0;
        int overlap = 0;
        int[] nArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            int input = nArray[n2];
            overlap = accumulator & input;
            currentResult |= overlap;
            accumulator |= input;
            ++n2;
        }
        return currentResult;
    }

    public static int getMask32(int numberOfOneBits) {
        if (numberOfOneBits > 32) {
            throw new IllegalArgumentException("Requested length is greater than a Java int's length (32 bits)! :  " + numberOfOneBits);
        }
        if (numberOfOneBits < 0) {
            throw new IllegalArgumentException("Requested length is either negative if signed or *WAY* greater than a Java int's length (32 bits) if unsigned! :  " + numberOfOneBits);
        }
        return (1 << numberOfOneBits) - 1;
    }

    public static long getMask64(long numberOfOneBits) {
        if (numberOfOneBits > 64L) {
            throw new IllegalArgumentException("Requested length is greater than a Java long's length (64 bits)! :  " + numberOfOneBits);
        }
        if (numberOfOneBits < 0L) {
            throw new IllegalArgumentException("Requested length is either negative if signed or *WAY* greater than a Java long's length (64 bits) if unsigned! :  " + numberOfOneBits);
        }
        return (1L << (int)numberOfOneBits) - 1L;
    }

    public static long reverse64(long value, int bitOffset, int bitLength) {
        long mask = (1 << bitLength) - 1 << bitOffset;
        long rev = Long.reverse(value >>> bitOffset) << bitOffset;
        assert ((rev & mask) == rev);
        return value & (mask ^ 0xFFFFFFFFFFFFFFFFL) | rev;
    }

    public static int reverse32(int value, int bitOffset, int bitLength) {
        int mask = (1 << bitLength) - 1 << bitOffset;
        int rev = Integer.reverse(value >>> bitOffset) << bitOffset;
        assert ((rev & mask) == rev);
        return value & ~mask | rev;
    }

    public static byte reverse(byte value, int bitOffset, int bitLength) {
        return (byte)BitUtilities.reverse32(value, bitOffset, bitLength);
    }

    public static char reverse(char value, int bitOffset, int bitLength) {
        return (char)BitUtilities.reverse32(value, bitOffset, bitLength);
    }

    public static short reverse(short value, int bitOffset, int bitLength) {
        return (short)BitUtilities.reverse32(value, bitOffset, bitLength);
    }

    public static byte reverse(byte value, int bitLength) {
        return BitUtilities.reverse(value, 0, bitLength);
    }

    public static char reverse(char value, int bitLength) {
        return BitUtilities.reverse(value, 0, bitLength);
    }

    public static short reverse(short value, int bitLength) {
        return BitUtilities.reverse(value, 0, bitLength);
    }

    public static int reverse(int value, int bitLength) {
        return BitUtilities.reverse32(value, 0, bitLength);
    }

    public static long reverse(long value, int bitLength) {
        return BitUtilities.reverse64(value, 0, bitLength);
    }

    public static byte reverse(byte value) {
        return BitUtilities.reverse(value, 0, 8);
    }

    public static short reverse(short value) {
        return BitUtilities.reverse(value, 0, 16);
    }

    public static char reverse(char value) {
        return BitUtilities.reverse(value, 0, 16);
    }

    public static int reverse(int value) {
        return Integer.reverse(value);
    }

    public static long reverse(long value) {
        return Long.reverse(value);
    }

    @ImplementationTransparency
    public static int _reverse_arbitraryBitlength(int x) {
        return BitUtilities.reverse32(x, 0, 32);
    }

    @ImplementationTransparency
    public static long _reverse_arbitraryBitlength(long x) {
        return BitUtilities.reverse64(x, 0, 64);
    }

    @ImplementationTransparency
    public static int _reverse_a(int x) {
        x = (x & 0x55555555) << 1 | (x & 0xAAAAAAAA) >>> 1;
        x = (x & 0x33333333) << 2 | (x & 0xCCCCCCCC) >>> 2;
        x = (x & 0xF0F0F0F) << 4 | (x & 0xF0F0F0F0) >>> 4;
        x = (x & 0xFF00FF) << 8 | (x & 0xFF00FF00) >>> 8;
        x = (x & 0xFFFF) << 16 | (x & 0xFFFF0000) >>> 16;
        return x;
    }

    @ImplementationTransparency
    public static long _reverse_a(long x) {
        x = (x & 0x5555555555555555L) << 1 | (x & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        x = (x & 0x3333333333333333L) << 2 | (x & 0xCCCCCCCCCCCCCCCCL) >>> 2;
        x = (x & 0xF0F0F0F0F0F0F0FL) << 4 | (x & 0xF0F0F0F0F0F0F0F0L) >>> 4;
        x = (x & 0xFF00FF00FF00FFL) << 8 | (x & 0xFF00FF00FF00FF00L) >>> 8;
        x = (x & 0xFFFF0000FFFFL) << 16 | (x & 0xFFFF0000FFFF0000L) >>> 16;
        x = (x & 0xFFFFFFFFL) << 32 | (x & 0xFFFFFFFF00000000L) >>> 32;
        return x;
    }

    @ImplementationTransparency
    public static int _reverse_b(int x) {
        x = (x & 0x55555555) << 1 | (x & 0xAAAAAAAA) >>> 1;
        x = (x & 0x33333333) << 2 | (x & 0xCCCCCCCC) >>> 2;
        x = (x & 0xF0F0F0F) << 4 | (x & 0xF0F0F0F0) >>> 4;
        x = (x & 0xFF00FF) << 8 | (x & 0xFF00FF00) >>> 8;
        x = x << 16 | x >>> 16;
        return x;
    }

    @ImplementationTransparency
    public static long _reverse_b(long x) {
        x = (x & 0x5555555555555555L) << 1 | (x & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        x = (x & 0x3333333333333333L) << 2 | (x & 0xCCCCCCCCCCCCCCCCL) >>> 2;
        x = (x & 0xF0F0F0F0F0F0F0FL) << 4 | (x & 0xF0F0F0F0F0F0F0F0L) >>> 4;
        x = (x & 0xFF00FF00FF00FFL) << 8 | (x & 0xFF00FF00FF00FF00L) >>> 8;
        x = (x & 0xFFFF0000FFFFL) << 16 | (x & 0xFFFF0000FFFF0000L) >>> 16;
        x = x << 32 | x >>> 32;
        return x;
    }

    @ImplementationTransparency
    public static int _reverse_c(int i) {
        i = (i & 0x55555555) << 1 | i >>> 1 & 0x55555555;
        i = (i & 0x33333333) << 2 | i >>> 2 & 0x33333333;
        i = (i & 0xF0F0F0F) << 4 | i >>> 4 & 0xF0F0F0F;
        i = i << 24 | (i & 0xFF00) << 8 | i >>> 8 & 0xFF00 | i >>> 24;
        return i;
    }

    @ImplementationTransparency
    public static long _reverse_c(long x) {
        x = (x & 0x5555555555555555L) << 1 | x >>> 1 & 0x5555555555555555L;
        x = (x & 0x3333333333333333L) << 2 | x >>> 2 & 0x3333333333333333L;
        x = (x & 0xF0F0F0F0F0F0F0FL) << 4 | x >>> 4 & 0xF0F0F0F0F0F0F0FL;
        x = (x & 0xFF00FF00FF00FFL) << 8 | x >>> 8 & 0xFF00FF00FF00FFL;
        x = x << 48 | (x & 0xFFFF0000L) << 16 | x >>> 16 & 0xFFFF0000L | x >>> 48;
        return x;
    }

    @ImplementationTransparency
    public static int _reverse_d(int x) {
        x = (x & 0x55555555) << 1 | x >>> 1 & 0x55555555;
        x = (x & 0x33333333) << 2 | x >>> 2 & 0x33333333;
        x = (x & 0xF0F0F0F) << 4 | x >>> 4 & 0xF0F0F0F;
        x = Integer.reverseBytes(x);
        return x;
    }

    @ImplementationTransparency
    public static long _reverse_d(long x) {
        x = (x & 0x5555555555555555L) << 1 | x >>> 1 & 0x5555555555555555L;
        x = (x & 0x3333333333333333L) << 2 | x >>> 2 & 0x3333333333333333L;
        x = (x & 0xF0F0F0F0F0F0F0FL) << 4 | x >>> 4 & 0xF0F0F0F0F0F0F0FL;
        x = Long.reverseBytes(x);
        return x;
    }

    @ImplementationTransparency
    public static int _reverse_e(int x) {
        int eax;
        int ebx = eax = x;
        eax &= 0xAAAAAAAA;
        eax = BitUtilities.rotateUp(eax, 2);
        ebx = eax |= (ebx &= 0x55555555);
        eax &= 0x66666666;
        eax = BitUtilities.rotateUp(eax, 4);
        ebx = eax |= (ebx &= 0x99999999);
        eax &= 0x1E1E1E1E;
        eax = BitUtilities.rotateDown(eax, 8);
        eax |= (ebx &= 0xE1E1E1E1);
        eax = BitUtilities.rotateUp(eax, 7);
        eax = Integer.reverseBytes(eax);
        return eax;
    }

    @ImplementationTransparency
    public static int _reverse_f(int x) {
        int y = 0x55555555;
        x = x >>> 1 & y | (x & y) << 1;
        y = 0x33333333;
        x = x >>> 2 & y | (x & y) << 2;
        y = 0xF0F0F0F;
        x = x >>> 4 & y | (x & y) << 4;
        y = 0xFF00FF;
        x = x >>> 8 & y | (x & y) << 8;
        return x >>> 16 | x << 16;
    }

    @ImplementationTransparency
    public static long _reverse_f(long x) {
        long y = 0x5555555555555555L;
        x = x >>> 1 & y | (x & y) << 1;
        y = 0x3333333333333333L;
        x = x >>> 2 & y | (x & y) << 2;
        y = 0xF0F0F0F0F0F0F0FL;
        x = x >>> 4 & y | (x & y) << 4;
        y = 0xFF00FF00FF00FFL;
        x = x >>> 8 & y | (x & y) << 8;
        y = 0xFFFF0000FFFFL;
        x = x >>> 16 & y | (x & y) << 16;
        return x >>> 32 | x << 32;
    }

    @ImplementationTransparency
    public static int _reverse_g(int x) {
        int y = 0x55555555;
        x = x >>> 1 & y | (x & y) << 1;
        y = 0x33333333;
        x = x >>> 2 & y | (x & y) << 2;
        y = 0xF0F0F0F;
        x = x >>> 4 & y | (x & y) << 4;
        return Integer.reverseBytes(x);
    }

    @ImplementationTransparency
    public static long _reverse_g(long x) {
        long y = 0x5555555555555555L;
        x = x >>> 1 & y | (x & y) << 1;
        y = 0x3333333333333333L;
        x = x >>> 2 & y | (x & y) << 2;
        y = 0xF0F0F0F0F0F0F0FL;
        x = x >>> 4 & y | (x & y) << 4;
        return Long.reverseBytes(x);
    }

    public static byte _reverse_h(byte x) {
        return (byte)((x * 2050 & 0x22110 | x * 32800 & 0x88440) * 65793 >>> 16);
    }

    public static byte _reverse_i(byte x) {
        return (byte)(((long)x * 0x202020202L & 0x10884422010L) % 1023L);
    }

    public static byte _reverse_ii(byte x) {
        return (byte)(((long)x * 0x80200802L & 0x884422110L) * 0x101010101L >>> 32);
    }

    @ImplementationTransparency
    public static int _reverse_j(int x) {
        x = x >>> 16 | x << 16;
        int m = 0xFF00FF;
        x = x >>> 8 & m | x << 8 & ~m;
        m ^= m << 4;
        x = x >>> 4 & m | x << 4 & ~m;
        m ^= m << 2;
        x = x >>> 2 & m | x << 2 & ~m;
        m ^= m << 1;
        x = x >>> 1 & m | x << 1 & ~m;
        return x;
    }

    @ImplementationTransparency
    public static int _reverse_k(int x) {
        x = x << 15 | x >>> 17;
        int t = (x ^ x >>> 10) & 0x3F801F;
        x = t + (t << 10) ^ x;
        t = (x ^ x >>> 4) & 0xE038421;
        x = t + (t << 4) ^ x;
        t = (x ^ x >>> 2) & 0x22488842;
        x = t + (t << 2) ^ x;
        return x;
    }

    @ImplementationTransparency
    public static int _reverse_l(int x) {
        x |= (x & 0xFF) << 16;
        x = x & 0xF0F0F0F0 | (x & 0xF0F0F0F) << 8;
        x = x & 0xCCCCCCCC | (x & 0x33333333) << 4;
        x = x & 0xAAAAAAAA | (x & 0x55555555) << 2;
        return x <<= 1;
    }

    @ImplementationTransparency
    public static int _reverse_m(int x) {
        x = BitUtilities.rotateUp(x & 0xFF00FF, 16) | x & 0xFF00FF00;
        x = BitUtilities.rotateUp(x & 0xF0F0F0F, 8) | x & 0xF0F0F0F0;
        x = BitUtilities.rotateUp(x & 0x33333333, 4) | x & 0xCCCCCCCC;
        x = BitUtilities.rotateUp(x & 0x55555555, 2) | x & 0xAAAAAAAA;
        x = BitUtilities.rotateUp(x, 1);
        return x;
    }

    @ImplementationTransparency
    public static int _reverse_n(int x) {
        x = BitUtilities.rotateUp(x, 16) & 0xFF00FF | x & 0xFF00FF00;
        x = BitUtilities.rotateUp(x, 8) & 0xF0F0F0F | x & 0xF0F0F0F0;
        x = BitUtilities.rotateUp(x, 4) & 0x33333333 | x & 0xCCCCCCCC;
        x = BitUtilities.rotateUp(x, 2) & 0x55555555 | x & 0xAAAAAAAA;
        x = BitUtilities.rotateUp(x, 1);
        return x;
    }

    @ImplementationTransparency
    public static int _reverse_o(int x) {
        x = BitUtilities.rotateUp(x, 16) & 0xFF00FF | x & 0xFF00FF00;
        x = BitUtilities.rotateUp(x, 8) & 0xF0F0F0F | x & 0xF0F0F0F0;
        x = BitUtilities.rotateUp(x, 4) & 0x33333333 | x & 0xCCCCCCCC;
        x = BitUtilities.rotateUp(x, 2) & 0x55555555 | x & 0xAAAAAAAA;
        x = BitUtilities.rotateUp(x, 1);
        return x;
    }

    @ImplementationTransparency
    public static int _reverse_p(int x) {
        x = (BitUtilities.rotateUp(x, 16) ^ x) & 0xFF00FF ^ x;
        x = (BitUtilities.rotateUp(x, 8) ^ x) & 0xF0F0F0F ^ x;
        x = (BitUtilities.rotateUp(x, 4) ^ x) & 0x33333333 ^ x;
        x = (BitUtilities.rotateUp(x, 2) ^ x) & 0x55555555 ^ x;
        x = BitUtilities.rotateUp(x, 1);
        return x;
    }

    @ImplementationTransparency
    public static int _reverse_q(int x) {
        int t = x & 0xFF00FF;
        x = BitUtilities.rotateUp(t, 16) | t ^ x;
        t = x & 0xF0F0F0F;
        x = BitUtilities.rotateUp(t, 8) | t ^ x;
        t = x & 0x33333333;
        x = BitUtilities.rotateUp(t, 4) | t ^ x;
        t = x & 0x55555555;
        x = BitUtilities.rotateUp(t, 2) | t ^ x;
        x = BitUtilities.rotateUp(x, 1);
        return x;
    }

    @ImplementationTransparency
    public static int _reverse_r(int x) {
        x = (x & 0x1FF) << 18 | x & 0x3FE00 | x >>> 18 & 0x1FF;
        x = (x & 0x1C0E07) << 6 | x & 0xE07038 | x >>> 6 & 0x1C0E07;
        x = (x & 0x1249249) << 2 | x & 0x2492492 | x >>> 2 & 0x1249249;
        return x;
    }

    @ImplementationTransparency
    public static int _reverse_s(int x) {
        x = BitUtilities.rotateUp(x, 15);
        int t = (x ^ x >>> 10) & 0x3F801F;
        x = (t | t << 10) ^ x;
        t = (x ^ x >>> 4) & 0xE038421;
        x = (t | t << 4) ^ x;
        t = (x ^ x >>> 2) & 0x22488842;
        x = (t | t << 2) ^ x;
        return x;
    }

    @ImplementationTransparency
    public static long _reverse_t(long x) {
        x = x << 32 | x >>> 32;
        x = (x & 0x1FFFF0001FFFFL) << 15 | (x & 0xFFFE0000FFFE0000L) >>> 17;
        long t = (x ^ x >>> 10) & 0x3F801F003F801FL;
        x = (t | t << 10) ^ x;
        t = (x ^ x >>> 4) & 0xE0384210E038421L;
        x = (t | t << 4) ^ x;
        t = (x ^ x >>> 2) & 0x2248884222488842L;
        x = (t | t << 2) ^ x;
        return x;
    }

    @ImplementationTransparency
    public static long _reverse_u(long x) {
        x = BitUtilities.rotateUp(x, 47);
        long t = (x ^ x >>> 10) & 0x3F801F003F801FL;
        x = (t | t << 10) ^ x;
        t = (x ^ x >>> 4) & 0xE0384210E038421L;
        x = (t | t << 4) ^ x;
        t = (x ^ x >>> 2) & 0x2248884222488842L;
        x = (t | t << 2) ^ x;
        return x;
    }

    @ImplementationTransparency
    public static long _reverse_v(long x) {
        x = x << 31 | x >>> 33;
        long t = (x ^ x >>> 20) & 0xFFF800007FFL;
        x = (t | t << 20) ^ x;
        t = (x ^ x >>> 8) & 0xF8000F80700807L;
        x = (t | t << 8) ^ x;
        t = (x ^ x >>> 4) & 0x808708080807008L;
        x = (t | t << 4) ^ x;
        t = (x ^ x >>> 2) & 0x1111111111111111L;
        x = (t | t << 2) ^ x;
        return x;
    }

    @ImplementationTransparency
    public static long _reverse_w(long x) {
        x = BitUtilities.rotateUp(x, 31);
        long t = (x ^ x >>> 20) & 0xFFF800007FFL;
        x = (t | t << 20) ^ x;
        t = (x ^ x >>> 8) & 0xF8000F80700807L;
        x = (t | t << 8) ^ x;
        t = (x ^ x >>> 4) & 0x808708080807008L;
        x = (t | t << 4) ^ x;
        t = (x ^ x >>> 2) & 0x1111111111111111L;
        x = (t | t << 2) ^ x;
        return x;
    }

    @ImplementationTransparency
    public static byte _reverse_x(byte x) {
        byte k = 0;
        byte rev = 0;
        byte n = x;
        while (n != 0) {
            k = (byte)(n & ~(n - 1));
            n = (byte)(n & n - 1);
            rev = (byte)(rev | 128 / k);
        }
        return rev;
    }

    @ImplementationTransparency
    public static int _reverse_y(int num) {
        int num_reverse = 0;
        int size = 31;
        int i = 0;
        int j = 0;
        i = 0;
        j = size;
        while (i <= size & j >= 0) {
            if ((num >>> i & 1) != 0) {
                num_reverse |= 1 << j;
            }
            ++i;
            --j;
        }
        return num_reverse;
    }

    @ImplementationTransparency
    public static int _reverse_naive(int x) {
        int bits = 32;
        int r = 0;
        int i = 0;
        while (i < bits) {
            int bit = (x & 1 << i) >>> i;
            r |= bit << bits - i - 1;
            ++i;
        }
        return r;
    }

    public static short reverseBytes16(short x) {
        return Short.reverseBytes(x);
    }

    public static int reverseBytes32(int x) {
        return Integer.reverseBytes(x);
    }

    public static long reverseBytes64(long x) {
        return Long.reverseBytes(x);
    }

    public static int reverseBytes24(int x) {
        return Integer.reverseBytes(x) >>> 8;
    }

    public static long reverseBytes40(long x) {
        return Long.reverseBytes(x) >>> 8;
    }

    public static long reverseBytes48(long x) {
        return Long.reverseBytes(x) >>> 16;
    }

    public static long reverseBytes56(long x) {
        return Long.reverseBytes(x) >>> 24;
    }

    public static int rotateUp(int value, int numberOfBits) {
        return Integer.rotateLeft(value, numberOfBits);
    }

    public static int rotateDown(int value, int numberOfBits) {
        return Integer.rotateRight(value, numberOfBits);
    }

    public static long rotateUp(long value, int numberOfBits) {
        return Long.rotateLeft(value, numberOfBits);
    }

    public static long rotateDown(long value, int numberOfBits) {
        return Long.rotateRight(value, numberOfBits);
    }

    @ImplementationTransparency
    public static int _rotateUp_a(int value, int numberOfBits) {
        int x = value;
        int n = numberOfBits;
        return x << n | x >>> 32 - n;
    }

    @ImplementationTransparency
    public static int _rotateDown_a(int value, int numberOfBits) {
        int x = value;
        int n = numberOfBits;
        return x >> n | x << 32 - n;
    }

    @ImplementationTransparency
    public static long _rotateUp_a(long value, int numberOfBits) {
        long x = value;
        int n = numberOfBits;
        return x << n | x >>> 64 - n;
    }

    @ImplementationTransparency
    public static long _rotateDown_a(long value, int numberOfBits) {
        long x = value;
        int n = numberOfBits;
        return x >> n | x << 64 - n;
    }

    public static long signextend(long value, long bitLength) {
        boolean signbit;
        if (bitLength > 64L) {
            throw new IllegalArgumentException("Requested length is greater than a Java long's length (64 bits)! :  " + bitLength);
        }
        if (bitLength < 0L) {
            throw new IllegalArgumentException("Requested length is either negative if signed or greater than a Java long's length (64 bits) if unsigned! :  " + bitLength);
        }
        if (bitLength == 64L) {
            return value;
        }
        boolean bl = signbit = (value & (long)(1 << (int)(bitLength - 1L))) != 0L;
        if (!signbit) {
            return value;
        }
        return value | BitUtilities.getMask64(64L - bitLength) << (int)bitLength;
    }

    public static byte insureFitsUnsigned(byte value, long bits) throws OverflowException {
        if (bits == 0L) {
            throw new OverflowException();
        }
        if ((long)BitUtilities.dcd32(BitUtilities.getHighestOneBit(Unsigned.upcast(value))) >= bits) {
            throw new OverflowException(String.valueOf(value) + " does not fit in " + bits + " bits!");
        }
        return value;
    }

    public static short insureFitsUnsigned(short value, long bits) throws OverflowException {
        if (bits == 0L) {
            throw new OverflowException();
        }
        if ((long)BitUtilities.dcd32(BitUtilities.getHighestOneBit(Unsigned.upcast(value))) >= bits) {
            throw new OverflowException(String.valueOf(value) + " does not fit in " + bits + " bits!");
        }
        return value;
    }

    public static int insureFitsUnsigned(int value, long bits) throws OverflowException {
        if (bits == 0L) {
            throw new OverflowException();
        }
        if ((long)BitUtilities.dcd32(BitUtilities.getHighestOneBit(value)) >= bits) {
            throw new OverflowException(String.valueOf(value) + " does not fit in " + bits + " bits!");
        }
        return value;
    }

    public static long insureFitsUnsigned(long value, long bits) throws OverflowException {
        if (bits == 0L) {
            throw new OverflowException();
        }
        if ((long)BitUtilities.dcd64(BitUtilities.getHighestOneBit(value)) >= bits) {
            throw new OverflowException(String.valueOf(value) + " does not fit in " + bits + " bits!");
        }
        return value;
    }

    public static boolean isContiguousOnes(long value) {
        value >>>= BitUtilities.dcd64(BitUtilities.getLowestOneBit(value));
        return ++value == 0L || BitUtilities.getNumberOfOneBits(value) == 1;
    }

    public static boolean isContiguousZeros(long value) {
        return BitUtilities.isContiguousOnes(value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean isContiguousOnes(int value) {
        return BitUtilities.isContiguousOnes((long)value & 0xFFFFFFFFL);
    }

    public static boolean isContiguousOnes(short value) {
        return BitUtilities.isContiguousOnes((long)value & 0xFFFFL);
    }

    public static boolean isContiguousOnes(byte value) {
        return BitUtilities.isContiguousOnes((long)value & 0xFFL);
    }

    public static boolean isContiguousZeros(int value) {
        return BitUtilities.isContiguousZeros((long)value | 0xFFFFFFFF00000000L);
    }

    public static boolean isContiguousZeros(short value) {
        return BitUtilities.isContiguousZeros((long)value | 0xFFFFFFFFFFFF0000L);
    }

    public static boolean isContiguousZeros(byte value) {
        return BitUtilities.isContiguousZeros((long)value | 0xFFFFFFFFFFFFFF00L);
    }

    public static void andOP(@ReadonlyValue boolean[] sourceA, @ReadonlyValue boolean[] sourceB, @WritableValue boolean[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = sourceA[i] & sourceB[i];
            ++i;
        }
    }

    public static void andIP(@ReadonlyValue boolean[] source, @WritableValue boolean[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = source[i] & dest[i];
            ++i;
        }
    }

    public static void orOP(@ReadonlyValue boolean[] sourceA, @ReadonlyValue boolean[] sourceB, @WritableValue boolean[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = sourceA[i] | sourceB[i];
            ++i;
        }
    }

    public static void orIP(@ReadonlyValue boolean[] source, @WritableValue boolean[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = source[i] | dest[i];
            ++i;
        }
    }

    public static void xorOP(@ReadonlyValue boolean[] sourceA, @ReadonlyValue boolean[] sourceB, @WritableValue boolean[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = sourceA[i] ^ sourceB[i];
            ++i;
        }
    }

    public static void xorIP(@ReadonlyValue boolean[] source, @WritableValue boolean[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = source[i] ^ dest[i];
            ++i;
        }
    }

    public static void notIP(@WritableValue boolean[] x) {
        int length = x.length;
        int i = 0;
        while (i < length) {
            x[i] = !x[i];
            ++i;
        }
    }

    public static void andOP(@ReadonlyValue byte[] sourceA, @ReadonlyValue byte[] sourceB, @WritableValue byte[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = (byte)(sourceA[i] & sourceB[i]);
            ++i;
        }
    }

    public static void andIP(@ReadonlyValue byte[] source, @WritableValue byte[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = (byte)(source[i] & dest[i]);
            ++i;
        }
    }

    public static void orOP(@ReadonlyValue byte[] sourceA, @ReadonlyValue byte[] sourceB, @WritableValue byte[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = (byte)(sourceA[i] | sourceB[i]);
            ++i;
        }
    }

    public static void orIP(@ReadonlyValue byte[] source, @WritableValue byte[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = (byte)(source[i] | dest[i]);
            ++i;
        }
    }

    public static void xorOP(@ReadonlyValue byte[] sourceA, @ReadonlyValue byte[] sourceB, @WritableValue byte[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = (byte)(sourceA[i] ^ sourceB[i]);
            ++i;
        }
    }

    public static void xorIP(@ReadonlyValue byte[] source, @WritableValue byte[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = (byte)(source[i] ^ dest[i]);
            ++i;
        }
    }

    public static void notIP(@WritableValue byte[] x) {
        int length = x.length;
        int i = 0;
        while (i < length) {
            x[i] = ~x[i];
            ++i;
        }
    }

    public static void andOP(@ReadonlyValue char[] sourceA, @ReadonlyValue char[] sourceB, @WritableValue char[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = (char)(sourceA[i] & sourceB[i]);
            ++i;
        }
    }

    public static void andIP(@ReadonlyValue char[] source, @WritableValue char[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = (char)(source[i] & dest[i]);
            ++i;
        }
    }

    public static void orOP(@ReadonlyValue char[] sourceA, @ReadonlyValue char[] sourceB, @WritableValue char[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = (char)(sourceA[i] | sourceB[i]);
            ++i;
        }
    }

    public static void orIP(@ReadonlyValue char[] source, @WritableValue char[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = (char)(source[i] | dest[i]);
            ++i;
        }
    }

    public static void xorOP(@ReadonlyValue char[] sourceA, @ReadonlyValue char[] sourceB, @WritableValue char[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = (char)(sourceA[i] ^ sourceB[i]);
            ++i;
        }
    }

    public static void xorIP(@ReadonlyValue char[] source, @WritableValue char[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = (char)(source[i] ^ dest[i]);
            ++i;
        }
    }

    public static void notIP(@WritableValue char[] x) {
        int length = x.length;
        int i = 0;
        while (i < length) {
            x[i] = ~x[i];
            ++i;
        }
    }

    public static void andOP(@ReadonlyValue short[] sourceA, @ReadonlyValue short[] sourceB, @WritableValue short[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = (short)(sourceA[i] & sourceB[i]);
            ++i;
        }
    }

    public static void andIP(@ReadonlyValue short[] source, @WritableValue short[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = (short)(source[i] & dest[i]);
            ++i;
        }
    }

    public static void orOP(@ReadonlyValue short[] sourceA, @ReadonlyValue short[] sourceB, @WritableValue short[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = (short)(sourceA[i] | sourceB[i]);
            ++i;
        }
    }

    public static void orIP(@ReadonlyValue short[] source, @WritableValue short[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = (short)(source[i] | dest[i]);
            ++i;
        }
    }

    public static void xorOP(@ReadonlyValue short[] sourceA, @ReadonlyValue short[] sourceB, @WritableValue short[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = (short)(sourceA[i] ^ sourceB[i]);
            ++i;
        }
    }

    public static void xorIP(@ReadonlyValue short[] source, @WritableValue short[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = (short)(source[i] ^ dest[i]);
            ++i;
        }
    }

    public static void notIP(@WritableValue short[] x) {
        int length = x.length;
        int i = 0;
        while (i < length) {
            x[i] = ~x[i];
            ++i;
        }
    }

    public static void andOP(@ReadonlyValue int[] sourceA, @ReadonlyValue int[] sourceB, @WritableValue int[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = sourceA[i] & sourceB[i];
            ++i;
        }
    }

    public static void andIP(@ReadonlyValue int[] source, @WritableValue int[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = source[i] & dest[i];
            ++i;
        }
    }

    public static void orOP(@ReadonlyValue int[] sourceA, @ReadonlyValue int[] sourceB, @WritableValue int[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = sourceA[i] | sourceB[i];
            ++i;
        }
    }

    public static void orIP(@ReadonlyValue int[] source, @WritableValue int[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = source[i] | dest[i];
            ++i;
        }
    }

    public static void xorOP(@ReadonlyValue int[] sourceA, @ReadonlyValue int[] sourceB, @WritableValue int[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = sourceA[i] ^ sourceB[i];
            ++i;
        }
    }

    public static void xorIP(@ReadonlyValue int[] source, @WritableValue int[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = source[i] ^ dest[i];
            ++i;
        }
    }

    public static void notIP(@WritableValue int[] x) {
        int length = x.length;
        int i = 0;
        while (i < length) {
            x[i] = ~x[i];
            ++i;
        }
    }

    public static void andOP(@ReadonlyValue long[] sourceA, @ReadonlyValue long[] sourceB, @WritableValue long[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = sourceA[i] & sourceB[i];
            ++i;
        }
    }

    public static void andIP(@ReadonlyValue long[] source, @WritableValue long[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = source[i] & dest[i];
            ++i;
        }
    }

    public static void orOP(@ReadonlyValue long[] sourceA, @ReadonlyValue long[] sourceB, @WritableValue long[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = sourceA[i] | sourceB[i];
            ++i;
        }
    }

    public static void orIP(@ReadonlyValue long[] source, @WritableValue long[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = source[i] | dest[i];
            ++i;
        }
    }

    public static void xorOP(@ReadonlyValue long[] sourceA, @ReadonlyValue long[] sourceB, @WritableValue long[] dest) {
        int lSA = sourceA.length;
        int lSB = sourceB.length;
        int lD = dest.length;
        int length = lSB < lSA ? lSB : lSA;
        length = lD < length ? lD : length;
        int i = 0;
        while (i < length) {
            dest[i] = sourceA[i] ^ sourceB[i];
            ++i;
        }
    }

    public static void xorIP(@ReadonlyValue long[] source, @WritableValue long[] dest) {
        int lD = dest.length;
        int lS = source.length;
        int length = lD < lS ? lD : lS;
        int i = 0;
        while (i < length) {
            dest[i] = source[i] ^ dest[i];
            ++i;
        }
    }

    public static void notIP(@WritableValue long[] x) {
        int length = x.length;
        int i = 0;
        while (i < length) {
            x[i] = x[i] ^ 0xFFFFFFFFFFFFFFFFL;
            ++i;
        }
    }

    public static void reverseIP(@WritableValue byte[] x, int bitOffset, int bitLength) {
        int partial0Index;
        int wholeElementOffset;
        int wholeElementCount;
        if (bitLength < 0) {
            throw new IllegalArgumentException("bitOffset: " + bitOffset + ", bitLength: " + bitLength + ", capacity: " + x.length * 8);
        }
        if (bitOffset < 0 || bitOffset + bitLength > x.length * 8) {
            throw new IllegalArgumentException("bitOffset: " + bitOffset + ", bitLength: " + bitLength + ", capacity: " + x.length * 8);
        }
        if (bitLength == 0) {
            return;
        }
        if (bitLength == 8 && bitOffset % 8 == 0) {
            int elementIndex = bitOffset / 8;
            x[elementIndex] = BitUtilities.reverse(x[elementIndex]);
            return;
        }
        if (bitLength <= 8 && bitOffset / 8 == SmallIntegerMathUtilities.ceilingDivision(bitOffset + bitLength, 8)) {
            int elementIndex = bitOffset / 8;
            x[elementIndex] = BitUtilities.reverse(x[elementIndex], bitOffset, bitLength);
            return;
        }
        boolean hasPartial0 = bitOffset % 8 != 0;
        boolean hasPartial1 = (bitOffset + bitLength) % 8 != 0;
        int wholeElementPastEnd = (bitOffset + bitLength) / 8;
        int wholeElementStart = bitOffset / 8 + (hasPartial0 ? 1 : 0);
        if (wholeElementPastEnd < wholeElementStart) {
            wholeElementCount = 0;
            wholeElementOffset = 0;
        } else {
            wholeElementCount = wholeElementPastEnd - wholeElementStart;
            wholeElementOffset = wholeElementStart;
        }
        int other = 0;
        int i = 0;
        while (i < wholeElementCount) {
            other = wholeElementCount - i - 1;
            int n = i;
            x[n] = (byte)(x[n] ^ x[other]);
            int n2 = other;
            x[n2] = (byte)(x[n2] ^ x[i]);
            int n3 = i++;
            x[n3] = (byte)(x[n3] ^ x[other]);
        }
        int i2 = 0;
        while (i2 < wholeElementCount) {
            x[i2] = BitUtilities.reverse(x[i2]);
            ++i2;
        }
        if (hasPartial0 && hasPartial1) {
            byte newPartial1Element;
            byte newPartial0Element;
            partial0Index = bitOffset / 8;
            int partial1Index = (bitOffset + bitLength) / 8 + 1;
            int partial0StartInElement = bitOffset % 8;
            int partial1EndInElement = (bitOffset + bitLength) % 8;
            int partial0Bitlength = 8 - partial0StartInElement;
            int partial1Bitlength = partial1EndInElement;
            byte partial0Element = x[partial0Index];
            byte partial1Element = x[partial1Index];
            byte partial0ElementUntouchedMask = (byte)((1 << partial0StartInElement) - 1);
            byte partial1ElementMask = (byte)((1 << partial1EndInElement) - 1);
            byte partial0ElementMask = ~partial0ElementUntouchedMask;
            byte partial1ElementUntouchedMask = ~partial1ElementMask;
            byte partial0Bits = (byte)((partial0Element & partial0ElementMask) >>> partial0StartInElement);
            byte partial1Bits = (byte)(partial1Element & partial1ElementMask);
            byte reversedPartial0Bits = BitUtilities.reverse(partial0Bits, partial0Bitlength);
            byte reversedPartial1Bits = BitUtilities.reverse(partial1Bits, partial1Bitlength);
            if (partial0Bitlength == partial1Bitlength) {
                newPartial0Element = (byte)(partial0Element & partial0ElementUntouchedMask | reversedPartial1Bits << partial0StartInElement);
                newPartial1Element = (byte)(partial1Element & partial1ElementUntouchedMask | reversedPartial0Bits);
            } else {
                int shiftAmount = partial1Bitlength - partial0Bitlength;
                assert (shiftAmount != 0);
                if (shiftAmount > 0) {
                    assert (partial0Bitlength < partial1Bitlength);
                    int smallerPartialBitlength = partial0Bitlength;
                    byte commonDenominatorUntranslatedBitsMask = (byte)((1 << smallerPartialBitlength) - 1);
                    byte lowCarryMask = (byte)((1 << shiftAmount) - 1);
                    if (wholeElementCount != 0) {
                        int carry = 0;
                        int elementLengthMinusShiftAmount = 8 - shiftAmount;
                        byte highCarryMask = (byte)(lowCarryMask << elementLengthMinusShiftAmount);
                        int i3 = wholeElementOffset;
                        while (i3 < wholeElementCount) {
                            byte nextCarry = (byte)((x[i3] & highCarryMask) >>> shiftAmount);
                            x[i3] = (byte)(x[i3] << shiftAmount | carry);
                            carry = nextCarry;
                            ++i3;
                        }
                        byte partial1ElementWithCarriedBitsFromLastMiddleWholeElement = (byte)(partial1Element & ~lowCarryMask | carry);
                        byte partial0BitsInPartial1Mask = (byte)((1 << partial0Bitlength) - 1 << shiftAmount);
                        newPartial1Element = (byte)(partial1ElementWithCarriedBitsFromLastMiddleWholeElement & ~partial0BitsInPartial1Mask | reversedPartial0Bits << shiftAmount);
                        newPartial0Element = (byte)(partial0Element & partial0ElementUntouchedMask | (reversedPartial1Bits & commonDenominatorUntranslatedBitsMask) << partial0StartInElement);
                        assert (reversedPartial1Bits >>> smallerPartialBitlength == (reversedPartial1Bits >>> smallerPartialBitlength & lowCarryMask));
                        x[wholeElementOffset] = (byte)(x[wholeElementOffset] & ~lowCarryMask | reversedPartial1Bits >>> smallerPartialBitlength);
                    } else {
                        byte newPartial1ElementWithoutSpill = (byte)(partial1Element & partial1ElementUntouchedMask | reversedPartial0Bits << shiftAmount);
                        newPartial0Element = (byte)(partial0Element & partial0ElementUntouchedMask | (reversedPartial1Bits & commonDenominatorUntranslatedBitsMask) << partial0StartInElement);
                        assert (reversedPartial1Bits >>> smallerPartialBitlength == (reversedPartial1Bits >>> smallerPartialBitlength & lowCarryMask));
                        newPartial1Element = (byte)(newPartial1ElementWithoutSpill & ~lowCarryMask | reversedPartial1Bits >>> smallerPartialBitlength);
                    }
                } else {
                    assert (shiftAmount < 0);
                    int absShiftAmount = -shiftAmount;
                    assert (partial0Bitlength > partial1Bitlength);
                    int smallerPartialBitlength = partial1Bitlength;
                    byte commonDenominatorUntranslatedBitsMask = (byte)((1 << smallerPartialBitlength) - 1);
                    byte lowCarryMask = (byte)((1 << absShiftAmount) - 1);
                    int elementLengthMinusShiftAmount = 8 - absShiftAmount;
                    byte highCarryMask = (byte)(lowCarryMask << elementLengthMinusShiftAmount);
                    if (wholeElementCount != 0) {
                        int carry = 0;
                        int i4 = wholeElementOffset + wholeElementCount - 1;
                        while (i4 >= 0) {
                            byte nextCarry = (byte)(x[i4] & lowCarryMask);
                            x[i4] = (byte)(x[i4] >>> absShiftAmount | carry << elementLengthMinusShiftAmount);
                            carry = nextCarry;
                            --i4;
                        }
                        byte partial0ElementWithCarriedBitsFromFirstMiddleWholeElement = (byte)(partial0Element & ~highCarryMask | carry << elementLengthMinusShiftAmount);
                        byte partial1BitsInPartial0Mask = (byte)((1 << partial1Bitlength) - 1 << partial0StartInElement);
                        newPartial0Element = (byte)(partial0ElementWithCarriedBitsFromFirstMiddleWholeElement & ~partial1BitsInPartial0Mask | reversedPartial1Bits << partial0StartInElement);
                        newPartial1Element = (byte)(partial1Element & partial1ElementUntouchedMask | (reversedPartial0Bits & commonDenominatorUntranslatedBitsMask << absShiftAmount) >>> absShiftAmount);
                        int lastElementIndex = wholeElementOffset + wholeElementCount - 1;
                        x[lastElementIndex] = (byte)(x[lastElementIndex] & ~highCarryMask | (reversedPartial0Bits & lowCarryMask) << elementLengthMinusShiftAmount);
                    } else {
                        byte partial1BitsInPartial0Mask = (byte)((1 << partial1Bitlength) - 1 << partial0StartInElement);
                        byte newPartial0ElementWithoutSpill = (byte)(partial0Element & ~partial1BitsInPartial0Mask | reversedPartial1Bits << partial0StartInElement);
                        newPartial1Element = (byte)(partial1Element & partial1ElementUntouchedMask | (reversedPartial0Bits & commonDenominatorUntranslatedBitsMask << absShiftAmount) >>> absShiftAmount);
                        newPartial0Element = (byte)(newPartial0ElementWithoutSpill & ~highCarryMask | (reversedPartial0Bits & lowCarryMask) << elementLengthMinusShiftAmount);
                    }
                }
            }
            x[partial0Index] = newPartial0Element;
            x[partial1Index] = newPartial1Element;
        } else if (hasPartial0 && !hasPartial1) {
            int lastElementIndex;
            byte newPartial0Element;
            partial0Index = bitOffset / 8;
            int partial0StartInElement = bitOffset % 8;
            int partial0Bitlength = 8 - partial0StartInElement;
            byte partial0Element = x[partial0Index];
            byte partial0ElementUntouchedMask = (byte)((1 << partial0StartInElement) - 1);
            byte partial0ElementMask = ~partial0ElementUntouchedMask;
            byte partial0Bits = (byte)((partial0Element & partial0ElementMask) >>> partial0StartInElement);
            byte reversedPartial0Bits = BitUtilities.reverse(partial0Bits, partial0Bitlength);
            int shiftAmount = 0 - partial0Bitlength;
            assert (shiftAmount < 0);
            int absShiftAmount = -shiftAmount;
            byte lowCarryMask = (byte)((1 << absShiftAmount) - 1);
            int elementLengthMinusShiftAmount = 8 - absShiftAmount;
            byte highCarryMask = (byte)(lowCarryMask << elementLengthMinusShiftAmount);
            if (wholeElementCount != 0) {
                int carry = 0;
                int i5 = wholeElementOffset + wholeElementCount - 1;
                while (i5 >= 0) {
                    byte nextCarry = (byte)(x[i5] & lowCarryMask);
                    x[i5] = (byte)(x[i5] >>> absShiftAmount | carry << elementLengthMinusShiftAmount);
                    carry = nextCarry;
                    --i5;
                }
                assert (partial0ElementUntouchedMask == ~highCarryMask);
                newPartial0Element = (byte)(partial0Element & partial0ElementUntouchedMask | carry << partial0StartInElement);
                lastElementIndex = wholeElementOffset + wholeElementCount - 1;
                assert ((reversedPartial0Bits & lowCarryMask) == reversedPartial0Bits);
            } else {
                throw new AssertionError((Object)"Should have been caught by single-element shortcuts ;_;");
            }
            x[lastElementIndex] = (byte)(x[lastElementIndex] & ~highCarryMask | reversedPartial0Bits << elementLengthMinusShiftAmount);
            x[partial0Index] = newPartial0Element;
        } else if (!hasPartial0 && hasPartial1) {
            byte newPartial1Element;
            int partial1EndInElement;
            int partial1Index = (bitOffset + bitLength) / 8 + 1;
            int partial1Bitlength = partial1EndInElement = (bitOffset + bitLength) % 8;
            byte partial1Element = x[partial1Index];
            byte partial1ElementMask = (byte)((1 << partial1EndInElement) - 1);
            byte partial1ElementUntouchedMask = ~partial1ElementMask;
            byte partial1Bits = (byte)(partial1Element & partial1ElementMask);
            byte reversedPartial1Bits = BitUtilities.reverse(partial1Bits, partial1Bitlength);
            int shiftAmount = partial1Bitlength - 0;
            assert (shiftAmount > 0);
            byte lowCarryMask = (byte)((1 << shiftAmount) - 1);
            if (wholeElementCount != 0) {
                int carry = 0;
                int elementLengthMinusShiftAmount = 8 - shiftAmount;
                byte highCarryMask = (byte)(lowCarryMask << elementLengthMinusShiftAmount);
                int i6 = wholeElementOffset;
                while (i6 < wholeElementCount) {
                    byte nextCarry = (byte)((x[i6] & highCarryMask) >>> shiftAmount);
                    x[i6] = (byte)(x[i6] << shiftAmount | carry);
                    carry = nextCarry;
                    ++i6;
                }
                assert (~lowCarryMask == partial1ElementUntouchedMask);
                newPartial1Element = (byte)(partial1Element & partial1ElementUntouchedMask | carry);
                assert ((reversedPartial1Bits & lowCarryMask) == reversedPartial1Bits);
            } else {
                throw new AssertionError((Object)"Should have been caught by single-element shortcuts ;_;");
            }
            x[wholeElementOffset] = (byte)(x[wholeElementOffset] & ~lowCarryMask | reversedPartial1Bits);
            x[partial1Index] = newPartial1Element;
        }
    }

    public static void reverseIP(@WritableValue char[] x, int bitOffset, int bitLength) {
        int partial0Index;
        int wholeElementOffset;
        int wholeElementCount;
        if (bitLength < 0) {
            throw new IllegalArgumentException("bitOffset: " + bitOffset + ", bitLength: " + bitLength + ", capacity: " + x.length * 16);
        }
        if (bitOffset < 0 || bitOffset + bitLength > x.length * 16) {
            throw new IllegalArgumentException("bitOffset: " + bitOffset + ", bitLength: " + bitLength + ", capacity: " + x.length * 16);
        }
        if (bitLength == 0) {
            return;
        }
        if (bitLength == 16 && bitOffset % 16 == 0) {
            int elementIndex = bitOffset / 16;
            x[elementIndex] = BitUtilities.reverse(x[elementIndex]);
            return;
        }
        if (bitLength <= 16 && bitOffset / 16 == SmallIntegerMathUtilities.ceilingDivision(bitOffset + bitLength, 16)) {
            int elementIndex = bitOffset / 16;
            x[elementIndex] = BitUtilities.reverse(x[elementIndex], bitOffset, bitLength);
            return;
        }
        boolean hasPartial0 = bitOffset % 16 != 0;
        boolean hasPartial1 = (bitOffset + bitLength) % 16 != 0;
        int wholeElementPastEnd = (bitOffset + bitLength) / 16;
        int wholeElementStart = bitOffset / 16 + (hasPartial0 ? 1 : 0);
        if (wholeElementPastEnd < wholeElementStart) {
            wholeElementCount = 0;
            wholeElementOffset = 0;
        } else {
            wholeElementCount = wholeElementPastEnd - wholeElementStart;
            wholeElementOffset = wholeElementStart;
        }
        int other = 0;
        int i = 0;
        while (i < wholeElementCount) {
            other = wholeElementCount - i - 1;
            int n = i;
            x[n] = (char)(x[n] ^ x[other]);
            int n2 = other;
            x[n2] = (char)(x[n2] ^ x[i]);
            int n3 = i++;
            x[n3] = (char)(x[n3] ^ x[other]);
        }
        int i2 = 0;
        while (i2 < wholeElementCount) {
            x[i2] = BitUtilities.reverse(x[i2]);
            ++i2;
        }
        if (hasPartial0 && hasPartial1) {
            char newPartial1Element;
            char newPartial0Element;
            partial0Index = bitOffset / 16;
            int partial1Index = (bitOffset + bitLength) / 16 + 1;
            int partial0StartInElement = bitOffset % 16;
            int partial1EndInElement = (bitOffset + bitLength) % 16;
            int partial0Bitlength = 16 - partial0StartInElement;
            int partial1Bitlength = partial1EndInElement;
            char partial0Element = x[partial0Index];
            char partial1Element = x[partial1Index];
            char partial0ElementUntouchedMask = (char)((1 << partial0StartInElement) - 1);
            char partial1ElementMask = (char)((1 << partial1EndInElement) - 1);
            char partial0ElementMask = ~partial0ElementUntouchedMask;
            char partial1ElementUntouchedMask = ~partial1ElementMask;
            char partial0Bits = (char)((partial0Element & partial0ElementMask) >>> partial0StartInElement);
            char partial1Bits = (char)(partial1Element & partial1ElementMask);
            char reversedPartial0Bits = BitUtilities.reverse(partial0Bits, partial0Bitlength);
            char reversedPartial1Bits = BitUtilities.reverse(partial1Bits, partial1Bitlength);
            if (partial0Bitlength == partial1Bitlength) {
                newPartial0Element = (char)(partial0Element & partial0ElementUntouchedMask | reversedPartial1Bits << partial0StartInElement);
                newPartial1Element = (char)(partial1Element & partial1ElementUntouchedMask | reversedPartial0Bits);
            } else {
                int shiftAmount = partial1Bitlength - partial0Bitlength;
                assert (shiftAmount != 0);
                if (shiftAmount > 0) {
                    assert (partial0Bitlength < partial1Bitlength);
                    int smallerPartialBitlength = partial0Bitlength;
                    char commonDenominatorUntranslatedBitsMask = (char)((1 << smallerPartialBitlength) - 1);
                    char lowCarryMask = (char)((1 << shiftAmount) - 1);
                    if (wholeElementCount != 0) {
                        int carry = 0;
                        int elementLengthMinusShiftAmount = 16 - shiftAmount;
                        char highCarryMask = (char)(lowCarryMask << elementLengthMinusShiftAmount);
                        int i3 = wholeElementOffset;
                        while (i3 < wholeElementCount) {
                            char nextCarry = (char)((x[i3] & highCarryMask) >>> shiftAmount);
                            x[i3] = (char)(x[i3] << shiftAmount | carry);
                            carry = nextCarry;
                            ++i3;
                        }
                        char partial1ElementWithCarriedBitsFromLastMiddleWholeElement = (char)(partial1Element & ~lowCarryMask | carry);
                        char partial0BitsInPartial1Mask = (char)((1 << partial0Bitlength) - 1 << shiftAmount);
                        newPartial1Element = (char)(partial1ElementWithCarriedBitsFromLastMiddleWholeElement & ~partial0BitsInPartial1Mask | reversedPartial0Bits << shiftAmount);
                        newPartial0Element = (char)(partial0Element & partial0ElementUntouchedMask | (reversedPartial1Bits & commonDenominatorUntranslatedBitsMask) << partial0StartInElement);
                        assert (reversedPartial1Bits >>> smallerPartialBitlength == (reversedPartial1Bits >>> smallerPartialBitlength & lowCarryMask));
                        x[wholeElementOffset] = (char)(x[wholeElementOffset] & ~lowCarryMask | reversedPartial1Bits >>> smallerPartialBitlength);
                    } else {
                        char newPartial1ElementWithoutSpill = (char)(partial1Element & partial1ElementUntouchedMask | reversedPartial0Bits << shiftAmount);
                        newPartial0Element = (char)(partial0Element & partial0ElementUntouchedMask | (reversedPartial1Bits & commonDenominatorUntranslatedBitsMask) << partial0StartInElement);
                        assert (reversedPartial1Bits >>> smallerPartialBitlength == (reversedPartial1Bits >>> smallerPartialBitlength & lowCarryMask));
                        newPartial1Element = (char)(newPartial1ElementWithoutSpill & ~lowCarryMask | reversedPartial1Bits >>> smallerPartialBitlength);
                    }
                } else {
                    assert (shiftAmount < 0);
                    int absShiftAmount = -shiftAmount;
                    assert (partial0Bitlength > partial1Bitlength);
                    int smallerPartialBitlength = partial1Bitlength;
                    char commonDenominatorUntranslatedBitsMask = (char)((1 << smallerPartialBitlength) - 1);
                    char lowCarryMask = (char)((1 << absShiftAmount) - 1);
                    int elementLengthMinusShiftAmount = 16 - absShiftAmount;
                    char highCarryMask = (char)(lowCarryMask << elementLengthMinusShiftAmount);
                    if (wholeElementCount != 0) {
                        int carry = 0;
                        int i4 = wholeElementOffset + wholeElementCount - 1;
                        while (i4 >= 0) {
                            char nextCarry = (char)(x[i4] & lowCarryMask);
                            x[i4] = (char)(x[i4] >>> absShiftAmount | carry << elementLengthMinusShiftAmount);
                            carry = nextCarry;
                            --i4;
                        }
                        char partial0ElementWithCarriedBitsFromFirstMiddleWholeElement = (char)(partial0Element & ~highCarryMask | carry << elementLengthMinusShiftAmount);
                        char partial1BitsInPartial0Mask = (char)((1 << partial1Bitlength) - 1 << partial0StartInElement);
                        newPartial0Element = (char)(partial0ElementWithCarriedBitsFromFirstMiddleWholeElement & ~partial1BitsInPartial0Mask | reversedPartial1Bits << partial0StartInElement);
                        newPartial1Element = (char)(partial1Element & partial1ElementUntouchedMask | (reversedPartial0Bits & commonDenominatorUntranslatedBitsMask << absShiftAmount) >>> absShiftAmount);
                        int lastElementIndex = wholeElementOffset + wholeElementCount - 1;
                        x[lastElementIndex] = (char)(x[lastElementIndex] & ~highCarryMask | (reversedPartial0Bits & lowCarryMask) << elementLengthMinusShiftAmount);
                    } else {
                        char partial1BitsInPartial0Mask = (char)((1 << partial1Bitlength) - 1 << partial0StartInElement);
                        char newPartial0ElementWithoutSpill = (char)(partial0Element & ~partial1BitsInPartial0Mask | reversedPartial1Bits << partial0StartInElement);
                        newPartial1Element = (char)(partial1Element & partial1ElementUntouchedMask | (reversedPartial0Bits & commonDenominatorUntranslatedBitsMask << absShiftAmount) >>> absShiftAmount);
                        newPartial0Element = (char)(newPartial0ElementWithoutSpill & ~highCarryMask | (reversedPartial0Bits & lowCarryMask) << elementLengthMinusShiftAmount);
                    }
                }
            }
            x[partial0Index] = newPartial0Element;
            x[partial1Index] = newPartial1Element;
        } else if (hasPartial0 && !hasPartial1) {
            int lastElementIndex;
            char newPartial0Element;
            partial0Index = bitOffset / 16;
            int partial0StartInElement = bitOffset % 16;
            int partial0Bitlength = 16 - partial0StartInElement;
            char partial0Element = x[partial0Index];
            char partial0ElementUntouchedMask = (char)((1 << partial0StartInElement) - 1);
            char partial0ElementMask = ~partial0ElementUntouchedMask;
            char partial0Bits = (char)((partial0Element & partial0ElementMask) >>> partial0StartInElement);
            char reversedPartial0Bits = BitUtilities.reverse(partial0Bits, partial0Bitlength);
            int shiftAmount = 0 - partial0Bitlength;
            assert (shiftAmount < 0);
            int absShiftAmount = -shiftAmount;
            char lowCarryMask = (char)((1 << absShiftAmount) - 1);
            int elementLengthMinusShiftAmount = 16 - absShiftAmount;
            char highCarryMask = (char)(lowCarryMask << elementLengthMinusShiftAmount);
            if (wholeElementCount != 0) {
                int carry = 0;
                int i5 = wholeElementOffset + wholeElementCount - 1;
                while (i5 >= 0) {
                    char nextCarry = (char)(x[i5] & lowCarryMask);
                    x[i5] = (char)(x[i5] >>> absShiftAmount | carry << elementLengthMinusShiftAmount);
                    carry = nextCarry;
                    --i5;
                }
                assert (partial0ElementUntouchedMask == ~highCarryMask);
                newPartial0Element = (char)(partial0Element & partial0ElementUntouchedMask | carry << partial0StartInElement);
                lastElementIndex = wholeElementOffset + wholeElementCount - 1;
                assert ((reversedPartial0Bits & lowCarryMask) == reversedPartial0Bits);
            } else {
                throw new AssertionError((Object)"Should have been caught by single-element shortcuts ;_;");
            }
            x[lastElementIndex] = (char)(x[lastElementIndex] & ~highCarryMask | reversedPartial0Bits << elementLengthMinusShiftAmount);
            x[partial0Index] = newPartial0Element;
        } else if (!hasPartial0 && hasPartial1) {
            char newPartial1Element;
            int partial1EndInElement;
            int partial1Index = (bitOffset + bitLength) / 16 + 1;
            int partial1Bitlength = partial1EndInElement = (bitOffset + bitLength) % 16;
            char partial1Element = x[partial1Index];
            char partial1ElementMask = (char)((1 << partial1EndInElement) - 1);
            char partial1ElementUntouchedMask = ~partial1ElementMask;
            char partial1Bits = (char)(partial1Element & partial1ElementMask);
            char reversedPartial1Bits = BitUtilities.reverse(partial1Bits, partial1Bitlength);
            int shiftAmount = partial1Bitlength - 0;
            assert (shiftAmount > 0);
            char lowCarryMask = (char)((1 << shiftAmount) - 1);
            if (wholeElementCount != 0) {
                int carry = 0;
                int elementLengthMinusShiftAmount = 16 - shiftAmount;
                char highCarryMask = (char)(lowCarryMask << elementLengthMinusShiftAmount);
                int i6 = wholeElementOffset;
                while (i6 < wholeElementCount) {
                    char nextCarry = (char)((x[i6] & highCarryMask) >>> shiftAmount);
                    x[i6] = (char)(x[i6] << shiftAmount | carry);
                    carry = nextCarry;
                    ++i6;
                }
                assert (~lowCarryMask == partial1ElementUntouchedMask);
                newPartial1Element = (char)(partial1Element & partial1ElementUntouchedMask | carry);
                assert ((reversedPartial1Bits & lowCarryMask) == reversedPartial1Bits);
            } else {
                throw new AssertionError((Object)"Should have been caught by single-element shortcuts ;_;");
            }
            x[wholeElementOffset] = (char)(x[wholeElementOffset] & ~lowCarryMask | reversedPartial1Bits);
            x[partial1Index] = newPartial1Element;
        }
    }

    public static void reverseIP(@WritableValue short[] x, int bitOffset, int bitLength) {
        int partial0Index;
        int wholeElementOffset;
        int wholeElementCount;
        if (bitLength < 0) {
            throw new IllegalArgumentException("bitOffset: " + bitOffset + ", bitLength: " + bitLength + ", capacity: " + x.length * 16);
        }
        if (bitOffset < 0 || bitOffset + bitLength > x.length * 16) {
            throw new IllegalArgumentException("bitOffset: " + bitOffset + ", bitLength: " + bitLength + ", capacity: " + x.length * 16);
        }
        if (bitLength == 0) {
            return;
        }
        if (bitLength == 16 && bitOffset % 16 == 0) {
            int elementIndex = bitOffset / 16;
            x[elementIndex] = BitUtilities.reverse(x[elementIndex]);
            return;
        }
        if (bitLength <= 16 && bitOffset / 16 == SmallIntegerMathUtilities.ceilingDivision(bitOffset + bitLength, 16)) {
            int elementIndex = bitOffset / 16;
            x[elementIndex] = BitUtilities.reverse(x[elementIndex], bitOffset, bitLength);
            return;
        }
        boolean hasPartial0 = bitOffset % 16 != 0;
        boolean hasPartial1 = (bitOffset + bitLength) % 16 != 0;
        int wholeElementPastEnd = (bitOffset + bitLength) / 16;
        int wholeElementStart = bitOffset / 16 + (hasPartial0 ? 1 : 0);
        if (wholeElementPastEnd < wholeElementStart) {
            wholeElementCount = 0;
            wholeElementOffset = 0;
        } else {
            wholeElementCount = wholeElementPastEnd - wholeElementStart;
            wholeElementOffset = wholeElementStart;
        }
        int other = 0;
        int i = 0;
        while (i < wholeElementCount) {
            other = wholeElementCount - i - 1;
            int n = i;
            x[n] = (short)(x[n] ^ x[other]);
            int n2 = other;
            x[n2] = (short)(x[n2] ^ x[i]);
            int n3 = i++;
            x[n3] = (short)(x[n3] ^ x[other]);
        }
        int i2 = 0;
        while (i2 < wholeElementCount) {
            x[i2] = BitUtilities.reverse(x[i2]);
            ++i2;
        }
        if (hasPartial0 && hasPartial1) {
            short newPartial1Element;
            short newPartial0Element;
            partial0Index = bitOffset / 16;
            int partial1Index = (bitOffset + bitLength) / 16 + 1;
            int partial0StartInElement = bitOffset % 16;
            int partial1EndInElement = (bitOffset + bitLength) % 16;
            int partial0Bitlength = 16 - partial0StartInElement;
            int partial1Bitlength = partial1EndInElement;
            short partial0Element = x[partial0Index];
            short partial1Element = x[partial1Index];
            short partial0ElementUntouchedMask = (short)((1 << partial0StartInElement) - 1);
            short partial1ElementMask = (short)((1 << partial1EndInElement) - 1);
            short partial0ElementMask = ~partial0ElementUntouchedMask;
            short partial1ElementUntouchedMask = ~partial1ElementMask;
            short partial0Bits = (short)((partial0Element & partial0ElementMask) >>> partial0StartInElement);
            short partial1Bits = (short)(partial1Element & partial1ElementMask);
            short reversedPartial0Bits = BitUtilities.reverse(partial0Bits, partial0Bitlength);
            short reversedPartial1Bits = BitUtilities.reverse(partial1Bits, partial1Bitlength);
            if (partial0Bitlength == partial1Bitlength) {
                newPartial0Element = (short)(partial0Element & partial0ElementUntouchedMask | reversedPartial1Bits << partial0StartInElement);
                newPartial1Element = (short)(partial1Element & partial1ElementUntouchedMask | reversedPartial0Bits);
            } else {
                int shiftAmount = partial1Bitlength - partial0Bitlength;
                assert (shiftAmount != 0);
                if (shiftAmount > 0) {
                    assert (partial0Bitlength < partial1Bitlength);
                    int smallerPartialBitlength = partial0Bitlength;
                    short commonDenominatorUntranslatedBitsMask = (short)((1 << smallerPartialBitlength) - 1);
                    short lowCarryMask = (short)((1 << shiftAmount) - 1);
                    if (wholeElementCount != 0) {
                        int carry = 0;
                        int elementLengthMinusShiftAmount = 16 - shiftAmount;
                        short highCarryMask = (short)(lowCarryMask << elementLengthMinusShiftAmount);
                        int i3 = wholeElementOffset;
                        while (i3 < wholeElementCount) {
                            short nextCarry = (short)((x[i3] & highCarryMask) >>> shiftAmount);
                            x[i3] = (short)(x[i3] << shiftAmount | carry);
                            carry = nextCarry;
                            ++i3;
                        }
                        short partial1ElementWithCarriedBitsFromLastMiddleWholeElement = (short)(partial1Element & ~lowCarryMask | carry);
                        short partial0BitsInPartial1Mask = (short)((1 << partial0Bitlength) - 1 << shiftAmount);
                        newPartial1Element = (short)(partial1ElementWithCarriedBitsFromLastMiddleWholeElement & ~partial0BitsInPartial1Mask | reversedPartial0Bits << shiftAmount);
                        newPartial0Element = (short)(partial0Element & partial0ElementUntouchedMask | (reversedPartial1Bits & commonDenominatorUntranslatedBitsMask) << partial0StartInElement);
                        assert (reversedPartial1Bits >>> smallerPartialBitlength == (reversedPartial1Bits >>> smallerPartialBitlength & lowCarryMask));
                        x[wholeElementOffset] = (short)(x[wholeElementOffset] & ~lowCarryMask | reversedPartial1Bits >>> smallerPartialBitlength);
                    } else {
                        short newPartial1ElementWithoutSpill = (short)(partial1Element & partial1ElementUntouchedMask | reversedPartial0Bits << shiftAmount);
                        newPartial0Element = (short)(partial0Element & partial0ElementUntouchedMask | (reversedPartial1Bits & commonDenominatorUntranslatedBitsMask) << partial0StartInElement);
                        assert (reversedPartial1Bits >>> smallerPartialBitlength == (reversedPartial1Bits >>> smallerPartialBitlength & lowCarryMask));
                        newPartial1Element = (short)(newPartial1ElementWithoutSpill & ~lowCarryMask | reversedPartial1Bits >>> smallerPartialBitlength);
                    }
                } else {
                    assert (shiftAmount < 0);
                    int absShiftAmount = -shiftAmount;
                    assert (partial0Bitlength > partial1Bitlength);
                    int smallerPartialBitlength = partial1Bitlength;
                    short commonDenominatorUntranslatedBitsMask = (short)((1 << smallerPartialBitlength) - 1);
                    short lowCarryMask = (short)((1 << absShiftAmount) - 1);
                    int elementLengthMinusShiftAmount = 16 - absShiftAmount;
                    short highCarryMask = (short)(lowCarryMask << elementLengthMinusShiftAmount);
                    if (wholeElementCount != 0) {
                        int carry = 0;
                        int i4 = wholeElementOffset + wholeElementCount - 1;
                        while (i4 >= 0) {
                            short nextCarry = (short)(x[i4] & lowCarryMask);
                            x[i4] = (short)(x[i4] >>> absShiftAmount | carry << elementLengthMinusShiftAmount);
                            carry = nextCarry;
                            --i4;
                        }
                        short partial0ElementWithCarriedBitsFromFirstMiddleWholeElement = (short)(partial0Element & ~highCarryMask | carry << elementLengthMinusShiftAmount);
                        short partial1BitsInPartial0Mask = (short)((1 << partial1Bitlength) - 1 << partial0StartInElement);
                        newPartial0Element = (short)(partial0ElementWithCarriedBitsFromFirstMiddleWholeElement & ~partial1BitsInPartial0Mask | reversedPartial1Bits << partial0StartInElement);
                        newPartial1Element = (short)(partial1Element & partial1ElementUntouchedMask | (reversedPartial0Bits & commonDenominatorUntranslatedBitsMask << absShiftAmount) >>> absShiftAmount);
                        int lastElementIndex = wholeElementOffset + wholeElementCount - 1;
                        x[lastElementIndex] = (short)(x[lastElementIndex] & ~highCarryMask | (reversedPartial0Bits & lowCarryMask) << elementLengthMinusShiftAmount);
                    } else {
                        short partial1BitsInPartial0Mask = (short)((1 << partial1Bitlength) - 1 << partial0StartInElement);
                        short newPartial0ElementWithoutSpill = (short)(partial0Element & ~partial1BitsInPartial0Mask | reversedPartial1Bits << partial0StartInElement);
                        newPartial1Element = (short)(partial1Element & partial1ElementUntouchedMask | (reversedPartial0Bits & commonDenominatorUntranslatedBitsMask << absShiftAmount) >>> absShiftAmount);
                        newPartial0Element = (short)(newPartial0ElementWithoutSpill & ~highCarryMask | (reversedPartial0Bits & lowCarryMask) << elementLengthMinusShiftAmount);
                    }
                }
            }
            x[partial0Index] = newPartial0Element;
            x[partial1Index] = newPartial1Element;
        } else if (hasPartial0 && !hasPartial1) {
            int lastElementIndex;
            short newPartial0Element;
            partial0Index = bitOffset / 16;
            int partial0StartInElement = bitOffset % 16;
            int partial0Bitlength = 16 - partial0StartInElement;
            short partial0Element = x[partial0Index];
            short partial0ElementUntouchedMask = (short)((1 << partial0StartInElement) - 1);
            short partial0ElementMask = ~partial0ElementUntouchedMask;
            short partial0Bits = (short)((partial0Element & partial0ElementMask) >>> partial0StartInElement);
            short reversedPartial0Bits = BitUtilities.reverse(partial0Bits, partial0Bitlength);
            int shiftAmount = 0 - partial0Bitlength;
            assert (shiftAmount < 0);
            int absShiftAmount = -shiftAmount;
            short lowCarryMask = (short)((1 << absShiftAmount) - 1);
            int elementLengthMinusShiftAmount = 16 - absShiftAmount;
            short highCarryMask = (short)(lowCarryMask << elementLengthMinusShiftAmount);
            if (wholeElementCount != 0) {
                int carry = 0;
                int i5 = wholeElementOffset + wholeElementCount - 1;
                while (i5 >= 0) {
                    short nextCarry = (short)(x[i5] & lowCarryMask);
                    x[i5] = (short)(x[i5] >>> absShiftAmount | carry << elementLengthMinusShiftAmount);
                    carry = nextCarry;
                    --i5;
                }
                assert (partial0ElementUntouchedMask == ~highCarryMask);
                newPartial0Element = (short)(partial0Element & partial0ElementUntouchedMask | carry << partial0StartInElement);
                lastElementIndex = wholeElementOffset + wholeElementCount - 1;
                assert ((reversedPartial0Bits & lowCarryMask) == reversedPartial0Bits);
            } else {
                throw new AssertionError((Object)"Should have been caught by single-element shortcuts ;_;");
            }
            x[lastElementIndex] = (short)(x[lastElementIndex] & ~highCarryMask | reversedPartial0Bits << elementLengthMinusShiftAmount);
            x[partial0Index] = newPartial0Element;
        } else if (!hasPartial0 && hasPartial1) {
            short newPartial1Element;
            int partial1EndInElement;
            int partial1Index = (bitOffset + bitLength) / 16 + 1;
            int partial1Bitlength = partial1EndInElement = (bitOffset + bitLength) % 16;
            short partial1Element = x[partial1Index];
            short partial1ElementMask = (short)((1 << partial1EndInElement) - 1);
            short partial1ElementUntouchedMask = ~partial1ElementMask;
            short partial1Bits = (short)(partial1Element & partial1ElementMask);
            short reversedPartial1Bits = BitUtilities.reverse(partial1Bits, partial1Bitlength);
            int shiftAmount = partial1Bitlength - 0;
            assert (shiftAmount > 0);
            short lowCarryMask = (short)((1 << shiftAmount) - 1);
            if (wholeElementCount != 0) {
                int carry = 0;
                int elementLengthMinusShiftAmount = 16 - shiftAmount;
                short highCarryMask = (short)(lowCarryMask << elementLengthMinusShiftAmount);
                int i6 = wholeElementOffset;
                while (i6 < wholeElementCount) {
                    short nextCarry = (short)((x[i6] & highCarryMask) >>> shiftAmount);
                    x[i6] = (short)(x[i6] << shiftAmount | carry);
                    carry = nextCarry;
                    ++i6;
                }
                assert (~lowCarryMask == partial1ElementUntouchedMask);
                newPartial1Element = (short)(partial1Element & partial1ElementUntouchedMask | carry);
                assert ((reversedPartial1Bits & lowCarryMask) == reversedPartial1Bits);
            } else {
                throw new AssertionError((Object)"Should have been caught by single-element shortcuts ;_;");
            }
            x[wholeElementOffset] = (short)(x[wholeElementOffset] & ~lowCarryMask | reversedPartial1Bits);
            x[partial1Index] = newPartial1Element;
        }
    }

    public static void reverseIP(@WritableValue int[] x, int bitOffset, int bitLength) {
        int partial0Index;
        int wholeElementOffset;
        int wholeElementCount;
        if (bitLength < 0) {
            throw new IllegalArgumentException("bitOffset: " + bitOffset + ", bitLength: " + bitLength + ", capacity: " + x.length * 32);
        }
        if (bitOffset < 0 || bitOffset + bitLength > x.length * 32) {
            throw new IllegalArgumentException("bitOffset: " + bitOffset + ", bitLength: " + bitLength + ", capacity: " + x.length * 32);
        }
        if (bitLength == 0) {
            return;
        }
        if (bitLength == 32 && bitOffset % 32 == 0) {
            int elementIndex = bitOffset / 32;
            x[elementIndex] = BitUtilities.reverse(x[elementIndex]);
            return;
        }
        if (bitLength <= 32 && bitOffset / 32 == SmallIntegerMathUtilities.ceilingDivision(bitOffset + bitLength, 32)) {
            int elementIndex = bitOffset / 32;
            x[elementIndex] = BitUtilities.reverse32(x[elementIndex], bitOffset, bitLength);
            return;
        }
        boolean hasPartial0 = bitOffset % 32 != 0;
        boolean hasPartial1 = (bitOffset + bitLength) % 32 != 0;
        int wholeElementPastEnd = (bitOffset + bitLength) / 32;
        int wholeElementStart = bitOffset / 32 + (hasPartial0 ? 1 : 0);
        if (wholeElementPastEnd < wholeElementStart) {
            wholeElementCount = 0;
            wholeElementOffset = 0;
        } else {
            wholeElementCount = wholeElementPastEnd - wholeElementStart;
            wholeElementOffset = wholeElementStart;
        }
        int other = 0;
        int i = 0;
        while (i < wholeElementCount) {
            other = wholeElementCount - i - 1;
            int n = i;
            x[n] = x[n] ^ x[other];
            int n2 = other;
            x[n2] = x[n2] ^ x[i];
            int n3 = i++;
            x[n3] = x[n3] ^ x[other];
        }
        int i2 = 0;
        while (i2 < wholeElementCount) {
            x[i2] = BitUtilities.reverse(x[i2]);
            ++i2;
        }
        if (hasPartial0 && hasPartial1) {
            int newPartial1Element;
            int newPartial0Element;
            partial0Index = bitOffset / 32;
            int partial1Index = (bitOffset + bitLength) / 32 + 1;
            int partial0StartInElement = bitOffset % 32;
            int partial1EndInElement = (bitOffset + bitLength) % 32;
            int partial0Bitlength = 32 - partial0StartInElement;
            int partial1Bitlength = partial1EndInElement;
            int partial0Element = x[partial0Index];
            int partial1Element = x[partial1Index];
            int partial0ElementUntouchedMask = (1 << partial0StartInElement) - 1;
            int partial1ElementMask = (1 << partial1EndInElement) - 1;
            int partial0ElementMask = ~partial0ElementUntouchedMask;
            int partial1ElementUntouchedMask = ~partial1ElementMask;
            int partial0Bits = (partial0Element & partial0ElementMask) >>> partial0StartInElement;
            int partial1Bits = partial1Element & partial1ElementMask;
            int reversedPartial0Bits = BitUtilities.reverse(partial0Bits, partial0Bitlength);
            int reversedPartial1Bits = BitUtilities.reverse(partial1Bits, partial1Bitlength);
            if (partial0Bitlength == partial1Bitlength) {
                newPartial0Element = partial0Element & partial0ElementUntouchedMask | reversedPartial1Bits << partial0StartInElement;
                newPartial1Element = partial1Element & partial1ElementUntouchedMask | reversedPartial0Bits;
            } else {
                int shiftAmount = partial1Bitlength - partial0Bitlength;
                assert (shiftAmount != 0);
                if (shiftAmount > 0) {
                    assert (partial0Bitlength < partial1Bitlength);
                    int smallerPartialBitlength = partial0Bitlength;
                    int commonDenominatorUntranslatedBitsMask = (1 << smallerPartialBitlength) - 1;
                    int lowCarryMask = (1 << shiftAmount) - 1;
                    if (wholeElementCount != 0) {
                        int carry = 0;
                        int elementLengthMinusShiftAmount = 32 - shiftAmount;
                        int highCarryMask = lowCarryMask << elementLengthMinusShiftAmount;
                        int i3 = wholeElementOffset;
                        while (i3 < wholeElementCount) {
                            int nextCarry = (x[i3] & highCarryMask) >>> shiftAmount;
                            x[i3] = x[i3] << shiftAmount | carry;
                            carry = nextCarry;
                            ++i3;
                        }
                        int partial1ElementWithCarriedBitsFromLastMiddleWholeElement = partial1Element & ~lowCarryMask | carry;
                        int partial0BitsInPartial1Mask = (1 << partial0Bitlength) - 1 << shiftAmount;
                        newPartial1Element = partial1ElementWithCarriedBitsFromLastMiddleWholeElement & ~partial0BitsInPartial1Mask | reversedPartial0Bits << shiftAmount;
                        newPartial0Element = partial0Element & partial0ElementUntouchedMask | (reversedPartial1Bits & commonDenominatorUntranslatedBitsMask) << partial0StartInElement;
                        assert (reversedPartial1Bits >>> smallerPartialBitlength == (reversedPartial1Bits >>> smallerPartialBitlength & lowCarryMask));
                        x[wholeElementOffset] = x[wholeElementOffset] & ~lowCarryMask | reversedPartial1Bits >>> smallerPartialBitlength;
                    } else {
                        int newPartial1ElementWithoutSpill = partial1Element & partial1ElementUntouchedMask | reversedPartial0Bits << shiftAmount;
                        newPartial0Element = partial0Element & partial0ElementUntouchedMask | (reversedPartial1Bits & commonDenominatorUntranslatedBitsMask) << partial0StartInElement;
                        assert (reversedPartial1Bits >>> smallerPartialBitlength == (reversedPartial1Bits >>> smallerPartialBitlength & lowCarryMask));
                        newPartial1Element = newPartial1ElementWithoutSpill & ~lowCarryMask | reversedPartial1Bits >>> smallerPartialBitlength;
                    }
                } else {
                    assert (shiftAmount < 0);
                    int absShiftAmount = -shiftAmount;
                    assert (partial0Bitlength > partial1Bitlength);
                    int smallerPartialBitlength = partial1Bitlength;
                    int commonDenominatorUntranslatedBitsMask = (1 << smallerPartialBitlength) - 1;
                    int lowCarryMask = (1 << absShiftAmount) - 1;
                    int elementLengthMinusShiftAmount = 32 - absShiftAmount;
                    int highCarryMask = lowCarryMask << elementLengthMinusShiftAmount;
                    if (wholeElementCount != 0) {
                        int carry = 0;
                        int i4 = wholeElementOffset + wholeElementCount - 1;
                        while (i4 >= 0) {
                            int nextCarry = x[i4] & lowCarryMask;
                            x[i4] = x[i4] >>> absShiftAmount | carry << elementLengthMinusShiftAmount;
                            carry = nextCarry;
                            --i4;
                        }
                        int partial0ElementWithCarriedBitsFromFirstMiddleWholeElement = partial0Element & ~highCarryMask | carry << elementLengthMinusShiftAmount;
                        int partial1BitsInPartial0Mask = (1 << partial1Bitlength) - 1 << partial0StartInElement;
                        newPartial0Element = partial0ElementWithCarriedBitsFromFirstMiddleWholeElement & ~partial1BitsInPartial0Mask | reversedPartial1Bits << partial0StartInElement;
                        newPartial1Element = partial1Element & partial1ElementUntouchedMask | (reversedPartial0Bits & commonDenominatorUntranslatedBitsMask << absShiftAmount) >>> absShiftAmount;
                        int lastElementIndex = wholeElementOffset + wholeElementCount - 1;
                        x[lastElementIndex] = x[lastElementIndex] & ~highCarryMask | (reversedPartial0Bits & lowCarryMask) << elementLengthMinusShiftAmount;
                    } else {
                        int partial1BitsInPartial0Mask = (1 << partial1Bitlength) - 1 << partial0StartInElement;
                        int newPartial0ElementWithoutSpill = partial0Element & ~partial1BitsInPartial0Mask | reversedPartial1Bits << partial0StartInElement;
                        newPartial1Element = partial1Element & partial1ElementUntouchedMask | (reversedPartial0Bits & commonDenominatorUntranslatedBitsMask << absShiftAmount) >>> absShiftAmount;
                        newPartial0Element = newPartial0ElementWithoutSpill & ~highCarryMask | (reversedPartial0Bits & lowCarryMask) << elementLengthMinusShiftAmount;
                    }
                }
            }
            x[partial0Index] = newPartial0Element;
            x[partial1Index] = newPartial1Element;
        } else if (hasPartial0 && !hasPartial1) {
            int lastElementIndex;
            int newPartial0Element;
            partial0Index = bitOffset / 32;
            int partial0StartInElement = bitOffset % 32;
            int partial0Bitlength = 32 - partial0StartInElement;
            int partial0Element = x[partial0Index];
            int partial0ElementUntouchedMask = (1 << partial0StartInElement) - 1;
            int partial0ElementMask = ~partial0ElementUntouchedMask;
            int partial0Bits = (partial0Element & partial0ElementMask) >>> partial0StartInElement;
            int reversedPartial0Bits = BitUtilities.reverse(partial0Bits, partial0Bitlength);
            int shiftAmount = 0 - partial0Bitlength;
            assert (shiftAmount < 0);
            int absShiftAmount = -shiftAmount;
            int lowCarryMask = (1 << absShiftAmount) - 1;
            int elementLengthMinusShiftAmount = 32 - absShiftAmount;
            int highCarryMask = lowCarryMask << elementLengthMinusShiftAmount;
            if (wholeElementCount != 0) {
                int carry = 0;
                int i5 = wholeElementOffset + wholeElementCount - 1;
                while (i5 >= 0) {
                    int nextCarry = x[i5] & lowCarryMask;
                    x[i5] = x[i5] >>> absShiftAmount | carry << elementLengthMinusShiftAmount;
                    carry = nextCarry;
                    --i5;
                }
                assert (partial0ElementUntouchedMask == ~highCarryMask);
                newPartial0Element = partial0Element & partial0ElementUntouchedMask | carry << partial0StartInElement;
                lastElementIndex = wholeElementOffset + wholeElementCount - 1;
                assert ((reversedPartial0Bits & lowCarryMask) == reversedPartial0Bits);
            } else {
                throw new AssertionError((Object)"Should have been caught by single-element shortcuts ;_;");
            }
            x[lastElementIndex] = x[lastElementIndex] & ~highCarryMask | reversedPartial0Bits << elementLengthMinusShiftAmount;
            x[partial0Index] = newPartial0Element;
        } else if (!hasPartial0 && hasPartial1) {
            int newPartial1Element;
            int partial1EndInElement;
            int partial1Index = (bitOffset + bitLength) / 32 + 1;
            int partial1Bitlength = partial1EndInElement = (bitOffset + bitLength) % 32;
            int partial1Element = x[partial1Index];
            int partial1ElementMask = (1 << partial1EndInElement) - 1;
            int partial1ElementUntouchedMask = ~partial1ElementMask;
            int partial1Bits = partial1Element & partial1ElementMask;
            int reversedPartial1Bits = BitUtilities.reverse(partial1Bits, partial1Bitlength);
            int shiftAmount = partial1Bitlength - 0;
            assert (shiftAmount > 0);
            int lowCarryMask = (1 << shiftAmount) - 1;
            if (wholeElementCount != 0) {
                int carry = 0;
                int elementLengthMinusShiftAmount = 32 - shiftAmount;
                int highCarryMask = lowCarryMask << elementLengthMinusShiftAmount;
                int i6 = wholeElementOffset;
                while (i6 < wholeElementCount) {
                    int nextCarry = (x[i6] & highCarryMask) >>> shiftAmount;
                    x[i6] = x[i6] << shiftAmount | carry;
                    carry = nextCarry;
                    ++i6;
                }
                assert (~lowCarryMask == partial1ElementUntouchedMask);
                newPartial1Element = partial1Element & partial1ElementUntouchedMask | carry;
                assert ((reversedPartial1Bits & lowCarryMask) == reversedPartial1Bits);
            } else {
                throw new AssertionError((Object)"Should have been caught by single-element shortcuts ;_;");
            }
            x[wholeElementOffset] = x[wholeElementOffset] & ~lowCarryMask | reversedPartial1Bits;
            x[partial1Index] = newPartial1Element;
        }
    }

    public static void reverseIP(@WritableValue long[] x, int bitOffset, int bitLength) {
        int partial0Index;
        int wholeElementOffset;
        int wholeElementCount;
        if (bitLength < 0) {
            throw new IllegalArgumentException("bitOffset: " + bitOffset + ", bitLength: " + bitLength + ", capacity: " + x.length * 64);
        }
        if (bitOffset < 0 || bitOffset + bitLength > x.length * 64) {
            throw new IllegalArgumentException("bitOffset: " + bitOffset + ", bitLength: " + bitLength + ", capacity: " + x.length * 64);
        }
        if (bitLength == 0) {
            return;
        }
        if (bitLength == 64 && bitOffset % 64 == 0) {
            int elementIndex = bitOffset / 64;
            x[elementIndex] = BitUtilities.reverse(x[elementIndex]);
            return;
        }
        if (bitLength <= 64 && bitOffset / 64 == SmallIntegerMathUtilities.ceilingDivision(bitOffset + bitLength, 64)) {
            int elementIndex = bitOffset / 64;
            x[elementIndex] = BitUtilities.reverse64(x[elementIndex], bitOffset, bitLength);
            return;
        }
        boolean hasPartial0 = bitOffset % 64 != 0;
        boolean hasPartial1 = (bitOffset + bitLength) % 64 != 0;
        int wholeElementPastEnd = (bitOffset + bitLength) / 64;
        int wholeElementStart = bitOffset / 64 + (hasPartial0 ? 1 : 0);
        if (wholeElementPastEnd < wholeElementStart) {
            wholeElementCount = 0;
            wholeElementOffset = 0;
        } else {
            wholeElementCount = wholeElementPastEnd - wholeElementStart;
            wholeElementOffset = wholeElementStart;
        }
        int other = 0;
        int i = 0;
        while (i < wholeElementCount) {
            other = wholeElementCount - i - 1;
            int n = i;
            x[n] = x[n] ^ x[other];
            int n2 = other;
            x[n2] = x[n2] ^ x[i];
            int n3 = i++;
            x[n3] = x[n3] ^ x[other];
        }
        int i2 = 0;
        while (i2 < wholeElementCount) {
            x[i2] = BitUtilities.reverse(x[i2]);
            ++i2;
        }
        if (hasPartial0 && hasPartial1) {
            long newPartial1Element;
            long newPartial0Element;
            partial0Index = bitOffset / 64;
            int partial1Index = (bitOffset + bitLength) / 64 + 1;
            int partial0StartInElement = bitOffset % 64;
            int partial1EndInElement = (bitOffset + bitLength) % 64;
            int partial0Bitlength = 64 - partial0StartInElement;
            int partial1Bitlength = partial1EndInElement;
            long partial0Element = x[partial0Index];
            long partial1Element = x[partial1Index];
            long partial0ElementUntouchedMask = (1 << partial0StartInElement) - 1;
            long partial1ElementMask = (1 << partial1EndInElement) - 1;
            long partial0ElementMask = partial0ElementUntouchedMask ^ 0xFFFFFFFFFFFFFFFFL;
            long partial1ElementUntouchedMask = partial1ElementMask ^ 0xFFFFFFFFFFFFFFFFL;
            long partial0Bits = (partial0Element & partial0ElementMask) >>> partial0StartInElement;
            long partial1Bits = partial1Element & partial1ElementMask;
            long reversedPartial0Bits = BitUtilities.reverse(partial0Bits, partial0Bitlength);
            long reversedPartial1Bits = BitUtilities.reverse(partial1Bits, partial1Bitlength);
            if (partial0Bitlength == partial1Bitlength) {
                newPartial0Element = partial0Element & partial0ElementUntouchedMask | reversedPartial1Bits << partial0StartInElement;
                newPartial1Element = partial1Element & partial1ElementUntouchedMask | reversedPartial0Bits;
            } else {
                int shiftAmount = partial1Bitlength - partial0Bitlength;
                assert (shiftAmount != 0);
                if (shiftAmount > 0) {
                    assert (partial0Bitlength < partial1Bitlength);
                    int smallerPartialBitlength = partial0Bitlength;
                    long commonDenominatorUntranslatedBitsMask = (1 << smallerPartialBitlength) - 1;
                    long lowCarryMask = (1 << shiftAmount) - 1;
                    if (wholeElementCount != 0) {
                        long carry = 0L;
                        int elementLengthMinusShiftAmount = 64 - shiftAmount;
                        long highCarryMask = lowCarryMask << elementLengthMinusShiftAmount;
                        int i3 = wholeElementOffset;
                        while (i3 < wholeElementCount) {
                            long nextCarry = (x[i3] & highCarryMask) >>> shiftAmount;
                            x[i3] = x[i3] << shiftAmount | carry;
                            carry = nextCarry;
                            ++i3;
                        }
                        long partial1ElementWithCarriedBitsFromLastMiddleWholeElement = partial1Element & (lowCarryMask ^ 0xFFFFFFFFFFFFFFFFL) | carry;
                        long partial0BitsInPartial1Mask = (1 << partial0Bitlength) - 1 << shiftAmount;
                        newPartial1Element = partial1ElementWithCarriedBitsFromLastMiddleWholeElement & (partial0BitsInPartial1Mask ^ 0xFFFFFFFFFFFFFFFFL) | reversedPartial0Bits << shiftAmount;
                        newPartial0Element = partial0Element & partial0ElementUntouchedMask | (reversedPartial1Bits & commonDenominatorUntranslatedBitsMask) << partial0StartInElement;
                        assert (reversedPartial1Bits >>> smallerPartialBitlength == (reversedPartial1Bits >>> smallerPartialBitlength & lowCarryMask));
                        x[wholeElementOffset] = x[wholeElementOffset] & (lowCarryMask ^ 0xFFFFFFFFFFFFFFFFL) | reversedPartial1Bits >>> smallerPartialBitlength;
                    } else {
                        long newPartial1ElementWithoutSpill = partial1Element & partial1ElementUntouchedMask | reversedPartial0Bits << shiftAmount;
                        newPartial0Element = partial0Element & partial0ElementUntouchedMask | (reversedPartial1Bits & commonDenominatorUntranslatedBitsMask) << partial0StartInElement;
                        assert (reversedPartial1Bits >>> smallerPartialBitlength == (reversedPartial1Bits >>> smallerPartialBitlength & lowCarryMask));
                        newPartial1Element = newPartial1ElementWithoutSpill & (lowCarryMask ^ 0xFFFFFFFFFFFFFFFFL) | reversedPartial1Bits >>> smallerPartialBitlength;
                    }
                } else {
                    assert (shiftAmount < 0);
                    int absShiftAmount = -shiftAmount;
                    assert (partial0Bitlength > partial1Bitlength);
                    int smallerPartialBitlength = partial1Bitlength;
                    long commonDenominatorUntranslatedBitsMask = (1 << smallerPartialBitlength) - 1;
                    long lowCarryMask = (1 << absShiftAmount) - 1;
                    int elementLengthMinusShiftAmount = 64 - absShiftAmount;
                    long highCarryMask = lowCarryMask << elementLengthMinusShiftAmount;
                    if (wholeElementCount != 0) {
                        long carry = 0L;
                        int i4 = wholeElementOffset + wholeElementCount - 1;
                        while (i4 >= 0) {
                            long nextCarry = x[i4] & lowCarryMask;
                            x[i4] = x[i4] >>> absShiftAmount | carry << elementLengthMinusShiftAmount;
                            carry = nextCarry;
                            --i4;
                        }
                        long partial0ElementWithCarriedBitsFromFirstMiddleWholeElement = partial0Element & (highCarryMask ^ 0xFFFFFFFFFFFFFFFFL) | carry << elementLengthMinusShiftAmount;
                        long partial1BitsInPartial0Mask = (1 << partial1Bitlength) - 1 << partial0StartInElement;
                        newPartial0Element = partial0ElementWithCarriedBitsFromFirstMiddleWholeElement & (partial1BitsInPartial0Mask ^ 0xFFFFFFFFFFFFFFFFL) | reversedPartial1Bits << partial0StartInElement;
                        newPartial1Element = partial1Element & partial1ElementUntouchedMask | (reversedPartial0Bits & commonDenominatorUntranslatedBitsMask << absShiftAmount) >>> absShiftAmount;
                        int lastElementIndex = wholeElementOffset + wholeElementCount - 1;
                        x[lastElementIndex] = x[lastElementIndex] & (highCarryMask ^ 0xFFFFFFFFFFFFFFFFL) | (reversedPartial0Bits & lowCarryMask) << elementLengthMinusShiftAmount;
                    } else {
                        long partial1BitsInPartial0Mask = (1 << partial1Bitlength) - 1 << partial0StartInElement;
                        long newPartial0ElementWithoutSpill = partial0Element & (partial1BitsInPartial0Mask ^ 0xFFFFFFFFFFFFFFFFL) | reversedPartial1Bits << partial0StartInElement;
                        newPartial1Element = partial1Element & partial1ElementUntouchedMask | (reversedPartial0Bits & commonDenominatorUntranslatedBitsMask << absShiftAmount) >>> absShiftAmount;
                        newPartial0Element = newPartial0ElementWithoutSpill & (highCarryMask ^ 0xFFFFFFFFFFFFFFFFL) | (reversedPartial0Bits & lowCarryMask) << elementLengthMinusShiftAmount;
                    }
                }
            }
            x[partial0Index] = newPartial0Element;
            x[partial1Index] = newPartial1Element;
        } else if (hasPartial0 && !hasPartial1) {
            int lastElementIndex;
            long newPartial0Element;
            partial0Index = bitOffset / 64;
            int partial0StartInElement = bitOffset % 64;
            int partial0Bitlength = 64 - partial0StartInElement;
            long partial0Element = x[partial0Index];
            long partial0ElementUntouchedMask = (1 << partial0StartInElement) - 1;
            long partial0ElementMask = partial0ElementUntouchedMask ^ 0xFFFFFFFFFFFFFFFFL;
            long partial0Bits = (partial0Element & partial0ElementMask) >>> partial0StartInElement;
            long reversedPartial0Bits = BitUtilities.reverse(partial0Bits, partial0Bitlength);
            int shiftAmount = 0 - partial0Bitlength;
            assert (shiftAmount < 0);
            int absShiftAmount = -shiftAmount;
            long lowCarryMask = (1 << absShiftAmount) - 1;
            int elementLengthMinusShiftAmount = 64 - absShiftAmount;
            long highCarryMask = lowCarryMask << elementLengthMinusShiftAmount;
            if (wholeElementCount != 0) {
                long carry = 0L;
                int i5 = wholeElementOffset + wholeElementCount - 1;
                while (i5 >= 0) {
                    long nextCarry = x[i5] & lowCarryMask;
                    x[i5] = x[i5] >>> absShiftAmount | carry << elementLengthMinusShiftAmount;
                    carry = nextCarry;
                    --i5;
                }
                assert (partial0ElementUntouchedMask == (highCarryMask ^ 0xFFFFFFFFFFFFFFFFL));
                newPartial0Element = partial0Element & partial0ElementUntouchedMask | carry << partial0StartInElement;
                lastElementIndex = wholeElementOffset + wholeElementCount - 1;
                assert ((reversedPartial0Bits & lowCarryMask) == reversedPartial0Bits);
            } else {
                throw new AssertionError((Object)"Should have been caught by single-element shortcuts ;_;");
            }
            x[lastElementIndex] = x[lastElementIndex] & (highCarryMask ^ 0xFFFFFFFFFFFFFFFFL) | reversedPartial0Bits << elementLengthMinusShiftAmount;
            x[partial0Index] = newPartial0Element;
        } else if (!hasPartial0 && hasPartial1) {
            long newPartial1Element;
            int partial1EndInElement;
            int partial1Index = (bitOffset + bitLength) / 64 + 1;
            int partial1Bitlength = partial1EndInElement = (bitOffset + bitLength) % 64;
            long partial1Element = x[partial1Index];
            long partial1ElementMask = (1 << partial1EndInElement) - 1;
            long partial1ElementUntouchedMask = partial1ElementMask ^ 0xFFFFFFFFFFFFFFFFL;
            long partial1Bits = partial1Element & partial1ElementMask;
            long reversedPartial1Bits = BitUtilities.reverse(partial1Bits, partial1Bitlength);
            int shiftAmount = partial1Bitlength - 0;
            assert (shiftAmount > 0);
            long lowCarryMask = (1 << shiftAmount) - 1;
            if (wholeElementCount != 0) {
                long carry = 0L;
                int elementLengthMinusShiftAmount = 64 - shiftAmount;
                long highCarryMask = lowCarryMask << elementLengthMinusShiftAmount;
                int i6 = wholeElementOffset;
                while (i6 < wholeElementCount) {
                    long nextCarry = (x[i6] & highCarryMask) >>> shiftAmount;
                    x[i6] = x[i6] << shiftAmount | carry;
                    carry = nextCarry;
                    ++i6;
                }
                assert ((lowCarryMask ^ 0xFFFFFFFFFFFFFFFFL) == partial1ElementUntouchedMask);
                newPartial1Element = partial1Element & partial1ElementUntouchedMask | carry;
                assert ((reversedPartial1Bits & lowCarryMask) == reversedPartial1Bits);
            } else {
                throw new AssertionError((Object)"Should have been caught by single-element shortcuts ;_;");
            }
            x[wholeElementOffset] = x[wholeElementOffset] & (lowCarryMask ^ 0xFFFFFFFFFFFFFFFFL) | reversedPartial1Bits;
            x[partial1Index] = newPartial1Element;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue byte[] source, int sourceOffset, @WritableValue byte[] dest, int destOffset, int lengthInEqualSizeElements) {
        System.arraycopy(source, sourceOffset, dest, destOffset, lengthInEqualSizeElements);
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue byte[] source, int sourceOffset, @WritableValue char[] dest, int destOffset, int lengthInLargerDestElements) {
        int ratio = 2;
        int i = 0;
        while (i < lengthInLargerDestElements) {
            char d = '\u0000';
            int e = 0;
            while (e < 2) {
                d = (char)(d | (source[sourceOffset + (i * 2 + e)] & 0xFF) << 2 * e);
                ++e;
            }
            dest[i] = d;
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue byte[] source, int sourceOffset, @WritableValue short[] dest, int destOffset, int lengthInLargerDestElements) {
        int ratio = 2;
        int i = 0;
        while (i < lengthInLargerDestElements) {
            short d = 0;
            int e = 0;
            while (e < 2) {
                d = (short)(d | (source[sourceOffset + (i * 2 + e)] & 0xFF) << 2 * e);
                ++e;
            }
            dest[i] = d;
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue byte[] source, int sourceOffset, @WritableValue int[] dest, int destOffset, int lengthInLargerDestElements) {
        int ratio = 4;
        int i = 0;
        while (i < lengthInLargerDestElements) {
            int d = 0;
            int e = 0;
            while (e < 4) {
                d |= (source[sourceOffset + (i * 4 + e)] & 0xFF) << 4 * e;
                ++e;
            }
            dest[i] = d;
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue byte[] source, int sourceOffset, @WritableValue long[] dest, int destOffset, int lengthInLargerDestElements) {
        int ratio = 8;
        int i = 0;
        while (i < lengthInLargerDestElements) {
            long d = 0L;
            int e = 0;
            while (e < 8) {
                d |= (long)((source[sourceOffset + (i * 8 + e)] & 0xFF) << 8 * e);
                ++e;
            }
            dest[i] = d;
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue char[] source, int sourceOffset, @WritableValue byte[] dest, int destOffset, int lengthInLargerSourceElements) {
        int ratio = 2;
        int i = 0;
        while (i < lengthInLargerSourceElements) {
            char s = source[sourceOffset + i];
            int e = 0;
            while (e < 2) {
                dest[i * 2 + e] = (byte)((s & 255 << 2 * e) >>> 2 * e);
                ++e;
            }
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue char[] source, int sourceOffset, @WritableValue char[] dest, int destOffset, int lengthInEqualSizeElements) {
        System.arraycopy(source, sourceOffset, dest, destOffset, lengthInEqualSizeElements);
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue char[] source, int sourceOffset, @WritableValue short[] dest, int destOffset, int lengthInEqualSizeElements) {
        System.arraycopy(source, sourceOffset, dest, destOffset, lengthInEqualSizeElements);
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue char[] source, int sourceOffset, @WritableValue int[] dest, int destOffset, int lengthInLargerDestElements) {
        int ratio = 2;
        int i = 0;
        while (i < lengthInLargerDestElements) {
            int d = 0;
            int e = 0;
            while (e < 2) {
                d |= (source[sourceOffset + (i * 2 + e)] & 0xFFFF) << 2 * e;
                ++e;
            }
            dest[i] = d;
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue char[] source, int sourceOffset, @WritableValue long[] dest, int destOffset, int lengthInLargerDestElements) {
        int ratio = 4;
        int i = 0;
        while (i < lengthInLargerDestElements) {
            long d = 0L;
            int e = 0;
            while (e < 4) {
                d |= (long)((source[sourceOffset + (i * 4 + e)] & 0xFFFF) << 4 * e);
                ++e;
            }
            dest[i] = d;
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue short[] source, int sourceOffset, @WritableValue byte[] dest, int destOffset, int lengthInLargerSourceElements) {
        int ratio = 2;
        int i = 0;
        while (i < lengthInLargerSourceElements) {
            short s = source[sourceOffset + i];
            int e = 0;
            while (e < 2) {
                dest[i * 2 + e] = (byte)((s & 255 << 2 * e) >>> 2 * e);
                ++e;
            }
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue short[] source, int sourceOffset, @WritableValue char[] dest, int destOffset, int lengthInEqualSizeElements) {
        System.arraycopy(source, sourceOffset, dest, destOffset, lengthInEqualSizeElements);
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue short[] source, int sourceOffset, @WritableValue short[] dest, int destOffset, int lengthInEqualSizeElements) {
        System.arraycopy(source, sourceOffset, dest, destOffset, lengthInEqualSizeElements);
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue short[] source, int sourceOffset, @WritableValue int[] dest, int destOffset, int lengthInLargerDestElements) {
        int ratio = 2;
        int i = 0;
        while (i < lengthInLargerDestElements) {
            int d = 0;
            int e = 0;
            while (e < 2) {
                d |= (source[sourceOffset + (i * 2 + e)] & 0xFFFF) << 2 * e;
                ++e;
            }
            dest[i] = d;
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue short[] source, int sourceOffset, @WritableValue long[] dest, int destOffset, int lengthInLargerDestElements) {
        int ratio = 4;
        int i = 0;
        while (i < lengthInLargerDestElements) {
            long d = 0L;
            int e = 0;
            while (e < 4) {
                d |= (long)((source[sourceOffset + (i * 4 + e)] & 0xFFFF) << 4 * e);
                ++e;
            }
            dest[i] = d;
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue int[] source, int sourceOffset, @WritableValue byte[] dest, int destOffset, int lengthInLargerSourceElements) {
        int ratio = 4;
        int i = 0;
        while (i < lengthInLargerSourceElements) {
            int s = source[sourceOffset + i];
            int e = 0;
            while (e < 4) {
                dest[i * 4 + e] = (byte)((s & 255 << 4 * e) >>> 4 * e);
                ++e;
            }
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue int[] source, int sourceOffset, @WritableValue char[] dest, int destOffset, int lengthInLargerSourceElements) {
        int ratio = 2;
        int i = 0;
        while (i < lengthInLargerSourceElements) {
            int s = source[sourceOffset + i];
            int e = 0;
            while (e < 2) {
                dest[i * 2 + e] = (char)((s & 65535 << 2 * e) >>> 2 * e);
                ++e;
            }
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue int[] source, int sourceOffset, @WritableValue short[] dest, int destOffset, int lengthInLargerSourceElements) {
        int ratio = 2;
        int i = 0;
        while (i < lengthInLargerSourceElements) {
            int s = source[sourceOffset + i];
            int e = 0;
            while (e < 2) {
                dest[i * 2 + e] = (short)((s & 65535 << 2 * e) >>> 2 * e);
                ++e;
            }
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue int[] source, int sourceOffset, @WritableValue int[] dest, int destOffset, int lengthInEqualSizeElements) {
        System.arraycopy(source, sourceOffset, dest, destOffset, lengthInEqualSizeElements);
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue int[] source, int sourceOffset, @WritableValue long[] dest, int destOffset, int lengthInLargerDestElements) {
        int ratio = 2;
        int i = 0;
        while (i < lengthInLargerDestElements) {
            long d = 0L;
            int e = 0;
            while (e < 2) {
                int cfr_ignored_0 = source[sourceOffset + (i * 2 + e)];
                d |= (long)(0 << 2 * e);
                ++e;
            }
            dest[i] = d;
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue long[] source, int sourceOffset, @WritableValue byte[] dest, int destOffset, int lengthInLargerSourceElements) {
        int ratio = 8;
        int i = 0;
        while (i < lengthInLargerSourceElements) {
            long s = source[sourceOffset + i];
            int e = 0;
            while (e < 8) {
                dest[i * 8 + e] = (byte)((s & (long)(255 << 8 * e)) >>> 8 * e);
                ++e;
            }
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue long[] source, int sourceOffset, @WritableValue char[] dest, int destOffset, int lengthInLargerSourceElements) {
        int ratio = 4;
        int i = 0;
        while (i < lengthInLargerSourceElements) {
            long s = source[sourceOffset + i];
            int e = 0;
            while (e < 4) {
                dest[i * 4 + e] = (char)((s & (long)(65535 << 4 * e)) >>> 4 * e);
                ++e;
            }
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue long[] source, int sourceOffset, @WritableValue short[] dest, int destOffset, int lengthInLargerSourceElements) {
        int ratio = 4;
        int i = 0;
        while (i < lengthInLargerSourceElements) {
            long s = source[sourceOffset + i];
            int e = 0;
            while (e < 4) {
                dest[i * 4 + e] = (short)((s & (long)(65535 << 4 * e)) >>> 4 * e);
                ++e;
            }
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue long[] source, int sourceOffset, @WritableValue int[] dest, int destOffset, int lengthInLargerSourceElements) {
        int ratio = 2;
        int i = 0;
        while (i < lengthInLargerSourceElements) {
            long s = source[sourceOffset + i];
            int e = 0;
            while (e < 2) {
                dest[i * 2 + e] = (int)((s & (long)(0 << 2 * e)) >>> 2 * e);
                ++e;
            }
            ++i;
        }
    }

    public static void copyExactlyBetweenJavaBitfieldArrays(@ReadonlyValue long[] source, int sourceOffset, @WritableValue long[] dest, int destOffset, int lengthInEqualSizeElements) {
        System.arraycopy(source, sourceOffset, dest, destOffset, lengthInEqualSizeElements);
    }

    public static boolean[] toBooleanArrayFrom8(byte bits32, int numBits) {
        if (numBits < 0) {
            throw new OverflowException();
        }
        if (numBits > 8) {
            throw new OverflowException();
        }
        boolean[] bits = new boolean[numBits];
        int i = 0;
        while (i < numBits) {
            bits[i] = (bits32 & 1 << i) != 0;
            ++i;
        }
        return bits;
    }

    public static boolean[] toBooleanArrayFrom16(short bits32, int numBits) {
        if (numBits < 0) {
            throw new OverflowException();
        }
        if (numBits > 16) {
            throw new OverflowException();
        }
        boolean[] bits = new boolean[numBits];
        int i = 0;
        while (i < numBits) {
            bits[i] = (bits32 & 1 << i) != 0;
            ++i;
        }
        return bits;
    }

    public static boolean[] toBooleanArrayFrom32(int bits32, int numBits) {
        if (numBits < 0) {
            throw new OverflowException();
        }
        if (numBits > 32) {
            throw new OverflowException();
        }
        boolean[] bits = new boolean[numBits];
        int i = 0;
        while (i < numBits) {
            bits[i] = (bits32 & 1 << i) != 0;
            ++i;
        }
        return bits;
    }

    public static boolean[] toBooleanArrayFrom64(long bits64, int numBits) {
        if (numBits < 0) {
            throw new OverflowException();
        }
        if (numBits > 64) {
            throw new OverflowException();
        }
        boolean[] bits = new boolean[numBits];
        int i = 0;
        while (i < numBits) {
            bits[i] = (bits64 & 1L << i) != 0L;
            ++i;
        }
        return bits;
    }

    public static boolean[] toBooleanArray8(byte bits8) {
        return BitUtilities.toBooleanArrayFrom64(bits8, 8);
    }

    public static boolean[] toBooleanArray16(short bits16) {
        return BitUtilities.toBooleanArrayFrom64(bits16, 16);
    }

    public static boolean[] toBooleanArray32(int bits32) {
        return BitUtilities.toBooleanArrayFrom64(bits32, 32);
    }

    public static boolean[] toBooleanArray64(long bits64) {
        return BitUtilities.toBooleanArrayFrom64(bits64, 64);
    }

    public static boolean isPowerOf2(int x) {
        int m = x - 1;
        return (x & m) == 0;
    }

    public static boolean isPowerOf2(long x) {
        long m = x - 1L;
        return (x & m) == 0L;
    }

    public static int signedUpcast24(int x) {
        int m = -16777216;
        int bit = x >> 23 & 1;
        return x | m * bit;
    }

    public static long signedUpcast40(long x) {
        long m = -1099511627776L;
        long bit = x >> 39 & 1L;
        return x | m * bit;
    }

    public static long signedUpcast48(long x) {
        long m = -281474976710656L;
        long bit = x >> 47 & 1L;
        return x | m * bit;
    }

    public static long signedUpcast56(long x) {
        long m = -72057594037927936L;
        long bit = x >> 55 & 1L;
        return x | m * bit;
    }
}

