/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.functional;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.reachability.EscapesVarargs;
import rebound.annotations.semantic.reachability.LiveValue;
import rebound.annotations.semantic.reachability.NotEscapedVarargs;
import rebound.annotations.semantic.reachability.PossiblySnapshotPossiblyLiveValue;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.annotations.semantic.temporal.ConstantReturnValue;
import rebound.exceptions.NoSuchMemberRuntimeException;
import rebound.exceptions.NotYetImplementedException;
import rebound.exceptions.OverflowException;
import rebound.exceptions.UnreachableCodeException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.math.SmallIntegerMathUtilities;
import rebound.testing.WidespreadTestingUtilities;
import rebound.util.AngryReflectionUtility;
import rebound.util.BasicExceptionUtilities;
import rebound.util.ExceptionUtilities;
import rebound.util.collections.ArrayUtilities;
import rebound.util.functional.ComparatorWithEquality;
import rebound.util.functional.EqualityComparator;
import rebound.util.functional.EqualityFromComparison;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.functional.NoopRunnable;
import rebound.util.functional.functions.DefaultEqualityComparator;
import rebound.util.functional.functions.IdentityFunction;
import rebound.util.functional.predicates.AlwaysFalsePredicate;
import rebound.util.functional.predicates.AlwaysTruePredicate;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.JavaNamespace;
import rebound.util.objectutil.StrictReferenceIdentityEqualityComparator;

public class FunctionalUtilities
implements JavaNamespace {
    public static final Predicate AlwaysTrue = AlwaysTruePredicate.I;
    public static final Predicate AlwaysFalse = AlwaysFalsePredicate.I;
    public static final FunctionInterfaces.UnaryFunction<?, ?> Identity = IdentityFunction.I;
    public static final Runnable NoopNullaryProcedure = NoopRunnable.I;
    protected static final Map<Class, MethodHandle> AccumulatedCacheOfSuccessfulMethodHandlesOfDiscoveredSingleFunctionInterfaces = new HashMap<Class, MethodHandle>();
    protected static final MethodHandle Runnable_run = FunctionalUtilities.lookupInstanceNonoverloadedMethod(Runnable.class, "run");

    public static <E> EqualityComparator<E> equalityFromComparison(Comparator<E> comparison) {
        if (comparison == Comparator.naturalOrder()) {
            return DefaultEqualityComparator.I;
        }
        if (ComparatorWithEquality.is(comparison)) {
            return ((ComparatorWithEquality)comparison).equalityComparator();
        }
        WidespreadTestingUtilities.asrt(Comparator.naturalOrder() == Comparator.naturalOrder());
        return new EqualityFromComparison<E>(comparison);
    }

    public static <E> FunctionInterfaces.NullaryFunction<E> cacher(final FunctionInterfaces.NullaryFunction<E> compute) {
        return new FunctionInterfaces.NullaryFunction<E>(){
            boolean cached = false;
            E cache;

            @Override
            public E f() {
                if (this.cached) {
                    return this.cache;
                }
                Object c = compute.f();
                this.cache = c;
                return c;
            }
        };
    }

    public static Runnable methodHandleToFunctionalInterfaceForNullaryProcedure(MethodHandle h) {
        return () -> {
            try {
                h.invokeExact();
            }
            catch (Throwable t) {
                throw new WrappedThrowableRuntimeException(t);
            }
        };
    }

    public static FunctionInterfaces.NullaryFunction methodHandleToFunctionalInterfaceForNullaryFunction(MethodHandle h) {
        return () -> {
            try {
                return h.invokeExact();
            }
            catch (Throwable t) {
                throw new WrappedThrowableRuntimeException(t);
            }
        };
    }

    public static FunctionInterfaces.UnaryProcedure objectAcceptingMethodHandleToFunctionalInterfaceForUnaryProcedure(MethodHandle h) {
        return i -> {
            try {
                h.invokeExact(i);
            }
            catch (Throwable t) {
                throw new WrappedThrowableRuntimeException(t);
            }
        };
    }

    public static FunctionInterfaces.UnaryFunction objectAcceptingMethodHandleToFunctionalInterfaceForUnaryFunction(MethodHandle h) {
        return i -> {
            try {
                return h.invokeExact(i);
            }
            catch (Throwable t) {
                throw new WrappedThrowableRuntimeException(t);
            }
        };
    }

    public static FunctionInterfaces.UnaryProcedure objectOrPrimitiveAcceptingMethodHandleToFunctionalInterfaceForUnaryProcedure(MethodHandle h) {
        return i -> {
            try {
                h.invoke(i);
            }
            catch (Throwable t) {
                throw new WrappedThrowableRuntimeException(t);
            }
        };
    }

    public static FunctionInterfaces.UnaryFunction objectOrPrimitiveAcceptingMethodHandleToFunctionalInterfaceForUnaryFunction(MethodHandle h) {
        return i -> {
            try {
                return h.invoke(i);
            }
            catch (Throwable t) {
                throw new WrappedThrowableRuntimeException(t);
            }
        };
    }

    public static <E, S1 extends E, S2 extends E> E altnull(S1 value, S2 alternate) {
        return (E)(value != null ? value : alternate);
    }

    public static <E> FunctionInterfaces.UnaryProcedure<E> wrapInRepeater(final ConvergentInPlaceOperationSinglePass<E> singlePassProcedure) {
        return new FunctionInterfaces.UnaryProcedure<E>(){

            @Override
            public void f(E input) {
                while (singlePassProcedure.f(input)) {
                }
            }
        };
    }

    public static Predicate<Object> instanceOfFunction(final Class cls) {
        return new Predicate<Object>(){

            @Override
            public boolean test(Object input) {
                return cls.isInstance(input);
            }
        };
    }

    public static <E> Predicate<E> equalsPattern(Object matcher) {
        return new SingletonObjectEqualityPredicate<Object>(matcher);
    }

    public static <E> Predicate<E> equalsPattern(Object matcher, EqualityComparator equalityComparator) {
        if (equalityComparator instanceof StrictReferenceIdentityEqualityComparator) {
            return FunctionalUtilities.identityPattern(matcher);
        }
        return new SingletonObjectEqualityPredicate<Object>(matcher, equalityComparator);
    }

    public static <E> Predicate<E> identityPattern(Object matcher) {
        return new SingletonObjectIdentityEqualityPredicate<Object>(matcher);
    }

    public static int getNumberOfParameters(Object function) {
        throw new NotYetImplementedException();
    }

    public static Object apply(Object function, Object ... inputs) {
        throw new NotYetImplementedException();
    }

    public static Object lookupAndApplyNonoverloadedInstanceMethod(Object self, String instanceMethodName, Object ... arguments) throws OverloadedMethodException, NoSuchMemberRuntimeException {
        MethodHandle unpartialled = FunctionalUtilities.lookupVirtualNonoverloadedMethodOnObject(self, instanceMethodName);
        MethodHandle partialled = unpartialled.bindTo(self);
        try {
            return partialled.invokeWithArguments(arguments);
        }
        catch (Throwable exc) {
            ExceptionUtilities.throwGeneralThrowableAttemptingUnverifiedThrow(exc);
            throw new UnreachableCodeException();
        }
    }

    @Nonnull
    public static MethodHandle lookupVirtualNonoverloadedMethodOnObject(Object self, String instanceMethodName) throws OverloadedMethodException, NoSuchMemberRuntimeException {
        if (self == null) {
            throw new NoSuchMemberRuntimeException("Null's 'class' has no methods or any members >,>  xD");
        }
        Method theMethod = null;
        Method[] methodArray = self.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (!Modifier.isStatic(m.getModifiers()) && m.getName().equals(instanceMethodName)) {
                if (theMethod == null) {
                    theMethod = m;
                } else {
                    throw new OverloadedMethodException("<a " + self.getClass().getName() + ">." + instanceMethodName + "(*)");
                }
            }
            ++n2;
        }
        if (theMethod == null) {
            throw new NoSuchMemberRuntimeException();
        }
        try {
            return MethodHandles.publicLookup().unreflect(theMethod);
        }
        catch (IllegalAccessException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static Object lookupAndApplyNonoverloadedStaticMethod(Class namespace, String staticMethodName, Object ... arguments) throws OverloadedMethodException, NoSuchMemberRuntimeException {
        MethodHandle f = FunctionalUtilities.lookupStaticNonoverloadedMethod(namespace, staticMethodName);
        try {
            return f.invokeWithArguments(arguments);
        }
        catch (Throwable exc) {
            ExceptionUtilities.throwGeneralThrowableAttemptingUnverifiedThrow(exc);
            throw new UnreachableCodeException();
        }
    }

    @Nonnull
    public static MethodHandle lookupStaticNonoverloadedMethod(Class namespace, String staticMethodName) throws OverloadedMethodException, NoSuchMemberRuntimeException {
        if (namespace == null) {
            throw new NullPointerException();
        }
        if ("<init>".equals(staticMethodName)) {
            Constructor<?>[] constructors = namespace.getConstructors();
            if (constructors.length == 0) {
                throw new NoSuchMemberRuntimeException();
            }
            if (constructors.length > 1) {
                throw new OverloadedMethodException("more than one <init> (constructor)!");
            }
            try {
                return MethodHandles.publicLookup().unreflectConstructor(constructors[0]);
            }
            catch (IllegalAccessException exc) {
                throw new WrappedThrowableRuntimeException(exc);
            }
        }
        Method theMethod = null;
        Method[] methodArray = namespace.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers()) && m.getName().equals(staticMethodName)) {
                if (theMethod == null) {
                    theMethod = m;
                } else {
                    throw new OverloadedMethodException("static " + namespace.getName() + "." + staticMethodName + "(*)");
                }
            }
            ++n2;
        }
        if (theMethod == null) {
            throw new NoSuchMemberRuntimeException();
        }
        try {
            return MethodHandles.publicLookup().unreflect(theMethod);
        }
        catch (IllegalAccessException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    @Nonnull
    public static MethodHandle lookupInstanceNonoverloadedMethod(Class namespace, String instanceMethodName) throws OverloadedMethodException, NoSuchMemberRuntimeException {
        if (namespace == null) {
            throw new NullPointerException();
        }
        Method theMethod = null;
        Method[] methodArray = namespace.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (!Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers()) && m.getName().equals(instanceMethodName)) {
                if (theMethod == null) {
                    theMethod = m;
                } else {
                    throw new OverloadedMethodException(String.valueOf(namespace.getName()) + "." + instanceMethodName + "(*)");
                }
            }
            ++n2;
        }
        if (theMethod == null) {
            throw new NoSuchMemberRuntimeException();
        }
        try {
            return MethodHandles.publicLookup().unreflect(theMethod);
        }
        catch (IllegalAccessException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    @Nonnull
    public static MethodHandle mh(Class namespace, String methodName) throws OverloadedMethodException, NoSuchMemberRuntimeException {
        if (namespace == null) {
            throw new NullPointerException();
        }
        Method theMethod = null;
        Method[] methodArray = namespace.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(methodName)) {
                if (theMethod == null) {
                    theMethod = m;
                } else {
                    throw new OverloadedMethodException(String.valueOf(namespace.getName()) + "." + methodName + "(*)");
                }
            }
            ++n2;
        }
        if (theMethod == null) {
            throw new NoSuchMemberRuntimeException();
        }
        try {
            return MethodHandles.publicLookup().unreflect(theMethod);
        }
        catch (IllegalAccessException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    @Nonnull
    public static MethodHandle mh(Member m) {
        try {
            if (m instanceof Method) {
                return MethodHandles.publicLookup().unreflect((Method)m);
            }
            if (m instanceof Constructor) {
                return MethodHandles.publicLookup().unreflectConstructor((Constructor)m);
            }
            if (m instanceof Field) {
                return MethodHandles.publicLookup().unreflectGetter((Field)m);
            }
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(m);
        }
        catch (IllegalAccessException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static Method findSingleFunctionInSingleFunctionInterface(Class interfaceClass) {
        if (!interfaceClass.isInterface()) {
            return null;
        }
        Method theOnlyNonObjectMethod = null;
        Method[] methodArray = interfaceClass.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Object[] parameterTypes = m.getParameterTypes();
            boolean overridesAnObjectMethod = false;
            Method[] methodArray2 = Object.class.getDeclaredMethods();
            int n3 = methodArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Method objectMethod = methodArray2[n4];
                if (m.getName().equals(objectMethod.getName()) && Arrays.equals(parameterTypes, objectMethod.getParameterTypes())) {
                    overridesAnObjectMethod = true;
                    break;
                }
                ++n4;
            }
            if (!overridesAnObjectMethod) {
                if (theOnlyNonObjectMethod == null) {
                    theOnlyNonObjectMethod = m;
                } else {
                    return null;
                }
            }
            ++n2;
        }
        return theOnlyNonObjectMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodHandle getUnboundMethodHandleForSingleFunctionInterface(Object instanceOfSingleFunctionInterface) throws NoSuchMemberRuntimeException {
        if (instanceOfSingleFunctionInterface == null) {
            throw new NoSuchMemberRuntimeException("null type doesn't implement any interfaces of course! XD");
        }
        if (instanceOfSingleFunctionInterface instanceof ProvidesPrimaryMethodHandle) {
            return ((ProvidesPrimaryMethodHandle)instanceOfSingleFunctionInterface).getUnboundMethodHandle();
        }
        if (instanceOfSingleFunctionInterface instanceof Runnable) {
            return Runnable_run;
        }
        Class<?> runtimeClass = instanceOfSingleFunctionInterface.getClass();
        Map<Class, MethodHandle> map = AccumulatedCacheOfSuccessfulMethodHandlesOfDiscoveredSingleFunctionInterfaces;
        synchronized (map) {
            MethodHandle h = AccumulatedCacheOfSuccessfulMethodHandlesOfDiscoveredSingleFunctionInterfaces.get(runtimeClass);
            if (h != null) {
                return h;
            }
            Set<Class> allInterfaces = AngryReflectionUtility.getAllInterfaces(runtimeClass);
            for (Class implementedInterfaceClass : allInterfaces) {
                MethodHandle h2 = AccumulatedCacheOfSuccessfulMethodHandlesOfDiscoveredSingleFunctionInterfaces.get(implementedInterfaceClass);
                if (h2 == null) continue;
                AccumulatedCacheOfSuccessfulMethodHandlesOfDiscoveredSingleFunctionInterfaces.put(runtimeClass, h2);
                return h2;
            }
            Method theOneOneMethod = null;
            MethodHandle theOneOneMethodHandle = null;
            for (Class implementedInterfaceClass : allInterfaces) {
                Method m = FunctionalUtilities.findSingleFunctionInSingleFunctionInterface(implementedInterfaceClass);
                if (m == null) continue;
                MethodHandle h3 = FunctionalUtilities.mh(m);
                AccumulatedCacheOfSuccessfulMethodHandlesOfDiscoveredSingleFunctionInterfaces.put(implementedInterfaceClass, h3);
                if (theOneOneMethod == null) {
                    theOneOneMethod = m;
                    theOneOneMethodHandle = h3;
                    continue;
                }
                if (m.getName().equals(theOneOneMethod.getName()) && Arrays.equals(m.getParameterTypes(), theOneOneMethod.getParameterTypes())) continue;
                throw new NoSuchMemberRuntimeException(runtimeClass + " implements more than one incompatible single-function interface! ;_;");
            }
            if (theOneOneMethod == null) {
                throw new NoSuchMemberRuntimeException(runtimeClass + " implements no single-function interface ;_;");
            }
            AccumulatedCacheOfSuccessfulMethodHandlesOfDiscoveredSingleFunctionInterfaces.put(runtimeClass, theOneOneMethodHandle);
            return theOneOneMethodHandle;
        }
    }

    public static MethodHandle getBoundMethodHandleForSingleFunctionInterface(Object instanceOfSingleFunctionInterface) throws NoSuchMemberRuntimeException {
        if (instanceOfSingleFunctionInterface == null) {
            throw new NullPointerException();
        }
        if (instanceOfSingleFunctionInterface instanceof ProvidesPrimaryMethodHandle) {
            return ((ProvidesPrimaryMethodHandle)instanceOfSingleFunctionInterface).getBoundMethodHandle();
        }
        MethodHandle h = FunctionalUtilities.getUnboundMethodHandleForSingleFunctionInterface(instanceOfSingleFunctionInterface);
        return h.bindTo(instanceOfSingleFunctionInterface);
    }

    public static interface AccessibleBooleanSetPredicate
    extends FunctionInterfaces.UnaryFunctionBooleanToBoolean {
        @PossiblySnapshotPossiblyLiveValue
        @ReadonlyValue
        public boolean[] getDefiningSetAsPOSSIBLYLIVEArray();

        @ThrowAwayValue
        public boolean[] getDefiningSetAsThrowawayArray();
    }

    public static interface AccessibleBooleanSingleonPredicate
    extends FunctionInterfaces.UnaryFunctionBooleanToBoolean,
    AccessibleBooleanSetPredicate {
        public boolean getTarget();

        @Override
        @ThrowAwayValue
        default public boolean[] getDefiningSetAsThrowawayArray() {
            return new boolean[]{this.getTarget()};
        }
    }

    public static interface AccessibleByteSetPredicate
    extends FunctionInterfaces.UnaryFunctionByteToBoolean {
        @PossiblySnapshotPossiblyLiveValue
        @ReadonlyValue
        public byte[] getDefiningSetAsPOSSIBLYLIVEArray();

        @ThrowAwayValue
        public byte[] getDefiningSetAsThrowawayArray();
    }

    public static interface AccessibleByteSingleonPredicate
    extends FunctionInterfaces.UnaryFunctionByteToBoolean,
    AccessibleByteSetPredicate {
        public byte getTarget();

        @Override
        @ThrowAwayValue
        default public byte[] getDefiningSetAsThrowawayArray() {
            return new byte[]{this.getTarget()};
        }
    }

    public static interface AccessibleCharSetPredicate
    extends FunctionInterfaces.UnaryFunctionCharToBoolean {
        @PossiblySnapshotPossiblyLiveValue
        @ReadonlyValue
        public char[] getDefiningSetAsPOSSIBLYLIVEArray();

        @ThrowAwayValue
        public char[] getDefiningSetAsThrowawayArray();
    }

    public static interface AccessibleCharSingleonPredicate
    extends FunctionInterfaces.UnaryFunctionCharToBoolean,
    AccessibleCharSetPredicate {
        public char getTarget();

        @Override
        @ThrowAwayValue
        default public char[] getDefiningSetAsThrowawayArray() {
            return new char[]{this.getTarget()};
        }
    }

    public static interface AccessibleDoubleSetPredicate
    extends FunctionInterfaces.UnaryFunctionDoubleToBoolean {
        @PossiblySnapshotPossiblyLiveValue
        @ReadonlyValue
        public double[] getDefiningSetAsPOSSIBLYLIVEArray();

        @ThrowAwayValue
        public double[] getDefiningSetAsThrowawayArray();
    }

    public static interface AccessibleDoubleSingleonPredicate
    extends FunctionInterfaces.UnaryFunctionDoubleToBoolean,
    AccessibleDoubleSetPredicate {
        public double getTarget();

        @Override
        @ThrowAwayValue
        default public double[] getDefiningSetAsThrowawayArray() {
            return new double[]{this.getTarget()};
        }
    }

    public static interface AccessibleFloatSetPredicate
    extends FunctionInterfaces.UnaryFunctionFloatToBoolean {
        @PossiblySnapshotPossiblyLiveValue
        @ReadonlyValue
        public float[] getDefiningSetAsPOSSIBLYLIVEArray();

        @ThrowAwayValue
        public float[] getDefiningSetAsThrowawayArray();
    }

    public static interface AccessibleFloatSingleonPredicate
    extends FunctionInterfaces.UnaryFunctionFloatToBoolean,
    AccessibleFloatSetPredicate {
        public float getTarget();

        @Override
        @ThrowAwayValue
        default public float[] getDefiningSetAsThrowawayArray() {
            return new float[]{this.getTarget()};
        }
    }

    public static interface AccessibleIntSetPredicate
    extends FunctionInterfaces.UnaryFunctionIntToBoolean {
        @PossiblySnapshotPossiblyLiveValue
        @ReadonlyValue
        public int[] getDefiningSetAsPOSSIBLYLIVEArray();

        @ThrowAwayValue
        public int[] getDefiningSetAsThrowawayArray();
    }

    public static interface AccessibleIntSingleonPredicate
    extends FunctionInterfaces.UnaryFunctionIntToBoolean,
    AccessibleIntSetPredicate {
        public int getTarget();

        @Override
        @ThrowAwayValue
        default public int[] getDefiningSetAsThrowawayArray() {
            return new int[]{this.getTarget()};
        }
    }

    public static interface AccessibleLongSetPredicate
    extends FunctionInterfaces.UnaryFunctionLongToBoolean {
        @PossiblySnapshotPossiblyLiveValue
        @ReadonlyValue
        public long[] getDefiningSetAsPOSSIBLYLIVEArray();

        @ThrowAwayValue
        public long[] getDefiningSetAsThrowawayArray();
    }

    public static interface AccessibleLongSingleonPredicate
    extends FunctionInterfaces.UnaryFunctionLongToBoolean,
    AccessibleLongSetPredicate {
        public long getTarget();

        @Override
        @ThrowAwayValue
        default public long[] getDefiningSetAsThrowawayArray() {
            return new long[]{this.getTarget()};
        }
    }

    public static interface AccessibleShortSetPredicate
    extends FunctionInterfaces.UnaryFunctionShortToBoolean {
        @PossiblySnapshotPossiblyLiveValue
        @ReadonlyValue
        public short[] getDefiningSetAsPOSSIBLYLIVEArray();

        @ThrowAwayValue
        public short[] getDefiningSetAsThrowawayArray();
    }

    public static interface AccessibleShortSingleonPredicate
    extends FunctionInterfaces.UnaryFunctionShortToBoolean,
    AccessibleShortSetPredicate {
        public short getTarget();

        @Override
        @ThrowAwayValue
        default public short[] getDefiningSetAsThrowawayArray() {
            return new short[]{this.getTarget()};
        }
    }

    public static interface ConvergentInPlaceOperationSinglePass<E> {
        public boolean f(E var1);
    }

    public static class ExhaustiveByteHitMapPredicate
    implements AccessibleByteSetPredicate {
        protected final boolean[] hitMap;
        protected final int hitMapLogicalStart;
        protected transient byte[] definingSet = null;

        @NotEscapedVarargs
        public ExhaustiveByteHitMapPredicate(byte ... targets) {
            if (targets.length == 0) {
                this.hitMap = ArrayUtilities.EmptyBooleanArray;
                this.hitMapLogicalStart = 0;
            } else {
                byte min = SmallIntegerMathUtilities.least(targets);
                byte max = SmallIntegerMathUtilities.greatest(targets);
                int count = max - min + 1;
                if (count < 0) {
                    throw new OverflowException();
                }
                this.hitMap = new boolean[count];
                this.hitMapLogicalStart = min;
                byte[] byArray = targets;
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    byte target = byArray[n2];
                    this.hitMap[target - this.hitMapLogicalStart] = true;
                    ++n2;
                }
            }
        }

        public ExhaustiveByteHitMapPredicate(boolean[] hitMap, byte hitMapLogicalStart) {
            this.hitMap = hitMap;
            this.hitMapLogicalStart = hitMapLogicalStart;
        }

        @ThrowAwayValue
        public boolean[] getHitMapClone() {
            return (boolean[])this.hitMap.clone();
        }

        @LiveValue
        public boolean[] getHitMapLIVE() {
            return this.hitMap;
        }

        public byte getHitMapLogicalStart() {
            return (byte)this.hitMapLogicalStart;
        }

        @Override
        public boolean f(byte input) {
            int hitMapLogicalStart = this.hitMapLogicalStart;
            int hitMapLength = this.hitMap.length;
            if (input < hitMapLogicalStart || input - hitMapLogicalStart >= hitMapLength) {
                return false;
            }
            return this.hitMap[input - hitMapLogicalStart];
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public byte[] getDefiningSetAsPOSSIBLYLIVEArray() {
            byte[] set = this.definingSet;
            if (set == null) {
                this.definingSet = set = this.makeDefiningSet();
            }
            return set;
        }

        @Override
        @ThrowAwayValue
        public byte[] getDefiningSetAsThrowawayArray() {
            byte[] set = this.definingSet;
            if (set == null) {
                return this.makeDefiningSet();
            }
            return set;
        }

        protected byte[] makeDefiningSet() {
            int hitMapLogicalStart = this.hitMapLogicalStart;
            int hitMapLength = this.hitMap.length;
            byte[] set = new byte[hitMapLength];
            int count = 0;
            int i = 0;
            while (i < hitMapLength) {
                if (this.hitMap[i]) {
                    set[count] = (byte)(hitMapLogicalStart + i);
                    ++count;
                }
                ++i;
            }
            if (count != hitMapLength) {
                byte[] newSet = new byte[count];
                System.arraycopy(set, 0, newSet, 0, count);
                set = newSet;
            }
            return set;
        }
    }

    public static class ExhaustiveCharHitMapPredicate
    implements AccessibleCharSetPredicate {
        protected final boolean[] hitMap;
        protected final int hitMapLogicalStart;
        protected transient char[] definingSet = null;

        @NotEscapedVarargs
        public ExhaustiveCharHitMapPredicate(char ... targets) {
            if (targets.length == 0) {
                this.hitMap = ArrayUtilities.EmptyBooleanArray;
                this.hitMapLogicalStart = 0;
            } else {
                char min = SmallIntegerMathUtilities.least(targets);
                char max = SmallIntegerMathUtilities.greatest(targets);
                int count = max - min + 1;
                if (count < 0) {
                    throw new OverflowException();
                }
                this.hitMap = new boolean[count];
                this.hitMapLogicalStart = min;
                char[] cArray = targets;
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    char target = cArray[n2];
                    this.hitMap[target - this.hitMapLogicalStart] = true;
                    ++n2;
                }
            }
        }

        public ExhaustiveCharHitMapPredicate(boolean[] hitMap, char hitMapLogicalStart) {
            this.hitMap = hitMap;
            this.hitMapLogicalStart = hitMapLogicalStart;
        }

        @ThrowAwayValue
        public boolean[] getHitMapClone() {
            return (boolean[])this.hitMap.clone();
        }

        @LiveValue
        public boolean[] getHitMapLIVE() {
            return this.hitMap;
        }

        public char getHitMapLogicalStart() {
            return (char)this.hitMapLogicalStart;
        }

        @Override
        public boolean f(char input) {
            int hitMapLogicalStart = this.hitMapLogicalStart;
            int hitMapLength = this.hitMap.length;
            if (input < hitMapLogicalStart || input - hitMapLogicalStart >= hitMapLength) {
                return false;
            }
            return this.hitMap[input - hitMapLogicalStart];
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public char[] getDefiningSetAsPOSSIBLYLIVEArray() {
            char[] set = this.definingSet;
            if (set == null) {
                this.definingSet = set = this.makeDefiningSet();
            }
            return set;
        }

        @Override
        @ThrowAwayValue
        public char[] getDefiningSetAsThrowawayArray() {
            char[] set = this.definingSet;
            if (set == null) {
                return this.makeDefiningSet();
            }
            return set;
        }

        protected char[] makeDefiningSet() {
            int hitMapLogicalStart = this.hitMapLogicalStart;
            int hitMapLength = this.hitMap.length;
            char[] set = new char[hitMapLength];
            int count = 0;
            int i = 0;
            while (i < hitMapLength) {
                if (this.hitMap[i]) {
                    set[count] = (char)(hitMapLogicalStart + i);
                    ++count;
                }
                ++i;
            }
            if (count != hitMapLength) {
                char[] newSet = new char[count];
                System.arraycopy(set, 0, newSet, 0, count);
                set = newSet;
            }
            return set;
        }
    }

    public static class ExhaustiveIntHitMapPredicate
    implements AccessibleIntSetPredicate {
        protected final boolean[] hitMap;
        protected final int hitMapLogicalStart;
        protected transient int[] definingSet = null;

        @NotEscapedVarargs
        public ExhaustiveIntHitMapPredicate(int ... targets) {
            if (targets.length == 0) {
                this.hitMap = ArrayUtilities.EmptyBooleanArray;
                this.hitMapLogicalStart = 0;
            } else {
                int min = SmallIntegerMathUtilities.least(targets);
                int max = SmallIntegerMathUtilities.greatest(targets);
                int count = max - min + 1;
                if (count < 0) {
                    throw new OverflowException();
                }
                this.hitMap = new boolean[count];
                this.hitMapLogicalStart = min;
                int[] nArray = targets;
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    int target = nArray[n2];
                    this.hitMap[target - this.hitMapLogicalStart] = true;
                    ++n2;
                }
            }
        }

        public ExhaustiveIntHitMapPredicate(boolean[] hitMap, int hitMapLogicalStart) {
            this.hitMap = hitMap;
            this.hitMapLogicalStart = hitMapLogicalStart;
        }

        @ThrowAwayValue
        public boolean[] getHitMapClone() {
            return (boolean[])this.hitMap.clone();
        }

        @LiveValue
        public boolean[] getHitMapLIVE() {
            return this.hitMap;
        }

        public int getHitMapLogicalStart() {
            return this.hitMapLogicalStart;
        }

        @Override
        public boolean f(int input) {
            int hitMapLogicalStart = this.hitMapLogicalStart;
            int hitMapLength = this.hitMap.length;
            if (input < hitMapLogicalStart || input - hitMapLogicalStart >= hitMapLength) {
                return false;
            }
            return this.hitMap[input - hitMapLogicalStart];
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public int[] getDefiningSetAsPOSSIBLYLIVEArray() {
            int[] set = this.definingSet;
            if (set == null) {
                this.definingSet = set = this.makeDefiningSet();
            }
            return set;
        }

        @Override
        @ThrowAwayValue
        public int[] getDefiningSetAsThrowawayArray() {
            int[] set = this.definingSet;
            if (set == null) {
                return this.makeDefiningSet();
            }
            return set;
        }

        protected int[] makeDefiningSet() {
            int hitMapLogicalStart = this.hitMapLogicalStart;
            int hitMapLength = this.hitMap.length;
            int[] set = new int[hitMapLength];
            int count = 0;
            int i = 0;
            while (i < hitMapLength) {
                if (this.hitMap[i]) {
                    set[count] = hitMapLogicalStart + i;
                    ++count;
                }
                ++i;
            }
            if (count != hitMapLength) {
                int[] newSet = new int[count];
                System.arraycopy(set, 0, newSet, 0, count);
                set = newSet;
            }
            return set;
        }
    }

    public static class ExhaustiveLongHitMapPredicate
    implements AccessibleLongSetPredicate {
        protected final boolean[] hitMap;
        protected final long hitMapLogicalStart;
        protected transient long[] definingSet = null;

        @NotEscapedVarargs
        public ExhaustiveLongHitMapPredicate(long ... targets) {
            if (targets.length == 0) {
                this.hitMap = ArrayUtilities.EmptyBooleanArray;
                this.hitMapLogicalStart = 0L;
            } else {
                long min = SmallIntegerMathUtilities.least(targets);
                long max = SmallIntegerMathUtilities.greatest(targets);
                long count = max - min + 1L;
                if (count < 0L) {
                    throw new OverflowException();
                }
                if (count > Integer.MAX_VALUE) {
                    throw new OverflowException();
                }
                this.hitMap = new boolean[(int)count];
                this.hitMapLogicalStart = min;
                long[] lArray = targets;
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    long target = lArray[n2];
                    this.hitMap[(int)(target - this.hitMapLogicalStart)] = true;
                    ++n2;
                }
            }
        }

        public ExhaustiveLongHitMapPredicate(boolean[] hitMap, long hitMapLogicalStart) {
            this.hitMap = hitMap;
            this.hitMapLogicalStart = hitMapLogicalStart;
        }

        @ThrowAwayValue
        public boolean[] getHitMapClone() {
            return (boolean[])this.hitMap.clone();
        }

        @LiveValue
        public boolean[] getHitMapLIVE() {
            return this.hitMap;
        }

        public long getHitMapLogicalStart() {
            return this.hitMapLogicalStart;
        }

        @Override
        public boolean f(long input) {
            long hitMapLogicalStart = this.hitMapLogicalStart;
            int hitMapLength = this.hitMap.length;
            if (input < hitMapLogicalStart || input - hitMapLogicalStart >= (long)hitMapLength) {
                return false;
            }
            return this.hitMap[(int)(input - hitMapLogicalStart)];
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public long[] getDefiningSetAsPOSSIBLYLIVEArray() {
            long[] set = this.definingSet;
            if (set == null) {
                this.definingSet = set = this.makeDefiningSet();
            }
            return set;
        }

        @Override
        @ThrowAwayValue
        public long[] getDefiningSetAsThrowawayArray() {
            long[] set = this.definingSet;
            if (set == null) {
                return this.makeDefiningSet();
            }
            return set;
        }

        protected long[] makeDefiningSet() {
            long hitMapLogicalStart = this.hitMapLogicalStart;
            int hitMapLength = this.hitMap.length;
            long[] set = new long[hitMapLength];
            int count = 0;
            int i = 0;
            while (i < hitMapLength) {
                if (this.hitMap[i]) {
                    set[count] = hitMapLogicalStart + (long)i;
                    ++count;
                }
                ++i;
            }
            if (count != hitMapLength) {
                long[] newSet = new long[count];
                System.arraycopy(set, 0, newSet, 0, count);
                set = newSet;
            }
            return set;
        }
    }

    public static class ExhaustiveShortHitMapPredicate
    implements AccessibleShortSetPredicate {
        protected final boolean[] hitMap;
        protected final int hitMapLogicalStart;
        protected transient short[] definingSet = null;

        @NotEscapedVarargs
        public ExhaustiveShortHitMapPredicate(short ... targets) {
            if (targets.length == 0) {
                this.hitMap = ArrayUtilities.EmptyBooleanArray;
                this.hitMapLogicalStart = 0;
            } else {
                short min = SmallIntegerMathUtilities.least(targets);
                short max = SmallIntegerMathUtilities.greatest(targets);
                int count = max - min + 1;
                if (count < 0) {
                    throw new OverflowException();
                }
                this.hitMap = new boolean[count];
                this.hitMapLogicalStart = min;
                short[] sArray = targets;
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    short target = sArray[n2];
                    this.hitMap[target - this.hitMapLogicalStart] = true;
                    ++n2;
                }
            }
        }

        public ExhaustiveShortHitMapPredicate(boolean[] hitMap, short hitMapLogicalStart) {
            this.hitMap = hitMap;
            this.hitMapLogicalStart = hitMapLogicalStart;
        }

        @ThrowAwayValue
        public boolean[] getHitMapClone() {
            return (boolean[])this.hitMap.clone();
        }

        @LiveValue
        public boolean[] getHitMapLIVE() {
            return this.hitMap;
        }

        public short getHitMapLogicalStart() {
            return (short)this.hitMapLogicalStart;
        }

        @Override
        public boolean f(short input) {
            int hitMapLogicalStart = this.hitMapLogicalStart;
            int hitMapLength = this.hitMap.length;
            if (input < hitMapLogicalStart || input - hitMapLogicalStart >= hitMapLength) {
                return false;
            }
            return this.hitMap[input - hitMapLogicalStart];
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public short[] getDefiningSetAsPOSSIBLYLIVEArray() {
            short[] set = this.definingSet;
            if (set == null) {
                this.definingSet = set = this.makeDefiningSet();
            }
            return set;
        }

        @Override
        @ThrowAwayValue
        public short[] getDefiningSetAsThrowawayArray() {
            short[] set = this.definingSet;
            if (set == null) {
                return this.makeDefiningSet();
            }
            return set;
        }

        protected short[] makeDefiningSet() {
            int hitMapLogicalStart = this.hitMapLogicalStart;
            int hitMapLength = this.hitMap.length;
            short[] set = new short[hitMapLength];
            int count = 0;
            int i = 0;
            while (i < hitMapLength) {
                if (this.hitMap[i]) {
                    set[count] = (short)(hitMapLogicalStart + i);
                    ++count;
                }
                ++i;
            }
            if (count != hitMapLength) {
                short[] newSet = new short[count];
                System.arraycopy(set, 0, newSet, 0, count);
                set = newSet;
            }
            return set;
        }
    }

    public static class NaiveBooleanArraySearchPredicate
    implements AccessibleBooleanSetPredicate {
        protected final boolean[] targetArray;

        @EscapesVarargs
        public NaiveBooleanArraySearchPredicate(boolean ... targetArray) {
            this.targetArray = targetArray;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public boolean[] getDefiningSetAsPOSSIBLYLIVEArray() {
            return this.targetArray;
        }

        @Override
        @ThrowAwayValue
        public boolean[] getDefiningSetAsThrowawayArray() {
            return (boolean[])this.targetArray.clone();
        }

        @Override
        public boolean f(boolean input) {
            int targetArrayLength = this.targetArray.length;
            boolean[] targetArray = this.targetArray;
            int i = 0;
            while (i < targetArrayLength) {
                if (input == targetArray[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class NaiveByteArraySearchPredicate
    implements AccessibleByteSetPredicate {
        protected final byte[] targetArray;

        @EscapesVarargs
        public NaiveByteArraySearchPredicate(byte ... targetArray) {
            this.targetArray = targetArray;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public byte[] getDefiningSetAsPOSSIBLYLIVEArray() {
            return this.targetArray;
        }

        @Override
        @ThrowAwayValue
        public byte[] getDefiningSetAsThrowawayArray() {
            return (byte[])this.targetArray.clone();
        }

        @Override
        public boolean f(byte input) {
            int targetArrayLength = this.targetArray.length;
            byte[] targetArray = this.targetArray;
            int i = 0;
            while (i < targetArrayLength) {
                if (input == targetArray[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class NaiveCharArraySearchPredicate
    implements AccessibleCharSetPredicate {
        protected final char[] targetArray;

        @EscapesVarargs
        public NaiveCharArraySearchPredicate(char ... targetArray) {
            this.targetArray = targetArray;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public char[] getDefiningSetAsPOSSIBLYLIVEArray() {
            return this.targetArray;
        }

        @Override
        @ThrowAwayValue
        public char[] getDefiningSetAsThrowawayArray() {
            return (char[])this.targetArray.clone();
        }

        @Override
        public boolean f(char input) {
            int targetArrayLength = this.targetArray.length;
            char[] targetArray = this.targetArray;
            int i = 0;
            while (i < targetArrayLength) {
                if (input == targetArray[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class NaiveDoubleArraySearchPredicate
    implements AccessibleDoubleSetPredicate {
        protected final double[] targetArray;

        @EscapesVarargs
        public NaiveDoubleArraySearchPredicate(double ... targetArray) {
            this.targetArray = targetArray;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public double[] getDefiningSetAsPOSSIBLYLIVEArray() {
            return this.targetArray;
        }

        @Override
        @ThrowAwayValue
        public double[] getDefiningSetAsThrowawayArray() {
            return (double[])this.targetArray.clone();
        }

        @Override
        public boolean f(double input) {
            int targetArrayLength = this.targetArray.length;
            double[] targetArray = this.targetArray;
            int i = 0;
            while (i < targetArrayLength) {
                if (input == targetArray[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class NaiveFloatArraySearchPredicate
    implements AccessibleFloatSetPredicate {
        protected final float[] targetArray;

        @EscapesVarargs
        public NaiveFloatArraySearchPredicate(float ... targetArray) {
            this.targetArray = targetArray;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public float[] getDefiningSetAsPOSSIBLYLIVEArray() {
            return this.targetArray;
        }

        @Override
        @ThrowAwayValue
        public float[] getDefiningSetAsThrowawayArray() {
            return (float[])this.targetArray.clone();
        }

        @Override
        public boolean f(float input) {
            int targetArrayLength = this.targetArray.length;
            float[] targetArray = this.targetArray;
            int i = 0;
            while (i < targetArrayLength) {
                if (input == targetArray[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class NaiveIntArraySearchPredicate
    implements AccessibleIntSetPredicate {
        protected final int[] targetArray;

        @EscapesVarargs
        public NaiveIntArraySearchPredicate(int ... targetArray) {
            this.targetArray = targetArray;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public int[] getDefiningSetAsPOSSIBLYLIVEArray() {
            return this.targetArray;
        }

        @Override
        @ThrowAwayValue
        public int[] getDefiningSetAsThrowawayArray() {
            return (int[])this.targetArray.clone();
        }

        @Override
        public boolean f(int input) {
            int targetArrayLength = this.targetArray.length;
            int[] targetArray = this.targetArray;
            int i = 0;
            while (i < targetArrayLength) {
                if (input == targetArray[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class NaiveLongArraySearchPredicate
    implements AccessibleLongSetPredicate {
        protected final long[] targetArray;

        @EscapesVarargs
        public NaiveLongArraySearchPredicate(long ... targetArray) {
            this.targetArray = targetArray;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public long[] getDefiningSetAsPOSSIBLYLIVEArray() {
            return this.targetArray;
        }

        @Override
        @ThrowAwayValue
        public long[] getDefiningSetAsThrowawayArray() {
            return (long[])this.targetArray.clone();
        }

        @Override
        public boolean f(long input) {
            int targetArrayLength = this.targetArray.length;
            long[] targetArray = this.targetArray;
            int i = 0;
            while (i < targetArrayLength) {
                if (input == targetArray[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class NaiveObjectArrayIdentitySearchPredicate<Input>
    implements Predicate<Input> {
        protected final Input[] targetArray;

        @EscapesVarargs
        public NaiveObjectArrayIdentitySearchPredicate(Input ... targetArray) {
            this.targetArray = targetArray;
        }

        public Input[] getTargets() {
            return this.targetArray;
        }

        @Override
        public boolean test(Input input) {
            int targetArrayLength = this.targetArray.length;
            Input[] targetArray = this.targetArray;
            int i = 0;
            while (i < targetArrayLength) {
                if (input == targetArray[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class NaiveObjectArraySearchPredicate<Input>
    implements Predicate<Input> {
        protected final Input[] targetArray;
        protected final EqualityComparator<Input> equalityComparator;

        @EscapesVarargs
        public NaiveObjectArraySearchPredicate(EqualityComparator<Input> equalityComparator, Input ... targetArray) {
            this.targetArray = targetArray;
            this.equalityComparator = equalityComparator;
        }

        @EscapesVarargs
        public NaiveObjectArraySearchPredicate(Input ... targetArray) {
            this(BasicObjectUtilities.getNaturalEqualityComparator(), targetArray);
        }

        public Input[] getTargets() {
            return this.targetArray;
        }

        @Override
        public boolean test(Input input) {
            int targetArrayLength = this.targetArray.length;
            Input[] targetArray = this.targetArray;
            int i = 0;
            while (i < targetArrayLength) {
                if (this.equalityComparator.equals(input, targetArray[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class NaiveShortArraySearchPredicate
    implements AccessibleShortSetPredicate {
        protected final short[] targetArray;

        @EscapesVarargs
        public NaiveShortArraySearchPredicate(short ... targetArray) {
            this.targetArray = targetArray;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public short[] getDefiningSetAsPOSSIBLYLIVEArray() {
            return this.targetArray;
        }

        @Override
        @ThrowAwayValue
        public short[] getDefiningSetAsThrowawayArray() {
            return (short[])this.targetArray.clone();
        }

        @Override
        public boolean f(short input) {
            int targetArrayLength = this.targetArray.length;
            short[] targetArray = this.targetArray;
            int i = 0;
            while (i < targetArrayLength) {
                if (input == targetArray[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class OverloadedMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public OverloadedMethodException() {
        }

        public OverloadedMethodException(String message) {
            super(message);
        }

        public OverloadedMethodException(Throwable cause) {
            super(cause);
        }

        public OverloadedMethodException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface ProvidesPrimaryMethodHandle {
        @ConstantReturnValue
        public MethodHandle getUnboundMethodHandle();

        @ConstantReturnValue
        public MethodHandle getBoundMethodHandle();

        public static abstract class AbstractProvidesPrimaryMethodHandle
        implements ProvidesPrimaryMethodHandle {
            protected final MethodHandle boundPrimary = this.getUnboundMethodHandle().bindTo(this);

            @Override
            public MethodHandle getBoundMethodHandle() {
                return this.boundPrimary;
            }
        }
    }

    public static class SingletonBooleanEqualityPredicate
    implements AccessibleBooleanSingleonPredicate {
        protected final boolean target;
        protected transient boolean[] asArrayCache = null;

        public SingletonBooleanEqualityPredicate(boolean target) {
            this.target = target;
        }

        @Override
        public boolean getTarget() {
            return this.target;
        }

        @Override
        public boolean f(boolean input) {
            return input == this.target;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public boolean[] getDefiningSetAsPOSSIBLYLIVEArray() {
            boolean[] a = this.asArrayCache;
            if (a == null) {
                this.asArrayCache = a = new boolean[]{this.getTarget()};
            }
            return a;
        }
    }

    public static class SingletonByteEqualityPredicate
    implements AccessibleByteSingleonPredicate {
        protected final byte target;
        protected transient byte[] asArrayCache = null;

        public SingletonByteEqualityPredicate(byte target) {
            this.target = target;
        }

        @Override
        public byte getTarget() {
            return this.target;
        }

        @Override
        public boolean f(byte input) {
            return input == this.target;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public byte[] getDefiningSetAsPOSSIBLYLIVEArray() {
            byte[] a = this.asArrayCache;
            if (a == null) {
                this.asArrayCache = a = new byte[]{this.getTarget()};
            }
            return a;
        }
    }

    public static class SingletonCharEqualityPredicate
    implements AccessibleCharSingleonPredicate {
        protected final char target;
        protected transient char[] asArrayCache = null;

        public SingletonCharEqualityPredicate(char target) {
            this.target = target;
        }

        @Override
        public char getTarget() {
            return this.target;
        }

        @Override
        public boolean f(char input) {
            return input == this.target;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public char[] getDefiningSetAsPOSSIBLYLIVEArray() {
            char[] a = this.asArrayCache;
            if (a == null) {
                this.asArrayCache = a = new char[]{this.getTarget()};
            }
            return a;
        }
    }

    public static class SingletonDoubleEqualityPredicate
    implements AccessibleDoubleSingleonPredicate {
        protected final double target;
        protected transient double[] asArrayCache = null;

        public SingletonDoubleEqualityPredicate(double target) {
            this.target = target;
        }

        @Override
        public double getTarget() {
            return this.target;
        }

        @Override
        public boolean f(double input) {
            return input == this.target;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public double[] getDefiningSetAsPOSSIBLYLIVEArray() {
            double[] a = this.asArrayCache;
            if (a == null) {
                this.asArrayCache = a = new double[]{this.getTarget()};
            }
            return a;
        }
    }

    public static class SingletonFloatEqualityPredicate
    implements AccessibleFloatSingleonPredicate {
        protected final float target;
        protected transient float[] asArrayCache = null;

        public SingletonFloatEqualityPredicate(float target) {
            this.target = target;
        }

        @Override
        public float getTarget() {
            return this.target;
        }

        @Override
        public boolean f(float input) {
            return input == this.target;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public float[] getDefiningSetAsPOSSIBLYLIVEArray() {
            float[] a = this.asArrayCache;
            if (a == null) {
                this.asArrayCache = a = new float[]{this.getTarget()};
            }
            return a;
        }
    }

    public static class SingletonIntEqualityPredicate
    implements AccessibleIntSingleonPredicate {
        protected final int target;
        protected transient int[] asArrayCache = null;

        public SingletonIntEqualityPredicate(int target) {
            this.target = target;
        }

        @Override
        public int getTarget() {
            return this.target;
        }

        @Override
        public boolean f(int input) {
            return input == this.target;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public int[] getDefiningSetAsPOSSIBLYLIVEArray() {
            int[] a = this.asArrayCache;
            if (a == null) {
                this.asArrayCache = a = new int[]{this.getTarget()};
            }
            return a;
        }
    }

    public static class SingletonLongEqualityPredicate
    implements AccessibleLongSingleonPredicate {
        protected final long target;
        protected transient long[] asArrayCache = null;

        public SingletonLongEqualityPredicate(long target) {
            this.target = target;
        }

        @Override
        public long getTarget() {
            return this.target;
        }

        @Override
        public boolean f(long input) {
            return input == this.target;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public long[] getDefiningSetAsPOSSIBLYLIVEArray() {
            long[] a = this.asArrayCache;
            if (a == null) {
                this.asArrayCache = a = new long[]{this.getTarget()};
            }
            return a;
        }
    }

    public static class SingletonObjectEqualityPredicate<Input>
    implements Predicate<Input> {
        protected final Input target;
        protected final EqualityComparator<Input> equalityComparator;

        public SingletonObjectEqualityPredicate(Input target, EqualityComparator<Input> equalityComparator) {
            this.target = target;
            this.equalityComparator = equalityComparator;
        }

        public SingletonObjectEqualityPredicate(Input target) {
            this(target, BasicObjectUtilities.getNaturalEqualityComparator());
        }

        public Input getTarget() {
            return this.target;
        }

        @Override
        public boolean test(Input input) {
            return this.equalityComparator.equals(input, this.target);
        }
    }

    public static class SingletonObjectIdentityEqualityPredicate<Input>
    implements Predicate<Input> {
        protected final Input target;

        public SingletonObjectIdentityEqualityPredicate(Input target) {
            this.target = target;
        }

        public Input getTarget() {
            return this.target;
        }

        @Override
        public boolean test(Input input) {
            return input == this.target;
        }
    }

    public static class SingletonShortEqualityPredicate
    implements AccessibleShortSingleonPredicate {
        protected final short target;
        protected transient short[] asArrayCache = null;

        public SingletonShortEqualityPredicate(short target) {
            this.target = target;
        }

        @Override
        public short getTarget() {
            return this.target;
        }

        @Override
        public boolean f(short input) {
            return input == this.target;
        }

        @Override
        @LiveValue
        @ReadonlyValue
        public short[] getDefiningSetAsPOSSIBLYLIVEArray() {
            short[] a = this.asArrayCache;
            if (a == null) {
                this.asArrayCache = a = new short[]{this.getTarget()};
            }
            return a;
        }
    }

    public static interface UnaryUnderliedFunctionR<F> {
        public F getUnderlyingFunction();
    }

    public static interface UnaryUnderliedFunctionW<F> {
        public void setUnderlyingFunction(F var1);
    }
}

