/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections.prim;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.annotations.hints.IntendedToBeSubclassedImplementedOrOverriddenByApiUser;
import rebound.annotations.hints.IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser;
import rebound.annotations.hints.IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser;
import rebound.annotations.semantic.SignalType;
import rebound.annotations.semantic.allowedoperations.FixedLengthValue;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.allowedoperations.TreatAsImmutableValue;
import rebound.annotations.semantic.allowedoperations.VariableLengthValue;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.annotations.semantic.operationspecification.HashableType;
import rebound.annotations.semantic.reachability.LiveValue;
import rebound.annotations.semantic.reachability.PossiblySnapshotPossiblyLiveValue;
import rebound.annotations.semantic.reachability.SnapshotValue;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.annotations.semantic.temporal.ImmutableValue;
import rebound.bits.BitfieldSafeCasts;
import rebound.bits.DataEncodingUtilities;
import rebound.concurrency.immutability.JavaImmutability;
import rebound.concurrency.immutability.StaticallyConcurrentlyImmutable;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.OverflowException;
import rebound.exceptions.ReadonlyUnsupportedOperationException;
import rebound.exceptions.StopIterationReturnPath;
import rebound.exceptions.StructuredClassCastException;
import rebound.math.SmallIntegerMathUtilities;
import rebound.util.BasicExceptionUtilities;
import rebound.util.CodeHinting;
import rebound.util.NIOBufferUtilities;
import rebound.util.Primitives;
import rebound.util.ValueType;
import rebound.util.collections.AbstractReadonlyList;
import rebound.util.collections.AbstractReadonlySet;
import rebound.util.collections.ArrayUtilities;
import rebound.util.collections.CollectionUtilities;
import rebound.util.collections.DelegatingListIterator;
import rebound.util.collections.KnowsLengthFixedness;
import rebound.util.collections.ListWithFill;
import rebound.util.collections.ListWithRemoveRange;
import rebound.util.collections.ListWithSetAll;
import rebound.util.collections.ListWithSetSize;
import rebound.util.collections.PolymorphicCollectionUtilities;
import rebound.util.collections.ShiftableList;
import rebound.util.collections.SimpleIterator;
import rebound.util.collections.SimpleTable;
import rebound.util.collections.Slice;
import rebound.util.collections.SortingUtilities;
import rebound.util.collections.Sublist;
import rebound.util.collections.TransparentContiguousArrayBackedCollection;
import rebound.util.collections.prim.BitSetBackedBooleanList;
import rebound.util.collections.prim.CharSequenceBackedReadonlyCharacterList;
import rebound.util.collections.prim.NonuniformMethodsForBooleanList;
import rebound.util.collections.prim.PrimitiveCollection;
import rebound.util.collections.prim.PrimitiveList;
import rebound.util.collections.prim.PrimitiveSet;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.growth.Grower;
import rebound.util.growth.TranslatedExponentialGrower;
import rebound.util.objectutil.Equivalenceable;
import rebound.util.objectutil.LintingCircumvinting;
import rebound.util.objectutil.ObjectUtilities;
import rebound.util.objectutil.RuntimeImmutability;
import rebound.util.objectutil.Trimmable;
import rebound.util.objectutil.UnderlyingInstanceAccessible;

public class PrimitiveCollections {
    public static final int DefaultPrimitiveArrayListInitialCapacity = 16;
    public static final int FillWithArrayThreshold = 100;
    public static final int FillWithArraySize = 1024;

    @ImmutableValue
    public static Grower.GrowerComputationallyUnreducedPurelyRecursive defaultPrimitiveArrayListGrower(int initialCapacity) {
        return new TranslatedExponentialGrower(11, 10, initialCapacity);
    }

    @ReadonlyValue
    @Nonnull
    public static CharacterList charSequenceToList(@Nonnull CharSequence s) {
        return new CharSequenceBackedReadonlyCharacterList(s);
    }

    @ReadonlyValue
    @Nonnull
    public static CharacterList stringToList(@Nonnull String s) {
        return PrimitiveCollections.charSequenceToList(s);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static ByteList booleanListToByteList(List<Boolean> bits) {
        if (bits instanceof BooleanListWithByteListConversion) {
            return ((BooleanListWithByteListConversion)bits).byteList();
        }
        return PrimitiveCollections.byteArrayAsList(PrimitiveCollections.defaultBooleanListToNewByteArray(bits));
    }

    @ThrowAwayValue
    public static ByteList booleanListToNewByteList(List<Boolean> bits) {
        if (bits instanceof BooleanListWithByteListConversion) {
            return ((BooleanListWithByteListConversion)bits).toNewByteList();
        }
        return PrimitiveCollections.byteArrayAsList(PrimitiveCollections.defaultBooleanListToNewByteArray(bits));
    }

    @ThrowAwayValue
    public static byte[] defaultBooleanListToNewByteArray(List<Boolean> bits) {
        if (bits instanceof BooleanList) {
            return PrimitiveCollections.defaultBooleanListToNewByteArray((BooleanList)bits);
        }
        return PrimitiveCollections.defaultBooleanListToNewByteArray(bits.size(), i -> (Boolean)bits.get(i));
    }

    @ThrowAwayValue
    public static byte[] defaultBooleanListToNewByteArray(BooleanList bits) {
        return PrimitiveCollections.defaultBooleanListToNewByteArray(bits.size(), i -> bits.getBoolean(i));
    }

    @ThrowAwayValue
    public static byte[] defaultBooleanListToNewByteArray(int size, FunctionInterfaces.UnaryFunctionIntToBoolean getBit) {
        int nBits = size;
        int nBytes = SmallIntegerMathUtilities.ceilingDivision(nBits, 8);
        int lastByteLength = nBits - (nBytes - 1) * 8;
        byte[] bytes = new byte[nBytes];
        int i = 0;
        while (i < nBytes) {
            int base = i * 8;
            int nb = i == nBytes - 1 ? lastByteLength : 8;
            byte b = 0;
            int j = 0;
            while (j < nb) {
                b = (byte)(b | (getBit.f(base + j) ? 1 : 0) << j);
                ++j;
            }
            bytes[i] = b;
            ++i;
        }
        return bytes;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static Slice<byte[]> booleanListToByteArray(BooleanList bits) {
        return PrimitiveCollections.booleanListToByteList(bits).toByteArraySlicePossiblyLive();
    }

    public static BooleanList byteListToBooleanList(List<Byte> bytes) {
        Slice<byte[]> s;
        Object u;
        if (TransparentContiguousArrayBackedCollection.is(bytes) && (u = (s = ((TransparentContiguousArrayBackedCollection)((Object)bytes)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying()) instanceof byte[]) {
            return PrimitiveCollections.byteArrayToBooleanList(s);
        }
        return PrimitiveCollections.byteArrayToBooleanList(PolymorphicCollectionUtilities.anyToArrayByte(bytes));
    }

    public static BooleanList byteArrayToBooleanList(Slice<byte[]> bytes) {
        return BitSetBackedBooleanList.newFromBytesArraySlice(bytes);
    }

    public static BooleanList byteArrayToBooleanList(byte[] bytes) {
        return BitSetBackedBooleanList.newFromBytesArray(bytes);
    }

    public static BooleanList byteArrayToBooleanList(byte[] bytes, int offset, int length) {
        return BitSetBackedBooleanList.newFromBytesArraySlice(new Slice<byte[]>(bytes, offset, length));
    }

    public static BooleanList byteListToBooleanList(List<Byte> bytes, int nBits) {
        Slice<byte[]> s;
        Object u;
        if (TransparentContiguousArrayBackedCollection.is(bytes) && (u = (s = ((TransparentContiguousArrayBackedCollection)((Object)bytes)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying()) instanceof byte[]) {
            return PrimitiveCollections.byteArrayToBooleanList(s, nBits);
        }
        return PrimitiveCollections.byteArrayToBooleanList(PolymorphicCollectionUtilities.anyToArrayByte(bytes), nBits);
    }

    public static BooleanList byteArrayToBooleanList(Slice<byte[]> bytes, int nBits) {
        return BitSetBackedBooleanList.newFromBytesArraySlice(bytes, nBits);
    }

    public static BooleanList byteArrayToBooleanList(byte[] bytes, int nBits) {
        return BitSetBackedBooleanList.newFromBytesArray(bytes, nBits);
    }

    public static BooleanList byteArrayToBooleanList(byte[] bytes, int offset, int length, int nBits) {
        return BitSetBackedBooleanList.newFromBytesArraySlice(new Slice<byte[]>(bytes, offset, length), nBits);
    }

    public static String defaultToString(Iterable<?> c) {
        boolean list = c instanceof List;
        StringBuilder b = new StringBuilder(list ? "[" : "{");
        boolean first = true;
        for (Object e : c) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(e);
        }
        b.append(list ? (char)']' : '}');
        return b.toString();
    }

    public static String defaultBooleanListToString(BooleanList c) {
        StringBuilder b = new StringBuilder("[");
        b.append(DataEncodingUtilities.encodeBinary(c));
        b.append(']');
        return b.toString();
    }

    public static String defaultCharacterListToString(CharacterList c) {
        StringBuilder b = new StringBuilder();
        int n = c.size();
        int i = 0;
        while (i < n) {
            b.append(c.getChar(i));
            ++i;
        }
        return b.toString();
    }

    public static void sort(boolean[] array) {
        PrimitiveCollections.sortArray(array, 0, array.length);
    }

    public static void sortArray(boolean[] array, int start, int length) {
        int nFalses = 0;
        int nTrues = 0;
        int i = 0;
        while (i < length) {
            if (array[i + start]) {
                ++nTrues;
            } else {
                ++nFalses;
            }
            ++i;
        }
        i = 0;
        while (i < nFalses) {
            array[i + start] = false;
            ++i;
        }
        int s = start + nFalses;
        int i2 = 0;
        while (i2 < nTrues) {
            array[i2 + s] = true;
            ++i2;
        }
    }

    public static void sort(byte[] array) {
        PrimitiveCollections.sortArray(array, 0, array.length);
    }

    public static void sortArray(byte[] array, int start, int length) {
        Arrays.sort(array, start, length);
    }

    public static void sort(char[] array) {
        PrimitiveCollections.sortArray(array, 0, array.length);
    }

    public static void sortArray(char[] array, int start, int length) {
        Arrays.sort(array, start, length);
    }

    public static void sort(short[] array) {
        PrimitiveCollections.sortArray(array, 0, array.length);
    }

    public static void sortArray(short[] array, int start, int length) {
        Arrays.sort(array, start, length);
    }

    public static void sort(float[] array) {
        PrimitiveCollections.sortArray(array, 0, array.length);
    }

    public static void sortArray(float[] array, int start, int length) {
        Arrays.sort(array, start, length);
    }

    public static void sort(int[] array) {
        PrimitiveCollections.sortArray(array, 0, array.length);
    }

    public static void sortArray(int[] array, int start, int length) {
        Arrays.sort(array, start, length);
    }

    public static void sort(double[] array) {
        PrimitiveCollections.sortArray(array, 0, array.length);
    }

    public static void sortArray(double[] array, int start, int length) {
        Arrays.sort(array, start, length);
    }

    public static void sort(long[] array) {
        PrimitiveCollections.sortArray(array, 0, array.length);
    }

    public static void sortArray(long[] array, int start, int length) {
        Arrays.sort(array, start, length);
    }

    @ImplementationTransparency
    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    @Nullable
    public static <P> List<P> concatenateManyPrimitiveListsOP(@ReadonlyValue Collection<? extends Iterable<P>> lists) {
        Class<Comparable<Boolean>> primitiveType = null;
        for (Iterable<P> list : lists) {
            if (LintingCircumvinting.never()) continue;
            if (list instanceof BooleanCollection) {
                if (primitiveType == null) {
                    primitiveType = Boolean.TYPE;
                    continue;
                }
                if (primitiveType == Boolean.TYPE) continue;
                return null;
            }
            if (list instanceof ByteCollection) {
                if (primitiveType == null) {
                    primitiveType = Byte.TYPE;
                    continue;
                }
                if (primitiveType == Byte.TYPE) continue;
                return null;
            }
            if (list instanceof CharacterCollection) {
                if (primitiveType == null) {
                    primitiveType = Character.TYPE;
                    continue;
                }
                if (primitiveType == Character.TYPE) continue;
                return null;
            }
            if (list instanceof ShortCollection) {
                if (primitiveType == null) {
                    primitiveType = Short.TYPE;
                    continue;
                }
                if (primitiveType == Short.TYPE) continue;
                return null;
            }
            if (list instanceof FloatCollection) {
                if (primitiveType == null) {
                    primitiveType = Float.TYPE;
                    continue;
                }
                if (primitiveType == Float.TYPE) continue;
                return null;
            }
            if (list instanceof IntegerCollection) {
                if (primitiveType == null) {
                    primitiveType = Integer.TYPE;
                    continue;
                }
                if (primitiveType == Integer.TYPE) continue;
                return null;
            }
            if (list instanceof DoubleCollection) {
                if (primitiveType == null) {
                    primitiveType = Double.TYPE;
                    continue;
                }
                if (primitiveType == Double.TYPE) continue;
                return null;
            }
            if (!(list instanceof LongCollection)) continue;
            if (primitiveType == null) {
                primitiveType = Long.TYPE;
                continue;
            }
            if (primitiveType == Long.TYPE) continue;
            return null;
        }
        return primitiveType == null ? null : PrimitiveCollections.concatenateManyPrimitiveListsToGivenTypeOP(lists, primitiveType);
    }

    @ImplementationTransparency
    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    @Nullable
    public static <P> List<P> concatenateManyPrimitiveListsToGivenTypeOP(@ReadonlyValue Collection<? extends Iterable<P>> lists, Class primitiveType) {
        if (primitiveType == Boolean.TYPE) {
            BooleanList rv = PrimitiveCollections.newBooleanList();
            for (Iterable<P> list : lists) {
                if (LintingCircumvinting.never()) {
                    // empty if block
                }
                if (list instanceof Collection && ((Collection)list).isEmpty()) continue;
                if (list instanceof BooleanCollection) {
                    rv.addAll((BooleanCollection)list);
                    continue;
                }
                if (CollectionUtilities.forAll(e -> e instanceof Boolean, list)) {
                    CollectionUtilities.addAll(rv, list);
                    continue;
                }
                return null;
            }
            return rv;
        }
        if (primitiveType == Byte.TYPE) {
            ByteList rv = PrimitiveCollections.newByteList();
            for (Iterable<P> list : lists) {
                if (LintingCircumvinting.never()) {
                    // empty if block
                }
                if (list instanceof Collection && ((Collection)list).isEmpty()) continue;
                if (list instanceof ByteCollection) {
                    rv.addAll((ByteCollection)list);
                    continue;
                }
                if (CollectionUtilities.forAll(e -> e instanceof Byte, list)) {
                    CollectionUtilities.addAll(rv, list);
                    continue;
                }
                return null;
            }
            return rv;
        }
        if (primitiveType == Character.TYPE) {
            CharacterList rv = PrimitiveCollections.newCharacterList();
            for (Iterable<P> list : lists) {
                if (LintingCircumvinting.never()) {
                    // empty if block
                }
                if (list instanceof Collection && ((Collection)list).isEmpty()) continue;
                if (list instanceof CharacterCollection) {
                    rv.addAll((CharacterCollection)list);
                    continue;
                }
                if (CollectionUtilities.forAll(e -> e instanceof Character, list)) {
                    CollectionUtilities.addAll(rv, list);
                    continue;
                }
                return null;
            }
            return rv;
        }
        if (primitiveType == Short.TYPE) {
            ShortList rv = PrimitiveCollections.newShortList();
            for (Iterable<P> list : lists) {
                if (LintingCircumvinting.never()) {
                    // empty if block
                }
                if (list instanceof Collection && ((Collection)list).isEmpty()) continue;
                if (list instanceof ShortCollection) {
                    rv.addAll((ShortCollection)list);
                    continue;
                }
                if (CollectionUtilities.forAll(e -> e instanceof Short, list)) {
                    CollectionUtilities.addAll(rv, list);
                    continue;
                }
                return null;
            }
            return rv;
        }
        if (primitiveType == Float.TYPE) {
            FloatList rv = PrimitiveCollections.newFloatList();
            for (Iterable<P> list : lists) {
                if (LintingCircumvinting.never()) {
                    // empty if block
                }
                if (list instanceof Collection && ((Collection)list).isEmpty()) continue;
                if (list instanceof FloatCollection) {
                    rv.addAll((FloatCollection)list);
                    continue;
                }
                if (CollectionUtilities.forAll(e -> e instanceof Float, list)) {
                    CollectionUtilities.addAll(rv, list);
                    continue;
                }
                return null;
            }
            return rv;
        }
        if (primitiveType == Integer.TYPE) {
            IntegerList rv = PrimitiveCollections.newIntegerList();
            for (Iterable<P> list : lists) {
                if (LintingCircumvinting.never()) {
                    // empty if block
                }
                if (list instanceof Collection && ((Collection)list).isEmpty()) continue;
                if (list instanceof IntegerCollection) {
                    rv.addAll((IntegerCollection)list);
                    continue;
                }
                if (CollectionUtilities.forAll(e -> e instanceof Integer, list)) {
                    CollectionUtilities.addAll(rv, list);
                    continue;
                }
                return null;
            }
            return rv;
        }
        if (primitiveType == Double.TYPE) {
            DoubleList rv = PrimitiveCollections.newDoubleList();
            for (Iterable<P> list : lists) {
                if (LintingCircumvinting.never()) {
                    // empty if block
                }
                if (list instanceof Collection && ((Collection)list).isEmpty()) continue;
                if (list instanceof DoubleCollection) {
                    rv.addAll((DoubleCollection)list);
                    continue;
                }
                if (CollectionUtilities.forAll(e -> e instanceof Double, list)) {
                    CollectionUtilities.addAll(rv, list);
                    continue;
                }
                return null;
            }
            return rv;
        }
        if (primitiveType == Long.TYPE) {
            LongList rv = PrimitiveCollections.newLongList();
            for (Iterable<P> list : lists) {
                if (LintingCircumvinting.never()) {
                    // empty if block
                }
                if (list instanceof Collection && ((Collection)list).isEmpty()) continue;
                if (list instanceof LongCollection) {
                    rv.addAll((LongCollection)list);
                    continue;
                }
                if (CollectionUtilities.forAll(e -> e instanceof Long, list)) {
                    CollectionUtilities.addAll(rv, list);
                    continue;
                }
                return null;
            }
            return rv;
        }
        throw new IllegalArgumentException(ObjectUtilities.toStringNT(primitiveType));
    }

    @LiveValue
    public static List asListObjectOrPrimitiveArray(Object array) {
        if (array instanceof Object[]) {
            return Arrays.asList(array);
        }
        if (array instanceof boolean[]) {
            return PrimitiveCollections.booleanArrayAsList((boolean[])array);
        }
        if (array instanceof byte[]) {
            return PrimitiveCollections.byteArrayAsList((byte[])array);
        }
        if (array instanceof char[]) {
            return PrimitiveCollections.charArrayAsList((char[])array);
        }
        if (array instanceof short[]) {
            return PrimitiveCollections.shortArrayAsList((short[])array);
        }
        if (array instanceof float[]) {
            return PrimitiveCollections.floatArrayAsList((float[])array);
        }
        if (array instanceof int[]) {
            return PrimitiveCollections.intArrayAsList((int[])array);
        }
        if (array instanceof double[]) {
            return PrimitiveCollections.doubleArrayAsList((double[])array);
        }
        if (array instanceof long[]) {
            return PrimitiveCollections.longArrayAsList((long[])array);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(array);
    }

    @WritableValue
    public static BooleanList newBooleanList() {
        return new BitSetBackedBooleanList();
    }

    @WritableValue
    public static BooleanList newBooleanListZerofilled(int size) {
        return BitSetBackedBooleanList.newBooleanListZerofilled(size);
    }

    @WritableValue
    public static SimpleTable<Boolean> newBooleanTable() {
        return CollectionUtilities.newTable();
    }

    @WritableValue
    public static SimpleTable<Boolean> newBooleanTableZerofilled(int width, int height) {
        return CollectionUtilities.newTableGivenfilled(width, height, false);
    }

    @ImmutableValue
    public static BooleanList booleanlistof(boolean ... array) {
        int n = array.length;
        BitSet s = new BitSet(n);
        int i = 0;
        while (i < n) {
            s.set(i);
            ++i;
        }
        return new BitSetBackedBooleanList(s, n);
    }

    @WritableValue
    public static ByteList newByteList() {
        return new ByteArrayList();
    }

    @WritableValue
    public static ByteList newByteListZerofilled(int size) {
        return new ByteArrayList(new byte[size], size);
    }

    @WritableValue
    public static SimpleTable<Byte> newByteTable() {
        return CollectionUtilities.newTable();
    }

    @WritableValue
    public static SimpleTable<Byte> newByteTableZerofilled(int width, int height) {
        return CollectionUtilities.newTableGivenfilled(width, height, (byte)0);
    }

    @ImmutableValue
    public static ImmutableByteArrayList bytelistof(byte ... array) {
        return ImmutableByteArrayList.newLIVE(array);
    }

    @WritableValue
    public static CharacterList newCharacterList() {
        return new CharacterArrayList();
    }

    @WritableValue
    public static CharacterList newCharacterListZerofilled(int size) {
        return new CharacterArrayList(new char[size], size);
    }

    @WritableValue
    public static SimpleTable<Character> newCharacterTable() {
        return CollectionUtilities.newTable();
    }

    @WritableValue
    public static SimpleTable<Character> newCharacterTableZerofilled(int width, int height) {
        return CollectionUtilities.newTableGivenfilled(width, height, Character.valueOf('\u0000'));
    }

    @ImmutableValue
    public static ImmutableCharacterArrayList charlistof(char ... array) {
        return ImmutableCharacterArrayList.newLIVE(array);
    }

    @WritableValue
    public static ShortList newShortList() {
        return new ShortArrayList();
    }

    @WritableValue
    public static ShortList newShortListZerofilled(int size) {
        return new ShortArrayList(new short[size], size);
    }

    @WritableValue
    public static SimpleTable<Short> newShortTable() {
        return CollectionUtilities.newTable();
    }

    @WritableValue
    public static SimpleTable<Short> newShortTableZerofilled(int width, int height) {
        return CollectionUtilities.newTableGivenfilled(width, height, (short)0);
    }

    @ImmutableValue
    public static ImmutableShortArrayList shortlistof(short ... array) {
        return ImmutableShortArrayList.newLIVE(array);
    }

    @WritableValue
    public static FloatList newFloatList() {
        return new FloatArrayList();
    }

    @WritableValue
    public static FloatList newFloatListZerofilled(int size) {
        return new FloatArrayList(new float[size], size);
    }

    @WritableValue
    public static SimpleTable<Float> newFloatTable() {
        return CollectionUtilities.newTable();
    }

    @WritableValue
    public static SimpleTable<Float> newFloatTableZerofilled(int width, int height) {
        return CollectionUtilities.newTableGivenfilled(width, height, Float.valueOf(0.0f));
    }

    @ImmutableValue
    public static ImmutableFloatArrayList floatlistof(float ... array) {
        return ImmutableFloatArrayList.newLIVE(array);
    }

    @WritableValue
    public static IntegerList newIntegerList() {
        return new IntegerArrayList();
    }

    @WritableValue
    public static IntegerList newIntegerListZerofilled(int size) {
        return new IntegerArrayList(new int[size], size);
    }

    @WritableValue
    public static SimpleTable<Integer> newIntegerTable() {
        return CollectionUtilities.newTable();
    }

    @WritableValue
    public static SimpleTable<Integer> newIntegerTableZerofilled(int width, int height) {
        return CollectionUtilities.newTableGivenfilled(width, height, 0);
    }

    @ImmutableValue
    public static ImmutableIntegerArrayList intlistof(int ... array) {
        return ImmutableIntegerArrayList.newLIVE(array);
    }

    @WritableValue
    public static DoubleList newDoubleList() {
        return new DoubleArrayList();
    }

    @WritableValue
    public static DoubleList newDoubleListZerofilled(int size) {
        return new DoubleArrayList(new double[size], size);
    }

    @WritableValue
    public static SimpleTable<Double> newDoubleTable() {
        return CollectionUtilities.newTable();
    }

    @WritableValue
    public static SimpleTable<Double> newDoubleTableZerofilled(int width, int height) {
        return CollectionUtilities.newTableGivenfilled(width, height, 0.0);
    }

    @ImmutableValue
    public static ImmutableDoubleArrayList doublelistof(double ... array) {
        return ImmutableDoubleArrayList.newLIVE(array);
    }

    @WritableValue
    public static LongList newLongList() {
        return new LongArrayList();
    }

    @WritableValue
    public static LongList newLongListZerofilled(int size) {
        return new LongArrayList(new long[size], size);
    }

    @WritableValue
    public static SimpleTable<Long> newLongTable() {
        return CollectionUtilities.newTable();
    }

    @WritableValue
    public static SimpleTable<Long> newLongTableZerofilled(int width, int height) {
        return CollectionUtilities.newTableGivenfilled(width, height, 0L);
    }

    @ImmutableValue
    public static ImmutableLongArrayList longlistof(long ... array) {
        return ImmutableLongArrayList.newLIVE(array);
    }

    @WritableValue
    public static List newPrimitiveList(Class primitiveType) {
        if (primitiveType == Boolean.TYPE) {
            return PrimitiveCollections.newBooleanList();
        }
        if (primitiveType == Byte.TYPE) {
            return PrimitiveCollections.newByteList();
        }
        if (primitiveType == Character.TYPE) {
            return PrimitiveCollections.newCharacterList();
        }
        if (primitiveType == Short.TYPE) {
            return PrimitiveCollections.newShortList();
        }
        if (primitiveType == Float.TYPE) {
            return PrimitiveCollections.newFloatList();
        }
        if (primitiveType == Integer.TYPE) {
            return PrimitiveCollections.newIntegerList();
        }
        if (primitiveType == Double.TYPE) {
            return PrimitiveCollections.newDoubleList();
        }
        if (primitiveType == Long.TYPE) {
            return PrimitiveCollections.newLongList();
        }
        throw new IllegalArgumentException(ObjectUtilities.toStringNT(primitiveType));
    }

    @WritableValue
    public static List newPrimitiveListZerofilled(Class primitiveType, int size) {
        if (primitiveType == Boolean.TYPE) {
            return PrimitiveCollections.newBooleanListZerofilled(size);
        }
        if (primitiveType == Byte.TYPE) {
            return PrimitiveCollections.newByteListZerofilled(size);
        }
        if (primitiveType == Character.TYPE) {
            return PrimitiveCollections.newCharacterListZerofilled(size);
        }
        if (primitiveType == Short.TYPE) {
            return PrimitiveCollections.newShortListZerofilled(size);
        }
        if (primitiveType == Float.TYPE) {
            return PrimitiveCollections.newFloatListZerofilled(size);
        }
        if (primitiveType == Integer.TYPE) {
            return PrimitiveCollections.newIntegerListZerofilled(size);
        }
        if (primitiveType == Double.TYPE) {
            return PrimitiveCollections.newDoubleListZerofilled(size);
        }
        if (primitiveType == Long.TYPE) {
            return PrimitiveCollections.newLongListZerofilled(size);
        }
        throw new IllegalArgumentException(ObjectUtilities.toStringNT(primitiveType));
    }

    public static boolean getBoolean(List<Boolean> list, int index) {
        if (list instanceof BooleanList) {
            return ((BooleanList)list).getBoolean(index);
        }
        return list.get(index);
    }

    public static void setBoolean(List<Boolean> list, int index, boolean value) {
        if (list instanceof BooleanList) {
            ((BooleanList)list).setBoolean(index, value);
        } else {
            list.set(index, value);
        }
    }

    @WritableValue
    @FixedLengthValue
    public static BooleanList booleanArrayAsList(@LiveValue @WritableValue boolean[] array, int offset, int length) {
        return new FixedLengthArrayWrapperBooleanList(array, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static BooleanList booleanArrayAsList(boolean ... array) {
        return new FixedLengthArrayWrapperBooleanList(array);
    }

    @WritableValue
    @FixedLengthValue
    public static BooleanList booleanArrayAsList(@LiveValue @WritableValue Slice<boolean[]> arraySlice) {
        return new FixedLengthArrayWrapperBooleanList(arraySlice);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static BooleanList booleanArrayAsMutableList(@SnapshotValue @ReadonlyValue boolean[] array, int offset, int length) {
        return new BooleanArrayList(new FixedLengthArrayWrapperBooleanList(array, offset, length));
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static BooleanList booleanArrayAsMutableList(boolean ... array) {
        return PrimitiveCollections.booleanArrayAsMutableList(array, 0, array.length);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static BooleanList booleanArrayAsMutableList(@SnapshotValue @ReadonlyValue Slice<boolean[]> arraySlice) {
        return PrimitiveCollections.booleanArrayAsMutableList(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    @Nonnull
    public static BooleanList uniquedOfPresorted(@ReadonlyValue @Nonnull BooleanList presorted) {
        int n = presorted.size();
        BooleanArrayList uniqued = new BooleanArrayList(n);
        boolean last = false;
        int i = 0;
        while (i < n) {
            boolean e = presorted.getBoolean(0);
            if (i == 0) {
                last = e;
                uniqued.addBoolean(e);
            } else if (e != last) {
                last = e;
                uniqued.addBoolean(e);
            }
            ++i;
        }
        return uniqued;
    }

    public static final BooleanList emptyBooleanList() {
        return ImmutableBooleanArrayList.Empty;
    }

    public static final BooleanList singletonBooleanList(boolean v) {
        return ImmutableBooleanArrayList.newLIVE(new boolean[]{v});
    }

    public static BooleanList unmodifiableBooleanList(BooleanList booleanList) {
        return booleanList instanceof UnmodifiableBooleanListWrapper ? booleanList : new UnmodifiableBooleanListWrapper(booleanList);
    }

    @ThrowAwayValue
    public static boolean[] toBooleanArray(Collection<Boolean> genericCollection) {
        if (genericCollection instanceof BooleanCollection) {
            return ((BooleanCollection)genericCollection).toBooleanArray();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof boolean[]) {
                boolean[] a = new boolean[size];
                System.arraycopy(und, u.getOffset(), a, 0, size);
                return a;
            }
        }
        boolean[] a = new boolean[genericCollection.size()];
        int i = 0;
        for (Boolean e : genericCollection) {
            a[i++] = e;
        }
        return a;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static Slice<boolean[]> toBooleanArrayPossiblyLive(Collection<Boolean> genericCollection) {
        if (genericCollection instanceof BooleanCollection) {
            return ((BooleanCollection)genericCollection).toBooleanArraySlicePossiblyLive();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice<boolean[]> u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof boolean[]) {
                return u;
            }
        }
        boolean[] a = new boolean[genericCollection.size()];
        int i = 0;
        for (Boolean e : genericCollection) {
            a[i++] = e;
        }
        return ArrayUtilities.wholeArraySliceBoolean(a);
    }

    public static BooleanList asBooleanList(List<Boolean> genericList) {
        return genericList instanceof BooleanList ? (BooleanList)genericList : new BooleanListWrapper(genericList);
    }

    public static byte getByte(List<Byte> list, int index) {
        if (list instanceof ByteList) {
            return ((ByteList)list).getByte(index);
        }
        return list.get(index);
    }

    public static void setByte(List<Byte> list, int index, byte value) {
        if (list instanceof ByteList) {
            ((ByteList)list).setByte(index, value);
        } else {
            list.set(index, value);
        }
    }

    @WritableValue
    @FixedLengthValue
    public static ByteList byteArrayAsList(@LiveValue @WritableValue byte[] array, int offset, int length) {
        return new FixedLengthArrayWrapperByteList(array, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static ByteList byteArrayAsList(byte ... array) {
        return new FixedLengthArrayWrapperByteList(array);
    }

    @WritableValue
    @FixedLengthValue
    public static ByteList byteArrayAsList(@LiveValue @WritableValue Slice<byte[]> arraySlice) {
        return new FixedLengthArrayWrapperByteList(arraySlice);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static ByteList byteArrayAsMutableList(@SnapshotValue @ReadonlyValue byte[] array, int offset, int length) {
        return new ByteArrayList(new FixedLengthArrayWrapperByteList(array, offset, length));
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static ByteList byteArrayAsMutableList(byte ... array) {
        return PrimitiveCollections.byteArrayAsMutableList(array, 0, array.length);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static ByteList byteArrayAsMutableList(@SnapshotValue @ReadonlyValue Slice<byte[]> arraySlice) {
        return PrimitiveCollections.byteArrayAsMutableList(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    @Nonnull
    public static ByteList uniquedOfPresorted(@ReadonlyValue @Nonnull ByteList presorted) {
        int n = presorted.size();
        ByteArrayList uniqued = new ByteArrayList(n);
        byte last = 0;
        int i = 0;
        while (i < n) {
            byte e = presorted.getByte(0);
            if (i == 0) {
                last = e;
                uniqued.addByte(e);
            } else if (e != last) {
                last = e;
                uniqued.addByte(e);
            }
            ++i;
        }
        return uniqued;
    }

    public static final ByteList emptyByteList() {
        return ImmutableByteArrayList.Empty;
    }

    public static final ByteList singletonByteList(byte v) {
        return ImmutableByteArrayList.newLIVE(new byte[]{v});
    }

    public static ByteList unmodifiableByteList(ByteList byteList) {
        return byteList instanceof UnmodifiableByteListWrapper ? byteList : new UnmodifiableByteListWrapper(byteList);
    }

    @ThrowAwayValue
    public static byte[] toByteArray(Collection<Byte> genericCollection) {
        if (genericCollection instanceof ByteCollection) {
            return ((ByteCollection)genericCollection).toByteArray();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof byte[]) {
                byte[] a = new byte[size];
                System.arraycopy(und, u.getOffset(), a, 0, size);
                return a;
            }
        }
        byte[] a = new byte[genericCollection.size()];
        int i = 0;
        for (Byte e : genericCollection) {
            a[i++] = e;
        }
        return a;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static Slice<byte[]> toByteArrayPossiblyLive(Collection<Byte> genericCollection) {
        if (genericCollection instanceof ByteCollection) {
            return ((ByteCollection)genericCollection).toByteArraySlicePossiblyLive();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice<byte[]> u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof byte[]) {
                return u;
            }
        }
        byte[] a = new byte[genericCollection.size()];
        int i = 0;
        for (Byte e : genericCollection) {
            a[i++] = e;
        }
        return ArrayUtilities.wholeArraySliceByte(a);
    }

    public static ByteList asByteList(List<Byte> genericList) {
        return genericList instanceof ByteList ? (ByteList)genericList : new ByteListWrapper(genericList);
    }

    public static char getChar(List<Character> list, int index) {
        if (list instanceof CharacterList) {
            return ((CharacterList)list).getChar(index);
        }
        return list.get(index).charValue();
    }

    public static void setChar(List<Character> list, int index, char value) {
        if (list instanceof CharacterList) {
            ((CharacterList)list).setChar(index, value);
        } else {
            list.set(index, Character.valueOf(value));
        }
    }

    @WritableValue
    @FixedLengthValue
    public static CharacterList charArrayAsList(@LiveValue @WritableValue char[] array, int offset, int length) {
        return new FixedLengthArrayWrapperCharacterList(array, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static CharacterList charArrayAsList(char ... array) {
        return new FixedLengthArrayWrapperCharacterList(array);
    }

    @WritableValue
    @FixedLengthValue
    public static CharacterList charArrayAsList(@LiveValue @WritableValue Slice<char[]> arraySlice) {
        return new FixedLengthArrayWrapperCharacterList(arraySlice);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static CharacterList charArrayAsMutableList(@SnapshotValue @ReadonlyValue char[] array, int offset, int length) {
        return new CharacterArrayList(new FixedLengthArrayWrapperCharacterList(array, offset, length));
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static CharacterList charArrayAsMutableList(char ... array) {
        return PrimitiveCollections.charArrayAsMutableList(array, 0, array.length);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static CharacterList charArrayAsMutableList(@SnapshotValue @ReadonlyValue Slice<char[]> arraySlice) {
        return PrimitiveCollections.charArrayAsMutableList(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    @Nonnull
    public static CharacterList uniquedOfPresorted(@ReadonlyValue @Nonnull CharacterList presorted) {
        int n = presorted.size();
        CharacterArrayList uniqued = new CharacterArrayList(n);
        char last = '\u0000';
        int i = 0;
        while (i < n) {
            char e = presorted.getChar(0);
            if (i == 0) {
                last = e;
                uniqued.addChar(e);
            } else if (e != last) {
                last = e;
                uniqued.addChar(e);
            }
            ++i;
        }
        return uniqued;
    }

    public static final CharacterList emptyCharacterList() {
        return ImmutableCharacterArrayList.Empty;
    }

    public static final CharacterList singletonCharacterList(char v) {
        return ImmutableCharacterArrayList.newLIVE(new char[]{v});
    }

    public static CharacterList unmodifiableCharacterList(CharacterList characterList) {
        return characterList instanceof UnmodifiableCharacterListWrapper ? characterList : new UnmodifiableCharacterListWrapper(characterList);
    }

    @ThrowAwayValue
    public static char[] toCharArray(Collection<Character> genericCollection) {
        if (genericCollection instanceof CharacterCollection) {
            return ((CharacterCollection)genericCollection).toCharArray();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof char[]) {
                char[] a = new char[size];
                System.arraycopy(und, u.getOffset(), a, 0, size);
                return a;
            }
        }
        char[] a = new char[genericCollection.size()];
        int i = 0;
        for (Character e : genericCollection) {
            a[i++] = e.charValue();
        }
        return a;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static Slice<char[]> toCharArrayPossiblyLive(Collection<Character> genericCollection) {
        if (genericCollection instanceof CharacterCollection) {
            return ((CharacterCollection)genericCollection).toCharArraySlicePossiblyLive();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice<char[]> u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof char[]) {
                return u;
            }
        }
        char[] a = new char[genericCollection.size()];
        int i = 0;
        for (Character e : genericCollection) {
            a[i++] = e.charValue();
        }
        return ArrayUtilities.wholeArraySliceChar(a);
    }

    public static CharacterList asCharacterList(List<Character> genericList) {
        return genericList instanceof CharacterList ? (CharacterList)genericList : new CharacterListWrapper(genericList);
    }

    public static short getShort(List<Short> list, int index) {
        if (list instanceof ShortList) {
            return ((ShortList)list).getShort(index);
        }
        return list.get(index);
    }

    public static void setShort(List<Short> list, int index, short value) {
        if (list instanceof ShortList) {
            ((ShortList)list).setShort(index, value);
        } else {
            list.set(index, value);
        }
    }

    @WritableValue
    @FixedLengthValue
    public static ShortList shortArrayAsList(@LiveValue @WritableValue short[] array, int offset, int length) {
        return new FixedLengthArrayWrapperShortList(array, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static ShortList shortArrayAsList(short ... array) {
        return new FixedLengthArrayWrapperShortList(array);
    }

    @WritableValue
    @FixedLengthValue
    public static ShortList shortArrayAsList(@LiveValue @WritableValue Slice<short[]> arraySlice) {
        return new FixedLengthArrayWrapperShortList(arraySlice);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static ShortList shortArrayAsMutableList(@SnapshotValue @ReadonlyValue short[] array, int offset, int length) {
        return new ShortArrayList(new FixedLengthArrayWrapperShortList(array, offset, length));
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static ShortList shortArrayAsMutableList(short ... array) {
        return PrimitiveCollections.shortArrayAsMutableList(array, 0, array.length);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static ShortList shortArrayAsMutableList(@SnapshotValue @ReadonlyValue Slice<short[]> arraySlice) {
        return PrimitiveCollections.shortArrayAsMutableList(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    @Nonnull
    public static ShortList uniquedOfPresorted(@ReadonlyValue @Nonnull ShortList presorted) {
        int n = presorted.size();
        ShortArrayList uniqued = new ShortArrayList(n);
        short last = 0;
        int i = 0;
        while (i < n) {
            short e = presorted.getShort(0);
            if (i == 0) {
                last = e;
                uniqued.addShort(e);
            } else if (e != last) {
                last = e;
                uniqued.addShort(e);
            }
            ++i;
        }
        return uniqued;
    }

    public static final ShortList emptyShortList() {
        return ImmutableShortArrayList.Empty;
    }

    public static final ShortList singletonShortList(short v) {
        return ImmutableShortArrayList.newLIVE(new short[]{v});
    }

    public static ShortList unmodifiableShortList(ShortList shortList) {
        return shortList instanceof UnmodifiableShortListWrapper ? shortList : new UnmodifiableShortListWrapper(shortList);
    }

    @ThrowAwayValue
    public static short[] toShortArray(Collection<Short> genericCollection) {
        if (genericCollection instanceof ShortCollection) {
            return ((ShortCollection)genericCollection).toShortArray();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof short[]) {
                short[] a = new short[size];
                System.arraycopy(und, u.getOffset(), a, 0, size);
                return a;
            }
        }
        short[] a = new short[genericCollection.size()];
        int i = 0;
        for (Short e : genericCollection) {
            a[i++] = e;
        }
        return a;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static Slice<short[]> toShortArrayPossiblyLive(Collection<Short> genericCollection) {
        if (genericCollection instanceof ShortCollection) {
            return ((ShortCollection)genericCollection).toShortArraySlicePossiblyLive();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice<short[]> u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof short[]) {
                return u;
            }
        }
        short[] a = new short[genericCollection.size()];
        int i = 0;
        for (Short e : genericCollection) {
            a[i++] = e;
        }
        return ArrayUtilities.wholeArraySliceShort(a);
    }

    public static ShortList asShortList(List<Short> genericList) {
        return genericList instanceof ShortList ? (ShortList)genericList : new ShortListWrapper(genericList);
    }

    public static float getFloat(List<Float> list, int index) {
        if (list instanceof FloatList) {
            return ((FloatList)list).getFloat(index);
        }
        return list.get(index).floatValue();
    }

    public static void setFloat(List<Float> list, int index, float value) {
        if (list instanceof FloatList) {
            ((FloatList)list).setFloat(index, value);
        } else {
            list.set(index, Float.valueOf(value));
        }
    }

    @WritableValue
    @FixedLengthValue
    public static FloatList floatArrayAsList(@LiveValue @WritableValue float[] array, int offset, int length) {
        return new FixedLengthArrayWrapperFloatList(array, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static FloatList floatArrayAsList(float ... array) {
        return new FixedLengthArrayWrapperFloatList(array);
    }

    @WritableValue
    @FixedLengthValue
    public static FloatList floatArrayAsList(@LiveValue @WritableValue Slice<float[]> arraySlice) {
        return new FixedLengthArrayWrapperFloatList(arraySlice);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static FloatList floatArrayAsMutableList(@SnapshotValue @ReadonlyValue float[] array, int offset, int length) {
        return new FloatArrayList(new FixedLengthArrayWrapperFloatList(array, offset, length));
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static FloatList floatArrayAsMutableList(float ... array) {
        return PrimitiveCollections.floatArrayAsMutableList(array, 0, array.length);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static FloatList floatArrayAsMutableList(@SnapshotValue @ReadonlyValue Slice<float[]> arraySlice) {
        return PrimitiveCollections.floatArrayAsMutableList(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    @Nonnull
    public static FloatList uniquedOfPresorted(@ReadonlyValue @Nonnull FloatList presorted) {
        int n = presorted.size();
        FloatArrayList uniqued = new FloatArrayList(n);
        float last = 0.0f;
        int i = 0;
        while (i < n) {
            float e = presorted.getFloat(0);
            if (i == 0) {
                last = e;
                uniqued.addFloat(e);
            } else if (e != last) {
                last = e;
                uniqued.addFloat(e);
            }
            ++i;
        }
        return uniqued;
    }

    public static final FloatList emptyFloatList() {
        return ImmutableFloatArrayList.Empty;
    }

    public static final FloatList singletonFloatList(float v) {
        return ImmutableFloatArrayList.newLIVE(new float[]{v});
    }

    public static FloatList unmodifiableFloatList(FloatList floatList) {
        return floatList instanceof UnmodifiableFloatListWrapper ? floatList : new UnmodifiableFloatListWrapper(floatList);
    }

    @ThrowAwayValue
    public static float[] toFloatArray(Collection<Float> genericCollection) {
        if (genericCollection instanceof FloatCollection) {
            return ((FloatCollection)genericCollection).toFloatArray();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof float[]) {
                float[] a = new float[size];
                System.arraycopy(und, u.getOffset(), a, 0, size);
                return a;
            }
        }
        float[] a = new float[genericCollection.size()];
        int i = 0;
        for (Float e : genericCollection) {
            a[i++] = e.floatValue();
        }
        return a;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static Slice<float[]> toFloatArrayPossiblyLive(Collection<Float> genericCollection) {
        if (genericCollection instanceof FloatCollection) {
            return ((FloatCollection)genericCollection).toFloatArraySlicePossiblyLive();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice<float[]> u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof float[]) {
                return u;
            }
        }
        float[] a = new float[genericCollection.size()];
        int i = 0;
        for (Float e : genericCollection) {
            a[i++] = e.floatValue();
        }
        return ArrayUtilities.wholeArraySliceFloat(a);
    }

    public static FloatList asFloatList(List<Float> genericList) {
        return genericList instanceof FloatList ? (FloatList)genericList : new FloatListWrapper(genericList);
    }

    public static int getInt(List<Integer> list, int index) {
        if (list instanceof IntegerList) {
            return ((IntegerList)list).getInt(index);
        }
        return list.get(index);
    }

    public static void setInt(List<Integer> list, int index, int value) {
        if (list instanceof IntegerList) {
            ((IntegerList)list).setInt(index, value);
        } else {
            list.set(index, value);
        }
    }

    @WritableValue
    @FixedLengthValue
    public static IntegerList intArrayAsList(@LiveValue @WritableValue int[] array, int offset, int length) {
        return new FixedLengthArrayWrapperIntegerList(array, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static IntegerList intArrayAsList(int ... array) {
        return new FixedLengthArrayWrapperIntegerList(array);
    }

    @WritableValue
    @FixedLengthValue
    public static IntegerList intArrayAsList(@LiveValue @WritableValue Slice<int[]> arraySlice) {
        return new FixedLengthArrayWrapperIntegerList(arraySlice);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static IntegerList intArrayAsMutableList(@SnapshotValue @ReadonlyValue int[] array, int offset, int length) {
        return new IntegerArrayList(new FixedLengthArrayWrapperIntegerList(array, offset, length));
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static IntegerList intArrayAsMutableList(int ... array) {
        return PrimitiveCollections.intArrayAsMutableList(array, 0, array.length);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static IntegerList intArrayAsMutableList(@SnapshotValue @ReadonlyValue Slice<int[]> arraySlice) {
        return PrimitiveCollections.intArrayAsMutableList(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    @Nonnull
    public static IntegerList uniquedOfPresorted(@ReadonlyValue @Nonnull IntegerList presorted) {
        int n = presorted.size();
        IntegerArrayList uniqued = new IntegerArrayList(n);
        int last = 0;
        int i = 0;
        while (i < n) {
            int e = presorted.getInt(0);
            if (i == 0) {
                last = e;
                uniqued.addInt(e);
            } else if (e != last) {
                last = e;
                uniqued.addInt(e);
            }
            ++i;
        }
        return uniqued;
    }

    public static final IntegerList emptyIntegerList() {
        return ImmutableIntegerArrayList.Empty;
    }

    public static final IntegerList singletonIntegerList(int v) {
        return ImmutableIntegerArrayList.newLIVE(new int[]{v});
    }

    public static IntegerList unmodifiableIntegerList(IntegerList integerList) {
        return integerList instanceof UnmodifiableIntegerListWrapper ? integerList : new UnmodifiableIntegerListWrapper(integerList);
    }

    @ThrowAwayValue
    public static int[] toIntArray(Collection<Integer> genericCollection) {
        if (genericCollection instanceof IntegerCollection) {
            return ((IntegerCollection)genericCollection).toIntArray();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof int[]) {
                int[] a = new int[size];
                System.arraycopy(und, u.getOffset(), a, 0, size);
                return a;
            }
        }
        int[] a = new int[genericCollection.size()];
        int i = 0;
        for (Integer e : genericCollection) {
            a[i++] = e;
        }
        return a;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static Slice<int[]> toIntArrayPossiblyLive(Collection<Integer> genericCollection) {
        if (genericCollection instanceof IntegerCollection) {
            return ((IntegerCollection)genericCollection).toIntArraySlicePossiblyLive();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice<int[]> u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof int[]) {
                return u;
            }
        }
        int[] a = new int[genericCollection.size()];
        int i = 0;
        for (Integer e : genericCollection) {
            a[i++] = e;
        }
        return ArrayUtilities.wholeArraySliceInt(a);
    }

    public static IntegerList asIntegerList(List<Integer> genericList) {
        return genericList instanceof IntegerList ? (IntegerList)genericList : new IntegerListWrapper(genericList);
    }

    public static double getDouble(List<Double> list, int index) {
        if (list instanceof DoubleList) {
            return ((DoubleList)list).getDouble(index);
        }
        return list.get(index);
    }

    public static void setDouble(List<Double> list, int index, double value) {
        if (list instanceof DoubleList) {
            ((DoubleList)list).setDouble(index, value);
        } else {
            list.set(index, value);
        }
    }

    @WritableValue
    @FixedLengthValue
    public static DoubleList doubleArrayAsList(@LiveValue @WritableValue double[] array, int offset, int length) {
        return new FixedLengthArrayWrapperDoubleList(array, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static DoubleList doubleArrayAsList(double ... array) {
        return new FixedLengthArrayWrapperDoubleList(array);
    }

    @WritableValue
    @FixedLengthValue
    public static DoubleList doubleArrayAsList(@LiveValue @WritableValue Slice<double[]> arraySlice) {
        return new FixedLengthArrayWrapperDoubleList(arraySlice);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static DoubleList doubleArrayAsMutableList(@SnapshotValue @ReadonlyValue double[] array, int offset, int length) {
        return new DoubleArrayList(new FixedLengthArrayWrapperDoubleList(array, offset, length));
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static DoubleList doubleArrayAsMutableList(double ... array) {
        return PrimitiveCollections.doubleArrayAsMutableList(array, 0, array.length);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static DoubleList doubleArrayAsMutableList(@SnapshotValue @ReadonlyValue Slice<double[]> arraySlice) {
        return PrimitiveCollections.doubleArrayAsMutableList(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    @Nonnull
    public static DoubleList uniquedOfPresorted(@ReadonlyValue @Nonnull DoubleList presorted) {
        int n = presorted.size();
        DoubleArrayList uniqued = new DoubleArrayList(n);
        double last = 0.0;
        int i = 0;
        while (i < n) {
            double e = presorted.getDouble(0);
            if (i == 0) {
                last = e;
                uniqued.addDouble(e);
            } else if (e != last) {
                last = e;
                uniqued.addDouble(e);
            }
            ++i;
        }
        return uniqued;
    }

    public static final DoubleList emptyDoubleList() {
        return ImmutableDoubleArrayList.Empty;
    }

    public static final DoubleList singletonDoubleList(double v) {
        return ImmutableDoubleArrayList.newLIVE(new double[]{v});
    }

    public static DoubleList unmodifiableDoubleList(DoubleList doubleList) {
        return doubleList instanceof UnmodifiableDoubleListWrapper ? doubleList : new UnmodifiableDoubleListWrapper(doubleList);
    }

    @ThrowAwayValue
    public static double[] toDoubleArray(Collection<Double> genericCollection) {
        if (genericCollection instanceof DoubleCollection) {
            return ((DoubleCollection)genericCollection).toDoubleArray();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof double[]) {
                double[] a = new double[size];
                System.arraycopy(und, u.getOffset(), a, 0, size);
                return a;
            }
        }
        double[] a = new double[genericCollection.size()];
        int i = 0;
        for (Double e : genericCollection) {
            a[i++] = e;
        }
        return a;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static Slice<double[]> toDoubleArrayPossiblyLive(Collection<Double> genericCollection) {
        if (genericCollection instanceof DoubleCollection) {
            return ((DoubleCollection)genericCollection).toDoubleArraySlicePossiblyLive();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice<double[]> u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof double[]) {
                return u;
            }
        }
        double[] a = new double[genericCollection.size()];
        int i = 0;
        for (Double e : genericCollection) {
            a[i++] = e;
        }
        return ArrayUtilities.wholeArraySliceDouble(a);
    }

    public static DoubleList asDoubleList(List<Double> genericList) {
        return genericList instanceof DoubleList ? (DoubleList)genericList : new DoubleListWrapper(genericList);
    }

    public static long getLong(List<Long> list, int index) {
        if (list instanceof LongList) {
            return ((LongList)list).getLong(index);
        }
        return list.get(index);
    }

    public static void setLong(List<Long> list, int index, long value) {
        if (list instanceof LongList) {
            ((LongList)list).setLong(index, value);
        } else {
            list.set(index, value);
        }
    }

    @WritableValue
    @FixedLengthValue
    public static LongList longArrayAsList(@LiveValue @WritableValue long[] array, int offset, int length) {
        return new FixedLengthArrayWrapperLongList(array, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static LongList longArrayAsList(long ... array) {
        return new FixedLengthArrayWrapperLongList(array);
    }

    @WritableValue
    @FixedLengthValue
    public static LongList longArrayAsList(@LiveValue @WritableValue Slice<long[]> arraySlice) {
        return new FixedLengthArrayWrapperLongList(arraySlice);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static LongList longArrayAsMutableList(@SnapshotValue @ReadonlyValue long[] array, int offset, int length) {
        return new LongArrayList(new FixedLengthArrayWrapperLongList(array, offset, length));
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static LongList longArrayAsMutableList(long ... array) {
        return PrimitiveCollections.longArrayAsMutableList(array, 0, array.length);
    }

    @ThrowAwayValue
    @WritableValue
    @VariableLengthValue
    public static LongList longArrayAsMutableList(@SnapshotValue @ReadonlyValue Slice<long[]> arraySlice) {
        return PrimitiveCollections.longArrayAsMutableList(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    @Nonnull
    public static LongList uniquedOfPresorted(@ReadonlyValue @Nonnull LongList presorted) {
        int n = presorted.size();
        LongArrayList uniqued = new LongArrayList(n);
        long last = 0L;
        int i = 0;
        while (i < n) {
            long e = presorted.getLong(0);
            if (i == 0) {
                last = e;
                uniqued.addLong(e);
            } else if (e != last) {
                last = e;
                uniqued.addLong(e);
            }
            ++i;
        }
        return uniqued;
    }

    public static final LongList emptyLongList() {
        return ImmutableLongArrayList.Empty;
    }

    public static final LongList singletonLongList(long v) {
        return ImmutableLongArrayList.newLIVE(new long[]{v});
    }

    public static LongList unmodifiableLongList(LongList longList) {
        return longList instanceof UnmodifiableLongListWrapper ? longList : new UnmodifiableLongListWrapper(longList);
    }

    @ThrowAwayValue
    public static long[] toLongArray(Collection<Long> genericCollection) {
        if (genericCollection instanceof LongCollection) {
            return ((LongCollection)genericCollection).toLongArray();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof long[]) {
                long[] a = new long[size];
                System.arraycopy(und, u.getOffset(), a, 0, size);
                return a;
            }
        }
        long[] a = new long[genericCollection.size()];
        int i = 0;
        for (Long e : genericCollection) {
            a[i++] = e;
        }
        return a;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static Slice<long[]> toLongArrayPossiblyLive(Collection<Long> genericCollection) {
        if (genericCollection instanceof LongCollection) {
            return ((LongCollection)genericCollection).toLongArraySlicePossiblyLive();
        }
        if (TransparentContiguousArrayBackedCollection.is(genericCollection)) {
            Slice<long[]> u = ((TransparentContiguousArrayBackedCollection)((Object)genericCollection)).getLiveContiguousArrayBackingUNSAFE();
            int size = genericCollection.size();
            TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
            Object und = u.getUnderlying();
            if (und instanceof long[]) {
                return u;
            }
        }
        long[] a = new long[genericCollection.size()];
        int i = 0;
        for (Long e : genericCollection) {
            a[i++] = e;
        }
        return ArrayUtilities.wholeArraySliceLong(a);
    }

    public static LongList asLongList(List<Long> genericList) {
        return genericList instanceof LongList ? (LongList)genericList : new LongListWrapper(genericList);
    }

    @ImmutableValue
    public static ByteSet bytesetof(byte ... array) {
        return new ImmutableSortedByteSetBackedByArray(array);
    }

    @ImmutableValue
    public static CharacterSet charsetof(char ... array) {
        return new ImmutableSortedCharacterSetBackedByArray(array);
    }

    @ImmutableValue
    public static ShortSet shortsetof(short ... array) {
        return new ImmutableSortedShortSetBackedByArray(array);
    }

    @ImmutableValue
    public static FloatSet floatsetof(float ... array) {
        return new ImmutableSortedFloatSetBackedByArray(array);
    }

    @ImmutableValue
    public static IntegerSet intsetof(int ... array) {
        return new ImmutableSortedIntegerSetBackedByArray(array);
    }

    @ImmutableValue
    public static DoubleSet doublesetof(double ... array) {
        return new ImmutableSortedDoubleSetBackedByArray(array);
    }

    @ImmutableValue
    public static LongSet longsetof(long ... array) {
        return new ImmutableSortedLongSetBackedByArray(array);
    }

    private static byte scintervalByte(int x) {
        return BitfieldSafeCasts.safeCastS32toS8(x);
    }

    private static short scintervalShort(int x) {
        return BitfieldSafeCasts.safeCastS32toS16(x);
    }

    private static char scintervalChar(int x) {
        return (char)BitfieldSafeCasts.safeCastS32toU16(x);
    }

    private static int scintervalInt(int x) {
        return x;
    }

    private static long scintervalLong(long x) {
        return x;
    }

    @ReadonlyValue
    public static SortedByteSetBackedByList newSortedByteSetForRange(byte inclusiveLowBound, int count) {
        return new SortedByteSetBackedByList(CollectionUtilities.intervalBytesList(inclusiveLowBound, count));
    }

    @ThrowAwayValue
    public static SortedByteSetBackedByList newSortedByteSetForRangeMutable(byte inclusiveLowBound, int count) {
        return new SortedByteSetBackedByList(new ByteArrayList(CollectionUtilities.intervalBytesArray(inclusiveLowBound, count)));
    }

    @ReadonlyValue
    public static SortedCharacterSetBackedByList newSortedCharacterSetForRange(char inclusiveLowBound, int count) {
        return new SortedCharacterSetBackedByList(CollectionUtilities.intervalCharactersList(inclusiveLowBound, count));
    }

    @ThrowAwayValue
    public static SortedCharacterSetBackedByList newSortedCharacterSetForRangeMutable(char inclusiveLowBound, int count) {
        return new SortedCharacterSetBackedByList(new CharacterArrayList(CollectionUtilities.intervalCharactersArray(inclusiveLowBound, count)));
    }

    @ReadonlyValue
    public static SortedShortSetBackedByList newSortedShortSetForRange(short inclusiveLowBound, int count) {
        return new SortedShortSetBackedByList(CollectionUtilities.intervalShortsList(inclusiveLowBound, count));
    }

    @ThrowAwayValue
    public static SortedShortSetBackedByList newSortedShortSetForRangeMutable(short inclusiveLowBound, int count) {
        return new SortedShortSetBackedByList(new ShortArrayList(CollectionUtilities.intervalShortsArray(inclusiveLowBound, count)));
    }

    @ReadonlyValue
    public static SortedIntegerSetBackedByList newSortedIntegerSetForRange(int inclusiveLowBound, int count) {
        return new SortedIntegerSetBackedByList(CollectionUtilities.intervalIntegersList(inclusiveLowBound, count));
    }

    @ThrowAwayValue
    public static SortedIntegerSetBackedByList newSortedIntegerSetForRangeMutable(int inclusiveLowBound, int count) {
        return new SortedIntegerSetBackedByList(new IntegerArrayList(CollectionUtilities.intervalIntegersArray(inclusiveLowBound, count)));
    }

    @ReadonlyValue
    public static SortedLongSetBackedByList newSortedLongSetForRange(long inclusiveLowBound, int count) {
        return new SortedLongSetBackedByList(CollectionUtilities.intervalLongsList(inclusiveLowBound, count));
    }

    @ThrowAwayValue
    public static SortedLongSetBackedByList newSortedLongSetForRangeMutable(long inclusiveLowBound, int count) {
        return new SortedLongSetBackedByList(new LongArrayList(CollectionUtilities.intervalLongsArray(inclusiveLowBound, count)));
    }

    public static BooleanCollection wrappedBooleanCollection(Collection<? extends Boolean> underlying) {
        return underlying instanceof BooleanCollection ? (BooleanCollection)underlying : new UnboxingWrapperBooleanCollection(underlying);
    }

    public static BooleanList wrappedBooleanList(List<? extends Boolean> underlying) {
        return underlying instanceof BooleanList ? (BooleanList)underlying : new UnboxingWrapperBooleanList(underlying);
    }

    public static ByteCollection wrappedByteCollection(Collection<? extends Byte> underlying) {
        return underlying instanceof ByteCollection ? (ByteCollection)underlying : new UnboxingWrapperByteCollection(underlying);
    }

    public static ByteList wrappedByteList(List<? extends Byte> underlying) {
        return underlying instanceof ByteList ? (ByteList)underlying : new UnboxingWrapperByteList(underlying);
    }

    public static CharacterCollection wrappedCharacterCollection(Collection<? extends Character> underlying) {
        return underlying instanceof CharacterCollection ? (CharacterCollection)underlying : new UnboxingWrapperCharacterCollection(underlying);
    }

    public static CharacterList wrappedCharacterList(List<? extends Character> underlying) {
        return underlying instanceof CharacterList ? (CharacterList)underlying : new UnboxingWrapperCharacterList(underlying);
    }

    public static ShortCollection wrappedShortCollection(Collection<? extends Short> underlying) {
        return underlying instanceof ShortCollection ? (ShortCollection)underlying : new UnboxingWrapperShortCollection(underlying);
    }

    public static ShortList wrappedShortList(List<? extends Short> underlying) {
        return underlying instanceof ShortList ? (ShortList)underlying : new UnboxingWrapperShortList(underlying);
    }

    public static FloatCollection wrappedFloatCollection(Collection<? extends Float> underlying) {
        return underlying instanceof FloatCollection ? (FloatCollection)underlying : new UnboxingWrapperFloatCollection(underlying);
    }

    public static FloatList wrappedFloatList(List<? extends Float> underlying) {
        return underlying instanceof FloatList ? (FloatList)underlying : new UnboxingWrapperFloatList(underlying);
    }

    public static IntegerCollection wrappedIntegerCollection(Collection<? extends Integer> underlying) {
        return underlying instanceof IntegerCollection ? (IntegerCollection)underlying : new UnboxingWrapperIntegerCollection(underlying);
    }

    public static IntegerList wrappedIntegerList(List<? extends Integer> underlying) {
        return underlying instanceof IntegerList ? (IntegerList)underlying : new UnboxingWrapperIntegerList(underlying);
    }

    public static DoubleCollection wrappedDoubleCollection(Collection<? extends Double> underlying) {
        return underlying instanceof DoubleCollection ? (DoubleCollection)underlying : new UnboxingWrapperDoubleCollection(underlying);
    }

    public static DoubleList wrappedDoubleList(List<? extends Double> underlying) {
        return underlying instanceof DoubleList ? (DoubleList)underlying : new UnboxingWrapperDoubleList(underlying);
    }

    public static LongCollection wrappedLongCollection(Collection<? extends Long> underlying) {
        return underlying instanceof LongCollection ? (LongCollection)underlying : new UnboxingWrapperLongCollection(underlying);
    }

    public static LongList wrappedLongList(List<? extends Long> underlying) {
        return underlying instanceof LongList ? (LongList)underlying : new UnboxingWrapperLongList(underlying);
    }

    @WritableValue
    @FixedLengthValue
    public static ByteList byteBufferAsList(@LiveValue @WritableValue ByteBuffer buffer, int offset, int length) {
        return new FixedLengthBufferWrapperByteList(buffer, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static ByteList byteBufferAsList(@LiveValue @WritableValue ByteBuffer buffer) {
        return new FixedLengthBufferWrapperByteList(buffer);
    }

    @WritableValue
    @FixedLengthValue
    public static ByteList byteBufferAsList(@LiveValue @WritableValue Slice<ByteBuffer> bufferSlice) {
        return PrimitiveCollections.byteBufferAsList(bufferSlice.getUnderlying(), bufferSlice.getOffset(), bufferSlice.getLength());
    }

    @WritableValue
    @FixedLengthValue
    public static CharacterList charBufferAsList(@LiveValue @WritableValue CharBuffer buffer, int offset, int length) {
        return new FixedLengthBufferWrapperCharacterList(buffer, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static CharacterList charBufferAsList(@LiveValue @WritableValue CharBuffer buffer) {
        return new FixedLengthBufferWrapperCharacterList(buffer);
    }

    @WritableValue
    @FixedLengthValue
    public static CharacterList charBufferAsList(@LiveValue @WritableValue Slice<CharBuffer> bufferSlice) {
        return PrimitiveCollections.charBufferAsList(bufferSlice.getUnderlying(), bufferSlice.getOffset(), bufferSlice.getLength());
    }

    @WritableValue
    @FixedLengthValue
    public static ShortList shortBufferAsList(@LiveValue @WritableValue ShortBuffer buffer, int offset, int length) {
        return new FixedLengthBufferWrapperShortList(buffer, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static ShortList shortBufferAsList(@LiveValue @WritableValue ShortBuffer buffer) {
        return new FixedLengthBufferWrapperShortList(buffer);
    }

    @WritableValue
    @FixedLengthValue
    public static ShortList shortBufferAsList(@LiveValue @WritableValue Slice<ShortBuffer> bufferSlice) {
        return PrimitiveCollections.shortBufferAsList(bufferSlice.getUnderlying(), bufferSlice.getOffset(), bufferSlice.getLength());
    }

    @WritableValue
    @FixedLengthValue
    public static FloatList floatBufferAsList(@LiveValue @WritableValue FloatBuffer buffer, int offset, int length) {
        return new FixedLengthBufferWrapperFloatList(buffer, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static FloatList floatBufferAsList(@LiveValue @WritableValue FloatBuffer buffer) {
        return new FixedLengthBufferWrapperFloatList(buffer);
    }

    @WritableValue
    @FixedLengthValue
    public static FloatList floatBufferAsList(@LiveValue @WritableValue Slice<FloatBuffer> bufferSlice) {
        return PrimitiveCollections.floatBufferAsList(bufferSlice.getUnderlying(), bufferSlice.getOffset(), bufferSlice.getLength());
    }

    @WritableValue
    @FixedLengthValue
    public static IntegerList intBufferAsList(@LiveValue @WritableValue IntBuffer buffer, int offset, int length) {
        return new FixedLengthBufferWrapperIntegerList(buffer, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static IntegerList intBufferAsList(@LiveValue @WritableValue IntBuffer buffer) {
        return new FixedLengthBufferWrapperIntegerList(buffer);
    }

    @WritableValue
    @FixedLengthValue
    public static IntegerList intBufferAsList(@LiveValue @WritableValue Slice<IntBuffer> bufferSlice) {
        return PrimitiveCollections.intBufferAsList(bufferSlice.getUnderlying(), bufferSlice.getOffset(), bufferSlice.getLength());
    }

    @WritableValue
    @FixedLengthValue
    public static DoubleList doubleBufferAsList(@LiveValue @WritableValue DoubleBuffer buffer, int offset, int length) {
        return new FixedLengthBufferWrapperDoubleList(buffer, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static DoubleList doubleBufferAsList(@LiveValue @WritableValue DoubleBuffer buffer) {
        return new FixedLengthBufferWrapperDoubleList(buffer);
    }

    @WritableValue
    @FixedLengthValue
    public static DoubleList doubleBufferAsList(@LiveValue @WritableValue Slice<DoubleBuffer> bufferSlice) {
        return PrimitiveCollections.doubleBufferAsList(bufferSlice.getUnderlying(), bufferSlice.getOffset(), bufferSlice.getLength());
    }

    @WritableValue
    @FixedLengthValue
    public static LongList longBufferAsList(@LiveValue @WritableValue LongBuffer buffer, int offset, int length) {
        return new FixedLengthBufferWrapperLongList(buffer, offset, length);
    }

    @WritableValue
    @FixedLengthValue
    public static LongList longBufferAsList(@LiveValue @WritableValue LongBuffer buffer) {
        return new FixedLengthBufferWrapperLongList(buffer);
    }

    @WritableValue
    @FixedLengthValue
    public static LongList longBufferAsList(@LiveValue @WritableValue Slice<LongBuffer> bufferSlice) {
        return PrimitiveCollections.longBufferAsList(bufferSlice.getUnderlying(), bufferSlice.getOffset(), bufferSlice.getLength());
    }

    @ImmutableValue
    public static ImmutableByteArrayList mapToImmutableByteList(FunctionInterfaces.UnaryFunctionByteToByte mapper, @ReadonlyValue ByteList input) {
        int l = input.size();
        byte[] a = new byte[l];
        int i = 0;
        while (i < l) {
            a[i] = mapper.f(input.getByte(i));
            ++i;
        }
        return ImmutableByteArrayList.newLIVE(a);
    }

    public static int getByteListCardinality(List<Byte> list) {
        int n = list.size();
        if (n < 2) {
            return n;
        }
        if (n == 2) {
            if (list instanceof ByteList) {
                ByteList primlist = (ByteList)list;
                return primlist.getByte(0) == primlist.getByte(1) ? 1 : 2;
            }
            return Primitives.eq(list.get(0), list.get(1)) ? 1 : 2;
        }
        if (n == 3) {
            if (list instanceof ByteList) {
                ByteList primlist = (ByteList)list;
                byte a = primlist.getByte(0);
                byte b = primlist.getByte(1);
                byte c = primlist.getByte(2);
                return a == b ? (CodeHinting.arbitrary(a, b) == c ? 1 : 2) : (a == c ? 2 : (b == c ? 2 : 3));
            }
            Byte a = list.get(0);
            Byte b = list.get(1);
            Byte c = list.get(2);
            return Primitives.eq(a, b) ? (Primitives.eq(CodeHinting.arbitrary(a, b), c) ? 1 : 2) : (Primitives.eq(a, c) ? 2 : (Primitives.eq(b, c) ? 2 : 3));
        }
        SortedByteSetBackedByList s = new SortedByteSetBackedByList(new ByteArrayList(list.size()));
        s.addAll((Collection<? extends Byte>)list);
        return s.size();
    }

    @ImmutableValue
    public static ImmutableCharacterArrayList mapToImmutableCharList(FunctionInterfaces.UnaryFunctionCharToChar mapper, @ReadonlyValue CharacterList input) {
        int l = input.size();
        char[] a = new char[l];
        int i = 0;
        while (i < l) {
            a[i] = mapper.f(input.getChar(i));
            ++i;
        }
        return ImmutableCharacterArrayList.newLIVE(a);
    }

    public static int getCharacterListCardinality(List<Character> list) {
        int n = list.size();
        if (n < 2) {
            return n;
        }
        if (n == 2) {
            if (list instanceof CharacterList) {
                CharacterList primlist = (CharacterList)list;
                return primlist.getChar(0) == primlist.getChar(1) ? 1 : 2;
            }
            return Primitives.eq(list.get(0), list.get(1)) ? 1 : 2;
        }
        if (n == 3) {
            if (list instanceof CharacterList) {
                CharacterList primlist = (CharacterList)list;
                char a = primlist.getChar(0);
                char b = primlist.getChar(1);
                char c = primlist.getChar(2);
                return a == b ? (CodeHinting.arbitrary(a, b) == c ? 1 : 2) : (a == c ? 2 : (b == c ? 2 : 3));
            }
            Character a = list.get(0);
            Character b = list.get(1);
            Character c = list.get(2);
            return Primitives.eq(a, b) ? (Primitives.eq(CodeHinting.arbitrary(a, b), c) ? 1 : 2) : (Primitives.eq(a, c) ? 2 : (Primitives.eq(b, c) ? 2 : 3));
        }
        SortedCharacterSetBackedByList s = new SortedCharacterSetBackedByList(new CharacterArrayList(list.size()));
        s.addAll((Collection<? extends Character>)list);
        return s.size();
    }

    @ImmutableValue
    public static ImmutableShortArrayList mapToImmutableShortList(FunctionInterfaces.UnaryFunctionShortToShort mapper, @ReadonlyValue ShortList input) {
        int l = input.size();
        short[] a = new short[l];
        int i = 0;
        while (i < l) {
            a[i] = mapper.f(input.getShort(i));
            ++i;
        }
        return ImmutableShortArrayList.newLIVE(a);
    }

    public static int getShortListCardinality(List<Short> list) {
        int n = list.size();
        if (n < 2) {
            return n;
        }
        if (n == 2) {
            if (list instanceof ShortList) {
                ShortList primlist = (ShortList)list;
                return primlist.getShort(0) == primlist.getShort(1) ? 1 : 2;
            }
            return Primitives.eq(list.get(0), list.get(1)) ? 1 : 2;
        }
        if (n == 3) {
            if (list instanceof ShortList) {
                ShortList primlist = (ShortList)list;
                short a = primlist.getShort(0);
                short b = primlist.getShort(1);
                short c = primlist.getShort(2);
                return a == b ? (CodeHinting.arbitrary(a, b) == c ? 1 : 2) : (a == c ? 2 : (b == c ? 2 : 3));
            }
            Short a = list.get(0);
            Short b = list.get(1);
            Short c = list.get(2);
            return Primitives.eq(a, b) ? (Primitives.eq(CodeHinting.arbitrary(a, b), c) ? 1 : 2) : (Primitives.eq(a, c) ? 2 : (Primitives.eq(b, c) ? 2 : 3));
        }
        SortedShortSetBackedByList s = new SortedShortSetBackedByList(new ShortArrayList(list.size()));
        s.addAll((Collection<? extends Short>)list);
        return s.size();
    }

    @ImmutableValue
    public static ImmutableFloatArrayList mapToImmutableFloatList(FunctionInterfaces.UnaryFunctionFloatToFloat mapper, @ReadonlyValue FloatList input) {
        int l = input.size();
        float[] a = new float[l];
        int i = 0;
        while (i < l) {
            a[i] = mapper.f(input.getFloat(i));
            ++i;
        }
        return ImmutableFloatArrayList.newLIVE(a);
    }

    public static int getFloatListCardinality(List<Float> list) {
        int n = list.size();
        if (n < 2) {
            return n;
        }
        if (n == 2) {
            if (list instanceof FloatList) {
                FloatList primlist = (FloatList)list;
                return primlist.getFloat(0) == primlist.getFloat(1) ? 1 : 2;
            }
            return Primitives.eq(list.get(0), list.get(1)) ? 1 : 2;
        }
        if (n == 3) {
            if (list instanceof FloatList) {
                FloatList primlist = (FloatList)list;
                float a = primlist.getFloat(0);
                float b = primlist.getFloat(1);
                float c = primlist.getFloat(2);
                return a == b ? (CodeHinting.arbitrary(a, b) == c ? 1 : 2) : (a == c ? 2 : (b == c ? 2 : 3));
            }
            Float a = list.get(0);
            Float b = list.get(1);
            Float c = list.get(2);
            return Primitives.eq(a, b) ? (Primitives.eq(CodeHinting.arbitrary(a, b), c) ? 1 : 2) : (Primitives.eq(a, c) ? 2 : (Primitives.eq(b, c) ? 2 : 3));
        }
        SortedFloatSetBackedByList s = new SortedFloatSetBackedByList(new FloatArrayList(list.size()));
        s.addAll((Collection<? extends Float>)list);
        return s.size();
    }

    @ImmutableValue
    public static ImmutableIntegerArrayList mapToImmutableIntList(FunctionInterfaces.UnaryFunctionIntToInt mapper, @ReadonlyValue IntegerList input) {
        int l = input.size();
        int[] a = new int[l];
        int i = 0;
        while (i < l) {
            a[i] = mapper.f(input.getInt(i));
            ++i;
        }
        return ImmutableIntegerArrayList.newLIVE(a);
    }

    public static int getIntegerListCardinality(List<Integer> list) {
        int n = list.size();
        if (n < 2) {
            return n;
        }
        if (n == 2) {
            if (list instanceof IntegerList) {
                IntegerList primlist = (IntegerList)list;
                return primlist.getInt(0) == primlist.getInt(1) ? 1 : 2;
            }
            return Primitives.eq(list.get(0), list.get(1)) ? 1 : 2;
        }
        if (n == 3) {
            if (list instanceof IntegerList) {
                IntegerList primlist = (IntegerList)list;
                int a = primlist.getInt(0);
                int b = primlist.getInt(1);
                int c = primlist.getInt(2);
                return a == b ? (CodeHinting.arbitrary(a, b) == c ? 1 : 2) : (a == c ? 2 : (b == c ? 2 : 3));
            }
            Integer a = list.get(0);
            Integer b = list.get(1);
            Integer c = list.get(2);
            return Primitives.eq(a, b) ? (Primitives.eq(CodeHinting.arbitrary(a, b), c) ? 1 : 2) : (Primitives.eq(a, c) ? 2 : (Primitives.eq(b, c) ? 2 : 3));
        }
        SortedIntegerSetBackedByList s = new SortedIntegerSetBackedByList(new IntegerArrayList(list.size()));
        s.addAll((Collection<? extends Integer>)list);
        return s.size();
    }

    @ImmutableValue
    public static ImmutableDoubleArrayList mapToImmutableDoubleList(FunctionInterfaces.UnaryFunctionDoubleToDouble mapper, @ReadonlyValue DoubleList input) {
        int l = input.size();
        double[] a = new double[l];
        int i = 0;
        while (i < l) {
            a[i] = mapper.f(input.getDouble(i));
            ++i;
        }
        return ImmutableDoubleArrayList.newLIVE(a);
    }

    public static int getDoubleListCardinality(List<Double> list) {
        int n = list.size();
        if (n < 2) {
            return n;
        }
        if (n == 2) {
            if (list instanceof DoubleList) {
                DoubleList primlist = (DoubleList)list;
                return primlist.getDouble(0) == primlist.getDouble(1) ? 1 : 2;
            }
            return Primitives.eq(list.get(0), list.get(1)) ? 1 : 2;
        }
        if (n == 3) {
            if (list instanceof DoubleList) {
                DoubleList primlist = (DoubleList)list;
                double a = primlist.getDouble(0);
                double b = primlist.getDouble(1);
                double c = primlist.getDouble(2);
                return a == b ? (CodeHinting.arbitrary(a, b) == c ? 1 : 2) : (a == c ? 2 : (b == c ? 2 : 3));
            }
            Double a = list.get(0);
            Double b = list.get(1);
            Double c = list.get(2);
            return Primitives.eq(a, b) ? (Primitives.eq(CodeHinting.arbitrary(a, b), c) ? 1 : 2) : (Primitives.eq(a, c) ? 2 : (Primitives.eq(b, c) ? 2 : 3));
        }
        SortedDoubleSetBackedByList s = new SortedDoubleSetBackedByList(new DoubleArrayList(list.size()));
        s.addAll((Collection<? extends Double>)list);
        return s.size();
    }

    @ImmutableValue
    public static ImmutableLongArrayList mapToImmutableLongList(FunctionInterfaces.UnaryFunctionLongToLong mapper, @ReadonlyValue LongList input) {
        int l = input.size();
        long[] a = new long[l];
        int i = 0;
        while (i < l) {
            a[i] = mapper.f(input.getLong(i));
            ++i;
        }
        return ImmutableLongArrayList.newLIVE(a);
    }

    public static int getLongListCardinality(List<Long> list) {
        int n = list.size();
        if (n < 2) {
            return n;
        }
        if (n == 2) {
            if (list instanceof LongList) {
                LongList primlist = (LongList)list;
                return primlist.getLong(0) == primlist.getLong(1) ? 1 : 2;
            }
            return Primitives.eq(list.get(0), list.get(1)) ? 1 : 2;
        }
        if (n == 3) {
            if (list instanceof LongList) {
                LongList primlist = (LongList)list;
                long a = primlist.getLong(0);
                long b = primlist.getLong(1);
                long c = primlist.getLong(2);
                return a == b ? (CodeHinting.arbitrary(a, b) == c ? 1 : 2) : (a == c ? 2 : (b == c ? 2 : 3));
            }
            Long a = list.get(0);
            Long b = list.get(1);
            Long c = list.get(2);
            return Primitives.eq(a, b) ? (Primitives.eq(CodeHinting.arbitrary(a, b), c) ? 1 : 2) : (Primitives.eq(a, c) ? 2 : (Primitives.eq(b, c) ? 2 : 3));
        }
        SortedLongSetBackedByList s = new SortedLongSetBackedByList(new LongArrayList(list.size()));
        s.addAll((Collection<? extends Long>)list);
        return s.size();
    }

    public static class BooleanArrayList
    implements DefaultShiftingBasedBooleanList,
    ListWithSetSize<Boolean>,
    Trimmable,
    TransparentContiguousArrayBackedCollection<boolean[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected int size = 0;
        protected boolean[] data;
        protected Grower.GrowerComputationallyUnreducedPurelyRecursive grower;

        protected BooleanArrayList(Void thisiswhyyoushouldntusejavaconstructorsAlthoughIdontknowhowtomakeinheritanceworkwellwithoutinitmethodsorfactoriesorsomething) {
        }

        public BooleanArrayList(int initialCapacity, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = initialCapacity == 0 ? ArrayUtilities.EmptyBooleanArray : new boolean[initialCapacity];
            this.grower = grower;
        }

        public BooleanArrayList(@LiveValue @WritableValue boolean[] LIVEBACKING, int size, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = LIVEBACKING;
            this.grower = grower;
            this.size = size;
        }

        public BooleanArrayList(@SnapshotValue @ReadonlyValue Collection<Boolean> c, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this(c.size(), grower);
            this.addAll((Collection<? extends Boolean>)c);
        }

        public BooleanArrayList() {
            this(16);
        }

        public BooleanArrayList(int initialCapacity) {
            this(initialCapacity, PrimitiveCollections.defaultPrimitiveArrayListGrower(initialCapacity));
        }

        public BooleanArrayList(@SnapshotValue @ReadonlyValue Collection<Boolean> c) {
            this(c, PrimitiveCollections.defaultPrimitiveArrayListGrower(c.size()));
        }

        public BooleanArrayList(@LiveValue @WritableValue boolean[] LIVEBACKING, int size) {
            this(LIVEBACKING, size, PrimitiveCollections.defaultPrimitiveArrayListGrower(LIVEBACKING.length));
        }

        public BooleanArrayList(@LiveValue @WritableValue boolean[] LIVEBACKING) {
            this(LIVEBACKING, LIVEBACKING.length);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return false;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public void setSize(int newSize) {
            this.ensureCapacity(newSize);
            this.size = newSize;
        }

        protected void setupClone(BooleanArrayList freshClone) {
            freshClone.size = this.size;
            freshClone.data = new boolean[this.size];
            System.arraycopy(this.data, 0, freshClone.data, 0, this.size);
            freshClone.grower = this.grower;
        }

        @Override
        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        public BooleanArrayList clone() {
            BooleanArrayList clone = new BooleanArrayList();
            this.setupClone(clone);
            return clone;
        }

        @Override
        @ImplementationTransparency
        @LiveValue
        public Slice<boolean[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<boolean[]>(this.data, 0, this.size);
        }

        public void sort() {
            PrimitiveCollections.sortArray(this.data, 0, this.size);
        }

        @Override
        public void setBoolean(int index, boolean value) {
            CollectionUtilities.rangeCheckMember(this.size, index);
            this.data[index] = value;
        }

        @Override
        public boolean getBoolean(int index) {
            CollectionUtilities.rangeCheckMember(this.size(), index);
            return this.data[index];
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public void clear() {
            this.size = 0;
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public int size() {
            return this.size;
        }

        @ImplementationTransparency
        public void trimToSize() {
            boolean[] newdata = new boolean[this.size];
            System.arraycopy(this.data, 0, newdata, 0, this.size);
            this.data = newdata;
        }

        @Override
        public Trimmable.TrimmableTrimRV couldYouMaybeUseALittleLessMemoryIfYouDontMind() {
            this.trimToSize();
            return Trimmable.TrimmableTrimRV.DontKeepInvoking;
        }

        @ImplementationTransparency
        public int getCapacity() {
            return this.data.length;
        }

        @ImplementationTransparency
        public void ensureCapacity(int minCapacity) {
            if (this.data.length < minCapacity) {
                int newCapacity = this.getNewCapacity(minCapacity);
                boolean[] newData = new boolean[newCapacity];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
        }

        @Override
        public void clearHinting(int newCapacity) {
            this.clear();
            this.ensureCapacity(newCapacity);
        }

        @ImplementationTransparency
        public int getNewCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new IllegalArgumentException();
            }
            return Math.max(minCapacity, this.grower.getNewSizeRecursive(this.data.length));
        }

        @ImplementationTransparency
        public void setDirectBuffer(@LiveValue boolean[] array) {
            if (array.length < this.size) {
                throw new IllegalArgumentException("Array is too small; size=" + this.size + ", capacity=" + array.length);
            }
            this.data = array;
        }

        public String toString() {
            return this._toString();
        }
    }

    @SignalType
    public static interface BooleanCollection
    extends PrimitiveCollection<Boolean, boolean[]>,
    SimpleBooleanIterable {
        public boolean addBoolean(boolean var1);

        public boolean removeBoolean(boolean var1);

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class getPrimitiveType() {
            return Boolean.TYPE;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<Boolean> getBoxedType() {
            return Boolean.class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<boolean[]> getArrayType() {
            return boolean[].class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Boolean getDefaultElement() {
            return false;
        }

        @ThrowAwayValue
        public static boolean[] defaultToBooleanArray(BooleanCollection collection) {
            boolean[] array = new boolean[collection.size()];
            SimpleBooleanIterator i = collection.newSimpleBooleanIterator();
            int index = 0;
            while (true) {
                try {
                    array[index] = i.nextrpBoolean();
                }
                catch (StopIterationReturnPath exc) {
                    break;
                }
                ++index;
            }
            return array;
        }

        @ThrowAwayValue
        default public boolean[] toBooleanArray() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<boolean[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof boolean[]) {
                    return ArrayUtilities.sliceToNewBooleanArrayOP(u);
                }
            }
            return BooleanCollection.defaultToBooleanArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public boolean[] toBooleanArrayPossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                int size = this.size();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                Object und = u.getUnderlying();
                if (und instanceof boolean[] && u.getOffset() == 0 && ((boolean[])und).length == size) {
                    return (boolean[])und;
                }
            }
            return BooleanCollection.defaultToBooleanArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public Slice<boolean[]> toBooleanArraySlicePossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<boolean[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof boolean[]) {
                    return u;
                }
            }
            return ArrayUtilities.wholeArraySliceBoolean(BooleanCollection.defaultToBooleanArray(this));
        }

        @LiveValue
        @Nullable
        default public Slice<boolean[]> toBooleanArraySliceLiveOrNull() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<boolean[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof boolean[]) {
                    return u;
                }
            }
            return null;
        }

        default public boolean containsBoolean(boolean value) {
            SimpleBooleanIterator i = this.newSimpleBooleanIterator();
            try {
                while (!Primitives.eqSane(i.nextrpBoolean(), value)) {
                }
                return true;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return false;
            }
        }

        @Override
        default public Iterator<Boolean> iterator() {
            return SimpleBooleanIterable.super.iterator();
        }

        @Override
        default public boolean isEmpty() {
            return this.size() == 0;
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllBooleans(boolean[] array) {
            return this.addAllBooleans(array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllBooleans(Slice<boolean[]> arraySlice) {
            return this.addAllBooleans(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllBooleans(boolean[] elements, int offset, int length) {
            return BooleanCollection.defaultAddAllBooleans(this, elements, offset, length);
        }

        public static boolean defaultAddAllBooleans(BooleanCollection self, boolean[] elements, int offset, int length) {
            boolean changedAtAll = false;
            int e = offset + length;
            int i = offset;
            while (i < e) {
                changedAtAll |= self.addBoolean(elements[i]);
                ++i;
            }
            return changedAtAll;
        }

        default public void removeAllBooleans(boolean[] array) {
            this.removeAllBooleans(array, 0, array.length);
        }

        default public void removeAllBooleans(Slice<boolean[]> arraySlice) {
            this.removeAllBooleans(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public void removeAllBooleans(boolean[] a, int offset, int length) {
            int e = offset + length;
            int i = offset;
            while (i < e) {
                this.removeBoolean(a[i]);
                ++i;
            }
        }

        @Override
        default public boolean contains(Object o) {
            return o instanceof Boolean && this.containsBoolean((Boolean)o);
        }

        @Override
        default public boolean add(Boolean e) {
            return this.addBoolean(e);
        }

        @Override
        default public boolean remove(Object o) {
            return o instanceof Boolean && this.removeBoolean((Boolean)o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            if (c instanceof BooleanCollection) {
                BooleanCollection cc = (BooleanCollection)c;
                SimpleBooleanIterator i = cc.newSimpleBooleanIterator();
                try {
                    while (!this.containsBoolean(i.nextrpBoolean())) {
                    }
                    return true;
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return false;
                }
            }
            for (Object e : c) {
                if (!this.contains(e)) continue;
                return true;
            }
            return false;
        }

        @Override
        default public boolean addAll(Collection<? extends Boolean> c) {
            if (c instanceof BooleanCollection) {
                boolean changedAtAll = false;
                SimpleBooleanIterator simpleBooleanIterator = ((BooleanCollection)c).newSimpleBooleanIterator();
                try {
                    while (true) {
                        changedAtAll |= this.add(simpleBooleanIterator.nextrpBoolean());
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Boolean bl : c) {
                changedAtAll |= this.add(bl);
            }
            return changedAtAll;
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            if (c instanceof BooleanCollection) {
                boolean changedAtAll = false;
                SimpleBooleanIterator i = ((BooleanCollection)c).newSimpleBooleanIterator();
                try {
                    while (true) {
                        changedAtAll |= this.remove(i.nextrpBoolean());
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Object e : c) {
                changedAtAll |= this.remove(e);
            }
            return changedAtAll;
        }

        @Override
        default public void setFrom(Object source) {
            block8: {
                if (source == this) {
                    return;
                }
                if (source instanceof BooleanCollection) {
                    BooleanCollection s = (BooleanCollection)source;
                    this.clearHinting(s.size());
                    SimpleBooleanIterator i = s.newSimpleBooleanIterator();
                    while (true) {
                        boolean e;
                        try {
                            e = i.nextrpBoolean();
                        }
                        catch (StopIterationReturnPath exc) {
                            break block8;
                        }
                        this.addBoolean(e);
                    }
                }
                if (source instanceof Collection) {
                    Collection s = (Collection)source;
                    this.clearHinting(s.size());
                    for (Boolean e : s) {
                        this.addBoolean(e);
                    }
                } else {
                    throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(source);
                }
            }
        }

        default public void clearHinting(int newCapacity) {
            this.clear();
        }

        @Override
        default public String _toString() {
            return PrimitiveCollections.defaultToString(this);
        }
    }

    @SignalType
    public static interface BooleanList
    extends PrimitiveList<Boolean, boolean[]>,
    NonuniformMethodsForBooleanList,
    BooleanListRO,
    BooleanListRWFixed {
        @Override
        default public Iterator<Boolean> iterator() {
            return NonuniformMethodsForBooleanList.super.iterator();
        }

        public void insertBoolean(int var1, boolean var2);

        public BooleanList clone();

        public void setSizeBoolean(int var1, boolean var2);

        @Override
        default public void setSize(int newSize, Boolean elementToAddIfGrowing) {
            this.setSizeBoolean(newSize, elementToAddIfGrowing);
        }

        @Override
        default public void setSize(int newSize) {
            this.setSizeBoolean(newSize, false);
        }

        @Override
        default public void clear() {
            this.setSize(0);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllBooleans(int index, boolean[] array) {
            this.setAllBooleans(index, array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllBooleans(int index, Slice<boolean[]> arraySlice) {
            this.setAllBooleans(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        default public void setAllBooleans(int start, boolean[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof boolean[]) {
                    Slice s = u;
                    System.arraycopy(array, offset, s.getUnderlying(), s.getOffset() + start, length);
                    return;
                }
            }
            BooleanList.defaultSetAllBooleans(this, start, array, offset, length);
        }

        public static void defaultSetAllBooleans(BooleanList list, int start, @WritableValue boolean[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                list.setBoolean(start + i, array[offset + i]);
                ++i;
            }
        }

        default public void setAll(int destIndex, List sourceU, int sourceIndex, @Nonnegative int amount) throws IndexOutOfBoundsException {
            List source = sourceU;
            BooleanList dest = this;
            int sourceSize = source.size();
            int destSize = dest.size();
            CollectionUtilities.rangeCheckIntervalByLength(sourceSize, sourceIndex, amount);
            CollectionUtilities.rangeCheckIntervalByLength(destSize, destIndex, amount);
            if (TransparentContiguousArrayBackedCollection.is(source)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)source)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(sourceSize, u);
                if (u.getUnderlying() instanceof boolean[]) {
                    Slice s = u;
                    this.setAllBooleans(destIndex, (Slice)s.subslice(sourceIndex, amount));
                    return;
                }
            }
            if (source instanceof BooleanList) {
                BooleanList primSource = (BooleanList)source;
                if (destIndex < sourceIndex) {
                    int i = 0;
                    while (i < amount) {
                        dest.setBoolean(destIndex + i, primSource.getBoolean(sourceIndex + i));
                        ++i;
                    }
                } else {
                    int i = amount - 1;
                    while (i >= 0) {
                        dest.setBoolean(destIndex + i, primSource.getBoolean(sourceIndex + i));
                        --i;
                    }
                }
            } else if (destIndex < sourceIndex) {
                int i = 0;
                while (i < amount) {
                    dest.set(destIndex + i, (Boolean)source.get(sourceIndex + i));
                    ++i;
                }
            } else {
                int i = amount - 1;
                while (i >= 0) {
                    dest.set(destIndex + i, (Boolean)source.get(sourceIndex + i));
                    --i;
                }
            }
        }

        default public void getAllBooleans(int start, @WritableValue boolean[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof boolean[]) {
                    Slice s = u;
                    System.arraycopy(s.getUnderlying(), s.getOffset() + start, array, offset, length);
                    return;
                }
            }
            BooleanList.defaultGetAllBooleans(this, start, array, offset, length);
        }

        public static void defaultGetAllBooleans(BooleanList list, int start, @WritableValue boolean[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                array[offset + i] = list.getBoolean(start + i);
                ++i;
            }
        }

        @ThrowAwayValue
        default public boolean[] getAllBooleans(int start, int end) {
            CollectionUtilities.rangeCheckInterval(this.size(), start, end);
            boolean[] buff = new boolean[end - start];
            this.getAllBooleans(start, buff, 0, buff.length);
            return buff;
        }

        @Override
        default public boolean addBoolean(boolean value) {
            this.insertBoolean(this.size(), value);
            return true;
        }

        @Override
        default public boolean addAll(Collection<? extends Boolean> c) {
            this.addAll(this.size(), c);
            return true;
        }

        @Override
        default public boolean addAllBooleans(boolean[] elements, int offset, int length) {
            this.insertAllBooleans(this.size(), elements, offset, length);
            return true;
        }

        default public void removeByIndex(int index) {
            this.removeRange(index, index + 1);
        }

        default public boolean removeBooleanByIndex(int index) throws IndexOutOfBoundsException {
            boolean v = this.getBoolean(index);
            this.removeByIndex(index);
            return v;
        }

        @Override
        default public boolean removeBoolean(boolean value) {
            int i = this.indexOfBoolean(value);
            if (i != -1) {
                this.removeByIndex(i);
                return true;
            }
            return false;
        }

        @Override
        default public boolean retainAll(Collection<?> c) {
            if (c instanceof BooleanCollection) {
                BooleanCollection cc = (BooleanCollection)c;
                boolean changedAtAll = false;
                int i = this.size() - 1;
                while (i >= 0) {
                    if (!cc.containsBoolean(this.getBoolean(i))) {
                        this.removeBooleanByIndex(i);
                        changedAtAll = true;
                    }
                    --i;
                }
                return changedAtAll;
            }
            boolean changedAtAll = false;
            int i = this.size() - 1;
            while (i >= 0) {
                if (!c.contains(this.getBoolean(i))) {
                    this.removeBooleanByIndex(i);
                    changedAtAll = true;
                }
                --i;
            }
            return changedAtAll;
        }

        @Override
        default public SimpleBooleanIterator newSimpleBooleanIterator() {
            return new SimpleBooleanIterator(){
                int index = 0;

                @Override
                public boolean nextrpBoolean() throws StopIterationReturnPath {
                    int i = this.index;
                    if (i >= this.size()) {
                        throw StopIterationReturnPath.I;
                    }
                    this.index = i + 1;
                    return this.getBoolean(i);
                }
            };
        }

        @Override
        default public boolean containsBoolean(boolean value) {
            return this.indexOfBoolean(value) != -1;
        }

        default public void insertAllBooleans(int index, boolean[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                this.insertBoolean(index + i, array[offset + i]);
                ++i;
            }
        }

        @Override
        default public boolean addAll(int index, Collection<? extends Boolean> c) {
            if (c instanceof BooleanCollection) {
                BooleanCollection booleanCollection = (BooleanCollection)c;
                SimpleBooleanIterator i = booleanCollection.newSimpleBooleanIterator();
                try {
                    while (true) {
                        this.insertBoolean(index, i.nextrpBoolean());
                        ++index;
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {}
            } else {
                for (Boolean bl : c) {
                    this.insertBoolean(index, bl);
                    ++index;
                }
            }
            return true;
        }

        default public void insertAllBooleans(int index, boolean[] array) {
            this.insertAllBooleans(index, array, 0, array.length);
        }

        default public void insertAllBooleans(int index, Slice<boolean[]> arraySlice) {
            this.insertAllBooleans(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @Override
        default public Boolean get(int index) {
            return this.getBoolean(index);
        }

        @Override
        default public Boolean set(int index, Boolean value) {
            Boolean previous = this.get(index);
            this.setBoolean(index, value);
            return previous;
        }

        @Override
        default public void add(int index, Boolean value) {
            this.insertBoolean(index, value);
        }

        @Override
        default public Boolean remove(int index) throws IndexOutOfBoundsException {
            return this.removeBooleanByIndex(index);
        }

        @Override
        default public int indexOf(Object o) {
            return o instanceof Boolean ? this.indexOfBoolean((Boolean)o) : -1;
        }

        @Override
        default public int lastIndexOf(Object o) {
            return o instanceof Boolean ? this.lastIndexOfBoolean((Boolean)o) : -1;
        }

        default public int indexOf(Object o, int start) {
            return o instanceof Boolean ? this.indexOfBoolean((Boolean)o, start) : -1;
        }

        default public int lastIndexOf(Object o, int start) {
            return o instanceof Boolean ? this.lastIndexOfBoolean((Boolean)o, start) : -1;
        }

        @Override
        default public ListIterator<Boolean> listIterator() {
            return this.listIterator(0);
        }

        @Override
        default public ListIterator<Boolean> listIterator(int index) {
            return new DelegatingListIterator<Boolean>(this, index);
        }

        default public BooleanList subList(int fromIndex, int toIndex) {
            if (fromIndex == 0 && toIndex == this.size()) {
                return this;
            }
            if (this instanceof Sublist) {
                Sublist s = (Sublist)((Object)this);
                return new BooleanSublist((BooleanList)s.getUnderlying(), s.getSublistStartingIndex() + fromIndex, toIndex - fromIndex);
            }
            return new BooleanSublist(this, fromIndex, toIndex - fromIndex);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForBooleanList.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForBooleanList.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForBooleanList.super.containsAll(c);
        }

        @Override
        default public boolean add(Boolean e) {
            return NonuniformMethodsForBooleanList.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForBooleanList.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForBooleanList.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveList.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForBooleanList.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForBooleanList.super.toArray(a);
        }

        @Override
        default public void storeBoxingIntoArray(Slice<Object[]> array) {
            int n = this.size();
            int i = 0;
            while (i < n) {
                ArrayUtilities.setReference(array, i, this.get(i));
                ++i;
            }
        }

        default public boolean endsWith(List<Boolean> suffixCandidate) {
            return this.size() >= suffixCandidate.size() && this.subListToEnd(suffixCandidate.size()).equivalent(suffixCandidate);
        }

        default public boolean startsWith(List<Boolean> prefixCandidate) {
            return this.size() >= prefixCandidate.size() && this.subListFromBeginning(prefixCandidate.size()).equivalent(prefixCandidate);
        }

        default public BooleanList subListToEnd(int start) {
            return (BooleanList)PrimitiveList.super.subListToEnd(start);
        }

        default public BooleanList subListFromBeginning(int lengthWhichIsEndExclusiveInThisCaseXD) {
            return (BooleanList)PrimitiveList.super.subListFromBeginning(lengthWhichIsEndExclusiveInThisCaseXD);
        }

        default public BooleanList subListByLength(int start, int length) {
            return (BooleanList)PrimitiveList.super.subListByLength(start, length);
        }

        @Override
        default public void fillBySetting(int start, int count, Boolean value) {
            this.fillBySettingBoolean(start, count, value);
        }

        default public void fillBySettingBoolean(boolean value) {
            this.fillBySettingBoolean(0, this.size(), value);
        }

        default public void fillBySettingBoolean(int start, int count, boolean value) {
            CollectionUtilities.rangeCheckIntervalByLength(this.size(), start, count);
            if (count >= 100) {
                boolean[] array = new boolean[SmallIntegerMathUtilities.least(count, 1024)];
                if (value) {
                    Arrays.fill(array, value);
                }
                int al = array.length;
                BooleanList l = PrimitiveCollections.booleanArrayAsList(array);
                while (count > al) {
                    this.setAll(start, l);
                    start += al;
                    count -= al;
                }
                if (count > 0) {
                    this.setAll(start, l.subList(0, count));
                }
            } else {
                int e = start + count;
                int i = start;
                while (i < e) {
                    this.setBoolean(i, value);
                    ++i;
                }
            }
        }
    }

    @SignalType
    public static interface BooleanListRO
    extends Equivalenceable {
        public boolean getBoolean(int var1);

        public int size();

        default public int indexOfBoolean(boolean value) {
            return this.indexOfBoolean(value, 0);
        }

        default public int lastIndexOfBoolean(boolean value) {
            return this.lastIndexOfBoolean(value, this.size() - 1);
        }

        default public int indexOfBoolean(boolean value, int start) {
            int n = this.size();
            int i = start;
            while (i < n) {
                if (Primitives.eqSane(this.getBoolean(i), value)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        default public int lastIndexOfBoolean(boolean value, int start) {
            int i = start;
            if (i >= 0 && Primitives.eqSane(this.getBoolean(i), value)) {
                return i;
            }
            return i;
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof BooleanListRO) {
                return this.equivalentFixedRO((BooleanListRO)o);
            }
            if (o instanceof List) {
                List other = (List)o;
                int size = this.size();
                if (other.size() != size) {
                    return false;
                }
                int i = 0;
                while (i < size) {
                    Object e = other.get(i);
                    if (e instanceof Boolean) {
                        if (!Primitives.eqSane(this.getBoolean(i), (Boolean)e)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalentFixedRO(BooleanListRO other) {
            int size = this.size();
            if (other.size() != size) {
                return false;
            }
            int i = 0;
            while (i < size) {
                if (!Primitives.eqSane(this.getBoolean(i), other.getBoolean(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            int size = this.size();
            int i = 0;
            while (i < size) {
                boolean e = this.getBoolean(i);
                r = 31 * r + Primitives.hashprim(e);
                ++i;
            }
            return r;
        }
    }

    @SignalType
    public static interface BooleanListRWFixed
    extends BooleanListRO {
        public void setBoolean(int var1, boolean var2);
    }

    @SignalType
    public static interface BooleanListWithByteListConversion
    extends BooleanList {
        @PossiblySnapshotPossiblyLiveValue
        @ReadonlyValue
        public ByteList byteList();

        @ThrowAwayValue
        public ByteList toNewByteList();
    }

    public static class BooleanListWrapper
    implements BooleanList {
        protected final List<Boolean> underlying;

        public BooleanListWrapper(List<Boolean> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithRemoveRange) {
                ((ListWithRemoveRange)((Object)this.underlying)).removeRange(start, pastEnd);
            } else {
                BooleanList.super.removeRange(start, pastEnd);
            }
        }

        @Override
        public void setSize(int newSize, Boolean elementToAddIfGrowing) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize, elementToAddIfGrowing);
            } else {
                BooleanList.super.setSize(newSize, elementToAddIfGrowing);
            }
        }

        @Override
        public void setSize(int newSize) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize);
            } else {
                BooleanList.super.setSize(newSize);
            }
        }

        @Override
        public void setAll(int destIndex, List source, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithSetAll) {
                ((ListWithSetAll)((Object)this.underlying)).setAll(destIndex, source, sourceIndex, amount);
            } else {
                BooleanList.super.setAll(destIndex, source, sourceIndex, amount);
            }
        }

        @Override
        public void fillBySetting(int start, int count, Boolean value) {
            if (this.underlying instanceof ListWithFill) {
                ((ListWithFill)this.underlying).fillBySetting(start, count, value);
            } else {
                BooleanList.super.fillBySetting(start, count, value);
            }
        }

        @Override
        public BooleanList clone() {
            return PrimitiveCollections.asBooleanList(ObjectUtilities.attemptClone(this.underlying));
        }

        @Override
        public boolean getBoolean(int index) {
            return this.get(index);
        }

        @Override
        public void setBoolean(int index, boolean value) {
            this.set(index, value);
        }

        @Override
        public void insertBoolean(int index, boolean value) {
            this.add(index, value);
        }

        @Override
        public void setSizeBoolean(int newSize, boolean elementToAddIfGrowing) {
            this.setSize(newSize, elementToAddIfGrowing);
        }

        @Override
        public void forEach(Consumer<? super Boolean> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Boolean e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Boolean> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Boolean> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Boolean> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Boolean> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Boolean> c) {
            this.underlying.sort(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public Boolean get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Boolean set(int index, Boolean element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Boolean element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Boolean> stream() {
            return this.underlying.stream();
        }

        @Override
        public Boolean remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Boolean> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public Spliterator<Boolean> spliterator() {
            return this.underlying.spliterator();
        }
    }

    @SignalType
    public static interface BooleanSet
    extends PrimitiveSet<Boolean, boolean[]>,
    NonuniformMethodsForBooleanSet {
        @Override
        default public Iterator<Boolean> iterator() {
            return NonuniformMethodsForBooleanSet.super.iterator();
        }

        @Override
        default public boolean addAll(Collection<? extends Boolean> c) {
            return NonuniformMethodsForBooleanSet.super.addAll(c);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForBooleanSet.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForBooleanSet.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForBooleanSet.super.containsAll(c);
        }

        @Override
        default public boolean add(Boolean e) {
            return NonuniformMethodsForBooleanSet.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForBooleanSet.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForBooleanSet.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveSet.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForBooleanSet.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForBooleanSet.super.toArray(a);
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof BooleanSet) {
                return this.equivalent((BooleanSet)o);
            }
            if (o instanceof Set) {
                int bs;
                Set a = (Set)o;
                BooleanSet b = this;
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                int as = a.size();
                if (as != (bs = b.size())) {
                    return false;
                }
                if (CodeHinting.arbitrary(as, bs) == 0) {
                    return true;
                }
                for (Object an : a) {
                    if (an instanceof Boolean) {
                        if (b.containsBoolean((Boolean)an)) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalent(BooleanSet other) {
            int bs;
            BooleanSet a = this;
            BooleanSet b = other;
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            int as = a.size();
            if (as != (bs = b.size())) {
                return false;
            }
            if (CodeHinting.arbitrary(as, bs) == 0) {
                return true;
            }
            SimpleBooleanIterator i = a.newSimpleBooleanIterator();
            try {
                while (b.containsBoolean(i.nextrpBoolean())) {
                }
                return false;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return true;
            }
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            SimpleBooleanIterator i = this.newSimpleBooleanIterator();
            try {
                while (true) {
                    r += Primitives.hashprim(i.nextrpBoolean());
                }
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return r;
            }
        }
    }

    public static class BooleanSublist
    implements BooleanList,
    DefaultShiftingBasedBooleanList,
    Sublist<Boolean>,
    ShiftableList {
        protected final BooleanList underlying;
        protected final int start;
        protected int size;

        public BooleanSublist(BooleanList underlying, int start, int initialSize) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.size(), start, initialSize);
            this.underlying = underlying;
            this.start = start;
            this.size = initialSize;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean getBoolean(int index) {
            return this.underlying.getBoolean(index + this.start);
        }

        @Override
        public void setBoolean(int index, boolean value) {
            this.underlying.setBoolean(index + this.start, value);
        }

        @Override
        public void shiftRegionStretchingFromIndexToEndByAmountChangingSize(int start, int amount) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), start);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this.underlying, start, amount);
            this.size += amount;
        }

        @Override
        public BooleanList clone() {
            BooleanArrayList c = new BooleanArrayList();
            c.addAll(this);
            return c;
        }

        @Override
        public BooleanList getUnderlying() {
            return this.underlying;
        }

        @Override
        public int getSublistStartingIndex() {
            return this.start;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public Boolean isWritableCollection() {
            return this.underlying.isWritableCollection();
        }
    }

    public static class BooleanTable {
        protected int width;
        protected boolean[] data;

        public BooleanTable(int width, int height) {
            if (width < 0) {
                throw new IllegalArgumentException();
            }
            if (height < 0) {
                throw new IllegalArgumentException();
            }
            this.data = new boolean[width * height];
        }

        @Nonnegative
        public int getNumberOfColumns() {
            return this.width;
        }

        @Nonnegative
        public int getNumberOfRows() {
            return this.data.length / this.width;
        }

        @Nonnegative
        public int getNumberOfCells() {
            return this.data.length;
        }

        public boolean getCellContentsBoolean(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            return this.data[rowIndex * this.getNumberOfColumns() + columnIndex];
        }

        public void setCellContentsBoolean(int columnIndex, int rowIndex, @Nullable boolean newValue) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            this.data[rowIndex * this.getNumberOfColumns() + columnIndex] = newValue;
        }

        @Nullable
        public Boolean getCellContents(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            return this.getCellContentsBoolean(columnIndex, rowIndex);
        }

        public void setCellContents(int columnIndex, int rowIndex, @Nullable Boolean newValue) throws IndexOutOfBoundsException {
            this.setCellContentsBoolean(columnIndex, rowIndex, newValue);
        }
    }

    public static class ByteArrayList
    implements DefaultShiftingBasedByteList,
    ListWithSetSize<Byte>,
    Trimmable,
    TransparentContiguousArrayBackedCollection<byte[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected int size = 0;
        protected byte[] data;
        protected Grower.GrowerComputationallyUnreducedPurelyRecursive grower;

        protected ByteArrayList(Void thisiswhyyoushouldntusejavaconstructorsAlthoughIdontknowhowtomakeinheritanceworkwellwithoutinitmethodsorfactoriesorsomething) {
        }

        public ByteArrayList(int initialCapacity, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = initialCapacity == 0 ? ArrayUtilities.EmptyByteArray : new byte[initialCapacity];
            this.grower = grower;
        }

        public ByteArrayList(@LiveValue @WritableValue byte[] LIVEBACKING, int size, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = LIVEBACKING;
            this.grower = grower;
            this.size = size;
        }

        public ByteArrayList(@SnapshotValue @ReadonlyValue Collection<Byte> c, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this(c.size(), grower);
            this.addAll((Collection<? extends Byte>)c);
        }

        public ByteArrayList() {
            this(16);
        }

        public ByteArrayList(int initialCapacity) {
            this(initialCapacity, PrimitiveCollections.defaultPrimitiveArrayListGrower(initialCapacity));
        }

        public ByteArrayList(@SnapshotValue @ReadonlyValue Collection<Byte> c) {
            this(c, PrimitiveCollections.defaultPrimitiveArrayListGrower(c.size()));
        }

        public ByteArrayList(@LiveValue @WritableValue byte[] LIVEBACKING, int size) {
            this(LIVEBACKING, size, PrimitiveCollections.defaultPrimitiveArrayListGrower(LIVEBACKING.length));
        }

        public ByteArrayList(@LiveValue @WritableValue byte[] LIVEBACKING) {
            this(LIVEBACKING, LIVEBACKING.length);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return false;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public void setSize(int newSize) {
            this.ensureCapacity(newSize);
            this.size = newSize;
        }

        protected void setupClone(ByteArrayList freshClone) {
            freshClone.size = this.size;
            freshClone.data = new byte[this.size];
            System.arraycopy(this.data, 0, freshClone.data, 0, this.size);
            freshClone.grower = this.grower;
        }

        @Override
        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        public ByteArrayList clone() {
            ByteArrayList clone = new ByteArrayList();
            this.setupClone(clone);
            return clone;
        }

        @Override
        @ImplementationTransparency
        @LiveValue
        public Slice<byte[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<byte[]>(this.data, 0, this.size);
        }

        public void sort() {
            PrimitiveCollections.sortArray(this.data, 0, this.size);
        }

        @Override
        public void setByte(int index, byte value) {
            CollectionUtilities.rangeCheckMember(this.size, index);
            this.data[index] = value;
        }

        @Override
        public byte getByte(int index) {
            CollectionUtilities.rangeCheckMember(this.size(), index);
            return this.data[index];
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public void clear() {
            this.size = 0;
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public int size() {
            return this.size;
        }

        @ImplementationTransparency
        public void trimToSize() {
            byte[] newdata = new byte[this.size];
            System.arraycopy(this.data, 0, newdata, 0, this.size);
            this.data = newdata;
        }

        @Override
        public Trimmable.TrimmableTrimRV couldYouMaybeUseALittleLessMemoryIfYouDontMind() {
            this.trimToSize();
            return Trimmable.TrimmableTrimRV.DontKeepInvoking;
        }

        @ImplementationTransparency
        public int getCapacity() {
            return this.data.length;
        }

        @ImplementationTransparency
        public void ensureCapacity(int minCapacity) {
            if (this.data.length < minCapacity) {
                int newCapacity = this.getNewCapacity(minCapacity);
                byte[] newData = new byte[newCapacity];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
        }

        @Override
        public void clearHinting(int newCapacity) {
            this.clear();
            this.ensureCapacity(newCapacity);
        }

        @ImplementationTransparency
        public int getNewCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new IllegalArgumentException();
            }
            return Math.max(minCapacity, this.grower.getNewSizeRecursive(this.data.length));
        }

        @ImplementationTransparency
        public void setDirectBuffer(@LiveValue byte[] array) {
            if (array.length < this.size) {
                throw new IllegalArgumentException("Array is too small; size=" + this.size + ", capacity=" + array.length);
            }
            this.data = array;
        }

        public String toString() {
            return this._toString();
        }
    }

    @SignalType
    public static interface ByteCollection
    extends PrimitiveCollection<Byte, byte[]>,
    SimpleByteIterable {
        public boolean addByte(byte var1);

        public boolean removeByte(byte var1);

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class getPrimitiveType() {
            return Byte.TYPE;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<Byte> getBoxedType() {
            return Byte.class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<byte[]> getArrayType() {
            return byte[].class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Byte getDefaultElement() {
            return (byte)0;
        }

        @ThrowAwayValue
        public static byte[] defaultToByteArray(ByteCollection collection) {
            byte[] array = new byte[collection.size()];
            SimpleByteIterator i = collection.newSimpleByteIterator();
            int index = 0;
            while (true) {
                try {
                    array[index] = i.nextrpByte();
                }
                catch (StopIterationReturnPath exc) {
                    break;
                }
                ++index;
            }
            return array;
        }

        @ThrowAwayValue
        default public byte[] toByteArray() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<byte[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof byte[]) {
                    return ArrayUtilities.sliceToNewByteArrayOP(u);
                }
            }
            return ByteCollection.defaultToByteArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public byte[] toByteArrayPossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                int size = this.size();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                Object und = u.getUnderlying();
                if (und instanceof byte[] && u.getOffset() == 0 && ((byte[])und).length == size) {
                    return (byte[])und;
                }
            }
            return ByteCollection.defaultToByteArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public Slice<byte[]> toByteArraySlicePossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<byte[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof byte[]) {
                    return u;
                }
            }
            return ArrayUtilities.wholeArraySliceByte(ByteCollection.defaultToByteArray(this));
        }

        @LiveValue
        @Nullable
        default public Slice<byte[]> toByteArraySliceLiveOrNull() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<byte[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof byte[]) {
                    return u;
                }
            }
            return null;
        }

        default public boolean containsByte(byte value) {
            SimpleByteIterator i = this.newSimpleByteIterator();
            try {
                while (!Primitives.eqSane(i.nextrpByte(), value)) {
                }
                return true;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return false;
            }
        }

        @Override
        default public Iterator<Byte> iterator() {
            return SimpleByteIterable.super.iterator();
        }

        @Override
        default public boolean isEmpty() {
            return this.size() == 0;
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllBytes(byte[] array) {
            return this.addAllBytes(array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllBytes(Slice<byte[]> arraySlice) {
            return this.addAllBytes(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllBytes(byte[] elements, int offset, int length) {
            return ByteCollection.defaultAddAllBytes(this, elements, offset, length);
        }

        public static boolean defaultAddAllBytes(ByteCollection self, byte[] elements, int offset, int length) {
            boolean changedAtAll = false;
            int e = offset + length;
            int i = offset;
            while (i < e) {
                changedAtAll |= self.addByte(elements[i]);
                ++i;
            }
            return changedAtAll;
        }

        default public void removeAllBytes(byte[] array) {
            this.removeAllBytes(array, 0, array.length);
        }

        default public void removeAllBytes(Slice<byte[]> arraySlice) {
            this.removeAllBytes(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public void removeAllBytes(byte[] a, int offset, int length) {
            int e = offset + length;
            int i = offset;
            while (i < e) {
                this.removeByte(a[i]);
                ++i;
            }
        }

        @Override
        default public boolean contains(Object o) {
            return o instanceof Byte && this.containsByte((Byte)o);
        }

        @Override
        default public boolean add(Byte e) {
            return this.addByte(e);
        }

        @Override
        default public boolean remove(Object o) {
            return o instanceof Byte && this.removeByte((Byte)o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            if (c instanceof ByteCollection) {
                ByteCollection cc = (ByteCollection)c;
                SimpleByteIterator i = cc.newSimpleByteIterator();
                try {
                    while (!this.containsByte(i.nextrpByte())) {
                    }
                    return true;
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return false;
                }
            }
            for (Object e : c) {
                if (!this.contains(e)) continue;
                return true;
            }
            return false;
        }

        @Override
        default public boolean addAll(Collection<? extends Byte> c) {
            if (c instanceof ByteCollection) {
                boolean changedAtAll = false;
                SimpleByteIterator simpleByteIterator = ((ByteCollection)c).newSimpleByteIterator();
                try {
                    while (true) {
                        changedAtAll |= this.add(simpleByteIterator.nextrpByte());
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Byte by : c) {
                changedAtAll |= this.add(by);
            }
            return changedAtAll;
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            if (c instanceof ByteCollection) {
                boolean changedAtAll = false;
                SimpleByteIterator i = ((ByteCollection)c).newSimpleByteIterator();
                try {
                    while (true) {
                        changedAtAll |= this.remove(i.nextrpByte());
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Object e : c) {
                changedAtAll |= this.remove(e);
            }
            return changedAtAll;
        }

        @Override
        default public void setFrom(Object source) {
            block8: {
                if (source == this) {
                    return;
                }
                if (source instanceof ByteCollection) {
                    ByteCollection s = (ByteCollection)source;
                    this.clearHinting(s.size());
                    SimpleByteIterator i = s.newSimpleByteIterator();
                    while (true) {
                        byte e;
                        try {
                            e = i.nextrpByte();
                        }
                        catch (StopIterationReturnPath exc) {
                            break block8;
                        }
                        this.addByte(e);
                    }
                }
                if (source instanceof Collection) {
                    Collection s = (Collection)source;
                    this.clearHinting(s.size());
                    for (Byte e : s) {
                        this.addByte(e);
                    }
                } else {
                    throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(source);
                }
            }
        }

        default public void clearHinting(int newCapacity) {
            this.clear();
        }

        @Override
        default public String _toString() {
            return PrimitiveCollections.defaultToString(this);
        }
    }

    @SignalType
    public static interface ByteIntervalCollection
    extends ByteCollection {
        @Override
        public int size();

        public byte getLowerBoundInclusive();
    }

    @SignalType
    public static interface ByteList
    extends PrimitiveList<Byte, byte[]>,
    NonuniformMethodsForByteList,
    ByteListRO,
    ByteListRWFixed {
        @Override
        default public Iterator<Byte> iterator() {
            return NonuniformMethodsForByteList.super.iterator();
        }

        public void insertByte(int var1, byte var2);

        public ByteList clone();

        public void setSizeByte(int var1, byte var2);

        @Override
        default public void setSize(int newSize, Byte elementToAddIfGrowing) {
            this.setSizeByte(newSize, elementToAddIfGrowing);
        }

        @Override
        default public void setSize(int newSize) {
            this.setSizeByte(newSize, (byte)0);
        }

        @Override
        default public void clear() {
            this.setSize(0);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllBytes(int index, byte[] array) {
            this.setAllBytes(index, array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllBytes(int index, Slice<byte[]> arraySlice) {
            this.setAllBytes(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        default public void setAllBytes(int start, byte[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof byte[]) {
                    Slice s = u;
                    System.arraycopy(array, offset, s.getUnderlying(), s.getOffset() + start, length);
                    return;
                }
            }
            ByteList.defaultSetAllBytes(this, start, array, offset, length);
        }

        public static void defaultSetAllBytes(ByteList list, int start, @WritableValue byte[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                list.setByte(start + i, array[offset + i]);
                ++i;
            }
        }

        default public void setAll(int destIndex, List sourceU, int sourceIndex, @Nonnegative int amount) throws IndexOutOfBoundsException {
            List source = sourceU;
            ByteList dest = this;
            int sourceSize = source.size();
            int destSize = dest.size();
            CollectionUtilities.rangeCheckIntervalByLength(sourceSize, sourceIndex, amount);
            CollectionUtilities.rangeCheckIntervalByLength(destSize, destIndex, amount);
            if (TransparentContiguousArrayBackedCollection.is(source)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)source)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(sourceSize, u);
                if (u.getUnderlying() instanceof byte[]) {
                    Slice s = u;
                    this.setAllBytes(destIndex, (Slice)s.subslice(sourceIndex, amount));
                    return;
                }
            }
            if (source instanceof ByteList) {
                ByteList primSource = (ByteList)source;
                if (destIndex < sourceIndex) {
                    int i = 0;
                    while (i < amount) {
                        dest.setByte(destIndex + i, primSource.getByte(sourceIndex + i));
                        ++i;
                    }
                } else {
                    int i = amount - 1;
                    while (i >= 0) {
                        dest.setByte(destIndex + i, primSource.getByte(sourceIndex + i));
                        --i;
                    }
                }
            } else if (destIndex < sourceIndex) {
                int i = 0;
                while (i < amount) {
                    dest.set(destIndex + i, (Byte)source.get(sourceIndex + i));
                    ++i;
                }
            } else {
                int i = amount - 1;
                while (i >= 0) {
                    dest.set(destIndex + i, (Byte)source.get(sourceIndex + i));
                    --i;
                }
            }
        }

        default public void getAllBytes(int start, @WritableValue byte[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof byte[]) {
                    Slice s = u;
                    System.arraycopy(s.getUnderlying(), s.getOffset() + start, array, offset, length);
                    return;
                }
            }
            ByteList.defaultGetAllBytes(this, start, array, offset, length);
        }

        public static void defaultGetAllBytes(ByteList list, int start, @WritableValue byte[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                array[offset + i] = list.getByte(start + i);
                ++i;
            }
        }

        @ThrowAwayValue
        default public byte[] getAllBytes(int start, int end) {
            CollectionUtilities.rangeCheckInterval(this.size(), start, end);
            byte[] buff = new byte[end - start];
            this.getAllBytes(start, buff, 0, buff.length);
            return buff;
        }

        @Override
        default public boolean addByte(byte value) {
            this.insertByte(this.size(), value);
            return true;
        }

        @Override
        default public boolean addAll(Collection<? extends Byte> c) {
            this.addAll(this.size(), c);
            return true;
        }

        @Override
        default public boolean addAllBytes(byte[] elements, int offset, int length) {
            this.insertAllBytes(this.size(), elements, offset, length);
            return true;
        }

        default public void removeByIndex(int index) {
            this.removeRange(index, index + 1);
        }

        default public byte removeByteByIndex(int index) throws IndexOutOfBoundsException {
            byte v = this.getByte(index);
            this.removeByIndex(index);
            return v;
        }

        @Override
        default public boolean removeByte(byte value) {
            int i = this.indexOfByte(value);
            if (i != -1) {
                this.removeByIndex(i);
                return true;
            }
            return false;
        }

        @Override
        default public boolean retainAll(Collection<?> c) {
            if (c instanceof ByteCollection) {
                ByteCollection cc = (ByteCollection)c;
                boolean changedAtAll = false;
                int i = this.size() - 1;
                while (i >= 0) {
                    if (!cc.containsByte(this.getByte(i))) {
                        this.removeByteByIndex(i);
                        changedAtAll = true;
                    }
                    --i;
                }
                return changedAtAll;
            }
            boolean changedAtAll = false;
            int i = this.size() - 1;
            while (i >= 0) {
                if (!c.contains(this.getByte(i))) {
                    this.removeByteByIndex(i);
                    changedAtAll = true;
                }
                --i;
            }
            return changedAtAll;
        }

        @Override
        default public SimpleByteIterator newSimpleByteIterator() {
            return new SimpleByteIterator(){
                int index = 0;

                @Override
                public byte nextrpByte() throws StopIterationReturnPath {
                    int i = this.index;
                    if (i >= this.size()) {
                        throw StopIterationReturnPath.I;
                    }
                    this.index = i + 1;
                    return this.getByte(i);
                }
            };
        }

        @Override
        default public boolean containsByte(byte value) {
            return this.indexOfByte(value) != -1;
        }

        default public void insertAllBytes(int index, byte[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                this.insertByte(index + i, array[offset + i]);
                ++i;
            }
        }

        @Override
        default public boolean addAll(int index, Collection<? extends Byte> c) {
            if (c instanceof ByteCollection) {
                ByteCollection byteCollection = (ByteCollection)c;
                SimpleByteIterator i = byteCollection.newSimpleByteIterator();
                try {
                    while (true) {
                        this.insertByte(index, i.nextrpByte());
                        ++index;
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {}
            } else {
                for (Byte by : c) {
                    this.insertByte(index, by);
                    ++index;
                }
            }
            return true;
        }

        default public void insertAllBytes(int index, byte[] array) {
            this.insertAllBytes(index, array, 0, array.length);
        }

        default public void insertAllBytes(int index, Slice<byte[]> arraySlice) {
            this.insertAllBytes(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @Override
        default public Byte get(int index) {
            return this.getByte(index);
        }

        @Override
        default public Byte set(int index, Byte value) {
            Byte previous = this.get(index);
            this.setByte(index, value);
            return previous;
        }

        @Override
        default public void add(int index, Byte value) {
            this.insertByte(index, value);
        }

        @Override
        default public Byte remove(int index) throws IndexOutOfBoundsException {
            return this.removeByteByIndex(index);
        }

        @Override
        default public int indexOf(Object o) {
            return o instanceof Byte ? this.indexOfByte((Byte)o) : -1;
        }

        @Override
        default public int lastIndexOf(Object o) {
            return o instanceof Byte ? this.lastIndexOfByte((Byte)o) : -1;
        }

        default public int indexOf(Object o, int start) {
            return o instanceof Byte ? this.indexOfByte((Byte)o, start) : -1;
        }

        default public int lastIndexOf(Object o, int start) {
            return o instanceof Byte ? this.lastIndexOfByte((Byte)o, start) : -1;
        }

        @Override
        default public ListIterator<Byte> listIterator() {
            return this.listIterator(0);
        }

        @Override
        default public ListIterator<Byte> listIterator(int index) {
            return new DelegatingListIterator<Byte>(this, index);
        }

        default public ByteList subList(int fromIndex, int toIndex) {
            if (fromIndex == 0 && toIndex == this.size()) {
                return this;
            }
            if (this instanceof Sublist) {
                Sublist s = (Sublist)((Object)this);
                return new ByteSublist((ByteList)s.getUnderlying(), s.getSublistStartingIndex() + fromIndex, toIndex - fromIndex);
            }
            return new ByteSublist(this, fromIndex, toIndex - fromIndex);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForByteList.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForByteList.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForByteList.super.containsAll(c);
        }

        @Override
        default public boolean add(Byte e) {
            return NonuniformMethodsForByteList.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForByteList.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForByteList.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveList.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForByteList.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForByteList.super.toArray(a);
        }

        @Override
        default public void storeBoxingIntoArray(Slice<Object[]> array) {
            int n = this.size();
            int i = 0;
            while (i < n) {
                ArrayUtilities.setReference(array, i, this.get(i));
                ++i;
            }
        }

        default public boolean endsWith(List<Byte> suffixCandidate) {
            return this.size() >= suffixCandidate.size() && this.subListToEnd(suffixCandidate.size()).equivalent(suffixCandidate);
        }

        default public boolean startsWith(List<Byte> prefixCandidate) {
            return this.size() >= prefixCandidate.size() && this.subListFromBeginning(prefixCandidate.size()).equivalent(prefixCandidate);
        }

        default public ByteList subListToEnd(int start) {
            return (ByteList)PrimitiveList.super.subListToEnd(start);
        }

        default public ByteList subListFromBeginning(int lengthWhichIsEndExclusiveInThisCaseXD) {
            return (ByteList)PrimitiveList.super.subListFromBeginning(lengthWhichIsEndExclusiveInThisCaseXD);
        }

        default public ByteList subListByLength(int start, int length) {
            return (ByteList)PrimitiveList.super.subListByLength(start, length);
        }

        @Override
        default public void fillBySetting(int start, int count, Byte value) {
            this.fillBySettingByte(start, count, value);
        }

        default public void fillBySettingByte(byte value) {
            this.fillBySettingByte(0, this.size(), value);
        }

        default public void fillBySettingByte(int start, int count, byte value) {
            CollectionUtilities.rangeCheckIntervalByLength(this.size(), start, count);
            if (count >= 100) {
                byte[] array = new byte[SmallIntegerMathUtilities.least(count, 1024)];
                if (value != 0) {
                    Arrays.fill(array, value);
                }
                int al = array.length;
                ByteList l = PrimitiveCollections.byteArrayAsList(array);
                while (count > al) {
                    this.setAll(start, l);
                    start += al;
                    count -= al;
                }
                if (count > 0) {
                    this.setAll(start, l.subList(0, count));
                }
            } else {
                int e = start + count;
                int i = start;
                while (i < e) {
                    this.setByte(i, value);
                    ++i;
                }
            }
        }
    }

    @SignalType
    public static interface ByteListRO
    extends Equivalenceable {
        public byte getByte(int var1);

        public int size();

        default public int indexOfByte(byte value) {
            return this.indexOfByte(value, 0);
        }

        default public int lastIndexOfByte(byte value) {
            return this.lastIndexOfByte(value, this.size() - 1);
        }

        default public int indexOfByte(byte value, int start) {
            int n = this.size();
            int i = start;
            while (i < n) {
                if (Primitives.eqSane(this.getByte(i), value)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        default public int lastIndexOfByte(byte value, int start) {
            int i = start;
            if (i >= 0 && Primitives.eqSane(this.getByte(i), value)) {
                return i;
            }
            return i;
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof ByteListRO) {
                return this.equivalentFixedRO((ByteListRO)o);
            }
            if (o instanceof List) {
                List other = (List)o;
                int size = this.size();
                if (other.size() != size) {
                    return false;
                }
                int i = 0;
                while (i < size) {
                    Object e = other.get(i);
                    if (e instanceof Byte) {
                        if (!Primitives.eqSane(this.getByte(i), (Byte)e)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalentFixedRO(ByteListRO other) {
            int size = this.size();
            if (other.size() != size) {
                return false;
            }
            int i = 0;
            while (i < size) {
                if (!Primitives.eqSane(this.getByte(i), other.getByte(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            int size = this.size();
            int i = 0;
            while (i < size) {
                byte e = this.getByte(i);
                r = 31 * r + Primitives.hashprim(e);
                ++i;
            }
            return r;
        }
    }

    @SignalType
    public static interface ByteListRWFixed
    extends ByteListRO {
        public void setByte(int var1, byte var2);
    }

    public static class ByteListWrapper
    implements ByteList {
        protected final List<Byte> underlying;

        public ByteListWrapper(List<Byte> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithRemoveRange) {
                ((ListWithRemoveRange)((Object)this.underlying)).removeRange(start, pastEnd);
            } else {
                ByteList.super.removeRange(start, pastEnd);
            }
        }

        @Override
        public void setSize(int newSize, Byte elementToAddIfGrowing) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize, elementToAddIfGrowing);
            } else {
                ByteList.super.setSize(newSize, elementToAddIfGrowing);
            }
        }

        @Override
        public void setSize(int newSize) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize);
            } else {
                ByteList.super.setSize(newSize);
            }
        }

        @Override
        public void setAll(int destIndex, List source, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithSetAll) {
                ((ListWithSetAll)((Object)this.underlying)).setAll(destIndex, source, sourceIndex, amount);
            } else {
                ByteList.super.setAll(destIndex, source, sourceIndex, amount);
            }
        }

        @Override
        public void fillBySetting(int start, int count, Byte value) {
            if (this.underlying instanceof ListWithFill) {
                ((ListWithFill)this.underlying).fillBySetting(start, count, value);
            } else {
                ByteList.super.fillBySetting(start, count, value);
            }
        }

        @Override
        public ByteList clone() {
            return PrimitiveCollections.asByteList(ObjectUtilities.attemptClone(this.underlying));
        }

        @Override
        public byte getByte(int index) {
            return this.get(index);
        }

        @Override
        public void setByte(int index, byte value) {
            this.set(index, value);
        }

        @Override
        public void insertByte(int index, byte value) {
            this.add(index, value);
        }

        @Override
        public void setSizeByte(int newSize, byte elementToAddIfGrowing) {
            this.setSize(newSize, elementToAddIfGrowing);
        }

        @Override
        public void forEach(Consumer<? super Byte> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Byte e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Byte> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Byte> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Byte> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Byte> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Byte> c) {
            this.underlying.sort(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public Byte get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Byte set(int index, Byte element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Byte element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Byte> stream() {
            return this.underlying.stream();
        }

        @Override
        public Byte remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Byte> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public Spliterator<Byte> spliterator() {
            return this.underlying.spliterator();
        }
    }

    @SignalType
    public static interface ByteSet
    extends PrimitiveSet<Byte, byte[]>,
    NonuniformMethodsForByteSet {
        @Override
        default public Iterator<Byte> iterator() {
            return NonuniformMethodsForByteSet.super.iterator();
        }

        @Override
        default public boolean addAll(Collection<? extends Byte> c) {
            return NonuniformMethodsForByteSet.super.addAll(c);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForByteSet.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForByteSet.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForByteSet.super.containsAll(c);
        }

        @Override
        default public boolean add(Byte e) {
            return NonuniformMethodsForByteSet.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForByteSet.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForByteSet.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveSet.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForByteSet.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForByteSet.super.toArray(a);
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof ByteSet) {
                return this.equivalent((ByteSet)o);
            }
            if (o instanceof Set) {
                int bs;
                Set a = (Set)o;
                ByteSet b = this;
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                int as = a.size();
                if (as != (bs = b.size())) {
                    return false;
                }
                if (CodeHinting.arbitrary(as, bs) == 0) {
                    return true;
                }
                for (Object an : a) {
                    if (an instanceof Byte) {
                        if (b.containsByte((Byte)an)) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalent(ByteSet other) {
            int bs;
            ByteSet a = this;
            ByteSet b = other;
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            int as = a.size();
            if (as != (bs = b.size())) {
                return false;
            }
            if (CodeHinting.arbitrary(as, bs) == 0) {
                return true;
            }
            SimpleByteIterator i = a.newSimpleByteIterator();
            try {
                while (b.containsByte(i.nextrpByte())) {
                }
                return false;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return true;
            }
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            SimpleByteIterator i = this.newSimpleByteIterator();
            try {
                while (true) {
                    r += Primitives.hashprim(i.nextrpByte());
                }
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return r;
            }
        }
    }

    public static class ByteSublist
    implements ByteList,
    DefaultShiftingBasedByteList,
    Sublist<Byte>,
    ShiftableList {
        protected final ByteList underlying;
        protected final int start;
        protected int size;

        public ByteSublist(ByteList underlying, int start, int initialSize) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.size(), start, initialSize);
            this.underlying = underlying;
            this.start = start;
            this.size = initialSize;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public byte getByte(int index) {
            return this.underlying.getByte(index + this.start);
        }

        @Override
        public void setByte(int index, byte value) {
            this.underlying.setByte(index + this.start, value);
        }

        @Override
        public void shiftRegionStretchingFromIndexToEndByAmountChangingSize(int start, int amount) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), start);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this.underlying, start, amount);
            this.size += amount;
        }

        @Override
        public ByteList clone() {
            ByteArrayList c = new ByteArrayList();
            c.addAll(this);
            return c;
        }

        @Override
        public ByteList getUnderlying() {
            return this.underlying;
        }

        @Override
        public int getSublistStartingIndex() {
            return this.start;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public Boolean isWritableCollection() {
            return this.underlying.isWritableCollection();
        }
    }

    public static class ByteTable {
        protected int width;
        protected byte[] data;

        public ByteTable(int width, int height) {
            if (width < 0) {
                throw new IllegalArgumentException();
            }
            if (height < 0) {
                throw new IllegalArgumentException();
            }
            this.data = new byte[width * height];
        }

        @Nonnegative
        public int getNumberOfColumns() {
            return this.width;
        }

        @Nonnegative
        public int getNumberOfRows() {
            return this.data.length / this.width;
        }

        @Nonnegative
        public int getNumberOfCells() {
            return this.data.length;
        }

        public byte getCellContentsByte(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            return this.data[rowIndex * this.getNumberOfColumns() + columnIndex];
        }

        public void setCellContentsByte(int columnIndex, int rowIndex, @Nullable byte newValue) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            this.data[rowIndex * this.getNumberOfColumns() + columnIndex] = newValue;
        }

        @Nullable
        public Byte getCellContents(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            return this.getCellContentsByte(columnIndex, rowIndex);
        }

        public void setCellContents(int columnIndex, int rowIndex, @Nullable Byte newValue) throws IndexOutOfBoundsException {
            this.setCellContentsByte(columnIndex, rowIndex, newValue);
        }
    }

    public static class CharacterArrayList
    implements DefaultShiftingBasedCharacterList,
    ListWithSetSize<Character>,
    Trimmable,
    TransparentContiguousArrayBackedCollection<char[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected int size = 0;
        protected char[] data;
        protected Grower.GrowerComputationallyUnreducedPurelyRecursive grower;

        protected CharacterArrayList(Void thisiswhyyoushouldntusejavaconstructorsAlthoughIdontknowhowtomakeinheritanceworkwellwithoutinitmethodsorfactoriesorsomething) {
        }

        public CharacterArrayList(int initialCapacity, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = initialCapacity == 0 ? ArrayUtilities.EmptyCharArray : new char[initialCapacity];
            this.grower = grower;
        }

        public CharacterArrayList(@LiveValue @WritableValue char[] LIVEBACKING, int size, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = LIVEBACKING;
            this.grower = grower;
            this.size = size;
        }

        public CharacterArrayList(@SnapshotValue @ReadonlyValue Collection<Character> c, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this(c.size(), grower);
            this.addAll((Collection<? extends Character>)c);
        }

        public CharacterArrayList() {
            this(16);
        }

        public CharacterArrayList(int initialCapacity) {
            this(initialCapacity, PrimitiveCollections.defaultPrimitiveArrayListGrower(initialCapacity));
        }

        public CharacterArrayList(@SnapshotValue @ReadonlyValue Collection<Character> c) {
            this(c, PrimitiveCollections.defaultPrimitiveArrayListGrower(c.size()));
        }

        public CharacterArrayList(@LiveValue @WritableValue char[] LIVEBACKING, int size) {
            this(LIVEBACKING, size, PrimitiveCollections.defaultPrimitiveArrayListGrower(LIVEBACKING.length));
        }

        public CharacterArrayList(@LiveValue @WritableValue char[] LIVEBACKING) {
            this(LIVEBACKING, LIVEBACKING.length);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return false;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public void setSize(int newSize) {
            this.ensureCapacity(newSize);
            this.size = newSize;
        }

        protected void setupClone(CharacterArrayList freshClone) {
            freshClone.size = this.size;
            freshClone.data = new char[this.size];
            System.arraycopy(this.data, 0, freshClone.data, 0, this.size);
            freshClone.grower = this.grower;
        }

        @Override
        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        public CharacterArrayList clone() {
            CharacterArrayList clone = new CharacterArrayList();
            this.setupClone(clone);
            return clone;
        }

        @Override
        @ImplementationTransparency
        @LiveValue
        public Slice<char[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<char[]>(this.data, 0, this.size);
        }

        public void sort() {
            PrimitiveCollections.sortArray(this.data, 0, this.size);
        }

        @Override
        public void setChar(int index, char value) {
            CollectionUtilities.rangeCheckMember(this.size, index);
            this.data[index] = value;
        }

        @Override
        public char getChar(int index) {
            CollectionUtilities.rangeCheckMember(this.size(), index);
            return this.data[index];
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public void clear() {
            this.size = 0;
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public int size() {
            return this.size;
        }

        @ImplementationTransparency
        public void trimToSize() {
            char[] newdata = new char[this.size];
            System.arraycopy(this.data, 0, newdata, 0, this.size);
            this.data = newdata;
        }

        @Override
        public Trimmable.TrimmableTrimRV couldYouMaybeUseALittleLessMemoryIfYouDontMind() {
            this.trimToSize();
            return Trimmable.TrimmableTrimRV.DontKeepInvoking;
        }

        @ImplementationTransparency
        public int getCapacity() {
            return this.data.length;
        }

        @ImplementationTransparency
        public void ensureCapacity(int minCapacity) {
            if (this.data.length < minCapacity) {
                int newCapacity = this.getNewCapacity(minCapacity);
                char[] newData = new char[newCapacity];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
        }

        @Override
        public void clearHinting(int newCapacity) {
            this.clear();
            this.ensureCapacity(newCapacity);
        }

        @ImplementationTransparency
        public int getNewCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new IllegalArgumentException();
            }
            return Math.max(minCapacity, this.grower.getNewSizeRecursive(this.data.length));
        }

        @ImplementationTransparency
        public void setDirectBuffer(@LiveValue char[] array) {
            if (array.length < this.size) {
                throw new IllegalArgumentException("Array is too small; size=" + this.size + ", capacity=" + array.length);
            }
            this.data = array;
        }

        @Override
        public String toString() {
            return this._toString();
        }
    }

    @SignalType
    public static interface CharacterCollection
    extends PrimitiveCollection<Character, char[]>,
    SimpleCharacterIterable {
        public boolean addChar(char var1);

        public boolean removeChar(char var1);

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class getPrimitiveType() {
            return Character.TYPE;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<Character> getBoxedType() {
            return Character.class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<char[]> getArrayType() {
            return char[].class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Character getDefaultElement() {
            return Character.valueOf('\u0000');
        }

        @ThrowAwayValue
        public static char[] defaultToCharArray(CharacterCollection collection) {
            char[] array = new char[collection.size()];
            SimpleCharacterIterator i = collection.newSimpleCharacterIterator();
            int index = 0;
            while (true) {
                try {
                    array[index] = i.nextrpChar();
                }
                catch (StopIterationReturnPath exc) {
                    break;
                }
                ++index;
            }
            return array;
        }

        @ThrowAwayValue
        default public char[] toCharArray() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<char[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof char[]) {
                    return ArrayUtilities.sliceToNewCharArrayOP(u);
                }
            }
            return CharacterCollection.defaultToCharArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public char[] toCharArrayPossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                int size = this.size();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                Object und = u.getUnderlying();
                if (und instanceof char[] && u.getOffset() == 0 && ((char[])und).length == size) {
                    return (char[])und;
                }
            }
            return CharacterCollection.defaultToCharArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public Slice<char[]> toCharArraySlicePossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<char[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof char[]) {
                    return u;
                }
            }
            return ArrayUtilities.wholeArraySliceChar(CharacterCollection.defaultToCharArray(this));
        }

        @LiveValue
        @Nullable
        default public Slice<char[]> toCharArraySliceLiveOrNull() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<char[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof char[]) {
                    return u;
                }
            }
            return null;
        }

        default public boolean containsChar(char value) {
            SimpleCharacterIterator i = this.newSimpleCharacterIterator();
            try {
                while (!Primitives.eqSane(i.nextrpChar(), value)) {
                }
                return true;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return false;
            }
        }

        @Override
        default public Iterator<Character> iterator() {
            return SimpleCharacterIterable.super.iterator();
        }

        @Override
        default public boolean isEmpty() {
            return this.size() == 0;
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllChars(char[] array) {
            return this.addAllChars(array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllChars(Slice<char[]> arraySlice) {
            return this.addAllChars(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllChars(char[] elements, int offset, int length) {
            return CharacterCollection.defaultAddAllChars(this, elements, offset, length);
        }

        public static boolean defaultAddAllChars(CharacterCollection self, char[] elements, int offset, int length) {
            boolean changedAtAll = false;
            int e = offset + length;
            int i = offset;
            while (i < e) {
                changedAtAll |= self.addChar(elements[i]);
                ++i;
            }
            return changedAtAll;
        }

        default public void removeAllChars(char[] array) {
            this.removeAllChars(array, 0, array.length);
        }

        default public void removeAllChars(Slice<char[]> arraySlice) {
            this.removeAllChars(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public void removeAllChars(char[] a, int offset, int length) {
            int e = offset + length;
            int i = offset;
            while (i < e) {
                this.removeChar(a[i]);
                ++i;
            }
        }

        @Override
        default public boolean contains(Object o) {
            return o instanceof Character && this.containsChar(((Character)o).charValue());
        }

        @Override
        default public boolean add(Character e) {
            return this.addChar(e.charValue());
        }

        @Override
        default public boolean remove(Object o) {
            return o instanceof Character && this.removeChar(((Character)o).charValue());
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            if (c instanceof CharacterCollection) {
                CharacterCollection cc = (CharacterCollection)c;
                SimpleCharacterIterator i = cc.newSimpleCharacterIterator();
                try {
                    while (!this.containsChar(i.nextrpChar())) {
                    }
                    return true;
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return false;
                }
            }
            for (Object e : c) {
                if (!this.contains(e)) continue;
                return true;
            }
            return false;
        }

        @Override
        default public boolean addAll(Collection<? extends Character> c) {
            if (c instanceof CharacterCollection) {
                boolean changedAtAll = false;
                SimpleCharacterIterator simpleCharacterIterator = ((CharacterCollection)c).newSimpleCharacterIterator();
                try {
                    while (true) {
                        changedAtAll |= this.add(Character.valueOf(simpleCharacterIterator.nextrpChar()));
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Character c2 : c) {
                changedAtAll |= this.add(c2);
            }
            return changedAtAll;
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            if (c instanceof CharacterCollection) {
                boolean changedAtAll = false;
                SimpleCharacterIterator i = ((CharacterCollection)c).newSimpleCharacterIterator();
                try {
                    while (true) {
                        changedAtAll |= this.remove(Character.valueOf(i.nextrpChar()));
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Object e : c) {
                changedAtAll |= this.remove(e);
            }
            return changedAtAll;
        }

        @Override
        default public void setFrom(Object source) {
            block8: {
                if (source == this) {
                    return;
                }
                if (source instanceof CharacterCollection) {
                    CharacterCollection s = (CharacterCollection)source;
                    this.clearHinting(s.size());
                    SimpleCharacterIterator i = s.newSimpleCharacterIterator();
                    while (true) {
                        char e;
                        try {
                            e = i.nextrpChar();
                        }
                        catch (StopIterationReturnPath exc) {
                            break block8;
                        }
                        this.addChar(e);
                    }
                }
                if (source instanceof Collection) {
                    Collection s = (Collection)source;
                    this.clearHinting(s.size());
                    for (Character e : s) {
                        this.addChar(e.charValue());
                    }
                } else {
                    throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(source);
                }
            }
        }

        default public void clearHinting(int newCapacity) {
            this.clear();
        }

        @Override
        default public String _toString() {
            return PrimitiveCollections.defaultToString(this);
        }
    }

    @SignalType
    public static interface CharacterIntervalCollection
    extends CharacterCollection {
        @Override
        public int size();

        public char getLowerBoundInclusive();
    }

    @SignalType
    public static interface CharacterList
    extends PrimitiveList<Character, char[]>,
    NonuniformMethodsForCharacterList,
    CharacterListRO,
    CharacterListRWFixed {
        @Override
        default public Iterator<Character> iterator() {
            return NonuniformMethodsForCharacterList.super.iterator();
        }

        public void insertChar(int var1, char var2);

        public CharacterList clone();

        public void setSizeChar(int var1, char var2);

        @Override
        default public void setSize(int newSize, Character elementToAddIfGrowing) {
            this.setSizeChar(newSize, elementToAddIfGrowing.charValue());
        }

        @Override
        default public void setSize(int newSize) {
            this.setSizeChar(newSize, '\u0000');
        }

        @Override
        default public void clear() {
            this.setSize(0);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllChars(int index, char[] array) {
            this.setAllChars(index, array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllChars(int index, Slice<char[]> arraySlice) {
            this.setAllChars(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        default public void setAllChars(int start, char[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof char[]) {
                    Slice s = u;
                    System.arraycopy(array, offset, s.getUnderlying(), s.getOffset() + start, length);
                    return;
                }
            }
            CharacterList.defaultSetAllChars(this, start, array, offset, length);
        }

        public static void defaultSetAllChars(CharacterList list, int start, @WritableValue char[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                list.setChar(start + i, array[offset + i]);
                ++i;
            }
        }

        default public void setAll(int destIndex, List sourceU, int sourceIndex, @Nonnegative int amount) throws IndexOutOfBoundsException {
            List source = sourceU;
            CharacterList dest = this;
            int sourceSize = source.size();
            int destSize = dest.size();
            CollectionUtilities.rangeCheckIntervalByLength(sourceSize, sourceIndex, amount);
            CollectionUtilities.rangeCheckIntervalByLength(destSize, destIndex, amount);
            if (TransparentContiguousArrayBackedCollection.is(source)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)source)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(sourceSize, u);
                if (u.getUnderlying() instanceof char[]) {
                    Slice s = u;
                    this.setAllChars(destIndex, (Slice)s.subslice(sourceIndex, amount));
                    return;
                }
            }
            if (source instanceof CharacterList) {
                CharacterList primSource = (CharacterList)source;
                if (destIndex < sourceIndex) {
                    int i = 0;
                    while (i < amount) {
                        dest.setChar(destIndex + i, primSource.getChar(sourceIndex + i));
                        ++i;
                    }
                } else {
                    int i = amount - 1;
                    while (i >= 0) {
                        dest.setChar(destIndex + i, primSource.getChar(sourceIndex + i));
                        --i;
                    }
                }
            } else if (destIndex < sourceIndex) {
                int i = 0;
                while (i < amount) {
                    dest.set(destIndex + i, (Character)source.get(sourceIndex + i));
                    ++i;
                }
            } else {
                int i = amount - 1;
                while (i >= 0) {
                    dest.set(destIndex + i, (Character)source.get(sourceIndex + i));
                    --i;
                }
            }
        }

        default public void getAllChars(int start, @WritableValue char[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof char[]) {
                    Slice s = u;
                    System.arraycopy(s.getUnderlying(), s.getOffset() + start, array, offset, length);
                    return;
                }
            }
            CharacterList.defaultGetAllChars(this, start, array, offset, length);
        }

        public static void defaultGetAllChars(CharacterList list, int start, @WritableValue char[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                array[offset + i] = list.getChar(start + i);
                ++i;
            }
        }

        @ThrowAwayValue
        default public char[] getAllChars(int start, int end) {
            CollectionUtilities.rangeCheckInterval(this.size(), start, end);
            char[] buff = new char[end - start];
            this.getAllChars(start, buff, 0, buff.length);
            return buff;
        }

        @Override
        default public boolean addChar(char value) {
            this.insertChar(this.size(), value);
            return true;
        }

        @Override
        default public boolean addAll(Collection<? extends Character> c) {
            this.addAll(this.size(), c);
            return true;
        }

        @Override
        default public boolean addAllChars(char[] elements, int offset, int length) {
            this.insertAllChars(this.size(), elements, offset, length);
            return true;
        }

        default public void removeByIndex(int index) {
            this.removeRange(index, index + 1);
        }

        default public char removeCharByIndex(int index) throws IndexOutOfBoundsException {
            char v = this.getChar(index);
            this.removeByIndex(index);
            return v;
        }

        @Override
        default public boolean removeChar(char value) {
            int i = this.indexOfChar(value);
            if (i != -1) {
                this.removeByIndex(i);
                return true;
            }
            return false;
        }

        @Override
        default public boolean retainAll(Collection<?> c) {
            if (c instanceof CharacterCollection) {
                CharacterCollection cc = (CharacterCollection)c;
                boolean changedAtAll = false;
                int i = this.size() - 1;
                while (i >= 0) {
                    if (!cc.containsChar(this.getChar(i))) {
                        this.removeCharByIndex(i);
                        changedAtAll = true;
                    }
                    --i;
                }
                return changedAtAll;
            }
            boolean changedAtAll = false;
            int i = this.size() - 1;
            while (i >= 0) {
                if (!c.contains(Character.valueOf(this.getChar(i)))) {
                    this.removeCharByIndex(i);
                    changedAtAll = true;
                }
                --i;
            }
            return changedAtAll;
        }

        @Override
        default public SimpleCharacterIterator newSimpleCharacterIterator() {
            return new SimpleCharacterIterator(){
                int index = 0;

                @Override
                public char nextrpChar() throws StopIterationReturnPath {
                    int i = this.index;
                    if (i >= this.size()) {
                        throw StopIterationReturnPath.I;
                    }
                    this.index = i + 1;
                    return this.getChar(i);
                }
            };
        }

        @Override
        default public boolean containsChar(char value) {
            return this.indexOfChar(value) != -1;
        }

        default public void insertAllChars(int index, char[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                this.insertChar(index + i, array[offset + i]);
                ++i;
            }
        }

        @Override
        default public boolean addAll(int index, Collection<? extends Character> c) {
            if (c instanceof CharacterCollection) {
                CharacterCollection characterCollection = (CharacterCollection)c;
                SimpleCharacterIterator i = characterCollection.newSimpleCharacterIterator();
                try {
                    while (true) {
                        this.insertChar(index, i.nextrpChar());
                        ++index;
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {}
            } else {
                for (Character c2 : c) {
                    this.insertChar(index, c2.charValue());
                    ++index;
                }
            }
            return true;
        }

        default public void insertAllChars(int index, char[] array) {
            this.insertAllChars(index, array, 0, array.length);
        }

        default public void insertAllChars(int index, Slice<char[]> arraySlice) {
            this.insertAllChars(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @Override
        default public Character get(int index) {
            return Character.valueOf(this.getChar(index));
        }

        @Override
        default public Character set(int index, Character value) {
            Character previous = this.get(index);
            this.setChar(index, value.charValue());
            return previous;
        }

        @Override
        default public void add(int index, Character value) {
            this.insertChar(index, value.charValue());
        }

        @Override
        default public Character remove(int index) throws IndexOutOfBoundsException {
            return Character.valueOf(this.removeCharByIndex(index));
        }

        @Override
        default public int indexOf(Object o) {
            return o instanceof Character ? this.indexOfChar(((Character)o).charValue()) : -1;
        }

        @Override
        default public int lastIndexOf(Object o) {
            return o instanceof Character ? this.lastIndexOfChar(((Character)o).charValue()) : -1;
        }

        default public int indexOf(Object o, int start) {
            return o instanceof Character ? this.indexOfChar(((Character)o).charValue(), start) : -1;
        }

        default public int lastIndexOf(Object o, int start) {
            return o instanceof Character ? this.lastIndexOfChar(((Character)o).charValue(), start) : -1;
        }

        @Override
        default public ListIterator<Character> listIterator() {
            return this.listIterator(0);
        }

        @Override
        default public ListIterator<Character> listIterator(int index) {
            return new DelegatingListIterator<Character>(this, index);
        }

        @Override
        default public CharacterList subList(int fromIndex, int toIndex) {
            if (fromIndex == 0 && toIndex == this.size()) {
                return this;
            }
            if (this instanceof Sublist) {
                Sublist s = (Sublist)((Object)this);
                return new CharacterSublist((CharacterList)s.getUnderlying(), s.getSublistStartingIndex() + fromIndex, toIndex - fromIndex);
            }
            return new CharacterSublist(this, fromIndex, toIndex - fromIndex);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForCharacterList.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForCharacterList.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForCharacterList.super.containsAll(c);
        }

        @Override
        default public boolean add(Character e) {
            return NonuniformMethodsForCharacterList.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForCharacterList.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForCharacterList.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveList.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForCharacterList.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForCharacterList.super.toArray(a);
        }

        @Override
        default public void storeBoxingIntoArray(Slice<Object[]> array) {
            int n = this.size();
            int i = 0;
            while (i < n) {
                ArrayUtilities.setReference(array, i, this.get(i));
                ++i;
            }
        }

        default public boolean endsWith(List<Character> suffixCandidate) {
            return this.size() >= suffixCandidate.size() && this.subListToEnd(suffixCandidate.size()).equivalent(suffixCandidate);
        }

        default public boolean startsWith(List<Character> prefixCandidate) {
            return this.size() >= prefixCandidate.size() && this.subListFromBeginning(prefixCandidate.size()).equivalent(prefixCandidate);
        }

        default public CharacterList subListToEnd(int start) {
            return (CharacterList)PrimitiveList.super.subListToEnd(start);
        }

        default public CharacterList subListFromBeginning(int lengthWhichIsEndExclusiveInThisCaseXD) {
            return (CharacterList)PrimitiveList.super.subListFromBeginning(lengthWhichIsEndExclusiveInThisCaseXD);
        }

        default public CharacterList subListByLength(int start, int length) {
            return (CharacterList)PrimitiveList.super.subListByLength(start, length);
        }

        @Override
        default public void fillBySetting(int start, int count, Character value) {
            this.fillBySettingChar(start, count, value.charValue());
        }

        default public void fillBySettingChar(char value) {
            this.fillBySettingChar(0, this.size(), value);
        }

        default public void fillBySettingChar(int start, int count, char value) {
            CollectionUtilities.rangeCheckIntervalByLength(this.size(), start, count);
            if (count >= 100) {
                char[] array = new char[SmallIntegerMathUtilities.least(count, 1024)];
                if (value != '\u0000') {
                    Arrays.fill(array, value);
                }
                int al = array.length;
                CharacterList l = PrimitiveCollections.charArrayAsList(array);
                while (count > al) {
                    this.setAll(start, l);
                    start += al;
                    count -= al;
                }
                if (count > 0) {
                    this.setAll(start, l.subList(0, count));
                }
            } else {
                int e = start + count;
                int i = start;
                while (i < e) {
                    this.setChar(i, value);
                    ++i;
                }
            }
        }
    }

    @SignalType
    public static interface CharacterListRO
    extends Equivalenceable {
        public char getChar(int var1);

        public int size();

        default public int indexOfChar(char value) {
            return this.indexOfChar(value, 0);
        }

        default public int lastIndexOfChar(char value) {
            return this.lastIndexOfChar(value, this.size() - 1);
        }

        default public int indexOfChar(char value, int start) {
            int n = this.size();
            int i = start;
            while (i < n) {
                if (Primitives.eqSane(this.getChar(i), value)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        default public int lastIndexOfChar(char value, int start) {
            int i = start;
            if (i >= 0 && Primitives.eqSane(this.getChar(i), value)) {
                return i;
            }
            return i;
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof CharacterListRO) {
                return this.equivalentFixedRO((CharacterListRO)o);
            }
            if (o instanceof List) {
                List other = (List)o;
                int size = this.size();
                if (other.size() != size) {
                    return false;
                }
                int i = 0;
                while (i < size) {
                    Object e = other.get(i);
                    if (e instanceof Character) {
                        if (!Primitives.eqSane(this.getChar(i), ((Character)e).charValue())) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalentFixedRO(CharacterListRO other) {
            int size = this.size();
            if (other.size() != size) {
                return false;
            }
            int i = 0;
            while (i < size) {
                if (!Primitives.eqSane(this.getChar(i), other.getChar(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            int size = this.size();
            int i = 0;
            while (i < size) {
                char e = this.getChar(i);
                r = 31 * r + Primitives.hashprim(e);
                ++i;
            }
            return r;
        }
    }

    @SignalType
    public static interface CharacterListRWFixed
    extends CharacterListRO {
        public void setChar(int var1, char var2);
    }

    public static class CharacterListWrapper
    implements CharacterList {
        protected final List<Character> underlying;

        public CharacterListWrapper(List<Character> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithRemoveRange) {
                ((ListWithRemoveRange)((Object)this.underlying)).removeRange(start, pastEnd);
            } else {
                CharacterList.super.removeRange(start, pastEnd);
            }
        }

        @Override
        public void setSize(int newSize, Character elementToAddIfGrowing) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize, elementToAddIfGrowing);
            } else {
                CharacterList.super.setSize(newSize, elementToAddIfGrowing);
            }
        }

        @Override
        public void setSize(int newSize) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize);
            } else {
                CharacterList.super.setSize(newSize);
            }
        }

        @Override
        public void setAll(int destIndex, List source, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithSetAll) {
                ((ListWithSetAll)((Object)this.underlying)).setAll(destIndex, source, sourceIndex, amount);
            } else {
                CharacterList.super.setAll(destIndex, source, sourceIndex, amount);
            }
        }

        @Override
        public void fillBySetting(int start, int count, Character value) {
            if (this.underlying instanceof ListWithFill) {
                ((ListWithFill)this.underlying).fillBySetting(start, count, value);
            } else {
                CharacterList.super.fillBySetting(start, count, value);
            }
        }

        @Override
        public CharacterList clone() {
            return PrimitiveCollections.asCharacterList(ObjectUtilities.attemptClone(this.underlying));
        }

        @Override
        public char getChar(int index) {
            return this.get(index).charValue();
        }

        @Override
        public void setChar(int index, char value) {
            this.set(index, Character.valueOf(value));
        }

        @Override
        public void insertChar(int index, char value) {
            this.add(index, Character.valueOf(value));
        }

        @Override
        public void setSizeChar(int newSize, char elementToAddIfGrowing) {
            this.setSize(newSize, Character.valueOf(elementToAddIfGrowing));
        }

        @Override
        public void forEach(Consumer<? super Character> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Character e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Character> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Character> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Character> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Character> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Character> c) {
            this.underlying.sort(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public Character get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Character set(int index, Character element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Character element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Character> stream() {
            return this.underlying.stream();
        }

        @Override
        public Character remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Character> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public Spliterator<Character> spliterator() {
            return this.underlying.spliterator();
        }
    }

    @SignalType
    public static interface CharacterSet
    extends PrimitiveSet<Character, char[]>,
    NonuniformMethodsForCharacterSet {
        @Override
        default public Iterator<Character> iterator() {
            return NonuniformMethodsForCharacterSet.super.iterator();
        }

        @Override
        default public boolean addAll(Collection<? extends Character> c) {
            return NonuniformMethodsForCharacterSet.super.addAll(c);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForCharacterSet.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForCharacterSet.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForCharacterSet.super.containsAll(c);
        }

        @Override
        default public boolean add(Character e) {
            return NonuniformMethodsForCharacterSet.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForCharacterSet.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForCharacterSet.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveSet.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForCharacterSet.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForCharacterSet.super.toArray(a);
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof CharacterSet) {
                return this.equivalent((CharacterSet)o);
            }
            if (o instanceof Set) {
                int bs;
                Set a = (Set)o;
                CharacterSet b = this;
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                int as = a.size();
                if (as != (bs = b.size())) {
                    return false;
                }
                if (CodeHinting.arbitrary(as, bs) == 0) {
                    return true;
                }
                for (Object an : a) {
                    if (an instanceof Character) {
                        if (b.containsChar(((Character)an).charValue())) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalent(CharacterSet other) {
            int bs;
            CharacterSet a = this;
            CharacterSet b = other;
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            int as = a.size();
            if (as != (bs = b.size())) {
                return false;
            }
            if (CodeHinting.arbitrary(as, bs) == 0) {
                return true;
            }
            SimpleCharacterIterator i = a.newSimpleCharacterIterator();
            try {
                while (b.containsChar(i.nextrpChar())) {
                }
                return false;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return true;
            }
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            SimpleCharacterIterator i = this.newSimpleCharacterIterator();
            try {
                while (true) {
                    r += Primitives.hashprim(i.nextrpChar());
                }
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return r;
            }
        }
    }

    public static class CharacterSublist
    implements CharacterList,
    DefaultShiftingBasedCharacterList,
    Sublist<Character>,
    ShiftableList {
        protected final CharacterList underlying;
        protected final int start;
        protected int size;

        public CharacterSublist(CharacterList underlying, int start, int initialSize) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.size(), start, initialSize);
            this.underlying = underlying;
            this.start = start;
            this.size = initialSize;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public char getChar(int index) {
            return this.underlying.getChar(index + this.start);
        }

        @Override
        public void setChar(int index, char value) {
            this.underlying.setChar(index + this.start, value);
        }

        @Override
        public void shiftRegionStretchingFromIndexToEndByAmountChangingSize(int start, int amount) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), start);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this.underlying, start, amount);
            this.size += amount;
        }

        @Override
        public CharacterList clone() {
            CharacterArrayList c = new CharacterArrayList();
            c.addAll(this);
            return c;
        }

        @Override
        public CharacterList getUnderlying() {
            return this.underlying;
        }

        @Override
        public int getSublistStartingIndex() {
            return this.start;
        }

        @Override
        public String toString() {
            return this._toString();
        }

        @Override
        public Boolean isWritableCollection() {
            return this.underlying.isWritableCollection();
        }
    }

    public static class CharacterTable {
        protected int width;
        protected char[] data;

        public CharacterTable(int width, int height) {
            if (width < 0) {
                throw new IllegalArgumentException();
            }
            if (height < 0) {
                throw new IllegalArgumentException();
            }
            this.data = new char[width * height];
        }

        @Nonnegative
        public int getNumberOfColumns() {
            return this.width;
        }

        @Nonnegative
        public int getNumberOfRows() {
            return this.data.length / this.width;
        }

        @Nonnegative
        public int getNumberOfCells() {
            return this.data.length;
        }

        public char getCellContentsCharacter(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            return this.data[rowIndex * this.getNumberOfColumns() + columnIndex];
        }

        public void setCellContentsCharacter(int columnIndex, int rowIndex, @Nullable char newValue) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            this.data[rowIndex * this.getNumberOfColumns() + columnIndex] = newValue;
        }

        @Nullable
        public Character getCellContents(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            return Character.valueOf(this.getCellContentsCharacter(columnIndex, rowIndex));
        }

        public void setCellContents(int columnIndex, int rowIndex, @Nullable Character newValue) throws IndexOutOfBoundsException {
            this.setCellContentsCharacter(columnIndex, rowIndex, newValue.charValue());
        }
    }

    public static interface DefaultByteIntervalCollection
    extends ByteIntervalCollection,
    SimpleIterator.SimpleIterable<Byte> {
        @Override
        default public boolean containsByte(byte i) {
            return i >= this.getLowerBoundInclusive() && i < this.getLowerBoundInclusive() + this.size();
        }

        @Override
        default public Iterator<Byte> iterator() {
            final byte lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new Iterator<Byte>(){
                int next = 0;

                @Override
                public Byte next() {
                    int next = this.next;
                    if (next >= s) {
                        throw new NoSuchElementException();
                    }
                    this.next = next + 1;
                    return (byte)(next + lb);
                }

                @Override
                public boolean hasNext() {
                    return this.next < this.size();
                }
            };
        }

        @Override
        default public SimpleIterator<Byte> simpleIterator() {
            final byte lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new SimpleIterator<Byte>(){
                int next = 0;

                @Override
                public Byte nextrp() throws StopIterationReturnPath {
                    int next = this.next;
                    if (next >= s) {
                        throw StopIterationReturnPath.I;
                    }
                    this.next = next + 1;
                    return (byte)(next + lb);
                }
            };
        }

        @Override
        default public SimpleByteIterator newSimpleByteIterator() {
            final byte lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new SimpleByteIterator(){
                int next = 0;

                @Override
                public byte nextrpByte() throws StopIterationReturnPath {
                    int next = this.next;
                    if (next >= s) {
                        throw StopIterationReturnPath.I;
                    }
                    this.next = next + 1;
                    return (byte)(next + lb);
                }
            };
        }

        @Override
        default public byte[] toByteArray() {
            return CollectionUtilities.intervalBytesArray(this.getLowerBoundInclusive(), this.size());
        }
    }

    public static interface DefaultCharacterIntervalCollection
    extends CharacterIntervalCollection,
    SimpleIterator.SimpleIterable<Character> {
        @Override
        default public boolean containsChar(char i) {
            return i >= this.getLowerBoundInclusive() && i < this.getLowerBoundInclusive() + this.size();
        }

        @Override
        default public Iterator<Character> iterator() {
            final char lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new Iterator<Character>(){
                int next = 0;

                @Override
                public Character next() {
                    int next = this.next;
                    if (next >= s) {
                        throw new NoSuchElementException();
                    }
                    this.next = next + 1;
                    return Character.valueOf((char)(next + lb));
                }

                @Override
                public boolean hasNext() {
                    return this.next < this.size();
                }
            };
        }

        @Override
        default public SimpleIterator<Character> simpleIterator() {
            final char lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new SimpleIterator<Character>(){
                int next = 0;

                @Override
                public Character nextrp() throws StopIterationReturnPath {
                    int next = this.next;
                    if (next >= s) {
                        throw StopIterationReturnPath.I;
                    }
                    this.next = next + 1;
                    return Character.valueOf((char)(next + lb));
                }
            };
        }

        @Override
        default public SimpleCharacterIterator newSimpleCharacterIterator() {
            final char lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new SimpleCharacterIterator(){
                int next = 0;

                @Override
                public char nextrpChar() throws StopIterationReturnPath {
                    int next = this.next;
                    if (next >= s) {
                        throw StopIterationReturnPath.I;
                    }
                    this.next = next + 1;
                    return (char)(next + lb);
                }
            };
        }

        @Override
        default public char[] toCharArray() {
            return CollectionUtilities.intervalCharactersArray(this.getLowerBoundInclusive(), this.size());
        }
    }

    public static interface DefaultIntegerIntervalCollection
    extends IntegerIntervalCollection,
    SimpleIterator.SimpleIterable<Integer> {
        @Override
        default public boolean containsInt(int i) {
            return i >= this.getLowerBoundInclusive() && i < this.getLowerBoundInclusive() + this.size();
        }

        @Override
        default public Iterator<Integer> iterator() {
            final int lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new Iterator<Integer>(){
                int next = 0;

                @Override
                public Integer next() {
                    int next = this.next;
                    if (next >= s) {
                        throw new NoSuchElementException();
                    }
                    this.next = next + 1;
                    return next + lb;
                }

                @Override
                public boolean hasNext() {
                    return this.next < this.size();
                }
            };
        }

        @Override
        default public SimpleIterator<Integer> simpleIterator() {
            final int lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new SimpleIterator<Integer>(){
                int next = 0;

                @Override
                public Integer nextrp() throws StopIterationReturnPath {
                    int next = this.next;
                    if (next >= s) {
                        throw StopIterationReturnPath.I;
                    }
                    this.next = next + 1;
                    return next + lb;
                }
            };
        }

        @Override
        default public SimpleIntegerIterator newSimpleIntegerIterator() {
            final int lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new SimpleIntegerIterator(){
                int next = 0;

                @Override
                public int nextrpInt() throws StopIterationReturnPath {
                    int next = this.next;
                    if (next >= s) {
                        throw StopIterationReturnPath.I;
                    }
                    this.next = next + 1;
                    return next + lb;
                }
            };
        }

        @Override
        default public int[] toIntArray() {
            return CollectionUtilities.intervalIntegersArray(this.getLowerBoundInclusive(), this.size());
        }
    }

    public static interface DefaultLongIntervalCollection
    extends LongIntervalCollection,
    SimpleIterator.SimpleIterable<Long> {
        @Override
        default public boolean containsLong(long i) {
            return i >= this.getLowerBoundInclusive() && i < this.getLowerBoundInclusive() + (long)this.size();
        }

        @Override
        default public Iterator<Long> iterator() {
            final long lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new Iterator<Long>(){
                int next = 0;

                @Override
                public Long next() {
                    int next = this.next;
                    if (next >= s) {
                        throw new NoSuchElementException();
                    }
                    this.next = next + 1;
                    return (long)next + lb;
                }

                @Override
                public boolean hasNext() {
                    return this.next < this.size();
                }
            };
        }

        @Override
        default public SimpleIterator<Long> simpleIterator() {
            final long lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new SimpleIterator<Long>(){
                int next = 0;

                @Override
                public Long nextrp() throws StopIterationReturnPath {
                    int next = this.next;
                    if (next >= s) {
                        throw StopIterationReturnPath.I;
                    }
                    this.next = next + 1;
                    return (long)next + lb;
                }
            };
        }

        @Override
        default public SimpleLongIterator newSimpleLongIterator() {
            final long lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new SimpleLongIterator(){
                int next = 0;

                @Override
                public long nextrpLong() throws StopIterationReturnPath {
                    int next = this.next;
                    if (next >= s) {
                        throw StopIterationReturnPath.I;
                    }
                    this.next = next + 1;
                    return (long)next + lb;
                }
            };
        }

        @Override
        default public long[] toLongArray() {
            return CollectionUtilities.intervalLongsArray(this.getLowerBoundInclusive(), this.size());
        }
    }

    public static interface DefaultShiftingBasedBooleanList
    extends BooleanList {
        @Override
        default public void clear() {
            this.removeRange(0, this.size());
        }

        @Override
        default public void insertBoolean(int index, boolean value) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, 1);
            this.setBoolean(index, value);
        }

        @Override
        default public void insertAllBooleans(int index, boolean[] array, int offset, int length) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, length);
            this.setAllBooleans(index, array, offset, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public boolean addAll(int index, Collection<? extends Boolean> c) {
            block7: {
                CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
                int amount = c.size();
                CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, amount);
                if (c instanceof List) {
                    CollectionUtilities.listcopy((List)c, 0, this, index, amount);
                } else {
                    if (c instanceof BooleanCollection) {
                        SimpleBooleanIterator iterator = ((BooleanCollection)c).newSimpleBooleanIterator();
                        boolean bl = false;
                        while (true) {
                            void var5_7;
                            boolean e;
                            try {
                                e = iterator.nextrpBoolean();
                            }
                            catch (StopIterationReturnPath rp) {
                                break block7;
                            }
                            this.setBoolean(index + var5_7, e);
                            ++var5_7;
                        }
                    }
                    int i = 0;
                    for (Boolean bl : c) {
                        this.set(index + i, bl);
                        ++i;
                    }
                }
            }
            return true;
        }

        @Override
        default public void setSizeBoolean(int newSize, boolean elementToAddIfGrowing) {
            if (newSize < 0) {
                throw new IllegalArgumentException();
            }
            int oldSize = this.size();
            int amount = newSize - oldSize;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, oldSize, amount);
            if (amount > 0) {
                this.fillBySettingBoolean(oldSize, newSize - oldSize, elementToAddIfGrowing);
            }
        }

        @Override
        default public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.rangeCheckInterval(this.size(), start, pastEnd);
            int length = pastEnd - start;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, pastEnd, -length);
        }
    }

    public static interface DefaultShiftingBasedByteList
    extends ByteList {
        @Override
        default public void clear() {
            this.removeRange(0, this.size());
        }

        @Override
        default public void insertByte(int index, byte value) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, 1);
            this.setByte(index, value);
        }

        @Override
        default public void insertAllBytes(int index, byte[] array, int offset, int length) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, length);
            this.setAllBytes(index, array, offset, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public boolean addAll(int index, Collection<? extends Byte> c) {
            block7: {
                CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
                int amount = c.size();
                CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, amount);
                if (c instanceof List) {
                    CollectionUtilities.listcopy((List)c, 0, this, index, amount);
                } else {
                    if (c instanceof ByteCollection) {
                        SimpleByteIterator iterator = ((ByteCollection)c).newSimpleByteIterator();
                        boolean bl = false;
                        while (true) {
                            void var5_7;
                            byte e;
                            try {
                                e = iterator.nextrpByte();
                            }
                            catch (StopIterationReturnPath rp) {
                                break block7;
                            }
                            this.setByte(index + var5_7, e);
                            ++var5_7;
                        }
                    }
                    int i = 0;
                    for (Byte by : c) {
                        this.set(index + i, by);
                        ++i;
                    }
                }
            }
            return true;
        }

        @Override
        default public void setSizeByte(int newSize, byte elementToAddIfGrowing) {
            if (newSize < 0) {
                throw new IllegalArgumentException();
            }
            int oldSize = this.size();
            int amount = newSize - oldSize;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, oldSize, amount);
            if (amount > 0) {
                this.fillBySettingByte(oldSize, newSize - oldSize, elementToAddIfGrowing);
            }
        }

        @Override
        default public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.rangeCheckInterval(this.size(), start, pastEnd);
            int length = pastEnd - start;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, pastEnd, -length);
        }
    }

    public static interface DefaultShiftingBasedCharacterList
    extends CharacterList {
        @Override
        default public void clear() {
            this.removeRange(0, this.size());
        }

        @Override
        default public void insertChar(int index, char value) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, 1);
            this.setChar(index, value);
        }

        @Override
        default public void insertAllChars(int index, char[] array, int offset, int length) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, length);
            this.setAllChars(index, array, offset, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public boolean addAll(int index, Collection<? extends Character> c) {
            block7: {
                CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
                int amount = c.size();
                CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, amount);
                if (c instanceof List) {
                    CollectionUtilities.listcopy((List)c, 0, this, index, amount);
                } else {
                    if (c instanceof CharacterCollection) {
                        SimpleCharacterIterator iterator = ((CharacterCollection)c).newSimpleCharacterIterator();
                        boolean bl = false;
                        while (true) {
                            void var5_7;
                            char e;
                            try {
                                e = iterator.nextrpChar();
                            }
                            catch (StopIterationReturnPath rp) {
                                break block7;
                            }
                            this.setChar(index + var5_7, e);
                            ++var5_7;
                        }
                    }
                    int i = 0;
                    for (Character c2 : c) {
                        this.set(index + i, c2);
                        ++i;
                    }
                }
            }
            return true;
        }

        @Override
        default public void setSizeChar(int newSize, char elementToAddIfGrowing) {
            if (newSize < 0) {
                throw new IllegalArgumentException();
            }
            int oldSize = this.size();
            int amount = newSize - oldSize;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, oldSize, amount);
            if (amount > 0) {
                this.fillBySettingChar(oldSize, newSize - oldSize, elementToAddIfGrowing);
            }
        }

        @Override
        default public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.rangeCheckInterval(this.size(), start, pastEnd);
            int length = pastEnd - start;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, pastEnd, -length);
        }
    }

    public static interface DefaultShiftingBasedDoubleList
    extends DoubleList {
        @Override
        default public void clear() {
            this.removeRange(0, this.size());
        }

        @Override
        default public void insertDouble(int index, double value) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, 1);
            this.setDouble(index, value);
        }

        @Override
        default public void insertAllDoubles(int index, double[] array, int offset, int length) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, length);
            this.setAllDoubles(index, array, offset, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public boolean addAll(int index, Collection<? extends Double> c) {
            block7: {
                CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
                int amount = c.size();
                CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, amount);
                if (c instanceof List) {
                    CollectionUtilities.listcopy((List)c, 0, this, index, amount);
                } else {
                    if (c instanceof DoubleCollection) {
                        SimpleDoubleIterator iterator = ((DoubleCollection)c).newSimpleDoubleIterator();
                        boolean bl = false;
                        while (true) {
                            void var5_7;
                            double e;
                            try {
                                e = iterator.nextrpDouble();
                            }
                            catch (StopIterationReturnPath rp) {
                                break block7;
                            }
                            this.setDouble(index + var5_7, e);
                            ++var5_7;
                        }
                    }
                    int i = 0;
                    for (Double d : c) {
                        this.set(index + i, d);
                        ++i;
                    }
                }
            }
            return true;
        }

        @Override
        default public void setSizeDouble(int newSize, double elementToAddIfGrowing) {
            if (newSize < 0) {
                throw new IllegalArgumentException();
            }
            int oldSize = this.size();
            int amount = newSize - oldSize;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, oldSize, amount);
            if (amount > 0) {
                this.fillBySettingDouble(oldSize, newSize - oldSize, elementToAddIfGrowing);
            }
        }

        @Override
        default public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.rangeCheckInterval(this.size(), start, pastEnd);
            int length = pastEnd - start;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, pastEnd, -length);
        }
    }

    public static interface DefaultShiftingBasedFloatList
    extends FloatList {
        @Override
        default public void clear() {
            this.removeRange(0, this.size());
        }

        @Override
        default public void insertFloat(int index, float value) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, 1);
            this.setFloat(index, value);
        }

        @Override
        default public void insertAllFloats(int index, float[] array, int offset, int length) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, length);
            this.setAllFloats(index, array, offset, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public boolean addAll(int index, Collection<? extends Float> c) {
            block7: {
                CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
                int amount = c.size();
                CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, amount);
                if (c instanceof List) {
                    CollectionUtilities.listcopy((List)c, 0, this, index, amount);
                } else {
                    if (c instanceof FloatCollection) {
                        SimpleFloatIterator iterator = ((FloatCollection)c).newSimpleFloatIterator();
                        boolean bl = false;
                        while (true) {
                            void var5_7;
                            float e;
                            try {
                                e = iterator.nextrpFloat();
                            }
                            catch (StopIterationReturnPath rp) {
                                break block7;
                            }
                            this.setFloat(index + var5_7, e);
                            ++var5_7;
                        }
                    }
                    int i = 0;
                    for (Float f : c) {
                        this.set(index + i, f);
                        ++i;
                    }
                }
            }
            return true;
        }

        @Override
        default public void setSizeFloat(int newSize, float elementToAddIfGrowing) {
            if (newSize < 0) {
                throw new IllegalArgumentException();
            }
            int oldSize = this.size();
            int amount = newSize - oldSize;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, oldSize, amount);
            if (amount > 0) {
                this.fillBySettingFloat(oldSize, newSize - oldSize, elementToAddIfGrowing);
            }
        }

        @Override
        default public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.rangeCheckInterval(this.size(), start, pastEnd);
            int length = pastEnd - start;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, pastEnd, -length);
        }
    }

    public static interface DefaultShiftingBasedIntegerList
    extends IntegerList {
        @Override
        default public void clear() {
            this.removeRange(0, this.size());
        }

        @Override
        default public void insertInt(int index, int value) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, 1);
            this.setInt(index, value);
        }

        @Override
        default public void insertAllInts(int index, int[] array, int offset, int length) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, length);
            this.setAllInts(index, array, offset, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public boolean addAll(int index, Collection<? extends Integer> c) {
            block7: {
                CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
                int amount = c.size();
                CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, amount);
                if (c instanceof List) {
                    CollectionUtilities.listcopy((List)c, 0, this, index, amount);
                } else {
                    if (c instanceof IntegerCollection) {
                        SimpleIntegerIterator iterator = ((IntegerCollection)c).newSimpleIntegerIterator();
                        boolean bl = false;
                        while (true) {
                            void var5_7;
                            int e;
                            try {
                                e = iterator.nextrpInt();
                            }
                            catch (StopIterationReturnPath rp) {
                                break block7;
                            }
                            this.setInt(index + var5_7, e);
                            ++var5_7;
                        }
                    }
                    int i = 0;
                    for (Integer n : c) {
                        this.set(index + i, n);
                        ++i;
                    }
                }
            }
            return true;
        }

        @Override
        default public void setSizeInt(int newSize, int elementToAddIfGrowing) {
            if (newSize < 0) {
                throw new IllegalArgumentException();
            }
            int oldSize = this.size();
            int amount = newSize - oldSize;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, oldSize, amount);
            if (amount > 0) {
                this.fillBySettingInt(oldSize, newSize - oldSize, elementToAddIfGrowing);
            }
        }

        @Override
        default public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.rangeCheckInterval(this.size(), start, pastEnd);
            int length = pastEnd - start;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, pastEnd, -length);
        }
    }

    public static interface DefaultShiftingBasedLongList
    extends LongList {
        @Override
        default public void clear() {
            this.removeRange(0, this.size());
        }

        @Override
        default public void insertLong(int index, long value) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, 1);
            this.setLong(index, value);
        }

        @Override
        default public void insertAllLongs(int index, long[] array, int offset, int length) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, length);
            this.setAllLongs(index, array, offset, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public boolean addAll(int index, Collection<? extends Long> c) {
            block7: {
                CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
                int amount = c.size();
                CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, amount);
                if (c instanceof List) {
                    CollectionUtilities.listcopy((List)c, 0, this, index, amount);
                } else {
                    if (c instanceof LongCollection) {
                        SimpleLongIterator iterator = ((LongCollection)c).newSimpleLongIterator();
                        boolean bl = false;
                        while (true) {
                            void var5_7;
                            long e;
                            try {
                                e = iterator.nextrpLong();
                            }
                            catch (StopIterationReturnPath rp) {
                                break block7;
                            }
                            this.setLong(index + var5_7, e);
                            ++var5_7;
                        }
                    }
                    int i = 0;
                    for (Long l : c) {
                        this.set(index + i, l);
                        ++i;
                    }
                }
            }
            return true;
        }

        @Override
        default public void setSizeLong(int newSize, long elementToAddIfGrowing) {
            if (newSize < 0) {
                throw new IllegalArgumentException();
            }
            int oldSize = this.size();
            int amount = newSize - oldSize;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, oldSize, amount);
            if (amount > 0) {
                this.fillBySettingLong(oldSize, newSize - oldSize, elementToAddIfGrowing);
            }
        }

        @Override
        default public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.rangeCheckInterval(this.size(), start, pastEnd);
            int length = pastEnd - start;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, pastEnd, -length);
        }
    }

    public static interface DefaultShiftingBasedShortList
    extends ShortList {
        @Override
        default public void clear() {
            this.removeRange(0, this.size());
        }

        @Override
        default public void insertShort(int index, short value) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, 1);
            this.setShort(index, value);
        }

        @Override
        default public void insertAllShorts(int index, short[] array, int offset, int length) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, length);
            this.setAllShorts(index, array, offset, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public boolean addAll(int index, Collection<? extends Short> c) {
            block7: {
                CollectionUtilities.rangeCheckCursorPoint(this.size(), index);
                int amount = c.size();
                CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, index, amount);
                if (c instanceof List) {
                    CollectionUtilities.listcopy((List)c, 0, this, index, amount);
                } else {
                    if (c instanceof ShortCollection) {
                        SimpleShortIterator iterator = ((ShortCollection)c).newSimpleShortIterator();
                        boolean bl = false;
                        while (true) {
                            void var5_7;
                            short e;
                            try {
                                e = iterator.nextrpShort();
                            }
                            catch (StopIterationReturnPath rp) {
                                break block7;
                            }
                            this.setShort(index + var5_7, e);
                            ++var5_7;
                        }
                    }
                    int i = 0;
                    for (Short s : c) {
                        this.set(index + i, s);
                        ++i;
                    }
                }
            }
            return true;
        }

        @Override
        default public void setSizeShort(int newSize, short elementToAddIfGrowing) {
            if (newSize < 0) {
                throw new IllegalArgumentException();
            }
            int oldSize = this.size();
            int amount = newSize - oldSize;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, oldSize, amount);
            if (amount > 0) {
                this.fillBySettingShort(oldSize, newSize - oldSize, elementToAddIfGrowing);
            }
        }

        @Override
        default public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.rangeCheckInterval(this.size(), start, pastEnd);
            int length = pastEnd - start;
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this, pastEnd, -length);
        }
    }

    public static interface DefaultShortIntervalCollection
    extends ShortIntervalCollection,
    SimpleIterator.SimpleIterable<Short> {
        @Override
        default public boolean containsShort(short i) {
            return i >= this.getLowerBoundInclusive() && i < this.getLowerBoundInclusive() + this.size();
        }

        @Override
        default public Iterator<Short> iterator() {
            final short lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new Iterator<Short>(){
                int next = 0;

                @Override
                public Short next() {
                    int next = this.next;
                    if (next >= s) {
                        throw new NoSuchElementException();
                    }
                    this.next = next + 1;
                    return (short)(next + lb);
                }

                @Override
                public boolean hasNext() {
                    return this.next < this.size();
                }
            };
        }

        @Override
        default public SimpleIterator<Short> simpleIterator() {
            final short lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new SimpleIterator<Short>(){
                int next = 0;

                @Override
                public Short nextrp() throws StopIterationReturnPath {
                    int next = this.next;
                    if (next >= s) {
                        throw StopIterationReturnPath.I;
                    }
                    this.next = next + 1;
                    return (short)(next + lb);
                }
            };
        }

        @Override
        default public SimpleShortIterator newSimpleShortIterator() {
            final short lb = this.getLowerBoundInclusive();
            final int s = this.size();
            return new SimpleShortIterator(){
                int next = 0;

                @Override
                public short nextrpShort() throws StopIterationReturnPath {
                    int next = this.next;
                    if (next >= s) {
                        throw StopIterationReturnPath.I;
                    }
                    this.next = next + 1;
                    return (short)(next + lb);
                }
            };
        }

        @Override
        default public short[] toShortArray() {
            return CollectionUtilities.intervalShortsArray(this.getLowerBoundInclusive(), this.size());
        }
    }

    public static interface DefaultToArraysBooleanCollection
    extends BooleanCollection {
        @Override
        default public Object[] toArray() {
            Object[] a = new Object[this.size()];
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
            return a;
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            Object[] aa;
            if (a.length >= this.size()) {
                this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
                return a;
            }
            if (a.getClass() == Boolean[].class) {
                aa = new Boolean[this.size()];
            } else if (a.getClass() == Object[].class) {
                aa = new Object[this.size()];
            } else {
                throw new StructuredClassCastException(a.getClass());
            }
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(aa));
            return aa;
        }

        public void storeBoxingIntoArray(Slice<Object[]> var1);
    }

    public static interface DefaultToArraysByteCollection
    extends ByteCollection {
        @Override
        default public Object[] toArray() {
            Object[] a = new Object[this.size()];
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
            return a;
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            Object[] aa;
            if (a.length >= this.size()) {
                this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
                return a;
            }
            if (a.getClass() == Byte[].class) {
                aa = new Byte[this.size()];
            } else if (a.getClass() == Object[].class) {
                aa = new Object[this.size()];
            } else {
                throw new StructuredClassCastException(a.getClass());
            }
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(aa));
            return aa;
        }

        public void storeBoxingIntoArray(Slice<Object[]> var1);
    }

    public static interface DefaultToArraysCharacterCollection
    extends CharacterCollection {
        @Override
        default public Object[] toArray() {
            Object[] a = new Object[this.size()];
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
            return a;
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            Object[] aa;
            if (a.length >= this.size()) {
                this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
                return a;
            }
            if (a.getClass() == Character[].class) {
                aa = new Character[this.size()];
            } else if (a.getClass() == Object[].class) {
                aa = new Object[this.size()];
            } else {
                throw new StructuredClassCastException(a.getClass());
            }
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(aa));
            return aa;
        }

        public void storeBoxingIntoArray(Slice<Object[]> var1);
    }

    public static interface DefaultToArraysDoubleCollection
    extends DoubleCollection {
        @Override
        default public Object[] toArray() {
            Object[] a = new Object[this.size()];
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
            return a;
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            Object[] aa;
            if (a.length >= this.size()) {
                this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
                return a;
            }
            if (a.getClass() == Double[].class) {
                aa = new Double[this.size()];
            } else if (a.getClass() == Object[].class) {
                aa = new Object[this.size()];
            } else {
                throw new StructuredClassCastException(a.getClass());
            }
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(aa));
            return aa;
        }

        public void storeBoxingIntoArray(Slice<Object[]> var1);
    }

    public static interface DefaultToArraysFloatCollection
    extends FloatCollection {
        @Override
        default public Object[] toArray() {
            Object[] a = new Object[this.size()];
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
            return a;
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            Object[] aa;
            if (a.length >= this.size()) {
                this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
                return a;
            }
            if (a.getClass() == Float[].class) {
                aa = new Float[this.size()];
            } else if (a.getClass() == Object[].class) {
                aa = new Object[this.size()];
            } else {
                throw new StructuredClassCastException(a.getClass());
            }
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(aa));
            return aa;
        }

        public void storeBoxingIntoArray(Slice<Object[]> var1);
    }

    public static interface DefaultToArraysIntegerCollection
    extends IntegerCollection {
        @Override
        default public Object[] toArray() {
            Object[] a = new Object[this.size()];
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
            return a;
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            Object[] aa;
            if (a.length >= this.size()) {
                this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
                return a;
            }
            if (a.getClass() == Integer[].class) {
                aa = new Integer[this.size()];
            } else if (a.getClass() == Object[].class) {
                aa = new Object[this.size()];
            } else {
                throw new StructuredClassCastException(a.getClass());
            }
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(aa));
            return aa;
        }

        public void storeBoxingIntoArray(Slice<Object[]> var1);
    }

    public static interface DefaultToArraysLongCollection
    extends LongCollection {
        @Override
        default public Object[] toArray() {
            Object[] a = new Object[this.size()];
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
            return a;
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            Object[] aa;
            if (a.length >= this.size()) {
                this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
                return a;
            }
            if (a.getClass() == Long[].class) {
                aa = new Long[this.size()];
            } else if (a.getClass() == Object[].class) {
                aa = new Object[this.size()];
            } else {
                throw new StructuredClassCastException(a.getClass());
            }
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(aa));
            return aa;
        }

        public void storeBoxingIntoArray(Slice<Object[]> var1);
    }

    public static interface DefaultToArraysShortCollection
    extends ShortCollection {
        @Override
        default public Object[] toArray() {
            Object[] a = new Object[this.size()];
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
            return a;
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            Object[] aa;
            if (a.length >= this.size()) {
                this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(a));
                return a;
            }
            if (a.getClass() == Short[].class) {
                aa = new Short[this.size()];
            } else if (a.getClass() == Object[].class) {
                aa = new Object[this.size()];
            } else {
                throw new StructuredClassCastException(a.getClass());
            }
            this.storeBoxingIntoArray(ArrayUtilities.wholeArraySliceReference(aa));
            return aa;
        }

        public void storeBoxingIntoArray(Slice<Object[]> var1);
    }

    public static class DoubleArrayList
    implements DefaultShiftingBasedDoubleList,
    ListWithSetSize<Double>,
    Trimmable,
    TransparentContiguousArrayBackedCollection<double[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected int size = 0;
        protected double[] data;
        protected Grower.GrowerComputationallyUnreducedPurelyRecursive grower;

        protected DoubleArrayList(Void thisiswhyyoushouldntusejavaconstructorsAlthoughIdontknowhowtomakeinheritanceworkwellwithoutinitmethodsorfactoriesorsomething) {
        }

        public DoubleArrayList(int initialCapacity, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = initialCapacity == 0 ? ArrayUtilities.EmptyDoubleArray : new double[initialCapacity];
            this.grower = grower;
        }

        public DoubleArrayList(@LiveValue @WritableValue double[] LIVEBACKING, int size, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = LIVEBACKING;
            this.grower = grower;
            this.size = size;
        }

        public DoubleArrayList(@SnapshotValue @ReadonlyValue Collection<Double> c, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this(c.size(), grower);
            this.addAll((Collection<? extends Double>)c);
        }

        public DoubleArrayList() {
            this(16);
        }

        public DoubleArrayList(int initialCapacity) {
            this(initialCapacity, PrimitiveCollections.defaultPrimitiveArrayListGrower(initialCapacity));
        }

        public DoubleArrayList(@SnapshotValue @ReadonlyValue Collection<Double> c) {
            this(c, PrimitiveCollections.defaultPrimitiveArrayListGrower(c.size()));
        }

        public DoubleArrayList(@LiveValue @WritableValue double[] LIVEBACKING, int size) {
            this(LIVEBACKING, size, PrimitiveCollections.defaultPrimitiveArrayListGrower(LIVEBACKING.length));
        }

        public DoubleArrayList(@LiveValue @WritableValue double[] LIVEBACKING) {
            this(LIVEBACKING, LIVEBACKING.length);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return false;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public void setSize(int newSize) {
            this.ensureCapacity(newSize);
            this.size = newSize;
        }

        protected void setupClone(DoubleArrayList freshClone) {
            freshClone.size = this.size;
            freshClone.data = new double[this.size];
            System.arraycopy(this.data, 0, freshClone.data, 0, this.size);
            freshClone.grower = this.grower;
        }

        @Override
        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        public DoubleArrayList clone() {
            DoubleArrayList clone = new DoubleArrayList();
            this.setupClone(clone);
            return clone;
        }

        @Override
        @ImplementationTransparency
        @LiveValue
        public Slice<double[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<double[]>(this.data, 0, this.size);
        }

        public void sort() {
            PrimitiveCollections.sortArray(this.data, 0, this.size);
        }

        @Override
        public void setDouble(int index, double value) {
            CollectionUtilities.rangeCheckMember(this.size, index);
            this.data[index] = value;
        }

        @Override
        public double getDouble(int index) {
            CollectionUtilities.rangeCheckMember(this.size(), index);
            return this.data[index];
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public void clear() {
            this.size = 0;
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public int size() {
            return this.size;
        }

        @ImplementationTransparency
        public void trimToSize() {
            double[] newdata = new double[this.size];
            System.arraycopy(this.data, 0, newdata, 0, this.size);
            this.data = newdata;
        }

        @Override
        public Trimmable.TrimmableTrimRV couldYouMaybeUseALittleLessMemoryIfYouDontMind() {
            this.trimToSize();
            return Trimmable.TrimmableTrimRV.DontKeepInvoking;
        }

        @ImplementationTransparency
        public int getCapacity() {
            return this.data.length;
        }

        @ImplementationTransparency
        public void ensureCapacity(int minCapacity) {
            if (this.data.length < minCapacity) {
                int newCapacity = this.getNewCapacity(minCapacity);
                double[] newData = new double[newCapacity];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
        }

        @Override
        public void clearHinting(int newCapacity) {
            this.clear();
            this.ensureCapacity(newCapacity);
        }

        @ImplementationTransparency
        public int getNewCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new IllegalArgumentException();
            }
            return Math.max(minCapacity, this.grower.getNewSizeRecursive(this.data.length));
        }

        @ImplementationTransparency
        public void setDirectBuffer(@LiveValue double[] array) {
            if (array.length < this.size) {
                throw new IllegalArgumentException("Array is too small; size=" + this.size + ", capacity=" + array.length);
            }
            this.data = array;
        }

        public String toString() {
            return this._toString();
        }
    }

    @SignalType
    public static interface DoubleCollection
    extends PrimitiveCollection<Double, double[]>,
    SimpleDoubleIterable {
        public boolean addDouble(double var1);

        public boolean removeDouble(double var1);

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class getPrimitiveType() {
            return Double.TYPE;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<Double> getBoxedType() {
            return Double.class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<double[]> getArrayType() {
            return double[].class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Double getDefaultElement() {
            return 0.0;
        }

        @ThrowAwayValue
        public static double[] defaultToDoubleArray(DoubleCollection collection) {
            double[] array = new double[collection.size()];
            SimpleDoubleIterator i = collection.newSimpleDoubleIterator();
            int index = 0;
            while (true) {
                try {
                    array[index] = i.nextrpDouble();
                }
                catch (StopIterationReturnPath exc) {
                    break;
                }
                ++index;
            }
            return array;
        }

        @ThrowAwayValue
        default public double[] toDoubleArray() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<double[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof double[]) {
                    return ArrayUtilities.sliceToNewDoubleArrayOP(u);
                }
            }
            return DoubleCollection.defaultToDoubleArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public double[] toDoubleArrayPossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                int size = this.size();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                Object und = u.getUnderlying();
                if (und instanceof double[] && u.getOffset() == 0 && ((double[])und).length == size) {
                    return (double[])und;
                }
            }
            return DoubleCollection.defaultToDoubleArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public Slice<double[]> toDoubleArraySlicePossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<double[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof double[]) {
                    return u;
                }
            }
            return ArrayUtilities.wholeArraySliceDouble(DoubleCollection.defaultToDoubleArray(this));
        }

        @LiveValue
        @Nullable
        default public Slice<double[]> toDoubleArraySliceLiveOrNull() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<double[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof double[]) {
                    return u;
                }
            }
            return null;
        }

        default public boolean containsDouble(double value) {
            SimpleDoubleIterator i = this.newSimpleDoubleIterator();
            try {
                while (!Primitives.eqSane(i.nextrpDouble(), value)) {
                }
                return true;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return false;
            }
        }

        @Override
        default public Iterator<Double> iterator() {
            return SimpleDoubleIterable.super.iterator();
        }

        @Override
        default public boolean isEmpty() {
            return this.size() == 0;
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllDoubles(double[] array) {
            return this.addAllDoubles(array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllDoubles(Slice<double[]> arraySlice) {
            return this.addAllDoubles(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllDoubles(double[] elements, int offset, int length) {
            return DoubleCollection.defaultAddAllDoubles(this, elements, offset, length);
        }

        public static boolean defaultAddAllDoubles(DoubleCollection self, double[] elements, int offset, int length) {
            boolean changedAtAll = false;
            int e = offset + length;
            int i = offset;
            while (i < e) {
                changedAtAll |= self.addDouble(elements[i]);
                ++i;
            }
            return changedAtAll;
        }

        default public void removeAllDoubles(double[] array) {
            this.removeAllDoubles(array, 0, array.length);
        }

        default public void removeAllDoubles(Slice<double[]> arraySlice) {
            this.removeAllDoubles(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public void removeAllDoubles(double[] a, int offset, int length) {
            int e = offset + length;
            int i = offset;
            while (i < e) {
                this.removeDouble(a[i]);
                ++i;
            }
        }

        @Override
        default public boolean contains(Object o) {
            return o instanceof Double && this.containsDouble((Double)o);
        }

        @Override
        default public boolean add(Double e) {
            return this.addDouble(e);
        }

        @Override
        default public boolean remove(Object o) {
            return o instanceof Double && this.removeDouble((Double)o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            if (c instanceof DoubleCollection) {
                DoubleCollection cc = (DoubleCollection)c;
                SimpleDoubleIterator i = cc.newSimpleDoubleIterator();
                try {
                    while (!this.containsDouble(i.nextrpDouble())) {
                    }
                    return true;
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return false;
                }
            }
            for (Object e : c) {
                if (!this.contains(e)) continue;
                return true;
            }
            return false;
        }

        @Override
        default public boolean addAll(Collection<? extends Double> c) {
            if (c instanceof DoubleCollection) {
                boolean changedAtAll = false;
                SimpleDoubleIterator simpleDoubleIterator = ((DoubleCollection)c).newSimpleDoubleIterator();
                try {
                    while (true) {
                        changedAtAll |= this.add(simpleDoubleIterator.nextrpDouble());
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Double d : c) {
                changedAtAll |= this.add(d);
            }
            return changedAtAll;
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            if (c instanceof DoubleCollection) {
                boolean changedAtAll = false;
                SimpleDoubleIterator i = ((DoubleCollection)c).newSimpleDoubleIterator();
                try {
                    while (true) {
                        changedAtAll |= this.remove(i.nextrpDouble());
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Object e : c) {
                changedAtAll |= this.remove(e);
            }
            return changedAtAll;
        }

        @Override
        default public void setFrom(Object source) {
            block8: {
                if (source == this) {
                    return;
                }
                if (source instanceof DoubleCollection) {
                    DoubleCollection s = (DoubleCollection)source;
                    this.clearHinting(s.size());
                    SimpleDoubleIterator i = s.newSimpleDoubleIterator();
                    while (true) {
                        double e;
                        try {
                            e = i.nextrpDouble();
                        }
                        catch (StopIterationReturnPath exc) {
                            break block8;
                        }
                        this.addDouble(e);
                    }
                }
                if (source instanceof Collection) {
                    Collection s = (Collection)source;
                    this.clearHinting(s.size());
                    for (Double e : s) {
                        this.addDouble(e);
                    }
                } else {
                    throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(source);
                }
            }
        }

        default public void clearHinting(int newCapacity) {
            this.clear();
        }

        @Override
        default public String _toString() {
            return PrimitiveCollections.defaultToString(this);
        }
    }

    @SignalType
    public static interface DoubleList
    extends PrimitiveList<Double, double[]>,
    NonuniformMethodsForDoubleList,
    DoubleListRO,
    DoubleListRWFixed {
        @Override
        default public Iterator<Double> iterator() {
            return NonuniformMethodsForDoubleList.super.iterator();
        }

        public void insertDouble(int var1, double var2);

        public DoubleList clone();

        public void setSizeDouble(int var1, double var2);

        @Override
        default public void setSize(int newSize, Double elementToAddIfGrowing) {
            this.setSizeDouble(newSize, elementToAddIfGrowing);
        }

        @Override
        default public void setSize(int newSize) {
            this.setSizeDouble(newSize, 0.0);
        }

        @Override
        default public void clear() {
            this.setSize(0);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllDoubles(int index, double[] array) {
            this.setAllDoubles(index, array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllDoubles(int index, Slice<double[]> arraySlice) {
            this.setAllDoubles(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        default public void setAllDoubles(int start, double[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof double[]) {
                    Slice s = u;
                    System.arraycopy(array, offset, s.getUnderlying(), s.getOffset() + start, length);
                    return;
                }
            }
            DoubleList.defaultSetAllDoubles(this, start, array, offset, length);
        }

        public static void defaultSetAllDoubles(DoubleList list, int start, @WritableValue double[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                list.setDouble(start + i, array[offset + i]);
                ++i;
            }
        }

        default public void setAll(int destIndex, List sourceU, int sourceIndex, @Nonnegative int amount) throws IndexOutOfBoundsException {
            List source = sourceU;
            DoubleList dest = this;
            int sourceSize = source.size();
            int destSize = dest.size();
            CollectionUtilities.rangeCheckIntervalByLength(sourceSize, sourceIndex, amount);
            CollectionUtilities.rangeCheckIntervalByLength(destSize, destIndex, amount);
            if (TransparentContiguousArrayBackedCollection.is(source)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)source)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(sourceSize, u);
                if (u.getUnderlying() instanceof double[]) {
                    Slice s = u;
                    this.setAllDoubles(destIndex, (Slice)s.subslice(sourceIndex, amount));
                    return;
                }
            }
            if (source instanceof DoubleList) {
                DoubleList primSource = (DoubleList)source;
                if (destIndex < sourceIndex) {
                    int i = 0;
                    while (i < amount) {
                        dest.setDouble(destIndex + i, primSource.getDouble(sourceIndex + i));
                        ++i;
                    }
                } else {
                    int i = amount - 1;
                    while (i >= 0) {
                        dest.setDouble(destIndex + i, primSource.getDouble(sourceIndex + i));
                        --i;
                    }
                }
            } else if (destIndex < sourceIndex) {
                int i = 0;
                while (i < amount) {
                    dest.set(destIndex + i, (Double)source.get(sourceIndex + i));
                    ++i;
                }
            } else {
                int i = amount - 1;
                while (i >= 0) {
                    dest.set(destIndex + i, (Double)source.get(sourceIndex + i));
                    --i;
                }
            }
        }

        default public void getAllDoubles(int start, @WritableValue double[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof double[]) {
                    Slice s = u;
                    System.arraycopy(s.getUnderlying(), s.getOffset() + start, array, offset, length);
                    return;
                }
            }
            DoubleList.defaultGetAllDoubles(this, start, array, offset, length);
        }

        public static void defaultGetAllDoubles(DoubleList list, int start, @WritableValue double[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                array[offset + i] = list.getDouble(start + i);
                ++i;
            }
        }

        @ThrowAwayValue
        default public double[] getAllDoubles(int start, int end) {
            CollectionUtilities.rangeCheckInterval(this.size(), start, end);
            double[] buff = new double[end - start];
            this.getAllDoubles(start, buff, 0, buff.length);
            return buff;
        }

        @Override
        default public boolean addDouble(double value) {
            this.insertDouble(this.size(), value);
            return true;
        }

        @Override
        default public boolean addAll(Collection<? extends Double> c) {
            this.addAll(this.size(), c);
            return true;
        }

        @Override
        default public boolean addAllDoubles(double[] elements, int offset, int length) {
            this.insertAllDoubles(this.size(), elements, offset, length);
            return true;
        }

        default public void removeByIndex(int index) {
            this.removeRange(index, index + 1);
        }

        default public double removeDoubleByIndex(int index) throws IndexOutOfBoundsException {
            double v = this.getDouble(index);
            this.removeByIndex(index);
            return v;
        }

        @Override
        default public boolean removeDouble(double value) {
            int i = this.indexOfDouble(value);
            if (i != -1) {
                this.removeByIndex(i);
                return true;
            }
            return false;
        }

        @Override
        default public boolean retainAll(Collection<?> c) {
            if (c instanceof DoubleCollection) {
                DoubleCollection cc = (DoubleCollection)c;
                boolean changedAtAll = false;
                int i = this.size() - 1;
                while (i >= 0) {
                    if (!cc.containsDouble(this.getDouble(i))) {
                        this.removeDoubleByIndex(i);
                        changedAtAll = true;
                    }
                    --i;
                }
                return changedAtAll;
            }
            boolean changedAtAll = false;
            int i = this.size() - 1;
            while (i >= 0) {
                if (!c.contains(this.getDouble(i))) {
                    this.removeDoubleByIndex(i);
                    changedAtAll = true;
                }
                --i;
            }
            return changedAtAll;
        }

        @Override
        default public SimpleDoubleIterator newSimpleDoubleIterator() {
            return new SimpleDoubleIterator(){
                int index = 0;

                @Override
                public double nextrpDouble() throws StopIterationReturnPath {
                    int i = this.index;
                    if (i >= this.size()) {
                        throw StopIterationReturnPath.I;
                    }
                    this.index = i + 1;
                    return this.getDouble(i);
                }
            };
        }

        @Override
        default public boolean containsDouble(double value) {
            return this.indexOfDouble(value) != -1;
        }

        default public void insertAllDoubles(int index, double[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                this.insertDouble(index + i, array[offset + i]);
                ++i;
            }
        }

        @Override
        default public boolean addAll(int index, Collection<? extends Double> c) {
            if (c instanceof DoubleCollection) {
                DoubleCollection doubleCollection = (DoubleCollection)c;
                SimpleDoubleIterator i = doubleCollection.newSimpleDoubleIterator();
                try {
                    while (true) {
                        this.insertDouble(index, i.nextrpDouble());
                        ++index;
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {}
            } else {
                for (Double d : c) {
                    this.insertDouble(index, d);
                    ++index;
                }
            }
            return true;
        }

        default public void insertAllDoubles(int index, double[] array) {
            this.insertAllDoubles(index, array, 0, array.length);
        }

        default public void insertAllDoubles(int index, Slice<double[]> arraySlice) {
            this.insertAllDoubles(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @Override
        default public Double get(int index) {
            return this.getDouble(index);
        }

        @Override
        default public Double set(int index, Double value) {
            Double previous = this.get(index);
            this.setDouble(index, value);
            return previous;
        }

        @Override
        default public void add(int index, Double value) {
            this.insertDouble(index, value);
        }

        @Override
        default public Double remove(int index) throws IndexOutOfBoundsException {
            return this.removeDoubleByIndex(index);
        }

        @Override
        default public int indexOf(Object o) {
            return o instanceof Double ? this.indexOfDouble((Double)o) : -1;
        }

        @Override
        default public int lastIndexOf(Object o) {
            return o instanceof Double ? this.lastIndexOfDouble((Double)o) : -1;
        }

        default public int indexOf(Object o, int start) {
            return o instanceof Double ? this.indexOfDouble((Double)o, start) : -1;
        }

        default public int lastIndexOf(Object o, int start) {
            return o instanceof Double ? this.lastIndexOfDouble((Double)o, start) : -1;
        }

        @Override
        default public ListIterator<Double> listIterator() {
            return this.listIterator(0);
        }

        @Override
        default public ListIterator<Double> listIterator(int index) {
            return new DelegatingListIterator<Double>(this, index);
        }

        default public DoubleList subList(int fromIndex, int toIndex) {
            if (fromIndex == 0 && toIndex == this.size()) {
                return this;
            }
            if (this instanceof Sublist) {
                Sublist s = (Sublist)((Object)this);
                return new DoubleSublist((DoubleList)s.getUnderlying(), s.getSublistStartingIndex() + fromIndex, toIndex - fromIndex);
            }
            return new DoubleSublist(this, fromIndex, toIndex - fromIndex);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForDoubleList.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForDoubleList.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForDoubleList.super.containsAll(c);
        }

        @Override
        default public boolean add(Double e) {
            return NonuniformMethodsForDoubleList.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForDoubleList.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForDoubleList.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveList.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForDoubleList.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForDoubleList.super.toArray(a);
        }

        @Override
        default public void storeBoxingIntoArray(Slice<Object[]> array) {
            int n = this.size();
            int i = 0;
            while (i < n) {
                ArrayUtilities.setReference(array, i, this.get(i));
                ++i;
            }
        }

        default public boolean endsWith(List<Double> suffixCandidate) {
            return this.size() >= suffixCandidate.size() && this.subListToEnd(suffixCandidate.size()).equivalent(suffixCandidate);
        }

        default public boolean startsWith(List<Double> prefixCandidate) {
            return this.size() >= prefixCandidate.size() && this.subListFromBeginning(prefixCandidate.size()).equivalent(prefixCandidate);
        }

        default public DoubleList subListToEnd(int start) {
            return (DoubleList)PrimitiveList.super.subListToEnd(start);
        }

        default public DoubleList subListFromBeginning(int lengthWhichIsEndExclusiveInThisCaseXD) {
            return (DoubleList)PrimitiveList.super.subListFromBeginning(lengthWhichIsEndExclusiveInThisCaseXD);
        }

        default public DoubleList subListByLength(int start, int length) {
            return (DoubleList)PrimitiveList.super.subListByLength(start, length);
        }

        @Override
        default public void fillBySetting(int start, int count, Double value) {
            this.fillBySettingDouble(start, count, value);
        }

        default public void fillBySettingDouble(double value) {
            this.fillBySettingDouble(0, this.size(), value);
        }

        default public void fillBySettingDouble(int start, int count, double value) {
            CollectionUtilities.rangeCheckIntervalByLength(this.size(), start, count);
            if (count >= 100) {
                double[] array = new double[SmallIntegerMathUtilities.least(count, 1024)];
                if (value != 0.0) {
                    Arrays.fill(array, value);
                }
                int al = array.length;
                DoubleList l = PrimitiveCollections.doubleArrayAsList(array);
                while (count > al) {
                    this.setAll(start, l);
                    start += al;
                    count -= al;
                }
                if (count > 0) {
                    this.setAll(start, l.subList(0, count));
                }
            } else {
                int e = start + count;
                int i = start;
                while (i < e) {
                    this.setDouble(i, value);
                    ++i;
                }
            }
        }
    }

    @SignalType
    public static interface DoubleListRO
    extends Equivalenceable {
        public double getDouble(int var1);

        public int size();

        default public int indexOfDouble(double value) {
            return this.indexOfDouble(value, 0);
        }

        default public int lastIndexOfDouble(double value) {
            return this.lastIndexOfDouble(value, this.size() - 1);
        }

        default public int indexOfDouble(double value, int start) {
            int n = this.size();
            int i = start;
            while (i < n) {
                if (Primitives.eqSane(this.getDouble(i), value)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        default public int lastIndexOfDouble(double value, int start) {
            int i = start;
            if (i >= 0 && Primitives.eqSane(this.getDouble(i), value)) {
                return i;
            }
            return i;
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof DoubleListRO) {
                return this.equivalentFixedRO((DoubleListRO)o);
            }
            if (o instanceof List) {
                List other = (List)o;
                int size = this.size();
                if (other.size() != size) {
                    return false;
                }
                int i = 0;
                while (i < size) {
                    Object e = other.get(i);
                    if (e instanceof Double) {
                        if (!Primitives.eqSane(this.getDouble(i), (double)((Double)e))) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalentFixedRO(DoubleListRO other) {
            int size = this.size();
            if (other.size() != size) {
                return false;
            }
            int i = 0;
            while (i < size) {
                if (!Primitives.eqSane(this.getDouble(i), other.getDouble(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            int size = this.size();
            int i = 0;
            while (i < size) {
                double e = this.getDouble(i);
                r = 31 * r + Primitives.hashprim(e);
                ++i;
            }
            return r;
        }
    }

    @SignalType
    public static interface DoubleListRWFixed
    extends DoubleListRO {
        public void setDouble(int var1, double var2);
    }

    public static class DoubleListWrapper
    implements DoubleList {
        protected final List<Double> underlying;

        public DoubleListWrapper(List<Double> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithRemoveRange) {
                ((ListWithRemoveRange)((Object)this.underlying)).removeRange(start, pastEnd);
            } else {
                DoubleList.super.removeRange(start, pastEnd);
            }
        }

        @Override
        public void setSize(int newSize, Double elementToAddIfGrowing) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize, elementToAddIfGrowing);
            } else {
                DoubleList.super.setSize(newSize, elementToAddIfGrowing);
            }
        }

        @Override
        public void setSize(int newSize) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize);
            } else {
                DoubleList.super.setSize(newSize);
            }
        }

        @Override
        public void setAll(int destIndex, List source, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithSetAll) {
                ((ListWithSetAll)((Object)this.underlying)).setAll(destIndex, source, sourceIndex, amount);
            } else {
                DoubleList.super.setAll(destIndex, source, sourceIndex, amount);
            }
        }

        @Override
        public void fillBySetting(int start, int count, Double value) {
            if (this.underlying instanceof ListWithFill) {
                ((ListWithFill)this.underlying).fillBySetting(start, count, value);
            } else {
                DoubleList.super.fillBySetting(start, count, value);
            }
        }

        @Override
        public DoubleList clone() {
            return PrimitiveCollections.asDoubleList(ObjectUtilities.attemptClone(this.underlying));
        }

        @Override
        public double getDouble(int index) {
            return this.get(index);
        }

        @Override
        public void setDouble(int index, double value) {
            this.set(index, value);
        }

        @Override
        public void insertDouble(int index, double value) {
            this.add(index, value);
        }

        @Override
        public void setSizeDouble(int newSize, double elementToAddIfGrowing) {
            this.setSize(newSize, elementToAddIfGrowing);
        }

        @Override
        public void forEach(Consumer<? super Double> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Double e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Double> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Double> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Double> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Double> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Double> c) {
            this.underlying.sort(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public Double get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Double set(int index, Double element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Double element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Double> stream() {
            return this.underlying.stream();
        }

        @Override
        public Double remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Double> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public Spliterator<Double> spliterator() {
            return this.underlying.spliterator();
        }
    }

    @SignalType
    public static interface DoubleSet
    extends PrimitiveSet<Double, double[]>,
    NonuniformMethodsForDoubleSet {
        @Override
        default public Iterator<Double> iterator() {
            return NonuniformMethodsForDoubleSet.super.iterator();
        }

        @Override
        default public boolean addAll(Collection<? extends Double> c) {
            return NonuniformMethodsForDoubleSet.super.addAll(c);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForDoubleSet.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForDoubleSet.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForDoubleSet.super.containsAll(c);
        }

        @Override
        default public boolean add(Double e) {
            return NonuniformMethodsForDoubleSet.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForDoubleSet.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForDoubleSet.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveSet.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForDoubleSet.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForDoubleSet.super.toArray(a);
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof DoubleSet) {
                return this.equivalent((DoubleSet)o);
            }
            if (o instanceof Set) {
                int bs;
                Set a = (Set)o;
                DoubleSet b = this;
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                int as = a.size();
                if (as != (bs = b.size())) {
                    return false;
                }
                if (CodeHinting.arbitrary(as, bs) == 0) {
                    return true;
                }
                for (Object an : a) {
                    if (an instanceof Double) {
                        if (b.containsDouble((Double)an)) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalent(DoubleSet other) {
            int bs;
            DoubleSet a = this;
            DoubleSet b = other;
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            int as = a.size();
            if (as != (bs = b.size())) {
                return false;
            }
            if (CodeHinting.arbitrary(as, bs) == 0) {
                return true;
            }
            SimpleDoubleIterator i = a.newSimpleDoubleIterator();
            try {
                while (b.containsDouble(i.nextrpDouble())) {
                }
                return false;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return true;
            }
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            SimpleDoubleIterator i = this.newSimpleDoubleIterator();
            try {
                while (true) {
                    r += Primitives.hashprim(i.nextrpDouble());
                }
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return r;
            }
        }
    }

    public static class DoubleSublist
    implements DoubleList,
    DefaultShiftingBasedDoubleList,
    Sublist<Double>,
    ShiftableList {
        protected final DoubleList underlying;
        protected final int start;
        protected int size;

        public DoubleSublist(DoubleList underlying, int start, int initialSize) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.size(), start, initialSize);
            this.underlying = underlying;
            this.start = start;
            this.size = initialSize;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public double getDouble(int index) {
            return this.underlying.getDouble(index + this.start);
        }

        @Override
        public void setDouble(int index, double value) {
            this.underlying.setDouble(index + this.start, value);
        }

        @Override
        public void shiftRegionStretchingFromIndexToEndByAmountChangingSize(int start, int amount) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), start);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this.underlying, start, amount);
            this.size += amount;
        }

        @Override
        public DoubleList clone() {
            DoubleArrayList c = new DoubleArrayList();
            c.addAll(this);
            return c;
        }

        @Override
        public DoubleList getUnderlying() {
            return this.underlying;
        }

        @Override
        public int getSublistStartingIndex() {
            return this.start;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public Boolean isWritableCollection() {
            return this.underlying.isWritableCollection();
        }
    }

    public static class DoubleTable {
        protected int width;
        protected double[] data;

        public DoubleTable(int width, int height) {
            if (width < 0) {
                throw new IllegalArgumentException();
            }
            if (height < 0) {
                throw new IllegalArgumentException();
            }
            this.data = new double[width * height];
        }

        @Nonnegative
        public int getNumberOfColumns() {
            return this.width;
        }

        @Nonnegative
        public int getNumberOfRows() {
            return this.data.length / this.width;
        }

        @Nonnegative
        public int getNumberOfCells() {
            return this.data.length;
        }

        public double getCellContentsDouble(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            return this.data[rowIndex * this.getNumberOfColumns() + columnIndex];
        }

        public void setCellContentsDouble(int columnIndex, int rowIndex, @Nullable double newValue) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            this.data[rowIndex * this.getNumberOfColumns() + columnIndex] = newValue;
        }

        @Nullable
        public Double getCellContents(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            return this.getCellContentsDouble(columnIndex, rowIndex);
        }

        public void setCellContents(int columnIndex, int rowIndex, @Nullable Double newValue) throws IndexOutOfBoundsException {
            this.setCellContentsDouble(columnIndex, rowIndex, newValue);
        }
    }

    public static class FixedLengthArrayWrapperBooleanList
    implements BooleanList,
    TransparentContiguousArrayBackedCollection<boolean[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final boolean[] underlying;
        protected final int offset;
        protected final int length;

        public FixedLengthArrayWrapperBooleanList(boolean[] underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.length, offset, length);
            this.underlying = underlying;
            this.offset = offset;
            this.length = length;
        }

        public FixedLengthArrayWrapperBooleanList(boolean[] underlying) {
            this.underlying = underlying;
            this.offset = 0;
            this.length = underlying.length;
        }

        public FixedLengthArrayWrapperBooleanList(Slice<boolean[]> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public BooleanList clone() {
            return new FixedLengthArrayWrapperBooleanList(this.toBooleanArray());
        }

        @Override
        public boolean[] toBooleanArray() {
            return ArrayUtilities.sliceToNewBooleanArrayOP(this.getLiveContiguousArrayBackingUNSAFE());
        }

        @Override
        public Slice<boolean[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<boolean[]>(this.underlying, this.offset, this.length);
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public BooleanList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthArrayWrapperBooleanList(this.underlying, fromIndex + this.offset, toIndex - fromIndex);
        }

        @Override
        public boolean getBoolean(int index) {
            return this.underlying[this.offset + index];
        }

        @Override
        public void setBoolean(int index, boolean value) {
            this.underlying[this.offset + index] = value;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeBoolean(int newSize, boolean elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertBoolean(int index, boolean value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthArrayWrapperByteList
    implements ByteList,
    TransparentContiguousArrayBackedCollection<byte[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final byte[] underlying;
        protected final int offset;
        protected final int length;

        public FixedLengthArrayWrapperByteList(byte[] underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.length, offset, length);
            this.underlying = underlying;
            this.offset = offset;
            this.length = length;
        }

        public FixedLengthArrayWrapperByteList(byte[] underlying) {
            this.underlying = underlying;
            this.offset = 0;
            this.length = underlying.length;
        }

        public FixedLengthArrayWrapperByteList(Slice<byte[]> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public ByteList clone() {
            return new FixedLengthArrayWrapperByteList(this.toByteArray());
        }

        @Override
        public byte[] toByteArray() {
            return ArrayUtilities.sliceToNewByteArrayOP(this.getLiveContiguousArrayBackingUNSAFE());
        }

        @Override
        public Slice<byte[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<byte[]>(this.underlying, this.offset, this.length);
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public ByteList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthArrayWrapperByteList(this.underlying, fromIndex + this.offset, toIndex - fromIndex);
        }

        @Override
        public byte getByte(int index) {
            return this.underlying[this.offset + index];
        }

        @Override
        public void setByte(int index, byte value) {
            this.underlying[this.offset + index] = value;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeByte(int newSize, byte elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertByte(int index, byte value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthArrayWrapperCharacterList
    implements CharacterList,
    TransparentContiguousArrayBackedCollection<char[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final char[] underlying;
        protected final int offset;
        protected final int length;

        public FixedLengthArrayWrapperCharacterList(char[] underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.length, offset, length);
            this.underlying = underlying;
            this.offset = offset;
            this.length = length;
        }

        public FixedLengthArrayWrapperCharacterList(char[] underlying) {
            this.underlying = underlying;
            this.offset = 0;
            this.length = underlying.length;
        }

        public FixedLengthArrayWrapperCharacterList(Slice<char[]> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public CharacterList clone() {
            return new FixedLengthArrayWrapperCharacterList(this.toCharArray());
        }

        @Override
        public char[] toCharArray() {
            return ArrayUtilities.sliceToNewCharArrayOP(this.getLiveContiguousArrayBackingUNSAFE());
        }

        @Override
        public Slice<char[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<char[]>(this.underlying, this.offset, this.length);
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public CharacterList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthArrayWrapperCharacterList(this.underlying, fromIndex + this.offset, toIndex - fromIndex);
        }

        @Override
        public char getChar(int index) {
            return this.underlying[this.offset + index];
        }

        @Override
        public void setChar(int index, char value) {
            this.underlying[this.offset + index] = value;
        }

        @Override
        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeChar(int newSize, char elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertChar(int index, char value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthArrayWrapperDoubleList
    implements DoubleList,
    TransparentContiguousArrayBackedCollection<double[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final double[] underlying;
        protected final int offset;
        protected final int length;

        public FixedLengthArrayWrapperDoubleList(double[] underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.length, offset, length);
            this.underlying = underlying;
            this.offset = offset;
            this.length = length;
        }

        public FixedLengthArrayWrapperDoubleList(double[] underlying) {
            this.underlying = underlying;
            this.offset = 0;
            this.length = underlying.length;
        }

        public FixedLengthArrayWrapperDoubleList(Slice<double[]> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public DoubleList clone() {
            return new FixedLengthArrayWrapperDoubleList(this.toDoubleArray());
        }

        @Override
        public double[] toDoubleArray() {
            return ArrayUtilities.sliceToNewDoubleArrayOP(this.getLiveContiguousArrayBackingUNSAFE());
        }

        @Override
        public Slice<double[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<double[]>(this.underlying, this.offset, this.length);
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public DoubleList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthArrayWrapperDoubleList(this.underlying, fromIndex + this.offset, toIndex - fromIndex);
        }

        @Override
        public double getDouble(int index) {
            return this.underlying[this.offset + index];
        }

        @Override
        public void setDouble(int index, double value) {
            this.underlying[this.offset + index] = value;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeDouble(int newSize, double elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertDouble(int index, double value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthArrayWrapperFloatList
    implements FloatList,
    TransparentContiguousArrayBackedCollection<float[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final float[] underlying;
        protected final int offset;
        protected final int length;

        public FixedLengthArrayWrapperFloatList(float[] underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.length, offset, length);
            this.underlying = underlying;
            this.offset = offset;
            this.length = length;
        }

        public FixedLengthArrayWrapperFloatList(float[] underlying) {
            this.underlying = underlying;
            this.offset = 0;
            this.length = underlying.length;
        }

        public FixedLengthArrayWrapperFloatList(Slice<float[]> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public FloatList clone() {
            return new FixedLengthArrayWrapperFloatList(this.toFloatArray());
        }

        @Override
        public float[] toFloatArray() {
            return ArrayUtilities.sliceToNewFloatArrayOP(this.getLiveContiguousArrayBackingUNSAFE());
        }

        @Override
        public Slice<float[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<float[]>(this.underlying, this.offset, this.length);
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public FloatList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthArrayWrapperFloatList(this.underlying, fromIndex + this.offset, toIndex - fromIndex);
        }

        @Override
        public float getFloat(int index) {
            return this.underlying[this.offset + index];
        }

        @Override
        public void setFloat(int index, float value) {
            this.underlying[this.offset + index] = value;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeFloat(int newSize, float elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertFloat(int index, float value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthArrayWrapperIntegerList
    implements IntegerList,
    TransparentContiguousArrayBackedCollection<int[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final int[] underlying;
        protected final int offset;
        protected final int length;

        public FixedLengthArrayWrapperIntegerList(int[] underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.length, offset, length);
            this.underlying = underlying;
            this.offset = offset;
            this.length = length;
        }

        public FixedLengthArrayWrapperIntegerList(int[] underlying) {
            this.underlying = underlying;
            this.offset = 0;
            this.length = underlying.length;
        }

        public FixedLengthArrayWrapperIntegerList(Slice<int[]> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public IntegerList clone() {
            return new FixedLengthArrayWrapperIntegerList(this.toIntArray());
        }

        @Override
        public int[] toIntArray() {
            return ArrayUtilities.sliceToNewIntArrayOP(this.getLiveContiguousArrayBackingUNSAFE());
        }

        @Override
        public Slice<int[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<int[]>(this.underlying, this.offset, this.length);
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public IntegerList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthArrayWrapperIntegerList(this.underlying, fromIndex + this.offset, toIndex - fromIndex);
        }

        @Override
        public int getInt(int index) {
            return this.underlying[this.offset + index];
        }

        @Override
        public void setInt(int index, int value) {
            this.underlying[this.offset + index] = value;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeInt(int newSize, int elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertInt(int index, int value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthArrayWrapperLongList
    implements LongList,
    TransparentContiguousArrayBackedCollection<long[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final long[] underlying;
        protected final int offset;
        protected final int length;

        public FixedLengthArrayWrapperLongList(long[] underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.length, offset, length);
            this.underlying = underlying;
            this.offset = offset;
            this.length = length;
        }

        public FixedLengthArrayWrapperLongList(long[] underlying) {
            this.underlying = underlying;
            this.offset = 0;
            this.length = underlying.length;
        }

        public FixedLengthArrayWrapperLongList(Slice<long[]> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public LongList clone() {
            return new FixedLengthArrayWrapperLongList(this.toLongArray());
        }

        @Override
        public long[] toLongArray() {
            return ArrayUtilities.sliceToNewLongArrayOP(this.getLiveContiguousArrayBackingUNSAFE());
        }

        @Override
        public Slice<long[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<long[]>(this.underlying, this.offset, this.length);
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public LongList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthArrayWrapperLongList(this.underlying, fromIndex + this.offset, toIndex - fromIndex);
        }

        @Override
        public long getLong(int index) {
            return this.underlying[this.offset + index];
        }

        @Override
        public void setLong(int index, long value) {
            this.underlying[this.offset + index] = value;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeLong(int newSize, long elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertLong(int index, long value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthArrayWrapperShortList
    implements ShortList,
    TransparentContiguousArrayBackedCollection<short[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final short[] underlying;
        protected final int offset;
        protected final int length;

        public FixedLengthArrayWrapperShortList(short[] underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.length, offset, length);
            this.underlying = underlying;
            this.offset = offset;
            this.length = length;
        }

        public FixedLengthArrayWrapperShortList(short[] underlying) {
            this.underlying = underlying;
            this.offset = 0;
            this.length = underlying.length;
        }

        public FixedLengthArrayWrapperShortList(Slice<short[]> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public ShortList clone() {
            return new FixedLengthArrayWrapperShortList(this.toShortArray());
        }

        @Override
        public short[] toShortArray() {
            return ArrayUtilities.sliceToNewShortArrayOP(this.getLiveContiguousArrayBackingUNSAFE());
        }

        @Override
        public Slice<short[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<short[]>(this.underlying, this.offset, this.length);
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public ShortList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthArrayWrapperShortList(this.underlying, fromIndex + this.offset, toIndex - fromIndex);
        }

        @Override
        public short getShort(int index) {
            return this.underlying[this.offset + index];
        }

        @Override
        public void setShort(int index, short value) {
            this.underlying[this.offset + index] = value;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeShort(int newSize, short elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertShort(int index, short value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthBufferWrapperByteList
    implements ByteList,
    TransparentContiguousArrayBackedCollection<ByteBuffer>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final ByteBuffer underlying;

        public FixedLengthBufferWrapperByteList(@SnapshotValue @LiveValue ByteBuffer underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.remaining(), offset, length);
            this.underlying = NIOBufferUtilities.sliceAbsoluteNonmodifying(underlying, offset, length);
        }

        public FixedLengthBufferWrapperByteList(@SnapshotValue @LiveValue ByteBuffer underlying) {
            this.underlying = NIOBufferUtilities.sliceNonmodifying(underlying);
        }

        public FixedLengthBufferWrapperByteList(@SnapshotValue @LiveValue Slice<ByteBuffer> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public ByteList clone() {
            return new FixedLengthArrayWrapperByteList(this.toByteArray());
        }

        @Override
        public byte[] toByteArray() {
            return NIOBufferUtilities.copyToNewArray(this.underlying);
        }

        @Override
        public byte[] toByteArrayPossiblyLive() {
            return NIOBufferUtilities.getArray(this.underlying);
        }

        @Override
        public Slice<byte[]> toByteArraySlicePossiblyLive() {
            return NIOBufferUtilities.getUnderlyingArrayOrCopyIfDirect(this.underlying);
        }

        @Override
        public Slice<ByteBuffer> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<ByteBuffer>(this.underlying, 0, this.size());
        }

        @Override
        public int size() {
            return this.underlying.remaining();
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return !this.underlying.isReadOnly();
        }

        @Override
        public ByteList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthBufferWrapperByteList(this.underlying, fromIndex, toIndex - fromIndex);
        }

        @Override
        public byte getByte(int index) {
            return this.underlying.get(index);
        }

        @Override
        public void setByte(int index, byte value) {
            this.underlying.put(index, value);
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeByte(int newSize, byte elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertByte(int index, byte value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthBufferWrapperCharacterList
    implements CharacterList,
    TransparentContiguousArrayBackedCollection<CharBuffer>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final CharBuffer underlying;

        public FixedLengthBufferWrapperCharacterList(@SnapshotValue @LiveValue CharBuffer underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.remaining(), offset, length);
            this.underlying = NIOBufferUtilities.sliceAbsoluteNonmodifying(underlying, offset, length);
        }

        public FixedLengthBufferWrapperCharacterList(@SnapshotValue @LiveValue CharBuffer underlying) {
            this.underlying = NIOBufferUtilities.sliceNonmodifying(underlying);
        }

        public FixedLengthBufferWrapperCharacterList(@SnapshotValue @LiveValue Slice<CharBuffer> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public CharacterList clone() {
            return new FixedLengthArrayWrapperCharacterList(this.toCharArray());
        }

        @Override
        public char[] toCharArray() {
            return NIOBufferUtilities.copyToNewArray(this.underlying);
        }

        @Override
        public char[] toCharArrayPossiblyLive() {
            return NIOBufferUtilities.getArray(this.underlying);
        }

        @Override
        public Slice<char[]> toCharArraySlicePossiblyLive() {
            return NIOBufferUtilities.getUnderlyingArrayOrCopyIfDirect(this.underlying);
        }

        @Override
        public Slice<CharBuffer> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<CharBuffer>(this.underlying, 0, this.size());
        }

        @Override
        public int size() {
            return this.underlying.remaining();
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return !this.underlying.isReadOnly();
        }

        @Override
        public CharacterList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthBufferWrapperCharacterList(this.underlying, fromIndex, toIndex - fromIndex);
        }

        @Override
        public char getChar(int index) {
            return this.underlying.get(index);
        }

        @Override
        public void setChar(int index, char value) {
            this.underlying.put(index, value);
        }

        @Override
        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeChar(int newSize, char elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertChar(int index, char value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthBufferWrapperDoubleList
    implements DoubleList,
    TransparentContiguousArrayBackedCollection<DoubleBuffer>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final DoubleBuffer underlying;

        public FixedLengthBufferWrapperDoubleList(@SnapshotValue @LiveValue DoubleBuffer underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.remaining(), offset, length);
            this.underlying = NIOBufferUtilities.sliceAbsoluteNonmodifying(underlying, offset, length);
        }

        public FixedLengthBufferWrapperDoubleList(@SnapshotValue @LiveValue DoubleBuffer underlying) {
            this.underlying = NIOBufferUtilities.sliceNonmodifying(underlying);
        }

        public FixedLengthBufferWrapperDoubleList(@SnapshotValue @LiveValue Slice<DoubleBuffer> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public DoubleList clone() {
            return new FixedLengthArrayWrapperDoubleList(this.toDoubleArray());
        }

        @Override
        public double[] toDoubleArray() {
            return NIOBufferUtilities.copyToNewArray(this.underlying);
        }

        @Override
        public double[] toDoubleArrayPossiblyLive() {
            return NIOBufferUtilities.getArray(this.underlying);
        }

        @Override
        public Slice<double[]> toDoubleArraySlicePossiblyLive() {
            return NIOBufferUtilities.getUnderlyingArrayOrCopyIfDirect(this.underlying);
        }

        @Override
        public Slice<DoubleBuffer> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<DoubleBuffer>(this.underlying, 0, this.size());
        }

        @Override
        public int size() {
            return this.underlying.remaining();
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return !this.underlying.isReadOnly();
        }

        @Override
        public DoubleList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthBufferWrapperDoubleList(this.underlying, fromIndex, toIndex - fromIndex);
        }

        @Override
        public double getDouble(int index) {
            return this.underlying.get(index);
        }

        @Override
        public void setDouble(int index, double value) {
            this.underlying.put(index, value);
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeDouble(int newSize, double elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertDouble(int index, double value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthBufferWrapperFloatList
    implements FloatList,
    TransparentContiguousArrayBackedCollection<FloatBuffer>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final FloatBuffer underlying;

        public FixedLengthBufferWrapperFloatList(@SnapshotValue @LiveValue FloatBuffer underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.remaining(), offset, length);
            this.underlying = NIOBufferUtilities.sliceAbsoluteNonmodifying(underlying, offset, length);
        }

        public FixedLengthBufferWrapperFloatList(@SnapshotValue @LiveValue FloatBuffer underlying) {
            this.underlying = NIOBufferUtilities.sliceNonmodifying(underlying);
        }

        public FixedLengthBufferWrapperFloatList(@SnapshotValue @LiveValue Slice<FloatBuffer> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public FloatList clone() {
            return new FixedLengthArrayWrapperFloatList(this.toFloatArray());
        }

        @Override
        public float[] toFloatArray() {
            return NIOBufferUtilities.copyToNewArray(this.underlying);
        }

        @Override
        public float[] toFloatArrayPossiblyLive() {
            return NIOBufferUtilities.getArray(this.underlying);
        }

        @Override
        public Slice<float[]> toFloatArraySlicePossiblyLive() {
            return NIOBufferUtilities.getUnderlyingArrayOrCopyIfDirect(this.underlying);
        }

        @Override
        public Slice<FloatBuffer> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<FloatBuffer>(this.underlying, 0, this.size());
        }

        @Override
        public int size() {
            return this.underlying.remaining();
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return !this.underlying.isReadOnly();
        }

        @Override
        public FloatList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthBufferWrapperFloatList(this.underlying, fromIndex, toIndex - fromIndex);
        }

        @Override
        public float getFloat(int index) {
            return this.underlying.get(index);
        }

        @Override
        public void setFloat(int index, float value) {
            this.underlying.put(index, value);
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeFloat(int newSize, float elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertFloat(int index, float value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthBufferWrapperIntegerList
    implements IntegerList,
    TransparentContiguousArrayBackedCollection<IntBuffer>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final IntBuffer underlying;

        public FixedLengthBufferWrapperIntegerList(@SnapshotValue @LiveValue IntBuffer underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.remaining(), offset, length);
            this.underlying = NIOBufferUtilities.sliceAbsoluteNonmodifying(underlying, offset, length);
        }

        public FixedLengthBufferWrapperIntegerList(@SnapshotValue @LiveValue IntBuffer underlying) {
            this.underlying = NIOBufferUtilities.sliceNonmodifying(underlying);
        }

        public FixedLengthBufferWrapperIntegerList(@SnapshotValue @LiveValue Slice<IntBuffer> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public IntegerList clone() {
            return new FixedLengthArrayWrapperIntegerList(this.toIntArray());
        }

        @Override
        public int[] toIntArray() {
            return NIOBufferUtilities.copyToNewArray(this.underlying);
        }

        @Override
        public int[] toIntArrayPossiblyLive() {
            return NIOBufferUtilities.getArray(this.underlying);
        }

        @Override
        public Slice<int[]> toIntArraySlicePossiblyLive() {
            return NIOBufferUtilities.getUnderlyingArrayOrCopyIfDirect(this.underlying);
        }

        @Override
        public Slice<IntBuffer> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<IntBuffer>(this.underlying, 0, this.size());
        }

        @Override
        public int size() {
            return this.underlying.remaining();
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return !this.underlying.isReadOnly();
        }

        @Override
        public IntegerList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthBufferWrapperIntegerList(this.underlying, fromIndex, toIndex - fromIndex);
        }

        @Override
        public int getInt(int index) {
            return this.underlying.get(index);
        }

        @Override
        public void setInt(int index, int value) {
            this.underlying.put(index, value);
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeInt(int newSize, int elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertInt(int index, int value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthBufferWrapperLongList
    implements LongList,
    TransparentContiguousArrayBackedCollection<LongBuffer>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final LongBuffer underlying;

        public FixedLengthBufferWrapperLongList(@SnapshotValue @LiveValue LongBuffer underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.remaining(), offset, length);
            this.underlying = NIOBufferUtilities.sliceAbsoluteNonmodifying(underlying, offset, length);
        }

        public FixedLengthBufferWrapperLongList(@SnapshotValue @LiveValue LongBuffer underlying) {
            this.underlying = NIOBufferUtilities.sliceNonmodifying(underlying);
        }

        public FixedLengthBufferWrapperLongList(@SnapshotValue @LiveValue Slice<LongBuffer> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public LongList clone() {
            return new FixedLengthArrayWrapperLongList(this.toLongArray());
        }

        @Override
        public long[] toLongArray() {
            return NIOBufferUtilities.copyToNewArray(this.underlying);
        }

        @Override
        public long[] toLongArrayPossiblyLive() {
            return NIOBufferUtilities.getArray(this.underlying);
        }

        @Override
        public Slice<long[]> toLongArraySlicePossiblyLive() {
            return NIOBufferUtilities.getUnderlyingArrayOrCopyIfDirect(this.underlying);
        }

        @Override
        public Slice<LongBuffer> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<LongBuffer>(this.underlying, 0, this.size());
        }

        @Override
        public int size() {
            return this.underlying.remaining();
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return !this.underlying.isReadOnly();
        }

        @Override
        public LongList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthBufferWrapperLongList(this.underlying, fromIndex, toIndex - fromIndex);
        }

        @Override
        public long getLong(int index) {
            return this.underlying.get(index);
        }

        @Override
        public void setLong(int index, long value) {
            this.underlying.put(index, value);
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeLong(int newSize, long elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertLong(int index, long value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedLengthBufferWrapperShortList
    implements ShortList,
    TransparentContiguousArrayBackedCollection<ShortBuffer>,
    KnowsLengthFixedness,
    RandomAccess {
        protected final ShortBuffer underlying;

        public FixedLengthBufferWrapperShortList(@SnapshotValue @LiveValue ShortBuffer underlying, int offset, int length) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.remaining(), offset, length);
            this.underlying = NIOBufferUtilities.sliceAbsoluteNonmodifying(underlying, offset, length);
        }

        public FixedLengthBufferWrapperShortList(@SnapshotValue @LiveValue ShortBuffer underlying) {
            this.underlying = NIOBufferUtilities.sliceNonmodifying(underlying);
        }

        public FixedLengthBufferWrapperShortList(@SnapshotValue @LiveValue Slice<ShortBuffer> underlying) {
            this(underlying.getUnderlying(), underlying.getOffset(), underlying.getLength());
        }

        @Override
        public ShortList clone() {
            return new FixedLengthArrayWrapperShortList(this.toShortArray());
        }

        @Override
        public short[] toShortArray() {
            return NIOBufferUtilities.copyToNewArray(this.underlying);
        }

        @Override
        public short[] toShortArrayPossiblyLive() {
            return NIOBufferUtilities.getArray(this.underlying);
        }

        @Override
        public Slice<short[]> toShortArraySlicePossiblyLive() {
            return NIOBufferUtilities.getUnderlyingArrayOrCopyIfDirect(this.underlying);
        }

        @Override
        public Slice<ShortBuffer> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<ShortBuffer>(this.underlying, 0, this.size());
        }

        @Override
        public int size() {
            return this.underlying.remaining();
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return !this.underlying.isReadOnly();
        }

        @Override
        public ShortList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            return new FixedLengthBufferWrapperShortList(this.underlying, fromIndex, toIndex - fromIndex);
        }

        @Override
        public short getShort(int index) {
            return this.underlying.get(index);
        }

        @Override
        public void setShort(int index, short value) {
            this.underlying.put(index, value);
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSizeShort(int newSize, short elementToAddIfGrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertShort(int index, short value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FloatArrayList
    implements DefaultShiftingBasedFloatList,
    ListWithSetSize<Float>,
    Trimmable,
    TransparentContiguousArrayBackedCollection<float[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected int size = 0;
        protected float[] data;
        protected Grower.GrowerComputationallyUnreducedPurelyRecursive grower;

        protected FloatArrayList(Void thisiswhyyoushouldntusejavaconstructorsAlthoughIdontknowhowtomakeinheritanceworkwellwithoutinitmethodsorfactoriesorsomething) {
        }

        public FloatArrayList(int initialCapacity, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = initialCapacity == 0 ? ArrayUtilities.EmptyFloatArray : new float[initialCapacity];
            this.grower = grower;
        }

        public FloatArrayList(@LiveValue @WritableValue float[] LIVEBACKING, int size, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = LIVEBACKING;
            this.grower = grower;
            this.size = size;
        }

        public FloatArrayList(@SnapshotValue @ReadonlyValue Collection<Float> c, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this(c.size(), grower);
            this.addAll((Collection<? extends Float>)c);
        }

        public FloatArrayList() {
            this(16);
        }

        public FloatArrayList(int initialCapacity) {
            this(initialCapacity, PrimitiveCollections.defaultPrimitiveArrayListGrower(initialCapacity));
        }

        public FloatArrayList(@SnapshotValue @ReadonlyValue Collection<Float> c) {
            this(c, PrimitiveCollections.defaultPrimitiveArrayListGrower(c.size()));
        }

        public FloatArrayList(@LiveValue @WritableValue float[] LIVEBACKING, int size) {
            this(LIVEBACKING, size, PrimitiveCollections.defaultPrimitiveArrayListGrower(LIVEBACKING.length));
        }

        public FloatArrayList(@LiveValue @WritableValue float[] LIVEBACKING) {
            this(LIVEBACKING, LIVEBACKING.length);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return false;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public void setSize(int newSize) {
            this.ensureCapacity(newSize);
            this.size = newSize;
        }

        protected void setupClone(FloatArrayList freshClone) {
            freshClone.size = this.size;
            freshClone.data = new float[this.size];
            System.arraycopy(this.data, 0, freshClone.data, 0, this.size);
            freshClone.grower = this.grower;
        }

        @Override
        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        public FloatArrayList clone() {
            FloatArrayList clone = new FloatArrayList();
            this.setupClone(clone);
            return clone;
        }

        @Override
        @ImplementationTransparency
        @LiveValue
        public Slice<float[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<float[]>(this.data, 0, this.size);
        }

        public void sort() {
            PrimitiveCollections.sortArray(this.data, 0, this.size);
        }

        @Override
        public void setFloat(int index, float value) {
            CollectionUtilities.rangeCheckMember(this.size, index);
            this.data[index] = value;
        }

        @Override
        public float getFloat(int index) {
            CollectionUtilities.rangeCheckMember(this.size(), index);
            return this.data[index];
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public void clear() {
            this.size = 0;
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public int size() {
            return this.size;
        }

        @ImplementationTransparency
        public void trimToSize() {
            float[] newdata = new float[this.size];
            System.arraycopy(this.data, 0, newdata, 0, this.size);
            this.data = newdata;
        }

        @Override
        public Trimmable.TrimmableTrimRV couldYouMaybeUseALittleLessMemoryIfYouDontMind() {
            this.trimToSize();
            return Trimmable.TrimmableTrimRV.DontKeepInvoking;
        }

        @ImplementationTransparency
        public int getCapacity() {
            return this.data.length;
        }

        @ImplementationTransparency
        public void ensureCapacity(int minCapacity) {
            if (this.data.length < minCapacity) {
                int newCapacity = this.getNewCapacity(minCapacity);
                float[] newData = new float[newCapacity];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
        }

        @Override
        public void clearHinting(int newCapacity) {
            this.clear();
            this.ensureCapacity(newCapacity);
        }

        @ImplementationTransparency
        public int getNewCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new IllegalArgumentException();
            }
            return Math.max(minCapacity, this.grower.getNewSizeRecursive(this.data.length));
        }

        @ImplementationTransparency
        public void setDirectBuffer(@LiveValue float[] array) {
            if (array.length < this.size) {
                throw new IllegalArgumentException("Array is too small; size=" + this.size + ", capacity=" + array.length);
            }
            this.data = array;
        }

        public String toString() {
            return this._toString();
        }
    }

    @SignalType
    public static interface FloatCollection
    extends PrimitiveCollection<Float, float[]>,
    SimpleFloatIterable {
        public boolean addFloat(float var1);

        public boolean removeFloat(float var1);

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class getPrimitiveType() {
            return Float.TYPE;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<Float> getBoxedType() {
            return Float.class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<float[]> getArrayType() {
            return float[].class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Float getDefaultElement() {
            return Float.valueOf(0.0f);
        }

        @ThrowAwayValue
        public static float[] defaultToFloatArray(FloatCollection collection) {
            float[] array = new float[collection.size()];
            SimpleFloatIterator i = collection.newSimpleFloatIterator();
            int index = 0;
            while (true) {
                try {
                    array[index] = i.nextrpFloat();
                }
                catch (StopIterationReturnPath exc) {
                    break;
                }
                ++index;
            }
            return array;
        }

        @ThrowAwayValue
        default public float[] toFloatArray() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<float[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof float[]) {
                    return ArrayUtilities.sliceToNewFloatArrayOP(u);
                }
            }
            return FloatCollection.defaultToFloatArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public float[] toFloatArrayPossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                int size = this.size();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                Object und = u.getUnderlying();
                if (und instanceof float[] && u.getOffset() == 0 && ((float[])und).length == size) {
                    return (float[])und;
                }
            }
            return FloatCollection.defaultToFloatArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public Slice<float[]> toFloatArraySlicePossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<float[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof float[]) {
                    return u;
                }
            }
            return ArrayUtilities.wholeArraySliceFloat(FloatCollection.defaultToFloatArray(this));
        }

        @LiveValue
        @Nullable
        default public Slice<float[]> toFloatArraySliceLiveOrNull() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<float[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof float[]) {
                    return u;
                }
            }
            return null;
        }

        default public boolean containsFloat(float value) {
            SimpleFloatIterator i = this.newSimpleFloatIterator();
            try {
                while (!Primitives.eqSane(i.nextrpFloat(), value)) {
                }
                return true;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return false;
            }
        }

        @Override
        default public Iterator<Float> iterator() {
            return SimpleFloatIterable.super.iterator();
        }

        @Override
        default public boolean isEmpty() {
            return this.size() == 0;
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllFloats(float[] array) {
            return this.addAllFloats(array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllFloats(Slice<float[]> arraySlice) {
            return this.addAllFloats(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllFloats(float[] elements, int offset, int length) {
            return FloatCollection.defaultAddAllFloats(this, elements, offset, length);
        }

        public static boolean defaultAddAllFloats(FloatCollection self, float[] elements, int offset, int length) {
            boolean changedAtAll = false;
            int e = offset + length;
            int i = offset;
            while (i < e) {
                changedAtAll |= self.addFloat(elements[i]);
                ++i;
            }
            return changedAtAll;
        }

        default public void removeAllFloats(float[] array) {
            this.removeAllFloats(array, 0, array.length);
        }

        default public void removeAllFloats(Slice<float[]> arraySlice) {
            this.removeAllFloats(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public void removeAllFloats(float[] a, int offset, int length) {
            int e = offset + length;
            int i = offset;
            while (i < e) {
                this.removeFloat(a[i]);
                ++i;
            }
        }

        @Override
        default public boolean contains(Object o) {
            return o instanceof Float && this.containsFloat(((Float)o).floatValue());
        }

        @Override
        default public boolean add(Float e) {
            return this.addFloat(e.floatValue());
        }

        @Override
        default public boolean remove(Object o) {
            return o instanceof Float && this.removeFloat(((Float)o).floatValue());
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            if (c instanceof FloatCollection) {
                FloatCollection cc = (FloatCollection)c;
                SimpleFloatIterator i = cc.newSimpleFloatIterator();
                try {
                    while (!this.containsFloat(i.nextrpFloat())) {
                    }
                    return true;
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return false;
                }
            }
            for (Object e : c) {
                if (!this.contains(e)) continue;
                return true;
            }
            return false;
        }

        @Override
        default public boolean addAll(Collection<? extends Float> c) {
            if (c instanceof FloatCollection) {
                boolean changedAtAll = false;
                SimpleFloatIterator simpleFloatIterator = ((FloatCollection)c).newSimpleFloatIterator();
                try {
                    while (true) {
                        changedAtAll |= this.add(Float.valueOf(simpleFloatIterator.nextrpFloat()));
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Float f : c) {
                changedAtAll |= this.add(f);
            }
            return changedAtAll;
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            if (c instanceof FloatCollection) {
                boolean changedAtAll = false;
                SimpleFloatIterator i = ((FloatCollection)c).newSimpleFloatIterator();
                try {
                    while (true) {
                        changedAtAll |= this.remove(Float.valueOf(i.nextrpFloat()));
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Object e : c) {
                changedAtAll |= this.remove(e);
            }
            return changedAtAll;
        }

        @Override
        default public void setFrom(Object source) {
            block8: {
                if (source == this) {
                    return;
                }
                if (source instanceof FloatCollection) {
                    FloatCollection s = (FloatCollection)source;
                    this.clearHinting(s.size());
                    SimpleFloatIterator i = s.newSimpleFloatIterator();
                    while (true) {
                        float e;
                        try {
                            e = i.nextrpFloat();
                        }
                        catch (StopIterationReturnPath exc) {
                            break block8;
                        }
                        this.addFloat(e);
                    }
                }
                if (source instanceof Collection) {
                    Collection s = (Collection)source;
                    this.clearHinting(s.size());
                    for (Float e : s) {
                        this.addFloat(e.floatValue());
                    }
                } else {
                    throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(source);
                }
            }
        }

        default public void clearHinting(int newCapacity) {
            this.clear();
        }

        @Override
        default public String _toString() {
            return PrimitiveCollections.defaultToString(this);
        }
    }

    @SignalType
    public static interface FloatList
    extends PrimitiveList<Float, float[]>,
    NonuniformMethodsForFloatList,
    FloatListRO,
    FloatListRWFixed {
        @Override
        default public Iterator<Float> iterator() {
            return NonuniformMethodsForFloatList.super.iterator();
        }

        public void insertFloat(int var1, float var2);

        public FloatList clone();

        public void setSizeFloat(int var1, float var2);

        @Override
        default public void setSize(int newSize, Float elementToAddIfGrowing) {
            this.setSizeFloat(newSize, elementToAddIfGrowing.floatValue());
        }

        @Override
        default public void setSize(int newSize) {
            this.setSizeFloat(newSize, 0.0f);
        }

        @Override
        default public void clear() {
            this.setSize(0);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllFloats(int index, float[] array) {
            this.setAllFloats(index, array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllFloats(int index, Slice<float[]> arraySlice) {
            this.setAllFloats(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        default public void setAllFloats(int start, float[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof float[]) {
                    Slice s = u;
                    System.arraycopy(array, offset, s.getUnderlying(), s.getOffset() + start, length);
                    return;
                }
            }
            FloatList.defaultSetAllFloats(this, start, array, offset, length);
        }

        public static void defaultSetAllFloats(FloatList list, int start, @WritableValue float[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                list.setFloat(start + i, array[offset + i]);
                ++i;
            }
        }

        default public void setAll(int destIndex, List sourceU, int sourceIndex, @Nonnegative int amount) throws IndexOutOfBoundsException {
            List source = sourceU;
            FloatList dest = this;
            int sourceSize = source.size();
            int destSize = dest.size();
            CollectionUtilities.rangeCheckIntervalByLength(sourceSize, sourceIndex, amount);
            CollectionUtilities.rangeCheckIntervalByLength(destSize, destIndex, amount);
            if (TransparentContiguousArrayBackedCollection.is(source)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)source)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(sourceSize, u);
                if (u.getUnderlying() instanceof float[]) {
                    Slice s = u;
                    this.setAllFloats(destIndex, (Slice)s.subslice(sourceIndex, amount));
                    return;
                }
            }
            if (source instanceof FloatList) {
                FloatList primSource = (FloatList)source;
                if (destIndex < sourceIndex) {
                    int i = 0;
                    while (i < amount) {
                        dest.setFloat(destIndex + i, primSource.getFloat(sourceIndex + i));
                        ++i;
                    }
                } else {
                    int i = amount - 1;
                    while (i >= 0) {
                        dest.setFloat(destIndex + i, primSource.getFloat(sourceIndex + i));
                        --i;
                    }
                }
            } else if (destIndex < sourceIndex) {
                int i = 0;
                while (i < amount) {
                    dest.set(destIndex + i, (Float)source.get(sourceIndex + i));
                    ++i;
                }
            } else {
                int i = amount - 1;
                while (i >= 0) {
                    dest.set(destIndex + i, (Float)source.get(sourceIndex + i));
                    --i;
                }
            }
        }

        default public void getAllFloats(int start, @WritableValue float[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof float[]) {
                    Slice s = u;
                    System.arraycopy(s.getUnderlying(), s.getOffset() + start, array, offset, length);
                    return;
                }
            }
            FloatList.defaultGetAllFloats(this, start, array, offset, length);
        }

        public static void defaultGetAllFloats(FloatList list, int start, @WritableValue float[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                array[offset + i] = list.getFloat(start + i);
                ++i;
            }
        }

        @ThrowAwayValue
        default public float[] getAllFloats(int start, int end) {
            CollectionUtilities.rangeCheckInterval(this.size(), start, end);
            float[] buff = new float[end - start];
            this.getAllFloats(start, buff, 0, buff.length);
            return buff;
        }

        @Override
        default public boolean addFloat(float value) {
            this.insertFloat(this.size(), value);
            return true;
        }

        @Override
        default public boolean addAll(Collection<? extends Float> c) {
            this.addAll(this.size(), c);
            return true;
        }

        @Override
        default public boolean addAllFloats(float[] elements, int offset, int length) {
            this.insertAllFloats(this.size(), elements, offset, length);
            return true;
        }

        default public void removeByIndex(int index) {
            this.removeRange(index, index + 1);
        }

        default public float removeFloatByIndex(int index) throws IndexOutOfBoundsException {
            float v = this.getFloat(index);
            this.removeByIndex(index);
            return v;
        }

        @Override
        default public boolean removeFloat(float value) {
            int i = this.indexOfFloat(value);
            if (i != -1) {
                this.removeByIndex(i);
                return true;
            }
            return false;
        }

        @Override
        default public boolean retainAll(Collection<?> c) {
            if (c instanceof FloatCollection) {
                FloatCollection cc = (FloatCollection)c;
                boolean changedAtAll = false;
                int i = this.size() - 1;
                while (i >= 0) {
                    if (!cc.containsFloat(this.getFloat(i))) {
                        this.removeFloatByIndex(i);
                        changedAtAll = true;
                    }
                    --i;
                }
                return changedAtAll;
            }
            boolean changedAtAll = false;
            int i = this.size() - 1;
            while (i >= 0) {
                if (!c.contains(Float.valueOf(this.getFloat(i)))) {
                    this.removeFloatByIndex(i);
                    changedAtAll = true;
                }
                --i;
            }
            return changedAtAll;
        }

        @Override
        default public SimpleFloatIterator newSimpleFloatIterator() {
            return new SimpleFloatIterator(){
                int index = 0;

                @Override
                public float nextrpFloat() throws StopIterationReturnPath {
                    int i = this.index;
                    if (i >= this.size()) {
                        throw StopIterationReturnPath.I;
                    }
                    this.index = i + 1;
                    return this.getFloat(i);
                }
            };
        }

        @Override
        default public boolean containsFloat(float value) {
            return this.indexOfFloat(value) != -1;
        }

        default public void insertAllFloats(int index, float[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                this.insertFloat(index + i, array[offset + i]);
                ++i;
            }
        }

        @Override
        default public boolean addAll(int index, Collection<? extends Float> c) {
            if (c instanceof FloatCollection) {
                FloatCollection floatCollection = (FloatCollection)c;
                SimpleFloatIterator i = floatCollection.newSimpleFloatIterator();
                try {
                    while (true) {
                        this.insertFloat(index, i.nextrpFloat());
                        ++index;
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {}
            } else {
                for (Float f : c) {
                    this.insertFloat(index, f.floatValue());
                    ++index;
                }
            }
            return true;
        }

        default public void insertAllFloats(int index, float[] array) {
            this.insertAllFloats(index, array, 0, array.length);
        }

        default public void insertAllFloats(int index, Slice<float[]> arraySlice) {
            this.insertAllFloats(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @Override
        default public Float get(int index) {
            return Float.valueOf(this.getFloat(index));
        }

        @Override
        default public Float set(int index, Float value) {
            Float previous = this.get(index);
            this.setFloat(index, value.floatValue());
            return previous;
        }

        @Override
        default public void add(int index, Float value) {
            this.insertFloat(index, value.floatValue());
        }

        @Override
        default public Float remove(int index) throws IndexOutOfBoundsException {
            return Float.valueOf(this.removeFloatByIndex(index));
        }

        @Override
        default public int indexOf(Object o) {
            return o instanceof Float ? this.indexOfFloat(((Float)o).floatValue()) : -1;
        }

        @Override
        default public int lastIndexOf(Object o) {
            return o instanceof Float ? this.lastIndexOfFloat(((Float)o).floatValue()) : -1;
        }

        default public int indexOf(Object o, int start) {
            return o instanceof Float ? this.indexOfFloat(((Float)o).floatValue(), start) : -1;
        }

        default public int lastIndexOf(Object o, int start) {
            return o instanceof Float ? this.lastIndexOfFloat(((Float)o).floatValue(), start) : -1;
        }

        @Override
        default public ListIterator<Float> listIterator() {
            return this.listIterator(0);
        }

        @Override
        default public ListIterator<Float> listIterator(int index) {
            return new DelegatingListIterator<Float>(this, index);
        }

        default public FloatList subList(int fromIndex, int toIndex) {
            if (fromIndex == 0 && toIndex == this.size()) {
                return this;
            }
            if (this instanceof Sublist) {
                Sublist s = (Sublist)((Object)this);
                return new FloatSublist((FloatList)s.getUnderlying(), s.getSublistStartingIndex() + fromIndex, toIndex - fromIndex);
            }
            return new FloatSublist(this, fromIndex, toIndex - fromIndex);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForFloatList.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForFloatList.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForFloatList.super.containsAll(c);
        }

        @Override
        default public boolean add(Float e) {
            return NonuniformMethodsForFloatList.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForFloatList.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForFloatList.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveList.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForFloatList.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForFloatList.super.toArray(a);
        }

        @Override
        default public void storeBoxingIntoArray(Slice<Object[]> array) {
            int n = this.size();
            int i = 0;
            while (i < n) {
                ArrayUtilities.setReference(array, i, this.get(i));
                ++i;
            }
        }

        default public boolean endsWith(List<Float> suffixCandidate) {
            return this.size() >= suffixCandidate.size() && this.subListToEnd(suffixCandidate.size()).equivalent(suffixCandidate);
        }

        default public boolean startsWith(List<Float> prefixCandidate) {
            return this.size() >= prefixCandidate.size() && this.subListFromBeginning(prefixCandidate.size()).equivalent(prefixCandidate);
        }

        default public FloatList subListToEnd(int start) {
            return (FloatList)PrimitiveList.super.subListToEnd(start);
        }

        default public FloatList subListFromBeginning(int lengthWhichIsEndExclusiveInThisCaseXD) {
            return (FloatList)PrimitiveList.super.subListFromBeginning(lengthWhichIsEndExclusiveInThisCaseXD);
        }

        default public FloatList subListByLength(int start, int length) {
            return (FloatList)PrimitiveList.super.subListByLength(start, length);
        }

        @Override
        default public void fillBySetting(int start, int count, Float value) {
            this.fillBySettingFloat(start, count, value.floatValue());
        }

        default public void fillBySettingFloat(float value) {
            this.fillBySettingFloat(0, this.size(), value);
        }

        default public void fillBySettingFloat(int start, int count, float value) {
            CollectionUtilities.rangeCheckIntervalByLength(this.size(), start, count);
            if (count >= 100) {
                float[] array = new float[SmallIntegerMathUtilities.least(count, 1024)];
                if (value != 0.0f) {
                    Arrays.fill(array, value);
                }
                int al = array.length;
                FloatList l = PrimitiveCollections.floatArrayAsList(array);
                while (count > al) {
                    this.setAll(start, l);
                    start += al;
                    count -= al;
                }
                if (count > 0) {
                    this.setAll(start, l.subList(0, count));
                }
            } else {
                int e = start + count;
                int i = start;
                while (i < e) {
                    this.setFloat(i, value);
                    ++i;
                }
            }
        }
    }

    @SignalType
    public static interface FloatListRO
    extends Equivalenceable {
        public float getFloat(int var1);

        public int size();

        default public int indexOfFloat(float value) {
            return this.indexOfFloat(value, 0);
        }

        default public int lastIndexOfFloat(float value) {
            return this.lastIndexOfFloat(value, this.size() - 1);
        }

        default public int indexOfFloat(float value, int start) {
            int n = this.size();
            int i = start;
            while (i < n) {
                if (Primitives.eqSane(this.getFloat(i), value)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        default public int lastIndexOfFloat(float value, int start) {
            int i = start;
            if (i >= 0 && Primitives.eqSane(this.getFloat(i), value)) {
                return i;
            }
            return i;
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof FloatListRO) {
                return this.equivalentFixedRO((FloatListRO)o);
            }
            if (o instanceof List) {
                List other = (List)o;
                int size = this.size();
                if (other.size() != size) {
                    return false;
                }
                int i = 0;
                while (i < size) {
                    Object e = other.get(i);
                    if (e instanceof Float) {
                        if (!Primitives.eqSane(this.getFloat(i), ((Float)e).floatValue())) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalentFixedRO(FloatListRO other) {
            int size = this.size();
            if (other.size() != size) {
                return false;
            }
            int i = 0;
            while (i < size) {
                if (!Primitives.eqSane(this.getFloat(i), other.getFloat(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            int size = this.size();
            int i = 0;
            while (i < size) {
                float e = this.getFloat(i);
                r = 31 * r + Primitives.hashprim(e);
                ++i;
            }
            return r;
        }
    }

    @SignalType
    public static interface FloatListRWFixed
    extends FloatListRO {
        public void setFloat(int var1, float var2);
    }

    public static class FloatListWrapper
    implements FloatList {
        protected final List<Float> underlying;

        public FloatListWrapper(List<Float> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithRemoveRange) {
                ((ListWithRemoveRange)((Object)this.underlying)).removeRange(start, pastEnd);
            } else {
                FloatList.super.removeRange(start, pastEnd);
            }
        }

        @Override
        public void setSize(int newSize, Float elementToAddIfGrowing) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize, elementToAddIfGrowing);
            } else {
                FloatList.super.setSize(newSize, elementToAddIfGrowing);
            }
        }

        @Override
        public void setSize(int newSize) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize);
            } else {
                FloatList.super.setSize(newSize);
            }
        }

        @Override
        public void setAll(int destIndex, List source, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithSetAll) {
                ((ListWithSetAll)((Object)this.underlying)).setAll(destIndex, source, sourceIndex, amount);
            } else {
                FloatList.super.setAll(destIndex, source, sourceIndex, amount);
            }
        }

        @Override
        public void fillBySetting(int start, int count, Float value) {
            if (this.underlying instanceof ListWithFill) {
                ((ListWithFill)this.underlying).fillBySetting(start, count, value);
            } else {
                FloatList.super.fillBySetting(start, count, value);
            }
        }

        @Override
        public FloatList clone() {
            return PrimitiveCollections.asFloatList(ObjectUtilities.attemptClone(this.underlying));
        }

        @Override
        public float getFloat(int index) {
            return this.get(index).floatValue();
        }

        @Override
        public void setFloat(int index, float value) {
            this.set(index, Float.valueOf(value));
        }

        @Override
        public void insertFloat(int index, float value) {
            this.add(index, Float.valueOf(value));
        }

        @Override
        public void setSizeFloat(int newSize, float elementToAddIfGrowing) {
            this.setSize(newSize, Float.valueOf(elementToAddIfGrowing));
        }

        @Override
        public void forEach(Consumer<? super Float> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Float e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Float> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Float> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Float> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Float> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Float> c) {
            this.underlying.sort(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public Float get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Float set(int index, Float element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Float element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Float> stream() {
            return this.underlying.stream();
        }

        @Override
        public Float remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Float> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public Spliterator<Float> spliterator() {
            return this.underlying.spliterator();
        }
    }

    @SignalType
    public static interface FloatSet
    extends PrimitiveSet<Float, float[]>,
    NonuniformMethodsForFloatSet {
        @Override
        default public Iterator<Float> iterator() {
            return NonuniformMethodsForFloatSet.super.iterator();
        }

        @Override
        default public boolean addAll(Collection<? extends Float> c) {
            return NonuniformMethodsForFloatSet.super.addAll(c);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForFloatSet.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForFloatSet.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForFloatSet.super.containsAll(c);
        }

        @Override
        default public boolean add(Float e) {
            return NonuniformMethodsForFloatSet.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForFloatSet.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForFloatSet.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveSet.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForFloatSet.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForFloatSet.super.toArray(a);
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof FloatSet) {
                return this.equivalent((FloatSet)o);
            }
            if (o instanceof Set) {
                int bs;
                Set a = (Set)o;
                FloatSet b = this;
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                int as = a.size();
                if (as != (bs = b.size())) {
                    return false;
                }
                if (CodeHinting.arbitrary(as, bs) == 0) {
                    return true;
                }
                for (Object an : a) {
                    if (an instanceof Float) {
                        if (b.containsFloat(((Float)an).floatValue())) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalent(FloatSet other) {
            int bs;
            FloatSet a = this;
            FloatSet b = other;
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            int as = a.size();
            if (as != (bs = b.size())) {
                return false;
            }
            if (CodeHinting.arbitrary(as, bs) == 0) {
                return true;
            }
            SimpleFloatIterator i = a.newSimpleFloatIterator();
            try {
                while (b.containsFloat(i.nextrpFloat())) {
                }
                return false;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return true;
            }
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            SimpleFloatIterator i = this.newSimpleFloatIterator();
            try {
                while (true) {
                    r += Primitives.hashprim(i.nextrpFloat());
                }
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return r;
            }
        }
    }

    public static class FloatSublist
    implements FloatList,
    DefaultShiftingBasedFloatList,
    Sublist<Float>,
    ShiftableList {
        protected final FloatList underlying;
        protected final int start;
        protected int size;

        public FloatSublist(FloatList underlying, int start, int initialSize) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.size(), start, initialSize);
            this.underlying = underlying;
            this.start = start;
            this.size = initialSize;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public float getFloat(int index) {
            return this.underlying.getFloat(index + this.start);
        }

        @Override
        public void setFloat(int index, float value) {
            this.underlying.setFloat(index + this.start, value);
        }

        @Override
        public void shiftRegionStretchingFromIndexToEndByAmountChangingSize(int start, int amount) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), start);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this.underlying, start, amount);
            this.size += amount;
        }

        @Override
        public FloatList clone() {
            FloatArrayList c = new FloatArrayList();
            c.addAll(this);
            return c;
        }

        @Override
        public FloatList getUnderlying() {
            return this.underlying;
        }

        @Override
        public int getSublistStartingIndex() {
            return this.start;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public Boolean isWritableCollection() {
            return this.underlying.isWritableCollection();
        }
    }

    public static class FloatTable {
        protected int width;
        protected float[] data;

        public FloatTable(int width, int height) {
            if (width < 0) {
                throw new IllegalArgumentException();
            }
            if (height < 0) {
                throw new IllegalArgumentException();
            }
            this.data = new float[width * height];
        }

        @Nonnegative
        public int getNumberOfColumns() {
            return this.width;
        }

        @Nonnegative
        public int getNumberOfRows() {
            return this.data.length / this.width;
        }

        @Nonnegative
        public int getNumberOfCells() {
            return this.data.length;
        }

        public float getCellContentsFloat(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            return this.data[rowIndex * this.getNumberOfColumns() + columnIndex];
        }

        public void setCellContentsFloat(int columnIndex, int rowIndex, @Nullable float newValue) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            this.data[rowIndex * this.getNumberOfColumns() + columnIndex] = newValue;
        }

        @Nullable
        public Float getCellContents(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            return Float.valueOf(this.getCellContentsFloat(columnIndex, rowIndex));
        }

        public void setCellContents(int columnIndex, int rowIndex, @Nullable Float newValue) throws IndexOutOfBoundsException {
            this.setCellContentsFloat(columnIndex, rowIndex, newValue.floatValue());
        }
    }

    @Immutable
    public static class ImmutableBooleanArrayList
    implements Serializable,
    Comparable<ImmutableBooleanArrayList>,
    BooleanList,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected final boolean[] data;
        public static final ImmutableBooleanArrayList Empty = ImmutableBooleanArrayList.newLIVE(ArrayUtilities.EmptyBooleanArray);
        public static final Comparator<ImmutableBooleanArrayList> ComparatorLittleEndian = (a, b) -> a.compareTo((ImmutableBooleanArrayList)b);
        public static final Comparator<ImmutableBooleanArrayList> ComparatorBigEndian = (a, b) -> a.compareToBigEndian((ImmutableBooleanArrayList)b);
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        protected ImmutableBooleanArrayList(boolean[] LIVEDATA) {
            if (LIVEDATA == null) {
                throw new NullPointerException();
            }
            this.data = LIVEDATA;
        }

        @ImplementationTransparency
        public static ImmutableBooleanArrayList newLIVE(@LiveValue @TreatAsImmutableValue boolean[] LIVEDATA) {
            return new ImmutableBooleanArrayList(LIVEDATA);
        }

        @ImplementationTransparency
        public static ImmutableBooleanArrayList newSingleton(boolean singleMember) {
            return new ImmutableBooleanArrayList(new boolean[]{singleMember});
        }

        public static ImmutableBooleanArrayList newCopying(@SnapshotValue List<Boolean> data) {
            Slice<boolean[]> s;
            if (data instanceof ImmutableBooleanArrayList) {
                return (ImmutableBooleanArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof boolean[]) {
                return ImmutableBooleanArrayList.newCopying(s);
            }
            if (data instanceof BooleanList) {
                return ImmutableBooleanArrayList.newLIVE(((BooleanList)data).toBooleanArray());
            }
            int n = data.size();
            boolean[] a = new boolean[n];
            int i = 0;
            for (Boolean e : data) {
                if (i >= n) {
                    throw new ImpossibleException();
                }
                a[i] = e;
                ++i;
            }
            if (i != n) {
                throw new ImpossibleException();
            }
            return ImmutableBooleanArrayList.newLIVE(a);
        }

        public static ImmutableBooleanArrayList newCopying(@SnapshotValue boolean[] data) {
            return new ImmutableBooleanArrayList((boolean[])data.clone());
        }

        public static ImmutableBooleanArrayList newCopying(@SnapshotValue boolean[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableBooleanArrayList.newCopying(data);
            }
            boolean[] newArray = new boolean[length];
            System.arraycopy(data, offset, newArray, 0, length);
            return new ImmutableBooleanArrayList(newArray);
        }

        public static ImmutableBooleanArrayList newCopying(@SnapshotValue Slice<boolean[]> data) {
            return ImmutableBooleanArrayList.newCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableBooleanArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue boolean[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableBooleanArrayList.newLIVE(data);
            }
            return ImmutableBooleanArrayList.newCopying(data, offset, length);
        }

        public static ImmutableBooleanArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue Slice<boolean[]> data) {
            return ImmutableBooleanArrayList.newLIVEOrCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableBooleanArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue List<Boolean> data) {
            Slice<boolean[]> s;
            if (data instanceof ImmutableBooleanArrayList) {
                return (ImmutableBooleanArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof boolean[]) {
                return ImmutableBooleanArrayList.newLIVEOrCopying(s);
            }
            return ImmutableBooleanArrayList.newCopying(data);
        }

        @Override
        @ThrowAwayValue
        public boolean[] toBooleanArray() {
            return (boolean[])this.data.clone();
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public boolean[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public int size() {
            return this.data.length;
        }

        @Override
        public boolean getBoolean(int index) {
            return this.data[index];
        }

        @Override
        public void getAllBooleans(int offsetInThisSource, @WritableValue boolean[] dest, int offsetInDest, int lengthInBoth) {
            System.arraycopy(this.data, offsetInThisSource, dest, offsetInDest, lengthInBoth);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }

        @Override
        public int compareTo(@ReadonlyValue ImmutableBooleanArrayList other) {
            return this.compareToBooleanArray(other.data);
        }

        public boolean equalsBooleanArray(@ReadonlyValue boolean[] o) {
            boolean[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            boolean[] theirData = o;
            return Arrays.equals(ourData, theirData);
        }

        public int compareToBooleanArray(@ReadonlyValue boolean[] o) {
            boolean[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            boolean[] theirData = o;
            return ArrayUtilities.compareLittleEndianLengthsFirst(ourData, theirData);
        }

        public int compareToBigEndian(@ReadonlyValue ImmutableBooleanArrayList other) {
            return this.compareToBooleanArrayBigEndian(other.data);
        }

        public int compareToBooleanArrayBigEndian(@ReadonlyValue boolean[] o) {
            boolean[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            boolean[] theirData = o;
            return ArrayUtilities.compareBigEndianLengthsFirst(ourData, theirData);
        }

        @Override
        public ImmutableBooleanArrayList clone() {
            return this;
        }

        @Override
        public ImmutableBooleanArrayList reversed() {
            return ImmutableBooleanArrayList.newLIVE(ArrayUtilities.reversed(this.data));
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeBoolean(int newSize, boolean elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertBoolean(int index, boolean value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setBoolean(int index, boolean value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof List)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableBooleanArrayList ? Arrays.equals(this.data, ((ImmutableBooleanArrayList)obj).data) : this.equivalent(obj);
        }
    }

    @Immutable
    public static class ImmutableByteArrayList
    implements Serializable,
    Comparable<ImmutableByteArrayList>,
    ByteList,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected final byte[] data;
        public static final ImmutableByteArrayList Empty = ImmutableByteArrayList.newLIVE(ArrayUtilities.EmptyByteArray);
        public static final Comparator<ImmutableByteArrayList> ComparatorLittleEndian = (a, b) -> a.compareTo((ImmutableByteArrayList)b);
        public static final Comparator<ImmutableByteArrayList> ComparatorBigEndian = (a, b) -> a.compareToBigEndian((ImmutableByteArrayList)b);
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        protected ImmutableByteArrayList(byte[] LIVEDATA) {
            if (LIVEDATA == null) {
                throw new NullPointerException();
            }
            this.data = LIVEDATA;
        }

        @ImplementationTransparency
        public static ImmutableByteArrayList newLIVE(@LiveValue @TreatAsImmutableValue byte[] LIVEDATA) {
            return new ImmutableByteArrayList(LIVEDATA);
        }

        @ImplementationTransparency
        public static ImmutableByteArrayList newSingleton(byte singleMember) {
            return new ImmutableByteArrayList(new byte[]{singleMember});
        }

        public static ImmutableByteArrayList newCopying(@SnapshotValue List<Byte> data) {
            Slice<byte[]> s;
            if (data instanceof ImmutableByteArrayList) {
                return (ImmutableByteArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof byte[]) {
                return ImmutableByteArrayList.newCopying(s);
            }
            if (data instanceof ByteList) {
                return ImmutableByteArrayList.newLIVE(((ByteList)data).toByteArray());
            }
            int n = data.size();
            byte[] a = new byte[n];
            int i = 0;
            for (Byte e : data) {
                if (i >= n) {
                    throw new ImpossibleException();
                }
                a[i] = e;
                ++i;
            }
            if (i != n) {
                throw new ImpossibleException();
            }
            return ImmutableByteArrayList.newLIVE(a);
        }

        public static ImmutableByteArrayList newCopying(@SnapshotValue byte[] data) {
            return new ImmutableByteArrayList((byte[])data.clone());
        }

        public static ImmutableByteArrayList newCopying(@SnapshotValue byte[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableByteArrayList.newCopying(data);
            }
            byte[] newArray = new byte[length];
            System.arraycopy(data, offset, newArray, 0, length);
            return new ImmutableByteArrayList(newArray);
        }

        public static ImmutableByteArrayList newCopying(@SnapshotValue Slice<byte[]> data) {
            return ImmutableByteArrayList.newCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableByteArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue byte[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableByteArrayList.newLIVE(data);
            }
            return ImmutableByteArrayList.newCopying(data, offset, length);
        }

        public static ImmutableByteArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue Slice<byte[]> data) {
            return ImmutableByteArrayList.newLIVEOrCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableByteArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue List<Byte> data) {
            Slice<byte[]> s;
            if (data instanceof ImmutableByteArrayList) {
                return (ImmutableByteArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof byte[]) {
                return ImmutableByteArrayList.newLIVEOrCopying(s);
            }
            return ImmutableByteArrayList.newCopying(data);
        }

        @Override
        @ThrowAwayValue
        public byte[] toByteArray() {
            return (byte[])this.data.clone();
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public byte[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public int size() {
            return this.data.length;
        }

        @Override
        public byte getByte(int index) {
            return this.data[index];
        }

        @Override
        public void getAllBytes(int offsetInThisSource, @WritableValue byte[] dest, int offsetInDest, int lengthInBoth) {
            System.arraycopy(this.data, offsetInThisSource, dest, offsetInDest, lengthInBoth);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }

        @Override
        public int compareTo(@ReadonlyValue ImmutableByteArrayList other) {
            return this.compareToByteArray(other.data);
        }

        public boolean equalsByteArray(@ReadonlyValue byte[] o) {
            byte[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            byte[] theirData = o;
            return Arrays.equals(ourData, theirData);
        }

        public int compareToByteArray(@ReadonlyValue byte[] o) {
            byte[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            byte[] theirData = o;
            return ArrayUtilities.compareLittleEndianLengthsFirst(ourData, theirData);
        }

        public int compareToBigEndian(@ReadonlyValue ImmutableByteArrayList other) {
            return this.compareToByteArrayBigEndian(other.data);
        }

        public int compareToByteArrayBigEndian(@ReadonlyValue byte[] o) {
            byte[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            byte[] theirData = o;
            return ArrayUtilities.compareBigEndianLengthsFirst(ourData, theirData);
        }

        @Override
        public ImmutableByteArrayList clone() {
            return this;
        }

        @Override
        public ImmutableByteArrayList reversed() {
            return ImmutableByteArrayList.newLIVE(ArrayUtilities.reversed(this.data));
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeByte(int newSize, byte elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertByte(int index, byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setByte(int index, byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof List)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableByteArrayList ? Arrays.equals(this.data, ((ImmutableByteArrayList)obj).data) : this.equivalent(obj);
        }
    }

    public static class ImmutableByteIntervalList
    extends AbstractReadonlyList<Byte>
    implements StaticallyConcurrentlyImmutable,
    DefaultByteIntervalCollection,
    ByteList {
        protected final byte lowerBoundInclusive;
        protected final int size;

        public ImmutableByteIntervalList(byte lowerBoundInclusive, @Nonnegative int size) {
            if (size < 0) {
                throw new IllegalArgumentException("negative size: " + size);
            }
            if (SmallIntegerMathUtilities.doesIntegerIntervalOverflowByteWithIntSize(lowerBoundInclusive, size)) {
                throw new OverflowException();
            }
            this.lowerBoundInclusive = lowerBoundInclusive;
            this.size = size;
        }

        @Override
        public ByteList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            byte l = this.lowerBoundInclusive;
            return new ImmutableByteIntervalList(PrimitiveCollections.scintervalByte(l + fromIndex), toIndex - fromIndex);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public byte getLowerBoundInclusive() {
            return this.lowerBoundInclusive;
        }

        @Override
        public ByteList clone() {
            return this;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public byte[] toByteArray() {
            return DefaultByteIntervalCollection.super.toByteArray();
        }

        @Override
        public SimpleByteIterator newSimpleByteIterator() {
            return DefaultByteIntervalCollection.super.newSimpleByteIterator();
        }

        @Override
        public boolean containsByte(byte i) {
            return DefaultByteIntervalCollection.super.containsByte(i);
        }

        @Override
        public byte getByte(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return (byte)(index + this.lowerBoundInclusive);
        }

        @Override
        public Byte get(int index) {
            return ByteList.super.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.contains(o) ? (Byte)o - this.lowerBoundInclusive : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public SimpleIterator<Byte> simpleIterator() {
            return DefaultByteIntervalCollection.super.simpleIterator();
        }

        @Override
        public Iterator<Byte> iterator() {
            return DefaultByteIntervalCollection.super.iterator();
        }

        @Override
        public boolean addByte(byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertByte(int index, byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeByte(byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setByte(int index, byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeByte(int newSize, byte elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this._toString();
        }
    }

    public static class ImmutableByteIntervalSet
    extends AbstractReadonlySet<Byte>
    implements StaticallyConcurrentlyImmutable,
    DefaultByteIntervalCollection {
        protected final byte lowerBoundInclusive;
        protected final int size;

        public ImmutableByteIntervalSet(byte lowerBoundInclusive, @Nonnegative int size) {
            if (size < 0) {
                throw new IllegalArgumentException("negative size: " + size);
            }
            if (SmallIntegerMathUtilities.doesIntegerIntervalOverflowByteWithIntSize(lowerBoundInclusive, size)) {
                throw new OverflowException();
            }
            this.lowerBoundInclusive = lowerBoundInclusive;
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public byte getLowerBoundInclusive() {
            return this.lowerBoundInclusive;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return DefaultByteIntervalCollection.super.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return DefaultByteIntervalCollection.super.contains(o);
        }

        @Override
        public SimpleIterator<Byte> simpleIterator() {
            return DefaultByteIntervalCollection.super.simpleIterator();
        }

        @Override
        public Iterator<Byte> iterator() {
            return DefaultByteIntervalCollection.super.iterator();
        }

        @Override
        public boolean addByte(byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeByte(byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this._toString();
        }
    }

    @Immutable
    public static class ImmutableCharacterArrayList
    implements Serializable,
    Comparable<ImmutableCharacterArrayList>,
    CharacterList,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected final char[] data;
        public static final ImmutableCharacterArrayList Empty = ImmutableCharacterArrayList.newLIVE(ArrayUtilities.EmptyCharArray);
        public static final Comparator<ImmutableCharacterArrayList> ComparatorLittleEndian = (a, b) -> a.compareTo((ImmutableCharacterArrayList)b);
        public static final Comparator<ImmutableCharacterArrayList> ComparatorBigEndian = (a, b) -> a.compareToBigEndian((ImmutableCharacterArrayList)b);
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        protected ImmutableCharacterArrayList(char[] LIVEDATA) {
            if (LIVEDATA == null) {
                throw new NullPointerException();
            }
            this.data = LIVEDATA;
        }

        @ImplementationTransparency
        public static ImmutableCharacterArrayList newLIVE(@LiveValue @TreatAsImmutableValue char[] LIVEDATA) {
            return new ImmutableCharacterArrayList(LIVEDATA);
        }

        @ImplementationTransparency
        public static ImmutableCharacterArrayList newSingleton(char singleMember) {
            return new ImmutableCharacterArrayList(new char[]{singleMember});
        }

        public static ImmutableCharacterArrayList newCopying(@SnapshotValue List<Character> data) {
            Slice<char[]> s;
            if (data instanceof ImmutableCharacterArrayList) {
                return (ImmutableCharacterArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof char[]) {
                return ImmutableCharacterArrayList.newCopying(s);
            }
            if (data instanceof CharacterList) {
                return ImmutableCharacterArrayList.newLIVE(((CharacterList)data).toCharArray());
            }
            int n = data.size();
            char[] a = new char[n];
            int i = 0;
            for (Character e : data) {
                if (i >= n) {
                    throw new ImpossibleException();
                }
                a[i] = e.charValue();
                ++i;
            }
            if (i != n) {
                throw new ImpossibleException();
            }
            return ImmutableCharacterArrayList.newLIVE(a);
        }

        public static ImmutableCharacterArrayList newCopying(@SnapshotValue char[] data) {
            return new ImmutableCharacterArrayList((char[])data.clone());
        }

        public static ImmutableCharacterArrayList newCopying(@SnapshotValue char[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableCharacterArrayList.newCopying(data);
            }
            char[] newArray = new char[length];
            System.arraycopy(data, offset, newArray, 0, length);
            return new ImmutableCharacterArrayList(newArray);
        }

        public static ImmutableCharacterArrayList newCopying(@SnapshotValue Slice<char[]> data) {
            return ImmutableCharacterArrayList.newCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableCharacterArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue char[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableCharacterArrayList.newLIVE(data);
            }
            return ImmutableCharacterArrayList.newCopying(data, offset, length);
        }

        public static ImmutableCharacterArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue Slice<char[]> data) {
            return ImmutableCharacterArrayList.newLIVEOrCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableCharacterArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue List<Character> data) {
            Slice<char[]> s;
            if (data instanceof ImmutableCharacterArrayList) {
                return (ImmutableCharacterArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof char[]) {
                return ImmutableCharacterArrayList.newLIVEOrCopying(s);
            }
            return ImmutableCharacterArrayList.newCopying(data);
        }

        @Override
        @ThrowAwayValue
        public char[] toCharArray() {
            return (char[])this.data.clone();
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public char[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public int size() {
            return this.data.length;
        }

        @Override
        public char getChar(int index) {
            return this.data[index];
        }

        @Override
        public void getAllChars(int offsetInThisSource, @WritableValue char[] dest, int offsetInDest, int lengthInBoth) {
            System.arraycopy(this.data, offsetInThisSource, dest, offsetInDest, lengthInBoth);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }

        @Override
        public int compareTo(@ReadonlyValue ImmutableCharacterArrayList other) {
            return this.compareToCharArray(other.data);
        }

        public boolean equalsCharArray(@ReadonlyValue char[] o) {
            char[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            char[] theirData = o;
            return Arrays.equals(ourData, theirData);
        }

        public int compareToCharArray(@ReadonlyValue char[] o) {
            char[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            char[] theirData = o;
            return ArrayUtilities.compareLittleEndianLengthsFirst(ourData, theirData);
        }

        public int compareToBigEndian(@ReadonlyValue ImmutableCharacterArrayList other) {
            return this.compareToCharArrayBigEndian(other.data);
        }

        public int compareToCharArrayBigEndian(@ReadonlyValue char[] o) {
            char[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            char[] theirData = o;
            return ArrayUtilities.compareBigEndianLengthsFirst(ourData, theirData);
        }

        @Override
        public ImmutableCharacterArrayList clone() {
            return this;
        }

        @Override
        public ImmutableCharacterArrayList reversed() {
            return ImmutableCharacterArrayList.newLIVE(ArrayUtilities.reversed(this.data));
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeChar(int newSize, char elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertChar(int index, char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setChar(int index, char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this._toString();
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof List)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableCharacterArrayList ? Arrays.equals(this.data, ((ImmutableCharacterArrayList)obj).data) : this.equivalent(obj);
        }
    }

    public static class ImmutableCharacterIntervalList
    extends AbstractReadonlyList<Character>
    implements StaticallyConcurrentlyImmutable,
    DefaultCharacterIntervalCollection,
    CharacterList {
        protected final char lowerBoundInclusive;
        protected final int size;

        public ImmutableCharacterIntervalList(char lowerBoundInclusive, @Nonnegative int size) {
            if (size < 0) {
                throw new IllegalArgumentException("negative size: " + size);
            }
            if (SmallIntegerMathUtilities.doesIntegerIntervalOverflowCharWithIntSize(lowerBoundInclusive, size)) {
                throw new OverflowException();
            }
            this.lowerBoundInclusive = lowerBoundInclusive;
            this.size = size;
        }

        @Override
        public CharacterList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            char l = this.lowerBoundInclusive;
            return new ImmutableCharacterIntervalList(PrimitiveCollections.scintervalChar(l + fromIndex), toIndex - fromIndex);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public char getLowerBoundInclusive() {
            return this.lowerBoundInclusive;
        }

        @Override
        public CharacterList clone() {
            return this;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public char[] toCharArray() {
            return DefaultCharacterIntervalCollection.super.toCharArray();
        }

        @Override
        public SimpleCharacterIterator newSimpleCharacterIterator() {
            return DefaultCharacterIntervalCollection.super.newSimpleCharacterIterator();
        }

        @Override
        public boolean containsChar(char i) {
            return DefaultCharacterIntervalCollection.super.containsChar(i);
        }

        @Override
        public char getChar(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return (char)(index + this.lowerBoundInclusive);
        }

        @Override
        public Character get(int index) {
            return CharacterList.super.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.contains(o) ? ((Character)o).charValue() - this.lowerBoundInclusive : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public SimpleIterator<Character> simpleIterator() {
            return DefaultCharacterIntervalCollection.super.simpleIterator();
        }

        @Override
        public Iterator<Character> iterator() {
            return DefaultCharacterIntervalCollection.super.iterator();
        }

        @Override
        public boolean addChar(char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertChar(int index, char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeChar(char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setChar(int index, char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeChar(int newSize, char elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this._toString();
        }
    }

    public static class ImmutableCharacterIntervalSet
    extends AbstractReadonlySet<Character>
    implements StaticallyConcurrentlyImmutable,
    DefaultCharacterIntervalCollection {
        protected final char lowerBoundInclusive;
        protected final int size;

        public ImmutableCharacterIntervalSet(char lowerBoundInclusive, @Nonnegative int size) {
            if (size < 0) {
                throw new IllegalArgumentException("negative size: " + size);
            }
            if (SmallIntegerMathUtilities.doesIntegerIntervalOverflowCharWithIntSize(lowerBoundInclusive, size)) {
                throw new OverflowException();
            }
            this.lowerBoundInclusive = lowerBoundInclusive;
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public char getLowerBoundInclusive() {
            return this.lowerBoundInclusive;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return DefaultCharacterIntervalCollection.super.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return DefaultCharacterIntervalCollection.super.contains(o);
        }

        @Override
        public SimpleIterator<Character> simpleIterator() {
            return DefaultCharacterIntervalCollection.super.simpleIterator();
        }

        @Override
        public Iterator<Character> iterator() {
            return DefaultCharacterIntervalCollection.super.iterator();
        }

        @Override
        public boolean addChar(char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeChar(char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this._toString();
        }
    }

    @Immutable
    public static class ImmutableDoubleArrayList
    implements Serializable,
    Comparable<ImmutableDoubleArrayList>,
    DoubleList,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected final double[] data;
        public static final ImmutableDoubleArrayList Empty = ImmutableDoubleArrayList.newLIVE(ArrayUtilities.EmptyDoubleArray);
        public static final Comparator<ImmutableDoubleArrayList> ComparatorLittleEndian = (a, b) -> a.compareTo((ImmutableDoubleArrayList)b);
        public static final Comparator<ImmutableDoubleArrayList> ComparatorBigEndian = (a, b) -> a.compareToBigEndian((ImmutableDoubleArrayList)b);
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        protected ImmutableDoubleArrayList(double[] LIVEDATA) {
            if (LIVEDATA == null) {
                throw new NullPointerException();
            }
            this.data = LIVEDATA;
        }

        @ImplementationTransparency
        public static ImmutableDoubleArrayList newLIVE(@LiveValue @TreatAsImmutableValue double[] LIVEDATA) {
            return new ImmutableDoubleArrayList(LIVEDATA);
        }

        @ImplementationTransparency
        public static ImmutableDoubleArrayList newSingleton(double singleMember) {
            return new ImmutableDoubleArrayList(new double[]{singleMember});
        }

        public static ImmutableDoubleArrayList newCopying(@SnapshotValue List<Double> data) {
            Slice<double[]> s;
            if (data instanceof ImmutableDoubleArrayList) {
                return (ImmutableDoubleArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof double[]) {
                return ImmutableDoubleArrayList.newCopying(s);
            }
            if (data instanceof DoubleList) {
                return ImmutableDoubleArrayList.newLIVE(((DoubleList)data).toDoubleArray());
            }
            int n = data.size();
            double[] a = new double[n];
            int i = 0;
            for (Double e : data) {
                if (i >= n) {
                    throw new ImpossibleException();
                }
                a[i] = e;
                ++i;
            }
            if (i != n) {
                throw new ImpossibleException();
            }
            return ImmutableDoubleArrayList.newLIVE(a);
        }

        public static ImmutableDoubleArrayList newCopying(@SnapshotValue double[] data) {
            return new ImmutableDoubleArrayList((double[])data.clone());
        }

        public static ImmutableDoubleArrayList newCopying(@SnapshotValue double[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableDoubleArrayList.newCopying(data);
            }
            double[] newArray = new double[length];
            System.arraycopy(data, offset, newArray, 0, length);
            return new ImmutableDoubleArrayList(newArray);
        }

        public static ImmutableDoubleArrayList newCopying(@SnapshotValue Slice<double[]> data) {
            return ImmutableDoubleArrayList.newCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableDoubleArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue double[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableDoubleArrayList.newLIVE(data);
            }
            return ImmutableDoubleArrayList.newCopying(data, offset, length);
        }

        public static ImmutableDoubleArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue Slice<double[]> data) {
            return ImmutableDoubleArrayList.newLIVEOrCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableDoubleArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue List<Double> data) {
            Slice<double[]> s;
            if (data instanceof ImmutableDoubleArrayList) {
                return (ImmutableDoubleArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof double[]) {
                return ImmutableDoubleArrayList.newLIVEOrCopying(s);
            }
            return ImmutableDoubleArrayList.newCopying(data);
        }

        @Override
        @ThrowAwayValue
        public double[] toDoubleArray() {
            return (double[])this.data.clone();
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public double[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public int size() {
            return this.data.length;
        }

        @Override
        public double getDouble(int index) {
            return this.data[index];
        }

        @Override
        public void getAllDoubles(int offsetInThisSource, @WritableValue double[] dest, int offsetInDest, int lengthInBoth) {
            System.arraycopy(this.data, offsetInThisSource, dest, offsetInDest, lengthInBoth);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }

        @Override
        public int compareTo(@ReadonlyValue ImmutableDoubleArrayList other) {
            return this.compareToDoubleArray(other.data);
        }

        public boolean equalsDoubleArray(@ReadonlyValue double[] o) {
            double[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            double[] theirData = o;
            return Arrays.equals(ourData, theirData);
        }

        public int compareToDoubleArray(@ReadonlyValue double[] o) {
            double[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            double[] theirData = o;
            return ArrayUtilities.compareLittleEndianLengthsFirst(ourData, theirData);
        }

        public int compareToBigEndian(@ReadonlyValue ImmutableDoubleArrayList other) {
            return this.compareToDoubleArrayBigEndian(other.data);
        }

        public int compareToDoubleArrayBigEndian(@ReadonlyValue double[] o) {
            double[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            double[] theirData = o;
            return ArrayUtilities.compareBigEndianLengthsFirst(ourData, theirData);
        }

        @Override
        public ImmutableDoubleArrayList clone() {
            return this;
        }

        @Override
        public ImmutableDoubleArrayList reversed() {
            return ImmutableDoubleArrayList.newLIVE(ArrayUtilities.reversed(this.data));
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeDouble(int newSize, double elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertDouble(int index, double value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setDouble(int index, double value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof List)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableDoubleArrayList ? Arrays.equals(this.data, ((ImmutableDoubleArrayList)obj).data) : this.equivalent(obj);
        }
    }

    @Immutable
    public static class ImmutableFloatArrayList
    implements Serializable,
    Comparable<ImmutableFloatArrayList>,
    FloatList,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected final float[] data;
        public static final ImmutableFloatArrayList Empty = ImmutableFloatArrayList.newLIVE(ArrayUtilities.EmptyFloatArray);
        public static final Comparator<ImmutableFloatArrayList> ComparatorLittleEndian = (a, b) -> a.compareTo((ImmutableFloatArrayList)b);
        public static final Comparator<ImmutableFloatArrayList> ComparatorBigEndian = (a, b) -> a.compareToBigEndian((ImmutableFloatArrayList)b);
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        protected ImmutableFloatArrayList(float[] LIVEDATA) {
            if (LIVEDATA == null) {
                throw new NullPointerException();
            }
            this.data = LIVEDATA;
        }

        @ImplementationTransparency
        public static ImmutableFloatArrayList newLIVE(@LiveValue @TreatAsImmutableValue float[] LIVEDATA) {
            return new ImmutableFloatArrayList(LIVEDATA);
        }

        @ImplementationTransparency
        public static ImmutableFloatArrayList newSingleton(float singleMember) {
            return new ImmutableFloatArrayList(new float[]{singleMember});
        }

        public static ImmutableFloatArrayList newCopying(@SnapshotValue List<Float> data) {
            Slice<float[]> s;
            if (data instanceof ImmutableFloatArrayList) {
                return (ImmutableFloatArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof float[]) {
                return ImmutableFloatArrayList.newCopying(s);
            }
            if (data instanceof FloatList) {
                return ImmutableFloatArrayList.newLIVE(((FloatList)data).toFloatArray());
            }
            int n = data.size();
            float[] a = new float[n];
            int i = 0;
            for (Float e : data) {
                if (i >= n) {
                    throw new ImpossibleException();
                }
                a[i] = e.floatValue();
                ++i;
            }
            if (i != n) {
                throw new ImpossibleException();
            }
            return ImmutableFloatArrayList.newLIVE(a);
        }

        public static ImmutableFloatArrayList newCopying(@SnapshotValue float[] data) {
            return new ImmutableFloatArrayList((float[])data.clone());
        }

        public static ImmutableFloatArrayList newCopying(@SnapshotValue float[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableFloatArrayList.newCopying(data);
            }
            float[] newArray = new float[length];
            System.arraycopy(data, offset, newArray, 0, length);
            return new ImmutableFloatArrayList(newArray);
        }

        public static ImmutableFloatArrayList newCopying(@SnapshotValue Slice<float[]> data) {
            return ImmutableFloatArrayList.newCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableFloatArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue float[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableFloatArrayList.newLIVE(data);
            }
            return ImmutableFloatArrayList.newCopying(data, offset, length);
        }

        public static ImmutableFloatArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue Slice<float[]> data) {
            return ImmutableFloatArrayList.newLIVEOrCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableFloatArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue List<Float> data) {
            Slice<float[]> s;
            if (data instanceof ImmutableFloatArrayList) {
                return (ImmutableFloatArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof float[]) {
                return ImmutableFloatArrayList.newLIVEOrCopying(s);
            }
            return ImmutableFloatArrayList.newCopying(data);
        }

        @Override
        @ThrowAwayValue
        public float[] toFloatArray() {
            return (float[])this.data.clone();
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public float[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public int size() {
            return this.data.length;
        }

        @Override
        public float getFloat(int index) {
            return this.data[index];
        }

        @Override
        public void getAllFloats(int offsetInThisSource, @WritableValue float[] dest, int offsetInDest, int lengthInBoth) {
            System.arraycopy(this.data, offsetInThisSource, dest, offsetInDest, lengthInBoth);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }

        @Override
        public int compareTo(@ReadonlyValue ImmutableFloatArrayList other) {
            return this.compareToFloatArray(other.data);
        }

        public boolean equalsFloatArray(@ReadonlyValue float[] o) {
            float[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            float[] theirData = o;
            return Arrays.equals(ourData, theirData);
        }

        public int compareToFloatArray(@ReadonlyValue float[] o) {
            float[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            float[] theirData = o;
            return ArrayUtilities.compareLittleEndianLengthsFirst(ourData, theirData);
        }

        public int compareToBigEndian(@ReadonlyValue ImmutableFloatArrayList other) {
            return this.compareToFloatArrayBigEndian(other.data);
        }

        public int compareToFloatArrayBigEndian(@ReadonlyValue float[] o) {
            float[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            float[] theirData = o;
            return ArrayUtilities.compareBigEndianLengthsFirst(ourData, theirData);
        }

        @Override
        public ImmutableFloatArrayList clone() {
            return this;
        }

        @Override
        public ImmutableFloatArrayList reversed() {
            return ImmutableFloatArrayList.newLIVE(ArrayUtilities.reversed(this.data));
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeFloat(int newSize, float elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertFloat(int index, float value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setFloat(int index, float value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof List)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableFloatArrayList ? Arrays.equals(this.data, ((ImmutableFloatArrayList)obj).data) : this.equivalent(obj);
        }
    }

    @Immutable
    public static class ImmutableIntegerArrayList
    implements Serializable,
    Comparable<ImmutableIntegerArrayList>,
    IntegerList,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected final int[] data;
        public static final ImmutableIntegerArrayList Empty = ImmutableIntegerArrayList.newLIVE(ArrayUtilities.EmptyIntArray);
        public static final Comparator<ImmutableIntegerArrayList> ComparatorLittleEndian = (a, b) -> a.compareTo((ImmutableIntegerArrayList)b);
        public static final Comparator<ImmutableIntegerArrayList> ComparatorBigEndian = (a, b) -> a.compareToBigEndian((ImmutableIntegerArrayList)b);
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        protected ImmutableIntegerArrayList(int[] LIVEDATA) {
            if (LIVEDATA == null) {
                throw new NullPointerException();
            }
            this.data = LIVEDATA;
        }

        @ImplementationTransparency
        public static ImmutableIntegerArrayList newLIVE(@LiveValue @TreatAsImmutableValue int[] LIVEDATA) {
            return new ImmutableIntegerArrayList(LIVEDATA);
        }

        @ImplementationTransparency
        public static ImmutableIntegerArrayList newSingleton(int singleMember) {
            return new ImmutableIntegerArrayList(new int[]{singleMember});
        }

        public static ImmutableIntegerArrayList newCopying(@SnapshotValue List<Integer> data) {
            Slice<int[]> s;
            if (data instanceof ImmutableIntegerArrayList) {
                return (ImmutableIntegerArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof int[]) {
                return ImmutableIntegerArrayList.newCopying(s);
            }
            if (data instanceof IntegerList) {
                return ImmutableIntegerArrayList.newLIVE(((IntegerList)data).toIntArray());
            }
            int n = data.size();
            int[] a = new int[n];
            int i = 0;
            for (Integer e : data) {
                if (i >= n) {
                    throw new ImpossibleException();
                }
                a[i] = e;
                ++i;
            }
            if (i != n) {
                throw new ImpossibleException();
            }
            return ImmutableIntegerArrayList.newLIVE(a);
        }

        public static ImmutableIntegerArrayList newCopying(@SnapshotValue int[] data) {
            return new ImmutableIntegerArrayList((int[])data.clone());
        }

        public static ImmutableIntegerArrayList newCopying(@SnapshotValue int[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableIntegerArrayList.newCopying(data);
            }
            int[] newArray = new int[length];
            System.arraycopy(data, offset, newArray, 0, length);
            return new ImmutableIntegerArrayList(newArray);
        }

        public static ImmutableIntegerArrayList newCopying(@SnapshotValue Slice<int[]> data) {
            return ImmutableIntegerArrayList.newCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableIntegerArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue int[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableIntegerArrayList.newLIVE(data);
            }
            return ImmutableIntegerArrayList.newCopying(data, offset, length);
        }

        public static ImmutableIntegerArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue Slice<int[]> data) {
            return ImmutableIntegerArrayList.newLIVEOrCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableIntegerArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue List<Integer> data) {
            Slice<int[]> s;
            if (data instanceof ImmutableIntegerArrayList) {
                return (ImmutableIntegerArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof int[]) {
                return ImmutableIntegerArrayList.newLIVEOrCopying(s);
            }
            return ImmutableIntegerArrayList.newCopying(data);
        }

        @Override
        @ThrowAwayValue
        public int[] toIntArray() {
            return (int[])this.data.clone();
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public int[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public int size() {
            return this.data.length;
        }

        @Override
        public int getInt(int index) {
            return this.data[index];
        }

        @Override
        public void getAllInts(int offsetInThisSource, @WritableValue int[] dest, int offsetInDest, int lengthInBoth) {
            System.arraycopy(this.data, offsetInThisSource, dest, offsetInDest, lengthInBoth);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }

        @Override
        public int compareTo(@ReadonlyValue ImmutableIntegerArrayList other) {
            return this.compareToIntArray(other.data);
        }

        public boolean equalsIntArray(@ReadonlyValue int[] o) {
            int[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            int[] theirData = o;
            return Arrays.equals(ourData, theirData);
        }

        public int compareToIntArray(@ReadonlyValue int[] o) {
            int[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            int[] theirData = o;
            return ArrayUtilities.compareLittleEndianLengthsFirst(ourData, theirData);
        }

        public int compareToBigEndian(@ReadonlyValue ImmutableIntegerArrayList other) {
            return this.compareToIntArrayBigEndian(other.data);
        }

        public int compareToIntArrayBigEndian(@ReadonlyValue int[] o) {
            int[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            int[] theirData = o;
            return ArrayUtilities.compareBigEndianLengthsFirst(ourData, theirData);
        }

        @Override
        public ImmutableIntegerArrayList clone() {
            return this;
        }

        @Override
        public ImmutableIntegerArrayList reversed() {
            return ImmutableIntegerArrayList.newLIVE(ArrayUtilities.reversed(this.data));
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeInt(int newSize, int elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertInt(int index, int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setInt(int index, int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof List)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableIntegerArrayList ? Arrays.equals(this.data, ((ImmutableIntegerArrayList)obj).data) : this.equivalent(obj);
        }
    }

    public static class ImmutableIntegerIntervalList
    extends AbstractReadonlyList<Integer>
    implements StaticallyConcurrentlyImmutable,
    DefaultIntegerIntervalCollection,
    IntegerList {
        protected final int lowerBoundInclusive;
        protected final int size;

        public ImmutableIntegerIntervalList(int lowerBoundInclusive, @Nonnegative int size) {
            if (size < 0) {
                throw new IllegalArgumentException("negative size: " + size);
            }
            if (SmallIntegerMathUtilities.doesIntegerIntervalOverflowIntWithIntSize(lowerBoundInclusive, size)) {
                throw new OverflowException();
            }
            this.lowerBoundInclusive = lowerBoundInclusive;
            this.size = size;
        }

        @Override
        public IntegerList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            int l = this.lowerBoundInclusive;
            return new ImmutableIntegerIntervalList(PrimitiveCollections.scintervalInt(l + fromIndex), toIndex - fromIndex);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int getLowerBoundInclusive() {
            return this.lowerBoundInclusive;
        }

        @Override
        public IntegerList clone() {
            return this;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public int[] toIntArray() {
            return DefaultIntegerIntervalCollection.super.toIntArray();
        }

        @Override
        public SimpleIntegerIterator newSimpleIntegerIterator() {
            return DefaultIntegerIntervalCollection.super.newSimpleIntegerIterator();
        }

        @Override
        public boolean containsInt(int i) {
            return DefaultIntegerIntervalCollection.super.containsInt(i);
        }

        @Override
        public int getInt(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return index + this.lowerBoundInclusive;
        }

        @Override
        public Integer get(int index) {
            return IntegerList.super.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.contains(o) ? (Integer)o - this.lowerBoundInclusive : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public SimpleIterator<Integer> simpleIterator() {
            return DefaultIntegerIntervalCollection.super.simpleIterator();
        }

        @Override
        public Iterator<Integer> iterator() {
            return DefaultIntegerIntervalCollection.super.iterator();
        }

        @Override
        public boolean addInt(int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertInt(int index, int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeInt(int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setInt(int index, int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeInt(int newSize, int elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this._toString();
        }
    }

    public static class ImmutableIntegerIntervalSet
    extends AbstractReadonlySet<Integer>
    implements StaticallyConcurrentlyImmutable,
    DefaultIntegerIntervalCollection {
        protected final int lowerBoundInclusive;
        protected final int size;

        public ImmutableIntegerIntervalSet(int lowerBoundInclusive, @Nonnegative int size) {
            if (size < 0) {
                throw new IllegalArgumentException("negative size: " + size);
            }
            if (SmallIntegerMathUtilities.doesIntegerIntervalOverflowIntWithIntSize(lowerBoundInclusive, size)) {
                throw new OverflowException();
            }
            this.lowerBoundInclusive = lowerBoundInclusive;
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int getLowerBoundInclusive() {
            return this.lowerBoundInclusive;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return DefaultIntegerIntervalCollection.super.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return DefaultIntegerIntervalCollection.super.contains(o);
        }

        @Override
        public SimpleIterator<Integer> simpleIterator() {
            return DefaultIntegerIntervalCollection.super.simpleIterator();
        }

        @Override
        public Iterator<Integer> iterator() {
            return DefaultIntegerIntervalCollection.super.iterator();
        }

        @Override
        public boolean addInt(int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeInt(int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this._toString();
        }
    }

    @Immutable
    public static class ImmutableLongArrayList
    implements Serializable,
    Comparable<ImmutableLongArrayList>,
    LongList,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected final long[] data;
        public static final ImmutableLongArrayList Empty = ImmutableLongArrayList.newLIVE(ArrayUtilities.EmptyLongArray);
        public static final Comparator<ImmutableLongArrayList> ComparatorLittleEndian = (a, b) -> a.compareTo((ImmutableLongArrayList)b);
        public static final Comparator<ImmutableLongArrayList> ComparatorBigEndian = (a, b) -> a.compareToBigEndian((ImmutableLongArrayList)b);
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        protected ImmutableLongArrayList(long[] LIVEDATA) {
            if (LIVEDATA == null) {
                throw new NullPointerException();
            }
            this.data = LIVEDATA;
        }

        @ImplementationTransparency
        public static ImmutableLongArrayList newLIVE(@LiveValue @TreatAsImmutableValue long[] LIVEDATA) {
            return new ImmutableLongArrayList(LIVEDATA);
        }

        @ImplementationTransparency
        public static ImmutableLongArrayList newSingleton(long singleMember) {
            return new ImmutableLongArrayList(new long[]{singleMember});
        }

        public static ImmutableLongArrayList newCopying(@SnapshotValue List<Long> data) {
            Slice<long[]> s;
            if (data instanceof ImmutableLongArrayList) {
                return (ImmutableLongArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof long[]) {
                return ImmutableLongArrayList.newCopying(s);
            }
            if (data instanceof LongList) {
                return ImmutableLongArrayList.newLIVE(((LongList)data).toLongArray());
            }
            int n = data.size();
            long[] a = new long[n];
            int i = 0;
            for (Long e : data) {
                if (i >= n) {
                    throw new ImpossibleException();
                }
                a[i] = e;
                ++i;
            }
            if (i != n) {
                throw new ImpossibleException();
            }
            return ImmutableLongArrayList.newLIVE(a);
        }

        public static ImmutableLongArrayList newCopying(@SnapshotValue long[] data) {
            return new ImmutableLongArrayList((long[])data.clone());
        }

        public static ImmutableLongArrayList newCopying(@SnapshotValue long[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableLongArrayList.newCopying(data);
            }
            long[] newArray = new long[length];
            System.arraycopy(data, offset, newArray, 0, length);
            return new ImmutableLongArrayList(newArray);
        }

        public static ImmutableLongArrayList newCopying(@SnapshotValue Slice<long[]> data) {
            return ImmutableLongArrayList.newCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableLongArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue long[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableLongArrayList.newLIVE(data);
            }
            return ImmutableLongArrayList.newCopying(data, offset, length);
        }

        public static ImmutableLongArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue Slice<long[]> data) {
            return ImmutableLongArrayList.newLIVEOrCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableLongArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue List<Long> data) {
            Slice<long[]> s;
            if (data instanceof ImmutableLongArrayList) {
                return (ImmutableLongArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof long[]) {
                return ImmutableLongArrayList.newLIVEOrCopying(s);
            }
            return ImmutableLongArrayList.newCopying(data);
        }

        @Override
        @ThrowAwayValue
        public long[] toLongArray() {
            return (long[])this.data.clone();
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public long[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public int size() {
            return this.data.length;
        }

        @Override
        public long getLong(int index) {
            return this.data[index];
        }

        @Override
        public void getAllLongs(int offsetInThisSource, @WritableValue long[] dest, int offsetInDest, int lengthInBoth) {
            System.arraycopy(this.data, offsetInThisSource, dest, offsetInDest, lengthInBoth);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }

        @Override
        public int compareTo(@ReadonlyValue ImmutableLongArrayList other) {
            return this.compareToLongArray(other.data);
        }

        public boolean equalsLongArray(@ReadonlyValue long[] o) {
            long[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            long[] theirData = o;
            return Arrays.equals(ourData, theirData);
        }

        public int compareToLongArray(@ReadonlyValue long[] o) {
            long[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            long[] theirData = o;
            return ArrayUtilities.compareLittleEndianLengthsFirst(ourData, theirData);
        }

        public int compareToBigEndian(@ReadonlyValue ImmutableLongArrayList other) {
            return this.compareToLongArrayBigEndian(other.data);
        }

        public int compareToLongArrayBigEndian(@ReadonlyValue long[] o) {
            long[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            long[] theirData = o;
            return ArrayUtilities.compareBigEndianLengthsFirst(ourData, theirData);
        }

        @Override
        public ImmutableLongArrayList clone() {
            return this;
        }

        @Override
        public ImmutableLongArrayList reversed() {
            return ImmutableLongArrayList.newLIVE(ArrayUtilities.reversed(this.data));
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeLong(int newSize, long elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertLong(int index, long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setLong(int index, long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof List)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableLongArrayList ? Arrays.equals(this.data, ((ImmutableLongArrayList)obj).data) : this.equivalent(obj);
        }
    }

    public static class ImmutableLongIntervalList
    extends AbstractReadonlyList<Long>
    implements StaticallyConcurrentlyImmutable,
    DefaultLongIntervalCollection,
    LongList {
        protected final long lowerBoundInclusive;
        protected final int size;

        public ImmutableLongIntervalList(long lowerBoundInclusive, @Nonnegative int size) {
            if (size < 0) {
                throw new IllegalArgumentException("negative size: " + size);
            }
            if (SmallIntegerMathUtilities.doesIntegerIntervalOverflowLongWithIntSize(lowerBoundInclusive, size)) {
                throw new OverflowException();
            }
            this.lowerBoundInclusive = lowerBoundInclusive;
            this.size = size;
        }

        @Override
        public LongList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            long l = this.lowerBoundInclusive;
            return new ImmutableLongIntervalList(PrimitiveCollections.scintervalLong(l + (long)fromIndex), toIndex - fromIndex);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public long getLowerBoundInclusive() {
            return this.lowerBoundInclusive;
        }

        @Override
        public LongList clone() {
            return this;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public long[] toLongArray() {
            return DefaultLongIntervalCollection.super.toLongArray();
        }

        @Override
        public SimpleLongIterator newSimpleLongIterator() {
            return DefaultLongIntervalCollection.super.newSimpleLongIterator();
        }

        @Override
        public boolean containsLong(long i) {
            return DefaultLongIntervalCollection.super.containsLong(i);
        }

        @Override
        public long getLong(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return (long)index + this.lowerBoundInclusive;
        }

        @Override
        public Long get(int index) {
            return LongList.super.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.contains(o) ? (int)((Long)o - this.lowerBoundInclusive) : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public SimpleIterator<Long> simpleIterator() {
            return DefaultLongIntervalCollection.super.simpleIterator();
        }

        @Override
        public Iterator<Long> iterator() {
            return DefaultLongIntervalCollection.super.iterator();
        }

        @Override
        public boolean addLong(long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertLong(int index, long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeLong(long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setLong(int index, long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeLong(int newSize, long elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this._toString();
        }
    }

    public static class ImmutableLongIntervalSet
    extends AbstractReadonlySet<Long>
    implements StaticallyConcurrentlyImmutable,
    DefaultLongIntervalCollection {
        protected final long lowerBoundInclusive;
        protected final int size;

        public ImmutableLongIntervalSet(long lowerBoundInclusive, @Nonnegative int size) {
            if (size < 0) {
                throw new IllegalArgumentException("negative size: " + size);
            }
            if (SmallIntegerMathUtilities.doesIntegerIntervalOverflowLongWithIntSize(lowerBoundInclusive, size)) {
                throw new OverflowException();
            }
            this.lowerBoundInclusive = lowerBoundInclusive;
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public long getLowerBoundInclusive() {
            return this.lowerBoundInclusive;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return DefaultLongIntervalCollection.super.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return DefaultLongIntervalCollection.super.contains(o);
        }

        @Override
        public SimpleIterator<Long> simpleIterator() {
            return DefaultLongIntervalCollection.super.simpleIterator();
        }

        @Override
        public Iterator<Long> iterator() {
            return DefaultLongIntervalCollection.super.iterator();
        }

        @Override
        public boolean addLong(long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeLong(long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this._toString();
        }
    }

    @Immutable
    public static class ImmutableShortArrayList
    implements Serializable,
    Comparable<ImmutableShortArrayList>,
    ShortList,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected final short[] data;
        public static final ImmutableShortArrayList Empty = ImmutableShortArrayList.newLIVE(ArrayUtilities.EmptyShortArray);
        public static final Comparator<ImmutableShortArrayList> ComparatorLittleEndian = (a, b) -> a.compareTo((ImmutableShortArrayList)b);
        public static final Comparator<ImmutableShortArrayList> ComparatorBigEndian = (a, b) -> a.compareToBigEndian((ImmutableShortArrayList)b);
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        protected ImmutableShortArrayList(short[] LIVEDATA) {
            if (LIVEDATA == null) {
                throw new NullPointerException();
            }
            this.data = LIVEDATA;
        }

        @ImplementationTransparency
        public static ImmutableShortArrayList newLIVE(@LiveValue @TreatAsImmutableValue short[] LIVEDATA) {
            return new ImmutableShortArrayList(LIVEDATA);
        }

        @ImplementationTransparency
        public static ImmutableShortArrayList newSingleton(short singleMember) {
            return new ImmutableShortArrayList(new short[]{singleMember});
        }

        public static ImmutableShortArrayList newCopying(@SnapshotValue List<Short> data) {
            Slice<short[]> s;
            if (data instanceof ImmutableShortArrayList) {
                return (ImmutableShortArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof short[]) {
                return ImmutableShortArrayList.newCopying(s);
            }
            if (data instanceof ShortList) {
                return ImmutableShortArrayList.newLIVE(((ShortList)data).toShortArray());
            }
            int n = data.size();
            short[] a = new short[n];
            int i = 0;
            for (Short e : data) {
                if (i >= n) {
                    throw new ImpossibleException();
                }
                a[i] = e;
                ++i;
            }
            if (i != n) {
                throw new ImpossibleException();
            }
            return ImmutableShortArrayList.newLIVE(a);
        }

        public static ImmutableShortArrayList newCopying(@SnapshotValue short[] data) {
            return new ImmutableShortArrayList((short[])data.clone());
        }

        public static ImmutableShortArrayList newCopying(@SnapshotValue short[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableShortArrayList.newCopying(data);
            }
            short[] newArray = new short[length];
            System.arraycopy(data, offset, newArray, 0, length);
            return new ImmutableShortArrayList(newArray);
        }

        public static ImmutableShortArrayList newCopying(@SnapshotValue Slice<short[]> data) {
            return ImmutableShortArrayList.newCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableShortArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue short[] data, int offset, int length) {
            if (offset == 0 && length == data.length) {
                return ImmutableShortArrayList.newLIVE(data);
            }
            return ImmutableShortArrayList.newCopying(data, offset, length);
        }

        public static ImmutableShortArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue Slice<short[]> data) {
            return ImmutableShortArrayList.newLIVEOrCopying(data.getUnderlying(), data.getOffset(), data.getLength());
        }

        public static ImmutableShortArrayList newLIVEOrCopying(@PossiblySnapshotPossiblyLiveValue List<Short> data) {
            Slice<short[]> s;
            if (data instanceof ImmutableShortArrayList) {
                return (ImmutableShortArrayList)data;
            }
            if (TransparentContiguousArrayBackedCollection.is(data) && (s = ((TransparentContiguousArrayBackedCollection)((Object)data)).getLiveContiguousArrayBackingUNSAFE()).getUnderlying() instanceof short[]) {
                return ImmutableShortArrayList.newLIVEOrCopying(s);
            }
            return ImmutableShortArrayList.newCopying(data);
        }

        @Override
        @ThrowAwayValue
        public short[] toShortArray() {
            return (short[])this.data.clone();
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public short[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public int size() {
            return this.data.length;
        }

        @Override
        public short getShort(int index) {
            return this.data[index];
        }

        @Override
        public void getAllShorts(int offsetInThisSource, @WritableValue short[] dest, int offsetInDest, int lengthInBoth) {
            System.arraycopy(this.data, offsetInThisSource, dest, offsetInDest, lengthInBoth);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }

        @Override
        public int compareTo(@ReadonlyValue ImmutableShortArrayList other) {
            return this.compareToShortArray(other.data);
        }

        public boolean equalsShortArray(@ReadonlyValue short[] o) {
            short[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            short[] theirData = o;
            return Arrays.equals(ourData, theirData);
        }

        public int compareToShortArray(@ReadonlyValue short[] o) {
            short[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            short[] theirData = o;
            return ArrayUtilities.compareLittleEndianLengthsFirst(ourData, theirData);
        }

        public int compareToBigEndian(@ReadonlyValue ImmutableShortArrayList other) {
            return this.compareToShortArrayBigEndian(other.data);
        }

        public int compareToShortArrayBigEndian(@ReadonlyValue short[] o) {
            short[] ourData = this.getREADONLYLiveWholeArrayBackingUNSAFE();
            short[] theirData = o;
            return ArrayUtilities.compareBigEndianLengthsFirst(ourData, theirData);
        }

        @Override
        public ImmutableShortArrayList clone() {
            return this;
        }

        @Override
        public ImmutableShortArrayList reversed() {
            return ImmutableShortArrayList.newLIVE(ArrayUtilities.reversed(this.data));
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeShort(int newSize, short elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertShort(int index, short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setShort(int index, short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof List)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableShortArrayList ? Arrays.equals(this.data, ((ImmutableShortArrayList)obj).data) : this.equivalent(obj);
        }
    }

    public static class ImmutableShortIntervalList
    extends AbstractReadonlyList<Short>
    implements StaticallyConcurrentlyImmutable,
    DefaultShortIntervalCollection,
    ShortList {
        protected final short lowerBoundInclusive;
        protected final int size;

        public ImmutableShortIntervalList(short lowerBoundInclusive, @Nonnegative int size) {
            if (size < 0) {
                throw new IllegalArgumentException("negative size: " + size);
            }
            if (SmallIntegerMathUtilities.doesIntegerIntervalOverflowShortWithIntSize(lowerBoundInclusive, size)) {
                throw new OverflowException();
            }
            this.lowerBoundInclusive = lowerBoundInclusive;
            this.size = size;
        }

        @Override
        public ShortList subList(int fromIndex, int toIndex) {
            CollectionUtilities.rangeCheckInterval(this.size(), fromIndex, toIndex);
            short l = this.lowerBoundInclusive;
            return new ImmutableShortIntervalList(PrimitiveCollections.scintervalShort(l + fromIndex), toIndex - fromIndex);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public short getLowerBoundInclusive() {
            return this.lowerBoundInclusive;
        }

        @Override
        public ShortList clone() {
            return this;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public short[] toShortArray() {
            return DefaultShortIntervalCollection.super.toShortArray();
        }

        @Override
        public SimpleShortIterator newSimpleShortIterator() {
            return DefaultShortIntervalCollection.super.newSimpleShortIterator();
        }

        @Override
        public boolean containsShort(short i) {
            return DefaultShortIntervalCollection.super.containsShort(i);
        }

        @Override
        public short getShort(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return (short)(index + this.lowerBoundInclusive);
        }

        @Override
        public Short get(int index) {
            return ShortList.super.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.contains(o) ? (Short)o - this.lowerBoundInclusive : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public SimpleIterator<Short> simpleIterator() {
            return DefaultShortIntervalCollection.super.simpleIterator();
        }

        @Override
        public Iterator<Short> iterator() {
            return DefaultShortIntervalCollection.super.iterator();
        }

        @Override
        public boolean addShort(short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertShort(int index, short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeShort(short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setShort(int index, short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeShort(int newSize, short elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this._toString();
        }
    }

    public static class ImmutableShortIntervalSet
    extends AbstractReadonlySet<Short>
    implements StaticallyConcurrentlyImmutable,
    DefaultShortIntervalCollection {
        protected final short lowerBoundInclusive;
        protected final int size;

        public ImmutableShortIntervalSet(short lowerBoundInclusive, @Nonnegative int size) {
            if (size < 0) {
                throw new IllegalArgumentException("negative size: " + size);
            }
            if (SmallIntegerMathUtilities.doesIntegerIntervalOverflowShortWithIntSize(lowerBoundInclusive, size)) {
                throw new OverflowException();
            }
            this.lowerBoundInclusive = lowerBoundInclusive;
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public short getLowerBoundInclusive() {
            return this.lowerBoundInclusive;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return DefaultShortIntervalCollection.super.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return DefaultShortIntervalCollection.super.contains(o);
        }

        @Override
        public SimpleIterator<Short> simpleIterator() {
            return DefaultShortIntervalCollection.super.simpleIterator();
        }

        @Override
        public Iterator<Short> iterator() {
            return DefaultShortIntervalCollection.super.iterator();
        }

        @Override
        public boolean addShort(short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeShort(short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this._toString();
        }
    }

    @HashableType
    public static class ImmutableSortedByteSetBackedByArray
    implements Serializable,
    Comparable<ImmutableSortedByteSetBackedByArray>,
    ByteSet,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected byte[] data;
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        public ImmutableSortedByteSetBackedByArray(@LiveValue byte[] presortedOrEmptyUnderlying) {
            this.data = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static ImmutableSortedByteSetBackedByArray sorted(@ReadonlyValue @SnapshotValue Collection<Byte> c) {
            byte[] a = PrimitiveCollections.toByteArray(c);
            Arrays.sort(a);
            return new ImmutableSortedByteSetBackedByArray(a);
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public byte[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Concurrently_Immutable;
        }

        @Override
        public boolean addByte(byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public int indexOfByte(byte value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.data, 0, this.size(), value);
        }

        @Override
        public boolean removeByte(byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean containsByte(byte value) {
            return this.indexOfByte(value) != -1;
        }

        public boolean equivalent(ImmutableSortedByteSetBackedByArray other) {
            return Arrays.equals(this.data, other.data);
        }

        @Override
        public byte[] toByteArray() {
            return this.toSortedByteArray();
        }

        @ThrowAwayValue
        public byte[] toSortedByteArray() {
            return (byte[])this.data.clone();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.data.length;
        }

        public byte removeByteByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeRange(int start, int end) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        public byte getByte(int index) {
            return this.data[index];
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public SimpleByteIterator newSimpleByteIterator() {
            return new SimpleByteIterator(){
                int i = 0;

                @Override
                public byte nextrpByte() throws StopIterationReturnPath {
                    int i = this.i;
                    if (i >= data.length) {
                        throw StopIterationReturnPath.I;
                    }
                    this.i = i + 1;
                    return data[i];
                }
            };
        }

        public ImmutableSortedByteSetBackedByArray clone() {
            return new ImmutableSortedByteSetBackedByArray((byte[])this.data.clone());
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int compareTo(ImmutableSortedByteSetBackedByArray o) {
            return ArrayUtilities.compareLittleEndianLengthsFirst(this.data, o.data);
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Set)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableSortedByteSetBackedByArray ? Arrays.equals(this.data, ((ImmutableSortedByteSetBackedByArray)obj).data) : this.equivalent(obj);
        }
    }

    @HashableType
    public static class ImmutableSortedCharacterSetBackedByArray
    implements Serializable,
    Comparable<ImmutableSortedCharacterSetBackedByArray>,
    CharacterSet,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected char[] data;
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        public ImmutableSortedCharacterSetBackedByArray(@LiveValue char[] presortedOrEmptyUnderlying) {
            this.data = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static ImmutableSortedCharacterSetBackedByArray sorted(@ReadonlyValue @SnapshotValue Collection<Character> c) {
            char[] a = PrimitiveCollections.toCharArray(c);
            Arrays.sort(a);
            return new ImmutableSortedCharacterSetBackedByArray(a);
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public char[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Concurrently_Immutable;
        }

        @Override
        public boolean addChar(char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public int indexOfChar(char value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.data, 0, this.size(), value);
        }

        @Override
        public boolean removeChar(char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean containsChar(char value) {
            return this.indexOfChar(value) != -1;
        }

        public boolean equivalent(ImmutableSortedCharacterSetBackedByArray other) {
            return Arrays.equals(this.data, other.data);
        }

        @Override
        public char[] toCharArray() {
            return this.toSortedCharArray();
        }

        @ThrowAwayValue
        public char[] toSortedCharArray() {
            return (char[])this.data.clone();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.data.length;
        }

        public char removeCharByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeRange(int start, int end) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        public char getChar(int index) {
            return this.data[index];
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public SimpleCharacterIterator newSimpleCharacterIterator() {
            return new SimpleCharacterIterator(){
                int i = 0;

                @Override
                public char nextrpChar() throws StopIterationReturnPath {
                    int i = this.i;
                    if (i >= data.length) {
                        throw StopIterationReturnPath.I;
                    }
                    this.i = i + 1;
                    return data[i];
                }
            };
        }

        public ImmutableSortedCharacterSetBackedByArray clone() {
            return new ImmutableSortedCharacterSetBackedByArray((char[])this.data.clone());
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int compareTo(ImmutableSortedCharacterSetBackedByArray o) {
            return ArrayUtilities.compareLittleEndianLengthsFirst(this.data, o.data);
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Set)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableSortedCharacterSetBackedByArray ? Arrays.equals(this.data, ((ImmutableSortedCharacterSetBackedByArray)obj).data) : this.equivalent(obj);
        }
    }

    @HashableType
    public static class ImmutableSortedDoubleSetBackedByArray
    implements Serializable,
    Comparable<ImmutableSortedDoubleSetBackedByArray>,
    DoubleSet,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected double[] data;
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        public ImmutableSortedDoubleSetBackedByArray(@LiveValue double[] presortedOrEmptyUnderlying) {
            this.data = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static ImmutableSortedDoubleSetBackedByArray sorted(@ReadonlyValue @SnapshotValue Collection<Double> c) {
            double[] a = PrimitiveCollections.toDoubleArray(c);
            Arrays.sort(a);
            return new ImmutableSortedDoubleSetBackedByArray(a);
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public double[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Concurrently_Immutable;
        }

        @Override
        public boolean addDouble(double value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public int indexOfDouble(double value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.data, 0, this.size(), value);
        }

        @Override
        public boolean removeDouble(double value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean containsDouble(double value) {
            return this.indexOfDouble(value) != -1;
        }

        public boolean equivalent(ImmutableSortedDoubleSetBackedByArray other) {
            return Arrays.equals(this.data, other.data);
        }

        @Override
        public double[] toDoubleArray() {
            return this.toSortedDoubleArray();
        }

        @ThrowAwayValue
        public double[] toSortedDoubleArray() {
            return (double[])this.data.clone();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.data.length;
        }

        public double removeDoubleByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeRange(int start, int end) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        public double getDouble(int index) {
            return this.data[index];
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public SimpleDoubleIterator newSimpleDoubleIterator() {
            return new SimpleDoubleIterator(){
                int i = 0;

                @Override
                public double nextrpDouble() throws StopIterationReturnPath {
                    int i = this.i;
                    if (i >= data.length) {
                        throw StopIterationReturnPath.I;
                    }
                    this.i = i + 1;
                    return data[i];
                }
            };
        }

        public ImmutableSortedDoubleSetBackedByArray clone() {
            return new ImmutableSortedDoubleSetBackedByArray((double[])this.data.clone());
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int compareTo(ImmutableSortedDoubleSetBackedByArray o) {
            return ArrayUtilities.compareLittleEndianLengthsFirst(this.data, o.data);
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Set)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableSortedDoubleSetBackedByArray ? Arrays.equals(this.data, ((ImmutableSortedDoubleSetBackedByArray)obj).data) : this.equivalent(obj);
        }
    }

    @HashableType
    public static class ImmutableSortedFloatSetBackedByArray
    implements Serializable,
    Comparable<ImmutableSortedFloatSetBackedByArray>,
    FloatSet,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected float[] data;
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        public ImmutableSortedFloatSetBackedByArray(@LiveValue float[] presortedOrEmptyUnderlying) {
            this.data = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static ImmutableSortedFloatSetBackedByArray sorted(@ReadonlyValue @SnapshotValue Collection<Float> c) {
            float[] a = PrimitiveCollections.toFloatArray(c);
            Arrays.sort(a);
            return new ImmutableSortedFloatSetBackedByArray(a);
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public float[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Concurrently_Immutable;
        }

        @Override
        public boolean addFloat(float value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public int indexOfFloat(float value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.data, 0, this.size(), value);
        }

        @Override
        public boolean removeFloat(float value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean containsFloat(float value) {
            return this.indexOfFloat(value) != -1;
        }

        public boolean equivalent(ImmutableSortedFloatSetBackedByArray other) {
            return Arrays.equals(this.data, other.data);
        }

        @Override
        public float[] toFloatArray() {
            return this.toSortedFloatArray();
        }

        @ThrowAwayValue
        public float[] toSortedFloatArray() {
            return (float[])this.data.clone();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.data.length;
        }

        public float removeFloatByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeRange(int start, int end) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        public float getFloat(int index) {
            return this.data[index];
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public SimpleFloatIterator newSimpleFloatIterator() {
            return new SimpleFloatIterator(){
                int i = 0;

                @Override
                public float nextrpFloat() throws StopIterationReturnPath {
                    int i = this.i;
                    if (i >= data.length) {
                        throw StopIterationReturnPath.I;
                    }
                    this.i = i + 1;
                    return data[i];
                }
            };
        }

        public ImmutableSortedFloatSetBackedByArray clone() {
            return new ImmutableSortedFloatSetBackedByArray((float[])this.data.clone());
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int compareTo(ImmutableSortedFloatSetBackedByArray o) {
            return ArrayUtilities.compareLittleEndianLengthsFirst(this.data, o.data);
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Set)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableSortedFloatSetBackedByArray ? Arrays.equals(this.data, ((ImmutableSortedFloatSetBackedByArray)obj).data) : this.equivalent(obj);
        }
    }

    @HashableType
    public static class ImmutableSortedIntegerSetBackedByArray
    implements Serializable,
    Comparable<ImmutableSortedIntegerSetBackedByArray>,
    IntegerSet,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected int[] data;
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        public ImmutableSortedIntegerSetBackedByArray(@LiveValue int[] presortedOrEmptyUnderlying) {
            this.data = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static ImmutableSortedIntegerSetBackedByArray sorted(@ReadonlyValue @SnapshotValue Collection<Integer> c) {
            int[] a = PrimitiveCollections.toIntArray(c);
            Arrays.sort(a);
            return new ImmutableSortedIntegerSetBackedByArray(a);
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public int[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Concurrently_Immutable;
        }

        @Override
        public boolean addInt(int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public int indexOfInt(int value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.data, 0, this.size(), value);
        }

        @Override
        public boolean removeInt(int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean containsInt(int value) {
            return this.indexOfInt(value) != -1;
        }

        public boolean equivalent(ImmutableSortedIntegerSetBackedByArray other) {
            return Arrays.equals(this.data, other.data);
        }

        @Override
        public int[] toIntArray() {
            return this.toSortedIntArray();
        }

        @ThrowAwayValue
        public int[] toSortedIntArray() {
            return (int[])this.data.clone();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.data.length;
        }

        public int removeIntByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeRange(int start, int end) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        public int getInt(int index) {
            return this.data[index];
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public SimpleIntegerIterator newSimpleIntegerIterator() {
            return new SimpleIntegerIterator(){
                int i = 0;

                @Override
                public int nextrpInt() throws StopIterationReturnPath {
                    int i = this.i;
                    if (i >= data.length) {
                        throw StopIterationReturnPath.I;
                    }
                    this.i = i + 1;
                    return data[i];
                }
            };
        }

        public ImmutableSortedIntegerSetBackedByArray clone() {
            return new ImmutableSortedIntegerSetBackedByArray((int[])this.data.clone());
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int compareTo(ImmutableSortedIntegerSetBackedByArray o) {
            return ArrayUtilities.compareLittleEndianLengthsFirst(this.data, o.data);
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Set)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableSortedIntegerSetBackedByArray ? Arrays.equals(this.data, ((ImmutableSortedIntegerSetBackedByArray)obj).data) : this.equivalent(obj);
        }
    }

    @HashableType
    public static class ImmutableSortedLongSetBackedByArray
    implements Serializable,
    Comparable<ImmutableSortedLongSetBackedByArray>,
    LongSet,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected long[] data;
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        public ImmutableSortedLongSetBackedByArray(@LiveValue long[] presortedOrEmptyUnderlying) {
            this.data = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static ImmutableSortedLongSetBackedByArray sorted(@ReadonlyValue @SnapshotValue Collection<Long> c) {
            long[] a = PrimitiveCollections.toLongArray(c);
            Arrays.sort(a);
            return new ImmutableSortedLongSetBackedByArray(a);
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public long[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Concurrently_Immutable;
        }

        @Override
        public boolean addLong(long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public int indexOfLong(long value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.data, 0, this.size(), value);
        }

        @Override
        public boolean removeLong(long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean containsLong(long value) {
            return this.indexOfLong(value) != -1;
        }

        public boolean equivalent(ImmutableSortedLongSetBackedByArray other) {
            return Arrays.equals(this.data, other.data);
        }

        @Override
        public long[] toLongArray() {
            return this.toSortedLongArray();
        }

        @ThrowAwayValue
        public long[] toSortedLongArray() {
            return (long[])this.data.clone();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.data.length;
        }

        public long removeLongByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeRange(int start, int end) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        public long getLong(int index) {
            return this.data[index];
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public SimpleLongIterator newSimpleLongIterator() {
            return new SimpleLongIterator(){
                int i = 0;

                @Override
                public long nextrpLong() throws StopIterationReturnPath {
                    int i = this.i;
                    if (i >= data.length) {
                        throw StopIterationReturnPath.I;
                    }
                    this.i = i + 1;
                    return data[i];
                }
            };
        }

        public ImmutableSortedLongSetBackedByArray clone() {
            return new ImmutableSortedLongSetBackedByArray((long[])this.data.clone());
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int compareTo(ImmutableSortedLongSetBackedByArray o) {
            return ArrayUtilities.compareLittleEndianLengthsFirst(this.data, o.data);
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Set)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableSortedLongSetBackedByArray ? Arrays.equals(this.data, ((ImmutableSortedLongSetBackedByArray)obj).data) : this.equivalent(obj);
        }
    }

    @HashableType
    public static class ImmutableSortedShortSetBackedByArray
    implements Serializable,
    Comparable<ImmutableSortedShortSetBackedByArray>,
    ShortSet,
    KnowsLengthFixedness,
    RandomAccess,
    ValueType,
    RuntimeImmutability {
        private static final long serialVersionUID = 1L;
        protected short[] data;
        protected volatile transient boolean hashCodeIsCached;
        protected volatile transient int hashCodeCache;

        public ImmutableSortedShortSetBackedByArray(@LiveValue short[] presortedOrEmptyUnderlying) {
            this.data = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static ImmutableSortedShortSetBackedByArray sorted(@ReadonlyValue @SnapshotValue Collection<Short> c) {
            short[] a = PrimitiveCollections.toShortArray(c);
            Arrays.sort(a);
            return new ImmutableSortedShortSetBackedByArray(a);
        }

        @ImplementationTransparency
        @LiveValue
        @ReadonlyValue
        public short[] getREADONLYLiveWholeArrayBackingUNSAFE() {
            return this.data;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return true;
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Concurrently_Immutable;
        }

        @Override
        public boolean addShort(short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public int indexOfShort(short value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.data, 0, this.size(), value);
        }

        @Override
        public boolean removeShort(short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean containsShort(short value) {
            return this.indexOfShort(value) != -1;
        }

        public boolean equivalent(ImmutableSortedShortSetBackedByArray other) {
            return Arrays.equals(this.data, other.data);
        }

        @Override
        public short[] toShortArray() {
            return this.toSortedShortArray();
        }

        @ThrowAwayValue
        public short[] toSortedShortArray() {
            return (short[])this.data.clone();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.data.length;
        }

        public short removeShortByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        public void removeRange(int start, int end) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        public short getShort(int index) {
            return this.data[index];
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public SimpleShortIterator newSimpleShortIterator() {
            return new SimpleShortIterator(){
                int i = 0;

                @Override
                public short nextrpShort() throws StopIterationReturnPath {
                    int i = this.i;
                    if (i >= data.length) {
                        throw StopIterationReturnPath.I;
                    }
                    this.i = i + 1;
                    return data[i];
                }
            };
        }

        public ImmutableSortedShortSetBackedByArray clone() {
            return new ImmutableSortedShortSetBackedByArray((short[])this.data.clone());
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public int compareTo(ImmutableSortedShortSetBackedByArray o) {
            return ArrayUtilities.compareLittleEndianLengthsFirst(this.data, o.data);
        }

        @Override
        public int hashCode() {
            int h;
            if (this.hashCodeIsCached) {
                return this.hashCodeCache;
            }
            this.hashCodeCache = h = this.hashCodeOfContents();
            this.hashCodeIsCached = true;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Set)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return obj instanceof ImmutableSortedShortSetBackedByArray ? Arrays.equals(this.data, ((ImmutableSortedShortSetBackedByArray)obj).data) : this.equivalent(obj);
        }
    }

    public static class IntegerArrayList
    implements DefaultShiftingBasedIntegerList,
    ListWithSetSize<Integer>,
    Trimmable,
    TransparentContiguousArrayBackedCollection<int[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected int size = 0;
        protected int[] data;
        protected Grower.GrowerComputationallyUnreducedPurelyRecursive grower;

        protected IntegerArrayList(Void thisiswhyyoushouldntusejavaconstructorsAlthoughIdontknowhowtomakeinheritanceworkwellwithoutinitmethodsorfactoriesorsomething) {
        }

        public IntegerArrayList(int initialCapacity, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = initialCapacity == 0 ? ArrayUtilities.EmptyIntArray : new int[initialCapacity];
            this.grower = grower;
        }

        public IntegerArrayList(@LiveValue @WritableValue int[] LIVEBACKING, int size, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = LIVEBACKING;
            this.grower = grower;
            this.size = size;
        }

        public IntegerArrayList(@SnapshotValue @ReadonlyValue Collection<Integer> c, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this(c.size(), grower);
            this.addAll((Collection<? extends Integer>)c);
        }

        public IntegerArrayList() {
            this(16);
        }

        public IntegerArrayList(int initialCapacity) {
            this(initialCapacity, PrimitiveCollections.defaultPrimitiveArrayListGrower(initialCapacity));
        }

        public IntegerArrayList(@SnapshotValue @ReadonlyValue Collection<Integer> c) {
            this(c, PrimitiveCollections.defaultPrimitiveArrayListGrower(c.size()));
        }

        public IntegerArrayList(@LiveValue @WritableValue int[] LIVEBACKING, int size) {
            this(LIVEBACKING, size, PrimitiveCollections.defaultPrimitiveArrayListGrower(LIVEBACKING.length));
        }

        public IntegerArrayList(@LiveValue @WritableValue int[] LIVEBACKING) {
            this(LIVEBACKING, LIVEBACKING.length);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return false;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public void setSize(int newSize) {
            this.ensureCapacity(newSize);
            this.size = newSize;
        }

        protected void setupClone(IntegerArrayList freshClone) {
            freshClone.size = this.size;
            freshClone.data = new int[this.size];
            System.arraycopy(this.data, 0, freshClone.data, 0, this.size);
            freshClone.grower = this.grower;
        }

        @Override
        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        public IntegerArrayList clone() {
            IntegerArrayList clone = new IntegerArrayList();
            this.setupClone(clone);
            return clone;
        }

        @Override
        @ImplementationTransparency
        @LiveValue
        public Slice<int[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<int[]>(this.data, 0, this.size);
        }

        public void sort() {
            PrimitiveCollections.sortArray(this.data, 0, this.size);
        }

        @Override
        public void setInt(int index, int value) {
            CollectionUtilities.rangeCheckMember(this.size, index);
            this.data[index] = value;
        }

        @Override
        public int getInt(int index) {
            CollectionUtilities.rangeCheckMember(this.size(), index);
            return this.data[index];
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public void clear() {
            this.size = 0;
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public int size() {
            return this.size;
        }

        @ImplementationTransparency
        public void trimToSize() {
            int[] newdata = new int[this.size];
            System.arraycopy(this.data, 0, newdata, 0, this.size);
            this.data = newdata;
        }

        @Override
        public Trimmable.TrimmableTrimRV couldYouMaybeUseALittleLessMemoryIfYouDontMind() {
            this.trimToSize();
            return Trimmable.TrimmableTrimRV.DontKeepInvoking;
        }

        @ImplementationTransparency
        public int getCapacity() {
            return this.data.length;
        }

        @ImplementationTransparency
        public void ensureCapacity(int minCapacity) {
            if (this.data.length < minCapacity) {
                int newCapacity = this.getNewCapacity(minCapacity);
                int[] newData = new int[newCapacity];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
        }

        @Override
        public void clearHinting(int newCapacity) {
            this.clear();
            this.ensureCapacity(newCapacity);
        }

        @ImplementationTransparency
        public int getNewCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new IllegalArgumentException();
            }
            return Math.max(minCapacity, this.grower.getNewSizeRecursive(this.data.length));
        }

        @ImplementationTransparency
        public void setDirectBuffer(@LiveValue int[] array) {
            if (array.length < this.size) {
                throw new IllegalArgumentException("Array is too small; size=" + this.size + ", capacity=" + array.length);
            }
            this.data = array;
        }

        public String toString() {
            return this._toString();
        }
    }

    @SignalType
    public static interface IntegerCollection
    extends PrimitiveCollection<Integer, int[]>,
    SimpleIntegerIterable {
        public boolean addInt(int var1);

        public boolean removeInt(int var1);

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class getPrimitiveType() {
            return Integer.TYPE;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<Integer> getBoxedType() {
            return Integer.class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<int[]> getArrayType() {
            return int[].class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Integer getDefaultElement() {
            return 0;
        }

        @ThrowAwayValue
        public static int[] defaultToIntArray(IntegerCollection collection) {
            int[] array = new int[collection.size()];
            SimpleIntegerIterator i = collection.newSimpleIntegerIterator();
            int index = 0;
            while (true) {
                try {
                    array[index] = i.nextrpInt();
                }
                catch (StopIterationReturnPath exc) {
                    break;
                }
                ++index;
            }
            return array;
        }

        @ThrowAwayValue
        default public int[] toIntArray() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<int[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof int[]) {
                    return ArrayUtilities.sliceToNewIntArrayOP(u);
                }
            }
            return IntegerCollection.defaultToIntArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public int[] toIntArrayPossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                int size = this.size();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                Object und = u.getUnderlying();
                if (und instanceof int[] && u.getOffset() == 0 && ((int[])und).length == size) {
                    return (int[])und;
                }
            }
            return IntegerCollection.defaultToIntArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public Slice<int[]> toIntArraySlicePossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<int[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof int[]) {
                    return u;
                }
            }
            return ArrayUtilities.wholeArraySliceInt(IntegerCollection.defaultToIntArray(this));
        }

        @LiveValue
        @Nullable
        default public Slice<int[]> toIntArraySliceLiveOrNull() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<int[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof int[]) {
                    return u;
                }
            }
            return null;
        }

        default public boolean containsInt(int value) {
            SimpleIntegerIterator i = this.newSimpleIntegerIterator();
            try {
                while (!Primitives.eqSane(i.nextrpInt(), value)) {
                }
                return true;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return false;
            }
        }

        @Override
        default public Iterator<Integer> iterator() {
            return SimpleIntegerIterable.super.iterator();
        }

        @Override
        default public boolean isEmpty() {
            return this.size() == 0;
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllInts(int[] array) {
            return this.addAllInts(array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllInts(Slice<int[]> arraySlice) {
            return this.addAllInts(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllInts(int[] elements, int offset, int length) {
            return IntegerCollection.defaultAddAllInts(this, elements, offset, length);
        }

        public static boolean defaultAddAllInts(IntegerCollection self, int[] elements, int offset, int length) {
            boolean changedAtAll = false;
            int e = offset + length;
            int i = offset;
            while (i < e) {
                changedAtAll |= self.addInt(elements[i]);
                ++i;
            }
            return changedAtAll;
        }

        default public void removeAllInts(int[] array) {
            this.removeAllInts(array, 0, array.length);
        }

        default public void removeAllInts(Slice<int[]> arraySlice) {
            this.removeAllInts(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public void removeAllInts(int[] a, int offset, int length) {
            int e = offset + length;
            int i = offset;
            while (i < e) {
                this.removeInt(a[i]);
                ++i;
            }
        }

        @Override
        default public boolean contains(Object o) {
            return o instanceof Integer && this.containsInt((Integer)o);
        }

        @Override
        default public boolean add(Integer e) {
            return this.addInt(e);
        }

        @Override
        default public boolean remove(Object o) {
            return o instanceof Integer && this.removeInt((Integer)o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            if (c instanceof IntegerCollection) {
                IntegerCollection cc = (IntegerCollection)c;
                SimpleIntegerIterator i = cc.newSimpleIntegerIterator();
                try {
                    while (!this.containsInt(i.nextrpInt())) {
                    }
                    return true;
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return false;
                }
            }
            for (Object e : c) {
                if (!this.contains(e)) continue;
                return true;
            }
            return false;
        }

        @Override
        default public boolean addAll(Collection<? extends Integer> c) {
            if (c instanceof IntegerCollection) {
                boolean changedAtAll = false;
                SimpleIntegerIterator simpleIntegerIterator = ((IntegerCollection)c).newSimpleIntegerIterator();
                try {
                    while (true) {
                        changedAtAll |= this.add(simpleIntegerIterator.nextrpInt());
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Integer n : c) {
                changedAtAll |= this.add(n);
            }
            return changedAtAll;
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            if (c instanceof IntegerCollection) {
                boolean changedAtAll = false;
                SimpleIntegerIterator i = ((IntegerCollection)c).newSimpleIntegerIterator();
                try {
                    while (true) {
                        changedAtAll |= this.remove(i.nextrpInt());
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Object e : c) {
                changedAtAll |= this.remove(e);
            }
            return changedAtAll;
        }

        @Override
        default public void setFrom(Object source) {
            block8: {
                if (source == this) {
                    return;
                }
                if (source instanceof IntegerCollection) {
                    IntegerCollection s = (IntegerCollection)source;
                    this.clearHinting(s.size());
                    SimpleIntegerIterator i = s.newSimpleIntegerIterator();
                    while (true) {
                        int e;
                        try {
                            e = i.nextrpInt();
                        }
                        catch (StopIterationReturnPath exc) {
                            break block8;
                        }
                        this.addInt(e);
                    }
                }
                if (source instanceof Collection) {
                    Collection s = (Collection)source;
                    this.clearHinting(s.size());
                    for (Integer e : s) {
                        this.addInt(e);
                    }
                } else {
                    throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(source);
                }
            }
        }

        default public void clearHinting(int newCapacity) {
            this.clear();
        }

        @Override
        default public String _toString() {
            return PrimitiveCollections.defaultToString(this);
        }
    }

    @SignalType
    public static interface IntegerIntervalCollection
    extends IntegerCollection {
        @Override
        public int size();

        public int getLowerBoundInclusive();
    }

    @SignalType
    public static interface IntegerList
    extends PrimitiveList<Integer, int[]>,
    NonuniformMethodsForIntegerList,
    IntegerListRO,
    IntegerListRWFixed {
        @Override
        default public Iterator<Integer> iterator() {
            return NonuniformMethodsForIntegerList.super.iterator();
        }

        public void insertInt(int var1, int var2);

        public IntegerList clone();

        public void setSizeInt(int var1, int var2);

        @Override
        default public void setSize(int newSize, Integer elementToAddIfGrowing) {
            this.setSizeInt(newSize, elementToAddIfGrowing);
        }

        @Override
        default public void setSize(int newSize) {
            this.setSizeInt(newSize, 0);
        }

        @Override
        default public void clear() {
            this.setSize(0);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllInts(int index, int[] array) {
            this.setAllInts(index, array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllInts(int index, Slice<int[]> arraySlice) {
            this.setAllInts(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        default public void setAllInts(int start, int[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof int[]) {
                    Slice s = u;
                    System.arraycopy(array, offset, s.getUnderlying(), s.getOffset() + start, length);
                    return;
                }
            }
            IntegerList.defaultSetAllInts(this, start, array, offset, length);
        }

        public static void defaultSetAllInts(IntegerList list, int start, @WritableValue int[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                list.setInt(start + i, array[offset + i]);
                ++i;
            }
        }

        default public void setAll(int destIndex, List sourceU, int sourceIndex, @Nonnegative int amount) throws IndexOutOfBoundsException {
            List source = sourceU;
            IntegerList dest = this;
            int sourceSize = source.size();
            int destSize = dest.size();
            CollectionUtilities.rangeCheckIntervalByLength(sourceSize, sourceIndex, amount);
            CollectionUtilities.rangeCheckIntervalByLength(destSize, destIndex, amount);
            if (TransparentContiguousArrayBackedCollection.is(source)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)source)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(sourceSize, u);
                if (u.getUnderlying() instanceof int[]) {
                    Slice s = u;
                    this.setAllInts(destIndex, (Slice)s.subslice(sourceIndex, amount));
                    return;
                }
            }
            if (source instanceof IntegerList) {
                IntegerList primSource = (IntegerList)source;
                if (destIndex < sourceIndex) {
                    int i = 0;
                    while (i < amount) {
                        dest.setInt(destIndex + i, primSource.getInt(sourceIndex + i));
                        ++i;
                    }
                } else {
                    int i = amount - 1;
                    while (i >= 0) {
                        dest.setInt(destIndex + i, primSource.getInt(sourceIndex + i));
                        --i;
                    }
                }
            } else if (destIndex < sourceIndex) {
                int i = 0;
                while (i < amount) {
                    dest.set(destIndex + i, (Integer)source.get(sourceIndex + i));
                    ++i;
                }
            } else {
                int i = amount - 1;
                while (i >= 0) {
                    dest.set(destIndex + i, (Integer)source.get(sourceIndex + i));
                    --i;
                }
            }
        }

        default public void getAllInts(int start, @WritableValue int[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof int[]) {
                    Slice s = u;
                    System.arraycopy(s.getUnderlying(), s.getOffset() + start, array, offset, length);
                    return;
                }
            }
            IntegerList.defaultGetAllInts(this, start, array, offset, length);
        }

        public static void defaultGetAllInts(IntegerList list, int start, @WritableValue int[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                array[offset + i] = list.getInt(start + i);
                ++i;
            }
        }

        @ThrowAwayValue
        default public int[] getAllInts(int start, int end) {
            CollectionUtilities.rangeCheckInterval(this.size(), start, end);
            int[] buff = new int[end - start];
            this.getAllInts(start, buff, 0, buff.length);
            return buff;
        }

        @Override
        default public boolean addInt(int value) {
            this.insertInt(this.size(), value);
            return true;
        }

        @Override
        default public boolean addAll(Collection<? extends Integer> c) {
            this.addAll(this.size(), c);
            return true;
        }

        @Override
        default public boolean addAllInts(int[] elements, int offset, int length) {
            this.insertAllInts(this.size(), elements, offset, length);
            return true;
        }

        default public void removeByIndex(int index) {
            this.removeRange(index, index + 1);
        }

        default public int removeIntByIndex(int index) throws IndexOutOfBoundsException {
            int v = this.getInt(index);
            this.removeByIndex(index);
            return v;
        }

        @Override
        default public boolean removeInt(int value) {
            int i = this.indexOfInt(value);
            if (i != -1) {
                this.removeByIndex(i);
                return true;
            }
            return false;
        }

        @Override
        default public boolean retainAll(Collection<?> c) {
            if (c instanceof IntegerCollection) {
                IntegerCollection cc = (IntegerCollection)c;
                boolean changedAtAll = false;
                int i = this.size() - 1;
                while (i >= 0) {
                    if (!cc.containsInt(this.getInt(i))) {
                        this.removeIntByIndex(i);
                        changedAtAll = true;
                    }
                    --i;
                }
                return changedAtAll;
            }
            boolean changedAtAll = false;
            int i = this.size() - 1;
            while (i >= 0) {
                if (!c.contains(this.getInt(i))) {
                    this.removeIntByIndex(i);
                    changedAtAll = true;
                }
                --i;
            }
            return changedAtAll;
        }

        @Override
        default public SimpleIntegerIterator newSimpleIntegerIterator() {
            return new SimpleIntegerIterator(){
                int index = 0;

                @Override
                public int nextrpInt() throws StopIterationReturnPath {
                    int i = this.index;
                    if (i >= this.size()) {
                        throw StopIterationReturnPath.I;
                    }
                    this.index = i + 1;
                    return this.getInt(i);
                }
            };
        }

        @Override
        default public boolean containsInt(int value) {
            return this.indexOfInt(value) != -1;
        }

        default public void insertAllInts(int index, int[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                this.insertInt(index + i, array[offset + i]);
                ++i;
            }
        }

        @Override
        default public boolean addAll(int index, Collection<? extends Integer> c) {
            if (c instanceof IntegerCollection) {
                IntegerCollection integerCollection = (IntegerCollection)c;
                SimpleIntegerIterator i = integerCollection.newSimpleIntegerIterator();
                try {
                    while (true) {
                        this.insertInt(index, i.nextrpInt());
                        ++index;
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {}
            } else {
                for (Integer n : c) {
                    this.insertInt(index, n);
                    ++index;
                }
            }
            return true;
        }

        default public void insertAllInts(int index, int[] array) {
            this.insertAllInts(index, array, 0, array.length);
        }

        default public void insertAllInts(int index, Slice<int[]> arraySlice) {
            this.insertAllInts(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @Override
        default public Integer get(int index) {
            return this.getInt(index);
        }

        @Override
        default public Integer set(int index, Integer value) {
            Integer previous = this.get(index);
            this.setInt(index, value);
            return previous;
        }

        @Override
        default public void add(int index, Integer value) {
            this.insertInt(index, value);
        }

        @Override
        default public Integer remove(int index) throws IndexOutOfBoundsException {
            return this.removeIntByIndex(index);
        }

        @Override
        default public int indexOf(Object o) {
            return o instanceof Integer ? this.indexOfInt((Integer)o) : -1;
        }

        @Override
        default public int lastIndexOf(Object o) {
            return o instanceof Integer ? this.lastIndexOfInt((Integer)o) : -1;
        }

        default public int indexOf(Object o, int start) {
            return o instanceof Integer ? this.indexOfInt((Integer)o, start) : -1;
        }

        default public int lastIndexOf(Object o, int start) {
            return o instanceof Integer ? this.lastIndexOfInt((Integer)o, start) : -1;
        }

        @Override
        default public ListIterator<Integer> listIterator() {
            return this.listIterator(0);
        }

        @Override
        default public ListIterator<Integer> listIterator(int index) {
            return new DelegatingListIterator<Integer>(this, index);
        }

        default public IntegerList subList(int fromIndex, int toIndex) {
            if (fromIndex == 0 && toIndex == this.size()) {
                return this;
            }
            if (this instanceof Sublist) {
                Sublist s = (Sublist)((Object)this);
                return new IntegerSublist((IntegerList)s.getUnderlying(), s.getSublistStartingIndex() + fromIndex, toIndex - fromIndex);
            }
            return new IntegerSublist(this, fromIndex, toIndex - fromIndex);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForIntegerList.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForIntegerList.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForIntegerList.super.containsAll(c);
        }

        @Override
        default public boolean add(Integer e) {
            return NonuniformMethodsForIntegerList.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForIntegerList.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForIntegerList.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveList.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForIntegerList.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForIntegerList.super.toArray(a);
        }

        @Override
        default public void storeBoxingIntoArray(Slice<Object[]> array) {
            int n = this.size();
            int i = 0;
            while (i < n) {
                ArrayUtilities.setReference(array, i, this.get(i));
                ++i;
            }
        }

        default public boolean endsWith(List<Integer> suffixCandidate) {
            return this.size() >= suffixCandidate.size() && this.subListToEnd(suffixCandidate.size()).equivalent(suffixCandidate);
        }

        default public boolean startsWith(List<Integer> prefixCandidate) {
            return this.size() >= prefixCandidate.size() && this.subListFromBeginning(prefixCandidate.size()).equivalent(prefixCandidate);
        }

        default public IntegerList subListToEnd(int start) {
            return (IntegerList)PrimitiveList.super.subListToEnd(start);
        }

        default public IntegerList subListFromBeginning(int lengthWhichIsEndExclusiveInThisCaseXD) {
            return (IntegerList)PrimitiveList.super.subListFromBeginning(lengthWhichIsEndExclusiveInThisCaseXD);
        }

        default public IntegerList subListByLength(int start, int length) {
            return (IntegerList)PrimitiveList.super.subListByLength(start, length);
        }

        @Override
        default public void fillBySetting(int start, int count, Integer value) {
            this.fillBySettingInt(start, count, value);
        }

        default public void fillBySettingInt(int value) {
            this.fillBySettingInt(0, this.size(), value);
        }

        default public void fillBySettingInt(int start, int count, int value) {
            CollectionUtilities.rangeCheckIntervalByLength(this.size(), start, count);
            if (count >= 100) {
                int[] array = new int[SmallIntegerMathUtilities.least(count, 1024)];
                if (value != 0) {
                    Arrays.fill(array, value);
                }
                int al = array.length;
                IntegerList l = PrimitiveCollections.intArrayAsList(array);
                while (count > al) {
                    this.setAll(start, l);
                    start += al;
                    count -= al;
                }
                if (count > 0) {
                    this.setAll(start, l.subList(0, count));
                }
            } else {
                int e = start + count;
                int i = start;
                while (i < e) {
                    this.setInt(i, value);
                    ++i;
                }
            }
        }
    }

    @SignalType
    public static interface IntegerListRO
    extends Equivalenceable {
        public int getInt(int var1);

        public int size();

        default public int indexOfInt(int value) {
            return this.indexOfInt(value, 0);
        }

        default public int lastIndexOfInt(int value) {
            return this.lastIndexOfInt(value, this.size() - 1);
        }

        default public int indexOfInt(int value, int start) {
            int n = this.size();
            int i = start;
            while (i < n) {
                if (Primitives.eqSane(this.getInt(i), value)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        default public int lastIndexOfInt(int value, int start) {
            int i = start;
            if (i >= 0 && Primitives.eqSane(this.getInt(i), value)) {
                return i;
            }
            return i;
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof IntegerListRO) {
                return this.equivalentFixedRO((IntegerListRO)o);
            }
            if (o instanceof List) {
                List other = (List)o;
                int size = this.size();
                if (other.size() != size) {
                    return false;
                }
                int i = 0;
                while (i < size) {
                    Object e = other.get(i);
                    if (e instanceof Integer) {
                        if (!Primitives.eqSane(this.getInt(i), (Integer)e)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalentFixedRO(IntegerListRO other) {
            int size = this.size();
            if (other.size() != size) {
                return false;
            }
            int i = 0;
            while (i < size) {
                if (!Primitives.eqSane(this.getInt(i), other.getInt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            int size = this.size();
            int i = 0;
            while (i < size) {
                int e = this.getInt(i);
                r = 31 * r + Primitives.hashprim(e);
                ++i;
            }
            return r;
        }
    }

    @SignalType
    public static interface IntegerListRWFixed
    extends IntegerListRO {
        public void setInt(int var1, int var2);
    }

    public static class IntegerListWrapper
    implements IntegerList {
        protected final List<Integer> underlying;

        public IntegerListWrapper(List<Integer> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithRemoveRange) {
                ((ListWithRemoveRange)((Object)this.underlying)).removeRange(start, pastEnd);
            } else {
                IntegerList.super.removeRange(start, pastEnd);
            }
        }

        @Override
        public void setSize(int newSize, Integer elementToAddIfGrowing) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize, elementToAddIfGrowing);
            } else {
                IntegerList.super.setSize(newSize, elementToAddIfGrowing);
            }
        }

        @Override
        public void setSize(int newSize) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize);
            } else {
                IntegerList.super.setSize(newSize);
            }
        }

        @Override
        public void setAll(int destIndex, List source, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithSetAll) {
                ((ListWithSetAll)((Object)this.underlying)).setAll(destIndex, source, sourceIndex, amount);
            } else {
                IntegerList.super.setAll(destIndex, source, sourceIndex, amount);
            }
        }

        @Override
        public void fillBySetting(int start, int count, Integer value) {
            if (this.underlying instanceof ListWithFill) {
                ((ListWithFill)this.underlying).fillBySetting(start, count, value);
            } else {
                IntegerList.super.fillBySetting(start, count, value);
            }
        }

        @Override
        public IntegerList clone() {
            return PrimitiveCollections.asIntegerList(ObjectUtilities.attemptClone(this.underlying));
        }

        @Override
        public int getInt(int index) {
            return this.get(index);
        }

        @Override
        public void setInt(int index, int value) {
            this.set(index, value);
        }

        @Override
        public void insertInt(int index, int value) {
            this.add(index, value);
        }

        @Override
        public void setSizeInt(int newSize, int elementToAddIfGrowing) {
            this.setSize(newSize, elementToAddIfGrowing);
        }

        @Override
        public void forEach(Consumer<? super Integer> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Integer e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Integer> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Integer> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Integer> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Integer> c) {
            this.underlying.sort(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public Integer get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Integer set(int index, Integer element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Integer element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Integer> stream() {
            return this.underlying.stream();
        }

        @Override
        public Integer remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Integer> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public Spliterator<Integer> spliterator() {
            return this.underlying.spliterator();
        }
    }

    @SignalType
    public static interface IntegerSet
    extends PrimitiveSet<Integer, int[]>,
    NonuniformMethodsForIntegerSet {
        @Override
        default public Iterator<Integer> iterator() {
            return NonuniformMethodsForIntegerSet.super.iterator();
        }

        @Override
        default public boolean addAll(Collection<? extends Integer> c) {
            return NonuniformMethodsForIntegerSet.super.addAll(c);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForIntegerSet.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForIntegerSet.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForIntegerSet.super.containsAll(c);
        }

        @Override
        default public boolean add(Integer e) {
            return NonuniformMethodsForIntegerSet.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForIntegerSet.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForIntegerSet.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveSet.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForIntegerSet.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForIntegerSet.super.toArray(a);
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof IntegerSet) {
                return this.equivalent((IntegerSet)o);
            }
            if (o instanceof Set) {
                int bs;
                Set a = (Set)o;
                IntegerSet b = this;
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                int as = a.size();
                if (as != (bs = b.size())) {
                    return false;
                }
                if (CodeHinting.arbitrary(as, bs) == 0) {
                    return true;
                }
                for (Object an : a) {
                    if (an instanceof Integer) {
                        if (b.containsInt((Integer)an)) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalent(IntegerSet other) {
            int bs;
            IntegerSet a = this;
            IntegerSet b = other;
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            int as = a.size();
            if (as != (bs = b.size())) {
                return false;
            }
            if (CodeHinting.arbitrary(as, bs) == 0) {
                return true;
            }
            SimpleIntegerIterator i = a.newSimpleIntegerIterator();
            try {
                while (b.containsInt(i.nextrpInt())) {
                }
                return false;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return true;
            }
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            SimpleIntegerIterator i = this.newSimpleIntegerIterator();
            try {
                while (true) {
                    r += Primitives.hashprim(i.nextrpInt());
                }
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return r;
            }
        }
    }

    public static class IntegerSublist
    implements IntegerList,
    DefaultShiftingBasedIntegerList,
    Sublist<Integer>,
    ShiftableList {
        protected final IntegerList underlying;
        protected final int start;
        protected int size;

        public IntegerSublist(IntegerList underlying, int start, int initialSize) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.size(), start, initialSize);
            this.underlying = underlying;
            this.start = start;
            this.size = initialSize;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int getInt(int index) {
            return this.underlying.getInt(index + this.start);
        }

        @Override
        public void setInt(int index, int value) {
            this.underlying.setInt(index + this.start, value);
        }

        @Override
        public void shiftRegionStretchingFromIndexToEndByAmountChangingSize(int start, int amount) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), start);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this.underlying, start, amount);
            this.size += amount;
        }

        @Override
        public IntegerList clone() {
            IntegerArrayList c = new IntegerArrayList();
            c.addAll(this);
            return c;
        }

        @Override
        public IntegerList getUnderlying() {
            return this.underlying;
        }

        @Override
        public int getSublistStartingIndex() {
            return this.start;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public Boolean isWritableCollection() {
            return this.underlying.isWritableCollection();
        }
    }

    public static class IntegerTable {
        protected int width;
        protected int[] data;

        public IntegerTable(int width, int height) {
            if (width < 0) {
                throw new IllegalArgumentException();
            }
            if (height < 0) {
                throw new IllegalArgumentException();
            }
            this.data = new int[width * height];
        }

        @Nonnegative
        public int getNumberOfColumns() {
            return this.width;
        }

        @Nonnegative
        public int getNumberOfRows() {
            return this.data.length / this.width;
        }

        @Nonnegative
        public int getNumberOfCells() {
            return this.data.length;
        }

        public int getCellContentsInteger(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            return this.data[rowIndex * this.getNumberOfColumns() + columnIndex];
        }

        public void setCellContentsInteger(int columnIndex, int rowIndex, @Nullable int newValue) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            this.data[rowIndex * this.getNumberOfColumns() + columnIndex] = newValue;
        }

        @Nullable
        public Integer getCellContents(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            return this.getCellContentsInteger(columnIndex, rowIndex);
        }

        public void setCellContents(int columnIndex, int rowIndex, @Nullable Integer newValue) throws IndexOutOfBoundsException {
            this.setCellContentsInteger(columnIndex, rowIndex, newValue);
        }
    }

    public static class LongArrayList
    implements DefaultShiftingBasedLongList,
    ListWithSetSize<Long>,
    Trimmable,
    TransparentContiguousArrayBackedCollection<long[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected int size = 0;
        protected long[] data;
        protected Grower.GrowerComputationallyUnreducedPurelyRecursive grower;

        protected LongArrayList(Void thisiswhyyoushouldntusejavaconstructorsAlthoughIdontknowhowtomakeinheritanceworkwellwithoutinitmethodsorfactoriesorsomething) {
        }

        public LongArrayList(int initialCapacity, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = initialCapacity == 0 ? ArrayUtilities.EmptyLongArray : new long[initialCapacity];
            this.grower = grower;
        }

        public LongArrayList(@LiveValue @WritableValue long[] LIVEBACKING, int size, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = LIVEBACKING;
            this.grower = grower;
            this.size = size;
        }

        public LongArrayList(@SnapshotValue @ReadonlyValue Collection<Long> c, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this(c.size(), grower);
            this.addAll((Collection<? extends Long>)c);
        }

        public LongArrayList() {
            this(16);
        }

        public LongArrayList(int initialCapacity) {
            this(initialCapacity, PrimitiveCollections.defaultPrimitiveArrayListGrower(initialCapacity));
        }

        public LongArrayList(@SnapshotValue @ReadonlyValue Collection<Long> c) {
            this(c, PrimitiveCollections.defaultPrimitiveArrayListGrower(c.size()));
        }

        public LongArrayList(@LiveValue @WritableValue long[] LIVEBACKING, int size) {
            this(LIVEBACKING, size, PrimitiveCollections.defaultPrimitiveArrayListGrower(LIVEBACKING.length));
        }

        public LongArrayList(@LiveValue @WritableValue long[] LIVEBACKING) {
            this(LIVEBACKING, LIVEBACKING.length);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return false;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public void setSize(int newSize) {
            this.ensureCapacity(newSize);
            this.size = newSize;
        }

        protected void setupClone(LongArrayList freshClone) {
            freshClone.size = this.size;
            freshClone.data = new long[this.size];
            System.arraycopy(this.data, 0, freshClone.data, 0, this.size);
            freshClone.grower = this.grower;
        }

        @Override
        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        public LongArrayList clone() {
            LongArrayList clone = new LongArrayList();
            this.setupClone(clone);
            return clone;
        }

        @Override
        @ImplementationTransparency
        @LiveValue
        public Slice<long[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<long[]>(this.data, 0, this.size);
        }

        public void sort() {
            PrimitiveCollections.sortArray(this.data, 0, this.size);
        }

        @Override
        public void setLong(int index, long value) {
            CollectionUtilities.rangeCheckMember(this.size, index);
            this.data[index] = value;
        }

        @Override
        public long getLong(int index) {
            CollectionUtilities.rangeCheckMember(this.size(), index);
            return this.data[index];
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public void clear() {
            this.size = 0;
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public int size() {
            return this.size;
        }

        @ImplementationTransparency
        public void trimToSize() {
            long[] newdata = new long[this.size];
            System.arraycopy(this.data, 0, newdata, 0, this.size);
            this.data = newdata;
        }

        @Override
        public Trimmable.TrimmableTrimRV couldYouMaybeUseALittleLessMemoryIfYouDontMind() {
            this.trimToSize();
            return Trimmable.TrimmableTrimRV.DontKeepInvoking;
        }

        @ImplementationTransparency
        public int getCapacity() {
            return this.data.length;
        }

        @ImplementationTransparency
        public void ensureCapacity(int minCapacity) {
            if (this.data.length < minCapacity) {
                int newCapacity = this.getNewCapacity(minCapacity);
                long[] newData = new long[newCapacity];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
        }

        @Override
        public void clearHinting(int newCapacity) {
            this.clear();
            this.ensureCapacity(newCapacity);
        }

        @ImplementationTransparency
        public int getNewCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new IllegalArgumentException();
            }
            return Math.max(minCapacity, this.grower.getNewSizeRecursive(this.data.length));
        }

        @ImplementationTransparency
        public void setDirectBuffer(@LiveValue long[] array) {
            if (array.length < this.size) {
                throw new IllegalArgumentException("Array is too small; size=" + this.size + ", capacity=" + array.length);
            }
            this.data = array;
        }

        public String toString() {
            return this._toString();
        }
    }

    @SignalType
    public static interface LongCollection
    extends PrimitiveCollection<Long, long[]>,
    SimpleLongIterable {
        public boolean addLong(long var1);

        public boolean removeLong(long var1);

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class getPrimitiveType() {
            return Long.TYPE;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<Long> getBoxedType() {
            return Long.class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<long[]> getArrayType() {
            return long[].class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Long getDefaultElement() {
            return 0L;
        }

        @ThrowAwayValue
        public static long[] defaultToLongArray(LongCollection collection) {
            long[] array = new long[collection.size()];
            SimpleLongIterator i = collection.newSimpleLongIterator();
            int index = 0;
            while (true) {
                try {
                    array[index] = i.nextrpLong();
                }
                catch (StopIterationReturnPath exc) {
                    break;
                }
                ++index;
            }
            return array;
        }

        @ThrowAwayValue
        default public long[] toLongArray() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<long[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof long[]) {
                    return ArrayUtilities.sliceToNewLongArrayOP(u);
                }
            }
            return LongCollection.defaultToLongArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public long[] toLongArrayPossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                int size = this.size();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                Object und = u.getUnderlying();
                if (und instanceof long[] && u.getOffset() == 0 && ((long[])und).length == size) {
                    return (long[])und;
                }
            }
            return LongCollection.defaultToLongArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public Slice<long[]> toLongArraySlicePossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<long[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof long[]) {
                    return u;
                }
            }
            return ArrayUtilities.wholeArraySliceLong(LongCollection.defaultToLongArray(this));
        }

        @LiveValue
        @Nullable
        default public Slice<long[]> toLongArraySliceLiveOrNull() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<long[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof long[]) {
                    return u;
                }
            }
            return null;
        }

        default public boolean containsLong(long value) {
            SimpleLongIterator i = this.newSimpleLongIterator();
            try {
                while (!Primitives.eqSane(i.nextrpLong(), value)) {
                }
                return true;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return false;
            }
        }

        @Override
        default public Iterator<Long> iterator() {
            return SimpleLongIterable.super.iterator();
        }

        @Override
        default public boolean isEmpty() {
            return this.size() == 0;
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllLongs(long[] array) {
            return this.addAllLongs(array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllLongs(Slice<long[]> arraySlice) {
            return this.addAllLongs(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllLongs(long[] elements, int offset, int length) {
            return LongCollection.defaultAddAllLongs(this, elements, offset, length);
        }

        public static boolean defaultAddAllLongs(LongCollection self, long[] elements, int offset, int length) {
            boolean changedAtAll = false;
            int e = offset + length;
            int i = offset;
            while (i < e) {
                changedAtAll |= self.addLong(elements[i]);
                ++i;
            }
            return changedAtAll;
        }

        default public void removeAllLongs(long[] array) {
            this.removeAllLongs(array, 0, array.length);
        }

        default public void removeAllLongs(Slice<long[]> arraySlice) {
            this.removeAllLongs(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public void removeAllLongs(long[] a, int offset, int length) {
            int e = offset + length;
            int i = offset;
            while (i < e) {
                this.removeLong(a[i]);
                ++i;
            }
        }

        @Override
        default public boolean contains(Object o) {
            return o instanceof Long && this.containsLong((Long)o);
        }

        @Override
        default public boolean add(Long e) {
            return this.addLong(e);
        }

        @Override
        default public boolean remove(Object o) {
            return o instanceof Long && this.removeLong((Long)o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            if (c instanceof LongCollection) {
                LongCollection cc = (LongCollection)c;
                SimpleLongIterator i = cc.newSimpleLongIterator();
                try {
                    while (!this.containsLong(i.nextrpLong())) {
                    }
                    return true;
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return false;
                }
            }
            for (Object e : c) {
                if (!this.contains(e)) continue;
                return true;
            }
            return false;
        }

        @Override
        default public boolean addAll(Collection<? extends Long> c) {
            if (c instanceof LongCollection) {
                boolean changedAtAll = false;
                SimpleLongIterator simpleLongIterator = ((LongCollection)c).newSimpleLongIterator();
                try {
                    while (true) {
                        changedAtAll |= this.add(simpleLongIterator.nextrpLong());
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Long l : c) {
                changedAtAll |= this.add(l);
            }
            return changedAtAll;
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            if (c instanceof LongCollection) {
                boolean changedAtAll = false;
                SimpleLongIterator i = ((LongCollection)c).newSimpleLongIterator();
                try {
                    while (true) {
                        changedAtAll |= this.remove(i.nextrpLong());
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Object e : c) {
                changedAtAll |= this.remove(e);
            }
            return changedAtAll;
        }

        @Override
        default public void setFrom(Object source) {
            block8: {
                if (source == this) {
                    return;
                }
                if (source instanceof LongCollection) {
                    LongCollection s = (LongCollection)source;
                    this.clearHinting(s.size());
                    SimpleLongIterator i = s.newSimpleLongIterator();
                    while (true) {
                        long e;
                        try {
                            e = i.nextrpLong();
                        }
                        catch (StopIterationReturnPath exc) {
                            break block8;
                        }
                        this.addLong(e);
                    }
                }
                if (source instanceof Collection) {
                    Collection s = (Collection)source;
                    this.clearHinting(s.size());
                    for (Long e : s) {
                        this.addLong(e);
                    }
                } else {
                    throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(source);
                }
            }
        }

        default public void clearHinting(int newCapacity) {
            this.clear();
        }

        @Override
        default public String _toString() {
            return PrimitiveCollections.defaultToString(this);
        }
    }

    @SignalType
    public static interface LongIntervalCollection
    extends LongCollection {
        @Override
        public int size();

        public long getLowerBoundInclusive();
    }

    @SignalType
    public static interface LongList
    extends PrimitiveList<Long, long[]>,
    NonuniformMethodsForLongList,
    LongListRO,
    LongListRWFixed {
        @Override
        default public Iterator<Long> iterator() {
            return NonuniformMethodsForLongList.super.iterator();
        }

        public void insertLong(int var1, long var2);

        public LongList clone();

        public void setSizeLong(int var1, long var2);

        @Override
        default public void setSize(int newSize, Long elementToAddIfGrowing) {
            this.setSizeLong(newSize, elementToAddIfGrowing);
        }

        @Override
        default public void setSize(int newSize) {
            this.setSizeLong(newSize, 0L);
        }

        @Override
        default public void clear() {
            this.setSize(0);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllLongs(int index, long[] array) {
            this.setAllLongs(index, array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllLongs(int index, Slice<long[]> arraySlice) {
            this.setAllLongs(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        default public void setAllLongs(int start, long[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof long[]) {
                    Slice s = u;
                    System.arraycopy(array, offset, s.getUnderlying(), s.getOffset() + start, length);
                    return;
                }
            }
            LongList.defaultSetAllLongs(this, start, array, offset, length);
        }

        public static void defaultSetAllLongs(LongList list, int start, @WritableValue long[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                list.setLong(start + i, array[offset + i]);
                ++i;
            }
        }

        default public void setAll(int destIndex, List sourceU, int sourceIndex, @Nonnegative int amount) throws IndexOutOfBoundsException {
            List source = sourceU;
            LongList dest = this;
            int sourceSize = source.size();
            int destSize = dest.size();
            CollectionUtilities.rangeCheckIntervalByLength(sourceSize, sourceIndex, amount);
            CollectionUtilities.rangeCheckIntervalByLength(destSize, destIndex, amount);
            if (TransparentContiguousArrayBackedCollection.is(source)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)source)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(sourceSize, u);
                if (u.getUnderlying() instanceof long[]) {
                    Slice s = u;
                    this.setAllLongs(destIndex, (Slice)s.subslice(sourceIndex, amount));
                    return;
                }
            }
            if (source instanceof LongList) {
                LongList primSource = (LongList)source;
                if (destIndex < sourceIndex) {
                    int i = 0;
                    while (i < amount) {
                        dest.setLong(destIndex + i, primSource.getLong(sourceIndex + i));
                        ++i;
                    }
                } else {
                    int i = amount - 1;
                    while (i >= 0) {
                        dest.setLong(destIndex + i, primSource.getLong(sourceIndex + i));
                        --i;
                    }
                }
            } else if (destIndex < sourceIndex) {
                int i = 0;
                while (i < amount) {
                    dest.set(destIndex + i, (Long)source.get(sourceIndex + i));
                    ++i;
                }
            } else {
                int i = amount - 1;
                while (i >= 0) {
                    dest.set(destIndex + i, (Long)source.get(sourceIndex + i));
                    --i;
                }
            }
        }

        default public void getAllLongs(int start, @WritableValue long[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof long[]) {
                    Slice s = u;
                    System.arraycopy(s.getUnderlying(), s.getOffset() + start, array, offset, length);
                    return;
                }
            }
            LongList.defaultGetAllLongs(this, start, array, offset, length);
        }

        public static void defaultGetAllLongs(LongList list, int start, @WritableValue long[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                array[offset + i] = list.getLong(start + i);
                ++i;
            }
        }

        @ThrowAwayValue
        default public long[] getAllLongs(int start, int end) {
            CollectionUtilities.rangeCheckInterval(this.size(), start, end);
            long[] buff = new long[end - start];
            this.getAllLongs(start, buff, 0, buff.length);
            return buff;
        }

        @Override
        default public boolean addLong(long value) {
            this.insertLong(this.size(), value);
            return true;
        }

        @Override
        default public boolean addAll(Collection<? extends Long> c) {
            this.addAll(this.size(), c);
            return true;
        }

        @Override
        default public boolean addAllLongs(long[] elements, int offset, int length) {
            this.insertAllLongs(this.size(), elements, offset, length);
            return true;
        }

        default public void removeByIndex(int index) {
            this.removeRange(index, index + 1);
        }

        default public long removeLongByIndex(int index) throws IndexOutOfBoundsException {
            long v = this.getLong(index);
            this.removeByIndex(index);
            return v;
        }

        @Override
        default public boolean removeLong(long value) {
            int i = this.indexOfLong(value);
            if (i != -1) {
                this.removeByIndex(i);
                return true;
            }
            return false;
        }

        @Override
        default public boolean retainAll(Collection<?> c) {
            if (c instanceof LongCollection) {
                LongCollection cc = (LongCollection)c;
                boolean changedAtAll = false;
                int i = this.size() - 1;
                while (i >= 0) {
                    if (!cc.containsLong(this.getLong(i))) {
                        this.removeLongByIndex(i);
                        changedAtAll = true;
                    }
                    --i;
                }
                return changedAtAll;
            }
            boolean changedAtAll = false;
            int i = this.size() - 1;
            while (i >= 0) {
                if (!c.contains(this.getLong(i))) {
                    this.removeLongByIndex(i);
                    changedAtAll = true;
                }
                --i;
            }
            return changedAtAll;
        }

        @Override
        default public SimpleLongIterator newSimpleLongIterator() {
            return new SimpleLongIterator(){
                int index = 0;

                @Override
                public long nextrpLong() throws StopIterationReturnPath {
                    int i = this.index;
                    if (i >= this.size()) {
                        throw StopIterationReturnPath.I;
                    }
                    this.index = i + 1;
                    return this.getLong(i);
                }
            };
        }

        @Override
        default public boolean containsLong(long value) {
            return this.indexOfLong(value) != -1;
        }

        default public void insertAllLongs(int index, long[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                this.insertLong(index + i, array[offset + i]);
                ++i;
            }
        }

        @Override
        default public boolean addAll(int index, Collection<? extends Long> c) {
            if (c instanceof LongCollection) {
                LongCollection longCollection = (LongCollection)c;
                SimpleLongIterator i = longCollection.newSimpleLongIterator();
                try {
                    while (true) {
                        this.insertLong(index, i.nextrpLong());
                        ++index;
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {}
            } else {
                for (Long l : c) {
                    this.insertLong(index, l);
                    ++index;
                }
            }
            return true;
        }

        default public void insertAllLongs(int index, long[] array) {
            this.insertAllLongs(index, array, 0, array.length);
        }

        default public void insertAllLongs(int index, Slice<long[]> arraySlice) {
            this.insertAllLongs(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @Override
        default public Long get(int index) {
            return this.getLong(index);
        }

        @Override
        default public Long set(int index, Long value) {
            Long previous = this.get(index);
            this.setLong(index, value);
            return previous;
        }

        @Override
        default public void add(int index, Long value) {
            this.insertLong(index, value);
        }

        @Override
        default public Long remove(int index) throws IndexOutOfBoundsException {
            return this.removeLongByIndex(index);
        }

        @Override
        default public int indexOf(Object o) {
            return o instanceof Long ? this.indexOfLong((Long)o) : -1;
        }

        @Override
        default public int lastIndexOf(Object o) {
            return o instanceof Long ? this.lastIndexOfLong((Long)o) : -1;
        }

        default public int indexOf(Object o, int start) {
            return o instanceof Long ? this.indexOfLong((Long)o, start) : -1;
        }

        default public int lastIndexOf(Object o, int start) {
            return o instanceof Long ? this.lastIndexOfLong((Long)o, start) : -1;
        }

        @Override
        default public ListIterator<Long> listIterator() {
            return this.listIterator(0);
        }

        @Override
        default public ListIterator<Long> listIterator(int index) {
            return new DelegatingListIterator<Long>(this, index);
        }

        default public LongList subList(int fromIndex, int toIndex) {
            if (fromIndex == 0 && toIndex == this.size()) {
                return this;
            }
            if (this instanceof Sublist) {
                Sublist s = (Sublist)((Object)this);
                return new LongSublist((LongList)s.getUnderlying(), s.getSublistStartingIndex() + fromIndex, toIndex - fromIndex);
            }
            return new LongSublist(this, fromIndex, toIndex - fromIndex);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForLongList.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForLongList.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForLongList.super.containsAll(c);
        }

        @Override
        default public boolean add(Long e) {
            return NonuniformMethodsForLongList.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForLongList.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForLongList.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveList.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForLongList.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForLongList.super.toArray(a);
        }

        @Override
        default public void storeBoxingIntoArray(Slice<Object[]> array) {
            int n = this.size();
            int i = 0;
            while (i < n) {
                ArrayUtilities.setReference(array, i, this.get(i));
                ++i;
            }
        }

        default public boolean endsWith(List<Long> suffixCandidate) {
            return this.size() >= suffixCandidate.size() && this.subListToEnd(suffixCandidate.size()).equivalent(suffixCandidate);
        }

        default public boolean startsWith(List<Long> prefixCandidate) {
            return this.size() >= prefixCandidate.size() && this.subListFromBeginning(prefixCandidate.size()).equivalent(prefixCandidate);
        }

        default public LongList subListToEnd(int start) {
            return (LongList)PrimitiveList.super.subListToEnd(start);
        }

        default public LongList subListFromBeginning(int lengthWhichIsEndExclusiveInThisCaseXD) {
            return (LongList)PrimitiveList.super.subListFromBeginning(lengthWhichIsEndExclusiveInThisCaseXD);
        }

        default public LongList subListByLength(int start, int length) {
            return (LongList)PrimitiveList.super.subListByLength(start, length);
        }

        @Override
        default public void fillBySetting(int start, int count, Long value) {
            this.fillBySettingLong(start, count, value);
        }

        default public void fillBySettingLong(long value) {
            this.fillBySettingLong(0, this.size(), value);
        }

        default public void fillBySettingLong(int start, int count, long value) {
            CollectionUtilities.rangeCheckIntervalByLength(this.size(), start, count);
            if (count >= 100) {
                long[] array = new long[SmallIntegerMathUtilities.least(count, 1024)];
                if (value != 0L) {
                    Arrays.fill(array, value);
                }
                int al = array.length;
                LongList l = PrimitiveCollections.longArrayAsList(array);
                while (count > al) {
                    this.setAll(start, l);
                    start += al;
                    count -= al;
                }
                if (count > 0) {
                    this.setAll(start, l.subList(0, count));
                }
            } else {
                int e = start + count;
                int i = start;
                while (i < e) {
                    this.setLong(i, value);
                    ++i;
                }
            }
        }
    }

    @SignalType
    public static interface LongListRO
    extends Equivalenceable {
        public long getLong(int var1);

        public int size();

        default public int indexOfLong(long value) {
            return this.indexOfLong(value, 0);
        }

        default public int lastIndexOfLong(long value) {
            return this.lastIndexOfLong(value, this.size() - 1);
        }

        default public int indexOfLong(long value, int start) {
            int n = this.size();
            int i = start;
            while (i < n) {
                if (Primitives.eqSane(this.getLong(i), value)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        default public int lastIndexOfLong(long value, int start) {
            int i = start;
            if (i >= 0 && Primitives.eqSane(this.getLong(i), value)) {
                return i;
            }
            return i;
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof LongListRO) {
                return this.equivalentFixedRO((LongListRO)o);
            }
            if (o instanceof List) {
                List other = (List)o;
                int size = this.size();
                if (other.size() != size) {
                    return false;
                }
                int i = 0;
                while (i < size) {
                    Object e = other.get(i);
                    if (e instanceof Long) {
                        if (!Primitives.eqSane(this.getLong(i), (Long)e)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalentFixedRO(LongListRO other) {
            int size = this.size();
            if (other.size() != size) {
                return false;
            }
            int i = 0;
            while (i < size) {
                if (!Primitives.eqSane(this.getLong(i), other.getLong(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            int size = this.size();
            int i = 0;
            while (i < size) {
                long e = this.getLong(i);
                r = 31 * r + Primitives.hashprim(e);
                ++i;
            }
            return r;
        }
    }

    @SignalType
    public static interface LongListRWFixed
    extends LongListRO {
        public void setLong(int var1, long var2);
    }

    public static class LongListWrapper
    implements LongList {
        protected final List<Long> underlying;

        public LongListWrapper(List<Long> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithRemoveRange) {
                ((ListWithRemoveRange)((Object)this.underlying)).removeRange(start, pastEnd);
            } else {
                LongList.super.removeRange(start, pastEnd);
            }
        }

        @Override
        public void setSize(int newSize, Long elementToAddIfGrowing) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize, elementToAddIfGrowing);
            } else {
                LongList.super.setSize(newSize, elementToAddIfGrowing);
            }
        }

        @Override
        public void setSize(int newSize) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize);
            } else {
                LongList.super.setSize(newSize);
            }
        }

        @Override
        public void setAll(int destIndex, List source, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithSetAll) {
                ((ListWithSetAll)((Object)this.underlying)).setAll(destIndex, source, sourceIndex, amount);
            } else {
                LongList.super.setAll(destIndex, source, sourceIndex, amount);
            }
        }

        @Override
        public void fillBySetting(int start, int count, Long value) {
            if (this.underlying instanceof ListWithFill) {
                ((ListWithFill)this.underlying).fillBySetting(start, count, value);
            } else {
                LongList.super.fillBySetting(start, count, value);
            }
        }

        @Override
        public LongList clone() {
            return PrimitiveCollections.asLongList(ObjectUtilities.attemptClone(this.underlying));
        }

        @Override
        public long getLong(int index) {
            return this.get(index);
        }

        @Override
        public void setLong(int index, long value) {
            this.set(index, value);
        }

        @Override
        public void insertLong(int index, long value) {
            this.add(index, value);
        }

        @Override
        public void setSizeLong(int newSize, long elementToAddIfGrowing) {
            this.setSize(newSize, elementToAddIfGrowing);
        }

        @Override
        public void forEach(Consumer<? super Long> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Long e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Long> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Long> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Long> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Long> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Long> c) {
            this.underlying.sort(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public Long get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Long set(int index, Long element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Long element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Long> stream() {
            return this.underlying.stream();
        }

        @Override
        public Long remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Long> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public Spliterator<Long> spliterator() {
            return this.underlying.spliterator();
        }
    }

    @SignalType
    public static interface LongSet
    extends PrimitiveSet<Long, long[]>,
    NonuniformMethodsForLongSet {
        @Override
        default public Iterator<Long> iterator() {
            return NonuniformMethodsForLongSet.super.iterator();
        }

        @Override
        default public boolean addAll(Collection<? extends Long> c) {
            return NonuniformMethodsForLongSet.super.addAll(c);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForLongSet.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForLongSet.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForLongSet.super.containsAll(c);
        }

        @Override
        default public boolean add(Long e) {
            return NonuniformMethodsForLongSet.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForLongSet.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForLongSet.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveSet.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForLongSet.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForLongSet.super.toArray(a);
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof LongSet) {
                return this.equivalent((LongSet)o);
            }
            if (o instanceof Set) {
                int bs;
                Set a = (Set)o;
                LongSet b = this;
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                int as = a.size();
                if (as != (bs = b.size())) {
                    return false;
                }
                if (CodeHinting.arbitrary(as, bs) == 0) {
                    return true;
                }
                for (Object an : a) {
                    if (an instanceof Long) {
                        if (b.containsLong((Long)an)) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalent(LongSet other) {
            int bs;
            LongSet a = this;
            LongSet b = other;
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            int as = a.size();
            if (as != (bs = b.size())) {
                return false;
            }
            if (CodeHinting.arbitrary(as, bs) == 0) {
                return true;
            }
            SimpleLongIterator i = a.newSimpleLongIterator();
            try {
                while (b.containsLong(i.nextrpLong())) {
                }
                return false;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return true;
            }
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            SimpleLongIterator i = this.newSimpleLongIterator();
            try {
                while (true) {
                    r += Primitives.hashprim(i.nextrpLong());
                }
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return r;
            }
        }
    }

    public static class LongSublist
    implements LongList,
    DefaultShiftingBasedLongList,
    Sublist<Long>,
    ShiftableList {
        protected final LongList underlying;
        protected final int start;
        protected int size;

        public LongSublist(LongList underlying, int start, int initialSize) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.size(), start, initialSize);
            this.underlying = underlying;
            this.start = start;
            this.size = initialSize;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public long getLong(int index) {
            return this.underlying.getLong(index + this.start);
        }

        @Override
        public void setLong(int index, long value) {
            this.underlying.setLong(index + this.start, value);
        }

        @Override
        public void shiftRegionStretchingFromIndexToEndByAmountChangingSize(int start, int amount) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), start);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this.underlying, start, amount);
            this.size += amount;
        }

        @Override
        public LongList clone() {
            LongArrayList c = new LongArrayList();
            c.addAll(this);
            return c;
        }

        @Override
        public LongList getUnderlying() {
            return this.underlying;
        }

        @Override
        public int getSublistStartingIndex() {
            return this.start;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public Boolean isWritableCollection() {
            return this.underlying.isWritableCollection();
        }
    }

    public static class LongTable {
        protected int width;
        protected long[] data;

        public LongTable(int width, int height) {
            if (width < 0) {
                throw new IllegalArgumentException();
            }
            if (height < 0) {
                throw new IllegalArgumentException();
            }
            this.data = new long[width * height];
        }

        @Nonnegative
        public int getNumberOfColumns() {
            return this.width;
        }

        @Nonnegative
        public int getNumberOfRows() {
            return this.data.length / this.width;
        }

        @Nonnegative
        public int getNumberOfCells() {
            return this.data.length;
        }

        public long getCellContentsLong(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            return this.data[rowIndex * this.getNumberOfColumns() + columnIndex];
        }

        public void setCellContentsLong(int columnIndex, int rowIndex, @Nullable long newValue) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            this.data[rowIndex * this.getNumberOfColumns() + columnIndex] = newValue;
        }

        @Nullable
        public Long getCellContents(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            return this.getCellContentsLong(columnIndex, rowIndex);
        }

        public void setCellContents(int columnIndex, int rowIndex, @Nullable Long newValue) throws IndexOutOfBoundsException {
            this.setCellContentsLong(columnIndex, rowIndex, newValue);
        }
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForBooleanSet
    extends DefaultToArraysBooleanCollection {
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForByteList
    extends DefaultToArraysByteCollection {
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForByteSet
    extends DefaultToArraysByteCollection {
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForCharacterList
    extends CharSequence,
    DefaultToArraysCharacterCollection {
        public char getChar(int var1);

        public CharacterList subList(int var1, int var2);

        @Override
        default public boolean isEmpty() {
            return DefaultToArraysCharacterCollection.super.isEmpty();
        }

        @Override
        default public char charAt(int index) {
            return this.getChar(index);
        }

        @Override
        default public int length() {
            return this.size();
        }

        @Override
        default public CharSequence subSequence(int start, int end) {
            return this.subList(start, end);
        }

        @Override
        default public String _toString() {
            return PrimitiveCollections.defaultCharacterListToString((CharacterList)this);
        }
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForCharacterSet
    extends DefaultToArraysCharacterCollection {
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForDoubleList
    extends DefaultToArraysDoubleCollection {
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForDoubleSet
    extends DefaultToArraysDoubleCollection {
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForFloatList
    extends DefaultToArraysFloatCollection {
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForFloatSet
    extends DefaultToArraysFloatCollection {
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForIntegerList
    extends DefaultToArraysIntegerCollection {
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForIntegerSet
    extends DefaultToArraysIntegerCollection {
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForLongList
    extends DefaultToArraysLongCollection {
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForLongSet
    extends DefaultToArraysLongCollection {
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForShortList
    extends DefaultToArraysShortCollection {
    }

    @ImplementationTransparency
    public static interface NonuniformMethodsForShortSet
    extends DefaultToArraysShortCollection {
    }

    public static class ShortArrayList
    implements DefaultShiftingBasedShortList,
    ListWithSetSize<Short>,
    Trimmable,
    TransparentContiguousArrayBackedCollection<short[]>,
    KnowsLengthFixedness,
    RandomAccess {
        protected int size = 0;
        protected short[] data;
        protected Grower.GrowerComputationallyUnreducedPurelyRecursive grower;

        protected ShortArrayList(Void thisiswhyyoushouldntusejavaconstructorsAlthoughIdontknowhowtomakeinheritanceworkwellwithoutinitmethodsorfactoriesorsomething) {
        }

        public ShortArrayList(int initialCapacity, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = initialCapacity == 0 ? ArrayUtilities.EmptyShortArray : new short[initialCapacity];
            this.grower = grower;
        }

        public ShortArrayList(@LiveValue @WritableValue short[] LIVEBACKING, int size, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this.data = LIVEBACKING;
            this.grower = grower;
            this.size = size;
        }

        public ShortArrayList(@SnapshotValue @ReadonlyValue Collection<Short> c, Grower.GrowerComputationallyUnreducedPurelyRecursive grower) {
            this(c.size(), grower);
            this.addAll((Collection<? extends Short>)c);
        }

        public ShortArrayList() {
            this(16);
        }

        public ShortArrayList(int initialCapacity) {
            this(initialCapacity, PrimitiveCollections.defaultPrimitiveArrayListGrower(initialCapacity));
        }

        public ShortArrayList(@SnapshotValue @ReadonlyValue Collection<Short> c) {
            this(c, PrimitiveCollections.defaultPrimitiveArrayListGrower(c.size()));
        }

        public ShortArrayList(@LiveValue @WritableValue short[] LIVEBACKING, int size) {
            this(LIVEBACKING, size, PrimitiveCollections.defaultPrimitiveArrayListGrower(LIVEBACKING.length));
        }

        public ShortArrayList(@LiveValue @WritableValue short[] LIVEBACKING) {
            this(LIVEBACKING, LIVEBACKING.length);
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return false;
        }

        @Override
        public Boolean isWritableCollection() {
            return true;
        }

        @Override
        public void setSize(int newSize) {
            this.ensureCapacity(newSize);
            this.size = newSize;
        }

        protected void setupClone(ShortArrayList freshClone) {
            freshClone.size = this.size;
            freshClone.data = new short[this.size];
            System.arraycopy(this.data, 0, freshClone.data, 0, this.size);
            freshClone.grower = this.grower;
        }

        @Override
        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        public ShortArrayList clone() {
            ShortArrayList clone = new ShortArrayList();
            this.setupClone(clone);
            return clone;
        }

        @Override
        @ImplementationTransparency
        @LiveValue
        public Slice<short[]> getLiveContiguousArrayBackingUNSAFE() {
            return new Slice<short[]>(this.data, 0, this.size);
        }

        public void sort() {
            PrimitiveCollections.sortArray(this.data, 0, this.size);
        }

        @Override
        public void setShort(int index, short value) {
            CollectionUtilities.rangeCheckMember(this.size, index);
            this.data[index] = value;
        }

        @Override
        public short getShort(int index) {
            CollectionUtilities.rangeCheckMember(this.size(), index);
            return this.data[index];
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public void clear() {
            this.size = 0;
        }

        @Override
        @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
        public int size() {
            return this.size;
        }

        @ImplementationTransparency
        public void trimToSize() {
            short[] newdata = new short[this.size];
            System.arraycopy(this.data, 0, newdata, 0, this.size);
            this.data = newdata;
        }

        @Override
        public Trimmable.TrimmableTrimRV couldYouMaybeUseALittleLessMemoryIfYouDontMind() {
            this.trimToSize();
            return Trimmable.TrimmableTrimRV.DontKeepInvoking;
        }

        @ImplementationTransparency
        public int getCapacity() {
            return this.data.length;
        }

        @ImplementationTransparency
        public void ensureCapacity(int minCapacity) {
            if (this.data.length < minCapacity) {
                int newCapacity = this.getNewCapacity(minCapacity);
                short[] newData = new short[newCapacity];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
        }

        @Override
        public void clearHinting(int newCapacity) {
            this.clear();
            this.ensureCapacity(newCapacity);
        }

        @ImplementationTransparency
        public int getNewCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new IllegalArgumentException();
            }
            return Math.max(minCapacity, this.grower.getNewSizeRecursive(this.data.length));
        }

        @ImplementationTransparency
        public void setDirectBuffer(@LiveValue short[] array) {
            if (array.length < this.size) {
                throw new IllegalArgumentException("Array is too small; size=" + this.size + ", capacity=" + array.length);
            }
            this.data = array;
        }

        public String toString() {
            return this._toString();
        }
    }

    @SignalType
    public static interface ShortCollection
    extends PrimitiveCollection<Short, short[]>,
    SimpleShortIterable {
        public boolean addShort(short var1);

        public boolean removeShort(short var1);

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class getPrimitiveType() {
            return Short.TYPE;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<Short> getBoxedType() {
            return Short.class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Class<short[]> getArrayType() {
            return short[].class;
        }

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Short getDefaultElement() {
            return (short)0;
        }

        @ThrowAwayValue
        public static short[] defaultToShortArray(ShortCollection collection) {
            short[] array = new short[collection.size()];
            SimpleShortIterator i = collection.newSimpleShortIterator();
            int index = 0;
            while (true) {
                try {
                    array[index] = i.nextrpShort();
                }
                catch (StopIterationReturnPath exc) {
                    break;
                }
                ++index;
            }
            return array;
        }

        @ThrowAwayValue
        default public short[] toShortArray() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<short[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof short[]) {
                    return ArrayUtilities.sliceToNewShortArrayOP(u);
                }
            }
            return ShortCollection.defaultToShortArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public short[] toShortArrayPossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                int size = this.size();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                Object und = u.getUnderlying();
                if (und instanceof short[] && u.getOffset() == 0 && ((short[])und).length == size) {
                    return (short[])und;
                }
            }
            return ShortCollection.defaultToShortArray(this);
        }

        @PossiblySnapshotPossiblyLiveValue
        default public Slice<short[]> toShortArraySlicePossiblyLive() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<short[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof short[]) {
                    return u;
                }
            }
            return ArrayUtilities.wholeArraySliceShort(ShortCollection.defaultToShortArray(this));
        }

        @LiveValue
        @Nullable
        default public Slice<short[]> toShortArraySliceLiveOrNull() {
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice<short[]> u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(this.size(), u);
                if (u.getUnderlying() instanceof short[]) {
                    return u;
                }
            }
            return null;
        }

        default public boolean containsShort(short value) {
            SimpleShortIterator i = this.newSimpleShortIterator();
            try {
                while (!Primitives.eqSane(i.nextrpShort(), value)) {
                }
                return true;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return false;
            }
        }

        @Override
        default public Iterator<Short> iterator() {
            return SimpleShortIterable.super.iterator();
        }

        @Override
        default public boolean isEmpty() {
            return this.size() == 0;
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllShorts(short[] array) {
            return this.addAllShorts(array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllShorts(Slice<short[]> arraySlice) {
            return this.addAllShorts(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public boolean addAllShorts(short[] elements, int offset, int length) {
            return ShortCollection.defaultAddAllShorts(this, elements, offset, length);
        }

        public static boolean defaultAddAllShorts(ShortCollection self, short[] elements, int offset, int length) {
            boolean changedAtAll = false;
            int e = offset + length;
            int i = offset;
            while (i < e) {
                changedAtAll |= self.addShort(elements[i]);
                ++i;
            }
            return changedAtAll;
        }

        default public void removeAllShorts(short[] array) {
            this.removeAllShorts(array, 0, array.length);
        }

        default public void removeAllShorts(Slice<short[]> arraySlice) {
            this.removeAllShorts(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
        default public void removeAllShorts(short[] a, int offset, int length) {
            int e = offset + length;
            int i = offset;
            while (i < e) {
                this.removeShort(a[i]);
                ++i;
            }
        }

        @Override
        default public boolean contains(Object o) {
            return o instanceof Short && this.containsShort((Short)o);
        }

        @Override
        default public boolean add(Short e) {
            return this.addShort(e);
        }

        @Override
        default public boolean remove(Object o) {
            return o instanceof Short && this.removeShort((Short)o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            if (c instanceof ShortCollection) {
                ShortCollection cc = (ShortCollection)c;
                SimpleShortIterator i = cc.newSimpleShortIterator();
                try {
                    while (!this.containsShort(i.nextrpShort())) {
                    }
                    return true;
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return false;
                }
            }
            for (Object e : c) {
                if (!this.contains(e)) continue;
                return true;
            }
            return false;
        }

        @Override
        default public boolean addAll(Collection<? extends Short> c) {
            if (c instanceof ShortCollection) {
                boolean changedAtAll = false;
                SimpleShortIterator simpleShortIterator = ((ShortCollection)c).newSimpleShortIterator();
                try {
                    while (true) {
                        changedAtAll |= this.add(simpleShortIterator.nextrpShort());
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Short s : c) {
                changedAtAll |= this.add(s);
            }
            return changedAtAll;
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            if (c instanceof ShortCollection) {
                boolean changedAtAll = false;
                SimpleShortIterator i = ((ShortCollection)c).newSimpleShortIterator();
                try {
                    while (true) {
                        changedAtAll |= this.remove(i.nextrpShort());
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {
                    return changedAtAll;
                }
            }
            boolean changedAtAll = false;
            for (Object e : c) {
                changedAtAll |= this.remove(e);
            }
            return changedAtAll;
        }

        @Override
        default public void setFrom(Object source) {
            block8: {
                if (source == this) {
                    return;
                }
                if (source instanceof ShortCollection) {
                    ShortCollection s = (ShortCollection)source;
                    this.clearHinting(s.size());
                    SimpleShortIterator i = s.newSimpleShortIterator();
                    while (true) {
                        short e;
                        try {
                            e = i.nextrpShort();
                        }
                        catch (StopIterationReturnPath exc) {
                            break block8;
                        }
                        this.addShort(e);
                    }
                }
                if (source instanceof Collection) {
                    Collection s = (Collection)source;
                    this.clearHinting(s.size());
                    for (Short e : s) {
                        this.addShort(e);
                    }
                } else {
                    throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(source);
                }
            }
        }

        default public void clearHinting(int newCapacity) {
            this.clear();
        }

        @Override
        default public String _toString() {
            return PrimitiveCollections.defaultToString(this);
        }
    }

    @SignalType
    public static interface ShortIntervalCollection
    extends ShortCollection {
        @Override
        public int size();

        public short getLowerBoundInclusive();
    }

    @SignalType
    public static interface ShortList
    extends PrimitiveList<Short, short[]>,
    NonuniformMethodsForShortList,
    ShortListRO,
    ShortListRWFixed {
        @Override
        default public Iterator<Short> iterator() {
            return NonuniformMethodsForShortList.super.iterator();
        }

        public void insertShort(int var1, short var2);

        public ShortList clone();

        public void setSizeShort(int var1, short var2);

        @Override
        default public void setSize(int newSize, Short elementToAddIfGrowing) {
            this.setSizeShort(newSize, elementToAddIfGrowing);
        }

        @Override
        default public void setSize(int newSize) {
            this.setSizeShort(newSize, (short)0);
        }

        @Override
        default public void clear() {
            this.setSize(0);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllShorts(int index, short[] array) {
            this.setAllShorts(index, array, 0, array.length);
        }

        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void setAllShorts(int index, Slice<short[]> arraySlice) {
            this.setAllShorts(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        default public void setAllShorts(int start, short[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof short[]) {
                    Slice s = u;
                    System.arraycopy(array, offset, s.getUnderlying(), s.getOffset() + start, length);
                    return;
                }
            }
            ShortList.defaultSetAllShorts(this, start, array, offset, length);
        }

        public static void defaultSetAllShorts(ShortList list, int start, @WritableValue short[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                list.setShort(start + i, array[offset + i]);
                ++i;
            }
        }

        default public void setAll(int destIndex, List sourceU, int sourceIndex, @Nonnegative int amount) throws IndexOutOfBoundsException {
            List source = sourceU;
            ShortList dest = this;
            int sourceSize = source.size();
            int destSize = dest.size();
            CollectionUtilities.rangeCheckIntervalByLength(sourceSize, sourceIndex, amount);
            CollectionUtilities.rangeCheckIntervalByLength(destSize, destIndex, amount);
            if (TransparentContiguousArrayBackedCollection.is(source)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)source)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(sourceSize, u);
                if (u.getUnderlying() instanceof short[]) {
                    Slice s = u;
                    this.setAllShorts(destIndex, (Slice)s.subslice(sourceIndex, amount));
                    return;
                }
            }
            if (source instanceof ShortList) {
                ShortList primSource = (ShortList)source;
                if (destIndex < sourceIndex) {
                    int i = 0;
                    while (i < amount) {
                        dest.setShort(destIndex + i, primSource.getShort(sourceIndex + i));
                        ++i;
                    }
                } else {
                    int i = amount - 1;
                    while (i >= 0) {
                        dest.setShort(destIndex + i, primSource.getShort(sourceIndex + i));
                        --i;
                    }
                }
            } else if (destIndex < sourceIndex) {
                int i = 0;
                while (i < amount) {
                    dest.set(destIndex + i, (Short)source.get(sourceIndex + i));
                    ++i;
                }
            } else {
                int i = amount - 1;
                while (i >= 0) {
                    dest.set(destIndex + i, (Short)source.get(sourceIndex + i));
                    --i;
                }
            }
        }

        default public void getAllShorts(int start, @WritableValue short[] array, int offset, int length) {
            int size = this.size();
            CollectionUtilities.rangeCheckIntervalByLength(size, start, length);
            CollectionUtilities.rangeCheckIntervalByLength(array.length, offset, length);
            if (TransparentContiguousArrayBackedCollection.is(this)) {
                Slice u = ((TransparentContiguousArrayBackedCollection)((Object)this)).getLiveContiguousArrayBackingUNSAFE();
                TransparentContiguousArrayBackedCollection.checkUnderlyingLengthAndExposedSizeMatch(size, u);
                if (u.getUnderlying() instanceof short[]) {
                    Slice s = u;
                    System.arraycopy(s.getUnderlying(), s.getOffset() + start, array, offset, length);
                    return;
                }
            }
            ShortList.defaultGetAllShorts(this, start, array, offset, length);
        }

        public static void defaultGetAllShorts(ShortList list, int start, @WritableValue short[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                array[offset + i] = list.getShort(start + i);
                ++i;
            }
        }

        @ThrowAwayValue
        default public short[] getAllShorts(int start, int end) {
            CollectionUtilities.rangeCheckInterval(this.size(), start, end);
            short[] buff = new short[end - start];
            this.getAllShorts(start, buff, 0, buff.length);
            return buff;
        }

        @Override
        default public boolean addShort(short value) {
            this.insertShort(this.size(), value);
            return true;
        }

        @Override
        default public boolean addAll(Collection<? extends Short> c) {
            this.addAll(this.size(), c);
            return true;
        }

        @Override
        default public boolean addAllShorts(short[] elements, int offset, int length) {
            this.insertAllShorts(this.size(), elements, offset, length);
            return true;
        }

        default public void removeByIndex(int index) {
            this.removeRange(index, index + 1);
        }

        default public short removeShortByIndex(int index) throws IndexOutOfBoundsException {
            short v = this.getShort(index);
            this.removeByIndex(index);
            return v;
        }

        @Override
        default public boolean removeShort(short value) {
            int i = this.indexOfShort(value);
            if (i != -1) {
                this.removeByIndex(i);
                return true;
            }
            return false;
        }

        @Override
        default public boolean retainAll(Collection<?> c) {
            if (c instanceof ShortCollection) {
                ShortCollection cc = (ShortCollection)c;
                boolean changedAtAll = false;
                int i = this.size() - 1;
                while (i >= 0) {
                    if (!cc.containsShort(this.getShort(i))) {
                        this.removeShortByIndex(i);
                        changedAtAll = true;
                    }
                    --i;
                }
                return changedAtAll;
            }
            boolean changedAtAll = false;
            int i = this.size() - 1;
            while (i >= 0) {
                if (!c.contains(this.getShort(i))) {
                    this.removeShortByIndex(i);
                    changedAtAll = true;
                }
                --i;
            }
            return changedAtAll;
        }

        @Override
        default public SimpleShortIterator newSimpleShortIterator() {
            return new SimpleShortIterator(){
                int index = 0;

                @Override
                public short nextrpShort() throws StopIterationReturnPath {
                    int i = this.index;
                    if (i >= this.size()) {
                        throw StopIterationReturnPath.I;
                    }
                    this.index = i + 1;
                    return this.getShort(i);
                }
            };
        }

        @Override
        default public boolean containsShort(short value) {
            return this.indexOfShort(value) != -1;
        }

        default public void insertAllShorts(int index, short[] array, int offset, int length) {
            int i = 0;
            while (i < length) {
                this.insertShort(index + i, array[offset + i]);
                ++i;
            }
        }

        @Override
        default public boolean addAll(int index, Collection<? extends Short> c) {
            if (c instanceof ShortCollection) {
                ShortCollection shortCollection = (ShortCollection)c;
                SimpleShortIterator i = shortCollection.newSimpleShortIterator();
                try {
                    while (true) {
                        this.insertShort(index, i.nextrpShort());
                        ++index;
                    }
                }
                catch (StopIterationReturnPath stopIterationReturnPath) {}
            } else {
                for (Short s : c) {
                    this.insertShort(index, s);
                    ++index;
                }
            }
            return true;
        }

        default public void insertAllShorts(int index, short[] array) {
            this.insertAllShorts(index, array, 0, array.length);
        }

        default public void insertAllShorts(int index, Slice<short[]> arraySlice) {
            this.insertAllShorts(index, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
        }

        @Override
        default public Short get(int index) {
            return this.getShort(index);
        }

        @Override
        default public Short set(int index, Short value) {
            Short previous = this.get(index);
            this.setShort(index, value);
            return previous;
        }

        @Override
        default public void add(int index, Short value) {
            this.insertShort(index, value);
        }

        @Override
        default public Short remove(int index) throws IndexOutOfBoundsException {
            return this.removeShortByIndex(index);
        }

        @Override
        default public int indexOf(Object o) {
            return o instanceof Short ? this.indexOfShort((Short)o) : -1;
        }

        @Override
        default public int lastIndexOf(Object o) {
            return o instanceof Short ? this.lastIndexOfShort((Short)o) : -1;
        }

        default public int indexOf(Object o, int start) {
            return o instanceof Short ? this.indexOfShort((Short)o, start) : -1;
        }

        default public int lastIndexOf(Object o, int start) {
            return o instanceof Short ? this.lastIndexOfShort((Short)o, start) : -1;
        }

        @Override
        default public ListIterator<Short> listIterator() {
            return this.listIterator(0);
        }

        @Override
        default public ListIterator<Short> listIterator(int index) {
            return new DelegatingListIterator<Short>(this, index);
        }

        default public ShortList subList(int fromIndex, int toIndex) {
            if (fromIndex == 0 && toIndex == this.size()) {
                return this;
            }
            if (this instanceof Sublist) {
                Sublist s = (Sublist)((Object)this);
                return new ShortSublist((ShortList)s.getUnderlying(), s.getSublistStartingIndex() + fromIndex, toIndex - fromIndex);
            }
            return new ShortSublist(this, fromIndex, toIndex - fromIndex);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForShortList.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForShortList.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForShortList.super.containsAll(c);
        }

        @Override
        default public boolean add(Short e) {
            return NonuniformMethodsForShortList.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForShortList.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForShortList.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveList.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForShortList.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForShortList.super.toArray(a);
        }

        @Override
        default public void storeBoxingIntoArray(Slice<Object[]> array) {
            int n = this.size();
            int i = 0;
            while (i < n) {
                ArrayUtilities.setReference(array, i, this.get(i));
                ++i;
            }
        }

        default public boolean endsWith(List<Short> suffixCandidate) {
            return this.size() >= suffixCandidate.size() && this.subListToEnd(suffixCandidate.size()).equivalent(suffixCandidate);
        }

        default public boolean startsWith(List<Short> prefixCandidate) {
            return this.size() >= prefixCandidate.size() && this.subListFromBeginning(prefixCandidate.size()).equivalent(prefixCandidate);
        }

        default public ShortList subListToEnd(int start) {
            return (ShortList)PrimitiveList.super.subListToEnd(start);
        }

        default public ShortList subListFromBeginning(int lengthWhichIsEndExclusiveInThisCaseXD) {
            return (ShortList)PrimitiveList.super.subListFromBeginning(lengthWhichIsEndExclusiveInThisCaseXD);
        }

        default public ShortList subListByLength(int start, int length) {
            return (ShortList)PrimitiveList.super.subListByLength(start, length);
        }

        @Override
        default public void fillBySetting(int start, int count, Short value) {
            this.fillBySettingShort(start, count, value);
        }

        default public void fillBySettingShort(short value) {
            this.fillBySettingShort(0, this.size(), value);
        }

        default public void fillBySettingShort(int start, int count, short value) {
            CollectionUtilities.rangeCheckIntervalByLength(this.size(), start, count);
            if (count >= 100) {
                short[] array = new short[SmallIntegerMathUtilities.least(count, 1024)];
                if (value != 0) {
                    Arrays.fill(array, value);
                }
                int al = array.length;
                ShortList l = PrimitiveCollections.shortArrayAsList(array);
                while (count > al) {
                    this.setAll(start, l);
                    start += al;
                    count -= al;
                }
                if (count > 0) {
                    this.setAll(start, l.subList(0, count));
                }
            } else {
                int e = start + count;
                int i = start;
                while (i < e) {
                    this.setShort(i, value);
                    ++i;
                }
            }
        }
    }

    @SignalType
    public static interface ShortListRO
    extends Equivalenceable {
        public short getShort(int var1);

        public int size();

        default public int indexOfShort(short value) {
            return this.indexOfShort(value, 0);
        }

        default public int lastIndexOfShort(short value) {
            return this.lastIndexOfShort(value, this.size() - 1);
        }

        default public int indexOfShort(short value, int start) {
            int n = this.size();
            int i = start;
            while (i < n) {
                if (Primitives.eqSane(this.getShort(i), value)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        default public int lastIndexOfShort(short value, int start) {
            int i = start;
            if (i >= 0 && Primitives.eqSane(this.getShort(i), value)) {
                return i;
            }
            return i;
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof ShortListRO) {
                return this.equivalentFixedRO((ShortListRO)o);
            }
            if (o instanceof List) {
                List other = (List)o;
                int size = this.size();
                if (other.size() != size) {
                    return false;
                }
                int i = 0;
                while (i < size) {
                    Object e = other.get(i);
                    if (e instanceof Short) {
                        if (!Primitives.eqSane(this.getShort(i), (Short)e)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalentFixedRO(ShortListRO other) {
            int size = this.size();
            if (other.size() != size) {
                return false;
            }
            int i = 0;
            while (i < size) {
                if (!Primitives.eqSane(this.getShort(i), other.getShort(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            int size = this.size();
            int i = 0;
            while (i < size) {
                short e = this.getShort(i);
                r = 31 * r + Primitives.hashprim(e);
                ++i;
            }
            return r;
        }
    }

    @SignalType
    public static interface ShortListRWFixed
    extends ShortListRO {
        public void setShort(int var1, short var2);
    }

    public static class ShortListWrapper
    implements ShortList {
        protected final List<Short> underlying;

        public ShortListWrapper(List<Short> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithRemoveRange) {
                ((ListWithRemoveRange)((Object)this.underlying)).removeRange(start, pastEnd);
            } else {
                ShortList.super.removeRange(start, pastEnd);
            }
        }

        @Override
        public void setSize(int newSize, Short elementToAddIfGrowing) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize, elementToAddIfGrowing);
            } else {
                ShortList.super.setSize(newSize, elementToAddIfGrowing);
            }
        }

        @Override
        public void setSize(int newSize) {
            if (this.underlying instanceof ListWithSetSize) {
                ((ListWithSetSize)this.underlying).setSize(newSize);
            } else {
                ShortList.super.setSize(newSize);
            }
        }

        @Override
        public void setAll(int destIndex, List source, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            if (this.underlying instanceof ListWithSetAll) {
                ((ListWithSetAll)((Object)this.underlying)).setAll(destIndex, source, sourceIndex, amount);
            } else {
                ShortList.super.setAll(destIndex, source, sourceIndex, amount);
            }
        }

        @Override
        public void fillBySetting(int start, int count, Short value) {
            if (this.underlying instanceof ListWithFill) {
                ((ListWithFill)this.underlying).fillBySetting(start, count, value);
            } else {
                ShortList.super.fillBySetting(start, count, value);
            }
        }

        @Override
        public ShortList clone() {
            return PrimitiveCollections.asShortList(ObjectUtilities.attemptClone(this.underlying));
        }

        @Override
        public short getShort(int index) {
            return this.get(index);
        }

        @Override
        public void setShort(int index, short value) {
            this.set(index, value);
        }

        @Override
        public void insertShort(int index, short value) {
            this.add(index, value);
        }

        @Override
        public void setSizeShort(int newSize, short elementToAddIfGrowing) {
            this.setSize(newSize, elementToAddIfGrowing);
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Short e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Short> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Short> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Short> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Short> c) {
            this.underlying.sort(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public Short get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Short set(int index, Short element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Short element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Short> stream() {
            return this.underlying.stream();
        }

        @Override
        public Short remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Short> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public Spliterator<Short> spliterator() {
            return this.underlying.spliterator();
        }
    }

    @SignalType
    public static interface ShortSet
    extends PrimitiveSet<Short, short[]>,
    NonuniformMethodsForShortSet {
        @Override
        default public Iterator<Short> iterator() {
            return NonuniformMethodsForShortSet.super.iterator();
        }

        @Override
        default public boolean addAll(Collection<? extends Short> c) {
            return NonuniformMethodsForShortSet.super.addAll(c);
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            return NonuniformMethodsForShortSet.super.removeAll(c);
        }

        @Override
        default public boolean remove(Object o) {
            return NonuniformMethodsForShortSet.super.remove(o);
        }

        @Override
        default public boolean containsAll(Collection<?> c) {
            return NonuniformMethodsForShortSet.super.containsAll(c);
        }

        @Override
        default public boolean add(Short e) {
            return NonuniformMethodsForShortSet.super.add(e);
        }

        @Override
        default public boolean isEmpty() {
            return NonuniformMethodsForShortSet.super.isEmpty();
        }

        @Override
        default public boolean contains(Object o) {
            return NonuniformMethodsForShortSet.super.contains(o);
        }

        @Override
        default public void setFrom(Object source) {
            PrimitiveSet.super.setFrom(source);
        }

        @Override
        default public Object[] toArray() {
            return NonuniformMethodsForShortSet.super.toArray();
        }

        @Override
        default public <T> T[] toArray(T[] a) {
            return NonuniformMethodsForShortSet.super.toArray(a);
        }

        @Override
        default public boolean equivalent(Object o) {
            if (o instanceof ShortSet) {
                return this.equivalent((ShortSet)o);
            }
            if (o instanceof Set) {
                int bs;
                Set a = (Set)o;
                ShortSet b = this;
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                int as = a.size();
                if (as != (bs = b.size())) {
                    return false;
                }
                if (CodeHinting.arbitrary(as, bs) == 0) {
                    return true;
                }
                for (Object an : a) {
                    if (an instanceof Short) {
                        if (b.containsShort((Short)an)) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        default public boolean equivalent(ShortSet other) {
            int bs;
            ShortSet a = this;
            ShortSet b = other;
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            int as = a.size();
            if (as != (bs = b.size())) {
                return false;
            }
            if (CodeHinting.arbitrary(as, bs) == 0) {
                return true;
            }
            SimpleShortIterator i = a.newSimpleShortIterator();
            try {
                while (b.containsShort(i.nextrpShort())) {
                }
                return false;
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return true;
            }
        }

        @Override
        default public int hashCodeOfContents() {
            int r = 1;
            SimpleShortIterator i = this.newSimpleShortIterator();
            try {
                while (true) {
                    r += Primitives.hashprim(i.nextrpShort());
                }
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return r;
            }
        }
    }

    public static class ShortSublist
    implements ShortList,
    DefaultShiftingBasedShortList,
    Sublist<Short>,
    ShiftableList {
        protected final ShortList underlying;
        protected final int start;
        protected int size;

        public ShortSublist(ShortList underlying, int start, int initialSize) {
            CollectionUtilities.rangeCheckIntervalByLength(underlying.size(), start, initialSize);
            this.underlying = underlying;
            this.start = start;
            this.size = initialSize;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public short getShort(int index) {
            return this.underlying.getShort(index + this.start);
        }

        @Override
        public void setShort(int index, short value) {
            this.underlying.setShort(index + this.start, value);
        }

        @Override
        public void shiftRegionStretchingFromIndexToEndByAmountChangingSize(int start, int amount) {
            CollectionUtilities.rangeCheckCursorPoint(this.size(), start);
            CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(this.underlying, start, amount);
            this.size += amount;
        }

        @Override
        public ShortList clone() {
            ShortArrayList c = new ShortArrayList();
            c.addAll(this);
            return c;
        }

        @Override
        public ShortList getUnderlying() {
            return this.underlying;
        }

        @Override
        public int getSublistStartingIndex() {
            return this.start;
        }

        public String toString() {
            return this._toString();
        }

        @Override
        public Boolean isWritableCollection() {
            return this.underlying.isWritableCollection();
        }
    }

    public static class ShortTable {
        protected int width;
        protected short[] data;

        public ShortTable(int width, int height) {
            if (width < 0) {
                throw new IllegalArgumentException();
            }
            if (height < 0) {
                throw new IllegalArgumentException();
            }
            this.data = new short[width * height];
        }

        @Nonnegative
        public int getNumberOfColumns() {
            return this.width;
        }

        @Nonnegative
        public int getNumberOfRows() {
            return this.data.length / this.width;
        }

        @Nonnegative
        public int getNumberOfCells() {
            return this.data.length;
        }

        public short getCellContentsShort(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            return this.data[rowIndex * this.getNumberOfColumns() + columnIndex];
        }

        public void setCellContentsShort(int columnIndex, int rowIndex, @Nullable short newValue) throws IndexOutOfBoundsException {
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (columnIndex >= this.getNumberOfColumns()) {
                throw new IndexOutOfBoundsException();
            }
            if (rowIndex >= this.getNumberOfRows()) {
                throw new IndexOutOfBoundsException();
            }
            this.data[rowIndex * this.getNumberOfColumns() + columnIndex] = newValue;
        }

        @Nullable
        public Short getCellContents(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
            return this.getCellContentsShort(columnIndex, rowIndex);
        }

        public void setCellContents(int columnIndex, int rowIndex, @Nullable Short newValue) throws IndexOutOfBoundsException {
            this.setCellContentsShort(columnIndex, rowIndex, newValue);
        }
    }

    public static interface SimpleBooleanIterable
    extends SimpleIterator.SimpleIterable<Boolean> {
        public SimpleBooleanIterator newSimpleBooleanIterator();

        @Override
        default public SimpleIterator<Boolean> simpleIterator() {
            SimpleBooleanIterator i = this.newSimpleBooleanIterator();
            return () -> i.nextrpBoolean();
        }

        public static SimpleBooleanIterator defaultNewSimpleBooleanIterator(SimpleIterator<Boolean> i) {
            return i instanceof SimpleBooleanIterator ? (SimpleBooleanIterator)i : () -> (Boolean)i.nextrp();
        }

        public static SimpleBooleanIterator defaultNewSimpleBooleanIterator(Iterator<Boolean> i) {
            return i instanceof SimpleBooleanIterator ? (SimpleBooleanIterator)((Object)i) : SimpleBooleanIterable.defaultNewSimpleBooleanIterator(SimpleIterator.simpleIterator(i));
        }
    }

    public static interface SimpleBooleanIterator
    extends SimpleIterator<Boolean> {
        public boolean nextrpBoolean() throws StopIterationReturnPath;

        @Override
        default public Boolean nextrp() throws StopIterationReturnPath {
            return this.nextrpBoolean();
        }
    }

    public static interface SimpleByteIterable
    extends SimpleIterator.SimpleIterable<Byte> {
        public SimpleByteIterator newSimpleByteIterator();

        @Override
        default public SimpleIterator<Byte> simpleIterator() {
            SimpleByteIterator i = this.newSimpleByteIterator();
            return () -> i.nextrpByte();
        }

        public static SimpleByteIterator defaultNewSimpleByteIterator(SimpleIterator<Byte> i) {
            return i instanceof SimpleByteIterator ? (SimpleByteIterator)i : () -> (Byte)i.nextrp();
        }

        public static SimpleByteIterator defaultNewSimpleByteIterator(Iterator<Byte> i) {
            return i instanceof SimpleByteIterator ? (SimpleByteIterator)((Object)i) : SimpleByteIterable.defaultNewSimpleByteIterator(SimpleIterator.simpleIterator(i));
        }
    }

    public static interface SimpleByteIterator
    extends SimpleIterator<Byte> {
        public byte nextrpByte() throws StopIterationReturnPath;

        @Override
        default public Byte nextrp() throws StopIterationReturnPath {
            return this.nextrpByte();
        }
    }

    public static interface SimpleCharacterIterable
    extends SimpleIterator.SimpleIterable<Character> {
        public SimpleCharacterIterator newSimpleCharacterIterator();

        @Override
        default public SimpleIterator<Character> simpleIterator() {
            SimpleCharacterIterator i = this.newSimpleCharacterIterator();
            return () -> Character.valueOf(i.nextrpChar());
        }

        public static SimpleCharacterIterator defaultNewSimpleCharacterIterator(SimpleIterator<Character> i) {
            return i instanceof SimpleCharacterIterator ? (SimpleCharacterIterator)i : () -> ((Character)i.nextrp()).charValue();
        }

        public static SimpleCharacterIterator defaultNewSimpleCharacterIterator(Iterator<Character> i) {
            return i instanceof SimpleCharacterIterator ? (SimpleCharacterIterator)((Object)i) : SimpleCharacterIterable.defaultNewSimpleCharacterIterator(SimpleIterator.simpleIterator(i));
        }
    }

    public static interface SimpleCharacterIterator
    extends SimpleIterator<Character> {
        public char nextrpChar() throws StopIterationReturnPath;

        @Override
        default public Character nextrp() throws StopIterationReturnPath {
            return Character.valueOf(this.nextrpChar());
        }
    }

    public static interface SimpleDoubleIterable
    extends SimpleIterator.SimpleIterable<Double> {
        public SimpleDoubleIterator newSimpleDoubleIterator();

        @Override
        default public SimpleIterator<Double> simpleIterator() {
            SimpleDoubleIterator i = this.newSimpleDoubleIterator();
            return () -> i.nextrpDouble();
        }

        public static SimpleDoubleIterator defaultNewSimpleDoubleIterator(SimpleIterator<Double> i) {
            return i instanceof SimpleDoubleIterator ? (SimpleDoubleIterator)i : () -> (Double)i.nextrp();
        }

        public static SimpleDoubleIterator defaultNewSimpleDoubleIterator(Iterator<Double> i) {
            return i instanceof SimpleDoubleIterator ? (SimpleDoubleIterator)((Object)i) : SimpleDoubleIterable.defaultNewSimpleDoubleIterator(SimpleIterator.simpleIterator(i));
        }
    }

    public static interface SimpleDoubleIterator
    extends SimpleIterator<Double> {
        public double nextrpDouble() throws StopIterationReturnPath;

        @Override
        default public Double nextrp() throws StopIterationReturnPath {
            return this.nextrpDouble();
        }
    }

    public static interface SimpleFloatIterable
    extends SimpleIterator.SimpleIterable<Float> {
        public SimpleFloatIterator newSimpleFloatIterator();

        @Override
        default public SimpleIterator<Float> simpleIterator() {
            SimpleFloatIterator i = this.newSimpleFloatIterator();
            return () -> Float.valueOf(i.nextrpFloat());
        }

        public static SimpleFloatIterator defaultNewSimpleFloatIterator(SimpleIterator<Float> i) {
            return i instanceof SimpleFloatIterator ? (SimpleFloatIterator)i : () -> ((Float)i.nextrp()).floatValue();
        }

        public static SimpleFloatIterator defaultNewSimpleFloatIterator(Iterator<Float> i) {
            return i instanceof SimpleFloatIterator ? (SimpleFloatIterator)((Object)i) : SimpleFloatIterable.defaultNewSimpleFloatIterator(SimpleIterator.simpleIterator(i));
        }
    }

    public static interface SimpleFloatIterator
    extends SimpleIterator<Float> {
        public float nextrpFloat() throws StopIterationReturnPath;

        @Override
        default public Float nextrp() throws StopIterationReturnPath {
            return Float.valueOf(this.nextrpFloat());
        }
    }

    public static interface SimpleIntegerIterable
    extends SimpleIterator.SimpleIterable<Integer> {
        public SimpleIntegerIterator newSimpleIntegerIterator();

        @Override
        default public SimpleIterator<Integer> simpleIterator() {
            SimpleIntegerIterator i = this.newSimpleIntegerIterator();
            return () -> i.nextrpInt();
        }

        public static SimpleIntegerIterator defaultNewSimpleIntegerIterator(SimpleIterator<Integer> i) {
            return i instanceof SimpleIntegerIterator ? (SimpleIntegerIterator)i : () -> (Integer)i.nextrp();
        }

        public static SimpleIntegerIterator defaultNewSimpleIntegerIterator(Iterator<Integer> i) {
            return i instanceof SimpleIntegerIterator ? (SimpleIntegerIterator)((Object)i) : SimpleIntegerIterable.defaultNewSimpleIntegerIterator(SimpleIterator.simpleIterator(i));
        }
    }

    public static interface SimpleIntegerIterator
    extends SimpleIterator<Integer> {
        public int nextrpInt() throws StopIterationReturnPath;

        @Override
        default public Integer nextrp() throws StopIterationReturnPath {
            return this.nextrpInt();
        }
    }

    public static interface SimpleLongIterable
    extends SimpleIterator.SimpleIterable<Long> {
        public SimpleLongIterator newSimpleLongIterator();

        @Override
        default public SimpleIterator<Long> simpleIterator() {
            SimpleLongIterator i = this.newSimpleLongIterator();
            return () -> i.nextrpLong();
        }

        public static SimpleLongIterator defaultNewSimpleLongIterator(SimpleIterator<Long> i) {
            return i instanceof SimpleLongIterator ? (SimpleLongIterator)i : () -> (Long)i.nextrp();
        }

        public static SimpleLongIterator defaultNewSimpleLongIterator(Iterator<Long> i) {
            return i instanceof SimpleLongIterator ? (SimpleLongIterator)((Object)i) : SimpleLongIterable.defaultNewSimpleLongIterator(SimpleIterator.simpleIterator(i));
        }
    }

    public static interface SimpleLongIterator
    extends SimpleIterator<Long> {
        public long nextrpLong() throws StopIterationReturnPath;

        @Override
        default public Long nextrp() throws StopIterationReturnPath {
            return this.nextrpLong();
        }
    }

    public static interface SimpleShortIterable
    extends SimpleIterator.SimpleIterable<Short> {
        public SimpleShortIterator newSimpleShortIterator();

        @Override
        default public SimpleIterator<Short> simpleIterator() {
            SimpleShortIterator i = this.newSimpleShortIterator();
            return () -> i.nextrpShort();
        }

        public static SimpleShortIterator defaultNewSimpleShortIterator(SimpleIterator<Short> i) {
            return i instanceof SimpleShortIterator ? (SimpleShortIterator)i : () -> (Short)i.nextrp();
        }

        public static SimpleShortIterator defaultNewSimpleShortIterator(Iterator<Short> i) {
            return i instanceof SimpleShortIterator ? (SimpleShortIterator)((Object)i) : SimpleShortIterable.defaultNewSimpleShortIterator(SimpleIterator.simpleIterator(i));
        }
    }

    public static interface SimpleShortIterator
    extends SimpleIterator<Short> {
        public short nextrpShort() throws StopIterationReturnPath;

        @Override
        default public Short nextrp() throws StopIterationReturnPath {
            return this.nextrpShort();
        }
    }

    public static class SortedByteSetBackedByList
    implements ByteSet,
    UnderlyingInstanceAccessible<ByteList>,
    KnowsLengthFixedness {
        protected ByteList underlying;

        public SortedByteSetBackedByList() {
            this(new ByteArrayList());
        }

        public SortedByteSetBackedByList(@LiveValue ByteList presortedOrEmptyUnderlying) {
            this.underlying = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static SortedByteSetBackedByList sorted(@ReadonlyValue @SnapshotValue Collection<Byte> c) {
            byte[] a = PrimitiveCollections.toByteArray(c);
            Arrays.sort(a);
            return new SortedByteSetBackedByList(new ByteArrayList(a));
        }

        @Override
        @LiveValue
        public ByteList getUnderlying() {
            return this.underlying;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.getUnderlying());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.getUnderlying());
        }

        @Override
        public boolean addByte(byte value) {
            int insertionPoint = SortingUtilities.findInsertionPointInSet(this.underlying, 0, this.size(), value);
            if (insertionPoint < 0) {
                return false;
            }
            this.underlying.insertByte(insertionPoint, value);
            return true;
        }

        public int indexOfByte(byte value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.underlying, 0, this.size(), value);
        }

        @Override
        public boolean removeByte(byte value) {
            int i = this.indexOfByte(value);
            if (i == -1) {
                return false;
            }
            this.removeByIndex(i);
            return true;
        }

        @Override
        public boolean containsByte(byte value) {
            return this.indexOfByte(value) != -1;
        }

        public boolean equivalent(SortedByteSetBackedByList other) {
            return this.underlying.equivalent(other.getUnderlying());
        }

        @Override
        public byte[] toByteArray() {
            return this.toSortedByteArray();
        }

        @ThrowAwayValue
        public byte[] toSortedByteArray() {
            return this.underlying.toByteArray();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        public byte removeByteByIndex(int index) {
            return this.underlying.removeByteByIndex(index);
        }

        public void removeByIndex(int index) {
            this.underlying.removeByIndex(index);
        }

        public void removeRange(int start, int end) {
            this.underlying.removeRange(start, end);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public byte getByte(int index) {
            return this.underlying.getByte(index);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        @Override
        public SimpleByteIterator newSimpleByteIterator() {
            return this.underlying.newSimpleByteIterator();
        }

        public SortedByteSetBackedByList clone() {
            return new SortedByteSetBackedByList(this.underlying.clone());
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class SortedCharacterSetBackedByList
    implements CharacterSet,
    UnderlyingInstanceAccessible<CharacterList>,
    KnowsLengthFixedness {
        protected CharacterList underlying;

        public SortedCharacterSetBackedByList() {
            this(new CharacterArrayList());
        }

        public SortedCharacterSetBackedByList(@LiveValue CharacterList presortedOrEmptyUnderlying) {
            this.underlying = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static SortedCharacterSetBackedByList sorted(@ReadonlyValue @SnapshotValue Collection<Character> c) {
            char[] a = PrimitiveCollections.toCharArray(c);
            Arrays.sort(a);
            return new SortedCharacterSetBackedByList(new CharacterArrayList(a));
        }

        @Override
        @LiveValue
        public CharacterList getUnderlying() {
            return this.underlying;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.getUnderlying());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.getUnderlying());
        }

        @Override
        public boolean addChar(char value) {
            int insertionPoint = SortingUtilities.findInsertionPointInSet(this.underlying, 0, this.size(), value);
            if (insertionPoint < 0) {
                return false;
            }
            this.underlying.insertChar(insertionPoint, value);
            return true;
        }

        public int indexOfChar(char value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.underlying, 0, this.size(), value);
        }

        @Override
        public boolean removeChar(char value) {
            int i = this.indexOfChar(value);
            if (i == -1) {
                return false;
            }
            this.removeByIndex(i);
            return true;
        }

        @Override
        public boolean containsChar(char value) {
            return this.indexOfChar(value) != -1;
        }

        public boolean equivalent(SortedCharacterSetBackedByList other) {
            return this.underlying.equivalent(other.getUnderlying());
        }

        @Override
        public char[] toCharArray() {
            return this.toSortedCharArray();
        }

        @ThrowAwayValue
        public char[] toSortedCharArray() {
            return this.underlying.toCharArray();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        public char removeCharByIndex(int index) {
            return this.underlying.removeCharByIndex(index);
        }

        public void removeByIndex(int index) {
            this.underlying.removeByIndex(index);
        }

        public void removeRange(int start, int end) {
            this.underlying.removeRange(start, end);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public char getChar(int index) {
            return this.underlying.getChar(index);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        @Override
        public SimpleCharacterIterator newSimpleCharacterIterator() {
            return this.underlying.newSimpleCharacterIterator();
        }

        public SortedCharacterSetBackedByList clone() {
            return new SortedCharacterSetBackedByList(this.underlying.clone());
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class SortedDoubleSetBackedByList
    implements DoubleSet,
    UnderlyingInstanceAccessible<DoubleList>,
    KnowsLengthFixedness {
        protected DoubleList underlying;

        public SortedDoubleSetBackedByList() {
            this(new DoubleArrayList());
        }

        public SortedDoubleSetBackedByList(@LiveValue DoubleList presortedOrEmptyUnderlying) {
            this.underlying = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static SortedDoubleSetBackedByList sorted(@ReadonlyValue @SnapshotValue Collection<Double> c) {
            double[] a = PrimitiveCollections.toDoubleArray(c);
            Arrays.sort(a);
            return new SortedDoubleSetBackedByList(new DoubleArrayList(a));
        }

        @Override
        @LiveValue
        public DoubleList getUnderlying() {
            return this.underlying;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.getUnderlying());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.getUnderlying());
        }

        @Override
        public boolean addDouble(double value) {
            int insertionPoint = SortingUtilities.findInsertionPointInSet(this.underlying, 0, this.size(), value);
            if (insertionPoint < 0) {
                return false;
            }
            this.underlying.insertDouble(insertionPoint, value);
            return true;
        }

        public int indexOfDouble(double value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.underlying, 0, this.size(), value);
        }

        @Override
        public boolean removeDouble(double value) {
            int i = this.indexOfDouble(value);
            if (i == -1) {
                return false;
            }
            this.removeByIndex(i);
            return true;
        }

        @Override
        public boolean containsDouble(double value) {
            return this.indexOfDouble(value) != -1;
        }

        public boolean equivalent(SortedDoubleSetBackedByList other) {
            return this.underlying.equivalent(other.getUnderlying());
        }

        @Override
        public double[] toDoubleArray() {
            return this.toSortedDoubleArray();
        }

        @ThrowAwayValue
        public double[] toSortedDoubleArray() {
            return this.underlying.toDoubleArray();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        public double removeDoubleByIndex(int index) {
            return this.underlying.removeDoubleByIndex(index);
        }

        public void removeByIndex(int index) {
            this.underlying.removeByIndex(index);
        }

        public void removeRange(int start, int end) {
            this.underlying.removeRange(start, end);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public double getDouble(int index) {
            return this.underlying.getDouble(index);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        @Override
        public SimpleDoubleIterator newSimpleDoubleIterator() {
            return this.underlying.newSimpleDoubleIterator();
        }

        public SortedDoubleSetBackedByList clone() {
            return new SortedDoubleSetBackedByList(this.underlying.clone());
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class SortedFloatSetBackedByList
    implements FloatSet,
    UnderlyingInstanceAccessible<FloatList>,
    KnowsLengthFixedness {
        protected FloatList underlying;

        public SortedFloatSetBackedByList() {
            this(new FloatArrayList());
        }

        public SortedFloatSetBackedByList(@LiveValue FloatList presortedOrEmptyUnderlying) {
            this.underlying = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static SortedFloatSetBackedByList sorted(@ReadonlyValue @SnapshotValue Collection<Float> c) {
            float[] a = PrimitiveCollections.toFloatArray(c);
            Arrays.sort(a);
            return new SortedFloatSetBackedByList(new FloatArrayList(a));
        }

        @Override
        @LiveValue
        public FloatList getUnderlying() {
            return this.underlying;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.getUnderlying());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.getUnderlying());
        }

        @Override
        public boolean addFloat(float value) {
            int insertionPoint = SortingUtilities.findInsertionPointInSet(this.underlying, 0, this.size(), value);
            if (insertionPoint < 0) {
                return false;
            }
            this.underlying.insertFloat(insertionPoint, value);
            return true;
        }

        public int indexOfFloat(float value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.underlying, 0, this.size(), value);
        }

        @Override
        public boolean removeFloat(float value) {
            int i = this.indexOfFloat(value);
            if (i == -1) {
                return false;
            }
            this.removeByIndex(i);
            return true;
        }

        @Override
        public boolean containsFloat(float value) {
            return this.indexOfFloat(value) != -1;
        }

        public boolean equivalent(SortedFloatSetBackedByList other) {
            return this.underlying.equivalent(other.getUnderlying());
        }

        @Override
        public float[] toFloatArray() {
            return this.toSortedFloatArray();
        }

        @ThrowAwayValue
        public float[] toSortedFloatArray() {
            return this.underlying.toFloatArray();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        public float removeFloatByIndex(int index) {
            return this.underlying.removeFloatByIndex(index);
        }

        public void removeByIndex(int index) {
            this.underlying.removeByIndex(index);
        }

        public void removeRange(int start, int end) {
            this.underlying.removeRange(start, end);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public float getFloat(int index) {
            return this.underlying.getFloat(index);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        @Override
        public SimpleFloatIterator newSimpleFloatIterator() {
            return this.underlying.newSimpleFloatIterator();
        }

        public SortedFloatSetBackedByList clone() {
            return new SortedFloatSetBackedByList(this.underlying.clone());
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class SortedIntegerSetBackedByList
    implements IntegerSet,
    UnderlyingInstanceAccessible<IntegerList>,
    KnowsLengthFixedness {
        protected IntegerList underlying;

        public SortedIntegerSetBackedByList() {
            this(new IntegerArrayList());
        }

        public SortedIntegerSetBackedByList(@LiveValue IntegerList presortedOrEmptyUnderlying) {
            this.underlying = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static SortedIntegerSetBackedByList sorted(@ReadonlyValue @SnapshotValue Collection<Integer> c) {
            int[] a = PrimitiveCollections.toIntArray(c);
            Arrays.sort(a);
            return new SortedIntegerSetBackedByList(new IntegerArrayList(a));
        }

        @Override
        @LiveValue
        public IntegerList getUnderlying() {
            return this.underlying;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.getUnderlying());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.getUnderlying());
        }

        @Override
        public boolean addInt(int value) {
            int insertionPoint = SortingUtilities.findInsertionPointInSet(this.underlying, 0, this.size(), value);
            if (insertionPoint < 0) {
                return false;
            }
            this.underlying.insertInt(insertionPoint, value);
            return true;
        }

        public int indexOfInt(int value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.underlying, 0, this.size(), value);
        }

        @Override
        public boolean removeInt(int value) {
            int i = this.indexOfInt(value);
            if (i == -1) {
                return false;
            }
            this.removeByIndex(i);
            return true;
        }

        @Override
        public boolean containsInt(int value) {
            return this.indexOfInt(value) != -1;
        }

        public boolean equivalent(SortedIntegerSetBackedByList other) {
            return this.underlying.equivalent(other.getUnderlying());
        }

        @Override
        public int[] toIntArray() {
            return this.toSortedIntArray();
        }

        @ThrowAwayValue
        public int[] toSortedIntArray() {
            return this.underlying.toIntArray();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        public int removeIntByIndex(int index) {
            return this.underlying.removeIntByIndex(index);
        }

        public void removeByIndex(int index) {
            this.underlying.removeByIndex(index);
        }

        public void removeRange(int start, int end) {
            this.underlying.removeRange(start, end);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public int getInt(int index) {
            return this.underlying.getInt(index);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        @Override
        public SimpleIntegerIterator newSimpleIntegerIterator() {
            return this.underlying.newSimpleIntegerIterator();
        }

        public SortedIntegerSetBackedByList clone() {
            return new SortedIntegerSetBackedByList(this.underlying.clone());
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class SortedLongSetBackedByList
    implements LongSet,
    UnderlyingInstanceAccessible<LongList>,
    KnowsLengthFixedness {
        protected LongList underlying;

        public SortedLongSetBackedByList() {
            this(new LongArrayList());
        }

        public SortedLongSetBackedByList(@LiveValue LongList presortedOrEmptyUnderlying) {
            this.underlying = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static SortedLongSetBackedByList sorted(@ReadonlyValue @SnapshotValue Collection<Long> c) {
            long[] a = PrimitiveCollections.toLongArray(c);
            Arrays.sort(a);
            return new SortedLongSetBackedByList(new LongArrayList(a));
        }

        @Override
        @LiveValue
        public LongList getUnderlying() {
            return this.underlying;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.getUnderlying());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.getUnderlying());
        }

        @Override
        public boolean addLong(long value) {
            int insertionPoint = SortingUtilities.findInsertionPointInSet(this.underlying, 0, this.size(), value);
            if (insertionPoint < 0) {
                return false;
            }
            this.underlying.insertLong(insertionPoint, value);
            return true;
        }

        public int indexOfLong(long value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.underlying, 0, this.size(), value);
        }

        @Override
        public boolean removeLong(long value) {
            int i = this.indexOfLong(value);
            if (i == -1) {
                return false;
            }
            this.removeByIndex(i);
            return true;
        }

        @Override
        public boolean containsLong(long value) {
            return this.indexOfLong(value) != -1;
        }

        public boolean equivalent(SortedLongSetBackedByList other) {
            return this.underlying.equivalent(other.getUnderlying());
        }

        @Override
        public long[] toLongArray() {
            return this.toSortedLongArray();
        }

        @ThrowAwayValue
        public long[] toSortedLongArray() {
            return this.underlying.toLongArray();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        public long removeLongByIndex(int index) {
            return this.underlying.removeLongByIndex(index);
        }

        public void removeByIndex(int index) {
            this.underlying.removeByIndex(index);
        }

        public void removeRange(int start, int end) {
            this.underlying.removeRange(start, end);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public long getLong(int index) {
            return this.underlying.getLong(index);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        @Override
        public SimpleLongIterator newSimpleLongIterator() {
            return this.underlying.newSimpleLongIterator();
        }

        public SortedLongSetBackedByList clone() {
            return new SortedLongSetBackedByList(this.underlying.clone());
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class SortedShortSetBackedByList
    implements ShortSet,
    UnderlyingInstanceAccessible<ShortList>,
    KnowsLengthFixedness {
        protected ShortList underlying;

        public SortedShortSetBackedByList() {
            this(new ShortArrayList());
        }

        public SortedShortSetBackedByList(@LiveValue ShortList presortedOrEmptyUnderlying) {
            this.underlying = Objects.requireNonNull(presortedOrEmptyUnderlying);
        }

        public static SortedShortSetBackedByList sorted(@ReadonlyValue @SnapshotValue Collection<Short> c) {
            short[] a = PrimitiveCollections.toShortArray(c);
            Arrays.sort(a);
            return new SortedShortSetBackedByList(new ShortArrayList(a));
        }

        @Override
        @LiveValue
        public ShortList getUnderlying() {
            return this.underlying;
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.getUnderlying());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.getUnderlying());
        }

        @Override
        public boolean addShort(short value) {
            int insertionPoint = SortingUtilities.findInsertionPointInSet(this.underlying, 0, this.size(), value);
            if (insertionPoint < 0) {
                return false;
            }
            this.underlying.insertShort(insertionPoint, value);
            return true;
        }

        public int indexOfShort(short value) {
            return SortingUtilities.findIndexForValueInSortedSet(this.underlying, 0, this.size(), value);
        }

        @Override
        public boolean removeShort(short value) {
            int i = this.indexOfShort(value);
            if (i == -1) {
                return false;
            }
            this.removeByIndex(i);
            return true;
        }

        @Override
        public boolean containsShort(short value) {
            return this.indexOfShort(value) != -1;
        }

        public boolean equivalent(SortedShortSetBackedByList other) {
            return this.underlying.equivalent(other.getUnderlying());
        }

        @Override
        public short[] toShortArray() {
            return this.toSortedShortArray();
        }

        @ThrowAwayValue
        public short[] toSortedShortArray() {
            return this.underlying.toShortArray();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        public short removeShortByIndex(int index) {
            return this.underlying.removeShortByIndex(index);
        }

        public void removeByIndex(int index) {
            this.underlying.removeByIndex(index);
        }

        public void removeRange(int start, int end) {
            this.underlying.removeRange(start, end);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public short getShort(int index) {
            return this.underlying.getShort(index);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        @Override
        public SimpleShortIterator newSimpleShortIterator() {
            return this.underlying.newSimpleShortIterator();
        }

        public SortedShortSetBackedByList clone() {
            return new SortedShortSetBackedByList(this.underlying.clone());
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperBooleanCollection
    implements BooleanCollection {
        protected final Collection<Boolean> underlying;

        public UnboxingWrapperBooleanCollection(Collection<Boolean> underlying) {
            this.underlying = underlying;
        }

        public BooleanCollection clone() {
            return PrimitiveCollections.booleanArrayAsMutableList(this.toBooleanArray());
        }

        @Override
        public boolean addBoolean(boolean value) {
            return this.underlying.add(value);
        }

        @Override
        public SimpleBooleanIterator newSimpleBooleanIterator() {
            return SimpleBooleanIterable.defaultNewSimpleBooleanIterator(this.underlying.iterator());
        }

        @Override
        public boolean removeBoolean(boolean value) {
            return this.underlying.remove(value);
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Boolean> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Boolean> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Boolean e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Boolean> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super Boolean> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Boolean> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Boolean> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Boolean> parallelStream() {
            return this.underlying.parallelStream();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperBooleanList
    implements BooleanList {
        protected final List<Boolean> underlying;

        public UnboxingWrapperBooleanList(List<Boolean> underlying) {
            this.underlying = underlying;
        }

        @Override
        public boolean getBoolean(int index) {
            return this.underlying.get(index);
        }

        @Override
        public void setBoolean(int index, boolean value) {
            this.underlying.set(index, value);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.removeRange(this.underlying, start, pastEnd);
        }

        @Override
        public void insertBoolean(int index, boolean value) {
            this.underlying.add(index, value);
        }

        @Override
        public void setSize(int newSize) {
            CollectionUtilities.setListSize(this.underlying, newSize);
        }

        @Override
        public void setSizeBoolean(int newSize, boolean elementToAddIfGrowing) {
            CollectionUtilities.setListSize(this.underlying, newSize, elementToAddIfGrowing);
        }

        @Override
        public BooleanList clone() {
            return PrimitiveCollections.booleanArrayAsMutableList(this.toBooleanArray());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Boolean> action) {
            this.underlying.forEach(action);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Boolean> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Boolean e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Boolean> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Boolean> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Boolean> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Boolean> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Boolean> c) {
            this.underlying.sort(c);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Boolean get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Boolean set(int index, Boolean element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Boolean element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Boolean> stream() {
            return this.underlying.stream();
        }

        @Override
        public Boolean remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Boolean> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public ListIterator<Boolean> listIterator() {
            return this.underlying.listIterator();
        }

        @Override
        public ListIterator<Boolean> listIterator(int index) {
            return this.underlying.listIterator(index);
        }

        @Override
        public Spliterator<Boolean> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperBooleanSet
    extends UnboxingWrapperBooleanCollection
    implements BooleanCollection,
    Set<Boolean> {
        public UnboxingWrapperBooleanSet(Set<Boolean> underlying) {
            super(underlying);
        }
    }

    public static class UnboxingWrapperByteCollection
    implements ByteCollection {
        protected final Collection<Byte> underlying;

        public UnboxingWrapperByteCollection(Collection<Byte> underlying) {
            this.underlying = underlying;
        }

        public ByteCollection clone() {
            return PrimitiveCollections.byteArrayAsMutableList(this.toByteArray());
        }

        @Override
        public boolean addByte(byte value) {
            return this.underlying.add(value);
        }

        @Override
        public SimpleByteIterator newSimpleByteIterator() {
            return SimpleByteIterable.defaultNewSimpleByteIterator(this.underlying.iterator());
        }

        @Override
        public boolean removeByte(byte value) {
            return this.underlying.remove(value);
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Byte> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Byte> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Byte e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Byte> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super Byte> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Byte> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Byte> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Byte> parallelStream() {
            return this.underlying.parallelStream();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperByteList
    implements ByteList {
        protected final List<Byte> underlying;

        public UnboxingWrapperByteList(List<Byte> underlying) {
            this.underlying = underlying;
        }

        @Override
        public byte getByte(int index) {
            return this.underlying.get(index);
        }

        @Override
        public void setByte(int index, byte value) {
            this.underlying.set(index, value);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.removeRange(this.underlying, start, pastEnd);
        }

        @Override
        public void insertByte(int index, byte value) {
            this.underlying.add(index, value);
        }

        @Override
        public void setSize(int newSize) {
            CollectionUtilities.setListSize(this.underlying, newSize);
        }

        @Override
        public void setSizeByte(int newSize, byte elementToAddIfGrowing) {
            CollectionUtilities.setListSize(this.underlying, newSize, elementToAddIfGrowing);
        }

        @Override
        public ByteList clone() {
            return PrimitiveCollections.byteArrayAsMutableList(this.toByteArray());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Byte> action) {
            this.underlying.forEach(action);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Byte> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Byte e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Byte> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Byte> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Byte> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Byte> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Byte> c) {
            this.underlying.sort(c);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Byte get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Byte set(int index, Byte element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Byte element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Byte> stream() {
            return this.underlying.stream();
        }

        @Override
        public Byte remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Byte> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public ListIterator<Byte> listIterator() {
            return this.underlying.listIterator();
        }

        @Override
        public ListIterator<Byte> listIterator(int index) {
            return this.underlying.listIterator(index);
        }

        @Override
        public Spliterator<Byte> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperByteSet
    extends UnboxingWrapperByteCollection
    implements ByteCollection,
    Set<Byte> {
        public UnboxingWrapperByteSet(Set<Byte> underlying) {
            super(underlying);
        }
    }

    public static class UnboxingWrapperCharacterCollection
    implements CharacterCollection {
        protected final Collection<Character> underlying;

        public UnboxingWrapperCharacterCollection(Collection<Character> underlying) {
            this.underlying = underlying;
        }

        public CharacterCollection clone() {
            return PrimitiveCollections.charArrayAsMutableList(this.toCharArray());
        }

        @Override
        public boolean addChar(char value) {
            return this.underlying.add(Character.valueOf(value));
        }

        @Override
        public SimpleCharacterIterator newSimpleCharacterIterator() {
            return SimpleCharacterIterable.defaultNewSimpleCharacterIterator(this.underlying.iterator());
        }

        @Override
        public boolean removeChar(char value) {
            return this.underlying.remove(Character.valueOf(value));
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Character> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Character> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Character e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Character> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super Character> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Character> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Character> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Character> parallelStream() {
            return this.underlying.parallelStream();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperCharacterList
    implements CharacterList {
        protected final List<Character> underlying;

        public UnboxingWrapperCharacterList(List<Character> underlying) {
            this.underlying = underlying;
        }

        @Override
        public char getChar(int index) {
            return this.underlying.get(index).charValue();
        }

        @Override
        public void setChar(int index, char value) {
            this.underlying.set(index, Character.valueOf(value));
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.removeRange(this.underlying, start, pastEnd);
        }

        @Override
        public void insertChar(int index, char value) {
            this.underlying.add(index, Character.valueOf(value));
        }

        @Override
        public void setSize(int newSize) {
            CollectionUtilities.setListSize(this.underlying, newSize);
        }

        @Override
        public void setSizeChar(int newSize, char elementToAddIfGrowing) {
            CollectionUtilities.setListSize(this.underlying, newSize, Character.valueOf(elementToAddIfGrowing));
        }

        @Override
        public CharacterList clone() {
            return PrimitiveCollections.charArrayAsMutableList(this.toCharArray());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Character> action) {
            this.underlying.forEach(action);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Character> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Character e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Character> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Character> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Character> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Character> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Character> c) {
            this.underlying.sort(c);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Character get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Character set(int index, Character element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Character element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Character> stream() {
            return this.underlying.stream();
        }

        @Override
        public Character remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Character> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public ListIterator<Character> listIterator() {
            return this.underlying.listIterator();
        }

        @Override
        public ListIterator<Character> listIterator(int index) {
            return this.underlying.listIterator(index);
        }

        @Override
        public Spliterator<Character> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperCharacterSet
    extends UnboxingWrapperCharacterCollection
    implements CharacterCollection,
    Set<Character> {
        public UnboxingWrapperCharacterSet(Set<Character> underlying) {
            super(underlying);
        }
    }

    public static class UnboxingWrapperDoubleCollection
    implements DoubleCollection {
        protected final Collection<Double> underlying;

        public UnboxingWrapperDoubleCollection(Collection<Double> underlying) {
            this.underlying = underlying;
        }

        public DoubleCollection clone() {
            return PrimitiveCollections.doubleArrayAsMutableList(this.toDoubleArray());
        }

        @Override
        public boolean addDouble(double value) {
            return this.underlying.add(value);
        }

        @Override
        public SimpleDoubleIterator newSimpleDoubleIterator() {
            return SimpleDoubleIterable.defaultNewSimpleDoubleIterator(this.underlying.iterator());
        }

        @Override
        public boolean removeDouble(double value) {
            return this.underlying.remove(value);
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Double> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Double> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Double e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Double> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super Double> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Double> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Double> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Double> parallelStream() {
            return this.underlying.parallelStream();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperDoubleList
    implements DoubleList {
        protected final List<Double> underlying;

        public UnboxingWrapperDoubleList(List<Double> underlying) {
            this.underlying = underlying;
        }

        @Override
        public double getDouble(int index) {
            return this.underlying.get(index);
        }

        @Override
        public void setDouble(int index, double value) {
            this.underlying.set(index, value);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.removeRange(this.underlying, start, pastEnd);
        }

        @Override
        public void insertDouble(int index, double value) {
            this.underlying.add(index, value);
        }

        @Override
        public void setSize(int newSize) {
            CollectionUtilities.setListSize(this.underlying, newSize);
        }

        @Override
        public void setSizeDouble(int newSize, double elementToAddIfGrowing) {
            CollectionUtilities.setListSize(this.underlying, newSize, elementToAddIfGrowing);
        }

        @Override
        public DoubleList clone() {
            return PrimitiveCollections.doubleArrayAsMutableList(this.toDoubleArray());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Double> action) {
            this.underlying.forEach(action);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Double> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Double e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Double> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Double> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Double> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Double> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Double> c) {
            this.underlying.sort(c);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Double get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Double set(int index, Double element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Double element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Double> stream() {
            return this.underlying.stream();
        }

        @Override
        public Double remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Double> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public ListIterator<Double> listIterator() {
            return this.underlying.listIterator();
        }

        @Override
        public ListIterator<Double> listIterator(int index) {
            return this.underlying.listIterator(index);
        }

        @Override
        public Spliterator<Double> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperDoubleSet
    extends UnboxingWrapperDoubleCollection
    implements DoubleCollection,
    Set<Double> {
        public UnboxingWrapperDoubleSet(Set<Double> underlying) {
            super(underlying);
        }
    }

    public static class UnboxingWrapperFloatCollection
    implements FloatCollection {
        protected final Collection<Float> underlying;

        public UnboxingWrapperFloatCollection(Collection<Float> underlying) {
            this.underlying = underlying;
        }

        public FloatCollection clone() {
            return PrimitiveCollections.floatArrayAsMutableList(this.toFloatArray());
        }

        @Override
        public boolean addFloat(float value) {
            return this.underlying.add(Float.valueOf(value));
        }

        @Override
        public SimpleFloatIterator newSimpleFloatIterator() {
            return SimpleFloatIterable.defaultNewSimpleFloatIterator(this.underlying.iterator());
        }

        @Override
        public boolean removeFloat(float value) {
            return this.underlying.remove(Float.valueOf(value));
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Float> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Float> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Float e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Float> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super Float> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Float> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Float> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Float> parallelStream() {
            return this.underlying.parallelStream();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperFloatList
    implements FloatList {
        protected final List<Float> underlying;

        public UnboxingWrapperFloatList(List<Float> underlying) {
            this.underlying = underlying;
        }

        @Override
        public float getFloat(int index) {
            return this.underlying.get(index).floatValue();
        }

        @Override
        public void setFloat(int index, float value) {
            this.underlying.set(index, Float.valueOf(value));
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.removeRange(this.underlying, start, pastEnd);
        }

        @Override
        public void insertFloat(int index, float value) {
            this.underlying.add(index, Float.valueOf(value));
        }

        @Override
        public void setSize(int newSize) {
            CollectionUtilities.setListSize(this.underlying, newSize);
        }

        @Override
        public void setSizeFloat(int newSize, float elementToAddIfGrowing) {
            CollectionUtilities.setListSize(this.underlying, newSize, Float.valueOf(elementToAddIfGrowing));
        }

        @Override
        public FloatList clone() {
            return PrimitiveCollections.floatArrayAsMutableList(this.toFloatArray());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Float> action) {
            this.underlying.forEach(action);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Float> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Float e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Float> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Float> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Float> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Float> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Float> c) {
            this.underlying.sort(c);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Float get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Float set(int index, Float element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Float element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Float> stream() {
            return this.underlying.stream();
        }

        @Override
        public Float remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Float> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public ListIterator<Float> listIterator() {
            return this.underlying.listIterator();
        }

        @Override
        public ListIterator<Float> listIterator(int index) {
            return this.underlying.listIterator(index);
        }

        @Override
        public Spliterator<Float> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperFloatSet
    extends UnboxingWrapperFloatCollection
    implements FloatCollection,
    Set<Float> {
        public UnboxingWrapperFloatSet(Set<Float> underlying) {
            super(underlying);
        }
    }

    public static class UnboxingWrapperIntegerCollection
    implements IntegerCollection {
        protected final Collection<Integer> underlying;

        public UnboxingWrapperIntegerCollection(Collection<Integer> underlying) {
            this.underlying = underlying;
        }

        public IntegerCollection clone() {
            return PrimitiveCollections.intArrayAsMutableList(this.toIntArray());
        }

        @Override
        public boolean addInt(int value) {
            return this.underlying.add(value);
        }

        @Override
        public SimpleIntegerIterator newSimpleIntegerIterator() {
            return SimpleIntegerIterable.defaultNewSimpleIntegerIterator(this.underlying.iterator());
        }

        @Override
        public boolean removeInt(int value) {
            return this.underlying.remove(value);
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Integer> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Integer e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super Integer> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Integer> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Integer> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Integer> parallelStream() {
            return this.underlying.parallelStream();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperIntegerList
    implements IntegerList {
        protected final List<Integer> underlying;

        public UnboxingWrapperIntegerList(List<Integer> underlying) {
            this.underlying = underlying;
        }

        @Override
        public int getInt(int index) {
            return this.underlying.get(index);
        }

        @Override
        public void setInt(int index, int value) {
            this.underlying.set(index, value);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.removeRange(this.underlying, start, pastEnd);
        }

        @Override
        public void insertInt(int index, int value) {
            this.underlying.add(index, value);
        }

        @Override
        public void setSize(int newSize) {
            CollectionUtilities.setListSize(this.underlying, newSize);
        }

        @Override
        public void setSizeInt(int newSize, int elementToAddIfGrowing) {
            CollectionUtilities.setListSize(this.underlying, newSize, elementToAddIfGrowing);
        }

        @Override
        public IntegerList clone() {
            return PrimitiveCollections.intArrayAsMutableList(this.toIntArray());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Integer> action) {
            this.underlying.forEach(action);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Integer e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Integer> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Integer> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Integer> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Integer> c) {
            this.underlying.sort(c);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Integer get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Integer set(int index, Integer element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Integer element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Integer> stream() {
            return this.underlying.stream();
        }

        @Override
        public Integer remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Integer> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public ListIterator<Integer> listIterator() {
            return this.underlying.listIterator();
        }

        @Override
        public ListIterator<Integer> listIterator(int index) {
            return this.underlying.listIterator(index);
        }

        @Override
        public Spliterator<Integer> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperIntegerSet
    extends UnboxingWrapperIntegerCollection
    implements IntegerCollection,
    Set<Integer> {
        public UnboxingWrapperIntegerSet(Set<Integer> underlying) {
            super(underlying);
        }
    }

    public static class UnboxingWrapperLongCollection
    implements LongCollection {
        protected final Collection<Long> underlying;

        public UnboxingWrapperLongCollection(Collection<Long> underlying) {
            this.underlying = underlying;
        }

        public LongCollection clone() {
            return PrimitiveCollections.longArrayAsMutableList(this.toLongArray());
        }

        @Override
        public boolean addLong(long value) {
            return this.underlying.add(value);
        }

        @Override
        public SimpleLongIterator newSimpleLongIterator() {
            return SimpleLongIterable.defaultNewSimpleLongIterator(this.underlying.iterator());
        }

        @Override
        public boolean removeLong(long value) {
            return this.underlying.remove(value);
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Long> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Long> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Long e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Long> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super Long> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Long> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Long> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Long> parallelStream() {
            return this.underlying.parallelStream();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperLongList
    implements LongList {
        protected final List<Long> underlying;

        public UnboxingWrapperLongList(List<Long> underlying) {
            this.underlying = underlying;
        }

        @Override
        public long getLong(int index) {
            return this.underlying.get(index);
        }

        @Override
        public void setLong(int index, long value) {
            this.underlying.set(index, value);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.removeRange(this.underlying, start, pastEnd);
        }

        @Override
        public void insertLong(int index, long value) {
            this.underlying.add(index, value);
        }

        @Override
        public void setSize(int newSize) {
            CollectionUtilities.setListSize(this.underlying, newSize);
        }

        @Override
        public void setSizeLong(int newSize, long elementToAddIfGrowing) {
            CollectionUtilities.setListSize(this.underlying, newSize, elementToAddIfGrowing);
        }

        @Override
        public LongList clone() {
            return PrimitiveCollections.longArrayAsMutableList(this.toLongArray());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Long> action) {
            this.underlying.forEach(action);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Long> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Long e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Long> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Long> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Long> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Long> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Long> c) {
            this.underlying.sort(c);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Long get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Long set(int index, Long element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Long element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Long> stream() {
            return this.underlying.stream();
        }

        @Override
        public Long remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Long> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public ListIterator<Long> listIterator() {
            return this.underlying.listIterator();
        }

        @Override
        public ListIterator<Long> listIterator(int index) {
            return this.underlying.listIterator(index);
        }

        @Override
        public Spliterator<Long> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperLongSet
    extends UnboxingWrapperLongCollection
    implements LongCollection,
    Set<Long> {
        public UnboxingWrapperLongSet(Set<Long> underlying) {
            super(underlying);
        }
    }

    public static class UnboxingWrapperShortCollection
    implements ShortCollection {
        protected final Collection<Short> underlying;

        public UnboxingWrapperShortCollection(Collection<Short> underlying) {
            this.underlying = underlying;
        }

        public ShortCollection clone() {
            return PrimitiveCollections.shortArrayAsMutableList(this.toShortArray());
        }

        @Override
        public boolean addShort(short value) {
            return this.underlying.add(value);
        }

        @Override
        public SimpleShortIterator newSimpleShortIterator() {
            return SimpleShortIterable.defaultNewSimpleShortIterator(this.underlying.iterator());
        }

        @Override
        public boolean removeShort(short value) {
            return this.underlying.remove(value);
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Short> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Short e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Short> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Short> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Short> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Short> parallelStream() {
            return this.underlying.parallelStream();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperShortList
    implements ShortList {
        protected final List<Short> underlying;

        public UnboxingWrapperShortList(List<Short> underlying) {
            this.underlying = underlying;
        }

        @Override
        public short getShort(int index) {
            return this.underlying.get(index);
        }

        @Override
        public void setShort(int index, short value) {
            this.underlying.set(index, value);
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            CollectionUtilities.removeRange(this.underlying, start, pastEnd);
        }

        @Override
        public void insertShort(int index, short value) {
            this.underlying.add(index, value);
        }

        @Override
        public void setSize(int newSize) {
            CollectionUtilities.setListSize(this.underlying, newSize);
        }

        @Override
        public void setSizeShort(int newSize, short elementToAddIfGrowing) {
            CollectionUtilities.setListSize(this.underlying, newSize, elementToAddIfGrowing);
        }

        @Override
        public ShortList clone() {
            return PrimitiveCollections.shortArrayAsMutableList(this.toShortArray());
        }

        @Override
        public Boolean isWritableCollection() {
            return PolymorphicCollectionUtilities.isWritableCollection(this.underlying);
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            this.underlying.forEach(action);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Iterator<Short> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public boolean add(Short e) {
            return this.underlying.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.underlying.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Short> c) {
            return this.underlying.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Short> c) {
            return this.underlying.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.underlying.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.underlying.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<Short> operator) {
            this.underlying.replaceAll(operator);
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            return this.underlying.removeIf(filter);
        }

        @Override
        public void sort(Comparator<? super Short> c) {
            this.underlying.sort(c);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Short get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public Short set(int index, Short element) {
            return this.underlying.set(index, element);
        }

        @Override
        public void add(int index, Short element) {
            this.underlying.add(index, element);
        }

        @Override
        public Stream<Short> stream() {
            return this.underlying.stream();
        }

        @Override
        public Short remove(int index) {
            return this.underlying.remove(index);
        }

        @Override
        public Stream<Short> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public ListIterator<Short> listIterator() {
            return this.underlying.listIterator();
        }

        @Override
        public ListIterator<Short> listIterator(int index) {
            return this.underlying.listIterator(index);
        }

        @Override
        public Spliterator<Short> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public void clear() {
            this.underlying.clear();
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnboxingWrapperShortSet
    extends UnboxingWrapperShortCollection
    implements ShortCollection,
    Set<Short> {
        public UnboxingWrapperShortSet(Set<Short> underlying) {
            super(underlying);
        }
    }

    public static class UnmodifiableBooleanListWrapper
    implements BooleanList,
    KnowsLengthFixedness,
    TransparentContiguousArrayBackedCollection {
        protected final BooleanList underlying;

        public UnmodifiableBooleanListWrapper(BooleanList underlying) {
            this.underlying = underlying;
        }

        @ImplementationTransparency
        public BooleanList getUnderlying() {
            return this.underlying;
        }

        @Override
        public UnmodifiableBooleanListWrapper clone() {
            return new UnmodifiableBooleanListWrapper(this.underlying.clone());
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.underlying);
        }

        @Override
        public boolean isTransparentContiguousArrayBackedCollection() {
            return TransparentContiguousArrayBackedCollection.is(this.underlying);
        }

        public Slice getLiveContiguousArrayBackingUNSAFE() {
            return ((TransparentContiguousArrayBackedCollection)((Object)this.underlying)).getLiveContiguousArrayBackingUNSAFE();
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRangeByLength(int start, int length) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<Boolean> operator) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super Boolean> filter) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super Boolean> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Boolean remove(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllBooleans(boolean[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllBooleans(Slice<boolean[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllBooleans(boolean[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllBooleans(Slice<boolean[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllBooleans(boolean[] a, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setBoolean(int index, boolean value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertBoolean(int index, boolean value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeBoolean(int newSize, boolean elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize, Boolean elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllBooleans(int index, boolean[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllBooleans(int index, Slice<boolean[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllBooleans(int index, boolean[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAll(int destIndex, List sourceU, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addBoolean(boolean value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Boolean> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllBooleans(boolean[] elements, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeBooleanByIndex(int index) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeBoolean(boolean value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllBooleans(int index, boolean[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Boolean> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllBooleans(int index, boolean[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllBooleans(int index, Slice<boolean[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Boolean set(int index, Boolean value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void add(int index, Boolean value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean add(Boolean e) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super Boolean> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Boolean> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Boolean> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Boolean> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public boolean getBoolean(int index) {
            return this.underlying.getBoolean(index);
        }

        @Override
        public int indexOfBoolean(boolean value) {
            return this.underlying.indexOfBoolean(value);
        }

        @Override
        public int lastIndexOfBoolean(boolean value) {
            return this.underlying.lastIndexOfBoolean(value);
        }

        public boolean equivalent(List<Boolean> other) {
            return this.underlying.equivalent(other);
        }

        @Override
        public boolean[] toBooleanArray() {
            return this.underlying.toBooleanArray();
        }

        @Override
        public boolean containsBoolean(boolean value) {
            return this.underlying.containsBoolean(value);
        }

        @Override
        public Boolean get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnmodifiableByteListWrapper
    implements ByteList,
    KnowsLengthFixedness,
    TransparentContiguousArrayBackedCollection {
        protected final ByteList underlying;

        public UnmodifiableByteListWrapper(ByteList underlying) {
            this.underlying = underlying;
        }

        @ImplementationTransparency
        public ByteList getUnderlying() {
            return this.underlying;
        }

        @Override
        public UnmodifiableByteListWrapper clone() {
            return new UnmodifiableByteListWrapper(this.underlying.clone());
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.underlying);
        }

        @Override
        public boolean isTransparentContiguousArrayBackedCollection() {
            return TransparentContiguousArrayBackedCollection.is(this.underlying);
        }

        public Slice getLiveContiguousArrayBackingUNSAFE() {
            return ((TransparentContiguousArrayBackedCollection)((Object)this.underlying)).getLiveContiguousArrayBackingUNSAFE();
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRangeByLength(int start, int length) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<Byte> operator) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super Byte> filter) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super Byte> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Byte remove(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllBytes(byte[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllBytes(Slice<byte[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllBytes(byte[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllBytes(Slice<byte[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllBytes(byte[] a, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setByte(int index, byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertByte(int index, byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeByte(int newSize, byte elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize, Byte elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllBytes(int index, byte[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllBytes(int index, Slice<byte[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllBytes(int index, byte[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAll(int destIndex, List sourceU, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addByte(byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Byte> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllBytes(byte[] elements, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public byte removeByteByIndex(int index) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeByte(byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllBytes(int index, byte[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Byte> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllBytes(int index, byte[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllBytes(int index, Slice<byte[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Byte set(int index, Byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void add(int index, Byte value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean add(Byte e) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super Byte> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Byte> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Byte> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Byte> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public byte getByte(int index) {
            return this.underlying.getByte(index);
        }

        @Override
        public int indexOfByte(byte value) {
            return this.underlying.indexOfByte(value);
        }

        @Override
        public int lastIndexOfByte(byte value) {
            return this.underlying.lastIndexOfByte(value);
        }

        public boolean equivalent(List<Byte> other) {
            return this.underlying.equivalent(other);
        }

        @Override
        public byte[] toByteArray() {
            return this.underlying.toByteArray();
        }

        @Override
        public boolean containsByte(byte value) {
            return this.underlying.containsByte(value);
        }

        @Override
        public Byte get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnmodifiableCharacterListWrapper
    implements CharacterList,
    KnowsLengthFixedness,
    TransparentContiguousArrayBackedCollection {
        protected final CharacterList underlying;

        public UnmodifiableCharacterListWrapper(CharacterList underlying) {
            this.underlying = underlying;
        }

        @ImplementationTransparency
        public CharacterList getUnderlying() {
            return this.underlying;
        }

        @Override
        public UnmodifiableCharacterListWrapper clone() {
            return new UnmodifiableCharacterListWrapper(this.underlying.clone());
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.underlying);
        }

        @Override
        public boolean isTransparentContiguousArrayBackedCollection() {
            return TransparentContiguousArrayBackedCollection.is(this.underlying);
        }

        public Slice getLiveContiguousArrayBackingUNSAFE() {
            return ((TransparentContiguousArrayBackedCollection)((Object)this.underlying)).getLiveContiguousArrayBackingUNSAFE();
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRangeByLength(int start, int length) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<Character> operator) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super Character> filter) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super Character> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Character remove(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllChars(char[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllChars(Slice<char[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllChars(char[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllChars(Slice<char[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllChars(char[] a, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setChar(int index, char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertChar(int index, char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeChar(int newSize, char elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize, Character elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllChars(int index, char[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllChars(int index, Slice<char[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllChars(int index, char[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAll(int destIndex, List sourceU, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addChar(char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Character> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllChars(char[] elements, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public char removeCharByIndex(int index) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeChar(char value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllChars(int index, char[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Character> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllChars(int index, char[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllChars(int index, Slice<char[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Character set(int index, Character value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void add(int index, Character value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean add(Character e) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super Character> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Character> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Character> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Character> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public char getChar(int index) {
            return this.underlying.getChar(index);
        }

        @Override
        public int indexOfChar(char value) {
            return this.underlying.indexOfChar(value);
        }

        @Override
        public int lastIndexOfChar(char value) {
            return this.underlying.lastIndexOfChar(value);
        }

        public boolean equivalent(List<Character> other) {
            return this.underlying.equivalent(other);
        }

        @Override
        public char[] toCharArray() {
            return this.underlying.toCharArray();
        }

        @Override
        public boolean containsChar(char value) {
            return this.underlying.containsChar(value);
        }

        @Override
        public Character get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        @Override
        public String toString() {
            return this._toString();
        }
    }

    public static class UnmodifiableDoubleListWrapper
    implements DoubleList,
    KnowsLengthFixedness,
    TransparentContiguousArrayBackedCollection {
        protected final DoubleList underlying;

        public UnmodifiableDoubleListWrapper(DoubleList underlying) {
            this.underlying = underlying;
        }

        @ImplementationTransparency
        public DoubleList getUnderlying() {
            return this.underlying;
        }

        @Override
        public UnmodifiableDoubleListWrapper clone() {
            return new UnmodifiableDoubleListWrapper(this.underlying.clone());
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.underlying);
        }

        @Override
        public boolean isTransparentContiguousArrayBackedCollection() {
            return TransparentContiguousArrayBackedCollection.is(this.underlying);
        }

        public Slice getLiveContiguousArrayBackingUNSAFE() {
            return ((TransparentContiguousArrayBackedCollection)((Object)this.underlying)).getLiveContiguousArrayBackingUNSAFE();
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRangeByLength(int start, int length) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<Double> operator) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super Double> filter) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super Double> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Double remove(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllDoubles(double[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllDoubles(Slice<double[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllDoubles(double[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllDoubles(Slice<double[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllDoubles(double[] a, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setDouble(int index, double value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertDouble(int index, double value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeDouble(int newSize, double elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize, Double elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllDoubles(int index, double[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllDoubles(int index, Slice<double[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllDoubles(int index, double[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAll(int destIndex, List sourceU, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addDouble(double value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Double> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllDoubles(double[] elements, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public double removeDoubleByIndex(int index) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeDouble(double value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllDoubles(int index, double[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Double> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllDoubles(int index, double[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllDoubles(int index, Slice<double[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Double set(int index, Double value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void add(int index, Double value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean add(Double e) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super Double> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Double> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Double> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Double> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public double getDouble(int index) {
            return this.underlying.getDouble(index);
        }

        @Override
        public int indexOfDouble(double value) {
            return this.underlying.indexOfDouble(value);
        }

        @Override
        public int lastIndexOfDouble(double value) {
            return this.underlying.lastIndexOfDouble(value);
        }

        public boolean equivalent(List<Double> other) {
            return this.underlying.equivalent(other);
        }

        @Override
        public double[] toDoubleArray() {
            return this.underlying.toDoubleArray();
        }

        @Override
        public boolean containsDouble(double value) {
            return this.underlying.containsDouble(value);
        }

        @Override
        public Double get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnmodifiableFloatListWrapper
    implements FloatList,
    KnowsLengthFixedness,
    TransparentContiguousArrayBackedCollection {
        protected final FloatList underlying;

        public UnmodifiableFloatListWrapper(FloatList underlying) {
            this.underlying = underlying;
        }

        @ImplementationTransparency
        public FloatList getUnderlying() {
            return this.underlying;
        }

        @Override
        public UnmodifiableFloatListWrapper clone() {
            return new UnmodifiableFloatListWrapper(this.underlying.clone());
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.underlying);
        }

        @Override
        public boolean isTransparentContiguousArrayBackedCollection() {
            return TransparentContiguousArrayBackedCollection.is(this.underlying);
        }

        public Slice getLiveContiguousArrayBackingUNSAFE() {
            return ((TransparentContiguousArrayBackedCollection)((Object)this.underlying)).getLiveContiguousArrayBackingUNSAFE();
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRangeByLength(int start, int length) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<Float> operator) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super Float> filter) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super Float> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Float remove(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllFloats(float[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllFloats(Slice<float[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllFloats(float[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllFloats(Slice<float[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllFloats(float[] a, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setFloat(int index, float value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertFloat(int index, float value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeFloat(int newSize, float elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize, Float elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllFloats(int index, float[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllFloats(int index, Slice<float[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllFloats(int index, float[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAll(int destIndex, List sourceU, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addFloat(float value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Float> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllFloats(float[] elements, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public float removeFloatByIndex(int index) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeFloat(float value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllFloats(int index, float[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Float> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllFloats(int index, float[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllFloats(int index, Slice<float[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Float set(int index, Float value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void add(int index, Float value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean add(Float e) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super Float> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Float> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Float> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Float> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public float getFloat(int index) {
            return this.underlying.getFloat(index);
        }

        @Override
        public int indexOfFloat(float value) {
            return this.underlying.indexOfFloat(value);
        }

        @Override
        public int lastIndexOfFloat(float value) {
            return this.underlying.lastIndexOfFloat(value);
        }

        public boolean equivalent(List<Float> other) {
            return this.underlying.equivalent(other);
        }

        @Override
        public float[] toFloatArray() {
            return this.underlying.toFloatArray();
        }

        @Override
        public boolean containsFloat(float value) {
            return this.underlying.containsFloat(value);
        }

        @Override
        public Float get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnmodifiableIntegerListWrapper
    implements IntegerList,
    KnowsLengthFixedness,
    TransparentContiguousArrayBackedCollection {
        protected final IntegerList underlying;

        public UnmodifiableIntegerListWrapper(IntegerList underlying) {
            this.underlying = underlying;
        }

        @ImplementationTransparency
        public IntegerList getUnderlying() {
            return this.underlying;
        }

        @Override
        public UnmodifiableIntegerListWrapper clone() {
            return new UnmodifiableIntegerListWrapper(this.underlying.clone());
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.underlying);
        }

        @Override
        public boolean isTransparentContiguousArrayBackedCollection() {
            return TransparentContiguousArrayBackedCollection.is(this.underlying);
        }

        public Slice getLiveContiguousArrayBackingUNSAFE() {
            return ((TransparentContiguousArrayBackedCollection)((Object)this.underlying)).getLiveContiguousArrayBackingUNSAFE();
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRangeByLength(int start, int length) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<Integer> operator) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super Integer> filter) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super Integer> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Integer remove(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllInts(int[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllInts(Slice<int[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllInts(int[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllInts(Slice<int[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllInts(int[] a, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setInt(int index, int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertInt(int index, int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeInt(int newSize, int elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize, Integer elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllInts(int index, int[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllInts(int index, Slice<int[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllInts(int index, int[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAll(int destIndex, List sourceU, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addInt(int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllInts(int[] elements, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public int removeIntByIndex(int index) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeInt(int value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllInts(int index, int[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Integer> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllInts(int index, int[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllInts(int index, Slice<int[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Integer set(int index, Integer value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void add(int index, Integer value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean add(Integer e) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super Integer> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Integer> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Integer> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Integer> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public int getInt(int index) {
            return this.underlying.getInt(index);
        }

        @Override
        public int indexOfInt(int value) {
            return this.underlying.indexOfInt(value);
        }

        @Override
        public int lastIndexOfInt(int value) {
            return this.underlying.lastIndexOfInt(value);
        }

        public boolean equivalent(List<Integer> other) {
            return this.underlying.equivalent(other);
        }

        @Override
        public int[] toIntArray() {
            return this.underlying.toIntArray();
        }

        @Override
        public boolean containsInt(int value) {
            return this.underlying.containsInt(value);
        }

        @Override
        public Integer get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnmodifiableLongListWrapper
    implements LongList,
    KnowsLengthFixedness,
    TransparentContiguousArrayBackedCollection {
        protected final LongList underlying;

        public UnmodifiableLongListWrapper(LongList underlying) {
            this.underlying = underlying;
        }

        @ImplementationTransparency
        public LongList getUnderlying() {
            return this.underlying;
        }

        @Override
        public UnmodifiableLongListWrapper clone() {
            return new UnmodifiableLongListWrapper(this.underlying.clone());
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.underlying);
        }

        @Override
        public boolean isTransparentContiguousArrayBackedCollection() {
            return TransparentContiguousArrayBackedCollection.is(this.underlying);
        }

        public Slice getLiveContiguousArrayBackingUNSAFE() {
            return ((TransparentContiguousArrayBackedCollection)((Object)this.underlying)).getLiveContiguousArrayBackingUNSAFE();
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRangeByLength(int start, int length) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<Long> operator) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super Long> filter) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super Long> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Long remove(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllLongs(long[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllLongs(Slice<long[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllLongs(long[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllLongs(Slice<long[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllLongs(long[] a, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setLong(int index, long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertLong(int index, long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeLong(int newSize, long elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize, Long elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllLongs(int index, long[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllLongs(int index, Slice<long[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllLongs(int index, long[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAll(int destIndex, List sourceU, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addLong(long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Long> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllLongs(long[] elements, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public long removeLongByIndex(int index) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeLong(long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllLongs(int index, long[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Long> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllLongs(int index, long[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllLongs(int index, Slice<long[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Long set(int index, Long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void add(int index, Long value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean add(Long e) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super Long> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Long> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Long> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Long> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public long getLong(int index) {
            return this.underlying.getLong(index);
        }

        @Override
        public int indexOfLong(long value) {
            return this.underlying.indexOfLong(value);
        }

        @Override
        public int lastIndexOfLong(long value) {
            return this.underlying.lastIndexOfLong(value);
        }

        public boolean equivalent(List<Long> other) {
            return this.underlying.equivalent(other);
        }

        @Override
        public long[] toLongArray() {
            return this.underlying.toLongArray();
        }

        @Override
        public boolean containsLong(long value) {
            return this.underlying.containsLong(value);
        }

        @Override
        public Long get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        public String toString() {
            return this._toString();
        }
    }

    public static class UnmodifiableShortListWrapper
    implements ShortList,
    KnowsLengthFixedness,
    TransparentContiguousArrayBackedCollection {
        protected final ShortList underlying;

        public UnmodifiableShortListWrapper(ShortList underlying) {
            this.underlying = underlying;
        }

        @ImplementationTransparency
        public ShortList getUnderlying() {
            return this.underlying;
        }

        @Override
        public UnmodifiableShortListWrapper clone() {
            return new UnmodifiableShortListWrapper(this.underlying.clone());
        }

        @Override
        public Boolean isFixedLengthNotVariableLength() {
            return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.underlying);
        }

        @Override
        public boolean isTransparentContiguousArrayBackedCollection() {
            return TransparentContiguousArrayBackedCollection.is(this.underlying);
        }

        public Slice getLiveContiguousArrayBackingUNSAFE() {
            return ((TransparentContiguousArrayBackedCollection)((Object)this.underlying)).getLiveContiguousArrayBackingUNSAFE();
        }

        @Override
        public Boolean isWritableCollection() {
            return false;
        }

        @Override
        public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeRangeByLength(int start, int length) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<Short> operator) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super Short> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Short remove(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllShorts(short[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllShorts(Slice<short[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllShorts(short[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllShorts(Slice<short[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeAllShorts(short[] a, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setShort(int index, short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertShort(int index, short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSizeShort(int newSize, short elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize, Short elementToAddIfGrowing) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllShorts(int index, short[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllShorts(int index, Slice<short[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAllShorts(int index, short[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void setAll(int destIndex, List sourceU, int sourceIndex, int amount) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addShort(short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Short> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAllShorts(short[] elements, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void removeByIndex(int index) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public short removeShortByIndex(int index) throws IndexOutOfBoundsException {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeShort(short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllShorts(int index, short[] array, int offset, int length) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Short> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllShorts(int index, short[] array) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void insertAllShorts(int index, Slice<short[]> arraySlice) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public Short set(int index, Short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void add(int index, Short value) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public boolean add(Short e) {
            throw new ReadonlyUnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            this.underlying.forEach(action);
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.underlying.equals(o);
        }

        @Override
        public int hashCode() {
            return this.underlying.hashCode();
        }

        @Override
        public Spliterator<Short> spliterator() {
            return this.underlying.spliterator();
        }

        @Override
        public Stream<Short> stream() {
            return this.underlying.stream();
        }

        @Override
        public Stream<Short> parallelStream() {
            return this.underlying.parallelStream();
        }

        @Override
        public short getShort(int index) {
            return this.underlying.getShort(index);
        }

        @Override
        public int indexOfShort(short value) {
            return this.underlying.indexOfShort(value);
        }

        @Override
        public int lastIndexOfShort(short value) {
            return this.underlying.lastIndexOfShort(value);
        }

        public boolean equivalent(List<Short> other) {
            return this.underlying.equivalent(other);
        }

        @Override
        public short[] toShortArray() {
            return this.underlying.toShortArray();
        }

        @Override
        public boolean containsShort(short value) {
            return this.underlying.containsShort(value);
        }

        @Override
        public Short get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.underlying.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.underlying.lastIndexOf(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.underlying.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.underlying.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.underlying.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.underlying.toArray(a);
        }

        @Override
        public void storeBoxingIntoArray(Slice<Object[]> array) {
            this.underlying.storeBoxingIntoArray(array);
        }

        public String toString() {
            return this._toString();
        }
    }
}

