/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import rebound.annotations.semantic.FunctionalityType;
import rebound.annotations.semantic.StaticTraitPredicate;
import rebound.annotations.semantic.TraitPredicate;
import rebound.exceptions.ImpossibleException;
import rebound.util.collections.Slice;

@FunctionalityType
public interface TransparentContiguousArrayBackedCollection<A> {
    public Slice<A> getLiveContiguousArrayBackingUNSAFE();

    @TraitPredicate
    default public boolean isTransparentContiguousArrayBackedCollection() {
        return true;
    }

    @StaticTraitPredicate
    public static boolean is(Object x) {
        return x instanceof TransparentContiguousArrayBackedCollection && ((TransparentContiguousArrayBackedCollection)x).isTransparentContiguousArrayBackedCollection();
    }

    public static void checkUnderlyingLengthAndExposedSizeMatch(int apparentCollectionSize, Slice underlyingSlice) throws ImpossibleException {
        int sliceLength = underlyingSlice.getLength();
        if (sliceLength != apparentCollectionSize) {
            throw TransparentContiguousArrayBackedCollection.newUnderlyingLengthAndExposedSizeMismatchException(apparentCollectionSize, sliceLength);
        }
    }

    public static ImpossibleException newUnderlyingLengthAndExposedSizeMismatchException(int apparentCollectionSize, int underlyingSliceLength) {
        return new ImpossibleException("Collection.size() (" + apparentCollectionSize + ") and underlying Slice.getLength() (" + underlyingSliceLength + ") are not equal!!");
    }
}

