/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.util.Comparator;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.objectutil.JavaNamespace;

public class SortingUtilities
implements JavaNamespace {
    public static <E> int findIndexForValueInSortedSet(E[] sortedSet, E value, Comparator<E> comparator) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.length, value, comparator);
    }

    public static <E> int findIndexForValueInSortedSet(E[] sortedSet, int lowBound, int highBound, E value, Comparator<E> comparator) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value, comparator);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static <E> int findInsertionPointInSet(E[] sortedSet, E value, Comparator<E> comparator) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.length, value, comparator);
    }

    public static <E> int findInsertionPointInSet(E[] sortedSet, int arrayLowBound, int arrayHighBound, E value, Comparator<E> comparator) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value, comparator);
    }

    public static <E> int findInsertionPointInSet_Jumping(E[] sortedSet, int arrayLowBound, int arrayHighBound, E value, Comparator<E> comparator) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (comparator.compare(sortedSet[start], value) == 0) {
                    return ~start;
                }
                if (comparator.compare(value, sortedSet[start]) < 0) {
                    assert (start == 0 || comparator.compare(value, sortedSet[start - 1]) > 0);
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (comparator.compare(value, sortedSet[midpoint]) == 0) {
                return ~midpoint;
            }
            if (comparator.compare(value, sortedSet[midpoint]) < 0) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static <E> int findInsertionPointInSet_Naive(E[] sortedSet, int arrayLowBound, int arrayHighBound, E value, Comparator<E> comparator) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        Object curr = null;
        while (i < arrayHighBound) {
            curr = sortedSet[i];
            if (comparator.compare(curr, value) == 0) {
                return ~i;
            }
            if (comparator.compare(curr, value) > 0) break;
            ++i;
        }
        return i;
    }

    public static <E> int findIndexForValueInSortedSet(FunctionInterfaces.UnaryFunctionIntToObject<E> sortedSet, int sortedSetSize, E value, Comparator<E> comparator) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSetSize, value, comparator);
    }

    public static <E> int findIndexForValueInSortedSet(FunctionInterfaces.UnaryFunctionIntToObject<E> sortedSet, int lowBound, int highBound, E value, Comparator<E> comparator) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value, comparator);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static <E> int findInsertionPointInSet(FunctionInterfaces.UnaryFunctionIntToObject<E> sortedSet, int sortedSetSize, E value, Comparator<E> comparator) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSetSize, value, comparator);
    }

    public static <E> int findInsertionPointInSet(FunctionInterfaces.UnaryFunctionIntToObject<E> sortedSet, int arrayLowBound, int arrayHighBound, E value, Comparator<E> comparator) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value, comparator);
    }

    public static <E> int findInsertionPointInSet_Jumping(FunctionInterfaces.UnaryFunctionIntToObject<E> sortedSet, int arrayLowBound, int arrayHighBound, E value, Comparator<E> comparator) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (comparator.compare(sortedSet.f(start), value) == 0) {
                    return ~start;
                }
                if (comparator.compare(value, sortedSet.f(start)) < 0) {
                    assert (start == 0 || comparator.compare(value, sortedSet.f(start - 1)) > 0);
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (comparator.compare(value, sortedSet.f(midpoint)) == 0) {
                return ~midpoint;
            }
            if (comparator.compare(value, sortedSet.f(midpoint)) < 0) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static <E> int findInsertionPointInSet_Naive(FunctionInterfaces.UnaryFunctionIntToObject<E> sortedSet, int arrayLowBound, int arrayHighBound, E value, Comparator<E> comparator) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        Object curr = null;
        while (i < arrayHighBound) {
            curr = sortedSet.f(i);
            if (comparator.compare(curr, value) == 0) {
                return ~i;
            }
            if (comparator.compare(curr, value) > 0) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(byte[] sortedSet, byte value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findIndexForValueInSortedSet(byte[] sortedSet, int lowBound, int highBound, byte value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(byte[] sortedSet, byte value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findInsertionPointInSet(byte[] sortedSet, int arrayLowBound, int arrayHighBound, byte value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(byte[] sortedSet, int arrayLowBound, int arrayHighBound, byte value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet[start] == value) {
                    return ~start;
                }
                if (value < sortedSet[start]) {
                    assert (start == 0 || value > sortedSet[start - 1]);
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet[midpoint]) {
                return ~midpoint;
            }
            if (value < sortedSet[midpoint]) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(byte[] sortedSet, int arrayLowBound, int arrayHighBound, byte value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        byte curr = 0;
        while (i < arrayHighBound) {
            curr = sortedSet[i];
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.ByteList sortedSet, byte value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.ByteList sortedSet, int lowBound, int highBound, byte value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(PrimitiveCollections.ByteList sortedSet, byte value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findInsertionPointInSet(PrimitiveCollections.ByteList sortedSet, int arrayLowBound, int arrayHighBound, byte value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(PrimitiveCollections.ByteList sortedSet, int arrayLowBound, int arrayHighBound, byte value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet.get(start) == value) {
                    return ~start;
                }
                if (value < sortedSet.get(start)) {
                    assert (start == 0 || value > sortedSet.get(start - 1));
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet.get(midpoint)) {
                return ~midpoint;
            }
            if (value < sortedSet.get(midpoint)) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(PrimitiveCollections.ByteList sortedSet, int arrayLowBound, int arrayHighBound, byte value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        byte curr = 0;
        while (i < arrayHighBound) {
            curr = sortedSet.get(i);
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(char[] sortedSet, char value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findIndexForValueInSortedSet(char[] sortedSet, int lowBound, int highBound, char value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(char[] sortedSet, char value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findInsertionPointInSet(char[] sortedSet, int arrayLowBound, int arrayHighBound, char value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(char[] sortedSet, int arrayLowBound, int arrayHighBound, char value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet[start] == value) {
                    return ~start;
                }
                if (value < sortedSet[start]) {
                    assert (start == 0 || value > sortedSet[start - 1]);
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet[midpoint]) {
                return ~midpoint;
            }
            if (value < sortedSet[midpoint]) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(char[] sortedSet, int arrayLowBound, int arrayHighBound, char value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        char curr = '\u0000';
        while (i < arrayHighBound) {
            curr = sortedSet[i];
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.CharacterList sortedSet, char value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.CharacterList sortedSet, int lowBound, int highBound, char value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(PrimitiveCollections.CharacterList sortedSet, char value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findInsertionPointInSet(PrimitiveCollections.CharacterList sortedSet, int arrayLowBound, int arrayHighBound, char value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(PrimitiveCollections.CharacterList sortedSet, int arrayLowBound, int arrayHighBound, char value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet.get(start).charValue() == value) {
                    return ~start;
                }
                if (value < sortedSet.get(start).charValue()) {
                    assert (start == 0 || value > sortedSet.get(start - 1).charValue());
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet.get(midpoint).charValue()) {
                return ~midpoint;
            }
            if (value < sortedSet.get(midpoint).charValue()) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(PrimitiveCollections.CharacterList sortedSet, int arrayLowBound, int arrayHighBound, char value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        char curr = '\u0000';
        while (i < arrayHighBound) {
            curr = sortedSet.get(i).charValue();
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(short[] sortedSet, short value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findIndexForValueInSortedSet(short[] sortedSet, int lowBound, int highBound, short value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(short[] sortedSet, short value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findInsertionPointInSet(short[] sortedSet, int arrayLowBound, int arrayHighBound, short value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(short[] sortedSet, int arrayLowBound, int arrayHighBound, short value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet[start] == value) {
                    return ~start;
                }
                if (value < sortedSet[start]) {
                    assert (start == 0 || value > sortedSet[start - 1]);
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet[midpoint]) {
                return ~midpoint;
            }
            if (value < sortedSet[midpoint]) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(short[] sortedSet, int arrayLowBound, int arrayHighBound, short value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        short curr = 0;
        while (i < arrayHighBound) {
            curr = sortedSet[i];
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.ShortList sortedSet, short value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.ShortList sortedSet, int lowBound, int highBound, short value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(PrimitiveCollections.ShortList sortedSet, short value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findInsertionPointInSet(PrimitiveCollections.ShortList sortedSet, int arrayLowBound, int arrayHighBound, short value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(PrimitiveCollections.ShortList sortedSet, int arrayLowBound, int arrayHighBound, short value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet.get(start) == value) {
                    return ~start;
                }
                if (value < sortedSet.get(start)) {
                    assert (start == 0 || value > sortedSet.get(start - 1));
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet.get(midpoint)) {
                return ~midpoint;
            }
            if (value < sortedSet.get(midpoint)) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(PrimitiveCollections.ShortList sortedSet, int arrayLowBound, int arrayHighBound, short value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        short curr = 0;
        while (i < arrayHighBound) {
            curr = sortedSet.get(i);
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(float[] sortedSet, float value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findIndexForValueInSortedSet(float[] sortedSet, int lowBound, int highBound, float value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(float[] sortedSet, float value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findInsertionPointInSet(float[] sortedSet, int arrayLowBound, int arrayHighBound, float value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(float[] sortedSet, int arrayLowBound, int arrayHighBound, float value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet[start] == value) {
                    return ~start;
                }
                if (value < sortedSet[start]) {
                    assert (start == 0 || value > sortedSet[start - 1]);
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet[midpoint]) {
                return ~midpoint;
            }
            if (value < sortedSet[midpoint]) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(float[] sortedSet, int arrayLowBound, int arrayHighBound, float value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        float curr = 0.0f;
        while (i < arrayHighBound) {
            curr = sortedSet[i];
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.FloatList sortedSet, float value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.FloatList sortedSet, int lowBound, int highBound, float value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(PrimitiveCollections.FloatList sortedSet, float value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findInsertionPointInSet(PrimitiveCollections.FloatList sortedSet, int arrayLowBound, int arrayHighBound, float value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(PrimitiveCollections.FloatList sortedSet, int arrayLowBound, int arrayHighBound, float value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet.get(start).floatValue() == value) {
                    return ~start;
                }
                if (value < sortedSet.get(start).floatValue()) {
                    assert (start == 0 || value > sortedSet.get(start - 1).floatValue());
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet.get(midpoint).floatValue()) {
                return ~midpoint;
            }
            if (value < sortedSet.get(midpoint).floatValue()) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(PrimitiveCollections.FloatList sortedSet, int arrayLowBound, int arrayHighBound, float value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        float curr = 0.0f;
        while (i < arrayHighBound) {
            curr = sortedSet.get(i).floatValue();
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(int[] sortedSet, int value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findIndexForValueInSortedSet(int[] sortedSet, int lowBound, int highBound, int value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(int[] sortedSet, int value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findInsertionPointInSet(int[] sortedSet, int arrayLowBound, int arrayHighBound, int value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(int[] sortedSet, int arrayLowBound, int arrayHighBound, int value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet[start] == value) {
                    return ~start;
                }
                if (value < sortedSet[start]) {
                    assert (start == 0 || value > sortedSet[start - 1]);
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet[midpoint]) {
                return ~midpoint;
            }
            if (value < sortedSet[midpoint]) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(int[] sortedSet, int arrayLowBound, int arrayHighBound, int value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        int curr = 0;
        while (i < arrayHighBound) {
            curr = sortedSet[i];
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.IntegerList sortedSet, int value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.IntegerList sortedSet, int lowBound, int highBound, int value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(PrimitiveCollections.IntegerList sortedSet, int value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findInsertionPointInSet(PrimitiveCollections.IntegerList sortedSet, int arrayLowBound, int arrayHighBound, int value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(PrimitiveCollections.IntegerList sortedSet, int arrayLowBound, int arrayHighBound, int value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet.get(start) == value) {
                    return ~start;
                }
                if (value < sortedSet.get(start)) {
                    assert (start == 0 || value > sortedSet.get(start - 1));
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet.get(midpoint)) {
                return ~midpoint;
            }
            if (value < sortedSet.get(midpoint)) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(PrimitiveCollections.IntegerList sortedSet, int arrayLowBound, int arrayHighBound, int value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        int curr = 0;
        while (i < arrayHighBound) {
            curr = sortedSet.get(i);
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(double[] sortedSet, double value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findIndexForValueInSortedSet(double[] sortedSet, int lowBound, int highBound, double value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(double[] sortedSet, double value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findInsertionPointInSet(double[] sortedSet, int arrayLowBound, int arrayHighBound, double value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(double[] sortedSet, int arrayLowBound, int arrayHighBound, double value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet[start] == value) {
                    return ~start;
                }
                if (value < sortedSet[start]) {
                    assert (start == 0 || value > sortedSet[start - 1]);
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet[midpoint]) {
                return ~midpoint;
            }
            if (value < sortedSet[midpoint]) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(double[] sortedSet, int arrayLowBound, int arrayHighBound, double value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        double curr = 0.0;
        while (i < arrayHighBound) {
            curr = sortedSet[i];
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.DoubleList sortedSet, double value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.DoubleList sortedSet, int lowBound, int highBound, double value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(PrimitiveCollections.DoubleList sortedSet, double value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findInsertionPointInSet(PrimitiveCollections.DoubleList sortedSet, int arrayLowBound, int arrayHighBound, double value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(PrimitiveCollections.DoubleList sortedSet, int arrayLowBound, int arrayHighBound, double value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet.get(start) == value) {
                    return ~start;
                }
                if (value < sortedSet.get(start)) {
                    assert (start == 0 || value > sortedSet.get(start - 1));
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet.get(midpoint)) {
                return ~midpoint;
            }
            if (value < sortedSet.get(midpoint)) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(PrimitiveCollections.DoubleList sortedSet, int arrayLowBound, int arrayHighBound, double value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        double curr = 0.0;
        while (i < arrayHighBound) {
            curr = sortedSet.get(i);
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(long[] sortedSet, long value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findIndexForValueInSortedSet(long[] sortedSet, int lowBound, int highBound, long value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(long[] sortedSet, long value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.length, value);
    }

    public static int findInsertionPointInSet(long[] sortedSet, int arrayLowBound, int arrayHighBound, long value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(long[] sortedSet, int arrayLowBound, int arrayHighBound, long value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet[start] == value) {
                    return ~start;
                }
                if (value < sortedSet[start]) {
                    assert (start == 0 || value > sortedSet[start - 1]);
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet[midpoint]) {
                return ~midpoint;
            }
            if (value < sortedSet[midpoint]) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(long[] sortedSet, int arrayLowBound, int arrayHighBound, long value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        long curr = 0L;
        while (i < arrayHighBound) {
            curr = sortedSet[i];
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.LongList sortedSet, long value) {
        return SortingUtilities.findIndexForValueInSortedSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findIndexForValueInSortedSet(PrimitiveCollections.LongList sortedSet, int lowBound, int highBound, long value) {
        int insertionPoint = SortingUtilities.findInsertionPointInSet(sortedSet, lowBound, highBound, value);
        if (insertionPoint < 0) {
            return ~insertionPoint;
        }
        return -1;
    }

    public static int findInsertionPointInSet(PrimitiveCollections.LongList sortedSet, long value) {
        return SortingUtilities.findInsertionPointInSet(sortedSet, 0, sortedSet.size(), value);
    }

    public static int findInsertionPointInSet(PrimitiveCollections.LongList sortedSet, int arrayLowBound, int arrayHighBound, long value) {
        return SortingUtilities.findInsertionPointInSet_Jumping(sortedSet, arrayLowBound, arrayHighBound, value);
    }

    public static int findInsertionPointInSet_Jumping(PrimitiveCollections.LongList sortedSet, int arrayLowBound, int arrayHighBound, long value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int start = arrayLowBound;
        int end = arrayHighBound;
        int midpoint = 0;
        while (true) {
            if (end - start == 1) {
                if (sortedSet.get(start) == value) {
                    return ~start;
                }
                if (value < sortedSet.get(start)) {
                    assert (start == 0 || value > sortedSet.get(start - 1));
                    return start;
                }
                return start + 1;
            }
            midpoint = (end - start) / 2 + start;
            if (value == sortedSet.get(midpoint)) {
                return ~midpoint;
            }
            if (value < sortedSet.get(midpoint)) {
                end = midpoint;
                continue;
            }
            start = midpoint;
        }
    }

    public static int findInsertionPointInSet_Naive(PrimitiveCollections.LongList sortedSet, int arrayLowBound, int arrayHighBound, long value) {
        if (arrayHighBound - arrayLowBound == 0) {
            return arrayLowBound;
        }
        int i = arrayLowBound;
        long curr = 0L;
        while (i < arrayHighBound) {
            curr = sortedSet.get(i);
            if (curr == value) {
                return ~i;
            }
            if (curr > value) break;
            ++i;
        }
        return i;
    }
}

