/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import rebound.annotations.semantic.AccessedDynamicallyOrExternallyToJavaOrKnownToBeInImportantSerializedUse;
import rebound.annotations.semantic.SignalType;
import rebound.exceptions.OverflowException;
import rebound.exceptions.StopIterationReturnPath;

@AccessedDynamicallyOrExternallyToJavaOrKnownToBeInImportantSerializedUse
@FunctionalInterface
public interface SimpleIterator<E> {
    public static final SimpleIterator EmptySimpleIterator = () -> {
        throw StopIterationReturnPath.I;
    };

    public E nextrp() throws StopIterationReturnPath;

    default public <C> C[] drainToNewArray(Class<C> componentType) {
        ArrayList l = new ArrayList();
        this.drainTo(l);
        return l.toArray((Object[])Array.newInstance(componentType, l.size()));
    }

    default public Object[] drainToNewArray() {
        ArrayList l = new ArrayList();
        this.drainTo(l);
        return l.toArray();
    }

    default public int drainTo(Collection<? super E> sink) {
        int number = 0;
        while (true) {
            E e;
            try {
                e = this.nextrp();
            }
            catch (StopIterationReturnPath e1) {
                break;
            }
            sink.add(e);
            if (number == Integer.MAX_VALUE) {
                throw new OverflowException();
            }
            ++number;
        }
        return number;
    }

    default public Iterator<E> toIterator() {
        return SimpleIterator.defaultToIterator(this);
    }

    public static <E> Iterator<E> defaultToIterator(final SimpleIterator<E> i) {
        return new Iterator<E>(){
            boolean eof;
            boolean hasBuff;
            E buff;

            @Override
            public boolean hasNext() {
                if (this.eof) {
                    return false;
                }
                if (this.hasBuff) {
                    return true;
                }
                try {
                    this.buff = i.nextrp();
                    this.hasBuff = true;
                    return true;
                }
                catch (StopIterationReturnPath e) {
                    this.eof = true;
                    this.buff = null;
                    this.hasBuff = false;
                    return false;
                }
            }

            @Override
            public E next() {
                if (this.eof) {
                    throw new NoSuchElementException();
                }
                if (this.hasBuff) {
                    Object e = this.buff;
                    this.hasBuff = false;
                    this.buff = null;
                    return e;
                }
                throw new IllegalStateException("You should have called hasNext() before next()! D:      (I mean it might be fine this specific time, but it might not! \\o/    A broken clock might be right twice a day but you shouldn't write code that depends on twice-a-day-ness! )");
            }

            @Override
            public void remove() {
                ((SimpleIteratorWithRemove)((Object)i)).remove();
            }
        };
    }

    public static <E> SimpleIterator<E> simpleIterator(Iterator<E> i) {
        if (i instanceof SimpleIterator) {
            return (SimpleIterator)((Object)i);
        }
        class InnerIteratorAdapter
        implements SimpleIterator<E>,
        SimpleIteratorWithRemove {
            private final /* synthetic */ Iterator val$i;

            InnerIteratorAdapter(Iterator iterator) {
                this.val$i = iterator;
            }

            @Override
            public E nextrp() throws StopIterationReturnPath {
                if (this.val$i.hasNext()) {
                    return this.val$i.next();
                }
                throw StopIterationReturnPath.I;
            }

            @Override
            public void remove() {
                this.val$i.remove();
            }
        }
        return new InnerIteratorAdapter(i);
    }

    public static <E> SimpleIterator<E> singletonSimpleIterator(final E onlyElement) {
        return new SimpleIterator<E>(){
            boolean consumed = false;

            @Override
            public E nextrp() throws StopIterationReturnPath {
                if (this.consumed) {
                    throw StopIterationReturnPath.I;
                }
                this.consumed = true;
                return onlyElement;
            }
        };
    }

    public static SimpleIterator simpleIterator(Object x) {
        if (x instanceof SimpleIterable) {
            return ((SimpleIterable)x).simpleIterator();
        }
        if (x instanceof Object[]) {
            return SimpleIterator.simpleIterator((Object[])x);
        }
        if (x instanceof Iterable) {
            return SimpleIterator.simpleIterator(((Iterable)x).iterator());
        }
        if (x == null) {
            throw new NullPointerException();
        }
        throw new ClassCastException(x.getClass().getName());
    }

    public static <E> SimpleIterator<E> simpleIterator(Iterable<E> x) {
        if (x instanceof SimpleIterable) {
            return ((SimpleIterable)x).simpleIterator();
        }
        return SimpleIterator.simpleIterator(x.iterator());
    }

    public static <E> SimpleIterator<E> simpleIterator(final E[] array, int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
        final int bound = offset + length;
        return new SimpleIterator<E>(offset){
            int i;
            {
                this.i = n;
            }

            @Override
            public E nextrp() throws StopIterationReturnPath {
                if (this.i >= bound) {
                    throw StopIterationReturnPath.I;
                }
                Object e = array[this.i];
                ++this.i;
                return e;
            }
        };
    }

    public static <E> SimpleIterator<E> simpleIterator(E[] array) {
        return SimpleIterator.simpleIterator(array, 0, array.length);
    }

    public static <E> SimpleIterator<E> simpleIteratorV(E ... array) {
        return SimpleIterator.simpleIterator(array);
    }

    @FunctionalInterface
    public static interface SimpleIterable<E>
    extends Iterable<E> {
        public static final SimpleIterable<?> EmptySimpleIterable = () -> EmptySimpleIterator;

        public SimpleIterator<E> simpleIterator();

        @Override
        default public Iterator<E> iterator() {
            return this.simpleIterator().toIterator();
        }

        public static <D> SimpleIterable<D> simpleIterable(final Iterable<D> iterable) {
            if (iterable instanceof SimpleIterable) {
                return (SimpleIterable)iterable;
            }
            return new SimpleIterable<D>(){

                @Override
                public SimpleIterator<D> simpleIterator() {
                    return SimpleIterator.simpleIterator(iterable.iterator());
                }

                @Override
                public Iterator<D> iterator() {
                    return iterable.iterator();
                }
            };
        }

        public static <D> SimpleIterator<D> simpleIteratorOf(Iterable<D> iterable) {
            if (iterable instanceof SimpleIterable) {
                return ((SimpleIterable)iterable).simpleIterator();
            }
            return SimpleIterator.simpleIterator(iterable.iterator());
        }
    }

    @SignalType
    public static interface SimpleIteratorWithRemove {
        public void remove();
    }
}

