/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import rebound.annotations.semantic.reachability.EscapesVarargs;
import rebound.annotations.semantic.reachability.LiveValue;
import rebound.util.collections.PolymorphicCollectionUtilities;

public class AssertedSet<E>
implements Set<E> {
    @LiveValue
    protected Collection<E> underlying;

    public AssertedSet() {
    }

    public AssertedSet(@LiveValue Collection<E> underlying) {
        this.underlying = underlying;
    }

    @EscapesVarargs
    public AssertedSet(E ... underlying) {
        this.underlying = Arrays.asList(underlying);
    }

    public static <E> AssertedSet<E> checkNonduplicationAndInst(@LiveValue Collection<E> underlying) {
        if (!PolymorphicCollectionUtilities.checkSet(underlying)) {
            throw new IllegalArgumentException("The given collection (" + underlying + ") is not a set: it contains duplicate members! :O");
        }
        return new AssertedSet<E>(underlying);
    }

    @EscapesVarargs
    public static <E> AssertedSet<E> checkNonduplicationAndInstVarargs(E ... underlying) {
        if (!PolymorphicCollectionUtilities.checkSet(underlying)) {
            throw new IllegalArgumentException("The given array (" + underlying + ") is not a set: it contains duplicate members! :O");
        }
        return new AssertedSet<E>(underlying);
    }

    public Collection<E> getUnderlying() {
        return this.underlying;
    }

    public void setUnderlying(@LiveValue Collection<E> underlying) {
        this.underlying = underlying;
    }

    public void checkNonduplicationAndSetUnderlying(@LiveValue Collection<E> underlying) {
        if (!PolymorphicCollectionUtilities.checkSet(underlying)) {
            throw new IllegalArgumentException("The given collection (" + underlying + ") is not a set: it contains duplicate members! :O");
        }
        this.underlying = underlying;
    }

    public void checkNonduplicationAndSetUnderlying(E ... underlying) {
        if (!PolymorphicCollectionUtilities.checkSet(underlying)) {
            throw new IllegalArgumentException("The given array (" + underlying + ") is not a set: it contains duplicate members! :O");
        }
        this.underlying = Arrays.asList(underlying);
    }

    @Override
    public int size() {
        return this.getUnderlying().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getUnderlying().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.getUnderlying().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getUnderlying().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getUnderlying().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getUnderlying().toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.getUnderlying().add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.getUnderlying().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getUnderlying().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.getUnderlying().addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getUnderlying().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getUnderlying().removeAll(c);
    }

    @Override
    public void clear() {
        this.getUnderlying().clear();
    }

    @Override
    public boolean equals(Object obj) {
        return this.getUnderlying().equals(obj);
    }

    @Override
    public int hashCode() {
        return this.getUnderlying().hashCode();
    }

    public String toString() {
        return this.getUnderlying().toString();
    }
}

