/*
 * Decompiled with CFR 0.152.
 */
package rebound.util;

import rebound.annotations.hints.ImplementationTransparency;
import rebound.math.SmallIntegerMathUtilities;
import rebound.util.collections.BasicCollectionUtilities;
import rebound.util.collections.PairOrdered;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.objectutil.JavaNamespace;

public class TimeUtilities
implements JavaNamespace {
    protected static long referenceStampNS;
    protected static long referenceStampMSUX;

    static {
        Compiler.compileClass(TimeUtilities.class);
        int i = 0;
        while (i < 20000) {
            TimeUtilities.reReadReferenceTimestamps();
            ++i;
        }
        TimeUtilities.reReadReferenceTimestamps();
    }

    @ImplementationTransparency
    public static void reReadReferenceTimestamps() {
        referenceStampMSUX = System.currentTimeMillis();
        referenceStampNS = System.nanoTime();
    }

    public static long convertNanotimeToMSUX(long nanotime) {
        return SmallIntegerMathUtilities.floorDivision(nanotime - referenceStampNS, 1000000L) + referenceStampMSUX;
    }

    public static long convertNanotimeToNSUX(long nanotime) {
        return nanotime - referenceStampNS + referenceStampMSUX * 1000000L;
    }

    public static long convertMSUXToMillisecondAccurateNanotime(long currentTimeMillis) {
        return (currentTimeMillis - referenceStampMSUX) * 1000000L + referenceStampNS;
    }

    public static long convertMSUXToMillisecondAccurateNSUX(long currentTimeMillis) {
        return currentTimeMillis * 1000000L;
    }

    public static long convertNSUXToNanotime(long currentTimeNanos) {
        return currentTimeNanos + referenceStampNS - referenceStampMSUX * 1000000L;
    }

    public static long convertNSUXToMSUX(long currentTimeNanos) {
        return SmallIntegerMathUtilities.floorDivision(currentTimeNanos, 1000000L);
    }

    public static long getCurrentMSUX() {
        return System.currentTimeMillis();
    }

    public static long getCurrentNSUX() {
        return TimeUtilities.convertNanotimeToNSUX(System.nanoTime());
    }

    public static long getCurrentNanotime() {
        return System.nanoTime();
    }

    public static long measureDurationNS(Runnable r) {
        long start = System.nanoTime();
        r.run();
        long end = System.nanoTime();
        return end - start;
    }

    public static <T> PairOrdered<Long, T> measureDurationReturningNS(FunctionInterfaces.NullaryFunction<T> r) {
        long start = System.nanoTime();
        T rv = r.f();
        long end = System.nanoTime();
        return BasicCollectionUtilities.pair(end - start, rv);
    }

    public static <T> T observeDurationReturningNS(FunctionInterfaces.NullaryFunction<T> r, FunctionInterfaces.UnaryProcedureLong observeDuration) {
        long start = System.nanoTime();
        T rv = r.f();
        long end = System.nanoTime();
        observeDuration.f(end - start);
        return rv;
    }
}

