/*
 * Decompiled with CFR 0.152.
 */
package rebound.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nonnull;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.NondirectBufferException;
import rebound.exceptions.NullEnumValueIllegalArgumentException;
import rebound.exceptions.UnexpectedHardcodedEnumValueException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.util.AngryReflectionUtility;
import rebound.util.BasicExceptionUtilities;
import rebound.util.BufferAllocationType;
import rebound.util.ExceptionUtilities;
import rebound.util.NIOBufferUtilities;
import rebound.util.classhacking.jre.ClasshackingSunNIOUtilitiesOpportunisticHardlinked;

public class PlatformNIOBufferUtilities {
    @Nonnull
    public static ByteBuffer allocateByteBuffer(int capacity, BufferAllocationType allocationType) {
        if (capacity < 0) {
            throw new IllegalArgumentException("buffers can't have a negative capacity! XD *slaps knee melodramatically*");
        }
        try {
            ByteBuffer rv = null;
            if (allocationType == BufferAllocationType.JAVAHEAP) {
                rv = ByteBuffer.allocate(capacity);
            } else if (allocationType == BufferAllocationType.PREFERABLY_DIRECT) {
                rv = ByteBuffer.allocateDirect(capacity);
            } else if (allocationType == BufferAllocationType.NECESSARILY_DIRECT_POSSIBLYEXCESSSIZE_PAGEALIGNED_GARBAGECOLLECTED) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(capacity);
                if (!buffer.isDirect()) {
                    throw new NondirectBufferException();
                }
                rv = buffer;
            } else if (allocationType == BufferAllocationType.NECESSARILY_DIRECT_EXACTSIZE_NOTPAGEALIGNED_NOTGARBAGECOLLECTED) {
                rv = PlatformNIOBufferUtilities.allocateDirectNonGarbageCollectedBufferViaOpportunisticSoftLinkCall(capacity);
            } else if (allocationType == BufferAllocationType.NECESSARILY_DIRECT_EXACTSIZE_NOTPAGEALIGNED_GARBAGECOLLECTED) {
                ByteBuffer exactUntrackedMallocAllocatedBuffer = PlatformNIOBufferUtilities.allocateByteBuffer(capacity, BufferAllocationType.NECESSARILY_DIRECT_EXACTSIZE_NOTPAGEALIGNED_NOTGARBAGECOLLECTED);
                PlatformNIOBufferUtilities.makeUntrackedBufferGarbageCollectedViaOpportunisticSoftLinkCall(exactUntrackedMallocAllocatedBuffer);
                rv = exactUntrackedMallocAllocatedBuffer;
            } else {
                if (allocationType == null) {
                    throw new NullEnumValueIllegalArgumentException();
                }
                throw new UnexpectedHardcodedEnumValueException();
            }
            rv.order(ByteOrder.nativeOrder());
            return rv;
        }
        catch (OutOfMemoryError exc) {
            System.err.println("OutOfMemoryError occurred attempting to allocate " + capacity + " bytes, with type " + (Object)((Object)allocationType) + "; max memory=" + Runtime.getRuntime().maxMemory() + ", total memory=" + Runtime.getRuntime().totalMemory() + ", free memory=" + Runtime.getRuntime().freeMemory());
            throw exc;
        }
    }

    protected static ByteBuffer allocateDirectNonGarbageCollectedBufferViaOpportunisticSoftLinkCall(int capacity) {
        String targetClassName = "rebound.util.NonGarbageCollectedDirectByteBufferAllocator";
        String targetMethodName = "allocateDirectNonGarbageCollectedExactSizeNotPageAligned";
        Class targetClass = AngryReflectionUtility.forName(targetClassName);
        if (targetClass == null) {
            throw new UnsupportedOperationException(new ClassNotFoundException(targetClassName));
        }
        Method targetMethod = AngryReflectionUtility.getMethod(targetClass, targetMethodName, new Class[]{Integer.TYPE}, AngryReflectionUtility.JavaVisibility.Public, ByteBuffer.class, true, true);
        if (targetMethod == null) {
            throw new UnsupportedOperationException(new NoSuchMethodError(String.valueOf(targetClassName) + "." + targetMethodName));
        }
        Object rv = null;
        try {
            rv = targetMethod.invoke(null, capacity);
        }
        catch (IllegalAccessException exc) {
            throw new ImpossibleException();
        }
        catch (IllegalArgumentException exc) {
            throw new ImpossibleException();
        }
        catch (InvocationTargetException exc) {
            throw new WrappedThrowableRuntimeException(exc.getCause());
        }
        if (rv != null && !(rv instanceof ByteBuffer)) {
            throw new ImpossibleException();
        }
        return (ByteBuffer)rv;
    }

    protected static void freeDirectNonGarbageCollectedBufferViaOpportunisticSoftLinkCall(ByteBuffer buffer) {
        String targetClassName = "rebound.util.NonGarbageCollectedDirectByteBufferAllocator";
        String targetMethodName = "freeNonGarbageCollectedBuffer";
        Class targetClass = AngryReflectionUtility.forName(targetClassName);
        if (targetClass == null) {
            throw new UnsupportedOperationException(new ClassNotFoundException(targetClassName));
        }
        Method targetMethod = AngryReflectionUtility.getMethod(targetClass, targetMethodName, new Class[]{ByteBuffer.class}, AngryReflectionUtility.JavaVisibility.Public, Void.TYPE, true, true);
        if (targetMethod == null) {
            throw new UnsupportedOperationException(new NoSuchMethodError(String.valueOf(targetClassName) + "." + targetMethodName));
        }
        try {
            targetMethod.invoke(null, buffer);
        }
        catch (IllegalAccessException exc) {
            throw new ImpossibleException();
        }
        catch (IllegalArgumentException exc) {
            throw new ImpossibleException();
        }
        catch (InvocationTargetException exc) {
            throw ExceptionUtilities.rewrapToUnchecked(exc);
        }
    }

    protected static void makeUntrackedBufferGarbageCollectedViaOpportunisticSoftLinkCall(ByteBuffer buffer) {
        String targetClassName = "rebound.util.NonGarbageCollectedDirectByteBufferAllocator";
        String targetMethodName = "makeUntrackedBufferGarbageCollected";
        Class targetClass = AngryReflectionUtility.forName(targetClassName);
        if (targetClass == null) {
            throw new UnsupportedOperationException(new ClassNotFoundException(targetClassName));
        }
        Method targetMethod = AngryReflectionUtility.getMethod(targetClass, targetMethodName, new Class[]{ByteBuffer.class}, AngryReflectionUtility.JavaVisibility.Public, null, true, true);
        if (targetMethod == null) {
            throw new UnsupportedOperationException(new NoSuchMethodError(String.valueOf(targetClassName) + "." + targetMethodName));
        }
        try {
            targetMethod.invoke(null, buffer);
        }
        catch (IllegalAccessException exc) {
            throw new ImpossibleException();
        }
        catch (IllegalArgumentException exc) {
            throw new ImpossibleException();
        }
        catch (InvocationTargetException exc) {
            throw ExceptionUtilities.rewrapToUnchecked(exc);
        }
    }

    public static void freeNonGarbageCollectedBuffer(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Cannot free() a Java heap buffer!!! X\"DD");
        }
        PlatformNIOBufferUtilities.freeDirectNonGarbageCollectedBufferViaOpportunisticSoftLinkCall(buffer);
    }

    public static boolean isGarbageCollected(ByteBuffer buffer) {
        return ClasshackingSunNIOUtilitiesOpportunisticHardlinked.isStandardlyGarbageCollected(buffer);
    }

    public static BufferAllocationType getBufferAllocationType(Buffer buffer) {
        if (!buffer.isDirect()) {
            return BufferAllocationType.JAVAHEAP;
        }
        if (PlatformNIOBufferUtilities.isGarbageCollected(ClasshackingSunNIOUtilitiesOpportunisticHardlinked.getUnderlyingByteBuffer(buffer))) {
            return BufferAllocationType.NECESSARILY_DIRECT_POSSIBLYEXCESSSIZE_PAGEALIGNED_GARBAGECOLLECTED;
        }
        return BufferAllocationType.NECESSARILY_DIRECT_EXACTSIZE_NOTPAGEALIGNED_NOTGARBAGECOLLECTED;
    }

    public static ByteBuffer getUnderlyingByteBuffer(Buffer buffer) {
        return ClasshackingSunNIOUtilitiesOpportunisticHardlinked.getUnderlyingByteBuffer(buffer);
    }

    public static <E extends Buffer> E allocateCompatibleBuffer(E originalBuffer, BufferAllocationType allocationType) {
        int originalBitlength = NIOBufferUtilities.getBufferBitlength(originalBuffer);
        ByteBuffer newByteBuffer = PlatformNIOBufferUtilities.allocateByteBuffer(originalBuffer.capacity() * originalBitlength / 8, allocationType);
        ByteBuffer originalByteBuffer = PlatformNIOBufferUtilities.getUnderlyingByteBuffer(originalBuffer);
        if (originalByteBuffer != null) {
            newByteBuffer.order(originalByteBuffer.order());
        }
        Buffer newBuffer = null;
        if (originalBuffer instanceof ByteBuffer) {
            newBuffer = newByteBuffer;
        } else if (originalBuffer instanceof ShortBuffer) {
            newBuffer = newByteBuffer.asShortBuffer();
        } else if (originalBuffer instanceof CharBuffer) {
            newBuffer = newByteBuffer.asCharBuffer();
        } else if (originalBuffer instanceof IntBuffer) {
            newBuffer = newByteBuffer.asIntBuffer();
        } else if (originalBuffer instanceof FloatBuffer) {
            newBuffer = newByteBuffer.asFloatBuffer();
        } else if (originalBuffer instanceof LongBuffer) {
            newBuffer = newByteBuffer.asLongBuffer();
        } else if (originalBuffer instanceof DoubleBuffer) {
            newBuffer = newByteBuffer.asDoubleBuffer();
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(originalBuffer);
        }
        ((Buffer)newBuffer).limit(originalBuffer.limit());
        ((Buffer)newBuffer).position(originalBuffer.position());
        return (E)newBuffer;
    }

    public static <E extends Buffer> E allocateCompatibleBuffer(E originalBuffer) {
        return PlatformNIOBufferUtilities.allocateCompatibleBuffer(originalBuffer, PlatformNIOBufferUtilities.getBufferAllocationType(originalBuffer));
    }
}

