/*
 * Decompiled with CFR 0.152.
 */
package rebound.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.exceptions.ClassNotFoundRuntimeException;
import rebound.exceptions.ImPrettySureThisNeverActuallyHappensRuntimeException;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.NameConflictException;
import rebound.exceptions.NotFoundException;
import rebound.exceptions.NotYetImplementedException;
import rebound.exceptions.NullEnumValueIllegalArgumentException;
import rebound.exceptions.TooManyException;
import rebound.exceptions.UnexpectedHardcodedEnumValueException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.text.StringUtilities;
import rebound.util.BasicExceptionUtilities;
import rebound.util.Primitives;
import rebound.util.collections.ArrayUtilities;
import rebound.util.collections.CollectionUtilities;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.JavaNamespace;

public class AngryReflectionUtility
implements JavaNamespace {
    public static final int VISIBILITY_MODIFIER_MASK = 7;

    public static Class arrayClassOf(Class componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    @Nullable
    public static Class forName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException exc) {
            return AngryReflectionUtility.forPrimitiveName(name);
        }
    }

    public static Class forPrimitiveName(String name) {
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("void")) {
            return Void.TYPE;
        }
        return null;
    }

    public static boolean isPrimitiveName(String name) {
        return AngryReflectionUtility.forPrimitiveName(name) != null;
    }

    public static boolean isArrayName(String name) {
        return name.indexOf(91) != -1;
    }

    public static boolean isInstanceNormalizingPrimitivesAndWrappers(Class c, Object instanceCandidate) {
        if (c.isPrimitive()) {
            c = Primitives.getWrapperClassFromPrimitiveStrict(c);
        }
        return c.isInstance(instanceCandidate);
    }

    public static Class forNameMandatory(String name) throws ClassNotFoundRuntimeException {
        Class c = AngryReflectionUtility.forName(name);
        if (c == null) {
            throw new ClassNotFoundRuntimeException(name);
        }
        return c;
    }

    public static boolean isSuperclass(Class candidateSuperclass, Class candidateSubclass) {
        return candidateSuperclass.isAssignableFrom(candidateSubclass);
    }

    public static boolean isSubclass(Class candidateSubclass, Class candidateSuperclass) {
        return candidateSuperclass.isAssignableFrom(candidateSubclass);
    }

    public static boolean isParameterAnnotationPresent(Method m, int parameterIndex, Class<? extends Annotation> annotationClass) {
        if (parameterIndex < 0) {
            throw new IndexOutOfBoundsException("negative index! D:");
        }
        Annotation[][] parameterAnnotations = m.getParameterAnnotations();
        if (parameterIndex >= parameterAnnotations.length) {
            throw new IndexOutOfBoundsException("[" + parameterIndex + "] >= " + parameterAnnotations.length);
        }
        Annotation[] annotationArray = parameterAnnotations[parameterIndex];
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (annotationClass.isInstance(a)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isParameterAnnotationPresent(Constructor m, int parameterIndex, Class<? extends Annotation> annotationClass) {
        if (parameterIndex < 0) {
            throw new IndexOutOfBoundsException("negative index! D:");
        }
        Annotation[][] parameterAnnotations = m.getParameterAnnotations();
        if (parameterIndex >= parameterAnnotations.length) {
            throw new IndexOutOfBoundsException("[" + parameterIndex + "] >= " + parameterAnnotations.length);
        }
        Annotation[] annotationArray = parameterAnnotations[parameterIndex];
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (annotationClass.isInstance(a)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Class[] getSuperclassesOfIncludingSelf(Class c) {
        if (c == null) {
            return new Class[0];
        }
        ArrayList supers = new ArrayList();
        while (c != null) {
            supers.add(c);
            c = c.getSuperclass();
        }
        return supers.toArray(new Class[supers.size()]);
    }

    public static Class[] getSuperclassesOfNotIncludingSelf(Class c) {
        if (c == null) {
            return new Class[0];
        }
        if ((c = c.getSuperclass()) == null) {
            return new Class[0];
        }
        ArrayList supers = new ArrayList();
        while (c != null) {
            supers.add(c);
            c = c.getSuperclass();
        }
        return supers.toArray(new Class[supers.size()]);
    }

    @ThrowAwayValue
    public static Class[] getAllInterfacesArray(Class c) {
        if (c == null || c.isPrimitive() || c == Void.TYPE) {
            return new Class[0];
        }
        Set<Class> set = AngryReflectionUtility.getAllInterfaces(c);
        return set.toArray(new Class[set.size()]);
    }

    @ThrowAwayValue
    public static Set<Class> getAllInterfaces(Class c) {
        if (c == null || c.isPrimitive() || c == Void.TYPE) {
            return Collections.emptySet();
        }
        HashSet<Class> rv = new HashSet<Class>();
        AngryReflectionUtility.getAllInterfaces(c, rv);
        return rv;
    }

    public static void getAllInterfaces(Class c, Set<Class> interfacesOUT) {
        if (c == null || c.isPrimitive() || c == Void.TYPE) {
            return;
        }
        AngryReflectionUtility.getAllInterfaces(c.getSuperclass(), interfacesOUT);
        Class<?>[] classArray = c.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            if (!interfacesOUT.contains(i)) {
                interfacesOUT.add(i);
                AngryReflectionUtility.getAllInterfaces(i, interfacesOUT);
            }
            ++n2;
        }
    }

    public static JavaVisibility getVisibility(int modifiers) {
        if (Integer.bitCount(modifiers & 7) > 1) {
            throw new IllegalArgumentException("Invalid Java modifiers bitfield: " + modifiers);
        }
        if (Modifier.isPublic(modifiers)) {
            return JavaVisibility.Public;
        }
        if (Modifier.isProtected(modifiers)) {
            return JavaVisibility.Protected;
        }
        if (Modifier.isPrivate(modifiers)) {
            return JavaVisibility.Private;
        }
        return JavaVisibility.PackagePrivate;
    }

    public static JavaVisibility getVisibility(Class thing) {
        return AngryReflectionUtility.getVisibility(thing.getModifiers());
    }

    public static JavaVisibility getVisibility(Method thing) {
        return AngryReflectionUtility.getVisibility(thing.getModifiers());
    }

    public static JavaVisibility getVisibility(Constructor thing) {
        return AngryReflectionUtility.getVisibility(thing.getModifiers());
    }

    public static JavaVisibility getVisibility(Field thing) {
        return AngryReflectionUtility.getVisibility(thing.getModifiers());
    }

    public static JavaVisibility getVisibility(Object thing) {
        if (thing instanceof Class) {
            return AngryReflectionUtility.getVisibility((Class)thing);
        }
        if (thing instanceof Method) {
            return AngryReflectionUtility.getVisibility((Method)thing);
        }
        if (thing instanceof Field) {
            return AngryReflectionUtility.getVisibility((Field)thing);
        }
        if (thing instanceof Constructor) {
            return AngryReflectionUtility.getVisibility((Constructor)thing);
        }
        throw new IllegalArgumentException(thing != null ? new ClassCastException(thing.getClass().toString()) : new NullPointerException());
    }

    public static boolean getBooleanModifierValue(Class c, JavaModifierParametersForClasses modifier) {
        if (modifier == JavaModifierParametersForClasses.STATIC) {
            return Modifier.isStatic(c.getModifiers());
        }
        if (modifier == JavaModifierParametersForClasses.STRICTFP) {
            return Modifier.isStrict(c.getModifiers());
        }
        if (modifier == JavaModifierParametersForClasses.VISBILITY) {
            throw new IllegalArgumentException("not a boolean property ._.");
        }
        if (modifier == JavaModifierParametersForClasses.SUBCLASSABILITY) {
            throw new IllegalArgumentException("not a boolean property ._.");
        }
        if (modifier == null) {
            throw new NullEnumValueIllegalArgumentException();
        }
        throw new UnexpectedHardcodedEnumValueException();
    }

    public static boolean getBooleanModifierValue(Method m, JavaModifierParametersForMethods modifier) {
        if (modifier == JavaModifierParametersForMethods.STATIC) {
            return Modifier.isStatic(m.getModifiers());
        }
        if (modifier == JavaModifierParametersForMethods.NATIVE) {
            return Modifier.isNative(m.getModifiers());
        }
        if (modifier == JavaModifierParametersForMethods.STRICTFP) {
            return Modifier.isStrict(m.getModifiers());
        }
        if (modifier == JavaModifierParametersForMethods.SYNCHRONIZED) {
            return Modifier.isSynchronized(m.getModifiers());
        }
        if (modifier == JavaModifierParametersForMethods.VISBILITY) {
            throw new IllegalArgumentException("not a boolean property ._.");
        }
        if (modifier == JavaModifierParametersForMethods.SUBCLASSABILITY) {
            throw new IllegalArgumentException("not a boolean property ._.");
        }
        if (modifier == null) {
            throw new NullEnumValueIllegalArgumentException();
        }
        throw new UnexpectedHardcodedEnumValueException();
    }

    public static boolean getBooleanModifierValue(Field f, JavaModifierParametersForFields modifier) {
        if (modifier == JavaModifierParametersForFields.STATIC) {
            return Modifier.isStatic(f.getModifiers());
        }
        if (modifier == JavaModifierParametersForFields.FINAL) {
            return Modifier.isFinal(f.getModifiers());
        }
        if (modifier == JavaModifierParametersForFields.TRANSIENT) {
            return Modifier.isTransient(f.getModifiers());
        }
        if (modifier == JavaModifierParametersForFields.VOLATILE) {
            return Modifier.isVolatile(f.getModifiers());
        }
        if (modifier == JavaModifierParametersForFields.VISBILITY) {
            throw new IllegalArgumentException("not a boolean property ._.");
        }
        if (modifier == null) {
            throw new NullEnumValueIllegalArgumentException();
        }
        throw new UnexpectedHardcodedEnumValueException();
    }

    public static boolean isStatic(Object classOrMethodOrFieldOrConstructor) {
        if (classOrMethodOrFieldOrConstructor instanceof Member) {
            return AngryReflectionUtility.isStatic((Member)classOrMethodOrFieldOrConstructor);
        }
        if (classOrMethodOrFieldOrConstructor instanceof Class) {
            return Modifier.isStatic(((Class)classOrMethodOrFieldOrConstructor).getModifiers());
        }
        throw new IllegalArgumentException(classOrMethodOrFieldOrConstructor != null ? new ClassCastException(classOrMethodOrFieldOrConstructor.getClass().toString()) : new NullPointerException());
    }

    public static boolean isStatic(Member methodOrFieldOrConstructor) {
        if (methodOrFieldOrConstructor instanceof Constructor) {
            return true;
        }
        return Modifier.isStatic(methodOrFieldOrConstructor.getModifiers());
    }

    @Nullable
    public static Method getMethod(Class c, String methodName, Class[] argumentTypes, JavaVisibility optionalVisibilityRequirement, Class optionalReturnTypeRequirement, Boolean optionalModifierStaticRequirement, boolean scanSuperclasses) {
        if (c == null || methodName == null || argumentTypes == null) {
            throw new NullPointerException();
        }
        Class cls = c;
        while (cls != null) {
            Method[] members;
            Method[] methodArray = members = cls.getDeclaredMethods();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                Method member = methodArray[n2];
                if (!(!member.getName().equals(methodName) || !Arrays.equals(member.getParameterTypes(), argumentTypes) || optionalReturnTypeRequirement != null && member.getReturnType() != optionalReturnTypeRequirement || optionalVisibilityRequirement != null && AngryReflectionUtility.getVisibility(member) != optionalVisibilityRequirement || optionalVisibilityRequirement != null && Modifier.isStatic(member.getModifiers()) != optionalModifierStaticRequirement)) {
                    return member;
                }
                ++n2;
            }
            if (!scanSuperclasses) break;
            cls = cls.getSuperclass();
        }
        return null;
    }

    @Nullable
    public static Method getMethod(Class c, String methodName, Class[] argumentTypes, boolean scanSuperclasses) {
        return AngryReflectionUtility.getMethod(c, methodName, argumentTypes, null, null, null, scanSuperclasses);
    }

    @Nullable
    public static Method getMethod(Class c, String methodName, Class[] argumentTypes) {
        return AngryReflectionUtility.getMethod(c, methodName, argumentTypes, true);
    }

    @Nonnull
    public static Method getMethodByNameCheckingExactlyOneNotCountingInherited(Class c, String methodName) throws TooManyException, NotFoundException {
        return AngryReflectionUtility.getMethodByNameCheckingExactlyOneNotCountingInherited(c, methodName, null);
    }

    @Nonnull
    public static Method getMethodByNameCheckingExactlyOneNotCountingInherited(Class c, String methodName, @Nullable Boolean optionalStaticRequirement) throws TooManyException, NotFoundException {
        Method ourMethod = null;
        boolean has = false;
        Method[] methodArray = c.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(methodName) && (optionalStaticRequirement == null || Modifier.isStatic(m.getModifiers()) == optionalStaticRequirement)) {
                if (has) {
                    throw new TooManyException("Class " + c.getName() + " has multiple methods with the name " + methodName + "!!  (not counting inherited!)");
                }
                ourMethod = m;
                has = true;
            }
            ++n2;
        }
        if (has) {
            return ourMethod;
        }
        throw new NotFoundException("No method found in class " + c.getName() + " with the name " + methodName + "  (not counting inherited ones)");
    }

    @ThrowAwayValue
    @Nonnull
    public static Set<Method> getMethodsByNameNotCountingInherited(Class c, String methodName) {
        HashSet<Method> ourMethods = new HashSet<Method>();
        Method[] methodArray = c.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(methodName)) {
                ourMethods.add(m);
            }
            ++n2;
        }
        return ourMethods;
    }

    @Nullable
    public static <T> Constructor<T> getConstructor(Class<T> c, Class[] argumentTypes) {
        return AngryReflectionUtility.getConstructor(c, argumentTypes, null);
    }

    @Nullable
    public static <T> Constructor<T> getConstructor(Class<T> c, Class[] argumentTypes, JavaVisibility optionalVisibilityRequirement) {
        if (c == null || argumentTypes == null) {
            throw new NullPointerException();
        }
        Constructor<T> member = null;
        try {
            member = c.getDeclaredConstructor(argumentTypes);
        }
        catch (NoSuchMethodException exc) {
            member = null;
        }
        if (member != null && (optionalVisibilityRequirement == null || AngryReflectionUtility.getVisibility(member) == optionalVisibilityRequirement)) {
            return member;
        }
        return null;
    }

    @Nullable
    public static Field getField(Class c, String fieldName, JavaVisibility optionalVisibilityRequirement, Class optionalFieldTypeRequirement, Boolean optionalModifierStaticRequirement, boolean scanSuperclasses) {
        if (c == null || fieldName == null) {
            throw new NullPointerException();
        }
        Class cls = c;
        while (cls != null) {
            Field[] members;
            Field[] fieldArray = members = cls.getDeclaredFields();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                Field member = fieldArray[n2];
                if (!(!member.getName().equals(fieldName) || optionalFieldTypeRequirement != null && member.getType() != optionalFieldTypeRequirement || optionalVisibilityRequirement != null && AngryReflectionUtility.getVisibility(member) != optionalVisibilityRequirement || optionalVisibilityRequirement != null && Modifier.isStatic(member.getModifiers()) != optionalModifierStaticRequirement)) {
                    return member;
                }
                ++n2;
            }
            if (!scanSuperclasses) break;
            cls = cls.getSuperclass();
        }
        return null;
    }

    @Nullable
    public static Field getField(Class c, String fieldName) {
        return AngryReflectionUtility.getField(c, fieldName, null, null, null, false);
    }

    @Nullable
    public static <T> Constructor<T> getPublicNoArgsConstructor(Class<T> c) {
        return AngryReflectionUtility.getConstructor(c, new Class[0], JavaVisibility.Public);
    }

    public static Field[] getAllFields(Class c) {
        if (c == null) {
            throw new NullPointerException();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        Class cls = c;
        while (cls != null) {
            Field[] fs;
            Field[] fieldArray = fs = cls.getDeclaredFields();
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                fields.add(f);
                ++n2;
            }
            cls = cls.getSuperclass();
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static Method[] getAllMethods(Class c) {
        if (c == null) {
            throw new NullPointerException();
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        Class cls = c;
        while (cls != null) {
            Method[] fs;
            Method[] methodArray = fs = cls.getDeclaredMethods();
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                Method f = methodArray[n2];
                methods.add(f);
                ++n2;
            }
            cls = cls.getSuperclass();
        }
        return methods.toArray(new Method[methods.size()]);
    }

    public static Constructor[] getAllConstructors(Class c) {
        return c.getDeclaredConstructors();
    }

    public static boolean areAllInstanceFieldsFinal(Class c) {
        if (c == null) {
            throw new NullPointerException();
        }
        Class cls = c;
        while (cls != null) {
            Field[] fs;
            Field[] fieldArray = fs = cls.getDeclaredFields();
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (!Modifier.isStatic(f.getModifiers()) && !Modifier.isFinal(f.getModifiers())) {
                    return false;
                }
                ++n2;
            }
            cls = cls.getSuperclass();
        }
        return true;
    }

    public static boolean isInheritedAnnotationPresent(Class owner, Class<? extends Annotation> annotationClass) {
        Class c = owner;
        while (c != null) {
            if (c.isAnnotationPresent(annotationClass)) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    public static <A extends Annotation> A getInheritedAnnotation(Class owner, Class<A> annotationClass) {
        Class c = owner;
        A a = null;
        while (c != null) {
            a = c.getAnnotation(annotationClass);
            if (a != null) {
                return a;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    public static <E> E cast(Object o, Class<E> dest) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (dest != null) {
            if (AngryReflectionUtility.isInstanceNormalizingPrimitivesAndWrappers(dest, o)) {
                return (E)o;
            }
            if (Number.class.isAssignableFrom(dest) || dest.isPrimitive() && dest != Boolean.TYPE && dest != Character.TYPE) {
                if (o instanceof Character) {
                    o = (int)((Character)o).charValue();
                } else if (o instanceof CharSequence) {
                    if (((CharSequence)o).length() == 0) {
                        o = 0;
                    } else {
                        try {
                            o = Long.parseLong(o.toString());
                        }
                        catch (NumberFormatException exc) {
                            try {
                                o = Double.parseDouble(o.toString());
                            }
                            catch (NumberFormatException exc1) {
                                o = 0;
                            }
                        }
                    }
                }
                if (o instanceof Number) {
                    Number n = (Number)o;
                    if (dest == Byte.class || dest == Byte.TYPE) {
                        return (E)Byte.valueOf(n.byteValue());
                    }
                    if (dest == Short.class || dest == Short.TYPE) {
                        return (E)Short.valueOf(n.shortValue());
                    }
                    if (dest == Integer.class || dest == Integer.TYPE) {
                        return (E)Integer.valueOf(n.intValue());
                    }
                    if (dest == Long.class || dest == Long.TYPE) {
                        return (E)Long.valueOf(n.longValue());
                    }
                    if (dest == Float.class || dest == Float.TYPE) {
                        return (E)Float.valueOf(n.floatValue());
                    }
                    if (dest == Double.class || dest == Double.TYPE) {
                        return (E)Double.valueOf(n.doubleValue());
                    }
                }
            } else if (dest == Boolean.class || dest == Boolean.TYPE) {
                if (o instanceof Boolean) {
                    return (E)((Boolean)o);
                }
                if (o instanceof Number) {
                    return (E)Boolean.valueOf(((Number)o).longValue() != 0L);
                }
            } else if (dest == Character.class || dest == Character.TYPE) {
                if (o instanceof Character) {
                    return (E)((Character)o);
                }
                if (o instanceof Number) {
                    return (E)Character.valueOf((char)((Number)o).shortValue());
                }
            } else if (dest == String.class) {
                return (E)new String(o.toString());
            }
        }
        throw new ClassCastException("Cannot cast a " + o.getClass().getName() + " to a " + dest.getName());
    }

    public static boolean canCast(Class source, Class dest) {
        if (source == null) {
            return true;
        }
        if (dest == null) {
            return false;
        }
        if (source == dest) {
            return true;
        }
        if (dest == Object.class) {
            return true;
        }
        if (dest.isAssignableFrom(source)) {
            return true;
        }
        if (!(source != Boolean.TYPE && source != Boolean.class || dest != Boolean.TYPE && dest != Boolean.class)) {
            return true;
        }
        return (source != Boolean.TYPE && source.isPrimitive() || source == Character.class || Number.class.isAssignableFrom(source)) && (dest != Boolean.TYPE && dest.isPrimitive() || dest == Character.class || dest == Number.class || dest == Byte.class || dest == Short.class || dest == Integer.class || dest == Long.class || dest == Float.class || dest == Double.class);
    }

    public static Map<String, Class> getSimpleNameReverserMap(Class[] classes) throws NameConflictException {
        HashMap<String, Class> map = new HashMap<String, Class>();
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            String simpleName = c.getSimpleName();
            if (map.containsKey(simpleName)) {
                throw new NameConflictException();
            }
            map.put(simpleName, c);
            ++n2;
        }
        return map;
    }

    public static Map<String, Class> getSimpleNameReverserMap_besteffort(Class[] classes) {
        HashMap<String, Class> map = new HashMap<String, Class>();
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            String simpleName = c.getSimpleName();
            if (!map.containsKey(simpleName)) {
                map.put(simpleName, c);
            }
            ++n2;
        }
        return map;
    }

    public static Map<String, List<Class>> getSimpleNameConflicts(Class[] classes) {
        HashMap<String, Class> map = new HashMap<String, Class>();
        HashMap<String, List<Class>> conflictMap = new HashMap<String, List<Class>>();
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            String simpleName = c.getSimpleName();
            if (map.containsKey(simpleName)) {
                if (!conflictMap.containsKey(simpleName)) {
                    ArrayList<Class> list = new ArrayList<Class>();
                    list.add((Class)map.get(simpleName));
                    list.add(c);
                    conflictMap.put(simpleName, list);
                } else {
                    conflictMap.get(simpleName).add(c);
                }
            } else {
                map.put(simpleName, c);
            }
            ++n2;
        }
        return conflictMap;
    }

    public static String getInvokingClassName() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        return stack[3].getClassName();
    }

    @Nullable
    public static Method getMethod(Class cls, String methodDescriptor, Class returnType) {
        Method[] allMethods;
        String methodName = null;
        String[] methodArgTypeNames = null;
        String[] pp = StringUtilities.split(methodDescriptor, '(');
        if (pp.length != 2) {
            throw new IllegalArgumentException("Invalid syntax: '" + methodDescriptor + "'");
        }
        methodName = pp[0];
        String args = pp[1];
        if (!args.endsWith(")")) {
            throw new IllegalArgumentException("Invalid syntax: '" + methodDescriptor + "'");
        }
        args = args.substring(0, args.length() - 1);
        methodArgTypeNames = StringUtilities.split(args, ',');
        int i = 0;
        while (i < methodArgTypeNames.length) {
            methodArgTypeNames[i] = methodArgTypeNames[i].trim();
            ++i;
        }
        Object[] methodArgTypeClasses = null;
        methodArgTypeClasses = new Class[methodArgTypeNames.length];
        int i2 = 0;
        while (i2 < methodArgTypeClasses.length) {
            methodArgTypeClasses[i2] = AngryReflectionUtility.forName(methodArgTypeNames[i2]);
            if (methodArgTypeClasses[i2] == null) {
                throw new RuntimeException(new ClassNotFoundException(methodArgTypeNames[i2]));
            }
            ++i2;
        }
        Method[] methodArray = allMethods = AngryReflectionUtility.getAllMethods(cls);
        int n = allMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(methodName) && Arrays.equals(m.getParameterTypes(), methodArgTypeClasses) && (returnType == null || returnType.equals(m.getReturnType()))) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    public static Method getMethod(Class cls, String methodDescriptor) {
        return AngryReflectionUtility.getMethod(cls, methodDescriptor, null);
    }

    public static boolean lazyprogrammersPublicFieldbasedEquals(Object a, Object b) throws WrappedThrowableRuntimeException {
        Field[] fieldses;
        if (a == b) {
            return true;
        }
        if (a == null ^ b == null) {
            return false;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        Class<?> c = a.getClass();
        Field[] fieldArray = fieldses = c.getFields();
        int n = fieldses.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Object vA = null;
            Object vB = null;
            try {
                vA = field.get(a);
                vB = field.get(a);
            }
            catch (IllegalArgumentException exc) {
                throw new WrappedThrowableRuntimeException(exc);
            }
            catch (IllegalAccessException exc) {
                throw new WrappedThrowableRuntimeException(exc);
            }
            if (!BasicObjectUtilities.eq(vA, vB)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int getPrimitiveBitLength(Class primitiveClass) {
        return AngryReflectionUtility.getPrimitiveBitLength(primitiveClass, 8);
    }

    public static int getPackedPrimitiveBitLength(Class primitiveClass) {
        return AngryReflectionUtility.getPrimitiveBitLength(primitiveClass, 1);
    }

    public static int getPrimitiveBitLength(Class primitiveClass, int booleanBitLength) {
        if (primitiveClass == Boolean.TYPE) {
            return booleanBitLength;
        }
        if (primitiveClass == Byte.TYPE) {
            return 8;
        }
        if (primitiveClass == Short.TYPE) {
            return 16;
        }
        if (primitiveClass == Character.TYPE) {
            return 16;
        }
        if (primitiveClass == Integer.TYPE) {
            return 32;
        }
        if (primitiveClass == Float.TYPE) {
            return 32;
        }
        if (primitiveClass == Long.TYPE) {
            return 64;
        }
        if (primitiveClass == Double.TYPE) {
            return 64;
        }
        throw new IllegalArgumentException("Invalid primitive type: " + primitiveClass.getName());
    }

    public static Class getSubestCommonSuperclass(Class ... classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        if (classes[0].isPrimitive() || classes[0] == Void.class) {
            int i = 1;
            while (i < classes.length) {
                Class c = classes[i];
                if (c != classes[0]) {
                    return null;
                }
                ++i;
            }
            return classes[0];
        }
        Class[][] hierarchies = null;
        hierarchies = new Class[classes.length][];
        int i = 0;
        while (i < classes.length) {
            hierarchies[i] = AngryReflectionUtility.getClassInheritanceHierarchy(classes[i]);
            ++i;
        }
        int minLength = 0;
        boolean has = false;
        Class[][] classArrayArray = hierarchies;
        int n = hierarchies.length;
        int n2 = 0;
        while (n2 < n) {
            Class[] hierarchy = classArrayArray[n2];
            if (!has || hierarchy.length < minLength) {
                minLength = hierarchy.length;
            }
            ++n2;
        }
        Class lastEqual = null;
        int i2 = 0;
        while (i2 < minLength) {
            boolean allEqualHere = false;
            allEqualHere = true;
            int e = 1;
            while (e < hierarchies.length) {
                if (hierarchies[e][i2] != hierarchies[0][i2]) {
                    allEqualHere = false;
                    break;
                }
                ++e;
            }
            if (!allEqualHere) {
                return lastEqual;
            }
            lastEqual = hierarchies[0][i2];
            ++i2;
        }
        return lastEqual;
    }

    public static Class[] getClassInheritanceHierarchy(Class c) {
        if (c == null) {
            return new Class[]{Object.class};
        }
        if (c.isPrimitive() || c == Void.class) {
            return new Class[]{c};
        }
        Object[] h = AngryReflectionUtility.getClassInheritanceHierarchyReversed(c);
        ArrayUtilities.reverse(h);
        return h;
    }

    public static Class[] getClassInheritanceHierarchyReversed(Class c) {
        if (c == null) {
            return new Class[]{Object.class};
        }
        if (c.isPrimitive() || c == Void.class) {
            return new Class[]{c};
        }
        ArrayList l = new ArrayList();
        Class s = c;
        while (s != null) {
            l.add(s);
            s = s.getSuperclass();
        }
        return l.toArray(new Class[l.size()]);
    }

    public static Class[] getClassesOf(Object ... things) {
        if (things == null) {
            return null;
        }
        Class[] classes = new Class[things.length];
        int i = 0;
        while (i < things.length) {
            classes[i] = BasicObjectUtilities.getClassNT(things[i]);
            ++i;
        }
        return classes;
    }

    public static void setAccessibleIfNotPublic(Member thing) throws SecurityException {
        if (Modifier.isPublic(thing.getModifiers())) {
            return;
        }
        ((AccessibleObject)((Object)thing)).setAccessible(true);
    }

    public static Map<Field, Object> createObjectAsMapViewByFieldsThroughReflection(Object object, boolean includeNonpublicMembersThroughAccessibilityOverrideAttempts, boolean includeSupertypeMembers) {
        throw new NotYetImplementedException();
    }

    public static Map<Field, Object> createObjectAsMapViewByFieldsThroughReflection(Object object) {
        return AngryReflectionUtility.createObjectAsMapViewByFieldsThroughReflection(object, false, true);
    }

    public static Set newPropertySingletonByFieldThroughReflection(Field field, Object instance) {
        throw new NotYetImplementedException();
    }

    public static Set newStaticPropertySingletonByFieldThroughReflection(Field staticField) {
        throw new NotYetImplementedException();
    }

    public static boolean isJavaToplevelClass(Class c) {
        return c.getEnclosingClass() == null;
    }

    public static boolean isJavaNestedClass(Class c) {
        return c.isMemberClass() && Modifier.isStatic(c.getModifiers());
    }

    public static boolean isJavaInnerClass(Class c) {
        return c.isMemberClass() && !Modifier.isStatic(c.getModifiers());
    }

    public static boolean isJavaLocalClass(Class c) {
        return c.isLocalClass();
    }

    public static boolean isJavaAnonymousClass(Class c) {
        return c.isAnonymousClass();
    }

    public static boolean isJavaNestedOrInnerClass(Class c) {
        return c.isMemberClass();
    }

    public static boolean isJavaLocalOrAnonymousClass(Class c) {
        return c.isLocalClass() || c.isAnonymousClass();
    }

    public static boolean isJavaClassThatCouldHaveOuterClassContextField(Class c) {
        return AngryReflectionUtility.isJavaInnerClass(c) || c.isLocalClass() || c.isAnonymousClass();
    }

    public static void _isJavaSelfCheck(Class c) {
        if (c == null) {
            return;
        }
        int n = 0;
        if (AngryReflectionUtility.isJavaToplevelClass(c)) {
            ++n;
        }
        if (AngryReflectionUtility.isJavaNestedClass(c)) {
            ++n;
        }
        if (AngryReflectionUtility.isJavaInnerClass(c)) {
            ++n;
        }
        if (AngryReflectionUtility.isJavaLocalClass(c)) {
            ++n;
        }
        if (AngryReflectionUtility.isJavaAnonymousClass(c)) {
            ++n;
        }
        if (n != 1) {
            throw new AssertionError((Object)("isJavaXYZ checks failed; " + n + " leafset predicates return true! ;_;"));
        }
    }

    public static Class getToplevelClass(Class c) {
        Class<?> y;
        Class x = c;
        while ((y = x.getEnclosingClass()) != null) {
        }
        return x;
    }

    @Nonnull
    public static Field getEnumField(Enum singleton) {
        Field f;
        Objects.requireNonNull(singleton);
        Class c = singleton.getDeclaringClass();
        try {
            f = c.getDeclaredField(singleton.name());
        }
        catch (NoSuchFieldException exc) {
            throw new ImPrettySureThisNeverActuallyHappensRuntimeException(exc);
        }
        if (f == null) {
            throw new ImPrettySureThisNeverActuallyHappensRuntimeException();
        }
        return f;
    }

    public static String getCodeName(Class c) {
        if (c.isArray()) {
            return String.valueOf(AngryReflectionUtility.getCodeName(c.getComponentType())) + "[]";
        }
        return c.getName();
    }

    @Nonnull
    @ThrowAwayValue
    public static Map<Class<? extends Annotation>, List<? extends Annotation>> getPublicUninheritedAnnotations(AnnotatedElement o) {
        HashMap<Class<? extends Annotation>, List<? extends Annotation>> annotationsMap = new HashMap<Class<? extends Annotation>, List<? extends Annotation>>();
        Annotation[] annotationArray = o.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            Class<? extends Annotation> c = a.annotationType();
            if (!annotationsMap.containsKey(c)) {
                annotationsMap.put(c, CollectionUtilities.asList(o.getAnnotationsByType(c)));
            }
            ++n2;
        }
        return annotationsMap;
    }

    @Nullable
    public static Method getUninheritedMethodByAnnotationPresence(Class c, Class<? extends Annotation> annotationClass) {
        Method found = null;
        Method[] methodArray = c.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.isAnnotationPresent(annotationClass)) {
                if (found != null) {
                    throw new ImpossibleException("Misconfigured class!!  Multiple methods with the @" + annotationClass.getName() + " annotation!!");
                }
                found = m;
            }
            ++n2;
        }
        return found;
    }

    @Nullable
    public static Field getUninheritedFieldByAnnotationPresence(Class c, Class<? extends Annotation> annotationClass) {
        Field found = null;
        Field[] fieldArray = c.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field m = fieldArray[n2];
            if (m.isAnnotationPresent(annotationClass)) {
                if (found != null) {
                    throw new ImpossibleException("Misconfigured class!!  Multiple methods with the @" + annotationClass.getName() + " annotation!!");
                }
                found = m;
            }
            ++n2;
        }
        return found;
    }

    @Nonnull
    public static Class getRawType(@Nonnull Type type) {
        return type instanceof Class ? (Class)type : (Class)((ParameterizedType)type).getRawType();
    }

    public static <T extends AccessibleObject> T makeAccessible(T member) {
        member.setAccessible(true);
        return member;
    }

    public static Type getListGenericParameterTypeOrNull(Type t) {
        if (t == List.class) {
            return Object.class;
        }
        if (t instanceof ParameterizedType && ((ParameterizedType)t).getRawType() == List.class) {
            return ((ParameterizedType)t).getActualTypeArguments()[0];
        }
        return null;
    }

    public static Type getMapKeysGenericParameterTypeOrNull(Type t) {
        if (t == Map.class) {
            return Object.class;
        }
        if (t instanceof ParameterizedType && ((ParameterizedType)t).getRawType() == Map.class) {
            return ((ParameterizedType)t).getActualTypeArguments()[0];
        }
        return null;
    }

    public static Type getMapValuesGenericParameterTypeOrNull(Type t) {
        if (t == Map.class) {
            return Object.class;
        }
        if (t instanceof ParameterizedType && ((ParameterizedType)t).getRawType() == Map.class) {
            return ((ParameterizedType)t).getActualTypeArguments()[1];
        }
        return null;
    }

    public static Object invokeUnchecked(Method x, Object instance, Object ... args) throws RuntimeException {
        try {
            return x.invoke(instance, args);
        }
        catch (IllegalAccessException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
        catch (InvocationTargetException exc) {
            throw BasicExceptionUtilities.rethrowSafe(exc.getTargetException());
        }
    }

    public static Object invokeStaticUnchecked(Method x, Object ... args) throws RuntimeException {
        return AngryReflectionUtility.invokeUnchecked(x, null, args);
    }

    public static Object invokeStaticUnchecked(Constructor x, Object ... args) throws RuntimeException {
        try {
            return x.newInstance(args);
        }
        catch (InstantiationException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
        catch (IllegalAccessException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
        catch (InvocationTargetException exc) {
            throw BasicExceptionUtilities.rethrowSafe(exc.getTargetException());
        }
    }

    public static Object invokeStaticUnchecked(Executable x, Object ... args) throws RuntimeException {
        if (x instanceof Method) {
            return AngryReflectionUtility.invokeStaticUnchecked((Method)x, args);
        }
        if (x instanceof Constructor) {
            return AngryReflectionUtility.invokeStaticUnchecked((Constructor)x, args);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(x);
    }

    public static Object getUnchecked(Field x, Object instance) throws RuntimeException {
        try {
            return x.get(instance);
        }
        catch (IllegalAccessException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static void setUnchecked(Field x, Object instance, Object newValue) throws RuntimeException {
        try {
            x.set(instance, newValue);
        }
        catch (IllegalAccessException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static Object getStaticUnchecked(Field x) throws RuntimeException {
        return AngryReflectionUtility.getUnchecked(x, null);
    }

    public static void setStaticUnchecked(Field x, Object newValue) throws RuntimeException {
        AngryReflectionUtility.setUnchecked(x, null, newValue);
    }

    public static Object[] prepareVarArgs(Executable e, Object[] sourceCodeStyleInputs) {
        if (e.isVarArgs()) {
            int n = e.getParameterCount();
            return AngryReflectionUtility.prepareVarArgs(n, e.getParameterTypes()[n - 1].getComponentType(), sourceCodeStyleInputs);
        }
        return sourceCodeStyleInputs;
    }

    public static Object[] prepareVarArgs(int parameterCountIncludingVarArgs, Class varargsComponentType, Object[] sourceCodeStyleInputs) {
        int numberOfNonvarArgs = parameterCountIncludingVarArgs - 1;
        if (numberOfNonvarArgs == 0) {
            return new Object[]{sourceCodeStyleInputs};
        }
        Object[] r = new Object[parameterCountIncludingVarArgs];
        int numberOfGivenArgs = sourceCodeStyleInputs.length;
        if (numberOfGivenArgs < numberOfNonvarArgs) {
            throw new IllegalArgumentException("Insufficient parameters provided to varargs function: At least " + numberOfNonvarArgs + " parameters must be provided (to make 0 varargs), but " + numberOfGivenArgs + " were provided.");
        }
        int numberOfVarArgs = numberOfGivenArgs - numberOfNonvarArgs;
        Object vars = numberOfVarArgs == 0 ? ArrayUtilities.emptyArrayByComponentType(varargsComponentType) : Array.newInstance(varargsComponentType, numberOfVarArgs);
        System.arraycopy(sourceCodeStyleInputs, 0, r, 0, numberOfNonvarArgs);
        System.arraycopy(sourceCodeStyleInputs, numberOfNonvarArgs, vars, 0, numberOfVarArgs);
        r[numberOfNonvarArgs] = vars;
        return r;
    }

    public static enum JavaModifierParametersForClasses {
        VISBILITY,
        SUBCLASSABILITY,
        STATIC,
        STRICTFP;

    }

    public static enum JavaModifierParametersForFields {
        VISBILITY,
        STATIC,
        FINAL,
        TRANSIENT,
        VOLATILE;

    }

    public static enum JavaModifierParametersForMethods {
        VISBILITY,
        SUBCLASSABILITY,
        STATIC,
        NATIVE,
        STRICTFP,
        SYNCHRONIZED;

    }

    public static enum JavaOverrideOrSubclassAbility {
        ABSTRACT,
        DEFAULT,
        FINAL;

    }

    public static enum JavaVisibility {
        Public("public"),
        Protected("protected"),
        PackagePrivate(""),
        Private("private");

        protected String codeManifestation;

        private JavaVisibility(String codeManifestation) {
            this.codeManifestation = codeManifestation;
        }

        public String getManifestationInCode() {
            return this.codeManifestation;
        }

        public String toString() {
            return this == PackagePrivate ? "<package private>" : this.getManifestationInCode();
        }

        public JavaVisibility fromString(String str) {
            if (BasicObjectUtilities.eq((Object)(str = str.trim()), (Object)"public")) {
                return Public;
            }
            if (BasicObjectUtilities.eq((Object)str, (Object)"protected")) {
                return Protected;
            }
            if (BasicObjectUtilities.eq((Object)str, (Object)"private")) {
                return Private;
            }
            if (str == null || str.isEmpty() || BasicObjectUtilities.eq((Object)str, (Object)"package") || BasicObjectUtilities.eq((Object)str, (Object)"<package private>")) {
                return PackagePrivate;
            }
            throw new IllegalArgumentException("Invalid Java Visibility: " + str);
        }
    }
}

