/*
 * Decompiled with CFR 0.152.
 */
package rebound.osint.modapple.eawtproxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import rebound.exceptions.ImpossibleException;
import rebound.osint.modapple.eawtproxy.ApplicationEventProxy;
import rebound.osint.modapple.eawtproxy.ApplicationListenerClone;

public class ApplicationProxy {
    protected Object applicationInstance;
    protected Class c_application;
    protected Class c_applicationListener;
    protected Class c_applicationEvent;
    protected Method m_addAboutMenuItem;
    protected Method m_addPreferencesMenuItem;
    protected Method m_removeAboutMenuItem;
    protected Method m_removePreferencesMenuItem;
    protected Method m_addApplicationListener;
    protected Method m_listener_handleAbout;
    protected Method m_listener_handleOpenFile;
    protected Method m_listener_handleQuit;
    protected Method m_listener_handleReOpenApplication;
    protected Method m_listener_handleOpenApplication;
    protected Method m_listener_handlePreferences;
    protected Method m_listener_handlePrintFile;
    protected Method m_event_getFilename;
    protected Method m_event_isHandled;
    protected Method m_event_setHandled;

    private static Class c(String name) {
        try {
            return Class.forName("com.apple.eawt." + name);
        }
        catch (ClassNotFoundException exc) {
            throw new ImpossibleException(exc);
        }
    }

    private static Method m(Class c, String name, Class ... parameterTypes) {
        try {
            return c.getMethod(name, parameterTypes);
        }
        catch (SecurityException exc) {
            throw new ImpossibleException(exc);
        }
        catch (NoSuchMethodException exc) {
            throw new ImpossibleException(exc);
        }
    }

    private static Object call(Object o, Method m, Object ... args) {
        try {
            return m.invoke(o, args);
        }
        catch (IllegalArgumentException exc) {
            throw new ImpossibleException(exc);
        }
        catch (IllegalAccessException exc) {
            throw new ImpossibleException(exc);
        }
        catch (InvocationTargetException exc) {
            Throwable t = exc.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new ImpossibleException(t);
        }
    }

    private static Object callStatic(Method m, Object ... args) {
        return ApplicationProxy.call(null, m, args);
    }

    protected ApplicationProxy() {
    }

    public static boolean canGetApplication() {
        try {
            Class.forName("com.apple.eawt.Application");
        }
        catch (ClassNotFoundException exc) {
            return false;
        }
        return true;
    }

    public static ApplicationProxy getApplication() {
        Class<?> c_application = null;
        try {
            c_application = Class.forName("com.apple.eawt.Application");
        }
        catch (ClassNotFoundException exc) {
            return null;
        }
        Method m_getApplication = ApplicationProxy.m(c_application, "getApplication", new Class[0]);
        Object applicationInstance = ApplicationProxy.callStatic(m_getApplication, new Object[0]);
        if (applicationInstance == null) {
            throw new ImpossibleException(new NullPointerException("com.apple.eawt.Application.getApplication() returned null"));
        }
        if (!c_application.isInstance(applicationInstance)) {
            throw new ImpossibleException(new ClassCastException("com.apple.eawt.Application.getApplication() returned a non com.apple.eawt.Application"));
        }
        ApplicationProxy proxy = new ApplicationProxy();
        proxy.applicationInstance = applicationInstance;
        proxy.c_application = c_application;
        proxy.c_applicationListener = ApplicationProxy.c("ApplicationListener");
        proxy.c_applicationEvent = ApplicationProxy.c("ApplicationEvent");
        proxy.m_addAboutMenuItem = ApplicationProxy.m(c_application, "addAboutMenuItem", new Class[0]);
        proxy.m_addPreferencesMenuItem = ApplicationProxy.m(c_application, "addPreferencesMenuItem", new Class[0]);
        proxy.m_removeAboutMenuItem = ApplicationProxy.m(c_application, "removeAboutMenuItem", new Class[0]);
        proxy.m_removePreferencesMenuItem = ApplicationProxy.m(c_application, "removePreferencesMenuItem", new Class[0]);
        proxy.m_addApplicationListener = ApplicationProxy.m(c_application, "addApplicationListener", proxy.c_applicationListener);
        proxy.m_event_getFilename = ApplicationProxy.m(proxy.c_applicationEvent, "getFilename", new Class[0]);
        proxy.m_event_isHandled = ApplicationProxy.m(proxy.c_applicationEvent, "isHandled", new Class[0]);
        proxy.m_event_setHandled = ApplicationProxy.m(proxy.c_applicationEvent, "setHandled", Boolean.TYPE);
        proxy.m_listener_handleAbout = ApplicationProxy.m(proxy.c_applicationListener, "handleAbout", proxy.c_applicationEvent);
        proxy.m_listener_handleOpenFile = ApplicationProxy.m(proxy.c_applicationListener, "handleOpenFile", proxy.c_applicationEvent);
        proxy.m_listener_handleQuit = ApplicationProxy.m(proxy.c_applicationListener, "handleQuit", proxy.c_applicationEvent);
        proxy.m_listener_handleReOpenApplication = ApplicationProxy.m(proxy.c_applicationListener, "handleReOpenApplication", proxy.c_applicationEvent);
        proxy.m_listener_handleOpenApplication = ApplicationProxy.m(proxy.c_applicationListener, "handleOpenApplication", proxy.c_applicationEvent);
        proxy.m_listener_handlePreferences = ApplicationProxy.m(proxy.c_applicationListener, "handlePreferences", proxy.c_applicationEvent);
        proxy.m_listener_handlePrintFile = ApplicationProxy.m(proxy.c_applicationListener, "handlePrintFile", proxy.c_applicationEvent);
        return proxy;
    }

    public void addPreferencesMenuItem() {
        ApplicationProxy.call(this.applicationInstance, this.m_addPreferencesMenuItem, new Object[0]);
    }

    public void removePreferencesMenuItem() {
        ApplicationProxy.call(this.applicationInstance, this.m_removePreferencesMenuItem, new Object[0]);
    }

    public void addAboutMenuItem() {
        ApplicationProxy.call(this.applicationInstance, this.m_addAboutMenuItem, new Object[0]);
    }

    public void removeAboutMenuItem() {
        ApplicationProxy.call(this.applicationInstance, this.m_removeAboutMenuItem, new Object[0]);
    }

    public void addApplicationListener(final ApplicationListenerClone applistenerClone) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (args.length != 1) {
                    throw new ImpossibleException(String.valueOf(args.length) + " parameters passed to a com.apple.eawt.ApplicationListener method");
                }
                if (args[0] != null && !ApplicationProxy.this.c_applicationEvent.isInstance(args[0])) {
                    throw new ImpossibleException("A non com.apple.eawt.ApplicationEvent value was passed to a com.apple.eawt.ApplicationListener method");
                }
                ApplicationEventProxy eventProxy = ApplicationProxy.this.wrapEvent(args[0]);
                if (method.equals(ApplicationProxy.this.m_listener_handleAbout)) {
                    applistenerClone.handleAbout(eventProxy);
                } else if (method.equals(ApplicationProxy.this.m_listener_handleOpenApplication)) {
                    applistenerClone.handleOpenApplication(eventProxy);
                } else if (method.equals(ApplicationProxy.this.m_listener_handleOpenFile)) {
                    applistenerClone.handleOpenFile(eventProxy);
                } else if (method.equals(ApplicationProxy.this.m_listener_handlePreferences)) {
                    applistenerClone.handlePreferences(eventProxy);
                } else if (method.equals(ApplicationProxy.this.m_listener_handlePrintFile)) {
                    applistenerClone.handlePrintFile(eventProxy);
                } else if (method.equals(ApplicationProxy.this.m_listener_handleQuit)) {
                    applistenerClone.handleQuit(eventProxy);
                } else if (method.equals(ApplicationProxy.this.m_listener_handleReOpenApplication)) {
                    applistenerClone.handleReOpenApplication(eventProxy);
                } else {
                    throw new ImpossibleException("Unknown method of com.apple.eawt.ApplicationListener: " + method);
                }
                return null;
            }
        };
        Object listener = Proxy.newProxyInstance(ApplicationProxy.class.getClassLoader(), new Class[]{this.c_applicationListener}, handler);
        ApplicationProxy.call(this.applicationInstance, this.m_addApplicationListener, listener);
    }

    protected ApplicationEventProxy wrapEvent(final Object event) {
        return new ApplicationEventProxy(){

            @Override
            public void setHandled(boolean value) {
                ApplicationProxy.call(event, ApplicationProxy.this.m_event_setHandled, new Object[]{value});
            }

            @Override
            public boolean isHandled(boolean value) {
                return (Boolean)ApplicationProxy.call(event, ApplicationProxy.this.m_event_isHandled, new Object[0]);
            }

            @Override
            public String getFilename() {
                return (String)ApplicationProxy.call(event, ApplicationProxy.this.m_event_getFilename, new Object[0]);
            }
        };
    }
}

