/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui.edos.sedpane;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.swing.JComponent;
import rebound.hci.graphics2d.ImageUtilities;
import rebound.jagent.ui.gui.edos.sedpane.DnDErrorHandler;
import rebound.jagent.ui.gui.edos.sedpane.DnDiplomat;
import rebound.jagent.ui.gui.edos.sedpane.ImageStorage;
import rebound.jagent.ui.gui.edos.sedpane.MutableImageStorage;
import rebound.jagent.ui.gui.edos.sedpane.SedpaneImageMutationListener;
import rebound.jagent.ui.gui.edos.sedpane.SedpaneSelectionChangeListener;
import rebound.math.geom2d.Direction2D;

public class Sedpane
extends JComponent
implements KeyListener {
    public static final Color Default_Background = new Color(0, 0, 192);
    public static final Color Default_Foreground = new Color(64, 64, 255);
    public static final int Thumbnail_Width = 48;
    public static final int Thumbnail_Height = 48;
    protected static final int Absurdly_Large = 256;
    public static final int XPadding = 10;
    public static final int YPadding = 10;
    public static final int Selected_XPadding = 9;
    public static final int Selected_YPadding = 9;
    public static final Color Default_Infomask_BG = new Color(240, 240, 240, 128);
    public static final Color Default_Infomask_FG = new Color(0, 0, 0, 255);
    public static final int IDragCursor_Height = 58;
    protected Font infomaskFont;
    protected boolean wrapSideways = true;
    protected SedpaneSelectionChangeListener selectionChangeListener = null;
    protected SedpaneImageMutationListener mutationListener = null;
    protected DnDErrorHandler dndErrorHandler = null;
    protected MutableImageStorage storage = null;
    protected DragSource odragSource;
    protected DragGestureRecognizer odragRecognizer;
    protected DropTarget idropTarget;
    protected DnDiplomat diplomat = null;
    protected int matrixWidth = 0;
    protected int matrixHeight = 0;
    protected int matrixOffset = 0;
    protected int selected = -1;
    protected int infomask = -1;
    protected int idragCursorX = -1;
    protected int idragCursorY = -1;
    private DataFlavor uniqueDataFlavor;

    public Sedpane() {
        if (this.getBackground() == null) {
            this.setBackground(Default_Background);
        }
        if (this.getForeground() == null) {
            this.setForeground(Default_Foreground);
        }
        this.infomaskFont = new Font("SansSerif", 0, 12);
        this.registerEventListeners();
    }

    public void add(BufferedImage image) {
        this.add(image, this.getImageCount());
    }

    public void add(BufferedImage original, int insertionPoint) {
        this.storage.add(original, insertionPoint);
        if (this.hasSelection() && this.getSelectedImageIndex() >= insertionPoint) {
            this.setSelected(this.getSelectedMatrixIndex() + 1);
        }
        if (this.getImageMutationListener() != null) {
            this.getImageMutationListener().imageAdded(insertionPoint);
        }
        this.repaint();
    }

    public void delete(int index) {
        if (index >= 0 && index < this.getImageCount()) {
            int emptyRowCount;
            this.storage.delete(index);
            if (this.hasSelection() && index < this.getSelectedImageIndex()) {
                this.setSelected(this.getSelectedMatrixIndex() - 1);
            }
            if ((emptyRowCount = this.getEmptyTileCount() / this.getMatrixWidth()) > 0 && this.shiftRows(-1) != 0 && this.hasSelection()) {
                this.setSelected(this.getSelectedMatrixIndex() + this.getMatrixWidth());
            }
            this.killInfomask();
            if (this.getImageMutationListener() != null) {
                this.getImageMutationListener().imageDeleted(index);
            }
            this.repaint();
        }
    }

    public void setImages(BufferedImage[] imgs) {
        this.clear();
        int i = 0;
        while (i < imgs.length) {
            this.add(imgs[i]);
            ++i;
        }
    }

    public void reorder(int old, int fresh) {
        if (fresh != old && fresh != old + 1) {
            this.storage.reorder(old, fresh);
            if (this.hasSelection()) {
                if (old == this.getSelectedMatrixIndex()) {
                    if (fresh < old) {
                        this.setSelected(fresh);
                    } else {
                        this.setSelected(fresh - 1);
                    }
                } else if (old > this.getSelectedImageIndex() && fresh <= this.getSelectedImageIndex()) {
                    this.setSelected(this.getSelectedMatrixIndex() + 1);
                } else if (old < this.getSelectedImageIndex() && fresh > this.getSelectedImageIndex()) {
                    this.setSelected(this.getSelectedMatrixIndex() - 1);
                }
            }
            if (this.getImageMutationListener() != null) {
                this.getImageMutationListener().imagesReordered(old, fresh);
            }
            this.repaint();
        }
    }

    public void clear() {
        this.storage.clear();
        if (this.hasIDragCursor()) {
            this.setIDragCursor(0, 0);
        }
        this.killInfomask();
        this.killSelection();
        if (this.getImageMutationListener() != null) {
            this.getImageMutationListener().imagesCleared();
        }
        this.repaint();
    }

    public int getImageCount() {
        return this.getImageStorage().getCount();
    }

    public boolean isEmpty() {
        return this.getImageCount() == 0;
    }

    public boolean isWrappingSideways() {
        return this.wrapSideways;
    }

    public void setWrapSideways(boolean wrapSideways) {
        this.wrapSideways = wrapSideways;
    }

    public Font getInfomaskFont() {
        return this.infomaskFont;
    }

    public void setInfomaskFont(Font infomaskFont) {
        this.infomaskFont = infomaskFont;
    }

    public DnDiplomat getDnDiplomat() {
        return this.diplomat;
    }

    public void setDnDiplomat(DnDiplomat diplomat) {
        this.diplomat = diplomat;
    }

    public SedpaneSelectionChangeListener getSelectionChangeListener() {
        return this.selectionChangeListener;
    }

    public void setSelectionChangeListener(SedpaneSelectionChangeListener notifee) {
        this.selectionChangeListener = notifee;
    }

    public SedpaneImageMutationListener getImageMutationListener() {
        return this.mutationListener;
    }

    public void setImageMutationListener(SedpaneImageMutationListener notifee) {
        this.mutationListener = notifee;
    }

    public DnDErrorHandler getDnDErrorHandler() {
        return this.dndErrorHandler;
    }

    public void setDnDErrorHandler(DnDErrorHandler dndErrorHandler) {
        this.dndErrorHandler = dndErrorHandler;
    }

    public ImageStorage getImageStorage() {
        return this.storage;
    }

    public void setImageStorage(MutableImageStorage storage) {
        this.storage = storage;
    }

    public int getMatrixWidth() {
        return this.matrixWidth;
    }

    public int getMatrixHeight() {
        return this.matrixHeight;
    }

    public int getMatrixSize() {
        return this.matrixWidth * this.matrixHeight;
    }

    public int getMatrixOffset() {
        if (this.matrixOffset >= this.getImageCount()) {
            this.matrixOffset = this.getImageCount() - 1;
        }
        if (this.matrixOffset < 0) {
            this.matrixOffset = 0;
        }
        return this.matrixOffset;
    }

    protected void resizeMatrix(int newWidth, int newHeight) {
        if (newWidth < 0) {
            newWidth = 0;
        }
        if (newHeight < 0) {
            newHeight = 0;
        }
        this.matrixWidth = newWidth;
        this.matrixHeight = newHeight;
        if (this.getMatrixSize() > 0) {
            int newoff = this.getMatrixOffset();
            newoff = newoff / this.matrixWidth * this.matrixWidth;
            this.setMatrixOffset(newoff);
        }
        if (this.getMatrixSize() > 0) {
            int actual = this.shiftRows(-(this.getEmptyTileCount() / this.matrixWidth));
            if (this.hasSelection()) {
                this.setSelected(this.getSelectedMatrixIndex() + -actual * this.matrixWidth);
            }
        }
    }

    public int shiftRows(int rows) {
        if (rows != 0 && this.getMatrixSize() > 0) {
            int empty = Math.max(0, this.getMatrixSize() - (this.getImageCount() - (this.getMatrixOffset() + rows * this.getMatrixWidth())));
            int newoff = this.getMatrixOffset() + (rows -= empty / this.getMatrixWidth()) * this.getMatrixWidth();
            if (newoff >= 0) {
                this.setMatrixOffset(newoff);
                return rows;
            }
            return 0;
        }
        return 0;
    }

    public void setMatrixOffset(int newoff) {
        if (this.getImageCount() == 0) {
            if (this.matrixOffset != 0) {
                this.matrixOffset = 0;
                this.repaint();
            }
        } else {
            if (newoff < 0) {
                newoff = 0;
            } else if (newoff >= this.getImageCount()) {
                newoff = this.getImageCount() - 1;
            }
            if (this.matrixOffset != newoff) {
                this.matrixOffset = newoff;
                this.repaint();
            }
        }
    }

    public int getSelectedMatrixIndex() {
        if (this.selected == -1) {
            return -1;
        }
        if (this.selected < -1) {
            this.selected = -1;
        } else if (this.selected >= this.getMatrixSize()) {
            this.selected = this.getMatrixSize() - 1;
        } else if (this.selected + this.getMatrixOffset() >= this.getImageCount()) {
            this.selected = this.getImageCount() - 1 - this.getMatrixOffset();
        }
        return this.selected;
    }

    public boolean hasSelection() {
        return this.getSelectedMatrixIndex() != -1;
    }

    public int getSelectedImageIndex() {
        if (this.hasSelection()) {
            return this.getMatrixOffset() + this.getSelectedMatrixIndex();
        }
        return -1;
    }

    public int getSelectedColumn() {
        if (!this.hasSelection()) {
            return -1;
        }
        return this.getSelectedMatrixIndex() % this.getMatrixWidth();
    }

    public int getSelectedRow() {
        if (!this.hasSelection()) {
            return -1;
        }
        return this.getSelectedMatrixIndex() / this.getMatrixWidth();
    }

    public void moveSelected(Direction2D dir) {
        if (this.getMatrixSize() > 0 && this.hasSelection()) {
            int cx = this.getSelectedColumn();
            int cy = this.getSelectedRow();
            int dx = cx;
            int dy = cy;
            if (dir == Direction2D.Down) {
                if (cy == this.getMatrixHeight() - 1) {
                    this.shiftRows(1);
                } else {
                    ++dy;
                }
                if (!this.isMatrixTileFilled(dx, dy)) {
                    --dy;
                }
            } else if (dir == Direction2D.Up) {
                if (cy == 0) {
                    this.shiftRows(-1);
                } else {
                    --dy;
                }
            } else if (dir == Direction2D.Right) {
                if (cx == this.getMatrixWidth() - 1) {
                    if (this.isWrappingSideways()) {
                        if (cy == this.getMatrixHeight() - 1) {
                            if (this.shiftRows(1) != 0) {
                                dx = 0;
                            }
                        } else if (this.isMatrixTileFilled(0, dy + 1)) {
                            dx = 0;
                            ++dy;
                        }
                    }
                } else if (this.isMatrixTileFilled(dx + 1, dy)) {
                    ++dx;
                }
            } else if (dir == Direction2D.Left) {
                if (cx == 0) {
                    if (this.isWrappingSideways()) {
                        if (cy == 0) {
                            if (this.shiftRows(-1) != 0) {
                                dx = this.getMatrixWidth() - 1;
                            }
                        } else {
                            dx = this.getMatrixWidth() - 1;
                            --dy;
                        }
                    }
                } else {
                    --dx;
                }
            }
            this.setSelected(dx, dy);
        }
    }

    public void setSelected(int col, int row) {
        if (this.getMatrixSize() > 0) {
            if (col < 0 || row < 0) {
                this.killSelection();
            } else {
                int index;
                if (col >= this.getMatrixWidth()) {
                    col = this.getMatrixWidth() - 1;
                }
                if (row >= this.getMatrixHeight()) {
                    row = this.getMatrixHeight() - 1;
                }
                if ((index = col + row * this.getMatrixWidth()) + this.getMatrixOffset() >= this.getImageCount()) {
                    index = this.getImageCount() - 1 - this.getMatrixOffset();
                }
                this.setSelected(index);
            }
        }
    }

    public void killSelection() {
        if (this.selected != -1) {
            this.selected = -1;
            this.repaint();
        }
    }

    public void setSelected(int index) {
        if (index < -1) {
            index = -1;
        } else if (index != -1) {
            if (index >= this.getMatrixSize()) {
                index = this.getMatrixSize() - 1;
            } else if (this.getMatrixOffset() + index >= this.getImageCount()) {
                index = this.getImageCount() - this.getMatrixOffset() - 1;
            }
        }
        if (index != this.selected) {
            if (this.selectionChangeListener != null) {
                this.selectionChangeListener.selectedChange(this.selected, index);
            }
            this.selected = index;
            this.repaint();
        }
    }

    public int getInfomaskMatrixIndex() {
        if (this.infomask < -1) {
            this.infomask = -1;
        } else if (this.infomask + this.getMatrixOffset() >= this.getImageCount()) {
            this.infomask = -1;
        }
        return this.infomask;
    }

    public boolean isInfomaskVisible() {
        return this.getInfomaskMatrixIndex() != -1;
    }

    public void setInfomask(int matrixIndex) {
        if (matrixIndex < -1) {
            matrixIndex = -1;
        } else if (matrixIndex + this.getMatrixOffset() >= this.getImageCount()) {
            matrixIndex = -1;
        }
        if (this.infomask != matrixIndex) {
            this.infomask = matrixIndex;
            this.repaint();
        }
    }

    public void killInfomask() {
        if (this.isInfomaskVisible()) {
            this.infomask = -1;
            this.repaint();
        }
    }

    public int getIDragCursorColumn() {
        if (this.idragCursorX != -1 && this.idragCursorY != -1) {
            this.validateIDragCursor();
            return this.idragCursorX;
        }
        return -1;
    }

    public int getIDragCursorRow() {
        if (this.idragCursorX != -1 && this.idragCursorY != -1) {
            this.validateIDragCursor();
            return this.idragCursorY;
        }
        return -1;
    }

    public boolean hasIDragCursor() {
        this.validateIDragCursor();
        return this.idragCursorX != -1 && this.idragCursorY != -1;
    }

    public int getIDragCursorLogicalIndex() {
        return this.getIDragCursorRow() * this.getMatrixWidth() + this.getIDragCursorColumn();
    }

    public void killIDragCursor() {
        this.setIDragCursor(-1, -1);
    }

    public void setIDragCursorToEnd() {
        this.setIDragCursor(this.getMatrixWidth(), this.getMatrixHeight() - 1);
    }

    public void setIDragCursor(int col, int row) {
        if (col < 0 || row < 0) {
            boolean had = this.hasIDragCursor();
            this.idragCursorX = -1;
            this.idragCursorY = -1;
            if (had) {
                this.repaint();
            }
        } else {
            int oldx = this.idragCursorX;
            int oldy = this.idragCursorY;
            this.idragCursorX = col;
            this.idragCursorY = row;
            this.validateIDragCursor();
            if (oldx == -1 || oldy == -1) {
                if (this.idragCursorX != -1 && this.idragCursorY != -1) {
                    this.repaint();
                }
            } else if (this.idragCursorX == -1 || this.idragCursorY == -1) {
                this.repaint();
            }
        }
    }

    protected void validateIDragCursor() {
        if (this.idragCursorX == -1 || this.idragCursorY == -1) {
            this.idragCursorX = -1;
            this.idragCursorY = -1;
        } else if (this.getImageCount() == 0 || this.getMatrixSize() == 0) {
            this.idragCursorX = 0;
            this.idragCursorY = 0;
        } else {
            int x = this.idragCursorX;
            int y = this.idragCursorY;
            if (x > this.getMatrixWidth()) {
                x = this.getMatrixWidth();
            }
            if (y >= this.getMatrixHeight()) {
                y = this.getMatrixHeight() - 1;
            }
            int lastMatrixImage = this.getImageCount() - this.getMatrixOffset() - 1;
            if (y * this.getMatrixWidth() + x > lastMatrixImage + 1) {
                x = lastMatrixImage % this.getMatrixWidth() + 1;
                y = lastMatrixImage / this.getMatrixWidth();
            }
            this.idragCursorX = x;
            this.idragCursorY = y;
        }
    }

    public int getTileIndex(int x, int y) {
        int col = x / 68;
        int relx = x % 68;
        int row = y / 68;
        int rely = y % 68;
        if (col < 0 || row < 0 || col >= this.getMatrixWidth() || row >= this.getMatrixHeight()) {
            return -1;
        }
        if (relx >= 10 && relx < 58 && rely >= 10 && rely < 58) {
            return col + row * this.getMatrixWidth();
        }
        return -1;
    }

    public int getEmptyTileCount() {
        return this.getMatrixSize() - this.getLastFilledTileIndex() - 1;
    }

    public int getFilledMatrixIndex(int matrixIndex) {
        if (matrixIndex < 0) {
            return -1;
        }
        if (matrixIndex >= this.getMatrixSize()) {
            return -1;
        }
        if (matrixIndex + this.getMatrixOffset() >= this.getImageCount()) {
            return -1;
        }
        return matrixIndex;
    }

    public boolean isMatrixIndexFilled(int matrixIndex) {
        return this.getFilledMatrixIndex(matrixIndex) != -1;
    }

    public boolean isMatrixTileFilled(int col, int row) {
        return this.getFilledMatrixIndex(col + row * this.getMatrixWidth()) != -1;
    }

    public int getLastFilledTileIndex() {
        return Math.min(this.getImageCount() - 1 - this.getMatrixOffset(), this.getMatrixSize() - 1);
    }

    public int getLastFilledColumn() {
        return this.getLastFilledTileIndex() % this.getMatrixWidth();
    }

    public int getLastFilledRow() {
        return this.getLastFilledTileIndex() / this.getMatrixWidth();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color originalColor = g.getColor();
        Font originalFont = g.getFont();
        this.paintThumbnails((Graphics2D)g);
        this.paintSelectionBox((Graphics2D)g);
        this.paintInfomask((Graphics2D)g);
        this.paintIDragCursor((Graphics2D)g);
        g.setColor(originalColor);
        g.setFont(originalFont);
    }

    protected void paintThumbnails(Graphics2D g) {
        if (this.getMatrixSize() > 0) {
            int row = 0;
            while (row < this.getMatrixHeight()) {
                int col = 0;
                while (col < this.getMatrixWidth()) {
                    int x = col * 68 + 10;
                    int y = row * 68 + 10;
                    Image thumb = null;
                    int index = this.getMatrixOffset() + row * this.getMatrixWidth() + col;
                    if (index >= this.getImageCount()) {
                        return;
                    }
                    thumb = this.getImageStorage().getThumbnail(index);
                    int verticalPadding = 0;
                    int horizontalPadding = 0;
                    int thumbWidth = ImageUtilities.getWidthImmediately(thumb);
                    int thumbHeight = ImageUtilities.getHeightImmediately(thumb);
                    horizontalPadding = (48 - thumbWidth) / 2;
                    verticalPadding = (48 - thumbHeight) / 2;
                    g.drawImage(thumb, x + horizontalPadding, y + verticalPadding, null);
                    ++col;
                }
                ++row;
            }
        }
    }

    protected void paintSelectionBox(Graphics2D g) {
        if (this.hasSelection()) {
            int row = this.getSelectedRow();
            int col = this.getSelectedColumn();
            int left = 0;
            int top = 0;
            int right = 0;
            int bottom = 0;
            left = col * 68 + 10 - 9;
            top = row * 68 + 10 - 9;
            right = left + 9 + 48 + 9;
            bottom = top + 9 + 48 + 9;
            Color dark = this.getForeground().darker();
            Color light = this.getForeground().brighter();
            g.setColor(light);
            g.drawLine(--left, --top, left, bottom);
            g.setColor(light);
            g.drawLine(left, top, right, top);
            g.setColor(dark);
            g.drawLine(right, top, right, bottom);
            g.setColor(dark);
            g.drawLine(left, bottom, right, bottom);
        }
    }

    protected void paintInfomask(Graphics2D g) {
        if (this.isInfomaskVisible() && this.getMatrixSize() > 0) {
            Font font = this.getInfomaskFont();
            String[] lines = null;
            int imageIndex = this.getInfomaskMatrixIndex() + this.getMatrixOffset();
            lines = new String[]{"[ " + imageIndex + " ]", "W" + this.getImageStorage().getWidth(imageIndex), "H" + this.getImageStorage().getHeight(imageIndex)};
            TextLayout[] layouts = null;
            layouts = new TextLayout[lines.length];
            int i = 0;
            while (i < lines.length) {
                layouts[i] = new TextLayout(lines[i], font, g.getFontRenderContext());
                ++i;
            }
            int verticalPadding = 0;
            int totalHeight = 0;
            int i2 = 0;
            while (i2 < lines.length) {
                TextLayout layout = layouts[i2];
                totalHeight = (int)((float)totalHeight + (layout.getAscent() + layout.getDescent()));
                if (i2 < layouts.length - 1) {
                    totalHeight = (int)((float)totalHeight + layout.getLeading());
                }
                ++i2;
            }
            verticalPadding = (48 - totalHeight) / 2;
            int infomaskX = this.infomask % this.getMatrixWidth() * 68 + 10;
            int infomaskY = this.infomask / this.getMatrixWidth() * 68 + 10;
            g.setColor(Default_Infomask_BG);
            g.fillRect(infomaskX, infomaskY, 48, 48);
            int y = infomaskY + verticalPadding;
            g.setColor(Default_Infomask_FG);
            g.setFont(font);
            int i3 = 0;
            while (i3 < lines.length) {
                int horizontalPadding = (int)((48.0f - layouts[i3].getVisibleAdvance()) / 2.0f);
                y = (int)((float)y + layouts[i3].getAscent());
                g.drawString(lines[i3], infomaskX + horizontalPadding, y);
                y = (int)((float)y + layouts[i3].getDescent());
                y = (int)((float)y + layouts[i3].getLeading());
                ++i3;
            }
        }
    }

    protected void paintIDragCursor(Graphics2D g) {
        if (this.hasIDragCursor()) {
            int y2;
            int y1;
            int x = this.getIDragCursorColumn() * 68;
            int y = this.getIDragCursorRow() * 68;
            int verticalPadding = 5;
            Color baseColor = null;
            baseColor = this.getForeground();
            if (x > 0) {
                g.setColor(baseColor.brighter());
                y1 = y + verticalPadding;
                y2 = y + verticalPadding + 58 - 1;
                g.drawLine(x - 1, y1, x - 1, y2);
            }
            if (x < this.getWidth()) {
                g.setColor(baseColor.darker());
                y1 = y + verticalPadding;
                y2 = y + verticalPadding + 58 - 1;
                g.drawLine(x, y1, x, y2);
            }
        }
    }

    protected void registerEventListeners() {
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Sedpane.this.resized(Sedpane.this.getWidth(), Sedpane.this.getHeight());
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.odragSource = new DragSource();
        this.odragRecognizer = this.odragSource.createDefaultDragGestureRecognizer(this, 1, new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                Sedpane.this.odragBegin(dge, dge.getDragOrigin().x, dge.getDragOrigin().y);
            }
        });
        this.idropTarget = new DropTarget(this, new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                Sedpane.this.idragUpdate(true, dtde.getLocation().x, dtde.getLocation().y);
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                Sedpane.this.idragUpdate(false, dtde.getLocation().x, dtde.getLocation().y);
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                Sedpane.this.idragDropped(dtde);
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
                Sedpane.this.idragCancelled();
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
                Sedpane.this.mouseLeave();
                e.consume();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Sedpane.this.mouseUpdate(e.getX(), e.getY(), e.getModifiersEx());
                e.consume();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Sedpane.this.mouseClicked(e.getX(), e.getY(), e.getButton(), e.getModifiersEx());
                e.consume();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Sedpane.this.mouseUpdate(e.getX(), e.getY(), e.getModifiersEx());
                e.consume();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        this.addKeyListener(this);
    }

    protected void resized(int newWidth, int newHeight) {
        this.killIDragCursor();
        this.killInfomask();
        this.resizeMatrix(newWidth / 68, newHeight / 68);
        this.repaint();
    }

    public DataFlavor getUniqueInternalReorderFlavor() {
        if (this.uniqueDataFlavor == null) {
            String uniqueExtension = null;
            int objectCode = 0;
            String vmCode = null;
            objectCode = System.identityHashCode(this);
            vmCode = ManagementFactory.getRuntimeMXBean().getName();
            StringBuilder buff = new StringBuilder();
            char[] cArray = vmCode.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    buff.append(c);
                } else {
                    buff.append(Integer.toHexString(c).toUpperCase());
                }
                ++n2;
            }
            vmCode = buff.toString();
            uniqueExtension = String.valueOf(objectCode) + "-" + vmCode;
            this.uniqueDataFlavor = new DataFlavor("application/x-sedpane-reorder-" + uniqueExtension + "; class=java.lang.Integer", "Internal Sedpane Reorder");
        }
        return this.uniqueDataFlavor;
    }

    protected synchronized void odragBegin(DragGestureEvent e, int x, int y) {
        int index = this.getFilledMatrixIndex(this.getTileIndex(x, y));
        if (index != -1) {
            Image img = this.getImageStorage().getThumbnail(index += this.getMatrixOffset());
            Sedragdata t = new Sedragdata(index, this.storage.load(index));
            this.odragSource.startDrag(e, null, img, new Point(-ImageUtilities.getWidthImmediately(img) / 2, -ImageUtilities.getHeightImmediately(img) / 2), t, new DragSourceListener(){

                @Override
                public void dragDropEnd(DragSourceDropEvent dsde) {
                    Sedpane.this.odragEnd();
                }

                @Override
                public void dropActionChanged(DragSourceDragEvent dsde) {
                }

                @Override
                public void dragOver(DragSourceDragEvent dsde) {
                }

                @Override
                public void dragExit(DragSourceEvent dse) {
                }

                @Override
                public void dragEnter(DragSourceDragEvent dsde) {
                }
            });
        }
    }

    protected void odragEnd() {
        this.killInfomask();
        this.getDnDiplomat().freeDragResources();
    }

    protected void idragUpdate(boolean fresh, int x, int y) {
        int col = 0;
        int row = 0;
        int tilewidth = 68;
        col = (x + tilewidth / 2) / tilewidth;
        row = y / 68;
        this.setIDragCursor(col, row);
        this.repaint();
    }

    protected void idragCancelled() {
        this.killIDragCursor();
        this.killInfomask();
    }

    protected synchronized void idragDropped(DropTargetDropEvent e) {
        int dc = this.getIDragCursorLogicalIndex();
        this.killIDragCursor();
        this.killInfomask();
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(this.getUniqueInternalReorderFlavor())) {
            e.acceptDrop(e.getDropAction());
            int index = -1;
            try {
                index = (Integer)t.getTransferData(this.getUniqueInternalReorderFlavor());
                this.reorder(index, dc);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            e.dropComplete(index != -1);
            return;
        }
        if (this.diplomat == null) {
            e.rejectDrop();
        } else {
            DataFlavor[] dataFlavorArray = this.diplomat.getSupportedDropFlavors();
            int n = dataFlavorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor d = dataFlavorArray[n2];
                if (t.isDataFlavorSupported(d)) {
                    block12: {
                        e.acceptDrop(e.getDropAction());
                        try {
                            this.diplomat.drop(t.getTransferData(d), d, dc + this.getMatrixOffset());
                            e.dropComplete(true);
                        }
                        catch (UnsupportedFlavorException exc) {
                            e.dropComplete(false);
                            if (this.dndErrorHandler == null) {
                                this.dndErrorHandler.errorInDrop(exc);
                            }
                        }
                        catch (IOException exc) {
                            e.dropComplete(false);
                            if (this.dndErrorHandler != null) break block12;
                            this.dndErrorHandler.errorInDrop(exc);
                        }
                    }
                    return;
                }
                ++n2;
            }
            e.rejectDrop();
        }
        e.dropComplete(false);
    }

    protected void mouseClicked(int x, int y, int buttons, int modifiers) {
        int tileIndex = this.getFilledMatrixIndex(this.getTileIndex(x, y));
        this.setSelected(tileIndex);
    }

    protected void mouseUpdate(int x, int y, int modifiers) {
        int tileIndex = this.getFilledMatrixIndex(this.getTileIndex(x, y));
        this.setInfomask(tileIndex);
    }

    protected void mouseLeave() {
        this.killInfomask();
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        boolean actionDown = (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
        Enum dir = null;
        switch (e.getKeyCode()) {
            case 38: {
                if (actionDown) {
                    this.shiftRows(-1);
                    break;
                }
                dir = Direction2D.Up;
                break;
            }
            case 40: {
                if (actionDown) {
                    this.shiftRows(1);
                    break;
                }
                dir = Direction2D.Down;
                break;
            }
            case 37: {
                dir = Direction2D.Left;
                break;
            }
            case 39: {
                dir = Direction2D.Right;
                break;
            }
            case 9: {
                dir = Direction2D.Right;
                break;
            }
            case 8: 
            case 127: {
                if (!this.hasSelection()) break;
                this.delete(this.getSelectedImageIndex());
                break;
            }
            default: {
                return;
            }
        }
        e.consume();
        if (dir != null) {
            if (this.hasSelection()) {
                this.moveSelected((Direction2D)((Object)dir));
            } else {
                this.setSelected(0);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected class Sedragdata
    implements Transferable {
        protected int index;
        protected BufferedImage image;
        protected DataFlavor[] flavors;
        protected Hashtable<DataFlavor, Object> cache;

        public Sedragdata(int i, BufferedImage img) {
            this.index = i;
            this.image = img;
            DataFlavor[] dipd = Sedpane.this.getDnDiplomat().getSupportedDragFlavors();
            this.flavors = new DataFlavor[dipd.length + 1];
            System.arraycopy(dipd, 0, this.flavors, 0, dipd.length);
            this.flavors[dipd.length] = Sedpane.this.getUniqueInternalReorderFlavor();
            if (Sedpane.this.getDnDiplomat().isDragDataCachingAllowed()) {
                this.cache = new Hashtable();
            }
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] dataFlavorArray = this.flavors;
            int n = this.flavors.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor f = dataFlavorArray[n2];
                if (f.equals(flavor)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (Sedpane.this.getUniqueInternalReorderFlavor().equals(flavor)) {
                return this.index;
            }
            if (this.cache != null) {
                if (this.cache.containsKey(flavor)) {
                    return this.cache.get(flavor);
                }
                Object d = Sedpane.this.getDnDiplomat().getDragData(flavor, this.index, this.image);
                this.cache.put(flavor, d);
                return d;
            }
            return Sedpane.this.getDnDiplomat().getDragData(flavor, this.index, this.image);
        }
    }
}

