/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui.edos;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rebound.hci.graphics2d.gui.awt.components.ImageFormatDropDown;
import rebound.hci.graphics2d.gui.awt.components.JFileChooserWrapper;
import rebound.hci.graphics2d.gui.awt.components.LatentFileBox;
import rebound.jagent.ui.gui.edos.EdosWindow;
import rebound.text.CharacterPredicates;
import rebound.text.IndependentCursor;
import rebound.text.StringUtilities;

public class ExportContactSheetDialog
extends JFrame {
    protected EdosWindow callback;
    protected JPanel pane;
    protected ImageFormatDropDown formatBox;
    protected LatentFileBox fileBox;
    protected JTextField dimensionsField;
    protected JLabel statusLabel;
    protected JButton submitButton;
    protected JButton cancelButton;
    protected Color infoStatusColor;
    protected Color errorStatusColor;

    public ExportContactSheetDialog() {
        super("Export Contact Sheet");
        this.setSize(300, 139);
        this.setContentPane(this.getPane());
        this.setDefaultCloseOperation(1);
        this.setResizable(true);
    }

    public JPanel getPane() {
        if (this.pane == null) {
            this.pane = new JPanel(){

                @Override
                public void doLayout() {
                    super.doLayout();
                    int width = this.getWidth();
                    int height = this.getHeight();
                    int emptySpace = height - 116;
                    int cancelWidth = width / 2;
                    int submitWidth = width - cancelWidth;
                    ExportContactSheetDialog.this.getFormatBox().setLocation(0, 0);
                    ExportContactSheetDialog.this.getFormatBox().setSize(width, 20);
                    ExportContactSheetDialog.this.getFileBox().setLocation(0, 20);
                    ExportContactSheetDialog.this.getFileBox().setSize(width, 28);
                    ExportContactSheetDialog.this.getDimensionsField().setLocation(0, 48);
                    ExportContactSheetDialog.this.getDimensionsField().setSize(width, 20);
                    ExportContactSheetDialog.this.getSubmitButton().setLocation(0, 68);
                    ExportContactSheetDialog.this.getSubmitButton().setSize(submitWidth, 28);
                    ExportContactSheetDialog.this.getCancelButton().setLocation(submitWidth, 68);
                    ExportContactSheetDialog.this.getCancelButton().setSize(cancelWidth, 28);
                    ExportContactSheetDialog.this.getStatusLabel().setLocation(0, 96 + emptySpace);
                    ExportContactSheetDialog.this.getStatusLabel().setSize(width, 20);
                }
            };
            this.pane.add(this.getFormatBox());
            this.pane.add(this.getFileBox());
            this.pane.add(this.getDimensionsField());
            this.pane.add(this.getSubmitButton());
            this.pane.add(this.getCancelButton());
            this.pane.add(this.getStatusLabel());
        }
        return this.pane;
    }

    public ImageFormatDropDown getFormatBox() {
        if (this.formatBox == null) {
            this.formatBox = new ImageFormatDropDown();
            this.formatBox.populateProviders(ImageFormatDropDown.Parity.WRITER);
        }
        return this.formatBox;
    }

    public LatentFileBox getFileBox() {
        if (this.fileBox == null) {
            JFileChooser jfc = new JFileChooser();
            jfc.setFileSelectionMode(0);
            JFileChooserWrapper wrapper = new JFileChooserWrapper(jfc);
            wrapper.setDisplayType(JFileChooserWrapper.JFileChooserDisplayType.CUSTOM);
            wrapper.setCustomApproveButtonText("Choose");
            this.fileBox = new LatentFileBox();
            this.fileBox.setDefaultText("Choose a destination file.");
            this.fileBox.setFileChooser(wrapper);
        }
        return this.fileBox;
    }

    public JTextField getDimensionsField() {
        if (this.dimensionsField == null) {
            this.dimensionsField = new JTextField();
        }
        return this.dimensionsField;
    }

    public JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setText("Pick a format, folder, and filename.");
            this.infoStatusColor = this.statusLabel.getForeground();
            this.errorStatusColor = Color.red.darker();
        }
        return this.statusLabel;
    }

    public JButton getSubmitButton() {
        if (this.submitButton == null) {
            this.submitButton = new JButton();
            this.submitButton.setText("Save Set");
            this.submitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportContactSheetDialog.this.submitButtonClicked();
                }
            });
        }
        return this.submitButton;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportContactSheetDialog.this.cancelClicked();
                }
            });
        }
        return this.cancelButton;
    }

    public void setStatusText(String text) {
        this.getStatusLabel().setForeground(this.infoStatusColor);
        this.getStatusLabel().setText(text);
        this.getCallback().setStatusText(text);
    }

    public void setErrorText(String text) {
        this.getStatusLabel().setForeground(this.errorStatusColor);
        this.getStatusLabel().setText(text);
    }

    public void display() {
        this.getFileBox().setSelectedFile(null);
        this.getDimensionsField().setText(String.valueOf(this.getCallback().getColumnCount()) + "x" + this.getCallback().getRowCount());
        this.setVisible(true);
        this.getDimensionsField().requestFocusInWindow();
        this.getDimensionsField().selectAll();
    }

    public void cancelClicked() {
        this.setVisible(false);
    }

    public void submitButtonClicked() {
        this.submit();
    }

    public void submit() {
        ImageWriterSpi spi = this.getFormatBox().getSelectedWriterSpi();
        if (spi == null) {
            if (this.getFormatBox().getSelectedObjects().length == 0) {
                this.getFormatBox().populateProviders(ImageFormatDropDown.Parity.WRITER);
                if (this.getFormatBox().getSelectedObjects().length == 0) {
                    this.setErrorText("(ErrCode: XIW) Uh oh. There are no ImageWriters installed on your system.");
                    return;
                }
                return;
            }
            this.setErrorText("You need to choose an image format.");
            return;
        }
        File file = this.getFileBox().getSelectedFile();
        if (file == null) {
            this.setErrorText("You must choose a file to save the sheet in.");
            return;
        }
        if (file.exists()) {
            int choice = JOptionPane.showConfirmDialog(null, String.valueOf(file.getName()) + " already exists, do you want to replace it?", "Overwrite", 0, 3);
            if (choice != 0) {
                return;
            }
        } else {
            boolean badExt = false;
            String[] exts = spi.getFileSuffixes();
            if (exts.length > 0) {
                badExt = true;
                String[] stringArray = exts;
                int n = exts.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    if (file.getName().toLowerCase().endsWith(ext.toLowerCase())) {
                        badExt = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (badExt) {
                this.setStatusText(String.valueOf(spi.getFileSuffixes()[0]) + " is a conventional filename suffix.");
            }
        }
        int cols = 0;
        int rows = 0;
        String raw = this.getDimensionsField().getText();
        char[] data = raw.toCharArray();
        boolean wildcardCols = false;
        boolean wildcardRows = false;
        IndependentCursor cursor = new IndependentCursor();
        while (cursor.getCursor() < data.length && data[cursor.getCursor()] != '*' && !CharacterPredicates.isDigit(data[cursor.getCursor()], 10)) {
            cursor.setCursor(cursor.getCursor() + 1);
        }
        if (cursor.getCursor() < data.length) {
            if (data[cursor.getCursor()] == '*') {
                wildcardCols = true;
                cursor.setCursor(1);
            } else {
                cols = (int)StringUtilities.parseBasicNumber(data, 0, data.length, cursor, 10);
            }
        }
        while (cursor.getCursor() < data.length && data[cursor.getCursor()] != '*' && !CharacterPredicates.isDigit(data[cursor.getCursor()], 10)) {
            cursor.setCursor(cursor.getCursor() + 1);
        }
        if (cursor.getCursor() < data.length) {
            if (data[cursor.getCursor()] == '*') {
                wildcardRows = true;
            } else {
                rows = (int)StringUtilities.parseBasicNumber(data, 0, data.length, cursor, 10);
            }
        }
        int total = this.getCallback().getFrameCount();
        if (wildcardCols && wildcardRows) {
            this.setErrorText("You can't set both to *");
            return;
        }
        if (wildcardCols || wildcardRows) {
            if (wildcardCols) {
                if (rows != 0) {
                    cols = total / rows;
                }
            } else if (cols != 0) {
                rows = total / cols;
            }
        }
        if (cols == 0 || rows == 0) {
            this.setErrorText("You must specify the dimensions in the format WxH");
            return;
        }
        if (cols * rows != total) {
            this.setErrorText(String.valueOf(cols) + "x" + rows + " doesn't make a grid of " + total + " frames.");
            return;
        }
        this.setVisible(false);
        this.getCallback().exportContactSheetCallback(file, cols, rows, spi);
    }

    public EdosWindow getCallback() {
        return this.callback;
    }

    public void setCallback(EdosWindow callback) {
        this.callback = callback;
    }
}

