/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import rebound.jagent.ResourceHog;

public class AboutDialog
extends JFrame {
    public static final String DEFAULT_TITLE = "About";
    public static final int DEFAULT_WIDTH = 800;
    public static final int DEFAULT_HEIGHT = 495;
    protected String resource;
    protected JPanel pane;
    protected JScrollPane scrollPane;
    protected JEditorPane mediaPane;
    protected JButton closeButton;

    public AboutDialog(String resource) {
        this.setResource(resource);
        this.setSize(800, 495);
        this.setContentPane(this.getPane());
        this.setDefaultCloseOperation(1);
        this.setResizable(true);
    }

    public JPanel getPane() {
        if (this.pane == null) {
            this.pane = new JPanel(){

                @Override
                public void doLayout() {
                    super.doLayout();
                    float buttonWidthRatio = 0.33333334f;
                    int buttonHeight = 28;
                    int width = this.getWidth();
                    int height = this.getHeight();
                    int buttonWidth = (int)((float)width * buttonWidthRatio);
                    int buttonPadding = (width - buttonWidth) / 2;
                    AboutDialog.this.getScrollPane().setLocation(0, 0);
                    AboutDialog.this.getScrollPane().setSize(width, height - buttonHeight);
                    AboutDialog.this.getCloseButton().setLocation(buttonPadding, height - buttonHeight);
                    AboutDialog.this.getCloseButton().setSize(buttonWidth, buttonHeight);
                }
            };
            this.pane.add(this.getScrollPane());
            this.pane.add(this.getCloseButton());
        }
        return this.pane;
    }

    public JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getMediaPane());
        }
        return this.scrollPane;
    }

    public JEditorPane getMediaPane() {
        if (this.mediaPane == null) {
            this.mediaPane = new JEditorPane();
            this.mediaPane.setEditable(false);
            final JEditorPane _mp = this.mediaPane;
            this.mediaPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if ("mailto".equalsIgnoreCase(e.getURL().getProtocol())) {
                            if (Desktop.isDesktopSupported()) {
                                try {
                                    Desktop.getDesktop().mail(e.getURL().toURI());
                                }
                                catch (IOException iOException) {
                                }
                                catch (URISyntaxException uRISyntaxException) {}
                            }
                        } else {
                            try {
                                _mp.setPage(e.getURL());
                            }
                            catch (IOException exc) {
                                AboutDialog.this.setPageToIOError(exc);
                            }
                        }
                    }
                }
            });
            URL contentURL = this.getContentURL();
            if (contentURL == null) {
                this.setPageTo404(this.getResource());
            } else {
                this.mediaPane.setContentType("text/html");
                try {
                    this.mediaPane.setPage(contentURL);
                }
                catch (IOException exc) {
                    this.setPageToIOError(exc);
                }
            }
        }
        return this.mediaPane;
    }

    public void setPageTo404(String charge) {
        this.mediaPane.setContentType("text/html");
        this.mediaPane.setText("<html>\t<body bgcolor=\"#800000\">\t\t<center>\t\t\t<h1>\t\t\t\t<font color=\"#FFFF00\">\t\t\t\t\tCould not locate required resource <tt>" + charge + "</tt>" + "\t\t\t\t</font>" + "\t\t\t</h1>" + "\t\t</center>" + "\t</body>" + "</html>");
    }

    public void setPageToIOError(IOException exc) {
        this.mediaPane.setContentType("text/html");
        this.mediaPane.setText("<html>\t<body bgcolor=\"#800000\">\t\t<center>\t\t\t<h1>\t\t\t\t<font color=\"#FFFF00\">\t\t\t\t\tIO Error loading required resource <tt>" + this.getResource() + "</tt>: " + exc.getMessage() + "\t\t\t\t</font>" + "\t\t\t</h1>" + "\t\t</center>" + "\t</body>" + "</html>");
    }

    public JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutDialog.this.closeButtonClicked();
                }
            });
        }
        return this.closeButton;
    }

    public URL getContentURL() {
        return ResourceHog.getResource(this.getResource());
    }

    public void closeButtonClicked() {
        this.setVisible(false);
    }

    public void display() {
        this.setVisible(true);
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

