/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.s16;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import rebound.bits.Bytes;
import rebound.bits.Endianness;
import rebound.hci.graphics2d.ImageUtilities;
import rebound.io.iio.RandomAccessBytes;
import rebound.io.iio.sio.RandomAccessFileWrapper;
import rebound.jagent.lib.FormatMismatchException;
import rebound.jagent.lib.s16.DataMap;
import rebound.jagent.lib.s16.ToS16Notifee;

public class ToS16Converter {
    protected boolean bits565 = false;
    protected ToS16Notifee notifee;
    protected BufferedImage[] frames;

    public void write(File path) throws IOException, FormatMismatchException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RandomAccessFileWrapper file = new RandomAccessFileWrapper(new RandomAccessFile(path, "rw"));){
            this.write(file);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void write(RandomAccessBytes file) throws IOException, FormatMismatchException {
        this.normalizeImages();
        if (this.notifee != null) {
            this.notifee.startS16Writing();
        }
        DataMap map = new DataMap();
        file.setLength(0L);
        this.writeImageDatii(file, map);
        file.seek(0L);
        this.writeHeaders(file, map);
    }

    protected void writeHeaders(RandomAccessBytes file, DataMap map) throws IOException, FormatMismatchException {
        if (this.frames.length >= 65536) {
            throw new FormatMismatchException("Too many frames (" + this.frames.length + ") to store in an S16 (max: 65535 or 32767)");
        }
        int flags = 0;
        if (this.bits565) {
            flags |= 1;
        }
        Bytes.putLittleInt(file, flags);
        Bytes.putLittleShort(file, (short)this.frames.length);
        int i = 0;
        while (i < this.frames.length) {
            this.writeFrameHeader(file, i, map);
            ++i;
        }
    }

    protected void writeFrameHeader(RandomAccessBytes file, int frameIndex, DataMap map) throws IOException, FormatMismatchException {
        int width = this.frames[frameIndex].getWidth();
        int height = this.frames[frameIndex].getHeight();
        if (width >= 65536) {
            throw new FormatMismatchException("Image is too wide (" + width + ") to store in an S16 (max: 65535 or 32767)");
        }
        if (height >= 65536) {
            throw new FormatMismatchException("Image is too tall (" + height + ") to store in an S16 (max: 65535 or 32767)");
        }
        int offset0 = map.offsets[frameIndex];
        Bytes.putLittleInt(file, offset0);
        Bytes.putLittleShort(file, (short)width);
        Bytes.putLittleShort(file, (short)height);
    }

    protected void calculateHeaderLen(DataMap map) {
        map.headersLength = 4;
        map.headersLength += 2;
        int i = 0;
        while (i < this.frames.length) {
            map.headersLength += 4;
            map.headersLength += 2;
            map.headersLength += 2;
            ++i;
        }
    }

    protected void writeImageDatii(RandomAccessBytes file, DataMap map) throws IOException {
        this.calculateHeaderLen(map);
        file.seek(map.headersLength);
        map.offsets = new int[this.frames.length];
        int i = 0;
        while (i < this.frames.length) {
            this.writeImageData(file, i, map);
            if (this.notifee != null) {
                this.notifee.finS16WritingFrame(i, this.frames.length);
            }
            ++i;
        }
        if (this.notifee != null) {
            this.notifee.finS16Writing();
        }
    }

    protected void writeImageData(RandomAccessBytes file, int frameIndex, DataMap map) throws IOException {
        map.offsets[frameIndex] = (int)file.getFilePointer();
        byte[] rawImageData = ImageUtilities.extractRawImageData_5X5_bytes(this.frames[frameIndex], this.bits565, Endianness.Little);
        file.write(rawImageData);
    }

    protected void normalizeImages() {
        ColorConvertOp converter = new ColorConvertOp(ColorSpace.getInstance(1000), null);
        BufferedImage dest = null;
        BufferedImage src = null;
        if (this.notifee != null) {
            this.notifee.startS16PreConverting();
        }
        int i = 0;
        while (i < this.frames.length) {
            if (!this.isImageOnRightMode(this.frames[i]) || src.getRaster().getDataBuffer().getOffset() != 0) {
                src = this.frames[i];
                dest = new BufferedImage(src.getWidth(), src.getHeight(), this.isBits565() ? 8 : 9);
                converter.filter(src, dest);
                this.frames[i] = dest;
                if (this.notifee != null) {
                    this.notifee.finS16PreConvertingFrame(i, this.frames.length);
                }
            }
            ++i;
        }
        if (this.notifee != null) {
            this.notifee.finS16PreConverting();
        }
    }

    protected boolean isImageOnRightMode(BufferedImage img) {
        return this.bits565 && img.getType() == 8 || !this.bits565 && img.getType() == 9;
    }

    public boolean isBits565() {
        return this.bits565;
    }

    public void setBits565(boolean bits565) {
        this.bits565 = bits565;
    }

    public void setFrames(BufferedImage[] frames) {
        this.frames = (BufferedImage[])frames.clone();
    }

    public ToS16Notifee getNotifee() {
        return this.notifee;
    }

    public void setNotifee(ToS16Notifee notifee) {
        this.notifee = notifee;
    }
}

