/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.s16;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import rebound.bits.Bytes;
import rebound.bits.Endianness;
import rebound.bits.Unsigned;
import rebound.hci.graphics2d.ImageUtilities;
import rebound.io.iio.RandomAccessBytes;
import rebound.io.iio.sio.RandomAccessFileWrapper;
import rebound.io.util.BasicIOUtilities;
import rebound.jagent.lib.FormatMismatchException;
import rebound.jagent.lib.s16.DataMap;
import rebound.jagent.lib.s16.FromS16Notifee;

public class FromS16Converter {
    protected Color alphaColor = Color.BLACK;
    protected boolean bits565;
    protected BufferedImage[] frames;
    protected FromS16Notifee notifee;

    public void read(File path) throws IOException, FormatMismatchException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RandomAccessFileWrapper file = new RandomAccessFileWrapper(new RandomAccessFile(path, "r"));){
            this.read(file);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void read(RandomAccessBytes file) throws IOException, FormatMismatchException {
        DataMap map = new DataMap();
        if (this.notifee != null) {
            this.notifee.startS16Reading();
        }
        this.readHeaders(file, map);
        this.readImageDatii(file, map);
        if (this.notifee != null) {
            this.notifee.finS16Reading();
        }
    }

    protected void readHeaders(RandomAccessBytes file, DataMap map) throws IOException, FormatMismatchException {
        int flags = Bytes.getLittleInt(file);
        boolean bl = this.bits565 = (flags & 1) != 0;
        if ((flags & 2) != 0) {
            throw new FormatMismatchException("Attempting to read (what looks like) a C16 file, when expecting an S16");
        }
        int count = Unsigned.upcast(Bytes.getLittleShort(file));
        map.offsets = new int[count];
        map.widths = new int[count];
        map.heights = new int[count];
        this.frames = new BufferedImage[count];
        int i = 0;
        while (i < count) {
            this.readHeader(file, map, i);
            ++i;
        }
    }

    protected void readHeader(RandomAccessBytes file, DataMap map, int index) throws IOException {
        int offset = Bytes.getLittleInt(file);
        int width = Unsigned.upcast(Bytes.getLittleShort(file));
        int height = Unsigned.upcast(Bytes.getLittleShort(file));
        map.offsets[index] = offset;
        map.widths[index] = width;
        map.heights[index] = height;
    }

    protected void readImageDatii(RandomAccessBytes file, DataMap map) throws IOException, FormatMismatchException {
        int i = 0;
        while (i < this.frames.length) {
            this.readImageData(file, map, i);
            if (this.notifee != null) {
                this.notifee.finS16ReadingFrame(i, this.frames.length);
            }
            ++i;
        }
    }

    protected void readImageData(RandomAccessBytes file, DataMap map, int index) throws IOException, FormatMismatchException {
        boolean is565 = this.bits565;
        int width = map.widths[index];
        int height = map.heights[index];
        byte[] imagedata = null;
        int imageDataLength = 2 * width * height;
        int offset = map.offsets[index];
        if ((long)(imageDataLength + offset) > file.length()) {
            throw new FormatMismatchException("S16 File appears to be truncated at image " + index);
        }
        file.seek(offset);
        imagedata = new byte[imageDataLength];
        BasicIOUtilities.readFully(file, imagedata);
        this.frames[index] = ImageUtilities.wrapRawImageData_5X5_bytes(width, height, imagedata, 0, imagedata.length, is565, Endianness.Little);
        if (this.getAlphaColor() != null) {
            this.frames[index] = ImageUtilities.colorToAlpha(this.frames[index], this.getAlphaColor().getRGB());
        }
    }

    public FromS16Notifee getNotifee() {
        return this.notifee;
    }

    public void setNotifee(FromS16Notifee notifee) {
        this.notifee = notifee;
    }

    public boolean isBits565() {
        return this.bits565;
    }

    public BufferedImage[] getFrames() {
        return this.frames;
    }

    public Color getAlphaColor() {
        return this.alphaColor;
    }

    public void setAlphaColor(Color alphaColor) {
        this.alphaColor = alphaColor;
    }
}

