/*
 * Decompiled with CFR 0.152.
 */
package rebound.io.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import rebound.bits.Unsigned;
import rebound.exceptions.BinarySyntaxIOException;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.NotYetImplementedException;
import rebound.io.util.JRECompatIOUtilities;
import rebound.text.StringUtilities;
import rebound.util.BufferAllocationType;
import rebound.util.PlatformNIOBufferUtilities;
import rebound.util.ProgressObserver;
import rebound.util.objectutil.JavaNamespace;

public class ExtraIOUtilities
implements JavaNamespace {
    public static final SynchronousConsumer CONSUMER_COMPARISON = new SynchronousConsumer(){

        @Override
        public Object eofReached(boolean a, boolean b) {
            if (a && b) {
                return true;
            }
            return false;
        }

        @Override
        public Object consume(byte[] bufferA, byte[] bufferB, int offset, int length) {
            int stop = offset + length;
            int index = offset;
            while (index < stop) {
                if (bufferA[index] != bufferB[index]) {
                    return false;
                }
                ++index;
            }
            return null;
        }
    };
    public static final boolean READ = false;
    public static final boolean WRITE = true;

    public static Object consumeInSync(InputStream a, InputStream b, SynchronousConsumer consumer, int bufferSize) throws IOException {
        byte[] bufferA = new byte[bufferSize];
        byte[] bufferB = new byte[bufferSize];
        int fillA = 0;
        int fillB = 0;
        int offset = 0;
        int length = 0;
        Object rv = null;
        while (true) {
            if (fillA == 0 && fillB == 0) {
                fillA = a.read(bufferA, 0, bufferSize);
                fillB = b.read(bufferB, 0, bufferSize);
                offset = 0;
            } else if (fillA == 0) {
                fillA = a.read(bufferA, offset, fillB);
                if (fillA > fillB) {
                    throw new IllegalStateException("InputStream " + a + " read more bytes (" + fillA + ") than was requested (" + fillB + ")");
                }
            } else {
                fillB = b.read(bufferB, offset, fillA);
                if (fillB > fillA) {
                    throw new IllegalStateException("InputStream " + b + " read more bytes (" + fillB + ") than was requested (" + fillA + ")");
                }
            }
            if (fillA < 0 || fillB < 0) {
                return consumer.eofReached(fillA < 0, fillB < 0);
            }
            length = fillA < fillB ? fillA : fillB;
            rv = consumer.consume(bufferA, bufferB, offset, length);
            if (rv != null) {
                return rv;
            }
            offset += length;
            fillA -= length;
            fillB -= length;
        }
    }

    public static Object readObjectThrowingSyntaxExceptionInsteadOfClassNotFoundException(ObjectInputStream oin) throws IOException, BinarySyntaxIOException {
        try {
            return oin.readObject();
        }
        catch (ClassNotFoundException exc) {
            throw BinarySyntaxIOException.inst("Available class file mismatch; ClassNotFoundException on deserialization: " + StringUtilities.repr(exc.getMessage()));
        }
    }

    public static int forceReadNIO(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int amount = 0;
        while (buffer.hasRemaining()) {
            int amt = channel.read(buffer);
            if (amt == -1) break;
            amount += amt;
        }
        return amount;
    }

    public static int forceWriteNIO(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        int amount = 0;
        while (buffer.hasRemaining()) {
            int amt = channel.write(buffer);
            if (amt == -1) break;
            amount += amt;
        }
        return amount;
    }

    public static int forceIO(Object channel, ByteBuffer buffer, boolean direction) throws IOException {
        if (!direction) {
            return ExtraIOUtilities.forceReadNIO((ReadableByteChannel)channel, buffer);
        }
        return ExtraIOUtilities.forceWriteNIO((WritableByteChannel)channel, buffer);
    }

    public static void enforceReadNIO(ReadableByteChannel channel, ByteBuffer buffer) throws IOException, EOFException {
        int originalAmount = buffer.remaining();
        int readAmount = ExtraIOUtilities.forceReadNIO(channel, buffer);
        if (readAmount < originalAmount) {
            throw new EOFException();
        }
    }

    public static void enforceWriteNIO(WritableByteChannel channel, ByteBuffer buffer) throws IOException, EOFException {
        int originalAmount = buffer.remaining();
        int readAmount = ExtraIOUtilities.forceWriteNIO(channel, buffer);
        if (readAmount < originalAmount) {
            throw new EOFException();
        }
    }

    public static void enforceIO(Object channel, ByteBuffer buffer, boolean direction) throws IOException, EOFException {
        int originalAmount = buffer.remaining();
        int readAmount = ExtraIOUtilities.forceIO(channel, buffer, direction);
        if (readAmount < originalAmount) {
            throw new EOFException();
        }
    }

    public static ByteChannel decorateDirectOnlyByteChannelForNondirectCopying(ByteChannel rwChannel) {
        return ExtraIOUtilities.decorateDirectOnlyByteChannelForNondirectCopying(rwChannel, -1);
    }

    public static ByteChannel decorateDirectOnlyByteChannelForNondirectCopying(final ByteChannel rwChannel, int bufferSize) {
        return new ByteChannel(){

            public int io(boolean direction, ByteBuffer buffer) throws IOException {
                if (!rwChannel.isOpen()) {
                    throw new IOException("It's closed, yo!");
                }
                throw new NotYetImplementedException();
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return this.io(false, dst);
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return this.io(true, src);
            }

            @Override
            public boolean isOpen() {
                return rwChannel.isOpen();
            }

            @Override
            public void close() throws IOException {
                rwChannel.close();
            }
        };
    }

    public static ByteBuffer readAllToNIOBuffer(InputStream in, BufferAllocationType bufferAllocationType) throws IOException {
        byte[] all = JRECompatIOUtilities.readAll(in);
        ByteBuffer buffer = PlatformNIOBufferUtilities.allocateByteBuffer(all.length, bufferAllocationType);
        buffer.put(all);
        buffer.position(0);
        return buffer;
    }

    public static void readFully(InputStream in, byte[] buff, ProgressObserver progressObserver) throws EOFException, IOException {
        if (progressObserver == null) {
            JRECompatIOUtilities.readFully(in, buff);
        } else {
            ExtraIOUtilities.readFully(in, buff, 0, buff.length, progressObserver);
        }
    }

    public static void readFully(InputStream in, byte[] buff, int offset, int len, ProgressObserver progressObserver) throws EOFException, IOException {
        if (progressObserver != null) {
            progressObserver.update(0.0);
            int read = 0;
            int r = 0;
            int l = 0;
            while (true) {
                if ((l = len - read) > 65536) {
                    l = 65536;
                }
                if ((r = in.read(buff, offset + read, l)) < 0) {
                    throw new EOFException("Premature EOF");
                }
                if ((read += r) >= len) {
                    progressObserver.update(1.0);
                    return;
                }
                progressObserver.update((double)read / (double)len);
            }
        }
        JRECompatIOUtilities.readFully(in, buff, offset, len);
    }

    public static interface HappyByteChannel
    extends ByteChannel {
        public boolean supportsDirection(boolean var1);

        public boolean willHaveToCopyForNondirectBuffers(boolean var1);

        public int io(boolean var1, ByteBuffer var2) throws IOException;

        public int io(boolean var1, byte[] var2, int var3, int var4) throws IOException;

        public int io(boolean var1, HappyByteChannel var2, int var3) throws IOException;

        public int io(boolean var1, ReadableByteChannel var2, int var3) throws IOException;

        public int io(boolean var1, WritableByteChannel var2, int var3) throws IOException;

        public int io(boolean var1, ByteChannel var2, int var3) throws IOException;

        public int io(boolean var1, InputStream var2, int var3) throws IOException;

        public int io(boolean var1, OutputStream var2, int var3) throws IOException;

        public int skip(int var1);

        public int writesame(byte var1, int var2);
    }

    public static class IODirectionNotSupportedException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }

    public static class InputStreamChannelAdapter
    extends InputStream
    implements ReadableByteChannel {
        protected ReadableByteChannel underlying;
        protected ByteBuffer copyBuffer;
        protected ByteBuffer lastWrappedBuffer;

        public InputStreamChannelAdapter(ReadableByteChannel underlying, ByteBuffer copyBuffer) {
            this.underlying = underlying;
            this.copyBuffer = copyBuffer;
        }

        protected int readAtLeastOne(ByteBuffer buffer) throws IOException {
            int amt;
            do {
                if ((amt = this.underlying.read(buffer)) != -1) continue;
                return -1;
            } while (amt == 0);
            return amt;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (!this.underlying.isOpen()) {
                throw new IOException("It's closed, yo!");
            }
            if (len == 0) {
                return 0;
            }
            if (!(this.lastWrappedBuffer != null && this.lastWrappedBuffer.array() == b || this.copyBuffer != null && b.length < 512)) {
                this.lastWrappedBuffer = ByteBuffer.wrap(b);
            }
            if (this.lastWrappedBuffer != null && this.lastWrappedBuffer.array() == b) {
                this.lastWrappedBuffer.position(off);
                this.lastWrappedBuffer.limit(off + len);
                return this.readAtLeastOne(this.lastWrappedBuffer);
            }
            if (this.copyBuffer == null) {
                throw new ImpossibleException("it should have been wrapped! ;_;");
            }
            this.copyBuffer.position(0);
            int maxAmount = Math.min(len, this.copyBuffer.capacity());
            this.copyBuffer.limit(maxAmount);
            int amountRead = this.readAtLeastOne(this.copyBuffer);
            if (amountRead == -1) {
                return -1;
            }
            this.copyBuffer.get(b, off, amountRead);
            return amountRead;
        }

        @Override
        public int read() throws IOException {
            this.copyBuffer.position(0);
            this.copyBuffer.limit(1);
            int amount = ExtraIOUtilities.forceReadNIO(this.underlying, this.copyBuffer);
            if (amount < 1) {
                return -1;
            }
            return Unsigned.upcast(this.copyBuffer.get());
        }

        @Override
        public long skip(long amountToSkip) throws IOException {
            long amountSoFar = 0L;
            while (amountSoFar < amountToSkip) {
                this.copyBuffer.position(0);
                if (amountToSkip - amountSoFar > Integer.MAX_VALUE) {
                    this.copyBuffer.limit(this.copyBuffer.remaining());
                } else {
                    this.copyBuffer.limit(Math.min(this.copyBuffer.remaining(), (int)(amountToSkip - amountSoFar)));
                }
                int amt = this.underlying.read(this.copyBuffer);
                if (amt == -1) {
                    return amountSoFar;
                }
                amountSoFar += (long)amt;
            }
            return amountSoFar;
        }

        @Override
        public boolean isOpen() {
            return this.underlying.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.underlying.close();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.underlying.read(dst);
        }
    }

    public static interface SynchronousConsumer {
        public Object consume(byte[] var1, byte[] var2, int var3, int var4);

        public Object eofReached(boolean var1, boolean var2);
    }
}

