/*
 * Decompiled with CFR 0.152.
 */
package rebound.io.ucs4;

import java.io.IOException;
import java.io.Reader;
import rebound.io.ucs4.AbstractUCS4Reader;
import rebound.io.ucs4.UTF16EncodingException;

public class UCS4ReaderFromNormalUTF16Reader
extends AbstractUCS4Reader {
    protected final Reader underlying;

    public UCS4ReaderFromNormalUTF16Reader(Reader underlying) {
        this.underlying = underlying;
    }

    @Override
    public int read(int[] cbuf, int off, int len) throws IOException {
        int m = off + len;
        int i = off;
        while (i < m) {
            long v = this.read();
            if (v == -1L) {
                if (i == off) {
                    return -1;
                }
                return i - off;
            }
            cbuf[i] = (int)v;
            ++i;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.underlying.close();
    }

    @Override
    public long read() throws IOException, UTF16EncodingException {
        int first = this.underlying.read();
        if (first == -1) {
            return -1L;
        }
        char firstC = (char)first;
        if (UCS4ReaderFromNormalUTF16Reader.isHighSurrogate(firstC)) {
            int second = this.underlying.read();
            if (second == -1) {
                throw new UTF16EncodingException("UTF-16 Decoding Error!!  High/Leading Surrogate followed by EOF!!");
            }
            char secondC = (char)second;
            if (UCS4ReaderFromNormalUTF16Reader.isLowSurrogate(secondC)) {
                int codePoint = UCS4ReaderFromNormalUTF16Reader.surrogatesToCodePoint(firstC, secondC);
                return codePoint;
            }
            throw new UTF16EncodingException("UTF-16 Decoding Error!!  High/Leading Surrogate followed by something other than a Low/Trailing Surrogate!!");
        }
        if (UCS4ReaderFromNormalUTF16Reader.isLowSurrogate(firstC)) {
            throw new UTF16EncodingException("UTF-16 Decoding Error!!  Low/Trailing Surrogate preceded by BOF or something other than a High/Leading Surrogate!!");
        }
        return first;
    }

    public static boolean isSurrogate(char c) {
        return (c & 0xF800) == 55296;
    }

    public static boolean isHighSurrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    public static boolean isLowSurrogate(char c) {
        return (c & 0xFC00) == 56320;
    }

    public static int surrogatesToCodePoint(char highSurrogate, char lowSurrogate) {
        int lowBits = lowSurrogate & 0x3FF;
        int highBits = highSurrogate & 0x3FF;
        return (lowBits | highBits << 10) + 65536;
    }
}

