/*
 * Decompiled with CFR 0.152.
 */
package rebound.hci.graphics2d.gui.awt.components;

import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.JComboBox;
import rebound.exceptions.NotYetImplementedException;

public class ImageFormatDropDown
extends JComboBox {
    private static final long serialVersionUID = 1L;
    protected ItemType itemtype;

    public void populateFormats(Parity readOrWrite) {
        String[] formatNames;
        super.removeAllItems();
        this.itemtype = ItemType.SPI;
        String[] stringArray = formatNames = readOrWrite == Parity.READER ? ImageIO.getReaderFormatNames() : ImageIO.getWriterFormatNames();
        int n = formatNames.length;
        int n2 = 0;
        while (n2 < n) {
            String formatName = stringArray[n2];
            FormatItem item = new FormatItem();
            item.setName(formatName);
            item.setReadOrWrite(readOrWrite);
            this.addItem(item);
            ++n2;
        }
    }

    public void populateProviders(Parity readOrWrite) {
        super.removeAllItems();
        this.itemtype = ItemType.SPI;
        Iterator<ImageReaderSpi> spis = IIORegistry.getDefaultInstance().getServiceProviders(readOrWrite == Parity.READER ? ImageReaderSpi.class : ImageWriterSpi.class, true);
        while (spis.hasNext()) {
            ImageReaderWriterSpi spi = spis.next();
            SpiItem item = new SpiItem();
            item.setSpi(spi);
            this.addItem(item);
        }
    }

    public ImageReaderSpi getSelectedReaderSpi() {
        Object selectedObject = this.getSelectedItem();
        if (selectedObject instanceof SpiItem) {
            SpiItem spiItem = (SpiItem)selectedObject;
            if (spiItem.getReadOrWrite() == Parity.WRITER) {
                return null;
            }
            ImageReaderSpi spi = (ImageReaderSpi)spiItem.getSpi();
            return spi;
        }
        if (selectedObject instanceof FormatItem) {
            throw new NotYetImplementedException();
        }
        throw new ClassCastException();
    }

    public ImageWriterSpi getSelectedWriterSpi() {
        Object selectedObject = this.getSelectedItem();
        if (selectedObject instanceof SpiItem) {
            SpiItem spiItem = (SpiItem)selectedObject;
            if (spiItem.getReadOrWrite() == Parity.READER) {
                return null;
            }
            ImageWriterSpi spi = (ImageWriterSpi)spiItem.getSpi();
            return spi;
        }
        if (selectedObject instanceof FormatItem) {
            throw new NotYetImplementedException();
        }
        throw new ClassCastException();
    }

    public ItemType getItemtype() {
        return this.itemtype;
    }

    public void setItemtype(ItemType itemtype) {
        this.itemtype = itemtype;
    }

    public class FormatItem {
        protected Parity readOrWrite;
        protected String name;

        public String toString() {
            return this.name;
        }

        public Parity getReadOrWrite() {
            return this.readOrWrite;
        }

        public void setReadOrWrite(Parity readOrWrite) {
            this.readOrWrite = readOrWrite;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum ItemType {
        FORMAT,
        SPI;

    }

    public static enum Parity {
        READER,
        WRITER;

    }

    public class SpiItem {
        protected ImageReaderWriterSpi spi;

        public Parity getReadOrWrite() {
            return this.spi instanceof ImageReaderSpi ? Parity.READER : Parity.WRITER;
        }

        public String toString() {
            return this.spi.getDescription(Locale.getDefault());
        }

        public ImageReaderWriterSpi getSpi() {
            return this.spi;
        }

        public void setSpi(ImageReaderWriterSpi spi) {
            this.spi = spi;
        }
    }
}

