/*
 * Decompiled with CFR 0.152.
 */
package rebound.hci.graphics2d.gui.awt.components;

import java.io.File;
import java.util.HashSet;
import javax.swing.filechooser.FileFilter;

public class ExtJFCFileFilter
extends FileFilter {
    protected HashSet<String> filters = new HashSet();
    protected String description = "";
    protected boolean caseInsensitive = false;

    public ExtJFCFileFilter() {
    }

    public ExtJFCFileFilter(String descriptionBase, String ... extensions) {
        this();
        this.caseInsensitive = true;
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            this.addExtension(ext);
            ++n2;
        }
        this.setBasicDescription(descriptionBase);
    }

    @Override
    public boolean accept(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        if (this.isCaseInsensitive()) {
            return this.filters.contains(ExtJFCFileFilter.getExtension(file).toLowerCase());
        }
        return this.filters.contains(ExtJFCFileFilter.getExtension(file));
    }

    private static String getExtension(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        int dotpos = name.lastIndexOf(46);
        if (dotpos == -1) {
            return "";
        }
        return name.substring(dotpos + 1);
    }

    public void makeCaseInsensitive() {
        this.caseInsensitive = true;
        if (!this.filters.isEmpty()) {
            HashSet<String> newfilters = new HashSet<String>();
            for (String withcase : this.filters) {
                newfilters.add(withcase.toLowerCase());
            }
        }
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void addExtension(String ext) {
        if (ext == null) {
            return;
        }
        if (this.isCaseInsensitive()) {
            this.filters.add(ext.toLowerCase());
        } else {
            this.filters.add(ext);
        }
    }

    public void removeExtension(String ext) {
        if (ext == null) {
            return;
        }
        if (this.isCaseInsensitive()) {
            this.filters.remove(ext.toLowerCase());
        } else {
            this.filters.remove(ext);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBasicDescription(String descriptionBase) {
        StringBuilder buff = new StringBuilder(descriptionBase);
        buff.append(" (");
        boolean first = true;
        for (String ext : this.filters) {
            if (first) {
                first = false;
            } else {
                buff.append(", ");
            }
            buff.append("*.");
            buff.append(ext);
        }
        buff.append(")");
        this.setDescription(buff.toString());
    }
}

