/*
 * Decompiled with CFR 0.152.
 */
package rebound.exceptions;

import rebound.exceptions.SyntaxException;
import rebound.exceptions.TextSyntaxCheckedException;

public class TextSyntaxException
extends SyntaxException {
    private static final long serialVersionUID = 1L;

    protected TextSyntaxException(String message, Throwable cause) {
        super(message, cause);
    }

    public static TextSyntaxException inst() {
        return new TextSyntaxException(null, null);
    }

    public static TextSyntaxException inst(String message) {
        return new TextSyntaxException(message, null);
    }

    public static TextSyntaxException inst(Throwable cause) {
        return new TextSyntaxException(null, cause);
    }

    public static TextSyntaxException inst(String message, Throwable cause) {
        return new TextSyntaxException(message, cause);
    }

    public static TextSyntaxException instCharPos(String message, long pos) {
        return new TextSyntaxException(String.valueOf(message) + "    At character: [" + pos + "]", null);
    }

    public static TextSyntaxException instLineNumber(String message, long lineNumber) {
        return new TextSyntaxException(String.valueOf(message) + "    At line: " + lineNumber, null);
    }

    public static TextSyntaxException instLineAndColumnNumber(String message, long lineNumber, long columnNumber) {
        return new TextSyntaxException(String.valueOf(message) + "    At line " + lineNumber + ", column " + columnNumber, null);
    }

    public TextSyntaxCheckedException toSyntaxCheckedException() {
        return TextSyntaxCheckedException.inst(this.getMessage(), this);
    }
}

