#include "colors.inc"    
//#version unofficial MegaPov 0.7;
#include "textures.inc" 
#include "metals.inc"   
#include "effects.inc"
#declare port_colour=Brown;
#include "edynn.inc"

light_source {<25,25,-25> colour rgb<1, 1, 1>}
camera{
location<0,1.5,-10>
look_at<0,1.5,0>}
global_settings { ambient_light rgb<4, 4, 4> }

////////////////////////////////////////

//texture for the round glass thing at the top
#declare swirly=
texture { 
    NBglass
    pigment { rgbf <0.1, 0.15, 0.3, 0.9> }
}

//the roof
#declare dome=       
union{
//roof
 difference{
  sphere{<0, 2.5, 0>,3 scale <1, 0.75, 1>}
  cylinder {<0, -1, 0>,<0, 2.5, 0>,3}
 }
//ports
 object{port_in
 	translate z*-3
	rotate x*7
	translate y*2.5
	rotate y*30
 }
 object{port_out
	translate z*-3
	rotate x*7
	translate y*2.5
	rotate y*-30
 }

//top spheres
 blob{        
 	threshold .15 
	#declare i = 0;
	#while (i <=359)
		sphere {<-2.8,-1.45,0>,.3,0.5  rotate y*i}
		sphere {<-2.8,2.45,0>,.3,0.5  rotate y*i}
		#declare i = i +10;
	#end
 }
//edge of circle thingy at top
 blob{
 	threshold .15
	#declare i = 0;
	#while (i <360)
		cylinder {< 0, -1.3, -2.8>, < 0, -0.5,  0.0>, .3, 0.5
			rotate z*i
			translate y*3.7
		}
		cylinder {< 0, -1.3, -2.8>, < 0,  0.0, -2.6>, .3, 0.5
			rotate <0, 0, i>
			translate y*3.7
		}
		cylinder {< 0, -1.2, -2.9>, < 0, -1.3, -2.8>, .3, 0.5
			rotate <0, 0, i>
			translate y*3.7
		}
		cylinder {< 0, -1.0, -3.1>, < 0, -1.4, -2.9>, .2, 0.5
			rotate <0, 0, i>
			translate y*3.7
		}
		#declare i = i +10;
	#end
 }
//glass part of circle
 sphere { <0, 3.7, 0.0>,1.25 
 	texture { swirly }
	scale <1, 1, 0.5>
	translate z*-2.8
 }
}

//main teleporter stuff
#declare frame=
union{
//walls
 #declare i = -130;
 #while (i <=130)
	cylinder {<0,-1.5, 2.4>, <0,2.5, 2.40>, .2 
		rotate <0,i, 0>
	}
	#declare i = i +10;
 #end
//base
 cylinder {< 0, -1.95, 0>, < 0, -1.45, 0>, 2.9}
//bottom brown thing
 cylinder {< 0, -1.40, 0>, < 0, -1.45, 0>, 2.0 
 	texture { Polished_Brass }
 }
//top brown thing
 cylinder {< 0,  2.45, 0>, < 0,  2.50, 0>, 2.0
 	texture { Polished_Brass }
 }
//teleportation thingy
 #declare i = -1.2;
 #while (i <=2.4)
 	light_source{<0,i,-0> color (sin(2*pi*clock)+0.01)}
	#declare i = i +0.2;
 #end
 cylinder {<0, -1.5, 0>,<0, 2.5, 0>, 2.0*sin(2*pi*clock)
 	texture {swirly}
 }
 cylinder {<0, -1.5, 0>,<0, 2.5, 0>, 1.9*sin(2*pi*clock)
 	texture { Shiny_Orb
		scale 0.15
		rotate y*(720*clock)
	}
 }
//the top part
 object {dome}

//main texture
 texture{ pigment{
 	bozo color_map {
		[0 rgb .4]
		[1 rgb .8]
	}
	scale .2
 }}

}

/////////////////////////////////////////////////////


///finally, we actually show the teleporter
object { frame 
//	rotate y*45
	translate <0,1.2,0>
	scale 0.78
}



