; This script is the edynn installer for windoze.
!define VERSION "build 8"

SetCompressor bzip2
; The name of the installer
Name "Edynn (${VERSION})"
Icon "..\edynn.ico"
; The file to write
OutFile "Edynn.exe"

; The default installation directory
InstallDir "$PROGRAMFILES\Edynn"
; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM "SOFTWARE\CyberLife Technology\Edynn"  "Main Directory"
;install types
InstType "Default"
InstType "Upgrade"

; The text to prompt the user to enter a directory
ComponentText "This will (hopefully) install the Edynn beta. Select the type of install, or which components you want installed."
; The text to prompt the user to enter a directory
DirText "Choose a directory to install to:"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; The stuff to install
Section "Edynn files"
  SectionIn 1 2
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
 ;lots of file stuff here
  File "..\edynn.*"
  File "..\*.cfg"
  File "..\*.txt"
 ;now for the dirs
 ;first, the ones that can be simply overwritten.
  File /r "..\Backgrounds"
  File /r "..\Body Data"
  File /r "..\Bootstrap"
  File /r "..\Catalogue"
  File /r "..\Genetics"
  File /r "..\Images"
  File /r "..\Overlay Data"
  File /r "..\Sounds"
  File /r "..\source"
 ;next, make empties
  CreateDirectory "$INSTDIR\Creature Galleries"
  CreateDirectory "$INSTDIR\Journal"
  CreateDirectory "$INSTDIR\My Agents"
  CreateDirectory "$INSTDIR\My Creatures"
  CreateDirectory "$INSTDIR\My Worlds"
  CreateDirectory "$INSTDIR\Users"
 ;now, put files into some of them (these are dirs where existing files should be kept)
  SetOutPath "$INSTDIR\Journal"
  File "..\Journal\P*"
  File "..\Journal\SKINS"
  SetOutPath "$INSTDIR\My Agents"
  File "..\My Agents\*.agen*"
  SetOutPath "$INSTDIR\My Creatures"
  File "..\My Creatures\*.ds.creature"

  SetOutPath $INSTDIR
;boring ending stuffs
  ; Write the installation path into the registry
  WriteRegStr HKLM "SOFTWARE\CyberLife Technology\Edynn" "Install_Dir" "$INSTDIR"
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Edynn" "DisplayName" "Edynn beta (remove only)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Edynn" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteUninstaller "uninstall.exe"
SectionEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;update machine.cfg with DS
Section "Update machine.cfg"
 SectionIn 1 2
;if DS isn't installed, we can let the engine handle this.
 ReadRegStr $0 HKLM "SOFTWARE\CyberLife Technology\Docking Station" "Main Directory"
 StrCmp $0 "" mSkip
;if it is installed, we have to put in a c3 entry, or a dummy.
;oh, and open the file...
;append mode is odd, so just overwrite the whole thing:
 FileOpen $9 "$INSTDIR\machine.cfg" w
 DetailPrint "DS detected. adding to machine.cfg"
 ;let's write the DS part first. (aux 2)
 ;FileWrite $9 "$\"Auxiliary 2 Main Directory$\" $\"$0$\"$\r$\n"
 ReadRegStr $2 HKLM "SOFTWARE\CyberLife Technology\Docking Station" "Backgrounds Directory"
 FileWrite $9 "$\"Auxiliary 2 Backgrounds Directory$\"  $\"$2$\"$\r$\n"
 ReadRegStr $2 HKLM "SOFTWARE\CyberLife Technology\Docking Station" "Body Data Directory"
 FileWrite $9 "$\"Auxiliary 2 Body Data Directory$\"  $\"$2$\"$\r$\n"
 ReadRegStr $2 HKLM "SOFTWARE\CyberLife Technology\Docking Station" "Bootstrap Directory"
 FileWrite $9 "$\"Auxiliary 2 Bootstrap Directory$\"  $\"$2$\"$\r$\n"
 ReadRegStr $2 HKLM "SOFTWARE\CyberLife Technology\Docking Station" "Catalogue Directory"
 FileWrite $9 "$\"Auxiliary 2 Catalogue Directory$\"  $\"$2$\"$\r$\n"
 ReadRegStr $2 HKLM "SOFTWARE\CyberLife Technology\Docking Station" "Exported Creatures Directory"
 FileWrite $9 "$\"Auxiliary 2 Exported Creatures Directory$\"  $\"$2$\"$\r$\n"
 ReadRegStr $2 HKLM "SOFTWARE\CyberLife Technology\Docking Station" "Genetics Directory"
 FileWrite $9 "$\"Auxiliary 2 Genetics Directory$\"  $\"$2$\"$\r$\n"
 ReadRegStr $2 HKLM "SOFTWARE\CyberLife Technology\Docking Station" "Images Directory"
 FileWrite $9 "$\"Auxiliary 2 Images Directory$\"  $\"$2$\"$\r$\n"
 ReadRegStr $2 HKLM "SOFTWARE\CyberLife Technology\Docking Station" "Overlay Data Directory"
 FileWrite $9 "$\"Auxiliary 2 Overlay Data Directory$\"  $\"$2$\"$\r$\n"
 ReadRegStr $2 HKLM "SOFTWARE\CyberLife Technology\Docking Station" "Resource Files Directory"
 FileWrite $9 "$\"Auxiliary 2 Resource Files Directory$\"  $\"$2$\"$\r$\n"
 ReadRegStr $2 HKLM "SOFTWARE\CyberLife Technology\Docking Station" "Sounds Directory"
 FileWrite $9 "$\"Auxiliary 2 Sounds Directory$\"  $\"$2$\"$\r$\n"
;phew. I think that's all of them
 
;now, see if c3 is here
 ReadRegStr $1 HKLM "SOFTWARE\CyberLife Technology\Creatures 3" "Main Directory"
 StrCmp $1 "" dummy
 ;if it exists... 
 DetailPrint "C3 detected. adding to machine.cfg"
;here we go...
 ReadRegStr $1 HKLM "SOFTWARE\CyberLife Technology\Creatures 3" "Backgrounds Directory"
 FileWrite $9 "$\"Auxiliary 1 Backgrounds Directory$\"  $\"$1$\"$\r$\n"
 ReadRegStr $1 HKLM "SOFTWARE\CyberLife Technology\Creatures 3" "Body Data Directory"
 FileWrite $9 "$\"Auxiliary 1 Body Data Directory$\"  $\"$1$\"$\r$\n"
 ReadRegStr $1 HKLM "SOFTWARE\CyberLife Technology\Creatures 3" "Bootstrap Directory"
 FileWrite $9 "$\"Auxiliary 1 Bootstrap Directory$\"  $\"$1$\"$\r$\n"
 ReadRegStr $1 HKLM "SOFTWARE\CyberLife Technology\Creatures 3" "Catalogue Directory"
 FileWrite $9 "$\"Auxiliary 1 Catalogue Directory$\"  $\"$1$\"$\r$\n"
 ReadRegStr $1 HKLM "SOFTWARE\CyberLife Technology\Creatures 3" "Exported Creatures Directory"
 FileWrite $9 "$\"Auxiliary 1 Exported Creatures Directory$\"  $\"$1$\"$\r$\n"
 ReadRegStr $1 HKLM "SOFTWARE\CyberLife Technology\Creatures 3" "Genetics Directory"
 FileWrite $9 "$\"Auxiliary 1 Genetics Directory$\"  $\"$1$\"$\r$\n"
 ReadRegStr $1 HKLM "SOFTWARE\CyberLife Technology\Creatures 3" "Images Directory"
 FileWrite $9 "$\"Auxiliary 1 Images Directory$\"  $\"$1$\"$\r$\n"
 ReadRegStr $1 HKLM "SOFTWARE\CyberLife Technology\Creatures 3" "Overlay Data Directory"
 FileWrite $9 "$\"Auxiliary 1 Overlay Data Directory$\"  $\"$1$\"$\r$\n"
 ReadRegStr $1 HKLM "SOFTWARE\CyberLife Technology\Creatures 3" "Resource Files Directory"
 FileWrite $9 "$\"Auxiliary 1 Resource Files Directory$\"  $\"$1$\"$\r$\n"
 ReadRegStr $1 HKLM "SOFTWARE\CyberLife Technology\Creatures 3" "Sounds Directory"
 FileWrite $9 "$\"Auxiliary 1 Sounds Directory$\"  $\"$1$\"$\r$\n"
;yay. done that one

 Goto donec3
 dummy:
 ;doesn't exist. make an everything dummy, use that
 DetailPrint "C3 not detected."
 CreateDirectory "$INSTDIR\Everything Dummy"
;now we just send one huge block of text...
 FileWrite $9 "$\"Auxiliary 1 Backgrounds Directory$\"  $\"Everything Dummy$\"$\r$\n$\"Auxiliary 1 Body Data Directory$\"  $\"Everything Dummy$\"$\r$\n$\"Auxiliary 1 Bootstrap Directory$\"  $\"Everything Dummy$\"$\r$\n$\"Auxiliary 1 Catalogue Directory$\"  $\"Everything Dummy$\"$\r$\n$\"Auxiliary 1 Exported Creatures Directory$\"  $\"Everything Dummy$\"$\r$\n$\"Auxiliary 1 Genetics Directory$\"  $\"Everything Dummy$\"$\r$\n$\"Auxiliary 1 Images Directory$\"  $\"Everything Dummy$\"$\r$\n$\"Auxiliary 1 Overlay Data Directory$\"  $\"Everything Dummy$\"$\r$\n$\"Auxiliary 1 Resource Files Directory$\"  $\"Everything Dummy$\"$\r$\n$\"Auxiliary 1 Sounds Directory$\"  $\"Everything Dummy$\"$\r$\n"
;ugly, but hopefully it'll work.

 donec3:
;beh, evil, we now have to dump out the rest of the machine.cfg
 DetailPrint "Writing main section"
 FileWrite $9 "$\"Backgrounds Directory$\" Backgrounds$\r$\n$\"Body Data Directory$\" $\"Body Data$\"$\r$\n$\"Bootstrap Directory$\" Bootstrap$\r$\n$\"Catalogue Directory$\" Catalogue$\r$\n$\"Creature Database Directory$\" $\"Creature Galleries$\"$\r$\n$\"Display Type$\" 1$\r$\n$\"Exported Creatures Directory$\" $\"My Creatures$\"$\r$\n$\"Game Name$\" Edynn$\r$\n$\"Genetics Directory$\" Genetics$\r$\n$\"Images Directory$\" Images$\r$\n$\"Journal Directory$\" Journal$\r$\n$\"Main Directory$\" .$\r$\n$\"Overlay Data Directory$\" $\"Overlay Data$\"$\r$\n$\"Resource Files Directory$\" $\"My Agents$\"$\r$\n$\"Sounds Directory$\" Sounds$\r$\n$\"Users Directory$\" Users$\r$\n$\"Win32 Auxiliary Game Name 1$\" $\"Creatures 3$\"$\r$\n$\"Worlds Directory$\" $\"My Worlds$\"$\r$\n"
;ick. we also need a third auxiliary to override DS.
 FileWrite $9 "$\"Auxiliary 3 Backgrounds Directory$\" Backgrounds$\r$\n$\"Auxiliary 3 Body Data Directory$\" $\"Body Data$\"$\r$\n$\"Auxiliary 3 Catalogue Directory$\" Catalogue$\r$\n$\"Auxiliary 3 Exported Creatures Directory$\" $\"My Creatures$\"$\r$\n$\"Auxiliary 3 Genetics Directory$\" Genetics$\r$\n$\"Auxiliary 3 Images Directory$\" Images$\r$\n$\"Auxiliary 3 Overlay Data Directory$\" $\"Overlay Data$\"$\r$\n$\"Auxiliary 3 Resource Files Directory$\" $\"My Agents$\"$\r$\n$\"Auxiliary 3 Sounds Directory$\" Sounds$\r$\n"

;now, we still have to fix the backslashes...
 FileClose $9
;do it in two parts, to avoid the infinite loop
 Push "$INSTDIR\machine.cfg"
 Push "\"
 Push "!@#!@#"
 Call RIF
 Push "$INSTDIR\machine.cfg"
 Push "!@#!@#"
 Push "\\"
 Call RIF
 Delete "$INSTDIR\machine.cfg.old"
;please, work...
 mSkip:
 DetailPrint "Finished writing machine.cfg"
SectionEnd
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;functions
Function RIF
  ClearErrors  ; wanna be a newborn

  Exch $0      ; REPLACEMENT
  Exch
  Exch $1      ; SEARCH_TEXT
  Exch 2
  Exch $2      ; SOURCE_FILE
  Push $R0     ; SOURCE_FILE file handle
  Push $R1     ; temporary file handle
  Push $R2     ; unique temporary file name
  Push $R3     ; a line to sar/save
  Push $R4     ; shift puffer

  IfFileExists $2 +1 RIF_error      ; knock-knock
  FileOpen $R0 $2 "r"               ; open the door

  GetTempFileName $R2               ; who's new?
  FileOpen $R1 $R2 "w"              ; the escape, please!

  RIF_loop:                         ; round'n'round we go
    FileRead $R0 $R3                ; read one line
    IfErrors RIF_leaveloop          ; enough is enough
    RIF_sar:                        ; sar - search and replace
      Push "$R3"                    ; (hair)stack
      Push "$1"                     ; needle
      Push "$0"                     ; blood
      Call StrReplace               ; do the bartwalk
      StrCpy $R4 "$R3"              ; remember previous state
      Pop $R3                       ; gimme s.th. back in return!
      StrCmp "$R3" "$R4" +1 RIF_sar ; loop, might change again!
    FileWrite $R1 "$R3"             ; save the newbie
  Goto RIF_loop                     ; gimme more
  RIF_leaveloop:                    ; over'n'out, Sir!
    FileClose $R1                   ; S'rry, Ma'am - clos'n now
    FileClose $R0                   ; me 2

    Delete "$2.old"                 ; go away, Sire
    Rename "$2" "$2.old"            ; step aside, Ma'am
    Rename "$R2" "$2"               ; hi, baby!

    ClearErrors                     ; now i AM a newborn
    Goto RIF_out                    ; out'n'away

  RIF_error:                        ; ups - s.th. went wrong...
    SetErrors                       ; ...so cry, boy!
  RIF_out:                          ; your wardrobe?
  Pop $R4
  Pop $R3
  Pop $R2
  Pop $R1
  Pop $R0
  Pop $2
  Pop $0
  Pop $1
FunctionEnd

function StrReplace
  Exch $0 ;this will replace wrong characters
  Exch
  Exch $1 ;needs to be replaced
  Exch
  Exch 2
  Exch $2 ;the orginal string
  Push $3 ;counter
  Push $4 ;temp character
  Push $5 ;temp string
  Push $6 ;length of string that need to be replaced
  Push $7 ;length of string that will replace
  Push $R0 ;tempstring
  Push $R1 ;tempstring
  Push $R2 ;tempstring
  StrCpy $3 "-1"
  StrCpy $5 ""
  StrLen $6 $1
  StrLen $7 $0
  Loop:
  IntOp $3 $3 + 1
  StrCpy $4 $2 $6 $3
  StrCmp $4 "" ExitLoop
  StrCmp $4 $1 Replace
  Goto Loop
  Replace:
  StrCpy $R0 $2 $3
  IntOp $R2 $3 + $6
  StrCpy $R1 $2 "" $R2
  StrCpy $2 $R0$0$R1
  IntOp $3 $3 + $7
  Goto Loop
  ExitLoop:
  StrCpy $0 $2
  Pop $R2
  Pop $R1
  Pop $R0
  Pop $7
  Pop $6
  Pop $5
  Pop $4
  Pop $3
  Pop $2
  Pop $1
  Exch $0
FunctionEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;copy DS files
Section "Copy DS engine files"
  SectionIn 1
  ;find where DS is
  ReadRegStr $0 HKLM "SOFTWARE\CyberLife Technology\Docking Station" "Main Directory"
  StrCmp $0 "" 0 Copyness
   ;uhoh, no DS
   MessageBox MB_OK|MB_ICONEXCLAMATION  "Couldn't copy DS files: DS isn't installed! You'll have to get the files yourself. (caos.syntax, engine.exe, engine.map, engine-netbabel.dll, and engine-netbabel.map)"
   Goto Skipp

  Copyness:
;here's where we grab files
   CopyFiles "$0\engine*.*" "$INSTDIR" 4440
   CopyFiles "$0\caos.syntax" "$INSTDIR" 49
  Skipp:
SectionEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; optional section
Section "Start Menu Shortcuts"
  SectionIn 1
  CreateDirectory "$SMPROGRAMS\Edynn"
  CreateShortCut "$SMPROGRAMS\Edynn\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\Edynn\Edynn.lnk" "$INSTDIR\engine.exe" "" "$INSTDIR\edynn.ico" 0
SectionEnd

; optional desktop thing
Section "Desktop Shortcut"
  SectionIn 1
  CreateShortCut "$DESKTOP\Edynn.lnk" "$INSTDIR\engine.exe" "" "$INSTDIR\edynn.ico" 0
SectionEnd


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; uninstall stuff
UninstallText "This will uninstall Edynn. Hit next to continue."
UninstallIcon "un-edynn.ico"

; special uninstall section.
Section "Uninstall"
  ; remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Edynn"
  DeleteRegKey HKLM "SOFTWARE\CyberLife Technology\Edynn"
  ; remove files
;big list of files goes here.
;also need to check whether creatures/agents should be left.
  MessageBox MB_YESNO|MB_ICONQUESTION "Would you like to keep your creatures, worlds and agents?" IDNO Killitall

;here we have the long way of removing: take out certain folders, plus the engine n'stuff
 ;remove dirs
  RMDir /r "$INSTDIR\Backgrounds"
  RMDir /r "$INSTDIR\Body Data"
  RMDir /r "$INSTDIR\Bootstrap"
  RMDir /r "$INSTDIR\Catalogue"
  RMDir /r "$INSTDIR\Creature Galleries"
  RMDir /r "$INSTDIR\Genetics"
  RMDir /r "$INSTDIR\Images"
  RMDir /r "$INSTDIR\Overlay Data"
  RMDir /r "$INSTDIR\Sounds"
  RMDir /r "$INSTDIR\Users"
  RMDir /r "$INSTDIR\source"
  RMDir /r "$INSTDIR\Everything Dummy"
 ;remove files
  Delete "$INSTDIR\*.txt"
  Delete "$INSTDIR\*.cfg"
  Delete "$INSTDIR\edynn.*"
  Delete "$INSTDIR\engine*.*"
  Delete "$INSTDIR\caos.syntax"
  Delete "$INSTDIR\uninstall.exe"

  Goto Skip
  Killitall:
 ;here we just remove the whole dir.
  RMDir /r "$INSTDIR"

  Skip:
 ;remove shortcuts, if any.
  Delete "$SMPROGRAMS\Edynn\*.*"
 ;remove directories used.
  RMDir "$SMPROGRAMS\Edynn"
 ;kill desktop shortcut
  Delete "$DESKTOP\Edynn.lnk"
SectionEnd

; eof
