#!/usr/bin/perl
use strict;
use warnings;

my $build = get_build_number();

print <<WARNING;
Are you *sure* that you want to tag
everything as "Build-$build"?
The only way to undo this is to delete
everything and cvs checkout again, and
if you cvs commit, you can't untag it.

If you're *sure*, then just hit enter.
if you're not sure, Control-C now.
WARNING

readline(*STDIN);
print "Okay, here we go\n";
system('cvs', '-q', 'tag', "Build-$build");


sub get_build_number {
	my ($file, $build);
	open $file, "BuildNumber.txt";
	chomp($build = readline($file));
	close $file;

	return $build;
}
