#!/usr/bin/perl
use strict;
use warnings;
use Fatal qw(open close);



my $old = get_build_number();
my $now = shift(@ARGV) or print "USAGE: edynn-set-build <n>\nCurrent build is: $old\n" and exit;

my $new = set_build_number($now);
print "from $old to $new\n";

	
sub set_build_number {
	my ($build) = @_;
	my ($file, $catofile, $buffer);
	local $/; # localize $/, $/ can't be made private with my().
	$catofile = "Catalogue/enginestuff.catalogue";

	open $file, ">BuildNumber.txt";
	print $file $build, "\n";
	close $file;


	open $file, $catofile;
	$/ = undef; # disable input record seperator
	$buffer = readline($file);
	close $file;

	$buffer =~ s/"Edynn: Build \d+, DS Engine "/"Edynn: Build $build, DS Engine "/;

	open $file, ">$catofile";
	print $file $buffer;
	close $file;

	return $build;
}

sub get_build_number {
	my ($file, $build);
	open $file, "BuildNumber.txt";
	chomp($build = readline($file));
	close $file;

	return $build;
}
