#include "colors.inc"  
#include "functions.inc"
#include "edynn.inc"

 //camera
  camera {
  orthographic
    location <0, 6, -30>  //front                      
//    location <-25, 4, -5>  //left                       
//    location <25, 4, -5>   //right 
//    location <0, 4, 25>   //back
    look_at <0, 5, -5>    
//    angle 36
  }    
  
  //light
  light_source { <-5, 15, -50> Gray50 } 
  light_source { <-5, 15, -50> Gray50 shadowless }
  
  //background        
//  background { color rgb <.14, .04, 0> } //MidnightBlue }  

//stars
object {starfield}


//---------------------------------------------------------------\\

difference{
 union{
 //moon surface 
 isosurface {
 function {y-f_ridged_mf(x,-1,z, .3,2,8,.3,1,1)}
 max_gradient 7.3
 accuracy 0.0001
 contained_by{box{<-9, -1, -9>, <10, 1.5, 9>}}
 //pigment { color Yellow }
 scale <5, 4,5>
 translate <0, 10, 45.0001>
 }// */
 //the moon
 box { <-20, -10, 0>, <20,10,20>}
 texture{Syla}
 }//end union
 
//the inside
 blob{
	threshold .5
#declare a=-4;
#while (a<=4)
//lower corridor
	sphere{ <0, -3, a>, 4, 2 
		scale <.5,1,1>
		translate x*-14
	}
	#declare i=-12;
	#while (i<=12)
		sphere{ <i, -3, a>, 4, 2 }
		#declare i=i+4;
	#end
	sphere{ <0, -3, a>, 4, 2
		scale <.5,1,1>
		translate x*14
	}
// upper corridor
	sphere{ <0, 3.5, a>, 4, 2
		scale <.5,1,1>
		translate x*-14
	}
	#declare i=-12;
	#while (i<=4)
		sphere{ <i, 3.5, a>, 4, 2 }
		#declare i=i+4;
	#end
	sphere{ <0, 3.5, a>, 4, 2
		scale <.5,1,1>
		translate x*6
	}

	#declare a=a+4;
#end
// airlock
	cylinder{ <12, 1, 0>, <12, 9, 0>, 4, 2 }


//air vents
	#declare h=-3;
//use h to do top & bottom vents in one block
	#while (h<4)
	#declare r=-4.45;
	#while (r<=-3.55)
	 #declare c=55;
	 #while (c<=65)
	  cylinder{<r,2.5,0>,<r,3,0>,.11,.4
		pigment{ color Grey}
		rotate x*c
		translate <0,h,4>
	  }
	  #declare c=c+5;
	 #end
	 #declare r=r+.3;
	#end
	#declare h=h+6.5;
	#end

	pigment{ rgb <.91, .68, .17> }
 }//end blob
//air vent pipes
 cylinder{<-5,3.6,0>,<-2,3.6,0>,.7
 	pigment{ color Blue}
	rotate x*60
	translate <0,-3,4>
 }
 cylinder{<-5,3.6,0>,<-2,3.6,0>,.7
 	pigment{ color Blue}
	rotate x*60
	translate <0,3.5,4>
 }
//pipes to the screen
 cylinder{<-17,7.1,0>,<-4,7.1,0>,.4
 	pigment{color Blue}
 }
 cylinder{<-4,7.11,-.1>,<-4,7,4>,.4
 	pigment{color Blue}
 }

}//end diff
//////////////////////////////////////////////////////////////
//some lights
object{ Light
//	scale .5
	translate <-8,6,2>
}
object{ Light
//	scale .5
	translate <0,6,2>
}
object{ Light
//	scale .5
	translate <-8,-.5,2>
}
object{ Light
//	scale .5
	translate <4,-.5,2>
}
object{ Light
	rotate <90, 45, 0>
	translate <13, 3, 2>
}
/////////////////////////////////////////////////////////

//airlocks
difference{
torus{ 2.6, .3
//	pigment{ color Grey }
	scale <1,2,1>
	translate <12, 10, 0>
}
//box{ <8, 8, -5>, <16, 12, 0> 
box{<2.5, 2.5, 2.5>,<-2.5, -2.5, -2.5>
	rotate y*45
	translate <12, 10, -2.5>
}
pigment{ color Grey }
finish { 
	phong 1 
	specular .8
	reflection .1
}
no_shadow
}
//force field
cylinder{ <12,10.1,0>,<12,9.9,0>,2.3
texture{
pigment{ color rgbf<1,1,1,.7>}
finish {
	ambient 0.2
	diffuse 0
	reflection 0.6
	irid {
		0.35
		thickness .1
		turbulence .5
	}
}
normal{
	ripples
//	scale 2
}
}//end texture
interior { ior 2.5 caustics .5}
no_shadow
}


//airlock 2
difference{
torus{ 2.7, .3
//      pigment{ color Grey }
	scale <1,2,1>
	translate <12, 0.5, 0>
}
//box{ <8, -2, -5>, <16, 2, 0> }
box{<2.5, 2.5, 2.5>,<-2.5, -2.5, -2.5>
	rotate y*45
	translate <12, 0, -2.5>
}
pigment{ color Grey }
finish { 
	phong 1
	specular .8
	reflection .1
}
no_shadow
}

//force field
cylinder{ <12,.6,0>,<12,.4,0>,2.4
texture{
pigment{ color rgbf<1,1,1,.7>}
finish {
	ambient 0.2
	diffuse 0
	reflection 0.6
	irid {
		0.35
		thickness .1
		turbulence .5
	}
}
normal{
	ripples
//	scale 1
//	rotate y*158
}
}//end texture
interior { ior 2.5 caustics .5}
no_shadow
}

//////////////////////////////////////////////////////////

//lift pole
cylinder{<14,-10,0.2>,<14,12,0.2>,.1
pigment{ color Grey }
finish {
	phong 1
	specular .8
	reflection .1
}
}

//the lift
union{
cylinder{<12,-5.1,0>,<12,-4.9,0>,2.3}
cylinder{<13.7,-5,0>,<13.7,-5.5,0>,.5}
pigment{ color rgb <.6,.5,.63> }
finish {
	specular .5
	reflection .1
}
}




