#include "colors.inc"  
#include "functions.inc"
//#include "stars.inc"

 //camera
  camera {
  orthographic
    location <0, 6, -30>  //front                      
//    location <-25, 4, -5>  //left                       
//    location <25, 4, -5>   //right 
//    location <0, 4, 25>   //back
    look_at <0, 5, -5>    
//    angle 36
  }    
  
  //light
  light_source { <-5, 15, -50> Gray50 } 
  light_source { <-5, 15, -50> Gray50 shadowless }
  
  //background        
//  background { color rgb <.14, .04, 0> } //MidnightBlue }  

//stars
plane {z, -100
 rotate y*180
 texture {
	pigment {
	 granite
	 color_map {
	  [ 0.000  0.275 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
	  [ 0.275  0.280 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
	  [ 0.280  0.475 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
	  [ 0.475  0.480 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
	  [ 0.480  0.685 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
	  [ 0.685  0.690 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
	  [ 0.690  0.885 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
	  [ 0.885  0.890 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
	  [ 0.890  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
	 }
	 turbulence 1
	 sine_wave
	 scale .5
	}
	finish { diffuse 0 ambient 1 }
 }
}
/*    
  //sky-sphere
  sky_sphere {
    pigment {
      gradient y
      color_map {
        [0 color Green]
        [1 color Blue]
      }
      scale 2
      translate -1
    }    
    pigment {
      bozo
      turbulence 0.25
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.8, 0.5, 0.8>
    }     
  }             
           
//plane             
  plane { y, 0
    pigment { color ForestGreen }
    finish { ambient .3 diffuse .7 }
  }
  
//sphere  
  sphere { <0, 0, 0>, 2
    pigment { 
        color rgb <1, 1, 1>   
        filter .5
    }
    finish { 
        ambient 0.2 
        diffuse 0 
        reflection 0.6 
    }
  } 
//---------------------------------------------------\\

#declare Bulb=sphere {
	<0,-1,0>,0.5
	texture {
		pigment {
			color rgb <.9, .5, 0.1>
		}
		finish {
			ambient .8
			diffuse .6
		}
	}
}
*/
#declare Spot=sphere{ <0,0,0>, 1
	texture {
		pigment { color rgb <.99, .4, 0.1> }
		finish {
			ambient .8
			diffuse .6
		}
	}
	scale y*.4
}

/*
#declare Lamp = union{
	light_source {
		<0, -1, 0>
		color Red
		spotlight
		radius 5
		falloff 250
		tightness 2
		area_light <-0.5, -1, -0.5>, <0.5, -1, 0.5>, 2, 2
		adaptive 1
		jitter
		looks_like { Bulb }
		point_at <0, -2, 0>
	}
	cone{
		<0,0,0>, 0.1
		<0,-2,0>, 3
		open
		pigment{ color Blue }
	}
}
*/

#declare Light = union{
	light_source { <0, 0, 0>
		color Red
		spotlight
		radius 5
		falloff 250
		tightness 2
		area_light <-0.5, -1, -0.5>, <0.5, -1, 0.5>, 2, 2
		adaptive 1
		jitter
		looks_like { Spot }
		point_at <0, -2, 0>
	}
	torus { 1, .1
		scale y*3
		translate y*.2
		pigment { color Gray }//rgb <.4, .4, .8> }
	}
}


//------------------------------------------------------------------------------\\

difference{
 union{
//moon surface 
isosurface {
function {y-f_ridged_mf(x,-1,z, .3,2,8,.3,1,1)}
max_gradient 7.3
accuracy 0.0001
contained_by{box{<-9, -1, -9>, <10, 1.5, 9>}}
//pigment { color Yellow }
scale <5, 4,5>
translate <0, 10, 45.0001>
}// */

//the moon
box { <-20, -10, 0>, <20,10,20>}
texture{
 pigment {
	wood color_map { [0.1 color rgb <0.64, 0.36, 0.02>] 
		[0.8 color rgb <.91, .68, .07>] 
		[0.7 color rgb <.62, .17, 0>]
	}
	turbulence 0.8
//	rotate x*90
//	scale<0.2,0.3,1>
 }
 normal{
 	gradient x
	normal_map{
		[0.3 bumps scale 2]
		[0.3 dents scale 3]
		[0.6 dents]
		[0.9 marble turbulence .5]
	}
	scale 2
 }
//} 
}
texture{ pigment{
//	marble
	agate
	color_map { [0.1 color rgbt <0.64, 0.36, 0.02, .5>]
		[0.8 color rgbt <.91, .68, .07, .5>]
		[0.7 color rgbt <.62, .17, 0, .5>]
	}
	turbulence 0.4
//	frequency 3
	lambda 1.5
	omega .8
	octaves 5
//      rotate x*90
	scale <8, 2, 1>
}}
 }//end union
//the inside
blob{
	threshold .5
#declare a=-4;
#while (a<=4)
//lower corridor
	sphere{ <0, -3, a>, 4, 2 
		scale x*.5
		translate x*-14
	}
	#declare i=-12;
	#while (i<=12)
		sphere{ <i, -3, a>, 4, 2 }
		#declare i=i+4;
	#end
	sphere{ <0, -3, a>, 4, 2
		scale x*.5
		translate x*14
	}
// upper corridor
	sphere{ <0, 3.5, a>, 4, 2
		scale x*.5
		translate x*-14
	}
	#declare i=-12;
	#while (i<=4)
		sphere{ <i, 3.5, a>, 4, 2 }
		#declare i=i+4;
	#end
	sphere{ <0, 3.5, a>, 4, 2
		scale x*.5      
		translate x*6
	}
// airlock
//	cylinder{ <12, 1, a>, <12, 8, a>, 4, 2 }

	#declare a=a+4;
#end
// airlock
	cylinder{ <12, 1, 0>, <12, 9, 0>, 4, 2 }

	pigment{ rgb <.91, .68, .17> }
}

}

//some lights
object{ Light
//	scale .5
	translate <-8,6,2>
}
object{ Light
//	scale .5
	translate <0,6,2>
}
object{ Light
//	scale .5
	translate <-8,-.5,2>
}
object{ Light
//	scale .5
	translate <4,-.5,2>
}
object{ Light
	rotate <90, 45, 0>
	translate <13, 3, 2>
}

//airlocks
difference{
torus{ 2.6, .3
//	pigment{ color Grey }
	scale y*2
	translate <12, 10, 0>
}
//box{ <8, 8, -5>, <16, 12, 0> 
box{<2.5, 2.5, 2.5>,<-2.5, -2.5, -2.5>
	rotate y*45
	translate <12, 10, -2.5>
}
pigment{ color Grey }
finish { 
	phong 1 
	specular .8
	reflection .1
}
no_shadow
}
difference{
torus{ 2.7, .3
//      pigment{ color Grey }
	scale y*2
	translate <12, 0.5, 0>
}
//box{ <8, -2, -5>, <16, 2, 0> }
box{<2.5, 2.5, 2.5>,<-2.5, -2.5, -2.5>
	rotate y*45
	translate <12, 0, -2.5>
}
pigment{ color Grey }
finish { 
	phong 1
	specular .8
	reflection .1
}
no_shadow
}



