#include "colors.inc"  
#include "metals.inc"
#include "functions.inc"
#declare port_colour=Brown;
#include "edynn.inc"

 //camera
  camera {
  orthographic
    location <0, 6, -30>  //front                      
//    location <-25, 4, -5>  //left                       
//    location <25, 4, -5>   //right 
//    location <0, 4, 25>   //back
    look_at <0, 5, -5>    
//    angle 36
  }    
  
  //light
  light_source { <-5, 15, -50> Gray50 } 
  light_source { <-5, 15, -50> Gray50 shadowless }
  
  //background        
//  background { color rgb <.14, .04, 0> } //MidnightBlue }  

//stars
object {starfield}


//---------------------------------------------------------------\\

difference{
 union{
  difference{
 union{
 //moon surface 
 isosurface {
  function {y-f_ridged_mf(x,-1,z, .3,2,8,.3,1,1)}
  max_gradient 7.3
  accuracy 0.0001
  contained_by{box{<-9, -1, -9>, <10, 1.5, 9>}}
  //pigment { color Yellow }
  scale <5, 4,5>
  translate <0, 10, 45.0001>
 }// */
 //the moon
 box { <-20, -10, 0>, <20,10,20>}
 }
 //chop off a sliver of the rock to change the texture
 box{<-20, -10, .1>, <20,20,-1>
 	texture{Syla2}
 }
  }//end diff #2	  

 //soil colouring
 difference{
  blob{
	threshold .5
	#declare a=-4;
	#while (a<=4)
//lower coridor
	sphere{ <0, -3.5, a>, 4, 2
		scale <.5,1,1>
		translate x*-14
	}
	#declare i=-12;
	#while (i<=12)
		sphere{ <i, -3.5, a>, 4, 2 }
		#declare i=i+4;
	#end
	sphere{ <0, -3.5, a>, 4, 2
		scale <.5,1,1>
		translate x*14
	}
//upper corridor
	sphere{ <0, 3, a>, 4, 2
		scale <.5,1,1>
		translate x*-14
	}
	#declare i=-12;
	#while (i<=4)
		sphere{ <i, 3, a>, 4, 2 }
//		sphere{ <i, 4, a>, 4, -1}
		#declare i=i+4;
	#end
	sphere{ <0, 3, a>, 4, 2
		scale <.5,1,1>
		translate x*6
	}
//done
	#declare a=a+4;
	#end
//colour
//	pigment{ rgb <.85, .58, .27> }
  }//end soil blob

  box{<-20, -10, -.01>, <20,10,-10>}
  pigment{
  	agate
	color_map {// [0.1 color rgb <0.64, 0.36, 0.02>]
		[0.1 color rgbt <.25, .15, .01, .1>]
		[0.8 color rgbt <.55, .20, .03, .2>]
		[0.7 color rgbt <.44, .17, .01, .2>]
	}
	turbulence 2
  }
//  pigment{ rgbt <.55, .20, .03, .2> }
 }//end diff
// */
 texture{Syla3}
 }//end union
 
//chop of a sliver of the rock to change the texture
// box{<-20, -10, .1>, <20,20,-1>
// 	texture{Syla2}
// }
//the inside
 blob{
	threshold .5
#declare a=-4;
#while (a<=4)
//lower corridor
	sphere{ <0, -3, a>, 4, 2 
		scale <.5,1,1>
		translate x*-14
	}
	#declare i=-12;
	#while (i<=12)
		sphere{ <i, -3, a>, 4, 2 }
		#declare i=i+4;
	#end
	sphere{ <0, -3, a>, 4, 2
		scale <.5,1,1>
		translate x*14
	}
// upper corridor
	sphere{ <0, 3.5, a>, 4, 2
		scale <.5,1,1>
		translate x*-14
	}
	#declare i=-12;
	#while (i<=4)
		sphere{ <i, 3.5, a>, 4, 2 }
		#declare i=i+4;
	#end
	sphere{ <0, 3.5, a>, 4, 2
		scale <.5,1,1>
		translate x*6
	}

	#declare a=a+4;
#end
// airlock
	cylinder{ <12, 1, 0>, <12, 9, 0>, 4, 2 }


//air vents
	#declare h=-3;
//use h to do top & bottom vents in one block
	#while (h<4)
	#declare r=-4.45;
	#while (r<=-3.55)
	 #declare c=55;
	 #while (c<=65)
	  cylinder{<r,2.5,0>,<r,3,0>,.11,.4
		pigment{ color Grey}
		rotate x*c
		translate <0,h,4>
	  }
	  #declare c=c+5;
	 #end
	 #declare r=r+.3;
	#end
	#declare h=h+6.5;
	#end

//airlock vent
	#declare r=6;
	#while(r<=6.9)
	 #declare c=55;
	 #while (c<=75)
	  cylinder {<2.5,r,0>,<3,r,0>,.11,1-cos(pi*(clock+.05))
	  	pigment{color Grey}
		rotate y*-c
		translate x*12
	  }
	  #declare c=c+5;
	 #end
	 #declare r=r+.3;
	#end
	texture {Syla}
/*
	pigment{
		gradient y
		scale 3
		turbulence .1
		color_map{
			[0.0 color rgbf <.91, .68, .17, .2>]
			[0.1 color rgbf <.81, .48, .27, .2>]
			[0.3 color rgbf <.81, .48, .27, .2>]
			[0.9 color rgbf <.91, .68, .17, .2>]
		}
		
//	rgbf <.91, .68, .17, .2>
	}
	*/
 }//end blob
//air vent pipes
 cylinder{<-5,3.6,0>,<-2,3.6,0>,.7
 	pigment{ color Blue}
	rotate x*60
	translate <0,-3,4>
 }
 cylinder{<-5,3.6,0>,<-2,3.6,0>,.7
 	pigment{ color Blue}
	rotate x*60
	translate <0,3.5,4>
 }
//airlock vent pipes
#declare h=6.15;
#while (h<6.8)
 cylinder{<3.6,h,-2>,<3.6,h,2>,.7
	pigment{color Blue}
	rotate y*-65
	translate x*12
 }
 #declare h=h+.6;
#end
//now some pipes
 union{
//pipes to the screen
	cylinder{<-17,7.1,0>,<-4,7.1,0>,.4}
	cylinder{<-4,7.11,-.1>,<-4,7,4>,.4}
	cylinder{<-4,7.4,4>,<-4,6,4>,.4}
//decoration pipes
	cylinder{<-1.6,0,-1>,<-1.6,0,6>,.3} //big
	cylinder{<-1.6,1,7>,<-1.6,-1,7>,.3}
	cylinder{<-2.1,.25,-1>,<-2.1,.25,4>,.15} //small
	cylinder{<-2.1,.35,4>,<-2.1,0,4>,.15}
	cylinder{<11,-6.5,-1>,<7,-6.5,1>,.2}//slanted

//blobby thing by the airlock
	blob{
		threshold .2
		sphere{<16,5.7,0>,.5,1}
		sphere{<15.5,6.2,.1>,.4,1}
		sphere{<16.2,6.1,-.3>,.5,1}
		sphere{<15.8,5,-.1>,.8,1}
		sphere{<15.7,5.8,-.01>,.75,.6}
		sphere{<16.4,4.8,0>,.5,1}
	}

//random bubbles
	sphere{<16,1.5,0>,.1}
	sphere{<8,8,0>,.1}
	sphere{<-16,-6,0>,.1}
	sphere{<-12,6.5,0>,.1}


	texture{bluePipes}
 }

}//end diff
//////////////////////////////////////////////////////////////
//some lights
object{ Light
//	scale .5
	translate <-8,6,2>
}
object{ Light
//	scale .5
	translate <0,6,2>
}
object{ Light
//	scale .5
	translate <-8,-.5,2>
}
object{ Light
//	scale .5
	translate <4,-.5,2>
}
object{ Light
	rotate <90, 45, 0>
	translate <13, 3, 2>
}
/////////////////////////////////////////////////////////

//airlocks
union{
 difference{
torus{ 2.6, .3
//	pigment{ color Grey }
	scale <1,2,1>
	translate <12, 10, 0>
}
//box{ <8, 8, -5>, <16, 12, 0> 
box{<2.5, 2.5, 2.5>,<-2.5, -2.5, -2.5>
	rotate y*45
	translate <12, 10, -2.5>
}
 }
 object{port_in
 	scale .9
 	rotate y*-90
 	translate <-2.5,0,-.65>
	rotate y*45
	translate <12, 10, -2.5>
 }
 object{port_out
 	scale .9
//	rotate y*-90
	translate <.7,0,2.5>
	rotate y*45
	translate <12, 10, -2.5>
 }

pigment{ color Grey }
finish { 
	phong 1 
	specular .8
	reflection .1
}
no_shadow
}
///lower
union{
difference{
torus{ 2.7, .3
//	pigment{ color Grey }
	scale <1,2,1>
	translate <12, 0.5, 0>
}
//box{ <8, -2, -5>, <16, 2, 0> }
box{<2.5, 2.5, 2.5>,<-2.5, -2.5, -2.5>
	rotate y*45
	translate <12, 0, -2.5>
}
}
object{port_in
	scale .9
	rotate y*-90
	translate <-2.5,0,-.8>
	rotate y*45
	translate <12, 0.5, -2.5>
}
object{port_out
	scale .9
//	rotate y*-90
	translate <.8,0,2.5>
	rotate y*45
	translate <12, 0.5, -2.5>
}

pigment{ color Grey }
finish {
	phong 1
	specular .8
	reflection .1
}
no_shadow
}

#if (clock>0)
//force fields
cylinder{ <12,10.1,0>,<12,9.9,0>,2.3
texture{
pigment{ color rgbf<1,1,1,.7>}
finish {
	ambient 0.2
	diffuse 0
	reflection 0.6
	irid {
		0.35
		thickness .1
		turbulence .5
	}
}
normal{
	ripples
//	scale 2
	rotate y*(720*clock)
}
}//end texture
interior { ior 2.5 caustics .5}
no_shadow
}
///lower
cylinder{ <12,.6,0>,<12,.4,0>,2.4
texture{
pigment{ color rgbf<1,1,1,.7>}
finish {
	ambient 0.2
	diffuse 0
	reflection 0.6
	irid {
		0.35
		thickness .1
		turbulence .5
	}
}
normal{
	ripples
//	scale 1
	rotate y*(720*clock)
}
}//end texture
interior { ior 2.5 caustics .5}
no_shadow
}
#end

//////////////////////////////////////////////////////////

//lift pole
cylinder{<14,-10,0.2>,<14,12,0.2>,.1
pigment{ color Grey }
finish {
	phong 1
	specular .8
	reflection .1
}
}
/*
//the lift
union{
cylinder{<12,-5.1,0>,<12,-4.9,0>,2.3}
cylinder{<13.7,-5,0>,<13.7,-5.5,0>,.5}
pigment{ color rgb <.6,.5,.63> }
finish {
	specular .5
	reflection .1
}
}
*/



