/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections.prim;

import java.util.Objects;
import javax.annotation.Nonnull;
import rebound.exceptions.ReadonlyUnsupportedOperationException;
import rebound.util.Primitives;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.objectutil.ObjectUtilities;

public class CharSequenceBackedReadonlyCharacterList
implements PrimitiveCollections.CharacterList {
    @Nonnull
    protected final CharSequence underlying;

    public CharSequenceBackedReadonlyCharacterList(@Nonnull CharSequence underlying) {
        this.underlying = Objects.requireNonNull(underlying);
    }

    @Override
    public PrimitiveCollections.CharacterList clone() {
        if (Primitives.isTrueAndNotNull(ObjectUtilities.isThreadUnsafelyImmutable(this.underlying))) {
            return this;
        }
        return new CharSequenceBackedReadonlyCharacterList(ObjectUtilities.attemptClone(this.underlying));
    }

    @Override
    public Boolean isWritableCollection() {
        return false;
    }

    @Override
    public int size() {
        return this.underlying.length();
    }

    @Override
    public PrimitiveCollections.CharacterList subList(int fromIndex, int toIndex) {
        return fromIndex == 0 && toIndex == this.size() ? this : new CharSequenceBackedReadonlyCharacterList(this.underlying.subSequence(fromIndex, toIndex));
    }

    @Override
    public char getChar(int index) {
        return this.underlying.charAt(index);
    }

    @Override
    public void clear() {
        throw new ReadonlyUnsupportedOperationException();
    }

    @Override
    public void setChar(int index, char value) {
        throw new ReadonlyUnsupportedOperationException();
    }

    @Override
    public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
        throw new ReadonlyUnsupportedOperationException();
    }

    @Override
    public void insertChar(int index, char value) {
        throw new ReadonlyUnsupportedOperationException();
    }

    @Override
    public void setSizeChar(int newSize, char elementToAddIfGrowing) {
        throw new ReadonlyUnsupportedOperationException();
    }
}

