/*
 * Decompiled with CFR 0.152.
 */
package rebound.apps.c3ds.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import rebound.jagent.lib.archive.CreaturesArchiveFormat;

public class CreaturesArchiveCompressDecompressMain {
    public static final String HELP = "Usage: [un]compress.creatures -c [<compression-level>]\n       [un]compress.creatures <input-file> <output-file> [<compression-level>]\n\nThe -c option uses stdin and stdout instead of files.\nCompression level (used with compress mode) is 0-9 and has aliases: world, glist, caos.syntax";

    public static void main(boolean compress, String[] args) {
        int ec = CreaturesArchiveCompressDecompressMain.doMain(compress, args);
        if (ec == 1) {
            CreaturesArchiveCompressDecompressMain.printHelp();
        }
        System.exit(ec);
    }

    public static void printHelp() {
        System.out.println(HELP);
    }

    public static int doMain(boolean compress, String[] args) {
        block16: {
            if (args.length == 0) {
                return 1;
            }
            if (args[0].equals("-c")) {
                int compressionLevel = 9;
                if (args.length > 1) {
                    compressionLevel = CreaturesArchiveCompressDecompressMain.getCompressionLevel(args[1]);
                }
                try {
                    InputStream in = System.in;
                    PrintStream out = System.out;
                    if (compress) {
                        CreaturesArchiveFormat.compress(in, out, compressionLevel);
                        break block16;
                    }
                    CreaturesArchiveFormat.uncompress(in, out);
                }
                catch (IOException exc) {
                    System.err.println("IO Error: " + exc.getMessage());
                    System.exit(32);
                }
            } else if (args.length >= 2) {
                int compressionLevel = 9;
                if (args.length > 2) {
                    compressionLevel = CreaturesArchiveCompressDecompressMain.getCompressionLevel(args[2]);
                }
                File inf = new File(args[0]);
                File outf = new File(args[1]);
                if (!inf.isFile()) {
                    System.err.println("Input " + inf + " is not a file.");
                    return 2;
                }
                if (outf.exists()) {
                    System.err.println("Output " + outf + " exists.");
                    return 2;
                }
                try {
                    FileInputStream in = new FileInputStream(inf);
                    FileOutputStream out = new FileOutputStream(outf);
                    if (compress) {
                        CreaturesArchiveFormat.compress(in, out, compressionLevel);
                    } else {
                        CreaturesArchiveFormat.uncompress(in, out);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
                catch (IOException exc) {
                    System.err.println("IO Error: " + exc.getMessage());
                    System.exit(32);
                }
            } else {
                return 1;
            }
        }
        return 0;
    }

    public static int getCompressionLevel(String input) {
        if (input == null) {
            return 9;
        }
        int i = 0;
        try {
            i = Integer.parseInt(input);
        }
        catch (NumberFormatException exc) {
            i = input.equalsIgnoreCase("caos.syntax") ? 6 : (input.equalsIgnoreCase("world") ? 5 : (input.equalsIgnoreCase("glist") ? 6 : 9));
        }
        if (i < 0) {
            return 0;
        }
        if (i > 9) {
            return 9;
        }
        return i;
    }
}

