/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import rebound.annotations.semantic.allowedoperations.EmbeddableMain;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.allowedoperations.UnembeddableMain;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.annotations.semantic.temporal.NeverReturns;
import rebound.concurrency.ConcurrencyUtilities;
import rebound.dataformats.json.JSONUtilities;
import rebound.exceptions.GenericDataStructuresFormatException;
import rebound.exceptions.NotYetImplementedException;
import rebound.exceptions.TextSyntaxException;
import rebound.exceptions.UnreachableCodeException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.file.FSUtilities;
import rebound.io.util.BasicIOUtilities;
import rebound.io.util.JRECompatIOUtilities;
import rebound.io.util.TextIOUtilities;
import rebound.testing.WidespreadTestingUtilities;
import rebound.text.FormattingUtilities;
import rebound.text.StringUtilities;
import rebound.util.Compass;
import rebound.util.ExceptionPrettyPrintingUtilities;
import rebound.util.cli.AsyncConsoleReaderBufferer;
import rebound.util.collections.CollectionUtilities;
import rebound.util.container.SimpleContainers;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.functional.throwing.FunctionalInterfacesThrowingCheckedExceptionsStandard;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.JavaNamespace;

public class ConsoleUtilities
implements JavaNamespace {
    public static final String HelpFileSuffix = ".help.txt";
    public static final String HelpFile = "help.txt";

    @UnembeddableMain
    public static void mainWithErrorPrinting(FunctionalInterfacesThrowingCheckedExceptionsStandard.RunnableThrowingAnything realmain) {
        try {
            realmain.run();
        }
        catch (Throwable t) {
            ExceptionPrettyPrintingUtilities.printStackTraceCompletely(t);
            System.exit(32);
            throw new UnreachableCodeException();
        }
    }

    public static BufferedReader newLineReaderForSTDIN() {
        return new BufferedReader(new InputStreamReader(System.in));
    }

    public static void readOneLineFromSTDIN() {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (BufferedReader r = ConsoleUtilities.newLineReaderForSTDIN();){
                r.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    /*
     * Loose catch block
     */
    public static String getHelp(Class mainclass) {
        String string;
        block11: {
            InputStream helpData;
            block9: {
                block10: {
                    helpData = null;
                    File jarFile = Compass.getJarFile(mainclass);
                    if (jarFile != null) {
                        String stem;
                        File d = jarFile.getParentFile();
                        File helpFile = new File(d, String.valueOf(stem = FSUtilities.getFilenameStem(jarFile.getName())) + HelpFileSuffix);
                        helpData = helpFile.isFile() ? new FileInputStream(helpFile) : null;
                    }
                    if (helpData == null && (helpData = mainclass.getResourceAsStream(String.valueOf(mainclass.getSimpleName()) + HelpFileSuffix)) == null) {
                        helpData = mainclass.getResourceAsStream(HelpFile);
                    }
                    if (helpData != null) break block9;
                    if (helpData == null) break block10;
                    BasicIOUtilities.closeWithoutError(helpData);
                }
                return null;
            }
            try {
                InputStreamReader reader = new InputStreamReader(helpData, "UTF-8");
                char[] data = TextIOUtilities.readAll(reader);
                string = new String(data);
                if (helpData == null) break block11;
            }
            catch (IOException exc) {
                if (helpData != null) {
                    BasicIOUtilities.closeWithoutError(helpData);
                }
                return null;
                catch (Throwable throwable) {
                    if (helpData != null) {
                        BasicIOUtilities.closeWithoutError(helpData);
                    }
                    throw throwable;
                }
            }
            BasicIOUtilities.closeWithoutError(helpData);
        }
        return string;
    }

    public static void printHelp(Class mainclass) {
        PrintWriter stdout = new PrintWriter(System.out);
        ConsoleUtilities.printHelp(mainclass, stdout);
        stdout.flush();
    }

    public static void printHelp(Class mainclass, PrintWriter out) {
        String msg = ConsoleUtilities.getHelp(mainclass);
        if (msg != null) {
            if (msg.endsWith("\n")) {
                out.print(msg);
            } else {
                out.println(msg);
            }
        } else {
            out.println("Could not find help file.");
        }
    }

    public static String getArg0() {
        return System.getProperty("java.arg0");
    }

    public static void dprintln(Object o) {
        System.out.println(StringUtilities.repr(o));
    }

    public static void dprintln(String label, Object o) {
        System.out.print(String.valueOf(label) + ": ");
        System.out.println(StringUtilities.repr(o));
    }

    public static byte[] readallStdinBytes() throws IOException {
        return JRECompatIOUtilities.readAll(System.in);
    }

    public static String readallStdinText() throws IOException {
        return TextIOUtilities.readAllText(System.in, Charset.defaultCharset());
    }

    public static void waitForUserToPressEnter() {
        try {
            ConsoleUtilities.readStdinInputThatIsEntirelyJustOneLine();
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static String readStdinInputThatIsEntirelyJustOneLine() throws IOException {
        String line = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(System.in));){
            line = r.readLine();
        }
        return line;
    }

    public static boolean readBooleanStdinInputThatIsEntirelyJustOneLine(boolean def) throws IOException {
        return StringUtilities.parseBooleanLeniently(ConsoleUtilities.readStdinInputThatIsEntirelyJustOneLine(), def);
    }

    public static boolean readBooleanStdinInputThatIsEntirelyJustOneLine() throws IOException {
        return ConsoleUtilities.readBooleanStdinInputThatIsEntirelyJustOneLine(false);
    }

    public static void p(Object msg) {
        System.out.println(msg);
    }

    public static void pRepr(Object msg) {
        System.out.println(StringUtilities.repr(msg));
    }

    public static void p() {
        System.out.println();
    }

    public static boolean areThereAnyThreadSaveOursThatIsNonDaemonWhichWillPreventTheJVMFromShuttingDown() {
        Thread us = Thread.currentThread();
        Thread[] threadArray = ConcurrencyUtilities.enumerateThreadsSafely(us.getThreadGroup(), true);
        int n = threadArray.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            if (t != us && !t.isDaemon()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void printInformationAboutRunningThreads(PrintStream out, String indentationStr, int indentLevel) {
        Thread[] threads;
        ThreadGroup rootThreadGroup = Thread.currentThread().getThreadGroup().getParent();
        out.println(rootThreadGroup);
        if (rootThreadGroup.getParent() != null) {
            throw new AssertionError();
        }
        Thread[] threadArray = threads = ConcurrencyUtilities.enumerateThreadsSafely(rootThreadGroup, true);
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            out.println(String.valueOf(StringUtilities.mulnn(indentationStr, indentLevel)) + "(daemon: " + t.isDaemon() + ")\t\t" + t);
            out.println(ExceptionPrettyPrintingUtilities.getNicelyFormattedStandardStacktrace(t.getStackTrace(), StringUtilities.mulnn(indentationStr, indentLevel + 1)));
            out.println(StringUtilities.mulnn(indentationStr, indentLevel));
            ++n2;
        }
    }

    public static void printInformationAboutRunningThreadsIfThereAreAnyNonDaemonOnesSaveOursWhichWillPreventTheJVMFromShuttingDown(PrintStream out) {
        if (ConsoleUtilities.areThereAnyThreadSaveOursThatIsNonDaemonWhichWillPreventTheJVMFromShuttingDown()) {
            out.println("There are stray non-daemon threads that may prevent the program from terminating cleanly!! O,O");
            ConsoleUtilities.printInformationAboutRunningThreads(out, "\t", 1);
        }
    }

    public static void printInformationAboutRunningThreadsIfThereAreAnyNonDaemonOnesSaveOursWhichWillPreventTheJVMFromShuttingDown() {
        ConsoleUtilities.printInformationAboutRunningThreadsIfThereAreAnyNonDaemonOnesSaveOursWhichWillPreventTheJVMFromShuttingDown(System.out);
    }

    public static Object readJSONfromSTDINinUTF8() throws UncheckedIOException {
        InputStreamReader r = new InputStreamReader(System.in, StandardCharsets.UTF_8);
        try {
            return JSONUtilities.parseJSON(r);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    public static void writeJSONtoSTDOUTinUTF8(Object gds) throws UncheckedIOException {
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);
        try {
            JSONUtilities.serializeJSONEfficiently(gds, w);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    @NeverReturns
    public static void doJSONInteractableProgram(FunctionInterfaces.UnaryFunction<Object, Object> program) {
        Object output;
        Object input;
        try {
            input = ConsoleUtilities.readJSONfromSTDINinUTF8();
        }
        catch (Throwable exc) {
            System.err.println("JUX: Error reading JSON from STDIN!");
            exc.printStackTrace();
            System.exit(1);
            throw new UnreachableCodeException();
        }
        try {
            output = program.f(input);
        }
        catch (Throwable exc) {
            System.err.println("JUX: Uncaught error in program!");
            exc.printStackTrace();
            System.exit(2);
            throw new UnreachableCodeException();
        }
        try {
            ConsoleUtilities.writeJSONtoSTDOUTinUTF8(output);
        }
        catch (Throwable exc) {
            System.err.println("JUX: Error writing JSON to STDOUT!");
            exc.printStackTrace();
            System.exit(3);
            throw new UnreachableCodeException();
        }
        System.exit(0);
        throw new UnreachableCodeException();
    }

    public static FunctionInterfaces.NullaryFunction<Boolean> startAnySTDINInputCheckerDaemon() {
        AsyncConsoleReaderBufferer r = new AsyncConsoleReaderBufferer();
        return () -> r.peekAny();
    }

    public static List<String> expandSubstitutionSyntax(List<String> templateArgs, String expansion) {
        ArrayList<String> expanded = new ArrayList<String>(templateArgs.size());
        for (String a : templateArgs) {
            if (BasicObjectUtilities.eq((Object)a, (Object)"%")) {
                expanded.add(expansion);
                continue;
            }
            expanded.add(a);
        }
        return expanded;
    }

    public static List<String> expandSubstitutionSyntax(List<String> templateArgs, List<String> expansion) {
        throw new NotYetImplementedException();
    }

    @EmbeddableMain
    public static void simpleMainBodyOnArgsOrStdinLines(String[] args, FunctionalInterfacesThrowingCheckedExceptionsStandard.UnaryProcedureThrowingIOException<String> process) throws IOException {
        ConsoleUtilities.simpleMainBodyOnArgsOrStdinLines(CollectionUtilities.asList(args), process);
    }

    @EmbeddableMain
    public static void simpleMainBodyOnArgsOrStdinLines(Collection<String> args, FunctionalInterfacesThrowingCheckedExceptionsStandard.UnaryProcedureThrowingIOException<String> process) throws IOException {
        if (args.isEmpty()) {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while ((line = in.readLine()) != null) {
                process.f(line);
            }
        } else {
            for (String line : args) {
                process.f(line);
            }
        }
    }

    @UnembeddableMain
    public static void simpleMainEndingWithSystemExitOnArgsOrStdinLines(String[] args, FunctionalInterfacesThrowingCheckedExceptionsStandard.UnaryProcedureThrowingIOException<String> process) {
        ConsoleUtilities.simpleMainEndingWithSystemExitOnArgsOrStdinLines(CollectionUtilities.asList(args), process);
    }

    @UnembeddableMain
    public static void simpleMainEndingWithSystemExitOnArgsOrStdinLines(Collection<String> args, FunctionalInterfacesThrowingCheckedExceptionsStandard.UnaryProcedureThrowingIOException<String> process) {
        ConsoleUtilities.mainWithErrorPrinting(() -> ConsoleUtilities.simpleMainBodyOnArgsOrStdinLines(args, process));
    }

    @UnembeddableMain
    public static void simpleMainEndingWithSystemExitOnArgsOrStdinLinesAllAtOnce(String[] args, FunctionalInterfacesThrowingCheckedExceptionsStandard.UnaryProcedureThrowingIOException<List<String>> process) {
        ConsoleUtilities.simpleMainEndingWithSystemExitOnArgsOrStdinLinesAllAtOnce(CollectionUtilities.asList(args), process);
    }

    @UnembeddableMain
    public static void simpleMainEndingWithSystemExitOnArgsOrStdinLinesAllAtOnce(Collection<String> args, FunctionalInterfacesThrowingCheckedExceptionsStandard.UnaryProcedureThrowingIOException<List<String>> process) {
        ConsoleUtilities.mainWithErrorPrinting(() -> {
            ArrayList accumulator = new ArrayList();
            ConsoleUtilities.simpleMainBodyOnArgsOrStdinLines(args, accumulator::add);
            process.f(accumulator);
        });
    }

    public static void performLengthyOperationWithProgressDisplay(@Nonnull FunctionInterfaces.UnaryProcedure<FunctionInterfaces.UnaryProcedure<Double>> operationThatAcceptsProgressNotifee) {
        ConsoleUtilities.performLengthyOperationWithProgressDisplay("", operationThatAcceptsProgressNotifee);
    }

    public static void performLengthyOperationWithProgressDisplay(@Nonnull String prefix, @Nonnull FunctionInterfaces.UnaryProcedure<FunctionInterfaces.UnaryProcedure<Double>> operationThatAcceptsProgressNotifee) {
        ConsoleUtilities.performLengthyOperationWithProgressDisplay(prefix, 30000L, operationThatAcceptsProgressNotifee);
    }

    public static void performLengthyOperationWithProgressDisplay(@Nonnull String prefix, long updateMaxIntervalMS, @Nonnull FunctionInterfaces.UnaryProcedure<FunctionInterfaces.UnaryProcedure<Double>> operationThatAcceptsProgressNotifee) {
        long startMSUX = System.currentTimeMillis();
        System.out.println(String.valueOf(prefix) + "Starting at: " + FormattingUtilities.formatTimestampRPStandardMillisUTC(startMSUX));
        SimpleContainers.SimpleLongContainer lastUpdateMSUX_C = new SimpleContainers.SimpleLongContainer(startMSUX);
        FunctionInterfaces.BinaryProcedure<Double, Boolean> notifee = (progress, force) -> {
            long now = System.currentTimeMillis();
            long last = lastUpdateMSUX_C.get();
            if (force.booleanValue() || now - last >= updateMaxIntervalMS) {
                if (progress == 0.0 || now == startMSUX) {
                    System.out.println(String.valueOf(prefix) + "    " + FormattingUtilities.fixdec(progress * 100.0, 2) + "%   (" + FormattingUtilities.formatFixedPointDecimalBase10(now - startMSUX, 3) + "s elapsed)");
                } else {
                    double averageRateMSPerUnit = (double)(now - startMSUX) / progress;
                    double etaDurationMS = (1.0 - progress) * averageRateMSPerUnit;
                    long etaMSUX = Math.round((double)now + etaDurationMS);
                    System.out.println(String.valueOf(prefix) + "    " + FormattingUtilities.fixdec(progress * 100.0, 2) + "%   (" + FormattingUtilities.formatFixedPointDecimalBase10(now - startMSUX, 3) + "s elapsed, " + FormattingUtilities.formatFixedPointDecimalBase10(Math.round(etaDurationMS), 3) + "s eta at " + FormattingUtilities.formatTimestampRPStandardMillisUTC(etaMSUX) + ")");
                }
                lastUpdateMSUX_C.set(now);
            }
        };
        notifee.f(0.0, true);
        operationThatAcceptsProgressNotifee.f(progress -> notifee.f((Double)progress, false));
        notifee.f(1.0, true);
        long endMSUX = System.currentTimeMillis();
        System.out.println(String.valueOf(prefix) + "Finished at: " + FormattingUtilities.formatTimestampRPStandardMillisUTC(endMSUX));
        System.out.println(String.valueOf(prefix) + "Took: " + FormattingUtilities.formatFixedPointDecimalBase10(endMSUX - startMSUX, 3) + "s");
    }

    public static ParsedArgs<Map<String, Object>> parseArgsStateless(String[] args) throws TextSyntaxException {
        return ConsoleUtilities.parseArgsStateless(CollectionUtilities.asList(args));
    }

    public static ParsedArgs<Map<String, Object>> parseArgsStateless(List<String> args) throws TextSyntaxException {
        ArrayList<String> targets = new ArrayList<String>();
        StatelessArgsOptionsBuilder options = new StatelessArgsOptionsBuilder();
        int n = args.size();
        int i = 0;
        while (i < n) {
            boolean deset;
            int start;
            String arg = args.get(i);
            if (BasicObjectUtilities.eq((Object)arg, (Object)"--")) {
                ++i;
                break;
            }
            if (BasicObjectUtilities.eq((Object)arg, (Object)"--~~")) {
                options.removeEVERYTHING();
            } else if (arg.startsWith("--~~")) {
                start = 4;
                if (StringUtilities.contains(arg, '=')) {
                    throw TextSyntaxException.inst("Can't have an equals sign in a full-resetting arg!: " + arg);
                }
                int colonPos = arg.indexOf(58);
                String name = colonPos == -1 ? arg.substring(start) : arg.substring(start, colonPos);
                String key = colonPos == -1 ? null : arg.substring(colonPos + 1);
                name = StringUtilities.descapeASCIIPercentSignSyntax(name);
                String string = key = key == null ? null : StringUtilities.descapeASCIIPercentSignSyntax(key);
                if (key == null) {
                    options.removeAll(name);
                } else {
                    options.removeAllInMap(name, key);
                }
            } else if (arg.startsWith("--")) {
                int equalsPos;
                deset = arg.startsWith("--~");
                int start2 = deset ? 3 : 2;
                int colonPos = arg.indexOf(58);
                int n2 = equalsPos = colonPos == -1 ? arg.indexOf(61) : arg.indexOf(61, colonPos + 1);
                if (colonPos != -1 && equalsPos == -1) {
                    throw TextSyntaxException.inst("Can't have a colon arg without an equals sign after it!");
                }
                String name = colonPos == -1 ? (equalsPos == -1 ? arg.substring(start2) : arg.substring(start2, equalsPos)) : arg.substring(start2, colonPos);
                String key = colonPos == -1 ? null : arg.substring(colonPos + 1, equalsPos);
                String value = equalsPos == -1 ? null : arg.substring(equalsPos + 1);
                WidespreadTestingUtilities.asrt(name != null);
                if (key != null) {
                    WidespreadTestingUtilities.asrt(value != null);
                }
                name = StringUtilities.descapeASCIIPercentSignSyntax(name);
                key = key == null ? null : StringUtilities.descapeASCIIPercentSignSyntax(key);
                String string = value = value == null ? null : StringUtilities.descapeASCIIPercentSignSyntax(value);
                if (key == null) {
                    if (value == null) {
                        options.gotFlagType(name, deset);
                    } else {
                        options.gotListType(name, value, deset);
                    }
                } else {
                    WidespreadTestingUtilities.asrt(value != null);
                    options.gotMapType(name, key, value, deset);
                }
            } else if (arg.startsWith("-~~")) {
                start = 3;
                String them = StringUtilities.descapeASCIIPercentSignSyntax(arg.substring(start));
                int nn = them.length();
                int ii = 0;
                while (ii < nn) {
                    String it = String.valueOf(them.charAt(ii));
                    options.removeAll(it);
                    ++ii;
                }
            } else if (arg.startsWith("-")) {
                deset = arg.startsWith("-~");
                int start3 = deset ? 2 : 1;
                String them = StringUtilities.descapeASCIIPercentSignSyntax(arg.substring(start3));
                int nn = them.length();
                int ii = 0;
                while (ii < nn) {
                    String it = String.valueOf(them.charAt(ii));
                    options.gotFlagType(it, deset);
                    ++ii;
                }
            } else {
                targets.add(arg);
            }
            ++i;
        }
        targets.addAll(args.subList(i, n));
        return new ParsedArgs<Map<String, Object>>(options.getOptions(), targets);
    }

    public static boolean optionsHasFlagRemoving(@WritableValue Map<String, Object> options, String name) throws GenericDataStructuresFormatException {
        Object v = options.remove(name);
        if (v == null) {
            return false;
        }
        if (v instanceof Integer) {
            return true;
        }
        throw new GenericDataStructuresFormatException("Expected a flag-type argument for: " + name);
    }

    public static class ParsedArgs<Options> {
        @ReadonlyValue
        public final Options options;
        @ReadonlyValue
        public final List<String> targets;

        public ParsedArgs(Options options, List<String> targets) {
            this.options = options;
            this.targets = targets;
        }
    }

    public static class StatelessArgsOptionsBuilder {
        Map<String, Object> options = new HashMap<String, Object>();

        public void gotFlagType(String name, boolean deset) throws TextSyntaxException {
            Object current = this.options.get(name);
            if (current == null || current instanceof Integer) {
                int currentValue = current == null ? 0 : (Integer)current;
                int newValue = currentValue + (deset ? -1 : 1);
                if (newValue == 0) {
                    this.options.remove(name);
                } else {
                    this.options.put(name, newValue);
                }
            } else if (current instanceof List && deset) {
                List currentValue = (List)current;
                currentValue.remove(currentValue.size() - 1);
                if (currentValue.isEmpty()) {
                    this.options.remove(name);
                }
            } else {
                throw TextSyntaxException.inst("Mixing types isn't allowed!  (Mixed a non-flag with a flag on " + StringUtilities.repr(name) + ")");
            }
        }

        public void gotListType(String name, String value, boolean deset) throws TextSyntaxException {
            Object current = this.options.get(name);
            if (current == null) {
                if (!deset) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(value);
                    this.options.put(name, list);
                }
            } else if (current instanceof List) {
                List currentValue = (List)current;
                if (deset) {
                    currentValue.remove(value);
                    if (currentValue.isEmpty()) {
                        this.options.remove(name);
                    }
                } else {
                    currentValue.add(value);
                }
            } else {
                throw TextSyntaxException.inst("Mixing types isn't allowed!  (Mixed a non-list with a list on " + StringUtilities.repr(name) + ")");
            }
        }

        public void gotMapType(String name, String key, String value, boolean deset) throws TextSyntaxException {
            Object current = this.options.get(name);
            if (current == null) {
                if (!deset) {
                    HashMap map = new HashMap();
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(value);
                    map.put(key, list);
                    this.options.put(name, map);
                }
            } else if (current instanceof Map) {
                Map currentValue = (Map)current;
                if (deset) {
                    List list = (List)currentValue.get(key);
                    if (list != null) {
                        list.remove(value);
                    }
                    if (list != null && list.isEmpty()) {
                        currentValue.remove(key);
                    }
                    if (currentValue.isEmpty()) {
                        this.options.remove(name);
                    }
                } else {
                    CollectionUtilities.getOrCreate(currentValue, key, ArrayList::new).add(value);
                }
            } else {
                throw TextSyntaxException.inst("Mixing types isn't allowed!  (Mixed a non-map with a map on " + StringUtilities.repr(name) + ")");
            }
        }

        public void removeAllInMap(String name, String key) {
            Object current = this.options.get(name);
            if (current != null) {
                if (current instanceof Map) {
                    Map currentValue = (Map)current;
                    currentValue.remove(key);
                    if (currentValue.isEmpty()) {
                        this.options.remove(name);
                    }
                } else {
                    throw TextSyntaxException.inst("Mixing types isn't allowed!  (Mixed a non-map with a map on " + StringUtilities.repr(name) + ")");
                }
            }
        }

        public void removeAll(String name) {
            this.options.remove(name);
        }

        public void removeEVERYTHING() {
            this.options.clear();
        }

        public Map<String, Object> getOptions() {
            return this.options;
        }
    }
}

