/*
 * Decompiled with CFR 0.152.
 */
package rebound.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionPrettyPrintingUtilities {
    public static void printStackTraceCompletely(Throwable t) {
        System.err.print(ExceptionPrettyPrintingUtilities.getNicelyFormattedStandardStacktrace(t));
    }

    public static String getNicelyFormattedStandardStacktrace(StackTraceElement[] stackTrace) {
        return ExceptionPrettyPrintingUtilities.getNicelyFormattedStandardStacktrace(stackTrace, "\t");
    }

    public static String getNicelyFormattedStandardStacktrace(StackTraceElement[] stackTrace, String indentation) {
        StringBuilder b = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            b.append(indentation);
            b.append("at ");
            b.append(e);
            b.append('\n');
            ++n2;
        }
        return b.toString();
    }

    public static String getNicelyFormattedStandardStacktrace(Throwable t) {
        StringBuilder buff = new StringBuilder();
        buff.append(t.getClass().getName());
        String m = t.getLocalizedMessage();
        if (m != null) {
            buff.append(": ");
            buff.append(m);
        }
        buff.append('\n');
        buff.append(ExceptionPrettyPrintingUtilities.getNicelyFormattedStandardStacktrace(t.getStackTrace(), "\t"));
        Throwable cause = t.getCause();
        while (cause != null) {
            buff.append("Caused by: ");
            buff.append(cause.getClass().getName());
            String m2 = cause.getLocalizedMessage();
            if (m2 != null) {
                buff.append(": ");
                buff.append(m2);
            }
            buff.append('\n');
            buff.append(ExceptionPrettyPrintingUtilities.getNicelyFormattedStandardStacktrace(cause.getStackTrace(), "\t"));
            cause = cause.getCause();
        }
        return buff.toString();
    }

    public static String getNicelyFormattedStandardStacktraceOfCurrentStack() {
        StackTraceElement[] currentStack = Thread.currentThread().getStackTrace();
        return ExceptionPrettyPrintingUtilities.getNicelyFormattedStandardStacktrace(currentStack);
    }

    public static String getNicelyFormattedStandardStacktraceFromThrowableImplementation(Throwable t) {
        StringWriter b = new StringWriter();
        t.printStackTrace(new PrintWriter(b));
        return b.toString();
    }
}

