/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray.template;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import rebound.exceptions.TextSyntaxException;
import rebound.jagent.lib.Cursor;
import rebound.jagent.lib.pray.template.FileBlockInPrayTemplate;
import rebound.jagent.lib.pray.template.Group;
import rebound.jagent.lib.pray.template.PrayTemplate;
import rebound.text.StringUtilities;
import rebound.util.Either;

public class TemplateParser {
    protected Reader in;
    protected PrayTemplate template;
    private static final int TAG_NONE = 0;
    private static final int TAG_GROUP = 1;
    private static final int TAG_INLINE = 2;

    public void parse() throws IOException {
        int b;
        Cursor c = new Cursor();
        this.template = new PrayTemplate();
        ArrayList<Group> groups = new ArrayList<Group>();
        this.discardLine(c);
        boolean lastWasCS = false;
        char curr = '\u0000';
        int tagPos = 0;
        int tagType = 0;
        Group currGroup = null;
        String k = null;
        Either<Integer, String> v = null;
        while ((b = this.in.read()) != -1) {
            curr = (char)b;
            c.advance();
            if (lastWasCS && curr == '-') {
                this.finishComment(c);
                lastWasCS = false;
                continue;
            }
            lastWasCS = false;
            if (curr == '\"') {
                k = this.readSpontaneousQuoted(c);
                v = this.readKnownTagVal(c);
                if (currGroup == null) continue;
                if (k.startsWith("Script ") && k.length() > "Script ".length() && !k.substring("Script ".length()).equalsIgnoreCase("Count")) {
                    if (v.getValueIfB() == null) continue;
                    currGroup.addScript(v.getValueIfB());
                    continue;
                }
                if (k.equals("Script Count")) continue;
                currGroup.addTag(k, v);
                continue;
            }
            if (curr == 'g' || curr == 'G') {
                tagPos = 0;
                tagType = 1;
                continue;
            }
            if (!(curr != 'i' && curr != 'I' || tagType == 2 && tagPos == 2)) {
                tagPos = 0;
                tagType = 2;
                continue;
            }
            if (tagType == 1 && (curr == 'r' || curr == 'R' && tagPos == 0) || curr == 'o' || curr == 'O' && tagPos == 1 || curr == 'u' || curr == 'U' && tagPos == 2 || curr == 'p' || curr == 'P' && tagPos == 3) {
                ++tagPos;
                continue;
            }
            if (tagType == 1 && curr == ' ' && tagPos == 4) {
                currGroup = new Group();
                groups.add(currGroup);
                this.readGroupTag(currGroup, c);
                continue;
            }
            if (tagType == 2 && (curr == 'n' || curr == 'N' && tagPos == 0) || curr == 'l' || curr == 'L' && tagPos == 1 || curr == 'i' || curr == 'I' && tagPos == 2 || curr == 'n' || curr == 'N' && tagPos == 3 || curr == 'e' || curr == 'E' && tagPos == 4) {
                ++tagPos;
                continue;
            }
            if (tagType == 2 && curr == ' ' && tagPos == 5) {
                this.readInlineTag(this.template, c);
                continue;
            }
            tagType = 0;
            tagPos = 0;
        }
        this.template.groups = groups;
    }

    protected void discardLine(Cursor c) throws IOException {
        char curr;
        do {
            int i;
            if ((i = this.in.read()) == -1) {
                return;
            }
            curr = (char)i;
            c.advance();
        } while (curr != '\r' && curr != '\n');
    }

    protected void finishComment(Cursor c) throws IOException {
        char curr = '\u0000';
        char[] currBuff = new char[1];
        boolean lastWasDash = false;
        while (this.in.read(currBuff) == 1) {
            curr = currBuff[0];
            c.advance();
            if (curr == '-') {
                lastWasDash = true;
                continue;
            }
            if (curr != ')' || !lastWasDash) continue;
            return;
        }
    }

    protected Either<Integer, String> readKnownTagVal(Cursor c) throws IOException {
        boolean stringVal = true;
        boolean inTheQuotes = false;
        boolean lastWasCS = false;
        boolean lastWasEscape = false;
        char curr = '\u0000';
        char[] currBuff = new char[1];
        StringBuilder string = new StringBuilder();
        while (this.in.read(currBuff) == 1) {
            c.advance();
            curr = currBuff[0];
            if (stringVal && !inTheQuotes && lastWasCS && curr == '-') {
                this.finishComment(c);
                lastWasCS = false;
                continue;
            }
            if (lastWasCS) {
                lastWasCS = false;
            }
            if (!stringVal && curr != '0' && curr != '1' && curr != '2' && curr != '3' && curr != '4' && curr != '5' && curr != '6' && curr != '7' && curr != '8' && curr != '9') {
                return Either.forA(Integer.parseInt(string.toString()));
            }
            if (!inTheQuotes && curr == '\"') {
                inTheQuotes = true;
                continue;
            }
            if (!(inTheQuotes || curr != '0' && curr != '1' && curr != '2' && curr != '3' && curr != '4' && curr != '5' && curr != '6' && curr != '7' && curr != '8' && curr != '9')) {
                stringVal = false;
                string.append(curr);
                continue;
            }
            if (inTheQuotes && lastWasEscape) {
                if (curr == 'n') {
                    string.append('\n');
                } else if (curr == 'r') {
                    string.append('\r');
                } else if (curr == 't') {
                    string.append('\t');
                } else {
                    string.append(curr);
                }
                lastWasEscape = false;
                continue;
            }
            if (!inTheQuotes) continue;
            if (curr == '\\') {
                lastWasEscape = true;
                continue;
            }
            if (curr == '\"') {
                return Either.forB(string.toString());
            }
            string.append(curr);
        }
        return stringVal ? Either.forB(string.toString()) : Either.forA(Integer.parseInt(string.toString()));
    }

    protected String readKnownQuoted(Cursor c) throws IOException {
        return this.readKnownQuotedOrWord(c, false).getValueIfA();
    }

    @Nonnull
    protected Either<String, String> readKnownQuotedOrWord(Cursor c, boolean allowUnquotedToken) throws IOException {
        boolean inTheQuotes = false;
        boolean unquoted = false;
        boolean lastWasCS = false;
        boolean lastWasEscape = false;
        char curr = '\u0000';
        StringBuilder string = new StringBuilder();
        while (true) {
            int i;
            if ((i = this.in.read()) == -1) {
                if (inTheQuotes) {
                    throw TextSyntaxException.inst("Premature EOF, expected ending double-quote!");
                }
                if (unquoted) {
                    return Either.forB(string.toString());
                }
                throw TextSyntaxException.inst("Premature EOF, expected " + (allowUnquotedToken ? "either an unquoted token or a double-quoted string" : "a double-quoted string") + "!");
            }
            curr = (char)i;
            c.advance();
            if (!inTheQuotes && lastWasCS && curr == '-') {
                this.finishComment(c);
                lastWasCS = false;
                continue;
            }
            if (lastWasCS) {
                lastWasCS = false;
            }
            if (!inTheQuotes) {
                if (curr == '\"') {
                    inTheQuotes = true;
                    continue;
                }
                if (Character.isWhitespace(curr)) continue;
                if (allowUnquotedToken) {
                    unquoted = true;
                    string.append(curr);
                    continue;
                }
                throw TextSyntaxException.inst("Unexpected double-quote was none was expected!: " + StringUtilities.repr(Character.valueOf(curr)));
            }
            if (unquoted) {
                if (Character.isWhitespace(curr)) {
                    return Either.forB(string.toString());
                }
                if (curr == '\"') {
                    throw TextSyntaxException.inst("Unexpected character where double-quote was expected!: " + StringUtilities.repr(Character.valueOf(curr)));
                }
                string.append(curr);
                continue;
            }
            if (inTheQuotes && lastWasEscape) {
                if (curr == 'n') {
                    string.append('\n');
                    continue;
                }
                if (curr == 'r') {
                    string.append('\r');
                    continue;
                }
                if (curr == 't') {
                    string.append('\t');
                    continue;
                }
                string.append(curr);
                continue;
            }
            if (!inTheQuotes) continue;
            if (curr == '\\') {
                lastWasEscape = true;
                continue;
            }
            if (curr == '\"') {
                return Either.forA(string.toString());
            }
            string.append(curr);
        }
    }

    @Nonnull
    protected String readUnquotedToken(Cursor c) throws IOException {
        char curr = '\u0000';
        StringBuilder string = new StringBuilder();
        int i;
        while ((i = this.in.read()) != -1) {
            curr = (char)i;
            c.advance();
            if (Character.isWhitespace(curr)) {
                return string.toString();
            }
            if (curr == '\"') {
                throw TextSyntaxException.inst("Unexpected double-quote where none was expected!   (Text so far: " + StringUtilities.repr(string.toString()) + ")");
            }
            string.append(curr);
        }
        return string.toString();
    }

    protected String readSpontaneousQuoted(Cursor c) throws IOException {
        boolean lastWasEscape = false;
        char curr = '\u0000';
        StringBuilder string = new StringBuilder();
        char[] currBuff = new char[1];
        while (this.in.read(currBuff) == 1) {
            curr = currBuff[0];
            c.advance();
            if (lastWasEscape) {
                if (curr == 'n') {
                    string.append('\n');
                    continue;
                }
                if (curr == 'r') {
                    string.append('\r');
                    continue;
                }
                if (curr == 't') {
                    string.append('\t');
                    continue;
                }
                string.append(curr);
                continue;
            }
            if (curr == '\\') {
                lastWasEscape = true;
                continue;
            }
            if (curr == '\"') {
                return string.toString();
            }
            string.append(curr);
        }
        return string.toString();
    }

    protected void readGroupTag(Group g, Cursor c) throws IOException {
        char[] id = new char[4];
        this.in.read(id);
        c.advance(4);
        g.ID = new String(id);
        g.name = this.readKnownQuoted(c);
    }

    protected void readInlineTag(PrayTemplate template, Cursor c) throws IOException {
        String id;
        boolean archiveFormatInPray;
        String f = this.readUnquotedToken(c);
        if (f.equalsIgnoreCase("archive")) {
            archiveFormatInPray = true;
            id = this.readUnquotedToken(c);
        } else {
            archiveFormatInPray = false;
            id = f;
        }
        byte[] idBytes = StringUtilities.encodeTextToByteArrayReportingUnchecked(id, StandardCharsets.ISO_8859_1);
        if (idBytes.length != 4) {
            throw TextSyntaxException.inst("PRAY Chunk block type id's (eg, FILE, PHOT, GENE, CREA, etc.) must always be four bytes!");
        }
        String realFilename = this.readKnownQuoted(c);
        String prayFilename = this.readKnownQuoted(c);
        template.getFileBlocks().add(new FileBlockInPrayTemplate(realFilename, idBytes, prayFilename, archiveFormatInPray));
    }

    public void setContext(File prayfile) {
        this.template.setDir(prayfile.getAbsoluteFile().getParentFile());
    }

    public PrayTemplate getTemplate() {
        return this.template;
    }

    public Reader getIn() {
        return this.in;
    }

    public void setIn(Reader in) {
        this.in = in;
    }

    public void setIn(InputStream in) {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        this.setIn(new InputStreamReader(in, decoder));
    }
}

