/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray.blocks.parsers;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import javax.annotation.Nullable;
import rebound.io.util.JRECompatIOUtilities;
import rebound.jagent.lib.PathBoss;
import rebound.jagent.lib.archive.CreaturesArchiveFormat;
import rebound.jagent.lib.pray.BlockHeader;
import rebound.jagent.lib.pray.JagentRecognizedPrayChunkBlockIds;
import rebound.jagent.lib.pray.blocks.BlockParser;
import rebound.jagent.lib.pray.template.FileBlockInPrayTemplate;
import rebound.jagent.lib.pray.template.PrayTemplate;

public class FileBlockParser
implements BlockParser {
    @Override
    public void parseBlock(BlockHeader b, InputStream data, PrayTemplate template) throws IOException {
        byte[] archiveMagic = CreaturesArchiveFormat.HEADER;
        PushbackInputStream s = new PushbackInputStream(data, archiveMagic.length);
        byte[] c = JRECompatIOUtilities.readAsMuchAsPossibleToNew(s, archiveMagic.length);
        boolean archive = Arrays.equals(c, archiveMagic);
        s.unread(c);
        data = s;
        File file = null;
        String preferredFilename = null;
        preferredFilename = b.getName();
        JagentRecognizedPrayChunkBlockIds id = JagentRecognizedPrayChunkBlockIds.lookup(b.getId());
        if (id == JagentRecognizedPrayChunkBlockIds.PHOT && preferredFilename.endsWith(".photo")) {
            preferredFilename = String.valueOf(preferredFilename.substring(0, preferredFilename.length() - ".photo".length())) + ".s16";
        }
        if (id == JagentRecognizedPrayChunkBlockIds.GENE && preferredFilename.endsWith(".genetics")) {
            preferredFilename = String.valueOf(preferredFilename.substring(0, preferredFilename.length() - ".genetics".length())) + ".gen";
        }
        if (id == JagentRecognizedPrayChunkBlockIds.CREA && preferredFilename.endsWith(".creature")) {
            preferredFilename = String.valueOf(preferredFilename.substring(0, preferredFilename.length() - ".creature".length())) + ".crea";
        }
        if (id == JagentRecognizedPrayChunkBlockIds.GLST && preferredFilename.endsWith(".glist.creature")) {
            preferredFilename = String.valueOf(preferredFilename.substring(0, preferredFilename.length() - ".glist.creature".length())) + ".glist";
        }
        preferredFilename = PathBoss.getInstance().getEscapedNameOnCurrentHostOS(preferredFilename);
        file = new File(template.getDir(), preferredFilename);
        if (file.exists()) {
            System.err.println("Warning: Possible PRAY Violation (duplicate inline file): Inline file \"" + b.getName() + "\" exists: " + file.getAbsolutePath());
            String pre = null;
            String post = null;
            String d = file.getParent();
            String n = file.getName();
            int ep = n.lastIndexOf(46);
            if (ep == -1) {
                pre = file.getPath();
                post = "";
            } else {
                pre = new File(d, n.substring(0, ep)).getPath();
                post = n.substring(ep);
            }
            File f = null;
            int i = 2;
            do {
                f = new File(String.valueOf(pre) + " (" + i + ")" + post);
                if (++i < 65536) continue;
                throw new IOException("Seriously?! How many files do you have?   {" + b.getName() + "," + file.getAbsolutePath() + "}");
            } while (f.exists());
            file = f;
        }
        long fileLength = b.isCompressed() ? b.getOriginalLength() : b.getLengthInFile();
        Throwable throwable = null;
        Object var9_11 = null;
        try (FileOutputStream fileout = new FileOutputStream(file);){
            if (archive) {
                CreaturesArchiveFormat.uncompress(data, fileout);
            } else {
                long actual = JRECompatIOUtilities.pumpFixed(data, (OutputStream)fileout, fileLength);
                if (actual < fileLength) {
                    throw new EOFException("Premature EOF detected in " + b.getIdTextBestEffort() + " block \"" + b.getName() + "\", correct length is specified to be " + fileLength + ", actual length in file is " + actual + ".    Most likely the file was truncated somehow (eg, incomplete download).");
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        template.getFileBlocks().add(new FileBlockInPrayTemplate(file.getName(), b.getId(), b.getName(), archive));
    }

    @Override
    public boolean canHandle(BlockHeader b) {
        return true;
    }

    public static boolean isNormalFileTypeBlock(@Nullable JagentRecognizedPrayChunkBlockIds id) {
        return id == JagentRecognizedPrayChunkBlockIds.FILE || id == JagentRecognizedPrayChunkBlockIds.GENE || id == JagentRecognizedPrayChunkBlockIds.PHOT;
    }
}

