/*
 * Decompiled with CFR 0.152.
 */
package from.java.io.forr.rebound.io.iio;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.concurrent.NotThreadSafe;
import rebound.annotations.semantic.reachability.LiveValue;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.io.iio.OutputByteStream;
import rebound.io.iio.unions.CloseableFlushableOutputByteStreamInterface;
import rebound.util.collections.prim.PrimitiveCollections;

@NotThreadSafe
public class ByteListOutputByteStream
extends OutputStream
implements CloseableFlushableOutputByteStreamInterface {
    protected PrimitiveCollections.ByteList buf;

    public ByteListOutputByteStream() {
        this(32);
    }

    public ByteListOutputByteStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new PrimitiveCollections.ByteArrayList(size);
    }

    @Override
    public void write(int b) {
        this.buf.addByte((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.buf.addAllBytes(b, off, len);
    }

    public void writeTo(OutputByteStream out) throws IOException {
        out.write(this.buf);
    }

    public void reset() {
        this.buf.clear();
    }

    @ThrowAwayValue
    public byte[] toByteArray() {
        return this.buf.toByteArray();
    }

    @ThrowAwayValue
    public PrimitiveCollections.ByteList toByteList() {
        return this.buf.clone();
    }

    @LiveValue
    public PrimitiveCollections.ByteList getByteListLive() {
        return this.buf;
    }

    public int size() {
        return this.buf.size();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }
}

