/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.util.List;
import java.util.ListIterator;

public class DelegatingListIterator<E>
implements ListIterator<E> {
    protected final List<E> underlying;
    protected int cursor;
    protected boolean forwardLooking = true;
    protected boolean modificationUsedUpOrUninitialized = true;

    public DelegatingListIterator(List<E> underlying, int cursor) {
        this.underlying = underlying;
        this.cursor = cursor;
    }

    public DelegatingListIterator(List<E> underlying) {
        this(underlying, 0);
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.underlying.size();
    }

    @Override
    public E next() {
        E e = this.underlying.get(this.cursor);
        ++this.cursor;
        this.forwardLooking = true;
        this.modificationUsedUpOrUninitialized = false;
        return e;
    }

    @Override
    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    @Override
    public E previous() {
        E e = this.underlying.get(this.cursor - 1);
        --this.cursor;
        this.forwardLooking = false;
        this.modificationUsedUpOrUninitialized = false;
        return e;
    }

    @Override
    public int nextIndex() {
        return this.cursor;
    }

    @Override
    public int previousIndex() {
        return this.cursor - 1;
    }

    @Override
    public void remove() {
        if (this.modificationUsedUpOrUninitialized) {
            throw new IllegalStateException();
        }
        this.underlying.remove(this.forwardLooking ? this.cursor - 1 : this.cursor);
        if (this.forwardLooking) {
            --this.cursor;
        }
        this.modificationUsedUpOrUninitialized = true;
    }

    @Override
    public void set(E e) {
        if (this.modificationUsedUpOrUninitialized) {
            throw new IllegalStateException();
        }
        this.underlying.set(this.forwardLooking ? this.cursor - 1 : this.cursor, e);
        this.modificationUsedUpOrUninitialized = true;
    }

    @Override
    public void add(E e) {
        if (this.modificationUsedUpOrUninitialized) {
            throw new IllegalStateException();
        }
        this.underlying.add(this.forwardLooking ? this.cursor - 1 : this.cursor, e);
        if (this.forwardLooking) {
            ++this.cursor;
        }
        this.modificationUsedUpOrUninitialized = true;
    }
}

