/*
 * Decompiled with CFR 0.152.
 */
package rebound.math;

import javax.annotation.concurrent.Immutable;
import rebound.exceptions.OverflowException;
import rebound.math.Direction1D;

@Immutable
public class ArithmeticIntegerInterval {
    protected final long start;
    protected final long size;

    public ArithmeticIntegerInterval(long start, long size) {
        this.start = start;
        this.size = size;
        if (size < 0L) {
            throw new OverflowException();
        }
        if (start + size < start) {
            throw new OverflowException();
        }
    }

    public long getStart() {
        return this.start;
    }

    public long getSize() {
        return this.size;
    }

    public long getPastEnd() {
        return this.start + this.size;
    }

    public boolean isEmpty() {
        return this.getSize() == 0L;
    }

    public boolean containsPoint(long value) {
        return (value -= this.start) >= 0L && value < this.size;
    }

    public Direction1D comparePoint(long value) {
        if ((value -= this.start) < 0L) {
            return Direction1D.LowerDown;
        }
        if (value >= this.size) {
            return Direction1D.HigherUp;
        }
        return Direction1D.Zero;
    }

    public ArithmeticIntegerInterval subinterval(long start, long size) {
        if (size < 0L) {
            throw new IllegalArgumentException();
        }
        if (start < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (start + size > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (start == 0L && size == this.getSize()) {
            return this;
        }
        return new ArithmeticIntegerInterval(this.start + start, size);
    }

    public ArithmeticIntegerInterval subintervalByExclusiveBound(long start, long end) {
        return this.subinterval(start, end - start);
    }

    public ArithmeticIntegerInterval subintervalToEnd(long start) {
        return this.subinterval(start, this.size - start);
    }

    public ArithmeticIntegerInterval subintervalFromBeginning(long sizeOrExclusiveEndingBound) {
        return this.subinterval(0L, sizeOrExclusiveEndingBound);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArithmeticIntegerInterval other = (ArithmeticIntegerInterval)obj;
        if (this.isEmpty()) {
            return other.isEmpty();
        }
        if (other.isEmpty()) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        return this.start == other.start;
    }

    public String toString() {
        return "[" + this.getStart() + ", " + this.getPastEnd() + ")";
    }
}

