/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.uid;

import java.io.EOFException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.bits.Bytes;
import rebound.bits.DataEncodingUtilities;
import rebound.bits.InvalidInputCharacterException;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.TextSyntaxException;
import rebound.text.StringUtilities;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.uid.ClassUIDNotFoundException;
import rebound.util.uid.UID;

public class UIDUtilities {
    public static final FunctionInterfaces.UnaryFunctionCharToBoolean DelimiterPattern = c -> c == '-' || c == ' ' || c == ':' || c == '/' || c == ',';

    public static PrimitiveCollections.ImmutableByteArrayList parseAnnotation(@Nonnull UID uid) throws TextSyntaxException {
        Objects.requireNonNull(uid);
        return UIDUtilities.parseString(uid.value());
    }

    public static PrimitiveCollections.ImmutableByteArrayList parseString(@Nonnull String uidstr) throws TextSyntaxException {
        Objects.requireNonNull(uidstr);
        uidstr = StringUtilities.removeWhitespace(uidstr);
        if (!UIDUtilities.isEncodedUID(uidstr)) {
            throw TextSyntaxException.inst();
        }
        return UIDUtilities._parseStringNoCheck(uidstr);
    }

    @ImplementationTransparency
    public static PrimitiveCollections.ImmutableByteArrayList _parseStringNoCheck(@Nonnull String uidstr) {
        try {
            uidstr = StringUtilities.replaceCharsWithStringsByPattern(uidstr, DelimiterPattern, "");
            byte[] a = DataEncodingUtilities.decodeHexNoDelimiter(uidstr);
            return PrimitiveCollections.ImmutableByteArrayList.newLIVE(a);
        }
        catch (EOFException exc) {
            throw TextSyntaxException.inst(exc);
        }
        catch (InvalidInputCharacterException exc) {
            throw new ImpossibleException("But we validated it!!", exc);
        }
    }

    @ImplementationTransparency
    public static String formatString(@ReadonlyValue @Nonnull byte[] bytes) {
        Objects.requireNonNull(bytes);
        String s = DataEncodingUtilities.encodeHexNoDelimiter(bytes, 7);
        if (s.length() != bytes.length * 2) {
            throw new ImpossibleException();
        }
        return s;
    }

    @ImplementationTransparency
    public static String formatString(@Nonnull PrimitiveCollections.ImmutableByteArrayList bytes) {
        Objects.requireNonNull(bytes);
        return UIDUtilities.formatString(bytes.getREADONLYLiveWholeArrayBackingUNSAFE());
    }

    @Nullable
    public static PrimitiveCollections.ImmutableByteArrayList getClassUIDOrNull(@Nonnull Class c) {
        Objects.requireNonNull(c);
        UID uid = c.getAnnotation(UID.class);
        return uid != null ? UIDUtilities.parseAnnotation(uid) : null;
    }

    @Nonnull
    public static PrimitiveCollections.ImmutableByteArrayList getClassUIDOrFail(@Nonnull Class c) throws ClassUIDNotFoundException {
        Objects.requireNonNull(c);
        PrimitiveCollections.ImmutableByteArrayList uid = UIDUtilities.getClassUIDOrNull(c);
        if (uid == null) {
            throw new ClassUIDNotFoundException(c);
        }
        return uid;
    }

    @Nonnull
    public static Object getClassUIDOrName(@Nonnull Class c) {
        Objects.requireNonNull(c);
        PrimitiveCollections.ImmutableByteArrayList uid = UIDUtilities.getClassUIDOrNull(c);
        return uid != null ? uid : c.getName();
    }

    public static Map<PrimitiveCollections.ImmutableByteArrayList, Class> findClassUIDs(Iterable<Class> classes) {
        Objects.requireNonNull(classes);
        HashMap<PrimitiveCollections.ImmutableByteArrayList, Class> uidsToClasses = new HashMap<PrimitiveCollections.ImmutableByteArrayList, Class>();
        for (Class c : classes) {
            Objects.requireNonNull(c);
            UID uid = c.getAnnotation(UID.class);
            if (uid == null) continue;
            uidsToClasses.put(UIDUtilities.parseAnnotation(uid), c);
        }
        return uidsToClasses;
    }

    public static boolean isEncodedUID(@Nonnull String uidstr) {
        Objects.requireNonNull(uidstr);
        int n = uidstr.length();
        if (n % 2 != 0) {
            return false;
        }
        int i = 0;
        while (i < n) {
            char c = uidstr.charAt(i);
            boolean low = c >= 'a' && c <= 'f';
            boolean high = c >= 'A' && c <= 'F';
            boolean num = c >= '0' && c <= '9';
            boolean delimiter = DelimiterPattern.f(c);
            if (!(low || high || num || delimiter)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static UUID toUUID(PrimitiveCollections.ByteList bytes) {
        Objects.requireNonNull(bytes);
        if (bytes.size() != 16) {
            throw new IllegalArgumentException("A UUID is 16 bytes, we were given " + bytes.size());
        }
        return new UUID(Bytes.getBigLong(bytes, 0), Bytes.getBigLong(bytes, 8));
    }

    public static PrimitiveCollections.ImmutableByteArrayList fromUUID(UUID uuid) {
        Objects.requireNonNull(uuid);
        byte[] a = new byte[16];
        Bytes.putBigLong(a, 0, uuid.getMostSignificantBits());
        Bytes.putBigLong(a, 8, uuid.getLeastSignificantBits());
        return PrimitiveCollections.ImmutableByteArrayList.newLIVE(a);
    }
}

