/*
 * Decompiled with CFR 0.152.
 */
package rebound.dataformats.json;

import javax.annotation.concurrent.Immutable;
import rebound.annotations.semantic.operationspecification.HashableType;
import rebound.concurrency.immutability.StaticallyConcurrentlyImmutable;

@HashableType
@Immutable
public class JSONOptions
implements StaticallyConcurrentlyImmutable {
    protected final boolean jsonwcTypeCommentsSupported;
    protected final boolean tabsInStringsAllowed;
    protected final boolean multilineStringsAllowed;
    protected final boolean ucs4EscapesSupported;
    protected final boolean startingDigitlessNumbersAllowed;
    protected final boolean infinitiesSupported;
    protected final boolean nansSupported;
    protected final boolean extraneousCommasAllowed;
    protected final DecodeBigIntegersAs decodeBigIntegersAs;

    public static JSONOptions getJSONWCOptions(DecodeBigIntegersAs decodeBigIntegersAs) {
        return new JSONOptions(true, true, true, false, false, false, false, false, decodeBigIntegersAs);
    }

    public static JSONOptions getStandardOptions(DecodeBigIntegersAs decodeBigIntegersAs) {
        return new JSONOptions(false, false, false, false, false, false, false, false, decodeBigIntegersAs);
    }

    public boolean isAnyNonstandardOptionsSet() {
        return this.jsonwcTypeCommentsSupported || this.tabsInStringsAllowed || this.multilineStringsAllowed || this.ucs4EscapesSupported || this.startingDigitlessNumbersAllowed || this.infinitiesSupported || this.nansSupported || this.extraneousCommasAllowed;
    }

    public JSONOptions(boolean jsonwcTypeCommentsSupported, boolean tabsInStringsAllowed, boolean multilineStringsAllowed, boolean ucs4EscapesSupported, boolean startingDigitlessNumbersAllowed, boolean infinitiesSupported, boolean nansSupported, boolean extraneousCommasAllowed, DecodeBigIntegersAs decodeBigIntegersAs) {
        this.jsonwcTypeCommentsSupported = jsonwcTypeCommentsSupported;
        this.tabsInStringsAllowed = tabsInStringsAllowed;
        this.multilineStringsAllowed = multilineStringsAllowed;
        this.ucs4EscapesSupported = ucs4EscapesSupported;
        this.startingDigitlessNumbersAllowed = startingDigitlessNumbersAllowed;
        this.infinitiesSupported = infinitiesSupported;
        this.nansSupported = nansSupported;
        this.extraneousCommasAllowed = extraneousCommasAllowed;
        this.decodeBigIntegersAs = decodeBigIntegersAs;
    }

    public boolean isJsonwcTypeCommentsSupported() {
        return this.jsonwcTypeCommentsSupported;
    }

    public boolean isTabsInStringsAllowed() {
        return this.tabsInStringsAllowed;
    }

    public boolean isMultilineStringsAllowed() {
        return this.multilineStringsAllowed;
    }

    public boolean isUcs4EscapesSupported() {
        return this.ucs4EscapesSupported;
    }

    public boolean isStartingDigitlessNumbersAllowed() {
        return this.startingDigitlessNumbersAllowed;
    }

    public boolean isInfinitiesSupported() {
        return this.infinitiesSupported;
    }

    public boolean isNansSupported() {
        return this.nansSupported;
    }

    public boolean isExtraneousCommasAllowed() {
        return this.extraneousCommasAllowed;
    }

    public DecodeBigIntegersAs getDecodeBigIntegersAs() {
        return this.decodeBigIntegersAs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.decodeBigIntegersAs == null ? 0 : this.decodeBigIntegersAs.hashCode());
        result = 31 * result + (this.extraneousCommasAllowed ? 1231 : 1237);
        result = 31 * result + (this.infinitiesSupported ? 1231 : 1237);
        result = 31 * result + (this.jsonwcTypeCommentsSupported ? 1231 : 1237);
        result = 31 * result + (this.multilineStringsAllowed ? 1231 : 1237);
        result = 31 * result + (this.nansSupported ? 1231 : 1237);
        result = 31 * result + (this.startingDigitlessNumbersAllowed ? 1231 : 1237);
        result = 31 * result + (this.tabsInStringsAllowed ? 1231 : 1237);
        result = 31 * result + (this.ucs4EscapesSupported ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONOptions other = (JSONOptions)obj;
        if (this.decodeBigIntegersAs != other.decodeBigIntegersAs) {
            return false;
        }
        if (this.extraneousCommasAllowed != other.extraneousCommasAllowed) {
            return false;
        }
        if (this.infinitiesSupported != other.infinitiesSupported) {
            return false;
        }
        if (this.jsonwcTypeCommentsSupported != other.jsonwcTypeCommentsSupported) {
            return false;
        }
        if (this.multilineStringsAllowed != other.multilineStringsAllowed) {
            return false;
        }
        if (this.nansSupported != other.nansSupported) {
            return false;
        }
        if (this.startingDigitlessNumbersAllowed != other.startingDigitlessNumbersAllowed) {
            return false;
        }
        if (this.tabsInStringsAllowed != other.tabsInStringsAllowed) {
            return false;
        }
        return this.ucs4EscapesSupported == other.ucs4EscapesSupported;
    }

    public String toString() {
        return "JSONOptions [jsonwcTypeCommentsSupported=" + this.jsonwcTypeCommentsSupported + ", tabsInStringsAllowed=" + this.tabsInStringsAllowed + ", multilineStringsAllowed=" + this.multilineStringsAllowed + ", ucs4EscapesSupported=" + this.ucs4EscapesSupported + ", startingDigitlessNumbersAllowed=" + this.startingDigitlessNumbersAllowed + ", infinitiesSupported=" + this.infinitiesSupported + ", nansSupported=" + this.nansSupported + ", extraneousCommasAllowed=" + this.extraneousCommasAllowed + ", decodeBigIntegersAs=" + (Object)((Object)this.decodeBigIntegersAs) + "]";
    }

    public static enum DecodeBigIntegersAs {
        BigIntegers,
        FloatingPoints,
        SyntaxError;

    }
}

