/*
 * Decompiled with CFR 0.152.
 */
package rebound.io.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import javax.annotation.Nonnull;
import rebound.annotations.semantic.allowedoperations.FixedLengthValue;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.annotations.semantic.reachability.LiveValue;
import rebound.annotations.semantic.reachability.SnapshotValue;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.exceptions.OverflowException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.file.FSUtilities;
import rebound.io.ChannelProvider;
import rebound.io.util.BasicIOUtilities;
import rebound.io.util.JRECompatIOUtilities;
import rebound.io.util.TextIOUtilities;
import rebound.text.StringUtilities;
import rebound.text.encodings.detection.TextEncodingDetector;
import rebound.util.BufferAllocationType;
import rebound.util.PlatformNIOBufferUtilities;
import rebound.util.collections.ArrayUtilities;
import rebound.util.collections.Slice;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.collections.prim.RandomAccessFileBackedByteList;
import rebound.util.functional.FunctionInterfaces;

public class FSIOUtilities {
    public static long dumpFileToOutputStream(File f, OutputStream out) throws IOException {
        long total = 0L;
        FileInputStream in = new FileInputStream(f);
        try {
            total = JRECompatIOUtilities.pump((InputStream)in, out);
        }
        catch (IOException exc) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw exc;
        }
        in.close();
        return total;
    }

    @Nonnull
    public static byte[] readAll(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            byte[] byArray = JRECompatIOUtilities.readAll(in);
            return byArray;
        }
        finally {
            BasicIOUtilities.closeWithoutError(in);
        }
    }

    @Nonnull
    public static byte[] readAll(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            byte[] byArray = JRECompatIOUtilities.readAll(in);
            return byArray;
        }
        finally {
            BasicIOUtilities.closeWithoutError(in);
        }
    }

    @Nonnull
    public static ByteBuffer readAll(File file, BufferAllocationType allocationType) throws IOException {
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new OverflowException();
        }
        ByteBuffer buffer = PlatformNIOBufferUtilities.allocateByteBuffer((int)length, allocationType);
        FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.READ);
        try {
            while (buffer.hasRemaining()) {
                channel.write(buffer);
            }
        }
        catch (IOException exc) {
            BasicIOUtilities.closeWithoutError(channel);
            throw exc;
        }
        channel.close();
        return buffer;
    }

    @Nonnull
    @ThrowAwayValue
    public static byte[] readSome(File file, long start, int length) throws IOException {
        Throwable throwable = null;
        Object var5_5 = null;
        try (FileInputStream in = new FileInputStream(file);){
            if (start > 0L) {
                JRECompatIOUtilities.skipFully(in, start);
            }
            return JRECompatIOUtilities.readFullyToNew(in, length);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nonnull
    @SnapshotValue
    @WritableValue
    @FixedLengthValue
    public static PrimitiveCollections.ByteList readSomeToList(File file, long start, int length) throws IOException {
        return PrimitiveCollections.byteArrayAsList(FSIOUtilities.readSome(file, start, length));
    }

    @Nonnull
    @ThrowAwayValue
    public static byte[] readSome(File file, int length) throws IOException {
        return FSIOUtilities.readSome(file, 0L, length);
    }

    @Nonnull
    @SnapshotValue
    @WritableValue
    @FixedLengthValue
    public static PrimitiveCollections.ByteList readSomeToList(File file, int length) throws IOException {
        return FSIOUtilities.readSomeToList(file, 0L, length);
    }

    @Nonnull
    @SnapshotValue
    @WritableValue
    @FixedLengthValue
    public static PrimitiveCollections.ByteList readAllToList(File file) throws IOException {
        return PrimitiveCollections.byteArrayAsList(FSIOUtilities.readAll(file));
    }

    @Nonnull
    @LiveValue
    @WritableValue
    public static PrimitiveCollections.ByteList fileAsList(File file) throws IOException, UncheckedIOException {
        return new RandomAccessFileBackedByteList(new RandomAccessFile(file, "rw"), true);
    }

    @Nonnull
    public static String readAllText(File file, String encoding) throws IOException {
        return FSIOUtilities.readAllText(file, Charset.forName(encoding));
    }

    @Nonnull
    public static String readAllText(File file, Charset encoding) throws IOException {
        if (encoding == null) {
            encoding = Charset.defaultCharset();
        }
        FileInputStream in = new FileInputStream(file);
        try {
            String string = TextIOUtilities.readAllText((InputStream)in, encoding);
            return string;
        }
        finally {
            BasicIOUtilities.closeWithoutError(in);
        }
    }

    @Nonnull
    public static String readAllText(File file, TextEncodingDetector encodingDetector) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream in = new FileInputStream(file);){
            return TextIOUtilities.readAllText((InputStream)in, encodingDetector);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nonnull
    public static String readAllText(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream in = new FileInputStream(file);){
            return TextIOUtilities.readAllText(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeAll(File file, byte[] data) throws IOException {
        FSIOUtilities.writeAll(file, data, false);
    }

    public static void writeAll(File file, byte[] data, boolean append) throws IOException {
        FSIOUtilities.writeAll(file, ArrayUtilities.wholeArraySliceByte(data), append);
    }

    public static void writeAll(File file, Slice<byte[]> data) throws IOException {
        FSIOUtilities.writeAll(file, data, false);
    }

    public static void writeAll(File file, Slice<byte[]> data, boolean append) throws IOException {
        FileOutputStream out = new FileOutputStream(file, append);
        try {
            ((OutputStream)out).write(data.getUnderlying(), data.getOffset(), data.getLength());
        }
        catch (IOException exc) {
            BasicIOUtilities.closeWithoutError(out);
            throw exc;
        }
        ((OutputStream)out).close();
    }

    public static void writeAll(File file, ByteBuffer data, boolean append) throws IOException {
        FileChannel channel = !append ? FileChannel.open(file.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING) : FileChannel.open(file.toPath(), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        try {
            while (data.hasRemaining()) {
                channel.write(data);
            }
        }
        catch (IOException exc) {
            BasicIOUtilities.closeWithoutError(channel);
            throw exc;
        }
        channel.close();
    }

    public static void writeAll(File file, ByteBuffer data) throws IOException {
        FSIOUtilities.writeAll(file, data, true);
    }

    public static void writeAll(File file, PrimitiveCollections.ByteList data) throws IOException {
        FSIOUtilities.writeAll(file, data, false);
    }

    public static void writeAll(File file, PrimitiveCollections.ByteList data, boolean append) throws IOException {
        FSIOUtilities.writeAll(file, data.toByteArraySlicePossiblyLive(), append);
    }

    public static void writeAllText(File file, String data) throws IOException {
        FSIOUtilities.writeAllText(file, data, false);
    }

    public static void writeAllText(File file, String data, String encoding) throws IOException {
        FSIOUtilities.writeAll(file, data.getBytes(encoding));
    }

    public static void writeAllText(File file, String data, Charset encoding) throws IOException {
        FSIOUtilities.writeAll(file, data.getBytes(encoding));
    }

    public static void writeAllText(File file, String data, boolean append) throws IOException {
        FSIOUtilities.writeAllText(file, data, StandardCharsets.UTF_8, append);
    }

    public static void writeAllText(File file, String data, String encoding, boolean append) throws IOException {
        FSIOUtilities.writeAll(file, data.getBytes(encoding), append);
    }

    public static void writeAllText(File file, String data, Charset encoding, boolean append) throws IOException {
        FSIOUtilities.writeAll(file, data.getBytes(encoding), append);
    }

    public static void writeAllIfNotAlready(File file, byte[] data) throws IOException {
        if (FSUtilities.lexists(file)) {
            byte[] already;
            if (file.isFile() && Arrays.equals(data, already = FSIOUtilities.readAll(file))) {
                return;
            }
            throw new IOException("Differing file contents! at " + StringUtilities.repr(file.getAbsolutePath()));
        }
        FSIOUtilities.writeAll(file, data);
    }

    public static void writeAllTextIfNotAlready(File file, String data) throws IOException {
        if (FSUtilities.lexists(file)) {
            String already;
            if (file.isFile() && data.equals(already = FSIOUtilities.readAllText(file))) {
                return;
            }
            throw new IOException("Differing file contents! at " + StringUtilities.repr(file.getAbsolutePath()));
        }
        FSIOUtilities.writeAllText(file, data);
    }

    public static byte[] readSectionOfFileToMemory(File f, long offset, int length) throws IOException {
        Throwable throwable = null;
        Object var5_5 = null;
        try (FileInputStream in = new FileInputStream(f);){
            if (offset > 0L) {
                JRECompatIOUtilities.skipFully(in, offset);
            }
            byte[] buffer = new byte[length];
            JRECompatIOUtilities.readFully(in, buffer);
            return buffer;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void readSectionOfFileToOtherFile(File source, long offset, long length, File dest) throws IOException {
        Throwable throwable = null;
        Object var7_6 = null;
        try (FileInputStream in = new FileInputStream(source);){
            if (offset > 0L) {
                JRECompatIOUtilities.skipFully(in, offset);
            }
            Throwable throwable2 = null;
            Object var10_11 = null;
            try (FileOutputStream out = new FileOutputStream(dest);){
                JRECompatIOUtilities.pumpFixed((InputStream)in, (OutputStream)out, length);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static ChannelProvider<FileChannel> getChannelProviderForLocalFile(final File file, final String mode) {
        return new ChannelProvider<FileChannel>(){

            @Override
            public FileChannel open() throws IOException {
                RandomAccessFile raf = new RandomAccessFile(file, mode);
                return raf.getChannel();
            }
        };
    }

    public static ChannelProvider<FileChannel> getChannelProviderForLocalFile(File file) {
        return FSIOUtilities.getChannelProviderForLocalFile(file, "rw");
    }

    public static MappedByteBuffer fileAsByteBufferReadonly(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException("File is not a file!!: " + StringUtilities.repr(file.getAbsolutePath()));
        }
        long length = file.length();
        return FSIOUtilities.fileAsByteBufferReadonly(file, 0L, length);
    }

    public static MappedByteBuffer fileAsByteBuffeReadwrite(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException("File is not a file!!: " + StringUtilities.repr(file.getAbsolutePath()));
        }
        long length = file.length();
        return FSIOUtilities.fileAsByteBufferReadwrite(file, 0L, length);
    }

    public static MappedByteBuffer fileAsByteBufferReadonly(File file, long offset, long length) throws IOException {
        FileChannel fc = FSUtilities.openReadonlyNIO(file);
        return fc.map(FileChannel.MapMode.READ_ONLY, offset, length);
    }

    public static MappedByteBuffer fileAsByteBufferReadwrite(File file, long offset, long length) throws IOException {
        FileChannel fc = FSUtilities.openReadwriteNIO(file);
        return fc.map(FileChannel.MapMode.READ_WRITE, offset, length);
    }

    public static void doOnLines(File f, FunctionInterfaces.UnaryProcedure<String> process) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));){
            String line;
            while ((line = in.readLine()) != null) {
                process.f(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean compare(File a, File b) throws IOException {
        if (!a.isFile() || !b.isFile()) {
            throw new IOException("Cannot compare non-files");
        }
        if (a.length() != b.length()) {
            return false;
        }
        FileInputStream inA = null;
        FileInputStream inB = null;
        try {
            inA = new FileInputStream(a);
            inB = new FileInputStream(b);
            boolean results = JRECompatIOUtilities.compare(inA, inB);
            inA.close();
            inB.close();
            return results;
        }
        catch (IOException exc) {
            BasicIOUtilities.closeWithoutError(inA);
            BasicIOUtilities.closeWithoutError(inB);
            throw exc;
        }
    }

    public static boolean fileeq(File a, File b) throws IOException {
        return FSIOUtilities.filecmp(a, b) == 0;
    }

    /*
     * Exception decompiling
     */
    public static int filecmp(File a, File b) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    public static String readAllTextRE(File file, String encoding) {
        try {
            return FSIOUtilities.readAllText(file, encoding);
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    @Nonnull
    public static String readAllTextRE(File file, Charset encoding) {
        try {
            return FSIOUtilities.readAllText(file, encoding);
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    @Nonnull
    public static String readAllTextRE(File file) {
        try {
            return FSIOUtilities.readAllText(file);
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    @Nonnull
    public static String readAllTextRE(File file, TextEncodingDetector encodingDetector) {
        try {
            return FSIOUtilities.readAllText(file, encodingDetector);
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }
}

