/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rebound.util.cli.Arguments;

public class StandardArguments
extends Arguments {
    protected Set<String> followedArguments;
    protected Set<Character> switches;
    protected Set<String> longs;
    protected Map<String, List<String>> followings;
    protected List<String> targets;

    @Override
    public void reset() {
        this.followedArguments = null;
        this.switches = null;
        this.longs = null;
        this.followings = null;
        this.targets = null;
        super.reset();
    }

    public void season(String ... followedArguments) {
        HashSet<String> followedArgs = new HashSet<String>();
        Collections.addAll(followedArgs, followedArguments);
        this.followedArguments = followedArgs;
        super.season();
    }

    public Set<Character> getSwitches() {
        return this.switches;
    }

    public boolean isSwitchPresent(char sw) {
        return this.switches.contains(Character.valueOf(sw));
    }

    public Set<String> getLongs() {
        return this.longs;
    }

    public boolean isLongSwitchPresent(String sw) {
        return this.longs.contains(sw);
    }

    public List<String> getLongSuffices(String prefix) {
        ArrayList<String> suffices = new ArrayList<String>();
        for (String s : this.longs) {
            if (!s.startsWith(prefix)) continue;
            suffices.add(s.substring(prefix.length()));
        }
        return suffices;
    }

    public Map<String, List<String>> getAllFollowings() {
        return this.followings;
    }

    public List<String> getFollowings(String name) {
        return this.followings.get(name);
    }

    public String getFirstFollowing(String name) {
        List<String> f = this.followings.get(name);
        if (f == null || f.isEmpty()) {
            return null;
        }
        return f.get(0);
    }

    public boolean isFollowingPresent(String name) {
        List<String> f = this.getFollowings(name);
        return f != null && !f.isEmpty();
    }

    public List<String> getTargets() {
        return this.targets;
    }

    @Override
    public void bake(String[] args) {
        this.switches = new HashSet<Character>();
        this.longs = new HashSet<String>();
        this.followings = new HashMap<String, List<String>>();
        this.targets = new ArrayList<String>();
        String arg = null;
        int i = 0;
        while (i < args.length) {
            arg = args[i];
            if (arg.equals("--")) {
                ++i;
                while (i < args.length) {
                    this.targets.add(args[i]);
                    ++i;
                }
                super.bake(args);
                return;
            }
            if (this.followedArguments != null && this.followedArguments.contains(arg)) {
                if (i + 1 < args.length) {
                    List<String> argsFollowing = this.followings.get(arg);
                    if (argsFollowing == null) {
                        argsFollowing = new ArrayList<String>();
                        this.followings.put(arg, argsFollowing);
                    }
                    argsFollowing.add(args[i + 1]);
                    ++i;
                }
            } else if (arg.startsWith("--")) {
                this.longs.add(arg.substring(2, arg.length()));
            } else if (arg.startsWith("-")) {
                int e = 1;
                while (e < arg.length()) {
                    this.switches.add(Character.valueOf(arg.charAt(e)));
                    ++e;
                }
            } else {
                this.targets.add(arg);
            }
            ++i;
        }
        if (this.followedArguments != null) {
            for (String followedArgument : this.followedArguments) {
                if (this.followings.containsKey(followedArgument)) continue;
                this.followings.put(followedArgument, Collections.EMPTY_LIST);
            }
        }
        super.bake(args);
    }
}

