/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import rebound.exceptions.NotSingletonException;
import rebound.exceptions.StopIterationReturnPath;
import rebound.math.SmallIntegerMathUtilities;
import rebound.text.StringUtilities;
import rebound.util.Maybe;
import rebound.util.collections.CollectionUtilities;
import rebound.util.collections.PairCommutative;
import rebound.util.collections.PairCommutativeImmutable;
import rebound.util.collections.PairOrdered;
import rebound.util.collections.PairOrderedImmutable;
import rebound.util.collections.SimpleIterator;
import rebound.util.collections.TripleOrdered;
import rebound.util.collections.TripleOrderedImmutable;
import rebound.util.objectutil.JavaNamespace;

public class BasicCollectionUtilities
implements JavaNamespace {
    protected static final SimpleIterator Empty_SimpleIterator = () -> {
        throw StopIterationReturnPath.I;
    };
    protected static final SimpleIterator.SimpleIterable Empty_SimpleIterable = () -> Empty_SimpleIterator;

    public static <E> E getSingleElement(Iterable<E> collection) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleElement(collection.iterator());
    }

    public static <E> E getSingleElementOrNone(Iterable<E> collection, @Nullable E sentinelIfNone) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleElementOrNone(collection.iterator(), sentinelIfNone);
    }

    @Nullable
    public static <E> E getSingleElementOrNullIfNone(Iterable<E> collection) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleElementOrNone(collection, null);
    }

    public static <E> E getSingleElement(SimpleIterator.SimpleIterable<E> collection) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleElement(collection.simpleIterator());
    }

    public static <E> E getSingleElementOrNone(SimpleIterator.SimpleIterable<E> collection, @Nullable E sentinelIfNone) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleElementOrNone(collection.simpleIterator(), sentinelIfNone);
    }

    @Nullable
    public static <E> E getSingleElementOrNullIfNone(SimpleIterator.SimpleIterable<E> collection) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleElementOrNone(collection, null);
    }

    public static <E> E getSingleElement(Iterator<E> i) throws NotSingletonException {
        if (!i.hasNext()) {
            throw new NotSingletonException("no elements! ><");
        }
        E first = i.next();
        if (i.hasNext()) {
            throw new NotSingletonException("more than one element!: " + StringUtilities.reprListContentsSingleLine(CollectionUtilities.listof(first, i.next())) + ", (possibly more)");
        }
        return first;
    }

    public static <E> E getSingleElementOrNone(Iterator<E> i, @Nullable E sentinelIfNone) throws NotSingletonException {
        if (!i.hasNext()) {
            return sentinelIfNone;
        }
        E first = i.next();
        if (i.hasNext()) {
            throw new NotSingletonException("more than one element!: " + StringUtilities.reprListContentsSingleLine(CollectionUtilities.listof(first, i.next())) + ", (possibly more)");
        }
        return first;
    }

    @Nullable
    public static <E> E getSingleElementOrNullIfNone(Iterator<E> collection) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleElementOrNone(collection, null);
    }

    public static <E> E getSingleElementOrNoneOrMoreThanOne(Iterator<E> i, @Nullable E sentinelIfNone, @Nullable E sentinelIfMoreThanOne) throws NotSingletonException {
        if (!i.hasNext()) {
            return sentinelIfNone;
        }
        E first = i.next();
        if (i.hasNext()) {
            return sentinelIfMoreThanOne;
        }
        return first;
    }

    public static <E> E getSingleElementOrNoneOrMoreThanOne(Enumeration<E> e, @Nullable E sentinelIfNone, @Nullable E sentinelIfMoreThanOne) throws NotSingletonException {
        if (!e.hasMoreElements()) {
            return sentinelIfNone;
        }
        E first = e.nextElement();
        if (e.hasMoreElements()) {
            return sentinelIfMoreThanOne;
        }
        return first;
    }

    public static <E> E getSingleElement(SimpleIterator<E> collection) throws NotSingletonException {
        E first;
        SimpleIterator<E> i = collection;
        try {
            first = i.nextrp();
        }
        catch (StopIterationReturnPath exc) {
            throw new NotSingletonException("no elements! ><");
        }
        try {
            i.nextrp();
        }
        catch (StopIterationReturnPath exc) {
            return first;
        }
        throw new NotSingletonException("more than one element! o_o");
    }

    public static <E> E getSingleElementOrNone(SimpleIterator<E> collection, @Nullable E sentinelIfNone) throws NotSingletonException {
        E first;
        SimpleIterator<E> i = collection;
        try {
            first = i.nextrp();
        }
        catch (StopIterationReturnPath exc) {
            return sentinelIfNone;
        }
        try {
            i.nextrp();
        }
        catch (StopIterationReturnPath exc) {
            return first;
        }
        throw new NotSingletonException("more than one element! o_o");
    }

    @Nullable
    public static <E> E getSingleElementOrNullIfNone(SimpleIterator<E> collection) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleElementOrNone(collection, null);
    }

    public static <K, V> K getSingleKey(Map<K, V> map) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleElement(map.keySet());
    }

    public static <K, V> K getSingleKeyOrNone(Map<K, V> map, @Nullable K sentinelIfNone) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleElementOrNone(map.keySet(), sentinelIfNone);
    }

    @Nullable
    public static <K, V> K getSingleKeyOrNullIfNone(Map<K, V> map) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleKeyOrNone(map, null);
    }

    public static <K, V> V getSingleValue(Map<K, V> map) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleElement(map.values());
    }

    public static <K, V> V getSingleValueOrNone(Map<K, V> map, @Nullable V sentinelIfNone) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleElementOrNone(map.values(), sentinelIfNone);
    }

    @Nullable
    public static <K, V> V getSingleValueOrNullIfNone(Map<K, V> map) throws NotSingletonException {
        return BasicCollectionUtilities.getSingleValueOrNone(map, null);
    }

    public static <E> SimpleIterator<E> emptySimpleIterator() {
        return Empty_SimpleIterator;
    }

    public static <E> SimpleIterator.SimpleIterable<E> emptySimpleIterable() {
        return Empty_SimpleIterable;
    }

    public static boolean isEmptyIterable(Iterable x) {
        if (x instanceof Collection) {
            return ((Collection)x).isEmpty();
        }
        if (x instanceof IterableWithIsEmpty) {
            return ((IterableWithIsEmpty)((Object)x)).isEmpty();
        }
        if (x instanceof IterableWithSize) {
            return ((IterableWithSize)((Object)x)).size() == 0;
        }
        return !x.iterator().hasNext();
    }

    public static boolean isEmptySimpleIterable(SimpleIterator.SimpleIterable x) {
        if (x instanceof Collection) {
            return ((Collection)((Object)x)).isEmpty();
        }
        if (x instanceof IterableWithIsEmpty) {
            return ((IterableWithIsEmpty)((Object)x)).isEmpty();
        }
        if (x instanceof IterableWithSize) {
            return ((IterableWithSize)((Object)x)).size() == 0;
        }
        try {
            x.simpleIterator().nextrp();
        }
        catch (StopIterationReturnPath exc) {
            return true;
        }
        return false;
    }

    public static int sizeOfCollectionlike(Object x) {
        if (x == null) {
            throw new NullPointerException();
        }
        if (x instanceof Object[]) {
            return ((Object[])x).length;
        }
        if (x.getClass().isArray()) {
            return Array.getLength(x);
        }
        if (x instanceof Collection) {
            return ((Collection)x).size();
        }
        if (x instanceof Map) {
            return ((Map)x).size();
        }
        if (x instanceof CharSequence) {
            return ((CharSequence)x).length();
        }
        if (x instanceof Buffer) {
            return ((Buffer)x).limit();
        }
        if (x instanceof IterableWithSize) {
            return ((IterableWithSize)x).size();
        }
        if (x instanceof Iterable) {
            int s = 0;
            for (Object e : (Iterable)x) {
                s = SmallIntegerMathUtilities.safe_inc_s32(s);
            }
            return s;
        }
        throw new ClassCastException("Only arrays, " + Collection.class.getName() + "'s, " + Map.class.getName() + "'s(values), " + CharSequence.class.getName() + "'s, " + Buffer.class.getName() + "'s, and " + Iterable.class.getName() + "'s (O(n) length calculation XP) are supported; sorries ._.   not " + x.getClass().getName() + "'s");
    }

    public static <E> Set<E> emptyIfNull(Set<E> x) {
        return x == null ? Collections.emptySet() : x;
    }

    public static <E> List<E> emptyIfNull(List<E> x) {
        return x == null ? Collections.emptyList() : x;
    }

    public static <E> Collection<E> emptyIfNull(Collection<E> x) {
        return x == null ? Collections.emptySet() : x;
    }

    public static <E> Iterable<E> emptyIfNull(Iterable<E> x) {
        return x == null ? Collections.emptySet() : x;
    }

    public static <E> SimpleIterator.SimpleIterable<E> emptyIfNull(SimpleIterator.SimpleIterable<E> x) {
        return x == null ? BasicCollectionUtilities.emptySimpleIterable() : x;
    }

    public static <K, V> Map<K, V> emptyIfNull(Map<K, V> x) {
        return x == null ? Collections.emptyMap() : x;
    }

    public static <E> boolean isEmptyOrNull(Set<E> x) {
        return x == null || x.isEmpty();
    }

    public static <E> boolean isEmptyOrNull(List<E> x) {
        return x == null || x.isEmpty();
    }

    public static <E> boolean isEmptyOrNull(E[] x) {
        return x == null || x.length == 0;
    }

    public static <E> boolean isEmptyOrNull(CharSequence x) {
        return x == null || x.length() == 0;
    }

    public static <E> boolean isEmptyOrNull(Buffer x) {
        return x == null || x.remaining() == 0;
    }

    public static <E> boolean isEmptyOrNull(Collection<E> x) {
        return x == null || x.isEmpty();
    }

    public static <E> boolean isEmptyOrNull(Iterable<E> x) {
        return x == null || BasicCollectionUtilities.isEmptyIterable(x);
    }

    public static <E> boolean isEmptyOrNull(SimpleIterator.SimpleIterable<E> x) {
        return x == null || BasicCollectionUtilities.isEmptySimpleIterable(x);
    }

    public static <K, V> boolean isEmptyOrNull(Map<K, V> x) {
        return x == null || x.isEmpty();
    }

    public static boolean isEmptyOrNull(boolean[] x) {
        return x == null || x.length == 0;
    }

    public static boolean isEmptyOrNull(byte[] x) {
        return x == null || x.length == 0;
    }

    public static boolean isEmptyOrNull(char[] x) {
        return x == null || x.length == 0;
    }

    public static boolean isEmptyOrNull(short[] x) {
        return x == null || x.length == 0;
    }

    public static boolean isEmptyOrNull(float[] x) {
        return x == null || x.length == 0;
    }

    public static boolean isEmptyOrNull(int[] x) {
        return x == null || x.length == 0;
    }

    public static boolean isEmptyOrNull(double[] x) {
        return x == null || x.length == 0;
    }

    public static boolean isEmptyOrNull(long[] x) {
        return x == null || x.length == 0;
    }

    public static <A, B> PairOrdered<A, B> pair(A a, B b) {
        return new PairOrderedImmutable<A, B>(a, b);
    }

    public static <A, B, C> TripleOrdered<A, B, C> triple(A a, B b, C c) {
        return new TripleOrderedImmutable<A, B, C>(a, b, c);
    }

    public static <T> PairCommutative<T> doubleton(T a, T b) {
        return new PairCommutativeImmutable<T>(a, b);
    }

    public static <E> Maybe<E> just(@Nullable E e) {
        return new Maybe<E>(e);
    }

    public static <E> Maybe<E> nothing() {
        return null;
    }

    public static <E> Maybe<E> maybeNonNull(@Nullable E e) {
        return e == null ? null : BasicCollectionUtilities.just(e);
    }

    public static interface IterableWithIsEmpty {
        public boolean isEmpty();
    }

    public static interface IterableWithSize {
        public int size();
    }
}

