/*
 * Decompiled with CFR 0.152.
 */
package rebound.io.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import rebound.annotations.hints.Inline;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.annotations.semantic.simpledata.ActuallySigned;
import rebound.annotations.semantic.simpledata.ActuallyUnsigned;
import rebound.bits.Unsigned;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.SlowVersionUnsupportedException;
import rebound.io.iio.InputByteStream;
import rebound.io.streaming.api.StreamAPIs;
import rebound.io.util.ExtraIOUtilities;
import rebound.math.SmallIntegerMathUtilities;
import rebound.util.BasicExceptionUtilities;
import rebound.util.collections.ArrayUtilities;
import rebound.util.collections.PolymorphicCollectionUtilities;
import rebound.util.collections.Slice;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.functional.throwing.FunctionalInterfacesThrowingCheckedExceptionsStandard;
import rebound.util.objectutil.JavaNamespace;

public class JRECompatIOUtilities
implements JavaNamespace {
    public static InputStream getInputFromStreamOrBuffer(Object o) {
        if (o instanceof InputStream) {
            return (InputStream)o;
        }
        if (o instanceof byte[]) {
            return new ByteArrayInputStream((byte[])o);
        }
        if (o == null) {
            return new ByteArrayInputStream(ArrayUtilities.EmptyByteArray);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(o);
    }

    public static boolean isBufferAndEmpty(Object o) {
        if (o instanceof InputStream) {
            return false;
        }
        if (o instanceof InputByteStream) {
            return false;
        }
        if (o instanceof StreamAPIs.ByteBlockReadStream) {
            return false;
        }
        if (o instanceof byte[]) {
            return ((byte[])o).length == 0;
        }
        if (o instanceof ByteBuffer) {
            return ((ByteBuffer)o).remaining() == 0;
        }
        if (o == null) {
            return true;
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(o);
    }

    @Inline
    public static BufferedInputStream ensureBufferedInputStream(InputStream in) {
        return in.getClass() == BufferedInputStream.class ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    @Inline
    public static BufferedOutputStream ensureBufferedOutputStream(OutputStream in) {
        return in.getClass() == BufferedOutputStream.class ? (BufferedOutputStream)in : new BufferedOutputStream(in);
    }

    @ActuallySigned
    public static long pumpObservingErrors(InputStream in, OutputStream out, int bufferSize, FunctionInterfaces.UnaryProcedure<IOException> ioerrorInInput, FunctionInterfaces.UnaryProcedure<IOException> ioerrorInOutput) {
        long total = 0L;
        byte[] buffer = new byte[bufferSize];
        while (true) {
            int amt;
            try {
                amt = in.read(buffer);
            }
            catch (IOException exc) {
                ioerrorInInput.f(exc);
                break;
            }
            if (amt < 0) break;
            try {
                out.write(buffer, 0, amt);
            }
            catch (IOException exc) {
                ioerrorInOutput.f(exc);
                break;
            }
            total = SmallIntegerMathUtilities.safe_add_s64(total, amt);
        }
        return total;
    }

    public static long pumpObservingErrors(InputStream in, OutputStream out, FunctionInterfaces.UnaryProcedure<IOException> ioerrorInInput, FunctionInterfaces.UnaryProcedure<IOException> ioerrorInOutput) {
        return JRECompatIOUtilities.pumpObservingErrors(in, out, 4096, ioerrorInInput, ioerrorInOutput);
    }

    public static long pumpThenCloseBothObservingErrors(InputStream in, OutputStream out, FunctionInterfaces.UnaryProcedure<IOException> ioerrorInInput, FunctionInterfaces.UnaryProcedure<IOException> ioerrorInOutput) throws IOException {
        try {
            long l = JRECompatIOUtilities.pumpObservingErrors(in, out, ioerrorInInput, ioerrorInOutput);
            return l;
        }
        finally {
            try {
                in.close();
            }
            finally {
                out.close();
            }
        }
    }

    @ActuallyUnsigned
    public static long pumpFixedObservingErrors(InputStream in, OutputStream out, @ActuallyUnsigned long length, int bufferSize, FunctionInterfaces.UnaryProcedure<IOException> ioerrorInInput, FunctionInterfaces.UnaryProcedure<IOException> ioerrorInOutput) {
        SmallIntegerMathUtilities.requirePositive(bufferSize);
        if (length > 0L) {
            byte[] buffer = new byte[bufferSize];
            long curr = 0L;
            while (Long.compareUnsigned(curr, length) < 0) {
                int amt;
                try {
                    amt = in.read(buffer, 0, Math.min(bufferSize, (int)(length - curr)));
                }
                catch (IOException exc) {
                    ioerrorInInput.f(exc);
                    break;
                }
                if (amt < 0) {
                    return curr;
                }
                curr = SmallIntegerMathUtilities.safe_add_u64(curr, amt);
                try {
                    out.write(buffer, 0, amt);
                }
                catch (IOException exc) {
                    ioerrorInOutput.f(exc);
                    break;
                }
            }
            return curr;
        }
        return 0L;
    }

    @ActuallyUnsigned
    public static long pumpFixedObservingErrors(InputStream in, OutputStream out, @ActuallyUnsigned long length, FunctionInterfaces.UnaryProcedure<IOException> ioerrorInInput, FunctionInterfaces.UnaryProcedure<IOException> ioerrorInOutput) {
        return JRECompatIOUtilities.pumpFixedObservingErrors(in, out, length, 4096, ioerrorInInput, ioerrorInOutput);
    }

    @ActuallySigned
    public static long pump(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int amt;
        long total = 0L;
        byte[] buffer = new byte[bufferSize];
        while ((amt = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amt);
            total = SmallIntegerMathUtilities.safe_add_s64(total, amt);
        }
        return total;
    }

    public static long pump(InputStream in, OutputStream out) throws IOException {
        return JRECompatIOUtilities.pump(in, out, 4096);
    }

    public static long pumpThenCloseBoth(InputStream in, OutputStream out) throws IOException {
        try {
            long l = JRECompatIOUtilities.pump(in, out);
            return l;
        }
        finally {
            try {
                in.close();
            }
            finally {
                out.close();
            }
        }
    }

    @ActuallyUnsigned
    public static long pumpFixed(InputStream in, OutputStream out, @ActuallyUnsigned long length, int bufferSize) throws IOException {
        SmallIntegerMathUtilities.requirePositive(bufferSize);
        if (length > 0L) {
            byte[] buffer = new byte[bufferSize];
            long curr = 0L;
            while (Long.compareUnsigned(curr, length) < 0) {
                int amt = in.read(buffer, 0, Math.min(bufferSize, (int)(length - curr)));
                if (amt < 0) {
                    return curr;
                }
                curr = SmallIntegerMathUtilities.safe_add_u64(curr, amt);
                out.write(buffer, 0, amt);
            }
            return curr;
        }
        return 0L;
    }

    @ActuallyUnsigned
    public static long pumpFixed(InputStream in, OutputStream out, @ActuallyUnsigned long length) throws IOException {
        return JRECompatIOUtilities.pumpFixed(in, out, length, 4096);
    }

    @ActuallySigned
    public static long pump(RandomAccessFile in, OutputStream out, int bufferSize) throws IOException {
        int amt;
        long total = 0L;
        byte[] buffer = new byte[bufferSize];
        while ((amt = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amt);
            total = SmallIntegerMathUtilities.safe_add_s64(total, amt);
        }
        return total;
    }

    public static long pump(RandomAccessFile in, OutputStream out) throws IOException {
        return JRECompatIOUtilities.pump(in, out, 4096);
    }

    @ActuallyUnsigned
    public static long pumpFixed(RandomAccessFile in, OutputStream out, long length, int bufferSize) throws IOException {
        if (length > 0L) {
            byte[] buffer = new byte[bufferSize];
            long curr = 0L;
            while (Long.compareUnsigned(curr, length) < 0) {
                int amt = in.read(buffer, 0, Math.min(bufferSize, (int)(length - curr)));
                if (amt < 0) {
                    return curr;
                }
                curr = SmallIntegerMathUtilities.safe_add_u64(curr, amt);
                out.write(buffer, 0, amt);
            }
            return curr;
        }
        return 0L;
    }

    public static long pumpFixed(RandomAccessFile in, OutputStream out, long length) throws IOException {
        return JRECompatIOUtilities.pumpFixed(in, out, length, 4096);
    }

    @ActuallySigned
    public static long pump(InputStream in, RandomAccessFile out, int bufferSize) throws IOException {
        int amt;
        long total = 0L;
        byte[] buffer = new byte[bufferSize];
        while ((amt = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amt);
            total = SmallIntegerMathUtilities.safe_add_s64(total, amt);
        }
        return total;
    }

    public static long pump(InputStream in, RandomAccessFile out) throws IOException {
        return JRECompatIOUtilities.pump(in, out, 4096);
    }

    @ActuallyUnsigned
    public static long pumpFixed(InputStream in, RandomAccessFile out, long length, int bufferSize) throws IOException {
        if (length > 0L) {
            byte[] buffer = new byte[bufferSize];
            long curr = 0L;
            while (Long.compareUnsigned(curr, length) < 0) {
                int amt = in.read(buffer, 0, Math.min(bufferSize, (int)(length - curr)));
                if (amt < 0) {
                    return curr;
                }
                curr = SmallIntegerMathUtilities.safe_add_u64(curr, amt);
                out.write(buffer, 0, amt);
            }
            return curr;
        }
        return 0L;
    }

    public static long pumpFixed(InputStream in, RandomAccessFile out, long length) throws IOException {
        return JRECompatIOUtilities.pumpFixed(in, out, length, 4096);
    }

    public static void writeZeros(OutputStream out, long amount) throws IOException {
        JRECompatIOUtilities.writeRepeatingBytes(out, amount, new byte[(int)SmallIntegerMathUtilities.least(4096L, amount)]);
    }

    public static void writeRepeatingBytes(OutputStream out, long amount, byte[] zeroBuffer) throws IOException {
        while (amount > 0L) {
            int amountThisTime = (int)SmallIntegerMathUtilities.least(amount, (long)zeroBuffer.length);
            out.write(zeroBuffer, 0, amountThisTime);
            amount -= (long)amountThisTime;
        }
    }

    public static long discard(InputStream in) throws IOException {
        long skipped = 0L;
        long c;
        while ((c = in.skip(0x800000L)) > 0L) {
            skipped += c;
        }
        return skipped;
    }

    public static long discardByReading(InputStream in) throws IOException {
        byte[] dummyBuff = new byte[1024];
        long skipped = 0L;
        long c;
        while ((c = (long)in.read(dummyBuff, 0, dummyBuff.length)) >= 0L) {
            skipped += c;
        }
        return skipped;
    }

    public static void readFully(InputStream in, byte[] buff, int offset, int len) throws EOFException, IOException {
        int read = 0;
        while (read < len) {
            int r = in.read(buff, offset + read, len - read);
            if (r < 0) {
                throw new EOFException("Premature EOF");
            }
            read += r;
        }
        return;
    }

    public static void readFully(InputStream in, byte[] buff) throws EOFException, IOException {
        JRECompatIOUtilities.readFully(in, buff, 0, buff.length);
    }

    public static byte[] readFullyToNew(InputStream in, int length) throws EOFException, IOException {
        if (length == 0) {
            return ArrayUtilities.EmptyByteArray;
        }
        byte[] b = new byte[length];
        JRECompatIOUtilities.readFully(in, b);
        return b;
    }

    public static long skipFully(InputStream in, long amount) throws IOException {
        long skipped = 0L;
        while (skipped < amount) {
            long c = in.skip(amount - skipped);
            if (c < 0L) {
                return skipped;
            }
            skipped += c;
        }
        return skipped;
    }

    @ActuallySigned
    public static long skipFullyByDiscarding(InputStream in, long amount, byte[] dummyBuffer) throws IOException {
        long total = 0L;
        int amt = 0;
        while (total < amount) {
            amt = in.read(dummyBuffer, 0, (int)Math.min(amount - total, (long)dummyBuffer.length));
            if (amt < 0) {
                return total;
            }
            total = SmallIntegerMathUtilities.safe_add_s64(total, amt);
        }
        return total;
    }

    public static long skipFullyByDiscarding(InputStream in, long amount) throws IOException {
        return JRECompatIOUtilities.skipFullyByDiscarding(in, amount, new byte[2048]);
    }

    public static int readAsMuchAsPossible(InputStream in, byte[] buff, int offset, int len) throws IOException {
        int read;
        int r;
        for (read = 0; read < len && (r = in.read(buff, offset + read, len - read)) >= 0; read += r) {
        }
        return read;
    }

    public static int readAsMuchAsPossible(InputStream in, byte[] buff) throws IOException {
        return JRECompatIOUtilities.readAsMuchAsPossible(in, buff, 0, buff.length);
    }

    public static byte[] readAsMuchAsPossibleToNew(InputStream in, int length) throws IOException {
        if (length == 0) {
            return ArrayUtilities.EmptyByteArray;
        }
        byte[] b = new byte[length];
        int amt = JRECompatIOUtilities.readAsMuchAsPossible(in, b);
        assert (amt >= 0);
        if (amt != length) {
            b = Arrays.copyOf(b, amt);
        }
        return b;
    }

    public static byte[] readAll(@Nonnull InputStream in) throws IOException {
        Objects.requireNonNull(in);
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        JRECompatIOUtilities.pump(in, (OutputStream)buff);
        return buff.toByteArray();
    }

    public static boolean checkMagic(InputStream in, byte[] magic) throws IOException {
        int c = 0;
        int i = 0;
        while (i < magic.length) {
            c = in.read();
            if (c < 0) {
                return false;
            }
            if ((byte)c != magic[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static OutputStream getNullOutputStream() {
        return new OutputStream(){

            @Override
            public void write(byte[] b) throws IOException {
            }

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }
        };
    }

    public static byte read1(InputStream in) throws EOFException, IOException {
        int v = in.read();
        if (v < 0) {
            throw new EOFException();
        }
        return (byte)v;
    }

    public static byte read1(ByteArrayInputStream in) throws EOFException {
        int v = in.read();
        if (v < 0) {
            throw new EOFException();
        }
        return (byte)v;
    }

    public static int read1viaReadBlock(InputStream in, byte[] buf1) throws EOFException, IOException {
        return JRECompatIOUtilities.read1viaReadBlock(in, buf1, 0);
    }

    public static int read1viaReadBlock(InputStream in, byte[] buf1, int offset) throws EOFException, IOException {
        int r;
        do {
            if ((r = in.read(buf1, offset, 1)) == -1) {
                return -1;
            }
            if (r != 1) continue;
            return Unsigned.upcast(buf1[offset]);
        } while (r == 0);
        throw new ImpossibleException("an InputStream implementation's read(byte[], int, int) method returned more bytes (+r+) than were requested! (1)");
    }

    public static void writeSlice(OutputStream out, @ReadonlyValue Slice<byte[]> data) throws IOException {
        out.write(data.getUnderlying(), data.getOffset(), data.getLength());
    }

    public static int readSlice(InputStream in, @WritableValue Slice<byte[]> data) throws IOException {
        return in.read(data.getUnderlying(), data.getOffset(), data.getLength());
    }

    public static void readSliceFully(InputStream in, @WritableValue Slice<byte[]> data) throws IOException {
        JRECompatIOUtilities.readFully(in, data.getUnderlying(), data.getOffset(), data.getLength());
    }

    public static void writeList(OutputStream out, @ReadonlyValue PrimitiveCollections.ByteList data) throws IOException {
        JRECompatIOUtilities.writeSlice(out, data.toByteArraySlicePossiblyLive());
    }

    public static int readList(InputStream in, @WritableValue PrimitiveCollections.ByteList data) throws IOException {
        PolymorphicCollectionUtilities.ensureWritableCollection(data);
        Slice<byte[]> s = data.toByteArraySliceLiveOrNull();
        if (s == null) {
            throw new SlowVersionUnsupportedException();
        }
        return JRECompatIOUtilities.readSlice(in, s);
    }

    public static void readListFully(InputStream in, @WritableValue PrimitiveCollections.ByteList data) throws IOException {
        PolymorphicCollectionUtilities.ensureWritableCollection(data);
        Slice<byte[]> s = data.toByteArraySliceLiveOrNull();
        if (s == null) {
            throw new SlowVersionUnsupportedException();
        }
        JRECompatIOUtilities.readSliceFully(in, s);
    }

    public static boolean compare(InputStream a, InputStream b, int bufferSize) throws IOException {
        Object rv = ExtraIOUtilities.consumeInSync(a, b, ExtraIOUtilities.CONSUMER_COMPARISON, bufferSize);
        return (Boolean)rv;
    }

    public static boolean compare(InputStream a, InputStream b) throws IOException {
        return JRECompatIOUtilities.compare(a, b, 4096);
    }

    public static boolean streameq(InputStream a, InputStream b) throws IOException {
        return JRECompatIOUtilities.streamcmp(a, b) == 0;
    }

    public static int streamcmp(InputStream a, InputStream b) throws IOException {
        return JRECompatIOUtilities.streamcmp(a, false, b, false);
    }

    public static int streamcmp(InputStream a, boolean okayIfAStopsEarly, InputStream b, boolean okayIfBStopsEarly) throws IOException {
        int bc;
        int ac;
        BufferedInputStream ab = JRECompatIOUtilities.ensureBufferedInputStream(a);
        BufferedInputStream bb = JRECompatIOUtilities.ensureBufferedInputStream(b);
        do {
            if ((ac = ab.read()) < 0 && okayIfAStopsEarly) {
                return 0;
            }
            bc = bb.read();
            if (ac < 0) {
                if (bc < 0) {
                    return 0;
                }
                return -1;
            }
            if (bc >= 0) continue;
            return okayIfBStopsEarly ? 0 : 1;
        } while (ac == bc);
        if (ac < bc) {
            return -1;
        }
        return 1;
    }

    public static byte[] writeAllToMemory(FunctionalInterfacesThrowingCheckedExceptionsStandard.UnaryProcedureThrowingIOException<OutputStream> write) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayOutputStream buff = new ByteArrayOutputStream();){
                write.f(buff);
                return buff.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exc) {
            throw new ImpossibleException(exc);
        }
    }

    public static String writeAllTextToMemory(FunctionalInterfacesThrowingCheckedExceptionsStandard.UnaryProcedureThrowingIOException<Writer> write) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (StringWriter buff = new StringWriter();){
                write.f(buff);
                return buff.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exc) {
            throw new ImpossibleException(exc);
        }
    }
}

