/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.objectutil;

import java.util.Comparator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import rebound.exceptions.StructuredClassCastException;
import rebound.util.Maybe;
import rebound.util.Primitives;
import rebound.util.functional.EqualityComparator;
import rebound.util.functional.functions.DefaultEqualityComparator;
import rebound.util.objectutil.CompareNotSupportedException;
import rebound.util.objectutil.GeneralComparatorToEqualityComparator;
import rebound.util.objectutil.JavaNamespace;
import rebound.util.objectutil.StrictReferenceIdentityEqualityComparator;

public class BasicObjectUtilities
implements JavaNamespace {
    protected static final EqualityComparator IdentityUnboxingEqualityComparator = new EqualityComparator(){

        public boolean equals(Object a, Object b) {
            return BasicObjectUtilities.eqIdentityUnboxing(a, b);
        }
    };
    protected static final Comparator NaturalOrderingComparator = new Comparator(){

        public int compare(Object a, Object b) {
            return BasicObjectUtilities.cmp2(a, b);
        }

        public Comparator reversed() {
            return ReverseNaturalOrderingComparator;
        }
    };
    protected static final Comparator ReverseNaturalOrderingComparator = new Comparator(){

        public int compare(Object a, Object b) {
            return -BasicObjectUtilities.cmp2(a, b);
        }

        public Comparator reversed() {
            return NaturalOrderingComparator;
        }
    };

    public static boolean eq(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean eq(Object ... many) {
        if (many.length < 2) {
            return true;
        }
        Object first = many[0];
        int i = 1;
        while (i < many.length) {
            if (!BasicObjectUtilities.eq(many[i], first)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean eqC(Iterable<? extends Object> many) {
        boolean hasFirst = false;
        Object first = null;
        for (Object object : many) {
            if (hasFirst) {
                if (BasicObjectUtilities.eq(object, first)) continue;
                return false;
            }
            hasFirst = true;
            first = object;
        }
        return true;
    }

    public static boolean eqIdentityUnboxing(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return b == null;
        }
        if (Primitives.isPrimitiveWrapperInstance(a)) {
            return a.equals(b);
        }
        return false;
    }

    public static <E> boolean eqWith(EqualityComparator<E> comparator, E ... many) {
        if (many.length < 2) {
            return true;
        }
        if (comparator == null || comparator == DefaultEqualityComparator.I) {
            return BasicObjectUtilities.eq(many);
        }
        if (comparator == IdentityUnboxingEqualityComparator) {
            return BasicObjectUtilities.eqIdentityUnboxing(many);
        }
        E first = many[0];
        int i = 1;
        while (i < many.length) {
            if (!comparator.equals(first, many[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean eqIdentityUnboxing(Object ... many) {
        if (many.length < 2) {
            return true;
        }
        Object first = many[0];
        int i = 1;
        while (i < many.length) {
            if (!BasicObjectUtilities.eqIdentityUnboxing(first, many[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean eqWith(Object a, Object b, Object comparator) {
        if (comparator == null) {
            return BasicObjectUtilities.eq(a, b);
        }
        if (comparator instanceof EqualityComparator) {
            return ((EqualityComparator)comparator).equals(a, b);
        }
        if (comparator instanceof Comparator) {
            return ((Comparator)comparator).compare(a, b) == 0;
        }
        throw new IllegalArgumentException(new StructuredClassCastException(comparator.getClass()));
    }

    public static <T> GeneralComparatorToEqualityComparator<T> makeEqualityComparatorFromGeneralComparator(final Comparator<T> inequalityComparator) {
        return new GeneralComparatorToEqualityComparator<T>(){

            @Override
            public boolean equals(T a, T b) {
                return inequalityComparator.compare(a, b) == 0;
            }

            @Override
            public Comparator<T> getUnderlyingGeneralComparator() {
                return inequalityComparator;
            }
        };
    }

    public static boolean eqSome(@Nullable Object a, @Nullable Object b) {
        return a == null || b == null ? true : BasicObjectUtilities.eq(a, b);
    }

    public static boolean eqSomeMaybes(Maybe<Object> a, Maybe<Object> b) {
        return a == null || b == null ? true : BasicObjectUtilities.eq(a.getJust(), b.getJust());
    }

    public static <T> EqualityComparator<T> getNaturalEqualityComparator() {
        return DefaultEqualityComparator.I;
    }

    public static <T> EqualityComparator<T> getIdentityUnboxingEqualityComparator() {
        return IdentityUnboxingEqualityComparator;
    }

    public static <T> EqualityComparator<T> getIdentityNonunboxingEqualityComparator() {
        return StrictReferenceIdentityEqualityComparator.I;
    }

    public static <T> EqualityComparator<T> getEquivalenceOrIdentityEqualityComparator(final Predicate<T> hasIdentity) {
        return new EqualityComparator<T>(){

            @Override
            public boolean equals(T a, T b) {
                return hasIdentity.test(a) || hasIdentity.test(b) ? a == b : BasicObjectUtilities.eq(a, b);
            }
        };
    }

    public static int cmp2(@Nullable Object a, @Nullable Object b) throws CompareNotSupportedException {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        if (b instanceof Comparable) {
            return -((Comparable)b).compareTo(a);
        }
        throw new CompareNotSupportedException();
    }

    public static int cmp2chainable(int previous, Object a, Object b) throws CompareNotSupportedException {
        return previous != 0 ? previous : BasicObjectUtilities.cmp2(a, b);
    }

    public static <T> Comparator<T> chainComparators(final Comparator<T> first, final Comparator<T> second) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int r = first.compare(o1, o2);
                return r == 0 ? second.compare(o1, o2) : r;
            }
        };
    }

    public static <E extends Comparable<E>> Comparator<E> getNaturalOrderingComparator() {
        return NaturalOrderingComparator;
    }

    public static <E extends Comparable<E>> Comparator<E> getReverseNaturalOrderingComparator() {
        return ReverseNaturalOrderingComparator;
    }

    public static <T> T notnull(T object) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    public static int hashNT(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static Class getClassNT(Object o) {
        return o != null ? o.getClass() : null;
    }

    public static Class getClassNTVoid(Object o) {
        return o != null ? o.getClass() : Void.class;
    }

    public static <T> T def(T value, T def) {
        return value != null ? value : def;
    }
}

