/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.cli;

import java.io.BufferedReader;
import rebound.annotations.semantic.temporal.concurrencyprimitives.threadspecification.AnyThreads;
import rebound.util.cli.ConsoleLineReaderThread;
import rebound.util.cli.ConsoleUtilities;
import rebound.util.functional.ContinueSignal;

public class AsyncConsoleReaderBufferer {
    protected final ConsoleLineReaderThread reader;
    protected final Object lock = new Object();
    protected final StringBuilder b = new StringBuilder();

    public AsyncConsoleReaderBufferer(BufferedReader r) {
        this.reader = new ConsoleLineReaderThread(r, this::observeLine);
        this.reader.start();
    }

    public AsyncConsoleReaderBufferer() {
        this(ConsoleUtilities.newLineReaderForSTDIN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThreads
    protected ContinueSignal observeLine(String line) {
        Object object = this.lock;
        synchronized (object) {
            this.b.append(line);
            this.b.append('\n');
        }
        return ContinueSignal.Continue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThreads
    public boolean peekAny() {
        boolean h;
        Object object = this.lock;
        synchronized (object) {
            h = this.b.length() > 0;
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThreads
    public String peek() {
        String s;
        Object object = this.lock;
        synchronized (object) {
            s = this.b.toString();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThreads
    public String drain() {
        String s;
        Object object = this.lock;
        synchronized (object) {
            s = this.b.toString();
            this.b.setLength(0);
        }
        return s;
    }
}

