/*
 * Decompiled with CFR 0.152.
 */
package rebound.text.parsing.impls.auto.scanners.jflex.util;

import java.io.IOException;
import java.io.Reader;
import rebound.exceptions.TextSyntaxException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.text.lexing.apis.tokenless.SimpleLexer;
import rebound.text.lexing.apis.tokenless.util.SimpleLexerUtilities;

public abstract class AbstractJFlexSimpleLexer<TokenType>
implements SimpleLexer<Object, TokenType, Void> {
    protected boolean iseof;
    protected TokenType tokenType;
    protected Object originalSource;
    protected Reader readerSource;
    protected String literalTokenTextCache;
    protected boolean shortstopMode;

    public boolean isShortStopCapableLexer() {
        return false;
    }

    protected abstract int ryychar();

    protected abstract int ryylength();

    protected abstract String ryytext();

    protected abstract int ryyline();

    protected abstract int ryycolumn();

    protected abstract void ryyreset(Reader var1);

    protected abstract void ryylex() throws IOException, TextSyntaxException;

    public AbstractJFlexSimpleLexer() {
    }

    public AbstractJFlexSimpleLexer(boolean shortstopMode) {
        this.shortstopMode = shortstopMode;
    }

    @Override
    public boolean isShortStopMode() {
        if (this.shortstopMode && !this.isShortStopCapableLexer()) {
            throw new IllegalStateException("We're configured as a shortstop lexer, but the JFlex generated lexer code is specified as not-shortstop-capable :\\");
        }
        return this.shortstopMode;
    }

    @Override
    public void next() throws WrappedThrowableRuntimeException, TextSyntaxException {
        if (this.isEOF()) {
            return;
        }
        do {
            try {
                this.ryylex();
            }
            catch (IOException exc) {
                throw new WrappedThrowableRuntimeException(exc);
            }
            if (this.isEOF()) {
                this.literalTokenTextCache = null;
                break;
            }
            this.literalTokenTextCache = null;
        } while (this.tokenType == null);
    }

    @Override
    public void setSourceAndReset(Object source) throws IllegalArgumentException {
        this.readerSource = SimpleLexerUtilities.getReaderSource(source);
        this.originalSource = source;
        this.reset();
    }

    @Override
    public Object getSource() {
        return this.originalSource;
    }

    @Override
    public void reset() {
        this.iseof = false;
        this.tokenType = null;
        this.literalTokenTextCache = null;
        this.ryyreset(this.readerSource);
    }

    @Override
    public boolean isEOF() {
        return this.iseof;
    }

    @Override
    public TokenType getTokenType() {
        if (this.iseof) {
            return null;
        }
        return this.tokenType;
    }

    @Override
    public int getLiteralTokenStartPosition() {
        return this.ryychar();
    }

    @Override
    public int getLiteralTokenLength() {
        if (this.iseof) {
            return 0;
        }
        return this.ryylength();
    }

    @Override
    public String getLiteralTokenText() {
        if (this.iseof) {
            return "";
        }
        return this.ryytext();
    }

    @Override
    public int getLiteralTokenStartLineNumber() {
        return this.ryyline() + 1;
    }

    @Override
    public boolean isLineCountingSupported() {
        return true;
    }

    @Override
    public int getLiteralTokenStartColumnNumber() {
        return this.ryycolumn() + 1;
    }

    @Override
    public boolean isColumnCountingSupported() {
        return true;
    }

    @Override
    public boolean isLogicalValueUsed() {
        return false;
    }

    @Override
    public Void getLogicalTokenValue() {
        return null;
    }

    @Override
    public boolean isLogicalTokenValueStringable() {
        return false;
    }
}

