/*
 * Decompiled with CFR 0.152.
 */
package rebound.text.lexing.apis.tokenstream.util;

import rebound.text.lexing.apis.tokenstream.util.AbstractWherefulToken;
import rebound.text.parsing.apis.tokenstream.SimpleTokenWithLineAndColumnNumbers;
import rebound.text.parsing.apis.tokenstream.SimpleTokenWithMemoryOfOriginalSource;
import rebound.text.parsing.apis.tokenstream.WherefulToken;

public abstract class AbstractWherefulTokenForOnlyOriginalWithLazyMaskedComputation
extends AbstractWherefulToken
implements WherefulToken,
SimpleTokenWithMemoryOfOriginalSource,
SimpleTokenWithLineAndColumnNumbers {
    protected final int startingCharacterIndexInSource;
    protected final int lengthOfMaskedSource;
    protected final int startingLineNumberInSource1Based;
    protected final int startingColumnNumberInSource1Based;
    protected final CharSequence originalSource;
    protected transient String maskedSource;

    public AbstractWherefulTokenForOnlyOriginalWithLazyMaskedComputation(int startingCharacterIndexInSource, int lengthOfMaskedSource, CharSequence originalSource) {
        this(startingCharacterIndexInSource, lengthOfMaskedSource, -1, -1, originalSource);
    }

    public AbstractWherefulTokenForOnlyOriginalWithLazyMaskedComputation(int startingCharacterIndexInSource, int lengthOfMaskedSource, int startingLineNumberInSource1Based, int startingColumnNumberInSource1Based, CharSequence originalSource) {
        if (startingCharacterIndexInSource < 0) {
            throw new IllegalArgumentException();
        }
        if (startingLineNumberInSource1Based < -1) {
            throw new IllegalArgumentException();
        }
        if (startingColumnNumberInSource1Based < -1) {
            throw new IllegalArgumentException();
        }
        if (startingLineNumberInSource1Based == 0) {
            throw new IllegalArgumentException();
        }
        if (startingColumnNumberInSource1Based == 0) {
            throw new IllegalArgumentException();
        }
        if (originalSource == null) {
            throw new IllegalArgumentException();
        }
        this.originalSource = originalSource;
        this.startingCharacterIndexInSource = startingCharacterIndexInSource;
        this.lengthOfMaskedSource = lengthOfMaskedSource;
        this.startingLineNumberInSource1Based = startingLineNumberInSource1Based;
        this.startingColumnNumberInSource1Based = startingColumnNumberInSource1Based;
    }

    @Override
    public boolean isSimpleTokenWithLineAndColumnNumbers() {
        return this.startingLineNumberInSource1Based != -1 && this.startingColumnNumberInSource1Based != -1;
    }

    @Override
    public int getStartingCharacterIndexInSource() {
        return this.startingCharacterIndexInSource;
    }

    @Override
    public int getLengthOfMaskedSource() {
        return this.lengthOfMaskedSource;
    }

    @Override
    public CharSequence getOriginalSourceCharSequence() {
        return this.originalSource;
    }

    @Override
    public String getMaskedSource() {
        String m = this.maskedSource;
        if (m == null) {
            int s = this.startingCharacterIndexInSource;
            this.maskedSource = m = this.originalSource.subSequence(s, s + this.lengthOfMaskedSource).toString();
        }
        return m;
    }

    @Override
    public char getCharacterInMaskedSource(int index) {
        if (index < 0 || index >= this.lengthOfMaskedSource) {
            throw new StringIndexOutOfBoundsException();
        }
        return this.originalSource.charAt(this.startingCharacterIndexInSource + index);
    }
}

