/*
 * Decompiled with CFR 0.152.
 */
package rebound.text;

import java.util.Calendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import rebound.applied.calendars.GregorianCalendarCode;
import rebound.bits.BitfieldSafeCasts;
import rebound.math.ArithmeticIntegerInterval;
import rebound.math.MathUtilities;
import rebound.math.SmallIntegerMathUtilities;
import rebound.text.StringUtilities;
import rebound.util.objectutil.BasicObjectUtilities;

public class CalendarUtilities {
    public static final long DayInMilliseconds = 86400000L;
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final TimeZone ReturnedOnInvalidTimeZone = TimeZone.getTimeZone("GMT");

    public static int[] toGregorianDayNumberAndMillisInDay(long msux) {
        int dayNumber = CalendarUtilities.toGregorianDayNumber(msux);
        int remainder = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.progmod(msux, 86400000L));
        return new int[]{dayNumber, remainder};
    }

    public static int toGregorianDayNumber(long msux) {
        return BitfieldSafeCasts.safeCastS64toS32(Math.floorDiv(msux, 86400000L) + 719528L);
    }

    public static int[] toGregorianDayYMD(long msux) {
        return GregorianCalendarCode.convertADGregorianDayNumberToYearMonthDayofmonth(CalendarUtilities.toGregorianDayNumber(msux));
    }

    @Nonnull
    public static TimeZone getTimeZoneFailingIfInvalid(String s) throws IllegalArgumentException {
        if (BasicObjectUtilities.eq((Object)s, (Object)"GMT")) {
            return ReturnedOnInvalidTimeZone;
        }
        TimeZone tz = TimeZone.getTimeZone(s);
        if (BasicObjectUtilities.eq((Object)tz, (Object)ReturnedOnInvalidTimeZone)) {
            throw new IllegalArgumentException("Invalid TimeZone ID: " + StringUtilities.repr(s));
        }
        return tz;
    }

    public static TimeZone getTimeZoneByUTCOffset(int hours, int minutes) throws IllegalArgumentException {
        if (hours < -99 || hours > 99) {
            throw new IllegalArgumentException("Invalid hours " + hours);
        }
        if (minutes < 0 || minutes >= 60) {
            throw new IllegalArgumentException("Invalid minutes " + hours);
        }
        String id = String.valueOf(hours < 0 ? "UTC" : "UTC+") + StringUtilities.toTwoDigitStringWithLeadingZeroPad(hours) + StringUtilities.toTwoDigitStringWithLeadingZeroPad(minutes);
        return new SimpleTimeZone((hours * 60 + minutes) * 60 * 1000, id);
    }

    public static ArithmeticIntegerInterval gregorianToMSUX(int y, int m0based, int d1based, TimeZone timezone) {
        Calendar c = Calendar.getInstance(UTC, Locale.US);
        c.setTimeInMillis(0L);
        c.setTimeZone(timezone);
        c.set(1, y);
        c.set(2, m0based);
        c.set(5, d1based);
        return MathUtilities.intervalByPointAndSize(c.getTime().getTime(), 86400000L);
    }

    public static ArithmeticIntegerInterval gregorianToMSUX(int[] ymd, TimeZone timezone) {
        if (ymd.length != 3) {
            throw new IllegalArgumentException();
        }
        return CalendarUtilities.gregorianToMSUX(ymd[0], ymd[1], ymd[2], timezone);
    }
}

