/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui.monk;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import rebound.jagent.ResourceHog;
import rebound.jagent.ui.gui.DropData;
import rebound.jagent.ui.gui.monk.MonkApplicationCoordinator;
import rebound.jagent.ui.gui.monk.Monkifier;
import rebound.jagent.ui.gui.monk.Notifee;

public class MonkWindow
extends JFrame
implements DropTargetListener,
Notifee,
ItemListener {
    public static final boolean UseAboutMenuItem = !MonkApplicationCoordinator.AppleJavaExtentionsPresent;
    public static final boolean UseQuitMenuItem = !MonkApplicationCoordinator.AppleJavaExtentionsPresent;
    protected MonkApplicationCoordinator coordinator;
    protected JLabel currAction;
    protected JLabel bg;
    protected JRadioButton outputPrayChunk;
    protected JRadioButton outputPraySource;
    protected JRadioButton inputEach;
    protected JRadioButton inputMergeToAgents;
    protected JPanel body;
    protected DropTarget target;
    protected ButtonGroup outputFormatGroup;
    protected ButtonGroup inputEachOrMergeGroup;
    protected Monkifier chimp;
    protected JMenuBar mnu;
    protected JMenu mnuFile;
    protected JMenuItem mnuFileQuit;
    protected JMenu mnuEdit;
    protected JCheckBoxMenuItem mnuEditMergeScripts;
    protected JMenu mnuHelp;
    protected JMenuItem mnuHelpAbout;

    public MonkWindow() {
        super("Monk");
        this.setDefaultCloseOperation(3);
        this.chimp = new Monkifier(this);
        this.outputFormatGroup = new ButtonGroup();
        this.inputEachOrMergeGroup = new ButtonGroup();
        JPanel body = this.getBody();
        if (body != null) {
            this.setContentPane(body);
            this.setJMenuBar(this.getMnu());
            Icon i = this.getBG().getIcon();
            if (i == null) {
                this.setSize(250, 250);
            } else {
                this.setSize(i.getIconWidth(), i.getIconHeight());
            }
        }
        this.updateConfiguration();
    }

    public JPanel getBody() {
        if (this.body == null) {
            this.body = new JPanel(null, false){

                @Override
                public void doLayout() {
                    super.doLayout();
                    int w = this.getWidth();
                    int h = this.getHeight();
                    int cw = w / 2;
                    MonkWindow.this.getBG().setSize(w, h);
                    MonkWindow.this.getCurrAction().setSize(w, 20);
                    MonkWindow.this.getCurrAction().setLocation(0, h - MonkWindow.this.getCurrAction().getHeight());
                    MonkWindow.this.getOutputPray().setLocation(0, 0);
                    MonkWindow.this.getOutputPray().setSize(cw, 20);
                    MonkWindow.this.getOutputPraySource().setLocation(cw, 0);
                    MonkWindow.this.getOutputPraySource().setSize(w - cw, 20);
                    int yInputEachOrMerge = 125;
                    MonkWindow.this.getInputEach().setLocation(0, yInputEachOrMerge);
                    MonkWindow.this.getInputEach().setSize(cw, 20);
                    MonkWindow.this.getInputMergeToAgents().setLocation(cw, yInputEachOrMerge);
                    MonkWindow.this.getInputMergeToAgents().setSize(w - cw, 20);
                }
            };
            JLabel bg = this.getBG();
            if (bg != null) {
                this.body.add(this.getOutputPray());
                this.body.add(this.getOutputPraySource());
                this.body.add(this.getInputEach());
                this.body.add(this.getInputMergeToAgents());
                this.body.add(this.getCurrAction());
                this.body.add(bg);
            } else {
                JLabel errorLbl = new JLabel();
                errorLbl.setHorizontalAlignment(0);
                errorLbl.setBackground(new Color(128, 0, 0));
                errorLbl.setForeground(Color.YELLOW);
                errorLbl.setText("Face image could not be found.");
                this.getContentPane().add(errorLbl);
                this.setSize(250, 250);
                this.getContentPane().setBackground(Color.RED);
                return null;
            }
        }
        return this.body;
    }

    public JLabel getBG() {
        if (this.bg == null) {
            this.bg = new JLabel();
            String r = String.valueOf(MonkWindow.class.getPackage().getName().replace('.', '/')) + "/res/monk-face.png";
            URL u = ResourceHog.getResource(r);
            if (u == null) {
                return null;
            }
            ImageIcon i = new ImageIcon(u);
            this.bg.setIcon(i);
            this.bg.setSize(i.getIconWidth(), i.getIconHeight());
            this.target = new DropTarget(this.bg, this);
        }
        return this.bg;
    }

    public JLabel getCurrAction() {
        if (this.currAction == null) {
            this.currAction = new JLabel();
            this.currAction.setHorizontalAlignment(0);
            this.currAction.setText("Awaiting files");
            this.currAction.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    MonkWindow.this.currAction.setText("Awaiting files");
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }
            });
        }
        return this.currAction;
    }

    public JRadioButton getOutputPray() {
        if (this.outputPrayChunk == null) {
            this.outputPrayChunk = new JRadioButton("PRAY Chunk", true);
            this.outputPrayChunk.setOpaque(false);
            this.outputPrayChunk.setBackground(new Color(0, 0, 0, 0));
            this.outputPrayChunk.addItemListener(this);
            this.outputFormatGroup.add(this.outputPrayChunk);
            this.outputPrayChunk.setSelected(true);
        }
        return this.outputPrayChunk;
    }

    public JRadioButton getOutputPraySource() {
        if (this.outputPraySource == null) {
            this.outputPraySource = new JRadioButton("PRAY Source", false);
            this.outputPraySource.setOpaque(false);
            this.outputPraySource.setBackground(new Color(0, 0, 0, 0));
            this.outputPraySource.addItemListener(this);
            this.outputFormatGroup.add(this.outputPraySource);
            this.outputPraySource.setSelected(false);
        }
        return this.outputPraySource;
    }

    public JRadioButton getInputEach() {
        if (this.inputEach == null) {
            this.inputEach = new JRadioButton("Individually", true);
            this.inputEach.setOpaque(false);
            this.inputEach.setBackground(new Color(0, 0, 0, 0));
            this.inputEach.addItemListener(this);
            this.inputEachOrMergeGroup.add(this.inputEach);
            this.inputEach.setSelected(true);
        }
        return this.inputEach;
    }

    public JRadioButton getInputMergeToAgents() {
        if (this.inputMergeToAgents == null) {
            this.inputMergeToAgents = new JRadioButton("Merge PRAYs", false);
            this.inputMergeToAgents.setOpaque(false);
            this.inputMergeToAgents.setBackground(new Color(0, 0, 0, 0));
            this.inputMergeToAgents.addItemListener(this);
            this.inputEachOrMergeGroup.add(this.inputMergeToAgents);
            this.inputMergeToAgents.setSelected(false);
        }
        return this.inputMergeToAgents;
    }

    public JMenuBar getMnu() {
        if (this.mnu == null) {
            this.mnu = new JMenuBar();
            if (UseQuitMenuItem) {
                this.mnu.add(this.getMnuFile());
            }
            this.mnu.add(this.getMnuEdit());
            if (UseAboutMenuItem) {
                this.mnu.add(this.getMnuHelp());
            }
        }
        return this.mnu;
    }

    public JMenu getMnuFile() {
        if (this.mnuFile == null) {
            this.mnuFile = new JMenu("File");
            if (UseQuitMenuItem) {
                this.mnuFile.add(this.getMnuFileQuit());
            }
        }
        return this.mnuFile;
    }

    public JMenuItem getMnuFileQuit() {
        if (this.mnuFileQuit == null) {
            this.mnuFileQuit = new JMenuItem("Quit");
            this.mnuFileQuit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuFileQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonkWindow.this.getApplicationCoordinator().quitClicked();
                }
            });
        }
        return this.mnuFileQuit;
    }

    public JMenu getMnuEdit() {
        if (this.mnuEdit == null) {
            this.mnuEdit = new JMenu("Edit");
            this.mnuEdit.add(this.getMnuEditMergeScripts());
        }
        return this.mnuEdit;
    }

    public JCheckBoxMenuItem getMnuEditMergeScripts() {
        if (this.mnuEditMergeScripts == null) {
            this.mnuEditMergeScripts = new JCheckBoxMenuItem("Merge scripts", true);
            this.mnuEditMergeScripts.setAccelerator(KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuEditMergeScripts.addItemListener(this);
            this.mnuEditMergeScripts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonkWindow.this.itemStateChanged(null);
                }
            });
        }
        return this.mnuEditMergeScripts;
    }

    public JMenu getMnuHelp() {
        if (this.mnuHelp == null) {
            this.mnuHelp = new JMenu("Help");
            if (UseAboutMenuItem) {
                this.mnuHelp.add(this.getMnuHelpAbout());
            }
        }
        return this.mnuHelp;
    }

    public JMenuItem getMnuHelpAbout() {
        if (this.mnuHelpAbout == null) {
            this.mnuHelpAbout = new JMenuItem("About");
            this.mnuHelpAbout.setAccelerator(KeyStroke.getKeyStroke(112, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuHelpAbout.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonkWindow.this.getApplicationCoordinator().aboutClicked();
                }
            });
        }
        return this.mnuHelpAbout;
    }

    public boolean isMergingToMultiPrayOutput() {
        if (this.getInputEach().isSelected()) {
            return false;
        }
        return this.getInputMergeToAgents().isSelected();
    }

    public Monkifier.OutputType getOutputType() {
        if (this.getOutputPray().isSelected()) {
            return Monkifier.OutputType.PrayChunk;
        }
        if (this.getOutputPraySource().isSelected()) {
            return Monkifier.OutputType.PrayTemplateSource;
        }
        return Monkifier.OutputType.PrayChunk;
    }

    @Override
    public void notify(String message) {
        System.out.println("info: " + message);
        this.setStatus(message);
    }

    @Override
    public void error(String prefix, Throwable cause) {
        this.error(String.valueOf(prefix) + " : (" + cause.getClass().getSimpleName() + ")\"" + cause.getMessage() + "\"");
        cause.printStackTrace();
    }

    @Override
    public void error(String message) {
        System.err.println("error: " + message);
        if (!GraphicsEnvironment.isHeadless()) {
            this.setStatus("Error");
            JOptionPane.showMessageDialog(null, message, "Error", 0);
        }
    }

    public void setStatus(String s) {
        this.getCurrAction().setText(s);
    }

    public MonkApplicationCoordinator getApplicationCoordinator() {
        return this.coordinator;
    }

    public void setApplicationCoordinator(MonkApplicationCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    public void process(final Collection<File> files) {
        final boolean merge = this.isMergingToMultiPrayOutput();
        new Thread(){

            @Override
            public void run() {
                if (merge) {
                    MonkWindow.this.chimp.monkifyMerging(files);
                } else {
                    MonkWindow.this.chimp.monkifySeparately(files);
                }
            }
        }.start();
    }

    public void process(final File file) {
        new Thread(){

            @Override
            public void run() {
                MonkWindow.this.chimp.monkify(file);
            }
        }.start();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            List<File> files = DropData.getFileList(dtde);
            if (files != null) {
                this.process(files);
            } else {
                dtde.rejectDrop();
                dtde.dropComplete(false);
            }
        }
        catch (IOException exc) {
            this.error("Error occurred dropping: \"" + exc.getMessage() + "\"");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateConfiguration();
    }

    public void updateConfiguration() {
        this.chimp.setDesiredOutput(this.getOutputType());
        this.chimp.setMergeScripts(this.getMnuEditMergeScripts().isSelected());
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }
}

