/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui.monk;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import rebound.annotations.semantic.meta.dependencies.DependencyDirectory;
import rebound.apps.reboundcommonsbuilding.packaging.jar.annotations.PackageAsSimpleJar;
import rebound.dataformats.json.JSONUtilities;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.UnreachableCodeException;
import rebound.jagent.lib.caos2pray.FriendlyTags;
import rebound.jagent.ui.gui.AboutDialog;
import rebound.jagent.ui.gui.monk.MonkWindow;
import rebound.jagent.ui.gui.monk.Monkifier;
import rebound.jagent.ui.gui.monk.Notifee;
import rebound.osint.modapple.eawtproxy.ApplicationEventProxy;
import rebound.osint.modapple.eawtproxy.ApplicationListenerClone;
import rebound.osint.modapple.eawtproxy.ApplicationProxy;
import rebound.util.cli.ConsoleUtilities;
import rebound.util.collections.CollectionUtilities;

@PackageAsSimpleJar(value="Monk.jar")
@DependencyDirectory(value="./res")
public class MonkApplicationCoordinator {
    public static final String ABOUT_RESOURCE = "about-monk.html";
    public static final boolean AppleJavaExtentionsPresent = ApplicationProxy.canGetApplication();
    protected MonkWindow adrian;
    protected AboutDialog aboutDialog;

    public static void main(String[] args) {
        try {
            FriendlyTags.loadConfig();
        }
        catch (FileNotFoundException exc) {
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, "Could not find resource friendliness.nice", "Error Initializing", 0);
            }
            System.err.println("Could not find resource friendliness.nice");
        }
        catch (IOException exc) {
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, "There was an error loading resource friendliness.nice: " + exc.getMessage(), "Error Initializing", 0);
            }
            System.err.println("There was an error loading resource friendliness.nice: " + exc.getMessage());
        }
        ConsoleUtilities.ParsedArgs<Map<String, Object>> parsedArgs = ConsoleUtilities.parseArgsStateless(args);
        HashMap<String, Object> options = new HashMap<String, Object>((Map)parsedArgs.options);
        boolean outputPraySource = ConsoleUtilities.optionsHasFlagRemoving(options, "s");
        boolean mergeOutput = ConsoleUtilities.optionsHasFlagRemoving(options, "m");
        if (ConsoleUtilities.optionsHasFlagRemoving(options, "h") | ConsoleUtilities.optionsHasFlagRemoving(options, "help") | !options.isEmpty()) {
            boolean error;
            boolean bl = error = !options.isEmpty();
            if (error) {
                System.out.println("Unrecognized options: " + JSONUtilities.serializeJSONEfficiently(options));
            }
            System.out.println("usage: monk [-s] [-m] targets...");
            System.exit(error ? 1 : 0);
            throw new UnreachableCodeException();
        }
        if (parsedArgs.targets.isEmpty()) {
            MonkApplicationCoordinator coordinator = new MonkApplicationCoordinator();
            if (AppleJavaExtentionsPresent) {
                coordinator.setupMacExtensions();
            }
            coordinator.initWindow();
        } else {
            Monkifier chimp = new Monkifier();
            chimp.setNotifee(new Notifee(){

                @Override
                public void notify(String message) {
                    System.out.println("info: " + message);
                }

                @Override
                public void error(String prefix, Throwable cause) {
                    this.error(String.valueOf(prefix) + " : (" + cause.getClass().getSimpleName() + ")\"" + cause.getMessage() + "\"");
                    cause.printStackTrace();
                }

                @Override
                public void error(String message) {
                    System.err.println("error: " + message);
                    if (!GraphicsEnvironment.isHeadless()) {
                        JOptionPane.showMessageDialog(null, message, "Error", 0);
                    }
                }
            });
            if (outputPraySource) {
                chimp.setDesiredOutput(Monkifier.OutputType.PrayTemplateSource);
            }
            List<File> l = CollectionUtilities.mapToList(File::new, parsedArgs.targets);
            boolean success = mergeOutput ? chimp.monkifyMerging(l) : chimp.monkifySeparately(l);
            System.exit(success ? 0 : 1);
        }
    }

    public void initWindow() {
        this.adrian = new MonkWindow();
        this.adrian.setApplicationCoordinator(this);
        this.adrian.setVisible(true);
    }

    public AboutDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            String r = String.valueOf(MonkApplicationCoordinator.class.getPackage().getName().replace('.', '/')) + "/res/" + ABOUT_RESOURCE;
            this.aboutDialog = new AboutDialog(r);
        }
        return this.aboutDialog;
    }

    public void setupMacExtensions() {
        ApplicationProxy application = ApplicationProxy.getApplication();
        if (application == null) {
            throw new ImpossibleException("com.apple.eawt.Application exists, but it also doesn't exist...  Aren't computers are supposed to make sense?!");
        }
        application.removePreferencesMenuItem();
        application.addAboutMenuItem();
        application.addApplicationListener(new ApplicationListenerClone(){

            @Override
            public void handleAbout(ApplicationEventProxy e) {
                e.setHandled(true);
                MonkApplicationCoordinator.this.aboutClicked();
            }

            @Override
            public void handleOpenFile(ApplicationEventProxy e) {
                e.setHandled(true);
                MonkApplicationCoordinator.this.load(e.getFilename());
            }

            @Override
            public void handleQuit(ApplicationEventProxy e) {
                e.setHandled(false);
                MonkApplicationCoordinator.this.quitClicked();
            }

            @Override
            public void handleReOpenApplication(ApplicationEventProxy e) {
            }

            @Override
            public void handleOpenApplication(ApplicationEventProxy e) {
            }

            @Override
            public void handlePreferences(ApplicationEventProxy e) {
            }

            @Override
            public void handlePrintFile(ApplicationEventProxy e) {
            }
        });
    }

    public void load(String filename) {
        this.load(new File(filename));
    }

    public void load(File file) {
        this.adrian.process(file);
    }

    public void aboutClicked() {
        this.getAboutDialog().display();
    }

    public void quitClicked() {
        System.exit(0);
    }
}

